package com.platform.http.executor;

import io.appform.core.hystrix.CommandFactory;

import java.util.concurrent.Future;

/**
 * @author tushar.naik
 * @version 1.0  11/11/17 - 12:10 AM
 */
public interface HttpExecutor<T> {
    String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";

    T execute() throws Exception;

    String getCommand();

    Consumer<Exception, T> getExceptionConsumer();

    default T executeTracked(Class clazz) throws Exception {
        try {
           return CommandFactory.<T>create(clazz.getSimpleName(), getCommand())
                    .executor(this::execute)
                    .execute();
        } catch (Exception e) {
            Consumer<Exception, T> exceptionConsumer = getExceptionConsumer();
            if (exceptionConsumer != null) {
                return exceptionConsumer.consume(e);
            }
            throw e;
        }
    }

    default Future<T> queueTracked(Class clazz) throws Exception {
        return CommandFactory.<T>create(clazz.getSimpleName(), getCommand())
                .executor(this::execute)
                .queue();
    }
}
