package com.platform.http.executor;

import lombok.Builder;
import lombok.Data;
import okhttp3.*;

/**
 * @author tushar.naik
 * @version 1.0  07/03/18 - 4:06 PM
 */
@Data
public class ExtractedResponse {
    private final Protocol protocol;
    private final int code;
    private final String message;
    private final Headers headers;
    private final Handshake handshake;
    private final byte[] body;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;

    @Builder
    public ExtractedResponse(Protocol protocol, int code, String message, Headers headers, Handshake handshake,
                             byte[] body, long sentRequestAtMillis, long receivedResponseAtMillis) {
        this.protocol = protocol;
        this.code = code;
        this.message = message;
        this.headers = headers;
        this.handshake = handshake;
        this.body = body;
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
    }
}
