package com.platform.http;

import java.util.Optional;

/**
 * Returns the endpoint in the config.
 */
public class StaticServiceEndpointProvider implements ServiceEndpointProvider {
    private final Endpoint endpoint;

    public StaticServiceEndpointProvider(HttpClientConfiguration clientConfiguration) {
        endpoint = Endpoint.builder()
                           .host(clientConfiguration.getHost())
                           .port(clientConfiguration.getPort())
                           .build();
    }

    @Override
    public Optional<Endpoint> endpoint() {
        return Optional.of(endpoint);
    }
}
