package com.platform.http;

import io.dropwizard.discovery.client.io.dropwizard.ranger.ServiceDiscoveryClient;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import org.apache.curator.framework.CuratorFramework;

/**
 * Created by santanu on 6/4/16.
 */
public class ServiceEndpointProviderFactory {
    private final CuratorFramework curatorFramework;

    public ServiceEndpointProviderFactory(CuratorFramework curatorFramework) {
        this.curatorFramework = curatorFramework;
    }


    public ServiceEndpointProvider provider(HttpClientConfiguration clientConfiguration, Environment environment) throws Exception {
        if(!clientConfiguration.isUsingZookeeper()) {
            return new StaticServiceEndpointProvider(clientConfiguration);
        }
        ServiceDiscoveryClient client = ServiceDiscoveryClient.fromCurator()
                                            .curator(curatorFramework)
                                            .objectMapper(environment.getObjectMapper())
                                            .namespace("http")
                                            .serviceName(clientConfiguration.getServiceName())
                                            .environment(clientConfiguration.getEnvironment())
                                            .build();
        environment.lifecycle().manage(new Managed() {
            @Override
            public void start() throws Exception {
                client.start();
            }

            @Override
            public void stop() throws Exception {
                client.stop();
            }
        });
        return new RangerEndpointProvider(client);
    }
}
