package com.platform.http;

import io.dropwizard.discovery.client.io.dropwizard.ranger.ServiceDiscoveryClient;
import lombok.val;

import java.util.Optional;

/**
 * Return endpoint from ranger
 */
public class RangerEndpointProvider implements ServiceEndpointProvider {
    private final ServiceDiscoveryClient client;

    public RangerEndpointProvider(ServiceDiscoveryClient client) {
        this.client = client;
    }

    @Override
    public Optional<Endpoint> endpoint() {
        val response = client.getNode();
        if(!response.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Endpoint.builder()
                .host(response.get().getHost())
                .port(response.get().getPort())
                .build());
    }
}
