package com.platform.http;

import com.codahale.metrics.MetricRegistry;
import com.raskasa.metrics.okhttp.InstrumentedOkHttpClients;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import okhttp3.ResponseBody;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

/**
 * OkHttpUtils
 */
public interface OkHttpUtils {
    static byte[] body(Response response) throws IOException {
        try (final ResponseBody body = response.body()) {
            return body.bytes();
        }
    }

    static String bodyString(Response response) throws IOException {
        try (final ResponseBody body = response.body()) {
            return body.string();
        }
    }

    static OkHttpClient createOkHttpClient(HttpClientConfiguration httpClientConfiguration) {
        return createOkHttpClient(null, null, httpClientConfiguration);
    }

    static OkHttpClient createOkHttpClient(String clientName, MetricRegistry registry, HttpClientConfiguration httpClientConfiguration) {
        int connections = httpClientConfiguration.getConnections();
        connections = connections == 0 ? 10 : connections;

        int idleTimeOutSeconds = httpClientConfiguration.getIdleTimeOutSeconds();
        idleTimeOutSeconds = idleTimeOutSeconds == 0 ? 30 : idleTimeOutSeconds;

        int connTimeout = httpClientConfiguration.getConnectTimeoutMs();
        connTimeout = connTimeout == 0 ? 10000 : connTimeout;

        int opTimeout = httpClientConfiguration.getOpTimeoutMs();
        opTimeout = opTimeout == 0 ? 10000 : opTimeout;

        OkHttpClient okHttpClient = new OkHttpClient.Builder().hostnameVerifier((s, sslSession) -> true)
                .connectionPool(new ConnectionPool(connections, idleTimeOutSeconds, TimeUnit.SECONDS))
                .connectTimeout(connTimeout, TimeUnit.MILLISECONDS)
                .readTimeout(opTimeout, TimeUnit.MILLISECONDS)
                .writeTimeout(opTimeout, TimeUnit.MILLISECONDS)
                .build();
        if(registry != null) {
            okHttpClient = InstrumentedOkHttpClients.create(registry, okHttpClient, clientName);
        }

        return okHttpClient;
    }
}
