package com.platform.http;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

/**
 * Configration for HTTP client
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class HttpClientConfiguration {
    private boolean usingZookeeper;
    private String host;
    private int port;
    private String serviceName;
    private String environment;

    private boolean secure;

    @Min(10)
    @Max(1024)
    private int connections = 10;

    @Max(86400)
    private int idleTimeOutSeconds = 30;

    @Max(86400000)
    private int connectTimeoutMs = 10000;

    @Max(86400000)
    private int opTimeoutMs = 10000;

    //TODO::REMOVE THIS
    @Min(0)
    private int asyncWorkers = 10000;

    //For basic auth
    private String username;
    private String password;
}
