package com.platform.http;

import lombok.*;
import okhttp3.HttpUrl;

import java.net.URI;

/**
 * A service endpoint
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
@ToString
@Builder
public class Endpoint {
    private String host;
    private int port;

    public HttpUrl url(final String path) {
        return HttpUrl.get(URI.create(String.format("http://%s:%d%s", host, port, path)));
    }

    public HttpUrl secureUrl(final String path) {
        return HttpUrl.get(URI.create(String.format("https://%s:%d%s", host, port, path)));
    }
}
