/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.primer.auth.filter;

import com.codahale.metrics.annotation.Metered;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.toastshaman.dropwizard.auth.jwt.model.JsonWebToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.dropwizard.primer.auth.AuthFilter;
import io.dropwizard.primer.auth.AuthType;
import io.dropwizard.primer.auth.annotation.AuthWhitelist;
import io.dropwizard.primer.auth.annotation.Authorize;
import io.dropwizard.primer.auth.authorizer.PrimerAnnotationAuthorizer;
import io.dropwizard.primer.auth.whitelist.AuthWhitelistValidator;
import io.dropwizard.primer.core.PrimerError;
import io.dropwizard.primer.exception.PrimerException;
import io.dropwizard.primer.model.PrimerConfigurationHolder;
import io.dropwizard.primer.util.CryptUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import javax.annotation.Priority;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
@Singleton
public class PrimerAuthAnnotationFilter
extends AuthFilter {
    private static final Logger log = LoggerFactory.getLogger(PrimerAuthAnnotationFilter.class);
    @Context
    private HttpServletRequest requestProxy;
    @Context
    private ResourceInfo resourceInfo;
    private final PrimerAnnotationAuthorizer authorizer;
    private final SecretKeySpec secretKeySpec;
    private final GCMParameterSpec ivParameterSpec;

    public PrimerAuthAnnotationFilter(PrimerConfigurationHolder configHolder, ObjectMapper objectMapper, PrimerAnnotationAuthorizer authorizer, SecretKeySpec secretKeySpec, GCMParameterSpec ivParameterSpec) {
        super(AuthType.ANNOTATION, configHolder, objectMapper);
        this.authorizer = authorizer;
        this.secretKeySpec = secretKeySpec;
        this.ivParameterSpec = ivParameterSpec;
    }

    @Metered(name="authorize")
    public void filter(ContainerRequestContext requestContext) throws IOException {
        Optional<String> token = this.getToken(requestContext);
        if (!token.isPresent()) {
            if (!this.isEnabled() || this.isWhitelisted()) {
                return;
            }
            requestContext.abortWith(Response.status((Response.Status)this.configHolder.getConfig().getAbsentTokenStatus()).entity((Object)this.objectMapper.writeValueAsBytes((Object)PrimerError.builder().errorCode("PR000").message("Bad request").build())).build());
        } else {
            try {
                String decryptedToken = CryptUtil.tokenDecrypt(token.get(), this.secretKeySpec, this.ivParameterSpec);
                JsonWebToken webToken = this.authorize(requestContext, decryptedToken, this.authType);
                this.stampHeaders(requestContext, webToken);
                if (!this.isEnabled() || this.isWhitelisted()) {
                    return;
                }
                if (this.authorizer != null) {
                    this.authorizer.authorize(webToken, requestContext, this.getAuthorizeAnnotation());
                }
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof CompletionException) {
                    this.handleException(e.getCause().getCause(), requestContext, token.get());
                } else {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof PrimerException) {
                    this.handleException(e.getCause(), requestContext, token.get());
                }
                this.handleException(e, requestContext, token.get());
            }
        }
    }

    private boolean isEnabled() {
        return this.configHolder.getConfig().isEnabled() && this.configHolder.getConfig().getAuthTypesEnabled().getOrDefault((Object)AuthType.ANNOTATION, false) != false && Objects.nonNull(this.getAuthorizeAnnotation());
    }

    private boolean isWhitelisted() {
        AuthWhitelist authWhitelist = this.resourceInfo.getResourceMethod().getAnnotation(AuthWhitelist.class);
        return Objects.nonNull(authWhitelist) && authWhitelist.type().accept(new AuthWhitelistValidator(authWhitelist, this.requestProxy)) != false;
    }

    private Authorize getAuthorizeAnnotation() {
        return this.resourceInfo.getResourceMethod().getAnnotation(Authorize.class);
    }

    public static PrimerAuthAnnotationFilterBuilder builder() {
        return new PrimerAuthAnnotationFilterBuilder();
    }

    public static class PrimerAuthAnnotationFilterBuilder {
        private PrimerConfigurationHolder configHolder;
        private ObjectMapper objectMapper;
        private PrimerAnnotationAuthorizer authorizer;
        private SecretKeySpec secretKeySpec;
        private GCMParameterSpec ivParameterSpec;

        PrimerAuthAnnotationFilterBuilder() {
        }

        public PrimerAuthAnnotationFilterBuilder configHolder(PrimerConfigurationHolder configHolder) {
            this.configHolder = configHolder;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder authorizer(PrimerAnnotationAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder secretKeySpec(SecretKeySpec secretKeySpec) {
            this.secretKeySpec = secretKeySpec;
            return this;
        }

        public PrimerAuthAnnotationFilterBuilder ivParameterSpec(GCMParameterSpec ivParameterSpec) {
            this.ivParameterSpec = ivParameterSpec;
            return this;
        }

        public PrimerAuthAnnotationFilter build() {
            return new PrimerAuthAnnotationFilter(this.configHolder, this.objectMapper, this.authorizer, this.secretKeySpec, this.ivParameterSpec);
        }

        public String toString() {
            return "PrimerAuthAnnotationFilter.PrimerAuthAnnotationFilterBuilder(configHolder=" + this.configHolder + ", objectMapper=" + this.objectMapper + ", authorizer=" + this.authorizer + ", secretKeySpec=" + this.secretKeySpec + ", ivParameterSpec=" + this.ivParameterSpec + ")";
        }
    }
}

