/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.transport.heartbeat.HeartbeatMessage;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpClient;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpRequest;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class SimpleHttpHeartbeatSender
implements HeartbeatSender {
    private static final int OK_STATUS = 200;
    private static final long DEFAULT_INTERVAL = 10000L;
    private final HeartbeatMessage heartBeat = new HeartbeatMessage();
    private final SimpleHttpClient httpClient = new SimpleHttpClient();
    private final List<InetSocketAddress> addressList;
    private int currentAddressIdx = 0;

    public SimpleHttpHeartbeatSender() {
        List<InetSocketAddress> newAddrs = this.getDefaultConsoleIps();
        RecordLog.info((String)("[SimpleHttpHeartbeatSender] Default console address list retrieved: " + newAddrs), (Object[])new Object[0]);
        this.addressList = newAddrs;
    }

    public boolean sendHeartbeat() throws Exception {
        if (TransportConfig.getRuntimePort() <= 0) {
            RecordLog.info((String)"[SimpleHttpHeartbeatSender] Runtime port not initialized, won't send heartbeat", (Object[])new Object[0]);
            return false;
        }
        InetSocketAddress addr = this.getAvailableAddress();
        if (addr == null) {
            return false;
        }
        System.out.println(String.format("Host : %s, 8719 : %s", System.getenv("HOST"), System.getenv("PORT_8719")));
        System.out.println(String.format("Address Host : %s ", addr.getHostName()));
        System.out.println(String.format("Address Port : %s ", addr.getPort()));
        SimpleHttpRequest request = new SimpleHttpRequest(addr, TransportConfig.getHeartbeatApiPath());
        request.setParams(this.heartBeat.generateCurrentMessage());
        try {
            SimpleHttpResponse response = this.httpClient.post(request);
            System.out.println(String.format("Response : %s", response.getStatusCode()));
            System.out.println(String.format("Request Host: %s, Port : %s", request.getParams().get("hostname"), request.getParams().get("port")));
            if (response.getStatusCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            RecordLog.warn((String)("[SimpleHttpHeartbeatSender] Failed to send heartbeat to " + addr), (Throwable)e);
        }
        return false;
    }

    public long intervalMs() {
        return 10000L;
    }

    private InetSocketAddress getAvailableAddress() {
        if (this.addressList == null || this.addressList.isEmpty()) {
            return null;
        }
        if (this.currentAddressIdx < 0) {
            this.currentAddressIdx = 0;
        }
        int index = this.currentAddressIdx % this.addressList.size();
        return this.addressList.get(index);
    }

    private List<InetSocketAddress> getDefaultConsoleIps() {
        ArrayList<InetSocketAddress> newAddrs = new ArrayList<InetSocketAddress>();
        try {
            String ipsStr = TransportConfig.getConsoleServer();
            if (StringUtil.isEmpty((String)ipsStr)) {
                RecordLog.warn((String)"[SimpleHttpHeartbeatSender] Dashboard server address not configured", (Object[])new Object[0]);
                return newAddrs;
            }
            for (String ipPortStr : ipsStr.split(",")) {
                if (ipPortStr.trim().length() == 0) continue;
                if (ipPortStr.startsWith("http://")) {
                    ipPortStr = ipPortStr.trim().substring(7);
                }
                String[] ipPort = ipPortStr.trim().split(":");
                int port = 80;
                if (ipPort.length > 1) {
                    port = Integer.parseInt(ipPort[1].trim());
                }
                newAddrs.add(new InetSocketAddress(ipPort[0].trim(), port));
            }
        }
        catch (Exception ex) {
            RecordLog.warn((String)("[SimpleHeartbeatSender] Parse dashboard list failed, current address list: " + newAddrs), (Throwable)ex);
            ex.printStackTrace();
        }
        return newAddrs;
    }
}

