/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.csp.sentinel.util.PidUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

@SpiOrder(value=2147483547)
public class HttpHeartbeatSender
implements HeartbeatSender {
    private final CloseableHttpClient client;
    private final int timeoutMs = 3000;
    private final RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(3000).setConnectTimeout(3000).setSocketTimeout(3000).build();
    private String consoleHost;
    private int consolePort;

    public HttpHeartbeatSender() {
        this.client = HttpClients.createDefault();
        List<Tuple2<String, Integer>> dashboardList = HttpHeartbeatSender.parseDashboardList();
        if (dashboardList == null || dashboardList.isEmpty()) {
            RecordLog.info((String)"[NettyHttpHeartbeatSender] No dashboard available", (Object[])new Object[0]);
        } else {
            this.consoleHost = (String)dashboardList.get((int)0).r1;
            this.consolePort = (Integer)dashboardList.get((int)0).r2;
            RecordLog.info((String)("[NettyHttpHeartbeatSender] Dashboard address parsed: <" + this.consoleHost + ':' + this.consolePort + ">"), (Object[])new Object[0]);
        }
    }

    protected static List<Tuple2<String, Integer>> parseDashboardList() {
        ArrayList<Tuple2<String, Integer>> list = new ArrayList<Tuple2<String, Integer>>();
        try {
            String ipsStr = TransportConfig.getConsoleServer();
            if (StringUtil.isBlank((String)ipsStr)) {
                RecordLog.warn((String)"[NettyHttpHeartbeatSender] Dashboard server address is not configured", (Object[])new Object[0]);
                return list;
            }
            for (String ipPortStr : ipsStr.split(",")) {
                if (ipPortStr.trim().length() == 0) continue;
                if ((ipPortStr = ipPortStr.trim()).startsWith("http://")) {
                    ipPortStr = ipPortStr.substring(7);
                }
                if (ipPortStr.startsWith(":")) continue;
                String[] ipPort = ipPortStr.trim().split(":");
                int port = 80;
                if (ipPort.length > 1) {
                    port = Integer.parseInt(ipPort[1].trim());
                }
                list.add((Tuple2<String, Integer>)Tuple2.of((Object)ipPort[0].trim(), (Object)port));
            }
        }
        catch (Exception ex) {
            RecordLog.warn((String)("[NettyHttpHeartbeatSender] Parse dashboard list failed, current address list: " + list), (Throwable)ex);
            ex.printStackTrace();
        }
        return list;
    }

    public boolean sendHeartbeat() throws Exception {
        if (StringUtil.isEmpty((String)this.consoleHost)) {
            return false;
        }
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme("http").setHost(this.consoleHost).setPort(this.consolePort).setPath(TransportConfig.getHeartbeatApiPath()).setParameter("app", AppNameUtil.getAppName()).setParameter("app_type", String.valueOf(SentinelConfig.getAppType())).setParameter("v", Constants.SENTINEL_VERSION).setParameter("version", String.valueOf(System.currentTimeMillis())).setParameter("hostname", HostNameUtil.getHostName()).setParameter("ip", TransportConfig.getHeartbeatClientIp()).setParameter("port", TransportConfig.getPort()).setParameter("pid", String.valueOf(PidUtil.getPid()));
        HttpGet request = new HttpGet(uriBuilder.build());
        request.setConfig(this.requestConfig);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
        response.close();
        return true;
    }

    public long intervalMs() {
        return 5000L;
    }
}

