/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command.netty;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.CommandCenterLog;
import com.alibaba.csp.sentinel.transport.command.codec.CodecRegistry;
import com.alibaba.csp.sentinel.transport.command.codec.Encoder;
import com.alibaba.csp.sentinel.transport.command.netty.HttpServer;
import com.alibaba.csp.sentinel.transport.util.HttpCommandUtils;
import com.alibaba.csp.sentinel.util.StringUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class HttpServerHandler
extends SimpleChannelInboundHandler<Object> {
    private final CodecRegistry codecRegistry = new CodecRegistry();
    private static final String SERVER_ERROR_MESSAGE = "Command server error";

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpRequest httpRequest = (FullHttpRequest)msg;
        try {
            CommandRequest request = this.parseRequest(httpRequest);
            if (StringUtil.isBlank((String)HttpCommandUtils.getTarget((CommandRequest)request))) {
                this.writeErrorResponse(HttpResponseStatus.BAD_REQUEST.code(), "Invalid command", ctx);
                return;
            }
            this.handleRequest(request, ctx, HttpUtil.isKeepAlive((HttpMessage)httpRequest));
        }
        catch (Exception ex) {
            this.writeErrorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), SERVER_ERROR_MESSAGE, ctx);
            CommandCenterLog.warn((String)"Internal error", (Throwable)ex);
        }
    }

    private void handleRequest(CommandRequest request, ChannelHandlerContext ctx, boolean keepAlive) throws Exception {
        String commandName = HttpCommandUtils.getTarget((CommandRequest)request);
        CommandHandler commandHandler = this.getHandler(commandName);
        if (commandHandler != null) {
            CommandResponse response = commandHandler.handle(request);
            this.writeResponse(response, ctx, keepAlive);
        } else {
            this.writeErrorResponse(HttpResponseStatus.BAD_REQUEST.code(), String.format("Unknown command \"%s\"", commandName), ctx);
        }
    }

    private Encoder<?> pickEncoder(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Bad class metadata");
        }
        for (Encoder<?> encoder : this.codecRegistry.getEncoderList()) {
            if (!encoder.canEncode(clazz)) continue;
            return encoder;
        }
        return null;
    }

    private void writeErrorResponse(int statusCode, String message, ChannelHandlerContext ctx) {
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)statusCode), Unpooled.copiedBuffer((CharSequence)message, (Charset)Charset.forName(SentinelConfig.charset())));
        httpResponse.headers().set("Content-Type", (Object)("text/plain; charset=" + SentinelConfig.charset()));
        ctx.write((Object)httpResponse);
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private void writeResponse(CommandResponse response, ChannelHandlerContext ctx, boolean keepAlive) throws Exception {
        byte[] body;
        if (response.isSuccess()) {
            if (response.getResult() == null) {
                body = new byte[]{};
            } else {
                Encoder<?> encoder = this.pickEncoder(response.getResult().getClass());
                if (encoder == null) {
                    this.writeErrorResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), SERVER_ERROR_MESSAGE, ctx);
                    CommandCenterLog.warn((String)"Error when encoding object", (Throwable)new IllegalStateException("No compatible encoder"));
                    return;
                }
                body = encoder.encode(response.getResult());
            }
        } else {
            body = response.getException().getMessage().getBytes(SentinelConfig.charset());
        }
        HttpResponseStatus status = response.isSuccess() ? HttpResponseStatus.OK : HttpResponseStatus.BAD_REQUEST;
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((byte[])body));
        httpResponse.headers().set("Content-Type", (Object)("text/plain; charset=" + SentinelConfig.charset()));
        httpResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, httpResponse.content().readableBytes());
        httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.write((Object)httpResponse);
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandRequest parseRequest(FullHttpRequest request) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.uri());
        CommandRequest serverRequest = new CommandRequest();
        Map paramMap = queryStringDecoder.parameters();
        if (!paramMap.isEmpty()) {
            for (Map.Entry p : paramMap.entrySet()) {
                if (((List)p.getValue()).isEmpty()) continue;
                serverRequest.addParam((String)p.getKey(), (String)((List)p.getValue()).get(0));
            }
        }
        if (request.method().equals((Object)HttpMethod.POST)) {
            HttpPostRequestDecoder postRequestDecoder = null;
            try {
                postRequestDecoder = new HttpPostRequestDecoder((HttpRequest)request);
                for (InterfaceHttpData data : postRequestDecoder.getBodyHttpDatas()) {
                    data.retain();
                    if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute || !(data instanceof HttpData)) continue;
                    HttpData httpData = (HttpData)data;
                    try {
                        String name = httpData.getName();
                        String value = httpData.getString();
                        serverRequest.addParam(name, value);
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (postRequestDecoder != null) {
                    postRequestDecoder.destroy();
                }
            }
        }
        String target = this.parseTarget(queryStringDecoder.rawPath());
        serverRequest.addMetadata("command-target", target);
        if (request.content().readableBytes() <= 0) {
            serverRequest.setBody(null);
        } else {
            byte[] body = new byte[request.content().readableBytes()];
            request.content().getBytes(0, body);
            serverRequest.setBody(body);
        }
        return serverRequest;
    }

    private String parseTarget(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            return "";
        }
        int start = uri.indexOf(47);
        if (start != -1) {
            return uri.substring(start + 1);
        }
        return uri;
    }

    private CommandHandler getHandler(String commandName) {
        if (StringUtil.isEmpty((String)commandName)) {
            return null;
        }
        return HttpServer.handlerMap.get(commandName);
    }

    private void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }
}

