/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.config;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.csp.sentinel.util.StringUtil;

public class TransportConfig {
    public static final String CONSOLE_SERVER = "csp.sentinel.dashboard.server";
    public static final String SERVER_PORT = "csp.sentinel.api.port";
    public static final String HEARTBEAT_INTERVAL_MS = "csp.sentinel.heartbeat.interval.ms";
    public static final String HEARTBEAT_CLIENT_IP = "csp.sentinel.heartbeat.client.ip";
    public static final String HEARTBEAT_API_PATH = "csp.sentinel.heartbeat.api.path";
    public static final String HEARTBEAT_DEFAULT_PATH = "/registry/machine";
    private static int runtimePort = -1;

    public static Long getHeartbeatIntervalMs() {
        String interval = SentinelConfig.getConfig((String)HEARTBEAT_INTERVAL_MS);
        try {
            return interval == null ? null : Long.valueOf(Long.parseLong(interval));
        }
        catch (Exception ex) {
            RecordLog.warn((String)("[TransportConfig] Failed to parse heartbeat interval: " + interval), (Object[])new Object[0]);
            return null;
        }
    }

    public static String getConsoleServer() {
        return SentinelConfig.getConfig((String)CONSOLE_SERVER);
    }

    public static int getRuntimePort() {
        return runtimePort;
    }

    public static String getPort() {
        if (runtimePort > 0) {
            return String.valueOf(runtimePort);
        }
        return SentinelConfig.getConfig((String)SERVER_PORT);
    }

    public static void setRuntimePort(int port) {
        runtimePort = port;
    }

    public static String getHeartbeatClientIp() {
        String ip = SentinelConfig.getConfig((String)HEARTBEAT_CLIENT_IP);
        if (StringUtil.isBlank((String)ip)) {
            ip = HostNameUtil.getIp();
        }
        return ip;
    }

    public static String getHeartbeatApiPath() {
        String apiPath = SentinelConfig.getConfig((String)HEARTBEAT_API_PATH);
        if (StringUtil.isBlank((String)apiPath)) {
            return HEARTBEAT_DEFAULT_PATH;
        }
        if (!apiPath.startsWith("/")) {
            apiPath = "/" + apiPath;
        }
        return apiPath;
    }
}

