/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.vo;

import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import java.util.UUID;

public class NodeVo {
    private String id;
    private String parentId;
    private String resource;
    private Integer threadNum;
    private Long passQps;
    private Long blockQps;
    private Long totalQps;
    private Long averageRt;
    private Long successQps;
    private Long exceptionQps;
    private Long oneMinutePass;
    private Long oneMinuteBlock;
    private Long oneMinuteException;
    private Long oneMinuteTotal;
    private Long timestamp;

    public static NodeVo fromDefaultNode(DefaultNode node, String parentId) {
        if (node == null) {
            return null;
        }
        NodeVo vo = new NodeVo();
        vo.id = UUID.randomUUID().toString();
        vo.parentId = parentId;
        vo.resource = node.getId().getShowName();
        vo.threadNum = node.curThreadNum();
        vo.passQps = (long)node.passQps();
        vo.blockQps = (long)node.blockQps();
        vo.totalQps = (long)node.totalQps();
        vo.averageRt = (long)node.avgRt();
        vo.successQps = (long)node.successQps();
        vo.exceptionQps = (long)node.exceptionQps();
        vo.oneMinuteException = node.totalException();
        vo.oneMinutePass = node.totalRequest() - node.blockRequest();
        vo.oneMinuteBlock = node.blockRequest();
        vo.oneMinuteTotal = node.totalRequest();
        vo.timestamp = System.currentTimeMillis();
        return vo;
    }

    public static NodeVo fromClusterNode(ResourceWrapper name, ClusterNode node) {
        return NodeVo.fromClusterNode(name.getShowName(), node);
    }

    public static NodeVo fromClusterNode(String name, ClusterNode node) {
        if (node == null) {
            return null;
        }
        NodeVo vo = new NodeVo();
        vo.resource = name;
        vo.threadNum = node.curThreadNum();
        vo.passQps = (long)node.passQps();
        vo.blockQps = (long)node.blockQps();
        vo.totalQps = (long)node.totalQps();
        vo.averageRt = (long)node.avgRt();
        vo.successQps = (long)node.successQps();
        vo.exceptionQps = (long)node.exceptionQps();
        vo.oneMinuteException = node.totalException();
        vo.oneMinutePass = node.totalRequest() - node.blockRequest();
        vo.oneMinuteBlock = node.blockRequest();
        vo.oneMinuteTotal = node.totalRequest();
        vo.timestamp = System.currentTimeMillis();
        return vo;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Integer getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(Integer threadNum) {
        this.threadNum = threadNum;
    }

    public Long getPassQps() {
        return this.passQps;
    }

    public void setPassQps(Long passQps) {
        this.passQps = passQps;
    }

    public Long getBlockQps() {
        return this.blockQps;
    }

    public void setBlockQps(Long blockQps) {
        this.blockQps = blockQps;
    }

    public Long getTotalQps() {
        return this.totalQps;
    }

    public void setTotalQps(Long totalQps) {
        this.totalQps = totalQps;
    }

    public Long getAverageRt() {
        return this.averageRt;
    }

    public void setAverageRt(Long averageRt) {
        this.averageRt = averageRt;
    }

    public Long getSuccessQps() {
        return this.successQps;
    }

    public void setSuccessQps(Long successQps) {
        this.successQps = successQps;
    }

    public Long getExceptionQps() {
        return this.exceptionQps;
    }

    public void setExceptionQps(Long exceptionQps) {
        this.exceptionQps = exceptionQps;
    }

    public Long getOneMinuteException() {
        return this.oneMinuteException;
    }

    public void setOneMinuteException(Long oneMinuteException) {
        this.oneMinuteException = oneMinuteException;
    }

    public Long getOneMinutePass() {
        return this.oneMinutePass;
    }

    public void setOneMinutePass(Long oneMinutePass) {
        this.oneMinutePass = oneMinutePass;
    }

    public Long getOneMinuteBlock() {
        return this.oneMinuteBlock;
    }

    public void setOneMinuteBlock(Long oneMinuteBlock) {
        this.oneMinuteBlock = oneMinuteBlock;
    }

    public Long getOneMinuteTotal() {
        return this.oneMinuteTotal;
    }

    public void setOneMinuteTotal(Long oneMinuteTotal) {
        this.oneMinuteTotal = oneMinuteTotal;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }
}

