/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.init;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.heartbeat.HeartbeatSenderProvider;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@InitOrder(value=-1)
public class HeartbeatSenderInitFunc
implements InitFunc {
    private ScheduledExecutorService pool = null;

    private void initSchedulerIfNeeded() {
        if (this.pool == null) {
            this.pool = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new NamedThreadFactory("sentinel-heartbeat-send-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
    }

    public void init() {
        System.out.println(String.format("Host : %s", "${HOST}"));
        System.out.println(String.format("Host : %s", "${PORT_8080}"));
        System.out.println(String.format("Host : %s", "${PORT_5050}"));
        System.out.println(String.format("Host : %s", "${PORT_8719}"));
        HeartbeatSender sender = HeartbeatSenderProvider.getHeartbeatSender();
        if (sender == null) {
            RecordLog.warn((String)"[HeartbeatSenderInitFunc] WARN: No HeartbeatSender loaded", (Object[])new Object[0]);
            return;
        }
        this.initSchedulerIfNeeded();
        long interval = this.retrieveInterval(sender);
        this.setIntervalIfNotExists(interval);
        this.scheduleHeartbeatTask(sender, interval);
    }

    private boolean isValidHeartbeatInterval(Long interval) {
        return interval != null && interval > 0L;
    }

    private void setIntervalIfNotExists(long interval) {
        SentinelConfig.setConfig((String)"csp.sentinel.heartbeat.interval.ms", (String)String.valueOf(interval));
    }

    long retrieveInterval(HeartbeatSender sender) {
        Long intervalInConfig = TransportConfig.getHeartbeatIntervalMs();
        if (this.isValidHeartbeatInterval(intervalInConfig)) {
            RecordLog.info((String)("[HeartbeatSenderInitFunc] Using heartbeat interval in Sentinel config property: " + intervalInConfig), (Object[])new Object[0]);
            return intervalInConfig;
        }
        long senderInterval = sender.intervalMs();
        RecordLog.info((String)("[HeartbeatSenderInit] Heartbeat interval not configured in config property or invalid, using sender default: " + senderInterval), (Object[])new Object[0]);
        return senderInterval;
    }

    private void scheduleHeartbeatTask(final HeartbeatSender sender, long interval) {
        this.pool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println(String.format("Host : %s", "${HOST}"));
                    System.out.println(String.format("Host : %s", "${PORT_8080}"));
                    System.out.println(String.format("Host : %s", "${PORT_5050}"));
                    System.out.println(String.format("Host : %s", "${PORT_8719}"));
                    sender.sendHeartbeat();
                }
                catch (Throwable e) {
                    RecordLog.warn((String)"[HeartbeatSender] Send heartbeat error", (Throwable)e);
                }
            }
        }, 5000L, interval, TimeUnit.MILLISECONDS);
        RecordLog.info((String)("[HeartbeatSenderInit] HeartbeatSender started: " + sender.getClass().getCanonicalName()), (Object[])new Object[0]);
    }
}

