/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.grpc;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class SentinelGrpcClientInterceptor
implements ClientInterceptor {
    private static final Status FLOW_CONTROL_BLOCK = Status.UNAVAILABLE.withDescription("Flow control limit exceeded (client side)");

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        String fullMethodName = methodDescriptor.getFullMethodName();
        AsyncEntry entry = null;
        try {
            entry = SphU.asyncEntry((String)fullMethodName, (EntryType)EntryType.OUT);
            final AtomicReference<AsyncEntry> atomicReferenceEntry = new AtomicReference<AsyncEntry>(entry);
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            Entry entry = (Entry)atomicReferenceEntry.get();
                            if (entry != null) {
                                if (!status.isOk()) {
                                    Tracer.traceEntry((Throwable)status.asRuntimeException(), (Entry)entry);
                                }
                                entry.exit();
                                atomicReferenceEntry.set(null);
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }

                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    Entry entry = (Entry)atomicReferenceEntry.get();
                    if (entry != null) {
                        Tracer.traceEntry((Throwable)cause, (Entry)entry);
                        entry.exit();
                        atomicReferenceEntry.set(null);
                    }
                    super.cancel(message, cause);
                }
            };
        }
        catch (BlockException e) {
            return new ClientCall<ReqT, RespT>(){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    responseListener.onClose(FLOW_CONTROL_BLOCK, new Metadata());
                }

                public void request(int numMessages) {
                }

                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                }

                public void halfClose() {
                }

                public void sendMessage(ReqT message) {
                }
            };
        }
        catch (RuntimeException e) {
            if (entry != null) {
                Tracer.traceEntry((Throwable)e, (Entry)entry);
                entry.exit();
            }
            throw e;
        }
    }
}

