/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo.config;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.util.StringUtil;

public final class DubboConfig {
    public static final String DUBBO_USE_PREFIX = "csp.sentinel.dubbo.resource.use.prefix";
    private static final String TRUE_STR = "true";
    public static final String DUBBO_PROVIDER_PREFIX = "csp.sentinel.dubbo.resource.provider.prefix";
    public static final String DUBBO_CONSUMER_PREFIX = "csp.sentinel.dubbo.resource.consumer.prefix";
    private static final String DEFAULT_DUBBO_PROVIDER_PREFIX = "dubbo:provider:";
    private static final String DEFAULT_DUBBO_CONSUMER_PREFIX = "dubbo:consumer:";

    public static boolean isUsePrefix() {
        return TRUE_STR.equalsIgnoreCase(SentinelConfig.getConfig((String)DUBBO_USE_PREFIX));
    }

    public static String getDubboProviderPrefix() {
        if (DubboConfig.isUsePrefix()) {
            String config = SentinelConfig.getConfig((String)DUBBO_PROVIDER_PREFIX);
            return StringUtil.isNotBlank((String)config) ? config : DEFAULT_DUBBO_PROVIDER_PREFIX;
        }
        return null;
    }

    public static String getDubboConsumerPrefix() {
        if (DubboConfig.isUsePrefix()) {
            String config = SentinelConfig.getConfig((String)DUBBO_CONSUMER_PREFIX);
            return StringUtil.isNotBlank((String)config) ? config : DEFAULT_DUBBO_CONSUMER_PREFIX;
        }
        return null;
    }
}

