/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.redis.config;

import com.alibaba.csp.sentinel.datasource.redis.config.RedisHostAndPort;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RedisConnectionConfig {
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_REDIS_PORT = 6379;
    public static final long DEFAULT_TIMEOUT_MILLISECONDS = 60000L;
    private String host;
    private String redisSentinelMasterId;
    private int port;
    private int database;
    private String clientName;
    private char[] password;
    private long timeout = 60000L;
    private final List<RedisConnectionConfig> redisSentinels = new ArrayList<RedisConnectionConfig>();

    public RedisConnectionConfig() {
    }

    public RedisConnectionConfig(String host, int port, long timeout) {
        AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
        AssertUtil.notNull((Object)timeout, (String)"Timeout duration must not be null");
        AssertUtil.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout duration must be greater or equal to zero");
        this.setHost(host);
        this.setPort(port);
        this.setTimeout(timeout);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getRedisSentinelMasterId() {
        return this.redisSentinelMasterId;
    }

    public void setRedisSentinelMasterId(String redisSentinelMasterId) {
        this.redisSentinelMasterId = redisSentinelMasterId;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        AssertUtil.notNull((Object)password, (String)"Password must not be null");
        this.password = password.toCharArray();
    }

    public void setPassword(char[] password) {
        AssertUtil.notNull((Object)password, (String)"Password must not be null");
        this.password = Arrays.copyOf(password, password.length);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        AssertUtil.notNull((Object)timeout, (String)"Timeout must not be null");
        AssertUtil.isTrue((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout must be greater or equal 0");
        this.timeout = timeout;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        AssertUtil.isTrue((database >= 0 ? 1 : 0) != 0, (String)("Invalid database number: " + database));
        this.database = database;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public List<RedisConnectionConfig> getRedisSentinels() {
        return this.redisSentinels;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        if (this.host != null) {
            sb.append("host='").append(this.host).append('\'');
            sb.append(", port=").append(this.port);
        }
        if (this.redisSentinelMasterId != null) {
            sb.append("redisSentinels=").append(this.getRedisSentinels());
            sb.append(", redisSentinelMasterId=").append(this.redisSentinelMasterId);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisConnectionConfig)) {
            return false;
        }
        RedisConnectionConfig redisURI = (RedisConnectionConfig)o;
        if (this.port != redisURI.port) {
            return false;
        }
        if (this.database != redisURI.database) {
            return false;
        }
        if (this.host != null ? !this.host.equals(redisURI.host) : redisURI.host != null) {
            return false;
        }
        if (this.redisSentinelMasterId != null ? !this.redisSentinelMasterId.equals(redisURI.redisSentinelMasterId) : redisURI.redisSentinelMasterId != null) {
            return false;
        }
        return !(this.redisSentinels == null ? redisURI.redisSentinels != null : !this.redisSentinels.equals(redisURI.redisSentinels));
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.redisSentinelMasterId != null ? this.redisSentinelMasterId.hashCode() : 0);
        result = 31 * result + this.port;
        result = 31 * result + this.database;
        result = 31 * result + (this.redisSentinels != null ? this.redisSentinels.hashCode() : 0);
        return result;
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static class Builder {
        private String host;
        private String redisSentinelMasterId;
        private int port;
        private int database;
        private String clientName;
        private char[] password;
        private long timeout = 60000L;
        private final List<RedisHostAndPort> redisSentinels = new ArrayList<RedisHostAndPort>();

        private Builder() {
        }

        public static Builder redis(String host) {
            return Builder.redis(host, 6379);
        }

        public static Builder redis(String host, int port) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            Builder builder = RedisConnectionConfig.builder();
            return builder.withHost(host).withPort(port);
        }

        public static Builder redisSentinel(String host) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            Builder builder = RedisConnectionConfig.builder();
            return builder.withRedisSentinel(host);
        }

        public static Builder redisSentinel(String host, int port) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            Builder builder = RedisConnectionConfig.builder();
            return builder.withRedisSentinel(host, port);
        }

        public static Builder redisSentinel(String host, String masterId) {
            return Builder.redisSentinel(host, 26379, masterId);
        }

        public static Builder redisSentinel(String host, int port, String masterId) {
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            Builder builder = RedisConnectionConfig.builder();
            return builder.withSentinelMasterId(masterId).withRedisSentinel(host, port);
        }

        public Builder withRedisSentinel(String host) {
            return this.withRedisSentinel(host, 26379);
        }

        public Builder withRedisSentinel(String host, int port) {
            AssertUtil.assertState((this.host == null ? 1 : 0) != 0, (String)"Cannot use with Redis mode.");
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            this.redisSentinels.add(RedisHostAndPort.of(host, port));
            return this;
        }

        public Builder withHost(String host) {
            AssertUtil.assertState((boolean)this.redisSentinels.isEmpty(), (String)"Sentinels are non-empty. Cannot use in Sentinel mode.");
            AssertUtil.notEmpty((String)host, (String)"Host must not be empty");
            this.host = host;
            return this;
        }

        public Builder withPort(int port) {
            AssertUtil.assertState((this.host != null ? 1 : 0) != 0, (String)"Host is null. Cannot use in Sentinel mode.");
            AssertUtil.isTrue((boolean)RedisConnectionConfig.isValidPort(port), (String)String.format("Port out of range: %s", port));
            this.port = port;
            return this;
        }

        public Builder withDatabase(int database) {
            AssertUtil.isTrue((database >= 0 ? 1 : 0) != 0, (String)("Invalid database number: " + database));
            this.database = database;
            return this;
        }

        public Builder withClientName(String clientName) {
            AssertUtil.notNull((Object)clientName, (String)"Client name must not be null");
            this.clientName = clientName;
            return this;
        }

        public Builder withPassword(String password) {
            AssertUtil.notNull((Object)password, (String)"Password must not be null");
            return this.withPassword(password.toCharArray());
        }

        public Builder withPassword(char[] password) {
            AssertUtil.notNull((Object)password, (String)"Password must not be null");
            this.password = Arrays.copyOf(password, password.length);
            return this;
        }

        public Builder withTimeout(long timeout) {
            AssertUtil.notNull((Object)timeout, (String)"Timeout must not be null");
            AssertUtil.notNull((Object)(timeout >= 0L ? 1 : 0), (String)"Timeout must be greater or equal 0");
            this.timeout = timeout;
            return this;
        }

        public Builder withSentinelMasterId(String sentinelMasterId) {
            AssertUtil.notEmpty((String)sentinelMasterId, (String)"Sentinel master id must not empty");
            this.redisSentinelMasterId = sentinelMasterId;
            return this;
        }

        public RedisConnectionConfig build() {
            if (this.redisSentinels.isEmpty() && StringUtil.isEmpty((String)this.host)) {
                throw new IllegalStateException("Cannot build a RedisConnectionConfig. One of the following must be provided Host, Socket or Sentinel");
            }
            RedisConnectionConfig redisURI = new RedisConnectionConfig();
            redisURI.setHost(this.host);
            redisURI.setPort(this.port);
            if (this.password != null) {
                redisURI.setPassword(this.password);
            }
            redisURI.setDatabase(this.database);
            redisURI.setClientName(this.clientName);
            redisURI.setRedisSentinelMasterId(this.redisSentinelMasterId);
            for (RedisHostAndPort sentinel : this.redisSentinels) {
                redisURI.getRedisSentinels().add(new RedisConnectionConfig(sentinel.getHost(), sentinel.getPort(), this.timeout));
            }
            redisURI.setTimeout(this.timeout);
            return redisURI;
        }
    }
}

