/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.etcd;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.etcd.EtcdConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.watch.WatchEvent;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class EtcdDataSource<T>
extends AbstractDataSource<String, T> {
    private final Client client;
    private Watch.Watcher watcher;
    private final String key;
    private Charset charset = Charset.forName(EtcdConfig.getCharset());

    public EtcdDataSource(String key, Converter<String, T> parser) {
        super(parser);
        this.client = !EtcdConfig.isAuthEnable() ? Client.builder().endpoints(EtcdConfig.getEndPoints().split(",")).build() : Client.builder().endpoints(EtcdConfig.getEndPoints().split(",")).user(ByteSequence.from((String)EtcdConfig.getUser(), (Charset)this.charset)).password(ByteSequence.from((String)EtcdConfig.getPassword(), (Charset)this.charset)).authority(EtcdConfig.getAuthority()).build();
        this.key = key;
        this.loadInitialConfig();
        this.initWatcher();
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[EtcdDataSource] Initial configuration is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[EtcdDataSource] Error when loading initial configuration", (Throwable)ex);
        }
    }

    private void initWatcher() {
        this.watcher = this.client.getWatchClient().watch(ByteSequence.from((String)this.key, (Charset)this.charset), watchResponse -> {
            for (WatchEvent watchEvent : watchResponse.getEvents()) {
                WatchEvent.EventType eventType = watchEvent.getEventType();
                if (eventType == WatchEvent.EventType.PUT) {
                    try {
                        Object newValue = this.loadConfig();
                        this.getProperty().updateValue(newValue);
                    }
                    catch (Exception e) {
                        RecordLog.warn((String)"[EtcdDataSource] Failed to update config", (Throwable)e);
                    }
                    continue;
                }
                if (eventType != WatchEvent.EventType.DELETE) continue;
                RecordLog.info((String)"[EtcdDataSource] Cleaning config for key <{0}>", (Object[])new Object[]{this.key});
                this.getProperty().updateValue(null);
            }
        });
    }

    public String readSource() throws Exception {
        CompletableFuture responseFuture = this.client.getKVClient().get(ByteSequence.from((String)this.key, (Charset)this.charset));
        List kvs = ((GetResponse)responseFuture.get()).getKvs();
        return kvs.size() == 0 ? null : ((KeyValue)kvs.get(0)).getValue().toString(this.charset);
    }

    public void close() {
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (Exception ex) {
                RecordLog.info((String)"[EtcdDataSource] Failed to close watcher", (Throwable)ex);
            }
        }
        if (this.client != null) {
            this.client.close();
        }
    }
}

