/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.consul;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ConsulDataSource<T>
extends AbstractDataSource<String, T> {
    private static final int DEFAULT_PORT = 8500;
    private final String address;
    private final String ruleKey;
    private final int watchTimeout;
    private volatile long lastIndex;
    private final ConsulClient client;
    private final ConsulKVWatcher watcher = new ConsulKVWatcher();
    private final ExecutorService watcherService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("sentinel-consul-ds-watcher", true));

    public ConsulDataSource(String host, String ruleKey, int watchTimeoutInSecond, Converter<String, T> parser) {
        this(host, 8500, ruleKey, watchTimeoutInSecond, parser);
    }

    public ConsulDataSource(String host, int port, String ruleKey, int watchTimeout, Converter<String, T> parser) {
        super(parser);
        AssertUtil.notNull((Object)host, (String)"Consul host can not be null");
        AssertUtil.notEmpty((String)ruleKey, (String)"Consul ruleKey can not be empty");
        AssertUtil.isTrue((watchTimeout >= 0 ? 1 : 0) != 0, (String)"watchTimeout should not be negative");
        this.client = new ConsulClient(host, port);
        this.address = host + ":" + port;
        this.ruleKey = ruleKey;
        this.watchTimeout = watchTimeout;
        this.loadInitialConfig();
        this.startKVWatcher();
    }

    private void startKVWatcher() {
        this.watcherService.submit(this.watcher);
    }

    private void loadInitialConfig() {
        try {
            Object newValue = this.loadConfig();
            if (newValue == null) {
                RecordLog.warn((String)"[ConsulDataSource] WARN: initial config is null, you may have to check your data source", (Object[])new Object[0]);
            }
            this.getProperty().updateValue(newValue);
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[ConsulDataSource] Error when loading initial config", (Throwable)ex);
        }
    }

    public String readSource() throws Exception {
        if (this.client == null) {
            throw new IllegalStateException("Consul has not been initialized or error occurred");
        }
        Response<GetValue> response = this.getValueImmediately(this.ruleKey);
        if (response != null) {
            GetValue value = (GetValue)response.getValue();
            this.lastIndex = response.getConsulIndex();
            return value != null ? value.getDecodedValue() : null;
        }
        return null;
    }

    public void close() throws Exception {
        this.watcher.stop();
        this.watcherService.shutdown();
    }

    private Response<GetValue> getValueImmediately(String key) {
        return this.getValue(key, -1L, -1L);
    }

    private Response<GetValue> getValue(String key, long index, long waitTime) {
        try {
            return this.client.getKVValue(key, new QueryParams(waitTime, index));
        }
        catch (Throwable t) {
            RecordLog.warn((String)("[ConsulDataSource] Failed to get value for key: " + key), (Throwable)t);
            return null;
        }
    }

    private class ConsulKVWatcher
    implements Runnable {
        private volatile boolean running = true;

        private ConsulKVWatcher() {
        }

        @Override
        public void run() {
            while (this.running) {
                Response response = ConsulDataSource.this.getValue(ConsulDataSource.this.ruleKey, ConsulDataSource.this.lastIndex, ConsulDataSource.this.watchTimeout);
                if (response == null) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(ConsulDataSource.this.watchTimeout * 1000);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                GetValue getValue = (GetValue)response.getValue();
                Long currentIndex = response.getConsulIndex();
                if (currentIndex == null || currentIndex <= ConsulDataSource.this.lastIndex) continue;
                ConsulDataSource.this.lastIndex = currentIndex;
                if (getValue == null) continue;
                String newValue = getValue.getDecodedValue();
                try {
                    ConsulDataSource.this.getProperty().updateValue(ConsulDataSource.this.parser.convert((Object)newValue));
                    RecordLog.info((String)"[ConsulDataSource] New property value received for ({0}, {1}): {2}", (Object[])new Object[]{ConsulDataSource.this.address, ConsulDataSource.this.ruleKey, newValue});
                }
                catch (Exception ex) {
                    RecordLog.warn((String)"[ConsulDataSource] Failed to update value for ({0}, {1}), raw value: {2}", (Object[])new Object[]{ConsulDataSource.this.address, ConsulDataSource.this.ruleKey, newValue});
                }
            }
        }

        private void stop() {
            this.running = false;
        }
    }
}

