/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule;

import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule.EnvoyRlsRule;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule.EnvoySentinelRuleConverter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public final class EnvoyRlsRuleManager {
    private static final ConcurrentMap<String, EnvoyRlsRule> RULE_MAP = new ConcurrentHashMap<String, EnvoyRlsRule>();
    private static final PropertyListener<List<EnvoyRlsRule>> PROPERTY_LISTENER = new EnvoyRlsRulePropertyListener();
    private static SentinelProperty<List<EnvoyRlsRule>> currentProperty = new DynamicSentinelProperty();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<EnvoyRlsRule>> property) {
        AssertUtil.notNull(property, (String)"property cannot be null");
        PropertyListener<List<EnvoyRlsRule>> propertyListener = PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info((String)"[EnvoyRlsRuleManager] Registering new property to Envoy rate limit service rule manager", (Object[])new Object[0]);
            currentProperty.removeListener(PROPERTY_LISTENER);
            property.addListener(PROPERTY_LISTENER);
            currentProperty = property;
        }
    }

    public static boolean loadRules(List<EnvoyRlsRule> rules) {
        return currentProperty.updateValue(rules);
    }

    public static List<EnvoyRlsRule> getRules() {
        return new ArrayList<EnvoyRlsRule>(RULE_MAP.values());
    }

    public static boolean isValidRule(EnvoyRlsRule rule) {
        if (rule == null || StringUtil.isBlank((String)rule.getDomain())) {
            return false;
        }
        List<EnvoyRlsRule.ResourceDescriptor> descriptors = rule.getDescriptors();
        if (descriptors == null || descriptors.isEmpty()) {
            return false;
        }
        for (EnvoyRlsRule.ResourceDescriptor descriptor : descriptors) {
            if (descriptor == null || descriptor.getCount() == null || descriptor.getCount() < 0.0) {
                return false;
            }
            Set<EnvoyRlsRule.KeyValueResource> resources = descriptor.getResources();
            if (resources == null || resources.isEmpty()) {
                return false;
            }
            for (EnvoyRlsRule.KeyValueResource resource : resources) {
                if (resource != null && !StringUtil.isBlank((String)resource.getKey()) && !StringUtil.isBlank((String)resource.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    private EnvoyRlsRuleManager() {
    }

    static {
        currentProperty.addListener(PROPERTY_LISTENER);
    }

    static final class EnvoyRlsRulePropertyListener
    extends SimplePropertyListener<List<EnvoyRlsRule>> {
        EnvoyRlsRulePropertyListener() {
        }

        public synchronized void configUpdate(List<EnvoyRlsRule> conf) {
            Map<String, EnvoyRlsRule> ruleMap = this.generateRuleMap(conf);
            List flowRules = ruleMap.values().stream().flatMap(e -> EnvoySentinelRuleConverter.toSentinelFlowRules(e).stream()).collect(Collectors.toList());
            RULE_MAP.clear();
            RULE_MAP.putAll(ruleMap);
            RecordLog.info((String)("[EnvoyRlsRuleManager] Envoy RLS rules loaded: " + flowRules), (Object[])new Object[0]);
            ClusterFlowRuleManager.loadRules((String)"default", flowRules);
        }

        Map<String, EnvoyRlsRule> generateRuleMap(List<EnvoyRlsRule> conf) {
            if (conf == null || conf.isEmpty()) {
                return new HashMap<String, EnvoyRlsRule>(2);
            }
            HashMap<String, EnvoyRlsRule> map = new HashMap<String, EnvoyRlsRule>(conf.size());
            for (EnvoyRlsRule rule : conf) {
                if (!EnvoyRlsRuleManager.isValidRule(rule)) {
                    RecordLog.warn((String)("[EnvoyRlsRuleManager] Ignoring invalid rule when loading new RLS rules: " + rule), (Object[])new Object[0]);
                    continue;
                }
                if (map.containsKey(rule.getDomain())) {
                    RecordLog.warn((String)("[EnvoyRlsRuleManager] Ignoring duplicate RLS rule for specific domain: " + rule), (Object[])new Object[0]);
                    continue;
                }
                map.put(rule.getDomain(), rule);
            }
            return map;
        }
    }
}

