/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule;

import com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule.EnvoyRlsRule;
import com.alibaba.csp.sentinel.cluster.server.envoy.rls.rule.EnvoyRlsRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.List;
import java.util.stream.Collectors;

public final class EnvoySentinelRuleConverter {
    public static final String SEPARATOR = "|";

    public static List<FlowRule> toSentinelFlowRules(EnvoyRlsRule rule) {
        if (!EnvoyRlsRuleManager.isValidRule(rule)) {
            throw new IllegalArgumentException("Not a valid RLS rule");
        }
        return rule.getDescriptors().stream().map(e -> EnvoySentinelRuleConverter.toSentinelFlowRule(rule.getDomain(), e)).collect(Collectors.toList());
    }

    public static FlowRule toSentinelFlowRule(String domain, EnvoyRlsRule.ResourceDescriptor descriptor) {
        String identifier = EnvoySentinelRuleConverter.generateKey(domain, descriptor);
        long flowId = EnvoySentinelRuleConverter.generateFlowId(identifier);
        return new FlowRule(identifier).setCount(descriptor.getCount().doubleValue()).setClusterMode(true).setClusterConfig(new ClusterFlowConfig().setFlowId(Long.valueOf(flowId)).setThresholdType(1).setSampleCount(1).setFallbackToLocalWhenFail(false));
    }

    public static long generateFlowId(String key) {
        if (StringUtil.isBlank((String)key)) {
            return -1L;
        }
        return Integer.MAX_VALUE + (long)key.hashCode();
    }

    public static String generateKey(String domain, EnvoyRlsRule.ResourceDescriptor descriptor) {
        AssertUtil.assertNotBlank((String)domain, (String)"domain cannot be blank");
        AssertUtil.notNull((Object)descriptor, (String)"EnvoyRlsRule.ResourceDescriptor cannot be null");
        AssertUtil.assertNotEmpty(descriptor.getResources(), (String)"resources in descriptor cannot be null");
        StringBuilder sb = new StringBuilder(domain);
        for (EnvoyRlsRule.KeyValueResource resource : descriptor.getResources()) {
            sb.append(SEPARATOR).append(resource.getKey()).append(SEPARATOR).append(resource.getValue());
        }
        return sb.toString();
    }

    private EnvoySentinelRuleConverter() {
    }
}

