/*
 * Decompiled with CFR 0.152.
 */
package com.platform.callback.resources;

import com.codahale.metrics.annotation.Metered;
import com.google.common.collect.ImmutableMap;
import io.dropwizard.revolver.RevolverBundle;
import io.swagger.annotations.ApiOperation;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/callback")
@Singleton
public class CallbackApiManageResource {
    private static final Logger log = LoggerFactory.getLogger(CallbackApiManageResource.class);

    @Path(value="/v1/manage/api/status/{service}/{api}")
    @GET
    @Metered
    @ApiOperation(value="API Status")
    @Produces(value={"application/json"})
    public Response getStatus(@PathParam(value="service") String service, @PathParam(value="api") String api) {
        String key = service + "." + api;
        if (RevolverBundle.apiStatus.containsKey(key)) {
            return Response.ok((Object)ImmutableMap.builder().put((Object)"service", (Object)service).put((Object)"api", (Object)api).put((Object)"status", RevolverBundle.apiStatus.get(service + "." + api)).build()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.builder().put((Object)"service", (Object)service).put((Object)"api", (Object)api).build()).build();
    }

    @Path(value="/v1/manage/api/status/{service}/{api}/enable")
    @POST
    @Metered
    @ApiOperation(value="Enable API")
    @Produces(value={"application/json"})
    public Response enable(@PathParam(value="service") String service, @PathParam(value="api") String api) {
        String key = service + "." + api;
        if (RevolverBundle.apiStatus.containsKey(key)) {
            RevolverBundle.apiStatus.put(key, true);
            return Response.ok((Object)ImmutableMap.builder().put((Object)"service", (Object)service).put((Object)"api", (Object)api).put((Object)"status", RevolverBundle.apiStatus.get(service + "." + api)).build()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.builder().put((Object)"service", (Object)service).put((Object)"api", (Object)api).build()).build();
    }

    @Path(value="/v1/manage/api/status/{service}/{api}/disable")
    @POST
    @Metered
    @ApiOperation(value="Disable API")
    @Produces(value={"application/json"})
    public Response disable(@PathParam(value="service") String service, @PathParam(value="api") String api) {
        String key = service + "." + api;
        if (RevolverBundle.apiStatus.containsKey(key)) {
            RevolverBundle.apiStatus.put(key, false);
            return Response.ok((Object)ImmutableMap.builder().put((Object)"service", (Object)service).put((Object)"api", (Object)api).put((Object)"status", RevolverBundle.apiStatus.get(service + "." + api)).build()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.builder().put((Object)"service", (Object)service).put((Object)"api", (Object)api).build()).build();
    }

    @Path(value="/v1/manage/api/status")
    @GET
    @Metered
    @ApiOperation(value="Full API Status")
    @Produces(value={"application/json"})
    public Response status() {
        return Response.ok(RevolverBundle.apiStatus.entrySet().stream().map(e -> {
            String[] key = ((String)e.getKey()).split("\\.");
            return ImmutableMap.builder().put((Object)"service", (Object)key[0]).put((Object)"api", (Object)key[1]).put((Object)"status", e.getValue()).build();
        }).collect(Collectors.toList())).build();
    }

    public static CallbackApiManageResourceBuilder builder() {
        return new CallbackApiManageResourceBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallbackApiManageResource)) {
            return false;
        }
        CallbackApiManageResource other = (CallbackApiManageResource)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof CallbackApiManageResource;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "CallbackApiManageResource()";
    }

    public static class CallbackApiManageResourceBuilder {
        CallbackApiManageResourceBuilder() {
        }

        public CallbackApiManageResource build() {
            return new CallbackApiManageResource();
        }

        public String toString() {
            return "CallbackApiManageResource.CallbackApiManageResourceBuilder()";
        }
    }
}

