/*
 * Decompiled with CFR 0.152.
 */
package com.platform.callback.rabbitmq;

import com.google.inject.Inject;
import com.platform.callback.rabbitmq.ActionMessagePublisher;
import io.dropwizard.actors.connectivity.RMQConnection;
import io.dropwizard.lifecycle.Managed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQWrapper
implements Managed {
    private static final Logger log = LoggerFactory.getLogger(RMQWrapper.class);
    private final RMQConnection connection;

    @Inject
    public RMQWrapper(RMQConnection connection) {
        this.connection = connection;
    }

    public void start() throws Exception {
        this.connection.start();
        ActionMessagePublisher.getActors().forEach((s, messageHandlingActor) -> {
            try {
                messageHandlingActor.start();
            }
            catch (Exception e) {
                log.error("Error starting actor : " + messageHandlingActor.getQueueId(), (Throwable)e);
                throw new RuntimeException("Error starting actor : " + messageHandlingActor.getQueueId(), e);
            }
        });
    }

    public void stop() throws Exception {
        this.connection.stop();
        ActionMessagePublisher.getActors().forEach((s, messageHandlingActor) -> {
            try {
                messageHandlingActor.stop();
            }
            catch (Exception e) {
                log.error("Error stopping actor : " + messageHandlingActor.getQueueId(), (Throwable)e);
                throw new RuntimeException("Error stopping actor : " + messageHandlingActor.getQueueId(), e);
            }
        });
    }
}

