/*
 * Decompiled with CFR 0.152.
 */
package com.platform.callback.rabbitmq;

import com.google.common.collect.Maps;
import com.platform.callback.exception.CallbackException;
import com.platform.callback.exception.ResponseCode;
import com.platform.callback.rabbitmq.actors.impl.MessageHandlingActor;
import com.platform.callback.rabbitmq.actors.messages.ActionMessage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionMessagePublisher {
    private static final Logger log = LoggerFactory.getLogger(ActionMessagePublisher.class);
    private static Map<String, MessageHandlingActor> actors;

    public static void initialize(List<MessageHandlingActor> actorList) {
        actors = Maps.newConcurrentMap();
        actorList.forEach(actor -> actors.put(actor.getQueueId(), (MessageHandlingActor)actor));
    }

    public static Map<String, MessageHandlingActor> getActors() {
        return Collections.unmodifiableMap(actors);
    }

    public static <Message extends ActionMessage> Boolean publishWithDelay(Message message, long delayInMillis, String clientIdKey) {
        try {
            MessageHandlingActor actor = actors.get(message.getQueueId());
            actor.publish(message);
            return true;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error in publishing in rmq:%s", message.getQueueId());
            log.error(errorMessage, (Throwable)e);
            throw new CallbackException(ResponseCode.QUEUE_EXCEPTION, errorMessage);
        }
    }

    public static <Message extends ActionMessage> Boolean publish(Message message) {
        try {
            MessageHandlingActor actor = actors.get(message.getQueueId());
            if (actor == null) {
                return false;
            }
            actor.publish(message);
            return true;
        }
        catch (Exception e) {
            String errorMessage = String.format("Error in publishing in rmq:%s ", message.getQueueId());
            log.error(errorMessage, (Throwable)e);
            throw new CallbackException(ResponseCode.QUEUE_EXCEPTION, errorMessage);
        }
    }
}

