(ns uix.dom.linter
  (:require [cljs.analyzer :as ana]
            [uix.lib :refer [doseq-loop]]
            [uix.linter]))

(def html-elements
  #{:a :abbr :acronym :address :area :article :aside :audio :b :base :bdi :bdo :big :blockquote :body :br :button :canvas :caption :center :cite :code :col :colgroup :data :datalist :dd :del :details :dfn :dialog :dir :div :dl :dt :em :embed :fieldset :figcaption :figure :font :footer :form :frame :frameset :h1 :h2 :h3 :h4 :h5 :h6 :head :header :hgroup :hr :html :i :iframe :image :img :input :ins :kbd :label :legend :li :link :main :map :mark :marquee :menu :menuitem :meta :meter :nav :nobr :noembed :noframes :noscript :object :ol :optgroup :option :output :p :param :picture :plaintext :portal :pre :progress :q :rb :rp :rt :rtc :ruby :s :samp :script :search :section :select :slot :small :source :span :strike :strong :style :sub :summary :sup :table :tbody :td :template :textarea :tfoot :th :thead :time :title :tr :track :tt :u :ul :var :video :wbr :xmp})

(def html-attrs
  {:formnovalidate :form-no-validate, :y :y, :zoomandpan :zoom-and-pan, :role :role, :glyphname :glyph-name, :rel :rel, :text-anchor :text-anchor, :divisor :divisor, :text-rendering :text-rendering, :surfacescale :surface-scale, :font-style :font-style, :reversed :reversed, :keysplines :key-splines, :fontstretch :font-stretch, :xml:lang :xml-lang, :vmathematical :v-mathematical, :open :open, :focusable :focusable, :strokedasharray :stroke-dasharray, :mask :mask, :image-rendering :image-rendering, :stroke-dasharray :stroke-dasharray, :strikethrough-thickness :strikethrough-thickness, :async :async, :accumulate :accumulate, :x-height :x-height, :typeof :typeof, :colorinterpolationfilters :color-interpolation-filters, :exponent :exponent, :vertoriginx :vert-origin-x, :bbox :bbox, :color-rendering :color-rendering, :xlink:arcrole :xlink-arcrole, :dominantbaseline :dominant-baseline, :markerheight :marker-height, :min :min, :fill-rule :fill-rule, :letterspacing :letter-spacing, :font-stretch :font-stretch, :format :format, :hanging :hanging, :children :children, :xheight :x-height, :sizes :sizes, :playsinline :plays-inline, :inputmode :input-mode, :rx :rx, :cellpadding :cell-padding, :r :r, :accent-height :accent-height, :novalidate :no-validate, :colorinterpolation :color-interpolation, :vector-effect :vector-effect, :xlinktitle :xlink-title, :stroke :stroke, :stop-color :stop-color, :attributetype :attribute-type, :horizoriginx :horiz-origin-x, :clip :clip, :wrap :wrap, :glyph-orientation-horizontal :glyph-orientation-horizontal, :paintorder :paint-order, :unitsperem :units-per-em, :elevation :elevation, :crossorigin :cross-origin, :xlink:show :xlink-show, :restart :restart, :intercept :intercept, :transform :transform, :selected :selected, :dx :dx, :srcset :src-set, :color :color, :stitchtiles :stitch-tiles, :xlinkshow :xlink-show, :dir :dir, :calcmode :calc-mode, :clippath :clip-path, :muted :muted, :amplitude :amplitude, :seamless :seamless, :acceptcharset :accept-charset, :placeholder :placeholder, :tabindex :tab-index, :disabled :disabled, :allowreorder :allow-reorder, :refy :ref-y, :markerstart :marker-start, :usemap :use-map, :is :is, :primitiveunits :primitive-units, :itemtype :item-type, :font-size :font-size, :fontstyle :font-style, :diffuseconstant :diffuse-constant, :alt :alt, :rowspan :row-span, :srcdoc :src-doc, :offset :offset, :allowfullscreen :allow-full-screen, :speed :speed, :stemv :stemv, :scale :scale, :kerning :kerning, :font-variant :font-variant, :writing-mode :writing-mode, :unselectable :unselectable, :font-weight :font-weight, :contextmenu :context-menu, :autocapitalize :auto-capitalize, :security :security, :xlinkactuate :xlink-actuate, :controlslist :controls-list, :coords :coords, :keytype :key-type, :method :method, :content :content, :default :default, :datatype :datatype, :patternunits :pattern-units, :overlinethickness :overline-thickness, :u1 :u1, :overflow :overflow, :property :property, :frameborder :frame-border, :strikethroughposition :strikethrough-position, :referrerpolicy :referrer-policy, :ideographic :ideographic, :name :name, :clip-rule :clip-rule, :panose1 :panose1, :as :as, :colorrendering :color-rendering, :innerhtml :inner-html, :arabicform :arabic-form, :renderingintent :rendering-intent, :stroke-opacity :stroke-opacity, :horiz-origin-x :horiz-origin-x, :fill :fill, :keytimes :key-times, :viewtarget :view-target, :value :value, :defaultchecked :default-checked, :minlength :min-length, :xml:space :xml-space, :readonly :read-only, :kernelmatrix :kernel-matrix, :stddeviation :std-deviation, :optimum :optimum, :preservealpha :preserve-alpha, :suppresshydrationwarning :suppress-hydration-warning, :kernelunitlength :kernel-unit-length, :numoctaves :num-octaves, :color-profile :color-profile, :vert-origin-y :vert-origin-y, :underlinethickness :underline-thickness, :stroke-linejoin :stroke-linejoin, :strokewidth :stroke-width, :strikethrough-position :strikethrough-position, :y1 :y1, :scoped :scoped, :mode :mode, :width :width, :start :start, :dy :dy, :strokelinecap :stroke-linecap, :g2 :g2, :alignmentbaseline :alignment-baseline, :defer :defer, :shape-rendering :shape-rendering, :orientation :orientation, :xlinkrole :xlink-role, :cursor :cursor, :panose-1 :panose1, :stroke-dashoffset :stroke-dashoffset, :refx :ref-x, :type :type, :specularconstant :specular-constant, :classname :class-name, :hreflang :href-lang, :glyphref :glyph-ref, :controls :controls, :viewbox :view-box, :fontsizeadjust :font-size-adjust, :vert-origin-x :vert-origin-x, :nomodule :no-module, :manifest :manifest, :src :src, :points :points, :xmlns :xmlns, :autocorrect :auto-correct, :orient :orient, :formtarget :form-target, :videographic :v-ideographic, :contentscripttype :content-script-type, :underline-thickness :underline-thickness, :icon :icon, :multiple :multiple, :accesskey :access-key, :formaction :form-action, :horiz-adv-x :horiz-adv-x, :scope :scope, :overlineposition :overline-position, :sandbox :sandbox, :itemprop :item-prop, :string :string, :ascent :ascent, :radius :radius, :strokemiterlimit :stroke-miterlimit, :baseprofile :base-profile, :word-spacing :word-spacing, :xlinktype :xlink-type, :disableremoteplayback :disable-remote-playback, :xlink:type :xlink-type, :autoreverse :auto-reverse, :maxlength :max-length, :seed :seed, :stop-opacity :stop-opacity, :size :size, :pointsaty :points-at-y, :k :k, :title :title, :capheight :cap-height, :repeatcount :repeat-count, :prefix :prefix, :arabic-form :arabic-form, :headers :headers, :loop :loop, :strokedashoffset :stroke-dashoffset, :high :high, :suppresscontenteditablewarning :suppress-content-editable-warning, :widths :widths, :keyparams :key-params, :style :style, :unicode-range :unicode-range, :clip-path :clip-path, :autosave :auto-save, :markerunits :marker-units, :inlist :inlist, :lang :lang, :stroke-linecap :stroke-linecap, :rows :rows, :flood-opacity :flood-opacity, :in2 :in2, :summary :summary, :begin :begin, :cliprule :clip-rule, :g1 :g1, :shaperendering :shape-rendering, :lighting-color :lighting-color, :writingmode :writing-mode, :z :z, :strokelinejoin :stroke-linejoin, :enterkeyhint :enter-key-hint, :azimuth :azimuth, :wordspacing :word-spacing, :alphabetic :alphabetic, :alignment-baseline :alignment-baseline, :stopcolor :stop-color, :http-equiv :http-equiv, :cols :cols, :xmlns:xlink :xmlns-xlink, :scrolling :scrolling, :vocab :vocab, :valphabetic :v-alphabetic, :radiogroup :radio-group, :preload :preload, :dominant-baseline :dominant-baseline, :units-per-em :units-per-em, :marker-start :marker-start, :strokeopacity :stroke-opacity, :overline-position :overline-position, :filter :filter, :externalresourcesrequired :external-resources-required, :spellcheck :spell-check, :targety :target-y, :formmethod :form-method, :textanchor :text-anchor, :markerend :marker-end, :xmlnsxlink :xmlns-xlink, :poster :poster, :draggable :draggable, :glyph-name :glyph-name, :keypoints :key-points, :vectoreffect :vector-effect, :basefrequency :base-frequency, :pointerevents :pointer-events, :descent :descent, :stroke-width :stroke-width, :challenge :challenge, :targetx :target-x, :list :list, :cap-height :cap-height, :attributename :attribute-name, :result :result, :from :from, :u2 :u2, :hidden :hidden, :max :max, :patterncontentunits :pattern-content-units, :opacity :opacity, :cx :cx, :label :label, :fontweight :font-weight, :id :id, :requiredextensions :required-extensions, :accept-charset :accept-charset, :values :values, :dur :dur, :autofocus :auto-focus, :wmode :wmode, :k3 :k3, :resource :resource, :repeatdur :repeat-dur, :cy :cy, :underline-position :underline-position, :kind :kind, :htmlfor :html-for, :k4 :k4, :xlink:actuate :xlink-actuate, :baseline-shift :baseline-shift, :baselineshift :baseline-shift, :checked :checked, :markerwidth :marker-width, :maskunits :mask-units, :lightingcolor :lighting-color, :imagerendering :image-rendering, :v-mathematical :v-mathematical, :filterres :filter-res, :slope :slope, :pathlength :path-length, :xlink:href :xlink-href, :color-interpolation-filters :color-interpolation-filters, :ychannelselector :y-channel-selector, :contentstyletype :content-style-type, :shape :shape, :underlineposition :underline-position, :strikethroughthickness :strikethrough-thickness, :filterunits :filter-units, :fontvariant :font-variant, :xlinkhref :xlink-href, :fontsize :font-size, :xchannelselector :x-channel-selector, :pointsatx :points-at-x, :additive :additive, :datetime :date-time, :operator :operator, :fontfamily :font-family, :defaultvalue :default-value, :preserveaspectratio :preserve-aspect-ratio, :low :low, :dangerouslysetinnerhtml :dangerously-set-inner-html, :marginheight :margin-height, :xlinkarcrole :xlink-arcrole, :text-decoration :text-decoration, :cellspacing :cell-spacing, :rotate :rotate, :display :display, :mathematical :mathematical, :textdecoration :text-decoration, :order :order, :d :d, :action :action, :stopopacity :stop-opacity, :imagesrcset :image-src-set, :requiredfeatures :required-features, :horizadvx :horiz-adv-x, :xmlspace :xml-space, :by :by, :origin :origin, :httpequiv :http-equiv, :fy :fy, :stroke-miterlimit :stroke-miterlimit, :specularexponent :specular-exponent, :marginwidth :margin-width, :colorprofile :color-profile, :letter-spacing :letter-spacing, :x :x, :autocomplete :auto-complete, :maskcontentunits :mask-content-units, :vert-adv-y :vert-adv-y, :x1 :x1, :form :form, :gradienttransform :gradient-transform, :capture :capture, :autoplay :auto-play, :integrity :integrity, :target :target, :unicoderange :unicode-range, :vertoriginy :vert-origin-y, :flood-color :flood-color, :rendering-intent :rendering-intent, :v-hanging :v-hanging, :unicode-bidi :unicode-bidi, :colspan :col-span, :tablevalues :table-values, :accentheight :accent-height, :end :end, :limitingconeangle :limiting-cone-angle, :xlink:title :xlink-title, :unicode :unicode, :bias :bias, :version :version, :unicodebidi :unicode-bidi, :y2 :y2, :glyphorientationhorizontal :glyph-orientation-horizontal, :xmllang :xml-lang, :formenctype :form-enc-type, :floodcolor :flood-color, :itemref :item-ref, :textlength :text-length, :systemlanguage :system-language, :marker-mid :marker-mid, :v-ideographic :v-ideographic, :floodopacity :flood-opacity, :nonce :nonce, :pointer-events :pointer-events, :fx :fx, :gradientunits :gradient-units, :local :local, :font-size-adjust :font-size-adjust, :download :download, :cite :cite, :k1 :k1, :k2 :k2, :srclang :src-lang, :step :step, :pointsatz :points-at-z, :itemid :item-id, :decelerate :decelerate, :media :media, :xmlbase :xml-base, :glyph-orientation-vertical :glyph-orientation-vertical, :itemscope :item-scope, :glyphorientationvertical :glyph-orientation-vertical, :lengthadjust :length-adjust, :startoffset :start-offset, :x2 :x2, :color-interpolation :color-interpolation, :visibility :visibility, :enctype :enc-type, :ry :ry, :enable-background :enable-background, :direction :direction, :enablebackground :enable-background, :classid :class-id, :href :href, :profile :profile, :fill-opacity :fill-opacity, :required :required, :contenteditable :content-editable, :fillopacity :fill-opacity, :fillrule :fill-rule, :v-alphabetic :v-alphabetic, :vertadvy :vert-adv-y, :spreadmethod :spread-method, :mediagroup :media-group, :edgemode :edge-mode, :imagesizes :image-sizes, :font-family :font-family, :clippathunits :clip-path-units, :textrendering :text-rendering, :disablepictureinpicture :disable-picture-in-picture, :height :height, :spacing :spacing, :marker-end :marker-end, :about :about, :vhanging :v-hanging, :in :in, :pattern :pattern, :overline-thickness :overline-thickness, :accept :accept, :markermid :marker-mid, :span :span, :to :to, :paint-order :paint-order, :xml:base :xml-base, :xlink:role :xlink-role, :patterntransform :pattern-transform, :data :data, :stemh :stemh, :results :results})

(defmethod ana/error-message :dom/invalid-attribute [_ {:keys [k]}]
  (cond-> (str "Invalid DOM property " k ".")
          (html-attrs k) (str " Did you mean " (html-attrs k) "?")))

(defn validate-attrs [tag m {:keys [env]}]
  (when (contains? html-elements tag)
    (doseq-loop [[k _] m]
      (when (and (contains? html-attrs k) (not= k (html-attrs k)))
        (ana/warning :dom/invalid-attribute (merge env (uix.linter/form->loc m)) {:k k})))))

(defmethod uix.linter/lint-element :dom/invalid-attribute [type form env]
  (let [[tag attrs] (uix.lib/normalize-element env (rest form))]
    (when (and (keyword? tag) (map? attrs))
      (validate-attrs tag attrs {:env env}))))

