goog.provide('membrane.ui');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Font = (function (name,size,weight,width,slant,__meta,__extmap,__hash){
this.name = name;
this.size = size;
this.weight = weight;
this.width = width;
this.slant = slant;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Font.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Font.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k11792,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__11796 = k11792;
var G__11796__$1 = (((G__11796 instanceof cljs.core.Keyword))?G__11796.fqn:null);
switch (G__11796__$1) {
case "name":
return self__.name;

break;
case "size":
return self__.size;

break;
case "weight":
return self__.weight;

break;
case "width":
return self__.width;

break;
case "slant":
return self__.slant;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k11792,else__4383__auto__);

}
}));

(membrane.ui.Font.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__11803){
var vec__11809 = p__11803;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11809,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11809,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Font.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Font{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"weight","weight",-1262796205),self__.weight],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"width","width",-384071477),self__.width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"slant","slant",1122551990),self__.slant],null))], null),self__.__extmap));
}));

(membrane.ui.Font.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11791){
var self__ = this;
var G__11791__$1 = this;
return (new cljs.core.RecordIter((0),G__11791__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"weight","weight",-1262796205),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"slant","slant",1122551990)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Font.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Font.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Font.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Font.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (633017093 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Font.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this11793,other11794){
var self__ = this;
var this11793__$1 = this;
return (((!((other11794 == null)))) && ((this11793__$1.constructor === other11794.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11793__$1.name,other11794.name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11793__$1.size,other11794.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11793__$1.weight,other11794.weight)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11793__$1.width,other11794.width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11793__$1.slant,other11794.slant)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11793__$1.__extmap,other11794.__extmap)));
}));

(membrane.ui.Font.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"weight","weight",-1262796205),null,new cljs.core.Keyword(null,"slant","slant",1122551990),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Font.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__11791){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__11823 = cljs.core.keyword_identical_QMARK_;
var expr__11824 = k__4388__auto__;
if(cljs.core.truth_((pred__11823.cljs$core$IFn$_invoke$arity$2 ? pred__11823.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177),expr__11824) : pred__11823.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__11824)))){
return (new membrane.ui.Font(G__11791,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__11823.cljs$core$IFn$_invoke$arity$2 ? pred__11823.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),expr__11824) : pred__11823.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__11824)))){
return (new membrane.ui.Font(self__.name,G__11791,self__.weight,self__.width,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__11823.cljs$core$IFn$_invoke$arity$2 ? pred__11823.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"weight","weight",-1262796205),expr__11824) : pred__11823.call(null,new cljs.core.Keyword(null,"weight","weight",-1262796205),expr__11824)))){
return (new membrane.ui.Font(self__.name,self__.size,G__11791,self__.width,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__11823.cljs$core$IFn$_invoke$arity$2 ? pred__11823.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"width","width",-384071477),expr__11824) : pred__11823.call(null,new cljs.core.Keyword(null,"width","width",-384071477),expr__11824)))){
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,G__11791,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__11823.cljs$core$IFn$_invoke$arity$2 ? pred__11823.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"slant","slant",1122551990),expr__11824) : pred__11823.call(null,new cljs.core.Keyword(null,"slant","slant",1122551990),expr__11824)))){
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,G__11791,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__11791),null));
}
}
}
}
}
}));

(membrane.ui.Font.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"name","name",1843675177),self__.name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"weight","weight",-1262796205),self__.weight,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"width","width",-384071477),self__.width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"slant","slant",1122551990),self__.slant,null))], null),self__.__extmap));
}));

(membrane.ui.Font.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__11791){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,G__11791,self__.__extmap,self__.__hash));
}));

(membrane.ui.Font.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Font.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"weight","weight",377735322,null),new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"slant","slant",-1531883779,null)], null);
}));

(membrane.ui.Font.cljs$lang$type = true);

(membrane.ui.Font.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Font",null,(1),null));
}));

(membrane.ui.Font.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Font");
}));

/**
 * Positional factory function for membrane.ui/Font.
 */
membrane.ui.__GT_Font = (function membrane$ui$__GT_Font(name,size,weight,width,slant){
return (new membrane.ui.Font(name,size,weight,width,slant,null,null,null));
});

/**
 * Factory function for membrane.ui/Font, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Font = (function membrane$ui$map__GT_Font(G__11795){
var extmap__4419__auto__ = (function (){var G__11826 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__11795,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"weight","weight",-1262796205),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"slant","slant",1122551990)], 0));
if(cljs.core.record_QMARK_(G__11795)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__11826);
} else {
return G__11826;
}
})();
return (new membrane.ui.Font(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__11795),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__11795),new cljs.core.Keyword(null,"weight","weight",-1262796205).cljs$core$IFn$_invoke$arity$1(G__11795),new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(G__11795),new cljs.core.Keyword(null,"slant","slant",1122551990).cljs$core$IFn$_invoke$arity$1(G__11795),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.default_font = (new membrane.ui.Font(null,(14),null,null,null,null,null,null));
/**
 * Creates a font.
 * 
 *   `name`: Should be the path to a font file on desktop. If nil, use the default font.
 *   `size`: Size of the font. If nil, use the default font size.
 */
membrane.ui.font = (function membrane$ui$font(name,size){
return (new membrane.ui.Font((cljs.core.truth_(name)?name:membrane.ui.default_font.name),(cljs.core.truth_(size)?size:membrane.ui.default_font.size),membrane.ui.default_font.weight,membrane.ui.default_font.width,membrane.ui.default_font.slant,null,null,null));
});

/**
 * @interface
 */
membrane.ui.IMouseMove = function(){};

var membrane$ui$IMouseMove$_mouse_move$dyn_13224 = (function (elem,pos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_move[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4429__auto__.call(null,elem,pos));
} else {
var m__4426__auto__ = (membrane.ui._mouse_move["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4426__auto__.call(null,elem,pos));
} else {
throw cljs.core.missing_protocol("IMouseMove.-mouse-move",elem);
}
}
});
membrane.ui._mouse_move = (function membrane$ui$_mouse_move(elem,pos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseMove$_mouse_move$arity$2 == null)))))){
return elem.membrane$ui$IMouseMove$_mouse_move$arity$2(elem,pos);
} else {
return membrane$ui$IMouseMove$_mouse_move$dyn_13224(elem,pos);
}
});


/**
 * @interface
 */
membrane.ui.IMouseMoveGlobal = function(){};

var membrane$ui$IMouseMoveGlobal$_mouse_move_global$dyn_13243 = (function (elem,pos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_move_global[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4429__auto__.call(null,elem,pos));
} else {
var m__4426__auto__ = (membrane.ui._mouse_move_global["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4426__auto__.call(null,elem,pos));
} else {
throw cljs.core.missing_protocol("IMouseMoveGlobal.-mouse-move-global",elem);
}
}
});
membrane.ui._mouse_move_global = (function membrane$ui$_mouse_move_global(elem,pos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 == null)))))){
return elem.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2(elem,pos);
} else {
return membrane$ui$IMouseMoveGlobal$_mouse_move_global$dyn_13243(elem,pos);
}
});


/**
 * @interface
 */
membrane.ui.IMouseEvent = function(){};

var membrane$ui$IMouseEvent$_mouse_event$dyn_13258 = (function (elem,pos,button,mouse_down_QMARK_,mods){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$5(elem,pos,button,mouse_down_QMARK_,mods) : m__4429__auto__.call(null,elem,pos,button,mouse_down_QMARK_,mods));
} else {
var m__4426__auto__ = (membrane.ui._mouse_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$5(elem,pos,button,mouse_down_QMARK_,mods) : m__4426__auto__.call(null,elem,pos,button,mouse_down_QMARK_,mods));
} else {
throw cljs.core.missing_protocol("IMouseEvent.-mouse-event",elem);
}
}
});
membrane.ui._mouse_event = (function membrane$ui$_mouse_event(elem,pos,button,mouse_down_QMARK_,mods){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseEvent$_mouse_event$arity$5 == null)))))){
return elem.membrane$ui$IMouseEvent$_mouse_event$arity$5(elem,pos,button,mouse_down_QMARK_,mods);
} else {
return membrane$ui$IMouseEvent$_mouse_event$dyn_13258(elem,pos,button,mouse_down_QMARK_,mods);
}
});


/**
 * @interface
 */
membrane.ui.IDrop = function(){};

var membrane$ui$IDrop$_drop$dyn_13273 = (function (elem,paths,pos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._drop[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(elem,paths,pos) : m__4429__auto__.call(null,elem,paths,pos));
} else {
var m__4426__auto__ = (membrane.ui._drop["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(elem,paths,pos) : m__4426__auto__.call(null,elem,paths,pos));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",elem);
}
}
});
membrane.ui._drop = (function membrane$ui$_drop(elem,paths,pos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IDrop$_drop$arity$3 == null)))))){
return elem.membrane$ui$IDrop$_drop$arity$3(elem,paths,pos);
} else {
return membrane$ui$IDrop$_drop$dyn_13273(elem,paths,pos);
}
});


/**
 * @interface
 */
membrane.ui.IScroll = function(){};

var membrane$ui$IScroll$_scroll$dyn_13289 = (function (elem,delta,mpos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._scroll[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(elem,delta,mpos) : m__4429__auto__.call(null,elem,delta,mpos));
} else {
var m__4426__auto__ = (membrane.ui._scroll["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(elem,delta,mpos) : m__4426__auto__.call(null,elem,delta,mpos));
} else {
throw cljs.core.missing_protocol("IScroll.-scroll",elem);
}
}
});
membrane.ui._scroll = (function membrane$ui$_scroll(elem,delta,mpos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IScroll$_scroll$arity$3 == null)))))){
return elem.membrane$ui$IScroll$_scroll$arity$3(elem,delta,mpos);
} else {
return membrane$ui$IScroll$_scroll$dyn_13289(elem,delta,mpos);
}
});


/**
 * @interface
 */
membrane.ui.IMouseWheel = function(){};

var membrane$ui$IMouseWheel$_mouse_wheel$dyn_13309 = (function (elem,delta){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_wheel[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,delta) : m__4429__auto__.call(null,elem,delta));
} else {
var m__4426__auto__ = (membrane.ui._mouse_wheel["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,delta) : m__4426__auto__.call(null,elem,delta));
} else {
throw cljs.core.missing_protocol("IMouseWheel.-mouse-wheel",elem);
}
}
});
membrane.ui._mouse_wheel = (function membrane$ui$_mouse_wheel(elem,delta){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseWheel$_mouse_wheel$arity$2 == null)))))){
return elem.membrane$ui$IMouseWheel$_mouse_wheel$arity$2(elem,delta);
} else {
return membrane$ui$IMouseWheel$_mouse_wheel$dyn_13309(elem,delta);
}
});


/**
 * @interface
 */
membrane.ui.IKeyPress = function(){};

var membrane$ui$IKeyPress$_key_press$dyn_13324 = (function (elem,key){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._key_press[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4429__auto__.call(null,elem,key));
} else {
var m__4426__auto__ = (membrane.ui._key_press["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4426__auto__.call(null,elem,key));
} else {
throw cljs.core.missing_protocol("IKeyPress.-key-press",elem);
}
}
});
membrane.ui._key_press = (function membrane$ui$_key_press(elem,key){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IKeyPress$_key_press$arity$2 == null)))))){
return elem.membrane$ui$IKeyPress$_key_press$arity$2(elem,key);
} else {
return membrane$ui$IKeyPress$_key_press$dyn_13324(elem,key);
}
});


/**
 * @interface
 */
membrane.ui.IKeyType = function(){};

var membrane$ui$IKeyType$_key_type$dyn_13328 = (function (elem,key){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._key_type[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4429__auto__.call(null,elem,key));
} else {
var m__4426__auto__ = (membrane.ui._key_type["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4426__auto__.call(null,elem,key));
} else {
throw cljs.core.missing_protocol("IKeyType.-key-type",elem);
}
}
});
membrane.ui._key_type = (function membrane$ui$_key_type(elem,key){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IKeyType$_key_type$arity$2 == null)))))){
return elem.membrane$ui$IKeyType$_key_type$arity$2(elem,key);
} else {
return membrane$ui$IKeyType$_key_type$dyn_13328(elem,key);
}
});


/**
 * @interface
 */
membrane.ui.IClipboardPaste = function(){};

var membrane$ui$IClipboardPaste$_clipboard_paste$dyn_13339 = (function (elem,contents){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._clipboard_paste[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,contents) : m__4429__auto__.call(null,elem,contents));
} else {
var m__4426__auto__ = (membrane.ui._clipboard_paste["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,contents) : m__4426__auto__.call(null,elem,contents));
} else {
throw cljs.core.missing_protocol("IClipboardPaste.-clipboard-paste",elem);
}
}
});
membrane.ui._clipboard_paste = (function membrane$ui$_clipboard_paste(elem,contents){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2 == null)))))){
return elem.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2(elem,contents);
} else {
return membrane$ui$IClipboardPaste$_clipboard_paste$dyn_13339(elem,contents);
}
});


/**
 * @interface
 */
membrane.ui.IClipboardCopy = function(){};

var membrane$ui$IClipboardCopy$_clipboard_copy$dyn_13351 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._clipboard_copy[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._clipboard_copy["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IClipboardCopy.-clipboard-copy",elem);
}
}
});
membrane.ui._clipboard_copy = (function membrane$ui$_clipboard_copy(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1 == null)))))){
return elem.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1(elem);
} else {
return membrane$ui$IClipboardCopy$_clipboard_copy$dyn_13351(elem);
}
});


/**
 * @interface
 */
membrane.ui.IClipboardCut = function(){};

var membrane$ui$IClipboardCut$_clipboard_cut$dyn_13357 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._clipboard_cut[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._clipboard_cut["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IClipboardCut.-clipboard-cut",elem);
}
}
});
membrane.ui._clipboard_cut = (function membrane$ui$_clipboard_cut(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IClipboardCut$_clipboard_cut$arity$1 == null)))))){
return elem.membrane$ui$IClipboardCut$_clipboard_cut$arity$1(elem);
} else {
return membrane$ui$IClipboardCut$_clipboard_cut$dyn_13357(elem);
}
});


/**
 * @interface
 */
membrane.ui.IMakeNode = function(){};

var membrane$ui$IMakeNode$make_node$dyn_13370 = (function (node,childs){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (membrane.ui.make_node[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(node,childs) : m__4429__auto__.call(null,node,childs));
} else {
var m__4426__auto__ = (membrane.ui.make_node["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(node,childs) : m__4426__auto__.call(null,node,childs));
} else {
throw cljs.core.missing_protocol("IMakeNode.make-node",node);
}
}
});
membrane.ui.make_node = (function membrane$ui$make_node(node,childs){
if((((!((node == null)))) && ((!((node.membrane$ui$IMakeNode$make_node$arity$2 == null)))))){
return node.membrane$ui$IMakeNode$make_node$arity$2(node,childs);
} else {
return membrane$ui$IMakeNode$make_node$dyn_13370(node,childs);
}
});

(cljs.core.PersistentVector.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (node,childs){
var node__$1 = this;
return cljs.core.vec(childs);
}));

/**
 * @interface
 */
membrane.ui.IOrigin = function(){};

var membrane$ui$IOrigin$_origin$dyn_13374 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._origin[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._origin["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IOrigin.-origin",elem);
}
}
});
/**
 * Specifies the top left corner of a component's bounds
 * 
 *   The origin is vector or 2 numbers [x, y]
 */
membrane.ui._origin = (function membrane$ui$_origin(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IOrigin$_origin$arity$1 == null)))))){
return elem.membrane$ui$IOrigin$_origin$arity$1(elem);
} else {
return membrane$ui$IOrigin$_origin$dyn_13374(elem);
}
});

(cljs.core.PersistentVector.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

goog.object.set(membrane.ui.IOrigin,"null",true);

goog.object.set(membrane.ui._origin,"null",(function (this$){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));
/**
 * Specifies the top left corner of a component's bounds
 * 
 *   The origin is vector or 2 numbers [x, y]
 */
membrane.ui.origin = (function membrane$ui$origin(elem){
return membrane.ui._origin(elem);
});
/**
 * Convience function for returning the x coordinate of elem's origin
 */
membrane.ui.origin_x = (function membrane$ui$origin_x(elem){
return cljs.core.first(membrane.ui.origin(elem));
});
/**
 * Convience function for returning the y coordinate of elem's origin
 */
membrane.ui.origin_y = (function membrane$ui$origin_y(elem){
return cljs.core.second(membrane.ui.origin(elem));
});

/**
 * @interface
 */
membrane.ui.IKeyEvent = function(){};

var membrane$ui$IKeyEvent$_key_event$dyn_13388 = (function (this$,key,scancode,action,mods){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui._key_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$5(this$,key,scancode,action,mods) : m__4429__auto__.call(null,this$,key,scancode,action,mods));
} else {
var m__4426__auto__ = (membrane.ui._key_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$5(this$,key,scancode,action,mods) : m__4426__auto__.call(null,this$,key,scancode,action,mods));
} else {
throw cljs.core.missing_protocol("IKeyEvent.-key-event",this$);
}
}
});
membrane.ui._key_event = (function membrane$ui$_key_event(this$,key,scancode,action,mods){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IKeyEvent$_key_event$arity$5 == null)))))){
return this$.membrane$ui$IKeyEvent$_key_event$arity$5(this$,key,scancode,action,mods);
} else {
return membrane$ui$IKeyEvent$_key_event$dyn_13388(this$,key,scancode,action,mods);
}
});


/**
 * @interface
 */
membrane.ui.IHasKeyEvent = function(){};

var membrane$ui$IHasKeyEvent$has_key_event$dyn_13397 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui.has_key_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (membrane.ui.has_key_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IHasKeyEvent.has-key-event",this$);
}
}
});
membrane.ui.has_key_event = (function membrane$ui$has_key_event(this$){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHasKeyEvent$has_key_event$arity$1 == null)))))){
return this$.membrane$ui$IHasKeyEvent$has_key_event$arity$1(this$);
} else {
return membrane$ui$IHasKeyEvent$has_key_event$dyn_13397(this$);
}
});


/**
 * @interface
 */
membrane.ui.IHasKeyPress = function(){};

var membrane$ui$IHasKeyPress$has_key_press$dyn_13409 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui.has_key_press[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (membrane.ui.has_key_press["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IHasKeyPress.has-key-press",this$);
}
}
});
membrane.ui.has_key_press = (function membrane$ui$has_key_press(this$){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHasKeyPress$has_key_press$arity$1 == null)))))){
return this$.membrane$ui$IHasKeyPress$has_key_press$arity$1(this$);
} else {
return membrane$ui$IHasKeyPress$has_key_press$dyn_13409(this$);
}
});


/**
 * @interface
 */
membrane.ui.IHasMouseMoveGlobal = function(){};

var membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$dyn_13420 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui.has_mouse_move_global[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (membrane.ui.has_mouse_move_global["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IHasMouseMoveGlobal.has-mouse-move-global",this$);
}
}
});
membrane.ui.has_mouse_move_global = (function membrane$ui$has_mouse_move_global(this$){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$arity$1 == null)))))){
return this$.membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$arity$1(this$);
} else {
return membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$dyn_13420(this$);
}
});


/**
 * Allows an element add, remove, modify effects emitted from its children.
 * @interface
 */
membrane.ui.IBubble = function(){};

var membrane$ui$IBubble$_bubble$dyn_13434 = (function (_,effects){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (membrane.ui._bubble[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(_,effects) : m__4429__auto__.call(null,_,effects));
} else {
var m__4426__auto__ = (membrane.ui._bubble["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(_,effects) : m__4426__auto__.call(null,_,effects));
} else {
throw cljs.core.missing_protocol("IBubble.-bubble",_);
}
}
});
/**
 * Called when an effect is being emitted by a child element. The parent element can either return the same effects or allow them to continue to bubble.
 */
membrane.ui._bubble = (function membrane$ui$_bubble(_,effects){
if((((!((_ == null)))) && ((!((_.membrane$ui$IBubble$_bubble$arity$2 == null)))))){
return _.membrane$ui$IBubble$_bubble$arity$2(_,effects);
} else {
return membrane$ui$IBubble$_bubble$dyn_13434(_,effects);
}
});

goog.object.set(membrane.ui.IHasKeyPress,"null",true);

goog.object.set(membrane.ui.has_key_press,"null",(function (this$){
return false;
}));

goog.object.set(membrane.ui.IHasMouseMoveGlobal,"null",true);

goog.object.set(membrane.ui.has_mouse_move_global,"null",(function (this$){
return false;
}));

goog.object.set(membrane.ui.IScroll,"null",true);

goog.object.set(membrane.ui._scroll,"null",(function (elem,offset,local_pos){
return null;
}));

goog.object.set(membrane.ui.IMouseEvent,"null",true);

goog.object.set(membrane.ui._mouse_event,"null",(function (elem,local_pos,button,mouse_down_QMARK_,mods){
return null;
}));

goog.object.set(membrane.ui.IKeyEvent,"null",true);

goog.object.set(membrane.ui._key_event,"null",(function (this$,key,scancode,action,mods){
return null;
}));

goog.object.set(membrane.ui.IKeyPress,"null",true);

goog.object.set(membrane.ui._key_press,"null",(function (this$,info){
return null;
}));

goog.object.set(membrane.ui.IBubble,"null",true);

goog.object.set(membrane.ui._bubble,"null",(function (elem,effects){
return null;
}));

goog.object.set(membrane.ui.IDrop,"null",true);

goog.object.set(membrane.ui._drop,"null",(function (elem,paths,local_pos){
return null;
}));

goog.object.set(membrane.ui.IMouseMoveGlobal,"null",true);

goog.object.set(membrane.ui._mouse_move_global,"null",(function (this$,info){
return null;
}));

goog.object.set(membrane.ui.IHasKeyEvent,"null",true);

goog.object.set(membrane.ui.has_key_event,"null",(function (this$){
return false;
}));
membrane.ui._default_mouse_move_global = (function membrane$ui$_default_mouse_move_global(elem,offset){
var vec__11900 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11900,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11900,(1),null);
var vec__11903 = offset;
var sx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11903,(0),null);
var sy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11903,(1),null);
var child_offset = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(sx - ox),(sy - oy)], null);
var intents = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,(function (){var iter__4529__auto__ = (function membrane$ui$_default_mouse_move_global_$_iter__11906(s__11907){
return (new cljs.core.LazySeq(null,(function (){
var s__11907__$1 = s__11907;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__11907__$1);
if(temp__5735__auto__){
var s__11907__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__11907__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__11907__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__11909 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__11908 = (0);
while(true){
if((i__11908 < size__4528__auto__)){
var child = cljs.core._nth(c__4527__auto__,i__11908);
cljs.core.chunk_append(b__11909,membrane.ui._mouse_move_global(child,child_offset));

var G__13465 = (i__11908 + (1));
i__11908 = G__13465;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__11909),membrane$ui$_default_mouse_move_global_$_iter__11906(cljs.core.chunk_rest(s__11907__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__11909),null);
}
} else {
var child = cljs.core.first(s__11907__$2);
return cljs.core.cons(membrane.ui._mouse_move_global(child,child_offset),membrane$ui$_default_mouse_move_global_$_iter__11906(cljs.core.rest(s__11907__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem)));
})());
return membrane.ui._bubble(elem,intents);
});
membrane.ui.within_bounds_QMARK_ = (function membrane$ui$within_bounds_QMARK_(elem,p__11910){
var vec__11911 = p__11910;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11911,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11911,(1),null);
var vec__11914 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11914,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11914,(1),null);
var vec__11917 = (membrane.ui.bounds.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.bounds.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.bounds.call(null,elem));
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11917,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11917,(1),null);
var local_x = (x - ox);
var local_y = (y - oy);
if((((local_x < width)) && ((local_x >= (0))) && ((local_y < height)) && ((local_y >= (0))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [local_x,local_y], null);
} else {
return null;
}
});
goog.object.set(membrane.ui.IHasKeyPress,"_",true);

goog.object.set(membrane.ui.has_key_press,"_",(function (this$){
return cljs.core.some(membrane.ui.has_key_press,(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$)));
}));

goog.object.set(membrane.ui.IHasMouseMoveGlobal,"_",true);

goog.object.set(membrane.ui.has_mouse_move_global,"_",(function (this$){
return cljs.core.some(membrane.ui.has_mouse_move_global,(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$)));
}));

goog.object.set(membrane.ui.IScroll,"_",true);

goog.object.set(membrane.ui._scroll,"_",(function (elem,offset,local_pos){
var intents = cljs.core.some((function (p1__11922_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__11922_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._scroll(p1__11922_SHARP_,offset,local_pos__$1));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IMouseEvent,"_",true);

goog.object.set(membrane.ui._mouse_event,"_",(function (elem,local_pos,button,mouse_down_QMARK_,mods){
var intents = cljs.core.some((function (p1__11920_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__11920_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_event(p1__11920_SHARP_,local_pos__$1,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IKeyEvent,"_",true);

goog.object.set(membrane.ui._key_event,"_",(function (this$,key,scancode,action,mods){
var intents = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__11925_SHARP_){
return membrane.ui._key_event(p1__11925_SHARP_,key,scancode,action,mods);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$))], 0));
return membrane.ui._bubble(this$,intents);
}));

goog.object.set(membrane.ui.IKeyPress,"_",true);

goog.object.set(membrane.ui._key_press,"_",(function (this$,info){
var intents = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__11924_SHARP_){
return membrane.ui._key_press(p1__11924_SHARP_,info);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$))], 0));
return membrane.ui._bubble(this$,intents);
}));

goog.object.set(membrane.ui.IBubble,"_",true);

goog.object.set(membrane.ui._bubble,"_",(function (this$,intents){
return intents;
}));

goog.object.set(membrane.ui.IMouseMove,"_",true);

goog.object.set(membrane.ui._mouse_move,"_",(function (elem,local_pos){
var intents = cljs.core.some((function (p1__11921_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__11921_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_move(p1__11921_SHARP_,local_pos__$1));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IDrop,"_",true);

goog.object.set(membrane.ui._drop,"_",(function (elem,paths,local_pos){
var intents = cljs.core.some((function (p1__11923_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__11923_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._drop(p1__11923_SHARP_,paths,local_pos__$1));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IMouseMoveGlobal,"_",true);

goog.object.set(membrane.ui._mouse_move_global,"_",(function (this$,offset){
return membrane.ui._default_mouse_move_global(this$,offset);
}));

goog.object.set(membrane.ui.IHasKeyEvent,"_",true);

goog.object.set(membrane.ui.has_key_event,"_",(function (this$){
return cljs.core.some(membrane.ui.has_key_event,(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$)));
}));
membrane.ui.SHIFT_MASK = (1);
membrane.ui.CONTROL_MASK = (2);
membrane.ui.ALT_MASK = (4);
membrane.ui.SUPER_MASK = (8);
membrane.ui.CAPS_LOCK_MASK = (16);
membrane.ui.NUM_LOCK_MASK = (32);
if((typeof membrane !== 'undefined') && (typeof membrane.ui !== 'undefined') && (typeof membrane.ui.default_draw_impls !== 'undefined')){
} else {
membrane.ui.default_draw_impls = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,null,(function (draw){
return (function (this$){
return null;
});
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,cljs.core.PersistentVector,(function (draw){
return (function (this$){
var seq__11926 = cljs.core.seq(this$);
var chunk__11927 = null;
var count__11928 = (0);
var i__11929 = (0);
while(true){
if((i__11929 < count__11928)){
var drawable = chunk__11927.cljs$core$IIndexed$_nth$arity$2(null,i__11929);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__13540 = seq__11926;
var G__13541 = chunk__11927;
var G__13542 = count__11928;
var G__13543 = (i__11929 + (1));
seq__11926 = G__13540;
chunk__11927 = G__13541;
count__11928 = G__13542;
i__11929 = G__13543;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__11926);
if(temp__5735__auto__){
var seq__11926__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11926__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__11926__$1);
var G__13544 = cljs.core.chunk_rest(seq__11926__$1);
var G__13545 = c__4556__auto__;
var G__13546 = cljs.core.count(c__4556__auto__);
var G__13547 = (0);
seq__11926 = G__13544;
chunk__11927 = G__13545;
count__11928 = G__13546;
i__11929 = G__13547;
continue;
} else {
var drawable = cljs.core.first(seq__11926__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__13548 = cljs.core.next(seq__11926__$1);
var G__13549 = null;
var G__13550 = (0);
var G__13551 = (0);
seq__11926 = G__13548;
chunk__11927 = G__13549;
count__11928 = G__13550;
i__11929 = G__13551;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,new cljs.core.Keyword(null,"default","default",-1987822328),(function (draw){
return (function (this$){
var G__11930 = (membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__11930) : draw.call(null,G__11930));
});
}));

/**
 * @interface
 */
membrane.ui.IBounds = function(){};

var membrane$ui$IBounds$_bounds$dyn_13558 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._bounds[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._bounds["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IBounds.-bounds",elem);
}
}
});
/**
 * Returns a 2 element vector with the [width, height] of an element's bounds with respect to its origin
 */
membrane.ui._bounds = (function membrane$ui$_bounds(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IBounds$_bounds$arity$1 == null)))))){
return elem.membrane$ui$IBounds$_bounds$arity$1(elem);
} else {
return membrane$ui$IBounds$_bounds$dyn_13558(elem);
}
});

/**
 * Returns a 2 element vector with the [width, height] of an element's bounds with respect to its origin
 */
membrane.ui.bounds = cljs.core.memoize((function (p1__11931_SHARP_){
return membrane.ui._bounds(p1__11931_SHARP_);
}));
(cljs.core.PersistentVector.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__11932,elem){
var vec__11933 = p__11932;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11933,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11933,(1),null);
var vec__11936 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11936,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11936,(1),null);
var vec__11939 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11939,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11939,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),this$__$1);
}));

goog.object.set(membrane.ui.IBounds,"null",true);

goog.object.set(membrane.ui._bounds,"null",(function (this$){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));
/**
 * Returns a memoized version of a referentially transparent function. The
 *   memoized version of the function keeps a cache of the mapping from arguments
 *   to results and, when calls with the same arguments are repeated often, has
 *   higher performance at the expense of higher memory use.
 */
membrane.ui.memoize_var = (function membrane$ui$memoize_var(f){
var mem = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
return (function() { 
var G__13583__delegate = function (args){
var temp__5733__auto__ = cljs.core.find(cljs.core.deref(mem),args);
if(cljs.core.truth_(temp__5733__auto__)){
var e = temp__5733__auto__;
return cljs.core.val(e);
} else {
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
mem.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(mem.cljs$core$IDeref$_deref$arity$1(null),args,ret));

return ret;
}
};
var G__13583 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__13588__i = 0, G__13588__a = new Array(arguments.length -  0);
while (G__13588__i < G__13588__a.length) {G__13588__a[G__13588__i] = arguments[G__13588__i + 0]; ++G__13588__i;}
  args = new cljs.core.IndexedSeq(G__13588__a,0,null);
} 
return G__13583__delegate.call(this,args);};
G__13583.cljs$lang$maxFixedArity = 0;
G__13583.cljs$lang$applyTo = (function (arglist__13589){
var args = cljs.core.seq(arglist__13589);
return G__13583__delegate(args);
});
G__13583.cljs$core$IFn$_invoke$arity$variadic = G__13583__delegate;
return G__13583;
})()
;
});

/**
 * @interface
 */
membrane.ui.IChildren = function(){};

var membrane$ui$IChildren$_children$dyn_13595 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._children[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._children["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IChildren.-children",elem);
}
}
});
/**
 * Returns sub elements of elem. Useful for traversal.
 */
membrane.ui._children = (function membrane$ui$_children(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IChildren$_children$arity$1 == null)))))){
return elem.membrane$ui$IChildren$_children$arity$1(elem);
} else {
return membrane$ui$IChildren$_children$dyn_13595(elem);
}
});

(cljs.core.PersistentVector.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));

goog.object.set(membrane.ui.IChildren,"null",true);

goog.object.set(membrane.ui._children,"null",(function (this$){
return null;
}));
goog.object.set(membrane.ui.IChildren,"_",true);

goog.object.set(membrane.ui._children,"_",(function (this$){
return null;
}));
/**
 * Returns sub elements of elem. Useful for traversal.
 */
membrane.ui.children = (function membrane$ui$children(elem){
return membrane.ui._children(elem);
});
/**
 * Returns the width of elem.
 */
membrane.ui.width = (function membrane$ui$width(elem){
var vec__11942 = membrane.ui.bounds(elem);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11942,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11942,(1),null);
return width;
});
/**
 * Returns the height of elem.
 */
membrane.ui.height = (function membrane$ui$height(elem){
var vec__11945 = membrane.ui.bounds(elem);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11945,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11945,(1),null);
return height;
});
/**
 * Returns the effects of a mouse move event on elem. Will only call -mouse-move on mouse events within an elements bounds.
 */
membrane.ui.mouse_move = (function membrane$ui$mouse_move(elem,pos){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._mouse_move(elem,local_pos);
} else {
return null;
}
});
/**
 * Returns the effects of a mouse move event on elem. Will -mouse-move-global for all elements and their children.
 */
membrane.ui.mouse_move_global = (function membrane$ui$mouse_move_global(elem,global_pos){
return membrane.ui._mouse_move_global(elem,global_pos);
});
membrane.ui.mouse_event = (function membrane$ui$mouse_event(elem,pos,button,mouse_down_QMARK_,mods){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._mouse_event(elem,local_pos,button,mouse_down_QMARK_,mods);
} else {
return null;
}
});
/**
 * Returns the effects of a mouse down event on elem. Will only call -mouse-event or -mouse-down if the position is in the element's bounds.
 */
membrane.ui.mouse_down = (function membrane$ui$mouse_down(elem,p__11948){
var vec__11949 = p__11948;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11949,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11949,(1),null);
var pos = vec__11949;
return membrane.ui.mouse_event(elem,pos,(0),true,(0));
});
/**
 * Returns the effects of a mouse up event on elem. Will only call -mouse-event or -mouse-down if the position is in the element's bounds.
 */
membrane.ui.mouse_up = (function membrane$ui$mouse_up(elem,p__11952){
var vec__11953 = p__11952;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11953,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11953,(1),null);
var pos = vec__11953;
return membrane.ui.mouse_event(elem,pos,(0),false,(0));
});
membrane.ui.drop = (function membrane$ui$drop(elem,paths,pos){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._drop(elem,paths,local_pos);
} else {
return null;
}
});
membrane.ui.scroll = (function membrane$ui$scroll(elem,offset,pos){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._scroll(elem,offset,local_pos);
} else {
return null;
}
});
/**
 * Returns the effects of a key press event on elem.
 * @param {...*} var_args
 */
membrane.ui.key_press = (function() { 
var membrane$ui$handler__9804__auto____delegate = function (elem__9805__auto__,args__9806__auto__){
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IKeyPress$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyPress,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyPress,elem__9805__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._key_press,elem__9805__auto__,args__9806__auto__);
} else {
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IChildren$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__))){
var intents__9807__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9803__9808__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__9804__auto__,p1__9803__9808__auto__,args__9806__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__9805__auto__));
return membrane.ui._bubble(elem__9805__auto__,intents__9807__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__9804__auto__ = function (elem__9805__auto__,var_args){
var args__9806__auto__ = null;
if (arguments.length > 1) {
var G__13617__i = 0, G__13617__a = new Array(arguments.length -  1);
while (G__13617__i < G__13617__a.length) {G__13617__a[G__13617__i] = arguments[G__13617__i + 1]; ++G__13617__i;}
  args__9806__auto__ = new cljs.core.IndexedSeq(G__13617__a,0,null);
} 
return membrane$ui$handler__9804__auto____delegate.call(this,elem__9805__auto__,args__9806__auto__);};
membrane$ui$handler__9804__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__9804__auto__.cljs$lang$applyTo = (function (arglist__13619){
var elem__9805__auto__ = cljs.core.first(arglist__13619);
var args__9806__auto__ = cljs.core.rest(arglist__13619);
return membrane$ui$handler__9804__auto____delegate(elem__9805__auto__,args__9806__auto__);
});
membrane$ui$handler__9804__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__9804__auto____delegate;
return membrane$ui$handler__9804__auto__;
})()
;
/**
 * Returns the effects of a key event on elem.
 * @param {...*} var_args
 */
membrane.ui.key_event = (function() { 
var membrane$ui$handler__9804__auto____delegate = function (elem__9805__auto__,args__9806__auto__){
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IKeyEvent$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyEvent,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyEvent,elem__9805__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._key_event,elem__9805__auto__,args__9806__auto__);
} else {
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IChildren$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__))){
var intents__9807__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9803__9808__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__9804__auto__,p1__9803__9808__auto__,args__9806__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__9805__auto__));
return membrane.ui._bubble(elem__9805__auto__,intents__9807__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__9804__auto__ = function (elem__9805__auto__,var_args){
var args__9806__auto__ = null;
if (arguments.length > 1) {
var G__13629__i = 0, G__13629__a = new Array(arguments.length -  1);
while (G__13629__i < G__13629__a.length) {G__13629__a[G__13629__i] = arguments[G__13629__i + 1]; ++G__13629__i;}
  args__9806__auto__ = new cljs.core.IndexedSeq(G__13629__a,0,null);
} 
return membrane$ui$handler__9804__auto____delegate.call(this,elem__9805__auto__,args__9806__auto__);};
membrane$ui$handler__9804__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__9804__auto__.cljs$lang$applyTo = (function (arglist__13630){
var elem__9805__auto__ = cljs.core.first(arglist__13630);
var args__9806__auto__ = cljs.core.rest(arglist__13630);
return membrane$ui$handler__9804__auto____delegate(elem__9805__auto__,args__9806__auto__);
});
membrane$ui$handler__9804__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__9804__auto____delegate;
return membrane$ui$handler__9804__auto__;
})()
;
/**
 * Returns the effects of a clipboard cut event on elem.
 * @param {...*} var_args
 */
membrane.ui.clipboard_cut = (function() { 
var membrane$ui$handler__9804__auto____delegate = function (elem__9805__auto__,args__9806__auto__){
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IClipboardCut$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCut,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCut,elem__9805__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._clipboard_cut,elem__9805__auto__,args__9806__auto__);
} else {
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IChildren$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__))){
var intents__9807__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9803__9808__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__9804__auto__,p1__9803__9808__auto__,args__9806__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__9805__auto__));
return membrane.ui._bubble(elem__9805__auto__,intents__9807__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__9804__auto__ = function (elem__9805__auto__,var_args){
var args__9806__auto__ = null;
if (arguments.length > 1) {
var G__13651__i = 0, G__13651__a = new Array(arguments.length -  1);
while (G__13651__i < G__13651__a.length) {G__13651__a[G__13651__i] = arguments[G__13651__i + 1]; ++G__13651__i;}
  args__9806__auto__ = new cljs.core.IndexedSeq(G__13651__a,0,null);
} 
return membrane$ui$handler__9804__auto____delegate.call(this,elem__9805__auto__,args__9806__auto__);};
membrane$ui$handler__9804__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__9804__auto__.cljs$lang$applyTo = (function (arglist__13652){
var elem__9805__auto__ = cljs.core.first(arglist__13652);
var args__9806__auto__ = cljs.core.rest(arglist__13652);
return membrane$ui$handler__9804__auto____delegate(elem__9805__auto__,args__9806__auto__);
});
membrane$ui$handler__9804__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__9804__auto____delegate;
return membrane$ui$handler__9804__auto__;
})()
;
/**
 * Returns the effects of a clipboard copy event on elem.
 * @param {...*} var_args
 */
membrane.ui.clipboard_copy = (function() { 
var membrane$ui$handler__9804__auto____delegate = function (elem__9805__auto__,args__9806__auto__){
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IClipboardCopy$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCopy,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCopy,elem__9805__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._clipboard_copy,elem__9805__auto__,args__9806__auto__);
} else {
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IChildren$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__))){
var intents__9807__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9803__9808__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__9804__auto__,p1__9803__9808__auto__,args__9806__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__9805__auto__));
return membrane.ui._bubble(elem__9805__auto__,intents__9807__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__9804__auto__ = function (elem__9805__auto__,var_args){
var args__9806__auto__ = null;
if (arguments.length > 1) {
var G__13654__i = 0, G__13654__a = new Array(arguments.length -  1);
while (G__13654__i < G__13654__a.length) {G__13654__a[G__13654__i] = arguments[G__13654__i + 1]; ++G__13654__i;}
  args__9806__auto__ = new cljs.core.IndexedSeq(G__13654__a,0,null);
} 
return membrane$ui$handler__9804__auto____delegate.call(this,elem__9805__auto__,args__9806__auto__);};
membrane$ui$handler__9804__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__9804__auto__.cljs$lang$applyTo = (function (arglist__13655){
var elem__9805__auto__ = cljs.core.first(arglist__13655);
var args__9806__auto__ = cljs.core.rest(arglist__13655);
return membrane$ui$handler__9804__auto____delegate(elem__9805__auto__,args__9806__auto__);
});
membrane$ui$handler__9804__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__9804__auto____delegate;
return membrane$ui$handler__9804__auto__;
})()
;
/**
 * Returns the effects of a clipboard paste event on elem.
 * @param {...*} var_args
 */
membrane.ui.clipboard_paste = (function() { 
var membrane$ui$handler__9804__auto____delegate = function (elem__9805__auto__,args__9806__auto__){
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IClipboardPaste$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardPaste,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardPaste,elem__9805__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._clipboard_paste,elem__9805__auto__,args__9806__auto__);
} else {
if((((!((elem__9805__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__9805__auto__.membrane$ui$IChildren$))))?true:(((!elem__9805__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__9805__auto__))){
var intents__9807__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9803__9808__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__9804__auto__,p1__9803__9808__auto__,args__9806__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__9805__auto__));
return membrane.ui._bubble(elem__9805__auto__,intents__9807__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__9804__auto__ = function (elem__9805__auto__,var_args){
var args__9806__auto__ = null;
if (arguments.length > 1) {
var G__13656__i = 0, G__13656__a = new Array(arguments.length -  1);
while (G__13656__i < G__13656__a.length) {G__13656__a[G__13656__i] = arguments[G__13656__i + 1]; ++G__13656__i;}
  args__9806__auto__ = new cljs.core.IndexedSeq(G__13656__a,0,null);
} 
return membrane$ui$handler__9804__auto____delegate.call(this,elem__9805__auto__,args__9806__auto__);};
membrane$ui$handler__9804__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__9804__auto__.cljs$lang$applyTo = (function (arglist__13657){
var elem__9805__auto__ = cljs.core.first(arglist__13657);
var args__9806__auto__ = cljs.core.rest(arglist__13657);
return membrane$ui$handler__9804__auto____delegate(elem__9805__auto__,args__9806__auto__);
});
membrane$ui$handler__9804__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__9804__auto____delegate;
return membrane$ui$handler__9804__auto__;
})()
;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Label = (function (text,font,__meta,__extmap,__hash){
this.text = text;
this.font = font;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Label.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Label.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k11973,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__11977 = k11973;
var G__11977__$1 = (((G__11977 instanceof cljs.core.Keyword))?G__11977.fqn:null);
switch (G__11977__$1) {
case "text":
return self__.text;

break;
case "font":
return self__.font;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k11973,else__4383__auto__);

}
}));

(membrane.ui.Label.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__11978){
var vec__11979 = p__11978;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11979,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11979,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Label.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Label{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"font","font",-1506159249),self__.font],null))], null),self__.__extmap));
}));

(membrane.ui.Label.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11972){
var self__ = this;
var G__11972__$1 = this;
return (new cljs.core.RecordIter((0),G__11972__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"font","font",-1506159249)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Label.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Label.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Label(self__.text,self__.font,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Label.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Label.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1431250007 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Label.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this11974,other11975){
var self__ = this;
var this11974__$1 = this;
return (((!((other11975 == null)))) && ((this11974__$1.constructor === other11975.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11974__$1.text,other11975.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11974__$1.font,other11975.font)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11974__$1.__extmap,other11975.__extmap)));
}));

(membrane.ui.Label.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Label.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Label.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font","font",-1506159249),null,new cljs.core.Keyword(null,"text","text",-1790561697),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Label(self__.text,self__.font,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Label.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__11972){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__11982 = cljs.core.keyword_identical_QMARK_;
var expr__11983 = k__4388__auto__;
if(cljs.core.truth_((pred__11982.cljs$core$IFn$_invoke$arity$2 ? pred__11982.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__11983) : pred__11982.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__11983)))){
return (new membrane.ui.Label(G__11972,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__11982.cljs$core$IFn$_invoke$arity$2 ? pred__11982.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"font","font",-1506159249),expr__11983) : pred__11982.call(null,new cljs.core.Keyword(null,"font","font",-1506159249),expr__11983)))){
return (new membrane.ui.Label(self__.text,G__11972,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Label(self__.text,self__.font,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__11972),null));
}
}
}));

(membrane.ui.Label.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"font","font",-1506159249),self__.font,null))], null),self__.__extmap));
}));

(membrane.ui.Label.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__11972){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Label(self__.text,self__.font,G__11972,self__.__extmap,self__.__hash));
}));

(membrane.ui.Label.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Label.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"font","font",134372278,null)], null);
}));

(membrane.ui.Label.cljs$lang$type = true);

(membrane.ui.Label.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Label",null,(1),null));
}));

(membrane.ui.Label.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Label");
}));

/**
 * Positional factory function for membrane.ui/Label.
 */
membrane.ui.__GT_Label = (function membrane$ui$__GT_Label(text,font){
return (new membrane.ui.Label(text,font,null,null,null));
});

/**
 * Factory function for membrane.ui/Label, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Label = (function membrane$ui$map__GT_Label(G__11976){
var extmap__4419__auto__ = (function (){var G__11985 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__11976,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"font","font",-1506159249)], 0));
if(cljs.core.record_QMARK_(G__11976)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__11985);
} else {
return G__11985;
}
})();
return (new membrane.ui.Label(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__11976),new cljs.core.Keyword(null,"font","font",-1506159249).cljs$core$IFn$_invoke$arity$1(G__11976),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that can draw text.
 * 
 *   label will use the default line spacing for newline.
 *   font should be a membrane.ui.Font
 */
membrane.ui.label = (function membrane$ui$label(var_args){
var G__11987 = arguments.length;
switch (G__11987) {
case 1:
return membrane.ui.label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.label.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.label.cljs$core$IFn$_invoke$arity$1 = (function (text){
return membrane.ui.label.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),membrane.ui.default_font);
}));

(membrane.ui.label.cljs$core$IFn$_invoke$arity$2 = (function (text,font){
return (new membrane.ui.Label(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),font,null,null,null));
}));

(membrane.ui.label.cljs$lang$maxFixedArity = 2);

membrane.ui.pr_label = (function membrane$ui$pr_label(var_args){
var G__11989 = arguments.length;
switch (G__11989) {
case 1:
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$1 = (function (x){
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$2(x,(30));
}));

(membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$2 = (function (x,max_length){
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$3(x,max_length,null);
}));

(membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$3 = (function (x,max_length,font){
var s = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
var s__$1 = (cljs.core.truth_(max_length)?cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(function (){var x__4217__auto__ = max_length;
var y__4218__auto__ = ((s).length);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})()):s);
return membrane.ui.label.cljs$core$IFn$_invoke$arity$2(s__$1,(function (){var or__4126__auto__ = font;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return membrane.ui.default_font;
}
})());
}));

(membrane.ui.pr_label.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.TextSelection = (function (text,selection,font,__meta,__extmap,__hash){
this.text = text;
this.selection = selection;
this.font = font;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.TextSelection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.TextSelection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k11991,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__11995 = k11991;
var G__11995__$1 = (((G__11995 instanceof cljs.core.Keyword))?G__11995.fqn:null);
switch (G__11995__$1) {
case "text":
return self__.text;

break;
case "selection":
return self__.selection;

break;
case "font":
return self__.font;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k11991,else__4383__auto__);

}
}));

(membrane.ui.TextSelection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__11996){
var vec__11997 = p__11996;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11997,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11997,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.TextSelection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.TextSelection{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"selection","selection",975998651),self__.selection],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"font","font",-1506159249),self__.font],null))], null),self__.__extmap));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__11990){
var self__ = this;
var G__11990__$1 = this;
return (new cljs.core.RecordIter((0),G__11990__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"selection","selection",975998651),new cljs.core.Keyword(null,"font","font",-1506159249)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.TextSelection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextSelection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-112814428 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.TextSelection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this11992,other11993){
var self__ = this;
var this11992__$1 = this;
return (((!((other11993 == null)))) && ((this11992__$1.constructor === other11993.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11992__$1.text,other11993.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11992__$1.selection,other11993.selection)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11992__$1.font,other11993.font)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this11992__$1.__extmap,other11993.__extmap)));
}));

(membrane.ui.TextSelection.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TextSelection.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.TextSelection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font","font",-1506159249),null,new cljs.core.Keyword(null,"selection","selection",975998651),null,new cljs.core.Keyword(null,"text","text",-1790561697),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.TextSelection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__11990){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12000 = cljs.core.keyword_identical_QMARK_;
var expr__12001 = k__4388__auto__;
if(cljs.core.truth_((pred__12000.cljs$core$IFn$_invoke$arity$2 ? pred__12000.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__12001) : pred__12000.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__12001)))){
return (new membrane.ui.TextSelection(G__11990,self__.selection,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12000.cljs$core$IFn$_invoke$arity$2 ? pred__12000.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"selection","selection",975998651),expr__12001) : pred__12000.call(null,new cljs.core.Keyword(null,"selection","selection",975998651),expr__12001)))){
return (new membrane.ui.TextSelection(self__.text,G__11990,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12000.cljs$core$IFn$_invoke$arity$2 ? pred__12000.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"font","font",-1506159249),expr__12001) : pred__12000.call(null,new cljs.core.Keyword(null,"font","font",-1506159249),expr__12001)))){
return (new membrane.ui.TextSelection(self__.text,self__.selection,G__11990,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__11990),null));
}
}
}
}));

(membrane.ui.TextSelection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"selection","selection",975998651),self__.selection,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"font","font",-1506159249),self__.font,null))], null),self__.__extmap));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__11990){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,G__11990,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextSelection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.TextSelection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"selection","selection",-1678437118,null),new cljs.core.Symbol(null,"font","font",134372278,null)], null);
}));

(membrane.ui.TextSelection.cljs$lang$type = true);

(membrane.ui.TextSelection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/TextSelection",null,(1),null));
}));

(membrane.ui.TextSelection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/TextSelection");
}));

/**
 * Positional factory function for membrane.ui/TextSelection.
 */
membrane.ui.__GT_TextSelection = (function membrane$ui$__GT_TextSelection(text,selection,font){
return (new membrane.ui.TextSelection(text,selection,font,null,null,null));
});

/**
 * Factory function for membrane.ui/TextSelection, taking a map of keywords to field values.
 */
membrane.ui.map__GT_TextSelection = (function membrane$ui$map__GT_TextSelection(G__11994){
var extmap__4419__auto__ = (function (){var G__12003 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__11994,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"selection","selection",975998651),new cljs.core.Keyword(null,"font","font",-1506159249)], 0));
if(cljs.core.record_QMARK_(G__11994)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12003);
} else {
return G__12003;
}
})();
return (new membrane.ui.TextSelection(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__11994),new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(G__11994),new cljs.core.Keyword(null,"font","font",-1506159249).cljs$core$IFn$_invoke$arity$1(G__11994),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem for drawing a selection of text.
 */
membrane.ui.text_selection = (function membrane$ui$text_selection(var_args){
var G__12005 = arguments.length;
switch (G__12005) {
case 2:
return membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$2 = (function (text,p__12006){
var vec__12007 = p__12006;
var selection_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12007,(0),null);
var selection_end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12007,(1),null);
var selection = vec__12007;
return (new membrane.ui.TextSelection(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),selection,membrane.ui.default_font,null,null,null));
}));

(membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$3 = (function (text,p__12010,font){
var vec__12011 = p__12010;
var selection_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12011,(0),null);
var selection_end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12011,(1),null);
var selection = vec__12011;
return (new membrane.ui.TextSelection(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),selection,font,null,null,null));
}));

(membrane.ui.text_selection.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.TextCursor = (function (text,cursor,font,__meta,__extmap,__hash){
this.text = text;
this.cursor = cursor;
this.font = font;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.TextCursor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.TextCursor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12015,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12019 = k12015;
var G__12019__$1 = (((G__12019 instanceof cljs.core.Keyword))?G__12019.fqn:null);
switch (G__12019__$1) {
case "text":
return self__.text;

break;
case "cursor":
return self__.cursor;

break;
case "font":
return self__.font;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12015,else__4383__auto__);

}
}));

(membrane.ui.TextCursor.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12020){
var vec__12021 = p__12020;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12021,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12021,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.TextCursor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.TextCursor{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cursor","cursor",1011937484),self__.cursor],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"font","font",-1506159249),self__.font],null))], null),self__.__extmap));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12014){
var self__ = this;
var G__12014__$1 = this;
return (new cljs.core.RecordIter((0),G__12014__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"font","font",-1506159249)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.TextCursor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextCursor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (976138570 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.TextCursor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12016,other12017){
var self__ = this;
var this12016__$1 = this;
return (((!((other12017 == null)))) && ((this12016__$1.constructor === other12017.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12016__$1.text,other12017.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12016__$1.cursor,other12017.cursor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12016__$1.font,other12017.font)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12016__$1.__extmap,other12017.__extmap)));
}));

(membrane.ui.TextCursor.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TextCursor.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.TextCursor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),null,new cljs.core.Keyword(null,"font","font",-1506159249),null,new cljs.core.Keyword(null,"text","text",-1790561697),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.TextCursor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12014){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12024 = cljs.core.keyword_identical_QMARK_;
var expr__12025 = k__4388__auto__;
if(cljs.core.truth_((pred__12024.cljs$core$IFn$_invoke$arity$2 ? pred__12024.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__12025) : pred__12024.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__12025)))){
return (new membrane.ui.TextCursor(G__12014,self__.cursor,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12024.cljs$core$IFn$_invoke$arity$2 ? pred__12024.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"cursor","cursor",1011937484),expr__12025) : pred__12024.call(null,new cljs.core.Keyword(null,"cursor","cursor",1011937484),expr__12025)))){
return (new membrane.ui.TextCursor(self__.text,G__12014,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12024.cljs$core$IFn$_invoke$arity$2 ? pred__12024.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"font","font",-1506159249),expr__12025) : pred__12024.call(null,new cljs.core.Keyword(null,"font","font",-1506159249),expr__12025)))){
return (new membrane.ui.TextCursor(self__.text,self__.cursor,G__12014,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12014),null));
}
}
}
}));

(membrane.ui.TextCursor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"cursor","cursor",1011937484),self__.cursor,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"font","font",-1506159249),self__.font,null))], null),self__.__extmap));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12014){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,G__12014,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextCursor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.TextCursor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"font","font",134372278,null)], null);
}));

(membrane.ui.TextCursor.cljs$lang$type = true);

(membrane.ui.TextCursor.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/TextCursor",null,(1),null));
}));

(membrane.ui.TextCursor.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/TextCursor");
}));

/**
 * Positional factory function for membrane.ui/TextCursor.
 */
membrane.ui.__GT_TextCursor = (function membrane$ui$__GT_TextCursor(text,cursor,font){
return (new membrane.ui.TextCursor(text,cursor,font,null,null,null));
});

/**
 * Factory function for membrane.ui/TextCursor, taking a map of keywords to field values.
 */
membrane.ui.map__GT_TextCursor = (function membrane$ui$map__GT_TextCursor(G__12018){
var extmap__4419__auto__ = (function (){var G__12027 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12018,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"font","font",-1506159249)], 0));
if(cljs.core.record_QMARK_(G__12018)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12027);
} else {
return G__12027;
}
})();
return (new membrane.ui.TextCursor(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__12018),new cljs.core.Keyword(null,"cursor","cursor",1011937484).cljs$core$IFn$_invoke$arity$1(G__12018),new cljs.core.Keyword(null,"font","font",-1506159249).cljs$core$IFn$_invoke$arity$1(G__12018),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that can draw a text cursor
 * 
 * font should be a membrane.ui.Font
 */
membrane.ui.text_cursor = (function membrane$ui$text_cursor(var_args){
var G__12029 = arguments.length;
switch (G__12029) {
case 2:
return membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$2 = (function (text,cursor){
return (new membrane.ui.TextCursor(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),cursor,membrane.ui.default_font,null,null,null));
}));

(membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$3 = (function (text,cursor,font){
return (new membrane.ui.TextCursor(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),cursor,font,null,null,null));
}));

(membrane.ui.text_cursor.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Image = (function (image_path,size,opacity,__meta,__extmap,__hash){
this.image_path = image_path;
this.size = size;
this.opacity = opacity;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Image.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Image.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12031,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12035 = k12031;
var G__12035__$1 = (((G__12035 instanceof cljs.core.Keyword))?G__12035.fqn:null);
switch (G__12035__$1) {
case "image-path":
return self__.image_path;

break;
case "size":
return self__.size;

break;
case "opacity":
return self__.opacity;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12031,else__4383__auto__);

}
}));

(membrane.ui.Image.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12036){
var vec__12037 = p__12036;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12037,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12037,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Image.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Image{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"image-path","image-path",-348638603),self__.image_path],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opacity","opacity",397153780),self__.opacity],null))], null),self__.__extmap));
}));

(membrane.ui.Image.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12030){
var self__ = this;
var G__12030__$1 = this;
return (new cljs.core.RecordIter((0),G__12030__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"image-path","image-path",-348638603),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"opacity","opacity",397153780)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Image.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Image.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.size;
}));

(membrane.ui.Image.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Image.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Image.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Image.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1465189816 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Image.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12032,other12033){
var self__ = this;
var this12032__$1 = this;
return (((!((other12033 == null)))) && ((this12032__$1.constructor === other12033.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12032__$1.image_path,other12033.image_path)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12032__$1.size,other12033.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12032__$1.opacity,other12033.opacity)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12032__$1.__extmap,other12033.__extmap)));
}));

(membrane.ui.Image.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Image.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Image.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"opacity","opacity",397153780),null,new cljs.core.Keyword(null,"image-path","image-path",-348638603),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Image.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12030){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12040 = cljs.core.keyword_identical_QMARK_;
var expr__12041 = k__4388__auto__;
if(cljs.core.truth_((pred__12040.cljs$core$IFn$_invoke$arity$2 ? pred__12040.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"image-path","image-path",-348638603),expr__12041) : pred__12040.call(null,new cljs.core.Keyword(null,"image-path","image-path",-348638603),expr__12041)))){
return (new membrane.ui.Image(G__12030,self__.size,self__.opacity,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12040.cljs$core$IFn$_invoke$arity$2 ? pred__12040.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),expr__12041) : pred__12040.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__12041)))){
return (new membrane.ui.Image(self__.image_path,G__12030,self__.opacity,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12040.cljs$core$IFn$_invoke$arity$2 ? pred__12040.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"opacity","opacity",397153780),expr__12041) : pred__12040.call(null,new cljs.core.Keyword(null,"opacity","opacity",397153780),expr__12041)))){
return (new membrane.ui.Image(self__.image_path,self__.size,G__12030,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12030),null));
}
}
}
}));

(membrane.ui.Image.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"image-path","image-path",-348638603),self__.image_path,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opacity","opacity",397153780),self__.opacity,null))], null),self__.__extmap));
}));

(membrane.ui.Image.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12030){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,G__12030,self__.__extmap,self__.__hash));
}));

(membrane.ui.Image.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Image.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"image-path","image-path",1291892924,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"opacity","opacity",2037685307,null)], null);
}));

(membrane.ui.Image.cljs$lang$type = true);

(membrane.ui.Image.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Image",null,(1),null));
}));

(membrane.ui.Image.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Image");
}));

/**
 * Positional factory function for membrane.ui/Image.
 */
membrane.ui.__GT_Image = (function membrane$ui$__GT_Image(image_path,size,opacity){
return (new membrane.ui.Image(image_path,size,opacity,null,null,null));
});

/**
 * Factory function for membrane.ui/Image, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Image = (function membrane$ui$map__GT_Image(G__12034){
var extmap__4419__auto__ = (function (){var G__12043 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12034,new cljs.core.Keyword(null,"image-path","image-path",-348638603),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"opacity","opacity",397153780)], 0));
if(cljs.core.record_QMARK_(G__12034)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12043);
} else {
return G__12043;
}
})();
return (new membrane.ui.Image(new cljs.core.Keyword(null,"image-path","image-path",-348638603).cljs$core$IFn$_invoke$arity$1(G__12034),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__12034),new cljs.core.Keyword(null,"opacity","opacity",397153780).cljs$core$IFn$_invoke$arity$1(G__12034),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.image_size = (function membrane$ui$image_size(image_path){
throw (new Error(["Assert failed: ","image size should be replaced by implementation","\n","false"].join('')));

});
/**
 * Graphical element that draws an image.
 * 
 *   `image-path`: using the skia backend, `image-path` can be one of
 *   - a string filename
 *   - a java.net.URL
 *   - a byte array containing the bytes of supported image format
 *   This is useful for drawing images included in a jar. Simply put your image in your resources folder, typically resources.
 *   Draw the images in the jar with `(ui/image (clojure.java.io/resource "filename.png"))`
 * 
 *   The image can be drawn at a different size by supplying a size.
 *   Supply a nil size will use the the original image size.
 * 
 *   The image can be aspect scaled by supply a size with one of the dimensions as nil.
 * 
 *   For example, to draw an image with width 30 with aspect scaling, `(image "path.png" [30 nil])`
 * 
 *   opacity is a float between 0 and 1.
 * 
 *   Allowable image formats may vary by platform, but will typically include png and jpeg.
 *   
 */
membrane.ui.image = (function membrane$ui$image(var_args){
var G__12045 = arguments.length;
switch (G__12045) {
case 1:
return membrane.ui.image.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.image.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.image.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.image.cljs$core$IFn$_invoke$arity$1 = (function (image_path){
return membrane.ui.image.cljs$core$IFn$_invoke$arity$3(image_path,null,null);
}));

(membrane.ui.image.cljs$core$IFn$_invoke$arity$2 = (function (image_path,p__12046){
var vec__12047 = p__12046;
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12047,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12047,(1),null);
var size = vec__12047;
return membrane.ui.image.cljs$core$IFn$_invoke$arity$3(image_path,size,null);
}));

(membrane.ui.image.cljs$core$IFn$_invoke$arity$3 = (function (image_path,p__12050,opacity){
var vec__12051 = p__12050;
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12051,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12051,(1),null);
var size = vec__12051;
var size__$1 = (((size == null))?membrane.ui.image_size(image_path):(function (){var vec__12054 = size;
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12054,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12054,(1),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = w;
if(cljs.core.truth_(and__4115__auto__)){
return h;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [w,h], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = w;
if(cljs.core.truth_(and__4115__auto__)){
return (h == null);
} else {
return and__4115__auto__;
}
})())){
var vec__12057 = membrane.ui.image_size(image_path);
var actual_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12057,(0),null);
var actual_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12057,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [w,(actual_height * (w / (function (){var x__4214__auto__ = (1);
var y__4215__auto__ = actual_width;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()))], null);
} else {
if(cljs.core.truth_((((w == null))?h:false))){
var vec__12060 = membrane.ui.image_size(image_path);
var actual_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12060,(0),null);
var actual_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12060,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(actual_width * (h / (function (){var x__4214__auto__ = (1);
var y__4215__auto__ = actual_height;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})())),h], null);
} else {
return membrane.ui.image_size(image_path);

}
}
}
})());
var opacity__$1 = (((opacity == null))?(1):opacity);
return (new membrane.ui.Image(image_path,size__$1,opacity__$1,null,null,null));
}));

(membrane.ui.image.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Translate = (function (x,y,drawable,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Translate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Translate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12064,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12068 = k12064;
var G__12068__$1 = (((G__12068 instanceof cljs.core.Keyword))?G__12068.fqn:null);
switch (G__12068__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12064,else__4383__auto__);

}
}));

(membrane.ui.Translate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12069){
var vec__12070 = p__12069;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12070,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12070,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Translate.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Translate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Translate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Translate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12063){
var self__ = this;
var G__12063__$1 = this;
return (new cljs.core.RecordIter((0),G__12063__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Translate.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__12073 = membrane.ui.bounds(self__.drawable);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12073,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12073,(1),null);
var vec__12076 = membrane.ui.origin(self__.drawable);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12076,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12076,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(w + ox),(h + oy)], null);
}));

(membrane.ui.Translate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Translate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Translate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Translate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (526052509 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Translate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12065,other12066){
var self__ = this;
var this12065__$1 = this;
return (((!((other12066 == null)))) && ((this12065__$1.constructor === other12066.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12065__$1.x,other12066.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12065__$1.y,other12066.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12065__$1.drawable,other12066.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12065__$1.__extmap,other12066.__extmap)));
}));

(membrane.ui.Translate.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.x,self__.y], null);
}));

(membrane.ui.Translate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Translate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12063){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12079 = cljs.core.keyword_identical_QMARK_;
var expr__12080 = k__4388__auto__;
if(cljs.core.truth_((pred__12079.cljs$core$IFn$_invoke$arity$2 ? pred__12079.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__12080) : pred__12079.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__12080)))){
return (new membrane.ui.Translate(G__12063,self__.y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12079.cljs$core$IFn$_invoke$arity$2 ? pred__12079.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__12080) : pred__12079.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__12080)))){
return (new membrane.ui.Translate(self__.x,G__12063,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12079.cljs$core$IFn$_invoke$arity$2 ? pred__12079.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12080) : pred__12079.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12080)))){
return (new membrane.ui.Translate(self__.x,self__.y,G__12063,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12063),null));
}
}
}
}));

(membrane.ui.Translate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Translate.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Translate(self__.x,self__.y,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Translate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12063){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,G__12063,self__.__extmap,self__.__hash));
}));

(membrane.ui.Translate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Translate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Translate.cljs$lang$type = true);

(membrane.ui.Translate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Translate",null,(1),null));
}));

(membrane.ui.Translate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Translate");
}));

/**
 * Positional factory function for membrane.ui/Translate.
 */
membrane.ui.__GT_Translate = (function membrane$ui$__GT_Translate(x,y,drawable){
return (new membrane.ui.Translate(x,y,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Translate, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Translate = (function membrane$ui$map__GT_Translate(G__12067){
var extmap__4419__auto__ = (function (){var G__12082 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12067,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12067)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12082);
} else {
return G__12082;
}
})();
return (new membrane.ui.Translate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__12067),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__12067),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12067),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * A graphical elem that will shift drawable's origin by x and y and draw it at its new origin.
 */
membrane.ui.translate = (function membrane$ui$translate(x,y,drawable){
return (new membrane.ui.Translate(x,y,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Rotate = (function (degrees,drawable,__meta,__extmap,__hash){
this.degrees = degrees;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Rotate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Rotate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12084,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12088 = k12084;
var G__12088__$1 = (((G__12088 instanceof cljs.core.Keyword))?G__12088.fqn:null);
switch (G__12088__$1) {
case "degrees":
return self__.degrees;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12084,else__4383__auto__);

}
}));

(membrane.ui.Rotate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12089){
var vec__12090 = p__12089;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12090,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12090,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Rotate.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Rotate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Rotate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"degrees","degrees",2015169884),self__.degrees],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Rotate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12083){
var self__ = this;
var G__12083__$1 = this;
return (new cljs.core.RecordIter((0),G__12083__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"degrees","degrees",2015169884),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Rotate.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.Rotate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Rotate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rotate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Rotate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (734720640 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Rotate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12085,other12086){
var self__ = this;
var this12085__$1 = this;
return (((!((other12086 == null)))) && ((this12085__$1.constructor === other12086.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12085__$1.degrees,other12086.degrees)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12085__$1.drawable,other12086.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12085__$1.__extmap,other12086.__extmap)));
}));

(membrane.ui.Rotate.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Rotate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"degrees","degrees",2015169884),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Rotate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12083){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12093 = cljs.core.keyword_identical_QMARK_;
var expr__12094 = k__4388__auto__;
if(cljs.core.truth_((pred__12093.cljs$core$IFn$_invoke$arity$2 ? pred__12093.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"degrees","degrees",2015169884),expr__12094) : pred__12093.call(null,new cljs.core.Keyword(null,"degrees","degrees",2015169884),expr__12094)))){
return (new membrane.ui.Rotate(G__12083,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12093.cljs$core$IFn$_invoke$arity$2 ? pred__12093.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12094) : pred__12093.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12094)))){
return (new membrane.ui.Rotate(self__.degrees,G__12083,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12083),null));
}
}
}));

(membrane.ui.Rotate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"degrees","degrees",2015169884),self__.degrees,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Rotate.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Rotate(self__.degrees,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Rotate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12083){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,G__12083,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rotate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Rotate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"degrees","degrees",-639265885,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Rotate.cljs$lang$type = true);

(membrane.ui.Rotate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Rotate",null,(1),null));
}));

(membrane.ui.Rotate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Rotate");
}));

/**
 * Positional factory function for membrane.ui/Rotate.
 */
membrane.ui.__GT_Rotate = (function membrane$ui$__GT_Rotate(degrees,drawable){
return (new membrane.ui.Rotate(degrees,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Rotate, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Rotate = (function membrane$ui$map__GT_Rotate(G__12087){
var extmap__4419__auto__ = (function (){var G__12096 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12087,new cljs.core.Keyword(null,"degrees","degrees",2015169884),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12087)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12096);
} else {
return G__12096;
}
})();
return (new membrane.ui.Rotate(new cljs.core.Keyword(null,"degrees","degrees",2015169884).cljs$core$IFn$_invoke$arity$1(G__12087),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12087),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.rotate = (function membrane$ui$rotate(degrees,drawable){
return (new membrane.ui.Rotate(degrees,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.AffineTransform = (function (matrix,drawable,__meta,__extmap,__hash){
this.matrix = matrix;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.AffineTransform.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12098,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12102 = k12098;
var G__12102__$1 = (((G__12102 instanceof cljs.core.Keyword))?G__12102.fqn:null);
switch (G__12102__$1) {
case "matrix":
return self__.matrix;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12098,else__4383__auto__);

}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12103){
var vec__12104 = p__12103;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12104,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12104,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.AffineTransform{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"matrix","matrix",803137200),self__.matrix],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12097){
var self__ = this;
var G__12097__$1 = this;
return (new cljs.core.RecordIter((0),G__12097__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"matrix","matrix",803137200),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1520501787 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12099,other12100){
var self__ = this;
var this12099__$1 = this;
return (((!((other12100 == null)))) && ((this12099__$1.constructor === other12100.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12099__$1.matrix,other12100.matrix)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12099__$1.drawable,other12100.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12099__$1.__extmap,other12100.__extmap)));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"matrix","matrix",803137200),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12097){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12107 = cljs.core.keyword_identical_QMARK_;
var expr__12108 = k__4388__auto__;
if(cljs.core.truth_((pred__12107.cljs$core$IFn$_invoke$arity$2 ? pred__12107.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"matrix","matrix",803137200),expr__12108) : pred__12107.call(null,new cljs.core.Keyword(null,"matrix","matrix",803137200),expr__12108)))){
return (new membrane.ui.AffineTransform(G__12097,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12107.cljs$core$IFn$_invoke$arity$2 ? pred__12107.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12108) : pred__12107.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12108)))){
return (new membrane.ui.AffineTransform(self__.matrix,G__12097,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12097),null));
}
}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"matrix","matrix",803137200),self__.matrix,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12097){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,G__12097,self__.__extmap,self__.__hash));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.AffineTransform.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"matrix","matrix",-1851298569,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.AffineTransform.cljs$lang$type = true);

(membrane.ui.AffineTransform.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/AffineTransform",null,(1),null));
}));

(membrane.ui.AffineTransform.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/AffineTransform");
}));

/**
 * Positional factory function for membrane.ui/AffineTransform.
 */
membrane.ui.__GT_AffineTransform = (function membrane$ui$__GT_AffineTransform(matrix,drawable){
return (new membrane.ui.AffineTransform(matrix,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/AffineTransform, taking a map of keywords to field values.
 */
membrane.ui.map__GT_AffineTransform = (function membrane$ui$map__GT_AffineTransform(G__12101){
var extmap__4419__auto__ = (function (){var G__12110 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12101,new cljs.core.Keyword(null,"matrix","matrix",803137200),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12101)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12110);
} else {
return G__12110;
}
})();
return (new membrane.ui.AffineTransform(new cljs.core.Keyword(null,"matrix","matrix",803137200).cljs$core$IFn$_invoke$arity$1(G__12101),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12101),null,cljs.core.not_empty(extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Skew = (function (sx,sy,drawable,__meta,__extmap,__hash){
this.sx = sx;
this.sy = sy;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Skew.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Skew.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12112,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12116 = k12112;
var G__12116__$1 = (((G__12116 instanceof cljs.core.Keyword))?G__12116.fqn:null);
switch (G__12116__$1) {
case "sx":
return self__.sx;

break;
case "sy":
return self__.sy;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12112,else__4383__auto__);

}
}));

(membrane.ui.Skew.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12117){
var vec__12118 = p__12117;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12118,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12118,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Skew.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Skew{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sx","sx",-403071592),self__.sx],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sy","sy",227523849),self__.sy],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Skew.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12111){
var self__ = this;
var G__12111__$1 = this;
return (new cljs.core.RecordIter((0),G__12111__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"sx","sx",-403071592),new cljs.core.Keyword(null,"sy","sy",227523849),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Skew.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Skew.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Skew.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Skew.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1913038515 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Skew.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12113,other12114){
var self__ = this;
var this12113__$1 = this;
return (((!((other12114 == null)))) && ((this12113__$1.constructor === other12114.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12113__$1.sx,other12114.sx)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12113__$1.sy,other12114.sy)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12113__$1.drawable,other12114.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12113__$1.__extmap,other12114.__extmap)));
}));

(membrane.ui.Skew.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"sy","sy",227523849),null,new cljs.core.Keyword(null,"sx","sx",-403071592),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Skew.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12111){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12121 = cljs.core.keyword_identical_QMARK_;
var expr__12122 = k__4388__auto__;
if(cljs.core.truth_((pred__12121.cljs$core$IFn$_invoke$arity$2 ? pred__12121.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"sx","sx",-403071592),expr__12122) : pred__12121.call(null,new cljs.core.Keyword(null,"sx","sx",-403071592),expr__12122)))){
return (new membrane.ui.Skew(G__12111,self__.sy,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12121.cljs$core$IFn$_invoke$arity$2 ? pred__12121.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"sy","sy",227523849),expr__12122) : pred__12121.call(null,new cljs.core.Keyword(null,"sy","sy",227523849),expr__12122)))){
return (new membrane.ui.Skew(self__.sx,G__12111,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12121.cljs$core$IFn$_invoke$arity$2 ? pred__12121.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12122) : pred__12121.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12122)))){
return (new membrane.ui.Skew(self__.sx,self__.sy,G__12111,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12111),null));
}
}
}
}));

(membrane.ui.Skew.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sx","sx",-403071592),self__.sx,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sy","sy",227523849),self__.sy,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Skew.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12111){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,G__12111,self__.__extmap,self__.__hash));
}));

(membrane.ui.Skew.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Skew.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sx","sx",1237459935,null),new cljs.core.Symbol(null,"sy","sy",1868055376,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Skew.cljs$lang$type = true);

(membrane.ui.Skew.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Skew",null,(1),null));
}));

(membrane.ui.Skew.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Skew");
}));

/**
 * Positional factory function for membrane.ui/Skew.
 */
membrane.ui.__GT_Skew = (function membrane$ui$__GT_Skew(sx,sy,drawable){
return (new membrane.ui.Skew(sx,sy,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Skew, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Skew = (function membrane$ui$map__GT_Skew(G__12115){
var extmap__4419__auto__ = (function (){var G__12124 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12115,new cljs.core.Keyword(null,"sx","sx",-403071592),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"sy","sy",227523849),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12115)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12124);
} else {
return G__12124;
}
})();
return (new membrane.ui.Skew(new cljs.core.Keyword(null,"sx","sx",-403071592).cljs$core$IFn$_invoke$arity$1(G__12115),new cljs.core.Keyword(null,"sy","sy",227523849).cljs$core$IFn$_invoke$arity$1(G__12115),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12115),null,cljs.core.not_empty(extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Spacer = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Spacer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Spacer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12126,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12130 = k12126;
var G__12130__$1 = (((G__12130 instanceof cljs.core.Keyword))?G__12130.fqn:null);
switch (G__12130__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12126,else__4383__auto__);

}
}));

(membrane.ui.Spacer.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12131){
var vec__12132 = p__12131;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12132,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12132,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Spacer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Spacer{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(membrane.ui.Spacer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12125){
var self__ = this;
var G__12125__$1 = this;
return (new cljs.core.RecordIter((0),G__12125__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Spacer.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Spacer.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.x,self__.y], null);
}));

(membrane.ui.Spacer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Spacer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Spacer(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Spacer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Spacer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-864303194 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Spacer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12127,other12128){
var self__ = this;
var this12127__$1 = this;
return (((!((other12128 == null)))) && ((this12127__$1.constructor === other12128.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12127__$1.x,other12128.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12127__$1.y,other12128.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12127__$1.__extmap,other12128.__extmap)));
}));

(membrane.ui.Spacer.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Spacer.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Spacer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Spacer(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Spacer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12125){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12135 = cljs.core.keyword_identical_QMARK_;
var expr__12136 = k__4388__auto__;
if(cljs.core.truth_((pred__12135.cljs$core$IFn$_invoke$arity$2 ? pred__12135.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__12136) : pred__12135.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__12136)))){
return (new membrane.ui.Spacer(G__12125,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12135.cljs$core$IFn$_invoke$arity$2 ? pred__12135.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__12136) : pred__12135.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__12136)))){
return (new membrane.ui.Spacer(self__.x,G__12125,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Spacer(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12125),null));
}
}
}));

(membrane.ui.Spacer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(membrane.ui.Spacer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12125){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Spacer(self__.x,self__.y,G__12125,self__.__extmap,self__.__hash));
}));

(membrane.ui.Spacer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Spacer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(membrane.ui.Spacer.cljs$lang$type = true);

(membrane.ui.Spacer.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Spacer",null,(1),null));
}));

(membrane.ui.Spacer.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Spacer");
}));

/**
 * Positional factory function for membrane.ui/Spacer.
 */
membrane.ui.__GT_Spacer = (function membrane$ui$__GT_Spacer(x,y){
return (new membrane.ui.Spacer(x,y,null,null,null));
});

/**
 * Factory function for membrane.ui/Spacer, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Spacer = (function membrane$ui$map__GT_Spacer(G__12129){
var extmap__4419__auto__ = (function (){var G__12138 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12129,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__12129)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12138);
} else {
return G__12138;
}
})();
return (new membrane.ui.Spacer(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__12129),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__12129),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Spacer,(function (draw){
return (function (this$){
return null;
});
}));
/**
 * An empty graphical element with width x and height y.
 * 
 *   Useful for layout.
 */
membrane.ui.spacer = (function membrane$ui$spacer(var_args){
var G__12140 = arguments.length;
switch (G__12140) {
case 1:
return membrane.ui.spacer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.spacer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.spacer.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new membrane.ui.Spacer(x,x,null,null,null));
}));

(membrane.ui.spacer.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new membrane.ui.Spacer(x,y,null,null,null));
}));

(membrane.ui.spacer.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.FixedBounds = (function (size,drawable,__meta,__extmap,__hash){
this.size = size;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.FixedBounds.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12142,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12146 = k12142;
var G__12146__$1 = (((G__12146 instanceof cljs.core.Keyword))?G__12146.fqn:null);
switch (G__12146__$1) {
case "size":
return self__.size;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12142,else__4383__auto__);

}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12147){
var vec__12148 = p__12147;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12148,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12148,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.FixedBounds{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12141){
var self__ = this;
var G__12141__$1 = this;
return (new cljs.core.RecordIter((0),G__12141__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.size;
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (208008287 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12143,other12144){
var self__ = this;
var this12143__$1 = this;
return (((!((other12144 == null)))) && ((this12143__$1.constructor === other12144.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12143__$1.size,other12144.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12143__$1.drawable,other12144.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12143__$1.__extmap,other12144.__extmap)));
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"size","size",1098693007),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12141){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12151 = cljs.core.keyword_identical_QMARK_;
var expr__12152 = k__4388__auto__;
if(cljs.core.truth_((pred__12151.cljs$core$IFn$_invoke$arity$2 ? pred__12151.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),expr__12152) : pred__12151.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__12152)))){
return (new membrane.ui.FixedBounds(G__12141,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12151.cljs$core$IFn$_invoke$arity$2 ? pred__12151.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12152) : pred__12151.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12152)))){
return (new membrane.ui.FixedBounds(self__.size,G__12141,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12141),null));
}
}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.FixedBounds(self__.size,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12141){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,G__12141,self__.__extmap,self__.__hash));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.FixedBounds.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.FixedBounds.cljs$lang$type = true);

(membrane.ui.FixedBounds.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/FixedBounds",null,(1),null));
}));

(membrane.ui.FixedBounds.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/FixedBounds");
}));

/**
 * Positional factory function for membrane.ui/FixedBounds.
 */
membrane.ui.__GT_FixedBounds = (function membrane$ui$__GT_FixedBounds(size,drawable){
return (new membrane.ui.FixedBounds(size,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/FixedBounds, taking a map of keywords to field values.
 */
membrane.ui.map__GT_FixedBounds = (function membrane$ui$map__GT_FixedBounds(G__12145){
var extmap__4419__auto__ = (function (){var G__12154 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12145,new cljs.core.Keyword(null,"size","size",1098693007),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12145)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12154);
} else {
return G__12154;
}
})();
return (new membrane.ui.FixedBounds(new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__12145),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12145),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.FixedBounds,(function (draw){
return (function (this$){
var G__12155 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12155) : draw.call(null,G__12155));
});
}));
membrane.ui.fixed_bounds = (function membrane$ui$fixed_bounds(size,drawable){
return (new membrane.ui.FixedBounds(size,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Padding = (function (top,right,bottom,left,drawable,__meta,__extmap,__hash){
this.top = top;
this.right = right;
this.bottom = bottom;
this.left = left;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Padding.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Padding.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12157,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12161 = k12157;
var G__12161__$1 = (((G__12161 instanceof cljs.core.Keyword))?G__12161.fqn:null);
switch (G__12161__$1) {
case "top":
return self__.top;

break;
case "right":
return self__.right;

break;
case "bottom":
return self__.bottom;

break;
case "left":
return self__.left;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12157,else__4383__auto__);

}
}));

(membrane.ui.Padding.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12162){
var vec__12163 = p__12162;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Padding.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Padding.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Padding{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"top","top",-1856271961),self__.top],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"right","right",-452581833),self__.right],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"bottom","bottom",-1550509018),self__.bottom],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"left","left",-399115937),self__.left],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Padding.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12156){
var self__ = this;
var G__12156__$1 = this;
return (new cljs.core.RecordIter((0),G__12156__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Padding.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__12166 = membrane.ui.bounds(self__.drawable);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12166,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12166,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((w + self__.left) + self__.right),((h + self__.top) + self__.bottom)], null);
}));

(membrane.ui.Padding.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Padding.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Padding.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Padding.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2025201373 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Padding.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12158,other12159){
var self__ = this;
var this12158__$1 = this;
return (((!((other12159 == null)))) && ((this12158__$1.constructor === other12159.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12158__$1.top,other12159.top)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12158__$1.right,other12159.right)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12158__$1.bottom,other12159.bottom)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12158__$1.left,other12159.left)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12158__$1.drawable,other12159.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12158__$1.__extmap,other12159.__extmap)));
}));

(membrane.ui.Padding.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.left,self__.top], null);
}));

(membrane.ui.Padding.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Padding.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12156){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12169 = cljs.core.keyword_identical_QMARK_;
var expr__12170 = k__4388__auto__;
if(cljs.core.truth_((pred__12169.cljs$core$IFn$_invoke$arity$2 ? pred__12169.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"top","top",-1856271961),expr__12170) : pred__12169.call(null,new cljs.core.Keyword(null,"top","top",-1856271961),expr__12170)))){
return (new membrane.ui.Padding(G__12156,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12169.cljs$core$IFn$_invoke$arity$2 ? pred__12169.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"right","right",-452581833),expr__12170) : pred__12169.call(null,new cljs.core.Keyword(null,"right","right",-452581833),expr__12170)))){
return (new membrane.ui.Padding(self__.top,G__12156,self__.bottom,self__.left,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12169.cljs$core$IFn$_invoke$arity$2 ? pred__12169.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"bottom","bottom",-1550509018),expr__12170) : pred__12169.call(null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),expr__12170)))){
return (new membrane.ui.Padding(self__.top,self__.right,G__12156,self__.left,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12169.cljs$core$IFn$_invoke$arity$2 ? pred__12169.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"left","left",-399115937),expr__12170) : pred__12169.call(null,new cljs.core.Keyword(null,"left","left",-399115937),expr__12170)))){
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,G__12156,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12169.cljs$core$IFn$_invoke$arity$2 ? pred__12169.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12170) : pred__12169.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12170)))){
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,G__12156,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12156),null));
}
}
}
}
}
}));

(membrane.ui.Padding.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"top","top",-1856271961),self__.top,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"right","right",-452581833),self__.right,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"bottom","bottom",-1550509018),self__.bottom,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"left","left",-399115937),self__.left,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Padding.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Padding(self__.left,self__.right,self__.bottom,self__.top,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Padding.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12156){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,G__12156,self__.__extmap,self__.__hash));
}));

(membrane.ui.Padding.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Padding.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"top","top",-215740434,null),new cljs.core.Symbol(null,"right","right",1187949694,null),new cljs.core.Symbol(null,"bottom","bottom",90022509,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Padding.cljs$lang$type = true);

(membrane.ui.Padding.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Padding",null,(1),null));
}));

(membrane.ui.Padding.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Padding");
}));

/**
 * Positional factory function for membrane.ui/Padding.
 */
membrane.ui.__GT_Padding = (function membrane$ui$__GT_Padding(top,right,bottom,left,drawable){
return (new membrane.ui.Padding(top,right,bottom,left,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Padding, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Padding = (function membrane$ui$map__GT_Padding(G__12160){
var extmap__4419__auto__ = (function (){var G__12172 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12160,new cljs.core.Keyword(null,"top","top",-1856271961),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12160)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12172);
} else {
return G__12172;
}
})();
return (new membrane.ui.Padding(new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(G__12160),new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(G__12160),new cljs.core.Keyword(null,"bottom","bottom",-1550509018).cljs$core$IFn$_invoke$arity$1(G__12160),new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(G__12160),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12160),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Padding,(function (draw){
return (function (this$){
var G__12173 = membrane.ui.translate(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12173) : draw.call(null,G__12173));
});
}));
membrane.ui.padding = (function membrane$ui$padding(var_args){
var G__12175 = arguments.length;
switch (G__12175) {
case 2:
return membrane.ui.padding.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.padding.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return membrane.ui.padding.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.padding.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
return (new membrane.ui.Padding(p,p,p,p,elem,null,null,null));
}));

(membrane.ui.padding.cljs$core$IFn$_invoke$arity$3 = (function (px,py,elem){
return (new membrane.ui.Padding(py,px,py,px,elem,null,null,null));
}));

(membrane.ui.padding.cljs$core$IFn$_invoke$arity$5 = (function (top,right,bottom,left,elem){
return (new membrane.ui.Padding(top,right,bottom,left,elem,null,null,null));
}));

(membrane.ui.padding.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Path = (function (points,__meta,__extmap,__hash){
this.points = points;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Path.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Path.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12177,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12181 = k12177;
var G__12181__$1 = (((G__12181 instanceof cljs.core.Keyword))?G__12181.fqn:null);
switch (G__12181__$1) {
case "points":
return self__.points;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12177,else__4383__auto__);

}
}));

(membrane.ui.Path.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12182){
var vec__12183 = p__12182;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12183,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12183,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Path.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Path{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"points","points",-1486596883),self__.points],null))], null),self__.__extmap));
}));

(membrane.ui.Path.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12176){
var self__ = this;
var G__12176__$1 = this;
return (new cljs.core.RecordIter((0),G__12176__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"points","points",-1486596883)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Path.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Path.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var maxx = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,self__.points));
var maxy = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,self__.points));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [maxx,maxy], null);
}));

(membrane.ui.Path.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Path.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Path(self__.points,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Path.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Path.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1184185045 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Path.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12178,other12179){
var self__ = this;
var this12178__$1 = this;
return (((!((other12179 == null)))) && ((this12178__$1.constructor === other12179.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12178__$1.points,other12179.points)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12178__$1.__extmap,other12179.__extmap)));
}));

(membrane.ui.Path.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Path.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Path.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"points","points",-1486596883),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Path(self__.points,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Path.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12176){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12186 = cljs.core.keyword_identical_QMARK_;
var expr__12187 = k__4388__auto__;
if(cljs.core.truth_((pred__12186.cljs$core$IFn$_invoke$arity$2 ? pred__12186.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"points","points",-1486596883),expr__12187) : pred__12186.call(null,new cljs.core.Keyword(null,"points","points",-1486596883),expr__12187)))){
return (new membrane.ui.Path(G__12176,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Path(self__.points,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12176),null));
}
}));

(membrane.ui.Path.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"points","points",-1486596883),self__.points,null))], null),self__.__extmap));
}));

(membrane.ui.Path.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12176){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Path(self__.points,G__12176,self__.__extmap,self__.__hash));
}));

(membrane.ui.Path.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Path.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"points","points",153934644,null)], null);
}));

(membrane.ui.Path.cljs$lang$type = true);

(membrane.ui.Path.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Path",null,(1),null));
}));

(membrane.ui.Path.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Path");
}));

/**
 * Positional factory function for membrane.ui/Path.
 */
membrane.ui.__GT_Path = (function membrane$ui$__GT_Path(points){
return (new membrane.ui.Path(points,null,null,null));
});

/**
 * Factory function for membrane.ui/Path, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Path = (function membrane$ui$map__GT_Path(G__12180){
var extmap__4419__auto__ = (function (){var G__12189 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__12180,new cljs.core.Keyword(null,"points","points",-1486596883));
if(cljs.core.record_QMARK_(G__12180)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12189);
} else {
return G__12189;
}
})();
return (new membrane.ui.Path(new cljs.core.Keyword(null,"points","points",-1486596883).cljs$core$IFn$_invoke$arity$1(G__12180),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * A graphical element that will draw lines connecting points.
 * 
 *   See with-style, with-stroke-width, and with-color for more options.
 */
membrane.ui.path = (function membrane$ui$path(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14070 = arguments.length;
var i__4737__auto___14071 = (0);
while(true){
if((i__4737__auto___14071 < len__4736__auto___14070)){
args__4742__auto__.push((arguments[i__4737__auto___14071]));

var G__14072 = (i__4737__auto___14071 + (1));
i__4737__auto___14071 = G__14072;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic = (function (points){
return (new membrane.ui.Path(points,null,null,null));
}));

(membrane.ui.path.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.path.cljs$lang$applyTo = (function (seq12190){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12190));
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.WithColor = (function (color,drawables,__meta,__extmap,__hash){
this.color = color;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.WithColor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.WithColor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12192,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12196 = k12192;
var G__12196__$1 = (((G__12196 instanceof cljs.core.Keyword))?G__12196.fqn:null);
switch (G__12196__$1) {
case "color":
return self__.color;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12192,else__4383__auto__);

}
}));

(membrane.ui.WithColor.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12197){
var vec__12198 = p__12197;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12198,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12198,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.WithColor.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.WithColor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.WithColor{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"color","color",1011675173),self__.color],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.WithColor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12191){
var self__ = this;
var G__12191__$1 = this;
return (new cljs.core.RecordIter((0),G__12191__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.WithColor.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12201,elem){
var vec__12202 = p__12201;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12202,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12202,(1),null);
var vec__12205 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12205,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12205,(1),null);
var vec__12208 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12208,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12208,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.WithColor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.WithColor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.WithColor(self__.color,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithColor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.WithColor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (505438910 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.WithColor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12193,other12194){
var self__ = this;
var this12193__$1 = this;
return (((!((other12194 == null)))) && ((this12193__$1.constructor === other12194.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12193__$1.color,other12194.color)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12193__$1.drawables,other12194.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12193__$1.__extmap,other12194.__extmap)));
}));

(membrane.ui.WithColor.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.WithColor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.WithColor(self__.color,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.WithColor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12191){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12211 = cljs.core.keyword_identical_QMARK_;
var expr__12212 = k__4388__auto__;
if(cljs.core.truth_((pred__12211.cljs$core$IFn$_invoke$arity$2 ? pred__12211.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"color","color",1011675173),expr__12212) : pred__12211.call(null,new cljs.core.Keyword(null,"color","color",1011675173),expr__12212)))){
return (new membrane.ui.WithColor(G__12191,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12211.cljs$core$IFn$_invoke$arity$2 ? pred__12211.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12212) : pred__12211.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12212)))){
return (new membrane.ui.WithColor(self__.color,G__12191,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.WithColor(self__.color,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12191),null));
}
}
}));

(membrane.ui.WithColor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"color","color",1011675173),self__.color,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.WithColor.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.WithColor(self__.color,childs,null,null,null));
}));

(membrane.ui.WithColor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12191){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.WithColor(self__.color,self__.drawables,G__12191,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithColor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.WithColor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"color","color",-1642760596,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.WithColor.cljs$lang$type = true);

(membrane.ui.WithColor.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/WithColor",null,(1),null));
}));

(membrane.ui.WithColor.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/WithColor");
}));

/**
 * Positional factory function for membrane.ui/WithColor.
 */
membrane.ui.__GT_WithColor = (function membrane$ui$__GT_WithColor(color,drawables){
return (new membrane.ui.WithColor(color,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/WithColor, taking a map of keywords to field values.
 */
membrane.ui.map__GT_WithColor = (function membrane$ui$map__GT_WithColor(G__12195){
var extmap__4419__auto__ = (function (){var G__12214 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12195,new cljs.core.Keyword(null,"color","color",1011675173),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12195)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12214);
} else {
return G__12214;
}
})();
return (new membrane.ui.WithColor(new cljs.core.Keyword(null,"color","color",1011675173).cljs$core$IFn$_invoke$arity$1(G__12195),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12195),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Use color for all children. Color is a vector of [r g b] or [r g b a]. All values should be between 0 and 1 inclusive.
 */
membrane.ui.with_color = (function membrane$ui$with_color(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14097 = arguments.length;
var i__4737__auto___14099 = (0);
while(true){
if((i__4737__auto___14099 < len__4736__auto___14097)){
args__4742__auto__.push((arguments[i__4737__auto___14099]));

var G__14100 = (i__4737__auto___14099 + (1));
i__4737__auto___14099 = G__14100;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic = (function (color,drawables){
return (new membrane.ui.WithColor(color,drawables,null,null,null));
}));

(membrane.ui.with_color.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.with_color.cljs$lang$applyTo = (function (seq12215){
var G__12216 = cljs.core.first(seq12215);
var seq12215__$1 = cljs.core.next(seq12215);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12216,seq12215__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.WithStyle = (function (style,drawables,__meta,__extmap,__hash){
this.style = style;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.WithStyle.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.WithStyle.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12218,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12222 = k12218;
var G__12222__$1 = (((G__12222 instanceof cljs.core.Keyword))?G__12222.fqn:null);
switch (G__12222__$1) {
case "style":
return self__.style;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12218,else__4383__auto__);

}
}));

(membrane.ui.WithStyle.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12223){
var vec__12224 = p__12223;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12224,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12224,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.WithStyle.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.WithStyle{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"style","style",-496642736),self__.style],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.WithStyle.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12217){
var self__ = this;
var G__12217__$1 = this;
return (new cljs.core.RecordIter((0),G__12217__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawables);
}));

(membrane.ui.WithStyle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.WithStyle.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.WithStyle(self__.style,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStyle.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.WithStyle.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (542819839 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.WithStyle.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12219,other12220){
var self__ = this;
var this12219__$1 = this;
return (((!((other12220 == null)))) && ((this12219__$1.constructor === other12220.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12219__$1.style,other12220.style)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12219__$1.drawables,other12220.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12219__$1.__extmap,other12220.__extmap)));
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.WithStyle.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"style","style",-496642736),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.WithStyle(self__.style,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.WithStyle.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12217){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12227 = cljs.core.keyword_identical_QMARK_;
var expr__12228 = k__4388__auto__;
if(cljs.core.truth_((pred__12227.cljs$core$IFn$_invoke$arity$2 ? pred__12227.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"style","style",-496642736),expr__12228) : pred__12227.call(null,new cljs.core.Keyword(null,"style","style",-496642736),expr__12228)))){
return (new membrane.ui.WithStyle(G__12217,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12227.cljs$core$IFn$_invoke$arity$2 ? pred__12227.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12228) : pred__12227.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12228)))){
return (new membrane.ui.WithStyle(self__.style,G__12217,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.WithStyle(self__.style,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12217),null));
}
}
}));

(membrane.ui.WithStyle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"style","style",-496642736),self__.style,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.WithStyle(self__.style,childs,null,null,null));
}));

(membrane.ui.WithStyle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12217){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.WithStyle(self__.style,self__.drawables,G__12217,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStyle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.WithStyle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"style","style",1143888791,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.WithStyle.cljs$lang$type = true);

(membrane.ui.WithStyle.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/WithStyle",null,(1),null));
}));

(membrane.ui.WithStyle.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/WithStyle");
}));

/**
 * Positional factory function for membrane.ui/WithStyle.
 */
membrane.ui.__GT_WithStyle = (function membrane$ui$__GT_WithStyle(style,drawables){
return (new membrane.ui.WithStyle(style,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/WithStyle, taking a map of keywords to field values.
 */
membrane.ui.map__GT_WithStyle = (function membrane$ui$map__GT_WithStyle(G__12221){
var extmap__4419__auto__ = (function (){var G__12230 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12221,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12221)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12230);
} else {
return G__12230;
}
})();
return (new membrane.ui.WithStyle(new cljs.core.Keyword(null,"style","style",-496642736).cljs$core$IFn$_invoke$arity$1(G__12221),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12221),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Style for drawing paths and polygons
 * 
 *   style is one of:
 * :membrane.ui/style-fill
 * :membrane.ui/style-stroke
 * :membrane.ui/style-stroke-and-fill
 */
membrane.ui.with_style = (function membrane$ui$with_style(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14110 = arguments.length;
var i__4737__auto___14111 = (0);
while(true){
if((i__4737__auto___14111 < len__4736__auto___14110)){
args__4742__auto__.push((arguments[i__4737__auto___14111]));

var G__14112 = (i__4737__auto___14111 + (1));
i__4737__auto___14111 = G__14112;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic = (function (style,drawables){
return (new membrane.ui.WithStyle(style,cljs.core.vec(drawables),null,null,null));
}));

(membrane.ui.with_style.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.with_style.cljs$lang$applyTo = (function (seq12231){
var G__12232 = cljs.core.first(seq12231);
var seq12231__$1 = cljs.core.next(seq12231);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12232,seq12231__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.WithStrokeWidth = (function (stroke_width,drawables,__meta,__extmap,__hash){
this.stroke_width = stroke_width;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.WithStrokeWidth.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12234,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12238 = k12234;
var G__12238__$1 = (((G__12238 instanceof cljs.core.Keyword))?G__12238.fqn:null);
switch (G__12238__$1) {
case "stroke-width":
return self__.stroke_width;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12234,else__4383__auto__);

}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12239){
var vec__12240 = p__12239;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12240,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12240,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.WithStrokeWidth{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),self__.stroke_width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12233){
var self__ = this;
var G__12233__$1 = this;
return (new cljs.core.RecordIter((0),G__12233__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawables);
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (335234124 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12235,other12236){
var self__ = this;
var this12235__$1 = this;
return (((!((other12236 == null)))) && ((this12235__$1.constructor === other12236.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12235__$1.stroke_width,other12236.stroke_width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12235__$1.drawables,other12236.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12235__$1.__extmap,other12236.__extmap)));
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12233){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12243 = cljs.core.keyword_identical_QMARK_;
var expr__12244 = k__4388__auto__;
if(cljs.core.truth_((pred__12243.cljs$core$IFn$_invoke$arity$2 ? pred__12243.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),expr__12244) : pred__12243.call(null,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),expr__12244)))){
return (new membrane.ui.WithStrokeWidth(G__12233,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12243.cljs$core$IFn$_invoke$arity$2 ? pred__12243.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12244) : pred__12243.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12244)))){
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,G__12233,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12233),null));
}
}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),self__.stroke_width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,childs,null,null,null));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12233){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,G__12233,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.WithStrokeWidth.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"stroke-width","stroke-width",-1937599334,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.WithStrokeWidth.cljs$lang$type = true);

(membrane.ui.WithStrokeWidth.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/WithStrokeWidth",null,(1),null));
}));

(membrane.ui.WithStrokeWidth.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/WithStrokeWidth");
}));

/**
 * Positional factory function for membrane.ui/WithStrokeWidth.
 */
membrane.ui.__GT_WithStrokeWidth = (function membrane$ui$__GT_WithStrokeWidth(stroke_width,drawables){
return (new membrane.ui.WithStrokeWidth(stroke_width,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/WithStrokeWidth, taking a map of keywords to field values.
 */
membrane.ui.map__GT_WithStrokeWidth = (function membrane$ui$map__GT_WithStrokeWidth(G__12237){
var extmap__4419__auto__ = (function (){var G__12246 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12237,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12237)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12246);
} else {
return G__12246;
}
})();
return (new membrane.ui.WithStrokeWidth(new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435).cljs$core$IFn$_invoke$arity$1(G__12237),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12237),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Set the stroke width for drawables.
 */
membrane.ui.with_stroke_width = (function membrane$ui$with_stroke_width(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14123 = arguments.length;
var i__4737__auto___14124 = (0);
while(true){
if((i__4737__auto___14124 < len__4736__auto___14123)){
args__4742__auto__.push((arguments[i__4737__auto___14124]));

var G__14125 = (i__4737__auto___14124 + (1));
i__4737__auto___14124 = G__14125;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic = (function (stroke_width,drawables){
return (new membrane.ui.WithStrokeWidth(stroke_width,cljs.core.vec(drawables),null,null,null));
}));

(membrane.ui.with_stroke_width.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.with_stroke_width.cljs$lang$applyTo = (function (seq12247){
var G__12248 = cljs.core.first(seq12247);
var seq12247__$1 = cljs.core.next(seq12247);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12248,seq12247__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Scale = (function (scalars,drawables,__meta,__extmap,__hash){
this.scalars = scalars;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Scale.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Scale.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12250,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12254 = k12250;
var G__12254__$1 = (((G__12254 instanceof cljs.core.Keyword))?G__12254.fqn:null);
switch (G__12254__$1) {
case "scalars":
return self__.scalars;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12250,else__4383__auto__);

}
}));

(membrane.ui.Scale.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12255){
var vec__12256 = p__12255;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12256,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12256,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Scale.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.Scale.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Scale{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"scalars","scalars",-350192527),self__.scalars],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.Scale.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12249){
var self__ = this;
var G__12249__$1 = this;
return (new cljs.core.RecordIter((0),G__12249__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"scalars","scalars",-350192527),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Scale.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__12259 = membrane.ui.bounds(self__.drawables);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12259,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12259,(1),null);
var vec__12262 = self__.scalars;
var sx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12262,(0),null);
var sy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12262,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(w * sx),(h * sy)], null);
}));

(membrane.ui.Scale.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Scale.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Scale(self__.scalars,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Scale.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Scale.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1872230439 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Scale.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12251,other12252){
var self__ = this;
var this12251__$1 = this;
return (((!((other12252 == null)))) && ((this12251__$1.constructor === other12252.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12251__$1.scalars,other12252.scalars)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12251__$1.drawables,other12252.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12251__$1.__extmap,other12252.__extmap)));
}));

(membrane.ui.Scale.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Scale.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"scalars","scalars",-350192527),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Scale(self__.scalars,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Scale.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12249){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12265 = cljs.core.keyword_identical_QMARK_;
var expr__12266 = k__4388__auto__;
if(cljs.core.truth_((pred__12265.cljs$core$IFn$_invoke$arity$2 ? pred__12265.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"scalars","scalars",-350192527),expr__12266) : pred__12265.call(null,new cljs.core.Keyword(null,"scalars","scalars",-350192527),expr__12266)))){
return (new membrane.ui.Scale(G__12249,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12265.cljs$core$IFn$_invoke$arity$2 ? pred__12265.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12266) : pred__12265.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12266)))){
return (new membrane.ui.Scale(self__.scalars,G__12249,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Scale(self__.scalars,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12249),null));
}
}
}));

(membrane.ui.Scale.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"scalars","scalars",-350192527),self__.scalars,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.Scale.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.Scale(self__.scalars,childs,null,null,null));
}));

(membrane.ui.Scale.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12249){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Scale(self__.scalars,self__.drawables,G__12249,self__.__extmap,self__.__hash));
}));

(membrane.ui.Scale.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Scale.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"scalars","scalars",1290339000,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.Scale.cljs$lang$type = true);

(membrane.ui.Scale.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Scale",null,(1),null));
}));

(membrane.ui.Scale.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Scale");
}));

/**
 * Positional factory function for membrane.ui/Scale.
 */
membrane.ui.__GT_Scale = (function membrane$ui$__GT_Scale(scalars,drawables){
return (new membrane.ui.Scale(scalars,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/Scale, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Scale = (function membrane$ui$map__GT_Scale(G__12253){
var extmap__4419__auto__ = (function (){var G__12268 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12253,new cljs.core.Keyword(null,"scalars","scalars",-350192527),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12253)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12268);
} else {
return G__12268;
}
})();
return (new membrane.ui.Scale(new cljs.core.Keyword(null,"scalars","scalars",-350192527).cljs$core$IFn$_invoke$arity$1(G__12253),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12253),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Draw drawables using scalars which is a vector of [scale-x scale-y]
 */
membrane.ui.scale = (function membrane$ui$scale(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14139 = arguments.length;
var i__4737__auto___14140 = (0);
while(true){
if((i__4737__auto___14140 < len__4736__auto___14139)){
args__4742__auto__.push((arguments[i__4737__auto___14140]));

var G__14141 = (i__4737__auto___14140 + (1));
i__4737__auto___14140 = G__14141;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return membrane.ui.scale.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(membrane.ui.scale.cljs$core$IFn$_invoke$arity$variadic = (function (sx,sy,drawables){
return (new membrane.ui.Scale(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sx,sy], null),cljs.core.vec(drawables),null,null,null));
}));

(membrane.ui.scale.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(membrane.ui.scale.cljs$lang$applyTo = (function (seq12269){
var G__12270 = cljs.core.first(seq12269);
var seq12269__$1 = cljs.core.next(seq12269);
var G__12271 = cljs.core.first(seq12269__$1);
var seq12269__$2 = cljs.core.next(seq12269__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12270,G__12271,seq12269__$2);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Arc = (function (radius,rad_start,rad_end,steps,__meta,__extmap,__hash){
this.radius = radius;
this.rad_start = rad_start;
this.rad_end = rad_end;
this.steps = steps;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Arc.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Arc.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12273,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12277 = k12273;
var G__12277__$1 = (((G__12277 instanceof cljs.core.Keyword))?G__12277.fqn:null);
switch (G__12277__$1) {
case "radius":
return self__.radius;

break;
case "rad-start":
return self__.rad_start;

break;
case "rad-end":
return self__.rad_end;

break;
case "steps":
return self__.steps;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12273,else__4383__auto__);

}
}));

(membrane.ui.Arc.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12278){
var vec__12279 = p__12278;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12279,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12279,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Arc.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Arc{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"radius","radius",-2073122258),self__.radius],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rad-start","rad-start",134012724),self__.rad_start],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),self__.rad_end],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"steps","steps",-128433302),self__.steps],null))], null),self__.__extmap));
}));

(membrane.ui.Arc.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12272){
var self__ = this;
var G__12272__$1 = this;
return (new cljs.core.RecordIter((0),G__12272__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"radius","radius",-2073122258),new cljs.core.Keyword(null,"rad-start","rad-start",134012724),new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),new cljs.core.Keyword(null,"steps","steps",-128433302)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Arc.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Arc.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Arc.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Arc.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Arc.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (4 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Arc.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-661039756 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Arc.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12274,other12275){
var self__ = this;
var this12274__$1 = this;
return (((!((other12275 == null)))) && ((this12274__$1.constructor === other12275.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12274__$1.radius,other12275.radius)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12274__$1.rad_start,other12275.rad_start)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12274__$1.rad_end,other12275.rad_end)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12274__$1.steps,other12275.steps)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12274__$1.__extmap,other12275.__extmap)));
}));

(membrane.ui.Arc.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Arc.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Arc.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),null,new cljs.core.Keyword(null,"steps","steps",-128433302),null,new cljs.core.Keyword(null,"radius","radius",-2073122258),null,new cljs.core.Keyword(null,"rad-start","rad-start",134012724),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Arc.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12272){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12282 = cljs.core.keyword_identical_QMARK_;
var expr__12283 = k__4388__auto__;
if(cljs.core.truth_((pred__12282.cljs$core$IFn$_invoke$arity$2 ? pred__12282.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"radius","radius",-2073122258),expr__12283) : pred__12282.call(null,new cljs.core.Keyword(null,"radius","radius",-2073122258),expr__12283)))){
return (new membrane.ui.Arc(G__12272,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12282.cljs$core$IFn$_invoke$arity$2 ? pred__12282.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"rad-start","rad-start",134012724),expr__12283) : pred__12282.call(null,new cljs.core.Keyword(null,"rad-start","rad-start",134012724),expr__12283)))){
return (new membrane.ui.Arc(self__.radius,G__12272,self__.rad_end,self__.steps,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12282.cljs$core$IFn$_invoke$arity$2 ? pred__12282.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),expr__12283) : pred__12282.call(null,new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),expr__12283)))){
return (new membrane.ui.Arc(self__.radius,self__.rad_start,G__12272,self__.steps,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12282.cljs$core$IFn$_invoke$arity$2 ? pred__12282.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"steps","steps",-128433302),expr__12283) : pred__12282.call(null,new cljs.core.Keyword(null,"steps","steps",-128433302),expr__12283)))){
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,G__12272,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12272),null));
}
}
}
}
}));

(membrane.ui.Arc.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"radius","radius",-2073122258),self__.radius,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rad-start","rad-start",134012724),self__.rad_start,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),self__.rad_end,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"steps","steps",-128433302),self__.steps,null))], null),self__.__extmap));
}));

(membrane.ui.Arc.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12272){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,G__12272,self__.__extmap,self__.__hash));
}));

(membrane.ui.Arc.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Arc.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"radius","radius",-432590731,null),new cljs.core.Symbol(null,"rad-start","rad-start",1774544251,null),new cljs.core.Symbol(null,"rad-end","rad-end",109446828,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)], null);
}));

(membrane.ui.Arc.cljs$lang$type = true);

(membrane.ui.Arc.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Arc",null,(1),null));
}));

(membrane.ui.Arc.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Arc");
}));

/**
 * Positional factory function for membrane.ui/Arc.
 */
membrane.ui.__GT_Arc = (function membrane$ui$__GT_Arc(radius,rad_start,rad_end,steps){
return (new membrane.ui.Arc(radius,rad_start,rad_end,steps,null,null,null));
});

/**
 * Factory function for membrane.ui/Arc, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Arc = (function membrane$ui$map__GT_Arc(G__12276){
var extmap__4419__auto__ = (function (){var G__12285 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12276,new cljs.core.Keyword(null,"radius","radius",-2073122258),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"rad-start","rad-start",134012724),new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),new cljs.core.Keyword(null,"steps","steps",-128433302)], 0));
if(cljs.core.record_QMARK_(G__12276)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12285);
} else {
return G__12285;
}
})();
return (new membrane.ui.Arc(new cljs.core.Keyword(null,"radius","radius",-2073122258).cljs$core$IFn$_invoke$arity$1(G__12276),new cljs.core.Keyword(null,"rad-start","rad-start",134012724).cljs$core$IFn$_invoke$arity$1(G__12276),new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699).cljs$core$IFn$_invoke$arity$1(G__12276),new cljs.core.Keyword(null,"steps","steps",-128433302).cljs$core$IFn$_invoke$arity$1(G__12276),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.arc = (function membrane$ui$arc(radius,rad_start,rad_end){
return (new membrane.ui.Arc(radius,rad_start,rad_end,(10),null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Rectangle = (function (width,height,__meta,__extmap,__hash){
this.width = width;
this.height = height;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Rectangle.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Rectangle.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12287,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12291 = k12287;
var G__12291__$1 = (((G__12291 instanceof cljs.core.Keyword))?G__12291.fqn:null);
switch (G__12291__$1) {
case "width":
return self__.width;

break;
case "height":
return self__.height;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12287,else__4383__auto__);

}
}));

(membrane.ui.Rectangle.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12292){
var vec__12293 = p__12292;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12293,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12293,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Rectangle.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Rectangle{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"width","width",-384071477),self__.width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"height","height",1025178622),self__.height],null))], null),self__.__extmap));
}));

(membrane.ui.Rectangle.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12286){
var self__ = this;
var G__12286__$1 = this;
return (new cljs.core.RecordIter((0),G__12286__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"height","height",1025178622)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Rectangle.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rectangle.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.width,self__.height], null);
}));

(membrane.ui.Rectangle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Rectangle.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Rectangle(self__.width,self__.height,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rectangle.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Rectangle.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (833278147 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Rectangle.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12288,other12289){
var self__ = this;
var this12288__$1 = this;
return (((!((other12289 == null)))) && ((this12288__$1.constructor === other12289.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12288__$1.width,other12289.width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12288__$1.height,other12289.height)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12288__$1.__extmap,other12289.__extmap)));
}));

(membrane.ui.Rectangle.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rectangle.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Rectangle.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"height","height",1025178622),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Rectangle(self__.width,self__.height,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Rectangle.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12286){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12296 = cljs.core.keyword_identical_QMARK_;
var expr__12297 = k__4388__auto__;
if(cljs.core.truth_((pred__12296.cljs$core$IFn$_invoke$arity$2 ? pred__12296.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"width","width",-384071477),expr__12297) : pred__12296.call(null,new cljs.core.Keyword(null,"width","width",-384071477),expr__12297)))){
return (new membrane.ui.Rectangle(G__12286,self__.height,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12296.cljs$core$IFn$_invoke$arity$2 ? pred__12296.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"height","height",1025178622),expr__12297) : pred__12296.call(null,new cljs.core.Keyword(null,"height","height",1025178622),expr__12297)))){
return (new membrane.ui.Rectangle(self__.width,G__12286,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Rectangle(self__.width,self__.height,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12286),null));
}
}
}));

(membrane.ui.Rectangle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"width","width",-384071477),self__.width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"height","height",1025178622),self__.height,null))], null),self__.__extmap));
}));

(membrane.ui.Rectangle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12286){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Rectangle(self__.width,self__.height,G__12286,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rectangle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Rectangle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"height","height",-1629257147,null)], null);
}));

(membrane.ui.Rectangle.cljs$lang$type = true);

(membrane.ui.Rectangle.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Rectangle",null,(1),null));
}));

(membrane.ui.Rectangle.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Rectangle");
}));

/**
 * Positional factory function for membrane.ui/Rectangle.
 */
membrane.ui.__GT_Rectangle = (function membrane$ui$__GT_Rectangle(width,height){
return (new membrane.ui.Rectangle(width,height,null,null,null));
});

/**
 * Factory function for membrane.ui/Rectangle, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Rectangle = (function membrane$ui$map__GT_Rectangle(G__12290){
var extmap__4419__auto__ = (function (){var G__12299 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12290,new cljs.core.Keyword(null,"width","width",-384071477),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"height","height",1025178622)], 0));
if(cljs.core.record_QMARK_(G__12290)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12299);
} else {
return G__12299;
}
})();
return (new membrane.ui.Rectangle(new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(G__12290),new cljs.core.Keyword(null,"height","height",1025178622).cljs$core$IFn$_invoke$arity$1(G__12290),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Rectangle,(function (draw){
return (function (this$){
var map__12300 = this$;
var map__12300__$1 = (((((!((map__12300 == null))))?(((((map__12300.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12300.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12300):map__12300);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12300__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12300__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var G__12302 = membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),height], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [width,height], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [width,(0)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null)], 0));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12302) : draw.call(null,G__12302));
});
}));
/**
 * Graphical elem that draws a rectangle.
 * 
 *   See with-style, with-stroke-width, and with-color for more options.
 */
membrane.ui.rectangle = (function membrane$ui$rectangle(width,height){
return (new membrane.ui.Rectangle(width,height,null,null,null));
});
/**
 * Graphical elem that draws a filled rectangle with color, [r g b] or [r g b a].
 */
membrane.ui.filled_rectangle = (function membrane$ui$filled_rectangle(color,width,height){
return membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(color,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-fill","membrane.ui/style-fill",1620230388),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new membrane.ui.Rectangle(width,height,null,null,null))], 0))], 0));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.RoundedRectangle = (function (width,height,border_radius,__meta,__extmap,__hash){
this.width = width;
this.height = height;
this.border_radius = border_radius;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.RoundedRectangle.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12304,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12308 = k12304;
var G__12308__$1 = (((G__12308 instanceof cljs.core.Keyword))?G__12308.fqn:null);
switch (G__12308__$1) {
case "width":
return self__.width;

break;
case "height":
return self__.height;

break;
case "border-radius":
return self__.border_radius;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12304,else__4383__auto__);

}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12309){
var vec__12310 = p__12309;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12310,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12310,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.RoundedRectangle{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"width","width",-384071477),self__.width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"height","height",1025178622),self__.height],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"border-radius","border-radius",419594011),self__.border_radius],null))], null),self__.__extmap));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12303){
var self__ = this;
var G__12303__$1 = this;
return (new cljs.core.RecordIter((0),G__12303__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"border-radius","border-radius",419594011)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.width,self__.height], null);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1334660464 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12305,other12306){
var self__ = this;
var this12305__$1 = this;
return (((!((other12306 == null)))) && ((this12305__$1.constructor === other12306.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12305__$1.width,other12306.width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12305__$1.height,other12306.height)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12305__$1.border_radius,other12306.border_radius)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12305__$1.__extmap,other12306.__extmap)));
}));

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),null,new cljs.core.Keyword(null,"height","height",1025178622),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12303){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12313 = cljs.core.keyword_identical_QMARK_;
var expr__12314 = k__4388__auto__;
if(cljs.core.truth_((pred__12313.cljs$core$IFn$_invoke$arity$2 ? pred__12313.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"width","width",-384071477),expr__12314) : pred__12313.call(null,new cljs.core.Keyword(null,"width","width",-384071477),expr__12314)))){
return (new membrane.ui.RoundedRectangle(G__12303,self__.height,self__.border_radius,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12313.cljs$core$IFn$_invoke$arity$2 ? pred__12313.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"height","height",1025178622),expr__12314) : pred__12313.call(null,new cljs.core.Keyword(null,"height","height",1025178622),expr__12314)))){
return (new membrane.ui.RoundedRectangle(self__.width,G__12303,self__.border_radius,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12313.cljs$core$IFn$_invoke$arity$2 ? pred__12313.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"border-radius","border-radius",419594011),expr__12314) : pred__12313.call(null,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),expr__12314)))){
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,G__12303,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12303),null));
}
}
}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"width","width",-384071477),self__.width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"height","height",1025178622),self__.height,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"border-radius","border-radius",419594011),self__.border_radius,null))], null),self__.__extmap));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12303){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,G__12303,self__.__extmap,self__.__hash));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.RoundedRectangle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"height","height",-1629257147,null),new cljs.core.Symbol(null,"border-radius","border-radius",2060125538,null)], null);
}));

(membrane.ui.RoundedRectangle.cljs$lang$type = true);

(membrane.ui.RoundedRectangle.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/RoundedRectangle",null,(1),null));
}));

(membrane.ui.RoundedRectangle.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/RoundedRectangle");
}));

/**
 * Positional factory function for membrane.ui/RoundedRectangle.
 */
membrane.ui.__GT_RoundedRectangle = (function membrane$ui$__GT_RoundedRectangle(width,height,border_radius){
return (new membrane.ui.RoundedRectangle(width,height,border_radius,null,null,null));
});

/**
 * Factory function for membrane.ui/RoundedRectangle, taking a map of keywords to field values.
 */
membrane.ui.map__GT_RoundedRectangle = (function membrane$ui$map__GT_RoundedRectangle(G__12307){
var extmap__4419__auto__ = (function (){var G__12316 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12307,new cljs.core.Keyword(null,"width","width",-384071477),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"border-radius","border-radius",419594011)], 0));
if(cljs.core.record_QMARK_(G__12307)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12316);
} else {
return G__12316;
}
})();
return (new membrane.ui.RoundedRectangle(new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(G__12307),new cljs.core.Keyword(null,"height","height",1025178622).cljs$core$IFn$_invoke$arity$1(G__12307),new cljs.core.Keyword(null,"border-radius","border-radius",419594011).cljs$core$IFn$_invoke$arity$1(G__12307),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that draws a rounded rectangle.
 */
membrane.ui.rounded_rectangle = (function membrane$ui$rounded_rectangle(width,height,border_radius){
return (new membrane.ui.RoundedRectangle(width,height,border_radius,null,null,null));
});
membrane.ui.bordered_draw = (function membrane$ui$bordered_draw(this$){
var map__12317 = this$;
var map__12317__$1 = (((((!((map__12317 == null))))?(((((map__12317.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12317.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12317):map__12317);
var drawable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12317__$1,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
var padding_x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12317__$1,new cljs.core.Keyword(null,"padding-x","padding-x",762313863));
var padding_y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12317__$1,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186));
var vec__12318 = membrane.ui.bounds(drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12318,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12318,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var gray = 0.65;
return membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [gray,gray,gray], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rectangle((width + ((2) * padding_x)),(height + ((2) * padding_y)))], 0))], 0));
})(),membrane.ui.translate(padding_x,padding_y,drawable)], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Bordered = (function (padding_x,padding_y,drawable,__meta,__extmap,__hash){
this.padding_x = padding_x;
this.padding_y = padding_y;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Bordered.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Bordered.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12323,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12327 = k12323;
var G__12327__$1 = (((G__12327 instanceof cljs.core.Keyword))?G__12327.fqn:null);
switch (G__12327__$1) {
case "padding-x":
return self__.padding_x;

break;
case "padding-y":
return self__.padding_y;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12323,else__4383__auto__);

}
}));

(membrane.ui.Bordered.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12328){
var vec__12329 = p__12328;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12329,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12329,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Bordered.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bordered_draw(this$__$1);
}));

(membrane.ui.Bordered.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Bordered{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Bordered.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12322){
var self__ = this;
var G__12322__$1 = this;
return (new cljs.core.RecordIter((0),G__12322__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"padding-x","padding-x",762313863),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Bordered.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__12332 = membrane.ui.bounds(self__.drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12332,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12332,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(width + ((2) * self__.padding_x)),(height + ((2) * self__.padding_y))], null);
}));

(membrane.ui.Bordered.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Bordered.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Bordered.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Bordered.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-900094536 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Bordered.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12324,other12325){
var self__ = this;
var this12324__$1 = this;
return (((!((other12325 == null)))) && ((this12324__$1.constructor === other12325.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12324__$1.padding_x,other12325.padding_x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12324__$1.padding_y,other12325.padding_y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12324__$1.drawable,other12325.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12324__$1.__extmap,other12325.__extmap)));
}));

(membrane.ui.Bordered.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.origin(membrane.ui.bordered_draw(this$__$1));
}));

(membrane.ui.Bordered.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Bordered.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12322){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12335 = cljs.core.keyword_identical_QMARK_;
var expr__12336 = k__4388__auto__;
if(cljs.core.truth_((pred__12335.cljs$core$IFn$_invoke$arity$2 ? pred__12335.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__12336) : pred__12335.call(null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__12336)))){
return (new membrane.ui.Bordered(G__12322,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12335.cljs$core$IFn$_invoke$arity$2 ? pred__12335.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__12336) : pred__12335.call(null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__12336)))){
return (new membrane.ui.Bordered(self__.padding_x,G__12322,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12335.cljs$core$IFn$_invoke$arity$2 ? pred__12335.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12336) : pred__12335.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12336)))){
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,G__12322,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12322),null));
}
}
}
}));

(membrane.ui.Bordered.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Bordered.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Bordered.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12322){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,G__12322,self__.__extmap,self__.__hash));
}));

(membrane.ui.Bordered.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Bordered.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"padding-x","padding-x",-1892121906,null),new cljs.core.Symbol(null,"padding-y","padding-y",382093341,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Bordered.cljs$lang$type = true);

(membrane.ui.Bordered.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Bordered",null,(1),null));
}));

(membrane.ui.Bordered.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Bordered");
}));

/**
 * Positional factory function for membrane.ui/Bordered.
 */
membrane.ui.__GT_Bordered = (function membrane$ui$__GT_Bordered(padding_x,padding_y,drawable){
return (new membrane.ui.Bordered(padding_x,padding_y,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Bordered, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Bordered = (function membrane$ui$map__GT_Bordered(G__12326){
var extmap__4419__auto__ = (function (){var G__12338 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12326,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12326)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12338);
} else {
return G__12338;
}
})();
return (new membrane.ui.Bordered(new cljs.core.Keyword(null,"padding-x","padding-x",762313863).cljs$core$IFn$_invoke$arity$1(G__12326),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186).cljs$core$IFn$_invoke$arity$1(G__12326),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12326),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Bordered,(function (draw){
return (function (this$){
var G__12339 = membrane.ui.bordered_draw(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12339) : draw.call(null,G__12339));
});
}));
/**
 * Graphical elem that will draw drawable with a gray border.
 */
membrane.ui.bordered = (function membrane$ui$bordered(padding,drawable){
if(cljs.core.vector_QMARK_(padding)){
var vec__12340 = padding;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12340,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12340,(1),null);
return (new membrane.ui.Bordered(px,py,drawable,null,null,null));
} else {
return (new membrane.ui.Bordered(padding,padding,drawable,null,null,null));
}
});
membrane.ui.fill_bordered_draw = (function membrane$ui$fill_bordered_draw(this$){
var map__12343 = this$;
var map__12343__$1 = (((((!((map__12343 == null))))?(((((map__12343.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__12343.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__12343):map__12343);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12343__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var drawable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12343__$1,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
var padding_x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12343__$1,new cljs.core.Keyword(null,"padding-x","padding-x",762313863));
var padding_y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12343__$1,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186));
var vec__12344 = membrane.ui.bounds(drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12344,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12344,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.filled_rectangle(color,(width + ((2) * padding_x)),(height + ((2) * padding_y))),membrane.ui.translate(padding_x,padding_y,drawable)], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.FillBordered = (function (color,padding_x,padding_y,drawable,__meta,__extmap,__hash){
this.color = color;
this.padding_x = padding_x;
this.padding_y = padding_y;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.FillBordered.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12349,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12353 = k12349;
var G__12353__$1 = (((G__12353 instanceof cljs.core.Keyword))?G__12353.fqn:null);
switch (G__12353__$1) {
case "color":
return self__.color;

break;
case "padding-x":
return self__.padding_x;

break;
case "padding-y":
return self__.padding_y;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12349,else__4383__auto__);

}
}));

(membrane.ui.FillBordered.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12354){
var vec__12355 = p__12354;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12355,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12355,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.FillBordered{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"color","color",1011675173),self__.color],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.FillBordered.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12348){
var self__ = this;
var G__12348__$1 = this;
return (new cljs.core.RecordIter((0),G__12348__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"padding-x","padding-x",762313863),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__12358 = membrane.ui.bounds(self__.drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12358,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12358,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(width + ((2) * self__.padding_x)),(height + ((2) * self__.padding_y))], null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.FillBordered.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.FillBordered.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (4 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.FillBordered.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-851895183 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.FillBordered.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12350,other12351){
var self__ = this;
var this12350__$1 = this;
return (((!((other12351 == null)))) && ((this12350__$1.constructor === other12351.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12350__$1.color,other12351.color)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12350__$1.padding_x,other12351.padding_x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12350__$1.padding_y,other12351.padding_y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12350__$1.drawable,other12351.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12350__$1.__extmap,other12351.__extmap)));
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.FillBordered.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12348){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12361 = cljs.core.keyword_identical_QMARK_;
var expr__12362 = k__4388__auto__;
if(cljs.core.truth_((pred__12361.cljs$core$IFn$_invoke$arity$2 ? pred__12361.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"color","color",1011675173),expr__12362) : pred__12361.call(null,new cljs.core.Keyword(null,"color","color",1011675173),expr__12362)))){
return (new membrane.ui.FillBordered(G__12348,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12361.cljs$core$IFn$_invoke$arity$2 ? pred__12361.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__12362) : pred__12361.call(null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__12362)))){
return (new membrane.ui.FillBordered(self__.color,G__12348,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12361.cljs$core$IFn$_invoke$arity$2 ? pred__12361.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__12362) : pred__12361.call(null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__12362)))){
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,G__12348,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12361.cljs$core$IFn$_invoke$arity$2 ? pred__12361.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12362) : pred__12361.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12362)))){
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,G__12348,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12348),null));
}
}
}
}
}));

(membrane.ui.FillBordered.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"color","color",1011675173),self__.color,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.FillBordered.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12348){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,G__12348,self__.__extmap,self__.__hash));
}));

(membrane.ui.FillBordered.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.FillBordered.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"color","color",-1642760596,null),new cljs.core.Symbol(null,"padding-x","padding-x",-1892121906,null),new cljs.core.Symbol(null,"padding-y","padding-y",382093341,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.FillBordered.cljs$lang$type = true);

(membrane.ui.FillBordered.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/FillBordered",null,(1),null));
}));

(membrane.ui.FillBordered.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/FillBordered");
}));

/**
 * Positional factory function for membrane.ui/FillBordered.
 */
membrane.ui.__GT_FillBordered = (function membrane$ui$__GT_FillBordered(color,padding_x,padding_y,drawable){
return (new membrane.ui.FillBordered(color,padding_x,padding_y,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/FillBordered, taking a map of keywords to field values.
 */
membrane.ui.map__GT_FillBordered = (function membrane$ui$map__GT_FillBordered(G__12352){
var extmap__4419__auto__ = (function (){var G__12364 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12352,new cljs.core.Keyword(null,"color","color",1011675173),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"padding-x","padding-x",762313863),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12352)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12364);
} else {
return G__12364;
}
})();
return (new membrane.ui.FillBordered(new cljs.core.Keyword(null,"color","color",1011675173).cljs$core$IFn$_invoke$arity$1(G__12352),new cljs.core.Keyword(null,"padding-x","padding-x",762313863).cljs$core$IFn$_invoke$arity$1(G__12352),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186).cljs$core$IFn$_invoke$arity$1(G__12352),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12352),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.FillBordered,(function (draw){
return (function (this$){
var G__12365 = membrane.ui.fill_bordered_draw(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12365) : draw.call(null,G__12365));
});
}));
/**
 * Graphical elem that will draw elem with filled border.
 */
membrane.ui.fill_bordered = (function membrane$ui$fill_bordered(color,padding,drawable){
if(cljs.core.vector_QMARK_(padding)){
var vec__12366 = padding;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12366,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12366,(1),null);
return (new membrane.ui.FillBordered(color,px,py,drawable,null,null,null));
} else {
return (new membrane.ui.FillBordered(color,padding,padding,drawable,null,null,null));
}
});
membrane.ui.draw_checkbox = (function membrane$ui$draw_checkbox(checked_QMARK_){
if(cljs.core.truth_(checked_QMARK_)){
var border = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.14901960784313725,0.5254901960784314,0.9882352941176471], null);
var fill = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.2,0.5607843137254902,0.9882352941176471], null);
return membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-fill","membrane.ui/style-fill",1620230388),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(fill,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((12),(12),(2))], 0))], 0)),membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(border,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((12),(12),(2))], 0)),membrane.ui.translate((0),(1),membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic(1.5,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),0.3], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(6)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(9)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(10),(2)], null)], 0))], 0))], 0))),membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic(1.5,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1),(1)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(6)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(9)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(10),(2)], null)], 0))], 0))], 0))], null)], 0));
} else {
var gray = 0.6862745098039216;
return membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [gray,gray,gray], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((12),(12),(2))], 0))], 0));
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Checkbox = (function (checked_QMARK_,__meta,__extmap,__hash){
this.checked_QMARK_ = checked_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Checkbox.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Checkbox.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12370,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12374 = k12370;
var G__12374__$1 = (((G__12374 instanceof cljs.core.Keyword))?G__12374.fqn:null);
switch (G__12374__$1) {
case "checked?":
return self__.checked_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12370,else__4383__auto__);

}
}));

(membrane.ui.Checkbox.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12375){
var vec__12376 = p__12375;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12376,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12376,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Checkbox.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Checkbox.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.draw_checkbox(self__.checked_QMARK_)], null);
}));

(membrane.ui.Checkbox.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Checkbox{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"checked?","checked?",2024809091),self__.checked_QMARK_],null))], null),self__.__extmap));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12369){
var self__ = this;
var G__12369__$1 = this;
return (new cljs.core.RecordIter((0),G__12369__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"checked?","checked?",2024809091)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Checkbox.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Checkbox.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(membrane.ui.draw_checkbox(self__.checked_QMARK_));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Checkbox.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Checkbox(self__.checked_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Checkbox.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1062342187 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Checkbox.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12371,other12372){
var self__ = this;
var this12371__$1 = this;
return (((!((other12372 == null)))) && ((this12371__$1.constructor === other12372.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12371__$1.checked_QMARK_,other12372.checked_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12371__$1.__extmap,other12372.__extmap)));
}));

(membrane.ui.Checkbox.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Checkbox.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Checkbox.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"checked?","checked?",2024809091),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Checkbox(self__.checked_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Checkbox.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12369){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12379 = cljs.core.keyword_identical_QMARK_;
var expr__12380 = k__4388__auto__;
if(cljs.core.truth_((pred__12379.cljs$core$IFn$_invoke$arity$2 ? pred__12379.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"checked?","checked?",2024809091),expr__12380) : pred__12379.call(null,new cljs.core.Keyword(null,"checked?","checked?",2024809091),expr__12380)))){
return (new membrane.ui.Checkbox(G__12369,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Checkbox(self__.checked_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12369),null));
}
}));

(membrane.ui.Checkbox.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"checked?","checked?",2024809091),self__.checked_QMARK_,null))], null),self__.__extmap));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12369){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Checkbox(self__.checked_QMARK_,G__12369,self__.__extmap,self__.__hash));
}));

(membrane.ui.Checkbox.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Checkbox.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"checked?","checked?",-629626678,null)], null);
}));

(membrane.ui.Checkbox.cljs$lang$type = true);

(membrane.ui.Checkbox.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Checkbox",null,(1),null));
}));

(membrane.ui.Checkbox.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Checkbox");
}));

/**
 * Positional factory function for membrane.ui/Checkbox.
 */
membrane.ui.__GT_Checkbox = (function membrane$ui$__GT_Checkbox(checked_QMARK_){
return (new membrane.ui.Checkbox(checked_QMARK_,null,null,null));
});

/**
 * Factory function for membrane.ui/Checkbox, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Checkbox = (function membrane$ui$map__GT_Checkbox(G__12373){
var extmap__4419__auto__ = (function (){var G__12382 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__12373,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
if(cljs.core.record_QMARK_(G__12373)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12382);
} else {
return G__12382;
}
})();
return (new membrane.ui.Checkbox(new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(G__12373),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Checkbox,(function (draw){
return (function (this$){
var G__12383 = membrane.ui.draw_checkbox(new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(this$));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12383) : draw.call(null,G__12383));
});
}));
/**
 * Graphical elem that will draw a checkbox.
 */
membrane.ui.checkbox = (function membrane$ui$checkbox(checked_QMARK_){
return (new membrane.ui.Checkbox(checked_QMARK_,null,null,null));
});
/**
 * Tests whether [px py] is within  [x y width height].
 */
membrane.ui.box_contains_QMARK_ = (function membrane$ui$box_contains_QMARK_(p__12384,p__12385){
var vec__12386 = p__12384;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12386,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12386,(1),null);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12386,(2),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12386,(3),null);
var vec__12389 = p__12385;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12389,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12389,(1),null);
return (((px <= (x + width))) && ((px >= x)) && ((py <= (y + height))) && ((py >= y)));
});
membrane.ui.button_draw = (function membrane$ui$button_draw(this$){
var text = new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(this$);
var vec__12392 = membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1(text));
var text_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12392,(0),null);
var text_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12392,(1),null);
var padding = (12);
var rect_width = (text_width + padding);
var rect_height = (text_height + padding);
var border_radius = (3);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(new cljs.core.Keyword(null,"hover?","hover?",-1201331489).cljs$core$IFn$_invoke$arity$1(this$))?membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.9,0.9,0.9], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle(rect_width,rect_height,border_radius)], 0)):null),membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.76,0.76,0.76,(1)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((0.5 + rect_width),(0.5 + rect_height),border_radius)], 0)),membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.85,0.85,0.85], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle(rect_width,rect_height,border_radius)], 0))], null)], 0)),membrane.ui.translate((padding / (2)),((padding / (2)) - (2)),membrane.ui.label.cljs$core$IFn$_invoke$arity$1(text))], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Button = (function (text,on_click,hover_QMARK_,__meta,__extmap,__hash){
this.text = text;
this.on_click = on_click;
this.hover_QMARK_ = hover_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Button.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Button.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12396,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12400 = k12396;
var G__12400__$1 = (((G__12400 instanceof cljs.core.Keyword))?G__12400.fqn:null);
switch (G__12400__$1) {
case "text":
return self__.text;

break;
case "on-click":
return self__.on_click;

break;
case "hover?":
return self__.hover_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12396,else__4383__auto__);

}
}));

(membrane.ui.Button.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12401){
var vec__12402 = p__12401;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12402,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12402,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Button.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Button{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"hover?","hover?",-1201331489),self__.hover_QMARK_],null))], null),self__.__extmap));
}));

(membrane.ui.Button.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12395){
var self__ = this;
var G__12395__$1 = this;
return (new cljs.core.RecordIter((0),G__12395__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"hover?","hover?",-1201331489)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Button.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Button.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var and__4115__auto__ = mouse_down_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return self__.on_click;
} else {
return and__4115__auto__;
}
})())){
return (self__.on_click.cljs$core$IFn$_invoke$arity$0 ? self__.on_click.cljs$core$IFn$_invoke$arity$0() : self__.on_click.call(null));
} else {
return null;
}
}));

(membrane.ui.Button.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Button.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vec__12405 = membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1(self__.text));
var text_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12405,(0),null);
var text_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12405,(1),null);
var padding = (12);
var btn_width = (text_width + padding);
var btn_height = (text_height + padding);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [btn_width,btn_height], null);
}));

(membrane.ui.Button.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Button.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Button.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Button.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-534561442 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Button.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12397,other12398){
var self__ = this;
var this12397__$1 = this;
return (((!((other12398 == null)))) && ((this12397__$1.constructor === other12398.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12397__$1.text,other12398.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12397__$1.on_click,other12398.on_click)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12397__$1.hover_QMARK_,other12398.hover_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12397__$1.__extmap,other12398.__extmap)));
}));

(membrane.ui.Button.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Button.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Button.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"text","text",-1790561697),null,new cljs.core.Keyword(null,"hover?","hover?",-1201331489),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Button.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12395){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12408 = cljs.core.keyword_identical_QMARK_;
var expr__12409 = k__4388__auto__;
if(cljs.core.truth_((pred__12408.cljs$core$IFn$_invoke$arity$2 ? pred__12408.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__12409) : pred__12408.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__12409)))){
return (new membrane.ui.Button(G__12395,self__.on_click,self__.hover_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12408.cljs$core$IFn$_invoke$arity$2 ? pred__12408.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__12409) : pred__12408.call(null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__12409)))){
return (new membrane.ui.Button(self__.text,G__12395,self__.hover_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12408.cljs$core$IFn$_invoke$arity$2 ? pred__12408.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"hover?","hover?",-1201331489),expr__12409) : pred__12408.call(null,new cljs.core.Keyword(null,"hover?","hover?",-1201331489),expr__12409)))){
return (new membrane.ui.Button(self__.text,self__.on_click,G__12395,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12395),null));
}
}
}
}));

(membrane.ui.Button.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"hover?","hover?",-1201331489),self__.hover_QMARK_,null))], null),self__.__extmap));
}));

(membrane.ui.Button.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12395){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,G__12395,self__.__extmap,self__.__hash));
}));

(membrane.ui.Button.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Button.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"on-click","on-click",-1021609226,null),new cljs.core.Symbol(null,"hover?","hover?",439200038,null)], null);
}));

(membrane.ui.Button.cljs$lang$type = true);

(membrane.ui.Button.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Button",null,(1),null));
}));

(membrane.ui.Button.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Button");
}));

/**
 * Positional factory function for membrane.ui/Button.
 */
membrane.ui.__GT_Button = (function membrane$ui$__GT_Button(text,on_click,hover_QMARK_){
return (new membrane.ui.Button(text,on_click,hover_QMARK_,null,null,null));
});

/**
 * Factory function for membrane.ui/Button, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Button = (function membrane$ui$map__GT_Button(G__12399){
var extmap__4419__auto__ = (function (){var G__12411 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12399,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"hover?","hover?",-1201331489)], 0));
if(cljs.core.record_QMARK_(G__12399)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12411);
} else {
return G__12411;
}
})();
return (new membrane.ui.Button(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__12399),new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(G__12399),new cljs.core.Keyword(null,"hover?","hover?",-1201331489).cljs$core$IFn$_invoke$arity$1(G__12399),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Button,(function (draw){
return (function (this$){
var G__12412 = membrane.ui.button_draw(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12412) : draw.call(null,G__12412));
});
}));
/**
 * Graphical elem that draws a button. Optional on-click function may be provided that is called with no arguments when button has a mouse-down event.
 */
membrane.ui.button = (function membrane$ui$button(var_args){
var G__12414 = arguments.length;
switch (G__12414) {
case 1:
return membrane.ui.button.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.button.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.button.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.button.cljs$core$IFn$_invoke$arity$1 = (function (text){
return (new membrane.ui.Button(text,null,false,null,null,null));
}));

(membrane.ui.button.cljs$core$IFn$_invoke$arity$2 = (function (text,on_click){
return (new membrane.ui.Button(text,on_click,false,null,null,null));
}));

(membrane.ui.button.cljs$core$IFn$_invoke$arity$3 = (function (text,on_click,hover_QMARK_){
return (new membrane.ui.Button(text,on_click,hover_QMARK_,null,null,null));
}));

(membrane.ui.button.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClick = (function (on_click,drawables,__meta,__extmap,__hash){
this.on_click = on_click;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClick.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClick.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12416,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12420 = k12416;
var G__12420__$1 = (((G__12420 instanceof cljs.core.Keyword))?G__12420.fqn:null);
switch (G__12420__$1) {
case "on-click":
return self__.on_click;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12416,else__4383__auto__);

}
}));

(membrane.ui.OnClick.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12421){
var vec__12422 = p__12421;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12422,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12422,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClick.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClick.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClick{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClick.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12415){
var self__ = this;
var G__12415__$1 = this;
return (new cljs.core.RecordIter((0),G__12415__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClick.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var and__4115__auto__ = mouse_down_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return self__.on_click;
} else {
return and__4115__auto__;
}
})())){
return (self__.on_click.cljs$core$IFn$_invoke$arity$0 ? self__.on_click.cljs$core$IFn$_invoke$arity$0() : self__.on_click.call(null));
} else {
return null;
}
}));

(membrane.ui.OnClick.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12425,elem){
var vec__12426 = p__12425;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12426,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12426,(1),null);
var vec__12429 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12429,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12429,(1),null);
var vec__12432 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12432,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12432,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClick.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClick.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClick.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClick.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1125995677 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClick.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12417,other12418){
var self__ = this;
var this12417__$1 = this;
return (((!((other12418 == null)))) && ((this12417__$1.constructor === other12418.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12417__$1.on_click,other12418.on_click)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12417__$1.drawables,other12418.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12417__$1.__extmap,other12418.__extmap)));
}));

(membrane.ui.OnClick.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClick.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClick.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12415){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12435 = cljs.core.keyword_identical_QMARK_;
var expr__12436 = k__4388__auto__;
if(cljs.core.truth_((pred__12435.cljs$core$IFn$_invoke$arity$2 ? pred__12435.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__12436) : pred__12435.call(null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__12436)))){
return (new membrane.ui.OnClick(G__12415,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12435.cljs$core$IFn$_invoke$arity$2 ? pred__12435.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12436) : pred__12435.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12436)))){
return (new membrane.ui.OnClick(self__.on_click,G__12415,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12415),null));
}
}
}));

(membrane.ui.OnClick.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClick.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClick(self__.on_click,childs,null,null,null));
}));

(membrane.ui.OnClick.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12415){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,G__12415,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClick.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClick.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-click","on-click",-1021609226,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClick.cljs$lang$type = true);

(membrane.ui.OnClick.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClick",null,(1),null));
}));

(membrane.ui.OnClick.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClick");
}));

/**
 * Positional factory function for membrane.ui/OnClick.
 */
membrane.ui.__GT_OnClick = (function membrane$ui$__GT_OnClick(on_click,drawables){
return (new membrane.ui.OnClick(on_click,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClick, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClick = (function membrane$ui$map__GT_OnClick(G__12419){
var extmap__4419__auto__ = (function (){var G__12438 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12419,new cljs.core.Keyword(null,"on-click","on-click",1632826543),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12419)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12438);
} else {
return G__12438;
}
})();
return (new membrane.ui.OnClick(new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(G__12419),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12419),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClick,(function (draw){
return (function (this$){
var seq__12439 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12440 = null;
var count__12441 = (0);
var i__12442 = (0);
while(true){
if((i__12442 < count__12441)){
var drawable = chunk__12440.cljs$core$IIndexed$_nth$arity$2(null,i__12442);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14697 = seq__12439;
var G__14698 = chunk__12440;
var G__14699 = count__12441;
var G__14700 = (i__12442 + (1));
seq__12439 = G__14697;
chunk__12440 = G__14698;
count__12441 = G__14699;
i__12442 = G__14700;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12439);
if(temp__5735__auto__){
var seq__12439__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12439__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12439__$1);
var G__14707 = cljs.core.chunk_rest(seq__12439__$1);
var G__14708 = c__4556__auto__;
var G__14709 = cljs.core.count(c__4556__auto__);
var G__14710 = (0);
seq__12439 = G__14707;
chunk__12440 = G__14708;
count__12441 = G__14709;
i__12442 = G__14710;
continue;
} else {
var drawable = cljs.core.first(seq__12439__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14711 = cljs.core.next(seq__12439__$1);
var G__14712 = null;
var G__14713 = (0);
var G__14714 = (0);
seq__12439 = G__14711;
chunk__12440 = G__14712;
count__12441 = G__14713;
i__12442 = G__14714;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wrap an element with a mouse down event handler, on-click. 
 * 
 *   on-click must accept 0 arguments and should return a sequence of effects.
 */
membrane.ui.on_click = (function membrane$ui$on_click(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14718 = arguments.length;
var i__4737__auto___14719 = (0);
while(true){
if((i__4737__auto___14719 < len__4736__auto___14718)){
args__4742__auto__.push((arguments[i__4737__auto___14719]));

var G__14720 = (i__4737__auto___14719 + (1));
i__4737__auto___14719 = G__14720;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_click.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_click.cljs$core$IFn$_invoke$arity$variadic = (function (on_click,drawables){
return (new membrane.ui.OnClick(on_click,drawables,null,null,null));
}));

(membrane.ui.on_click.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_click.cljs$lang$applyTo = (function (seq12443){
var G__12444 = cljs.core.first(seq12443);
var seq12443__$1 = cljs.core.next(seq12443);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12444,seq12443__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseDown = (function (on_mouse_down,drawables,__meta,__extmap,__hash){
this.on_mouse_down = on_mouse_down;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseDown.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12447,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12451 = k12447;
var G__12451__$1 = (((G__12451 instanceof cljs.core.Keyword))?G__12451.fqn:null);
switch (G__12451__$1) {
case "on-mouse-down":
return self__.on_mouse_down;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12447,else__4383__auto__);

}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12452){
var vec__12453 = p__12452;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12453,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12453,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseDown{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),self__.on_mouse_down],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12446){
var self__ = this;
var G__12446__$1 = this;
return (new cljs.core.RecordIter((0),G__12446__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(mouse_down_QMARK_)){
if(cljs.core.truth_(self__.on_mouse_down)){
return (self__.on_mouse_down.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_down.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_down.call(null,pos));
} else {
return null;
}
} else {
var intents = cljs.core.some((function (p1__12445_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__12445_SHARP_,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_event(p1__12445_SHARP_,local_pos,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}),cljs.core.reverse(membrane.ui.children(this$__$1)));
return membrane.ui._bubble(this$__$1,intents);
}
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12456,elem){
var vec__12457 = p__12456;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12457,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12457,(1),null);
var vec__12460 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12460,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12460,(1),null);
var vec__12463 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12463,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12463,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-698428315 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12448,other12449){
var self__ = this;
var this12448__$1 = this;
return (((!((other12449 == null)))) && ((this12448__$1.constructor === other12449.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12448__$1.on_mouse_down,other12449.on_mouse_down)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12448__$1.drawables,other12449.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12448__$1.__extmap,other12449.__extmap)));
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12446){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12466 = cljs.core.keyword_identical_QMARK_;
var expr__12467 = k__4388__auto__;
if(cljs.core.truth_((pred__12466.cljs$core$IFn$_invoke$arity$2 ? pred__12466.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),expr__12467) : pred__12466.call(null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),expr__12467)))){
return (new membrane.ui.OnMouseDown(G__12446,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12466.cljs$core$IFn$_invoke$arity$2 ? pred__12466.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12467) : pred__12466.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12467)))){
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,G__12446,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12446),null));
}
}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),self__.on_mouse_down,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,childs,null,null,null));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12446){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,G__12446,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseDown.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-down","on-mouse-down",-1506680299,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseDown.cljs$lang$type = true);

(membrane.ui.OnMouseDown.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseDown",null,(1),null));
}));

(membrane.ui.OnMouseDown.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseDown");
}));

/**
 * Positional factory function for membrane.ui/OnMouseDown.
 */
membrane.ui.__GT_OnMouseDown = (function membrane$ui$__GT_OnMouseDown(on_mouse_down,drawables){
return (new membrane.ui.OnMouseDown(on_mouse_down,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseDown, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseDown = (function membrane$ui$map__GT_OnMouseDown(G__12450){
var extmap__4419__auto__ = (function (){var G__12469 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12450,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12450)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12469);
} else {
return G__12469;
}
})();
return (new membrane.ui.OnMouseDown(new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470).cljs$core$IFn$_invoke$arity$1(G__12450),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12450),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseDown,(function (draw){
return (function (this$){
var seq__12470 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12471 = null;
var count__12472 = (0);
var i__12473 = (0);
while(true){
if((i__12473 < count__12472)){
var drawable = chunk__12471.cljs$core$IIndexed$_nth$arity$2(null,i__12473);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14789 = seq__12470;
var G__14790 = chunk__12471;
var G__14791 = count__12472;
var G__14792 = (i__12473 + (1));
seq__12470 = G__14789;
chunk__12471 = G__14790;
count__12472 = G__14791;
i__12473 = G__14792;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12470);
if(temp__5735__auto__){
var seq__12470__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12470__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12470__$1);
var G__14793 = cljs.core.chunk_rest(seq__12470__$1);
var G__14794 = c__4556__auto__;
var G__14795 = cljs.core.count(c__4556__auto__);
var G__14796 = (0);
seq__12470 = G__14793;
chunk__12471 = G__14794;
count__12472 = G__14795;
i__12473 = G__14796;
continue;
} else {
var drawable = cljs.core.first(seq__12470__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14798 = cljs.core.next(seq__12470__$1);
var G__14799 = null;
var G__14800 = (0);
var G__14801 = (0);
seq__12470 = G__14798;
chunk__12471 = G__14799;
count__12472 = G__14800;
i__12473 = G__14801;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-down events.
 * 
 *   on-mouse-down should take 1 argument [mx my] of the mouse position in local coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_down = (function membrane$ui$on_mouse_down(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14803 = arguments.length;
var i__4737__auto___14804 = (0);
while(true){
if((i__4737__auto___14804 < len__4736__auto___14803)){
args__4742__auto__.push((arguments[i__4737__auto___14804]));

var G__14805 = (i__4737__auto___14804 + (1));
i__4737__auto___14804 = G__14805;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_down.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_down.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_down,drawables){
return (new membrane.ui.OnMouseDown(on_mouse_down,drawables,null,null,null));
}));

(membrane.ui.on_mouse_down.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_down.cljs$lang$applyTo = (function (seq12474){
var G__12475 = cljs.core.first(seq12474);
var seq12474__$1 = cljs.core.next(seq12474);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12475,seq12474__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseUp = (function (on_mouse_up,drawables,__meta,__extmap,__hash){
this.on_mouse_up = on_mouse_up;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseUp.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12478,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12482 = k12478;
var G__12482__$1 = (((G__12482 instanceof cljs.core.Keyword))?G__12482.fqn:null);
switch (G__12482__$1) {
case "on-mouse-up":
return self__.on_mouse_up;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12478,else__4383__auto__);

}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12483){
var vec__12484 = p__12483;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12484,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12484,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseUp{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),self__.on_mouse_up],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12477){
var self__ = this;
var G__12477__$1 = this;
return (new cljs.core.RecordIter((0),G__12477__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(mouse_down_QMARK_)){
var intents = cljs.core.some((function (p1__12476_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__12476_SHARP_,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_event(p1__12476_SHARP_,local_pos,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}),cljs.core.reverse(membrane.ui.children(this$__$1)));
return membrane.ui._bubble(this$__$1,intents);
} else {
if(cljs.core.truth_(self__.on_mouse_up)){
return (self__.on_mouse_up.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_up.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_up.call(null,pos));
} else {
return null;
}
}
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12487,elem){
var vec__12488 = p__12487;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12488,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12488,(1),null);
var vec__12491 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12491,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12491,(1),null);
var vec__12494 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12494,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12494,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-778849279 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12479,other12480){
var self__ = this;
var this12479__$1 = this;
return (((!((other12480 == null)))) && ((this12479__$1.constructor === other12480.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12479__$1.on_mouse_up,other12480.on_mouse_up)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12479__$1.drawables,other12480.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12479__$1.__extmap,other12480.__extmap)));
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12477){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12497 = cljs.core.keyword_identical_QMARK_;
var expr__12498 = k__4388__auto__;
if(cljs.core.truth_((pred__12497.cljs$core$IFn$_invoke$arity$2 ? pred__12497.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),expr__12498) : pred__12497.call(null,new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),expr__12498)))){
return (new membrane.ui.OnMouseUp(G__12477,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12497.cljs$core$IFn$_invoke$arity$2 ? pred__12497.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12498) : pred__12497.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12498)))){
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,G__12477,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12477),null));
}
}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),self__.on_mouse_up,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,childs,null,null,null));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12477){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,G__12477,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseUp.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-up","on-mouse-up",299998207,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseUp.cljs$lang$type = true);

(membrane.ui.OnMouseUp.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseUp",null,(1),null));
}));

(membrane.ui.OnMouseUp.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseUp");
}));

/**
 * Positional factory function for membrane.ui/OnMouseUp.
 */
membrane.ui.__GT_OnMouseUp = (function membrane$ui$__GT_OnMouseUp(on_mouse_up,drawables){
return (new membrane.ui.OnMouseUp(on_mouse_up,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseUp, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseUp = (function membrane$ui$map__GT_OnMouseUp(G__12481){
var extmap__4419__auto__ = (function (){var G__12500 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12481,new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12481)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12500);
} else {
return G__12500;
}
})();
return (new membrane.ui.OnMouseUp(new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320).cljs$core$IFn$_invoke$arity$1(G__12481),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12481),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseUp,(function (draw){
return (function (this$){
var seq__12501 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12502 = null;
var count__12503 = (0);
var i__12504 = (0);
while(true){
if((i__12504 < count__12503)){
var drawable = chunk__12502.cljs$core$IIndexed$_nth$arity$2(null,i__12504);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14835 = seq__12501;
var G__14836 = chunk__12502;
var G__14837 = count__12503;
var G__14838 = (i__12504 + (1));
seq__12501 = G__14835;
chunk__12502 = G__14836;
count__12503 = G__14837;
i__12504 = G__14838;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12501);
if(temp__5735__auto__){
var seq__12501__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12501__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12501__$1);
var G__14839 = cljs.core.chunk_rest(seq__12501__$1);
var G__14840 = c__4556__auto__;
var G__14841 = cljs.core.count(c__4556__auto__);
var G__14842 = (0);
seq__12501 = G__14839;
chunk__12502 = G__14840;
count__12503 = G__14841;
i__12504 = G__14842;
continue;
} else {
var drawable = cljs.core.first(seq__12501__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14843 = cljs.core.next(seq__12501__$1);
var G__14844 = null;
var G__14845 = (0);
var G__14846 = (0);
seq__12501 = G__14843;
chunk__12502 = G__14844;
count__12503 = G__14845;
i__12504 = G__14846;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-up events.
 * 
 *   on-mouse-up should take 1 argument [mx my] of the mouse position in local coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_up = (function membrane$ui$on_mouse_up(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14847 = arguments.length;
var i__4737__auto___14848 = (0);
while(true){
if((i__4737__auto___14848 < len__4736__auto___14847)){
args__4742__auto__.push((arguments[i__4737__auto___14848]));

var G__14850 = (i__4737__auto___14848 + (1));
i__4737__auto___14848 = G__14850;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_up.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_up.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_up,drawables){
return (new membrane.ui.OnMouseUp(on_mouse_up,drawables,null,null,null));
}));

(membrane.ui.on_mouse_up.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_up.cljs$lang$applyTo = (function (seq12505){
var G__12506 = cljs.core.first(seq12505);
var seq12505__$1 = cljs.core.next(seq12505);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12506,seq12505__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMove}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseMove = (function (on_mouse_move,drawables,__meta,__extmap,__hash){
this.on_mouse_move = on_mouse_move;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseMove.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12508,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12512 = k12508;
var G__12512__$1 = (((G__12512 instanceof cljs.core.Keyword))?G__12512.fqn:null);
switch (G__12512__$1) {
case "on-mouse-move":
return self__.on_mouse_move;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12508,else__4383__auto__);

}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12513){
var vec__12514 = p__12513;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12514,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12514,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseMove{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),self__.on_mouse_move],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12507){
var self__ = this;
var G__12507__$1 = this;
return (new cljs.core.RecordIter((0),G__12507__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12517,elem){
var vec__12518 = p__12517;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12518,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12518,(1),null);
var vec__12521 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12521,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12521,(1),null);
var vec__12524 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12524,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12524,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1514972171 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12509,other12510){
var self__ = this;
var this12509__$1 = this;
return (((!((other12510 == null)))) && ((this12509__$1.constructor === other12510.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12509__$1.on_mouse_move,other12510.on_mouse_move)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12509__$1.drawables,other12510.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12509__$1.__extmap,other12510.__extmap)));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12507){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12527 = cljs.core.keyword_identical_QMARK_;
var expr__12528 = k__4388__auto__;
if(cljs.core.truth_((pred__12527.cljs$core$IFn$_invoke$arity$2 ? pred__12527.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),expr__12528) : pred__12527.call(null,new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),expr__12528)))){
return (new membrane.ui.OnMouseMove(G__12507,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12527.cljs$core$IFn$_invoke$arity$2 ? pred__12527.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12528) : pred__12527.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12528)))){
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,G__12507,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12507),null));
}
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),self__.on_mouse_move,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,childs,null,null,null));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMouseMove$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMouseMove$_mouse_move$arity$2 = (function (this$,p__12530){
var self__ = this;
var vec__12531 = p__12530;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12531,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12531,(1),null);
var pos = vec__12531;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_mouse_move)){
return (self__.on_mouse_move.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_move.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_move.call(null,pos));
} else {
return null;
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12507){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,G__12507,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseMove.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-move","on-mouse-move",254210653,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseMove.cljs$lang$type = true);

(membrane.ui.OnMouseMove.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseMove",null,(1),null));
}));

(membrane.ui.OnMouseMove.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseMove");
}));

/**
 * Positional factory function for membrane.ui/OnMouseMove.
 */
membrane.ui.__GT_OnMouseMove = (function membrane$ui$__GT_OnMouseMove(on_mouse_move,drawables){
return (new membrane.ui.OnMouseMove(on_mouse_move,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseMove, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseMove = (function membrane$ui$map__GT_OnMouseMove(G__12511){
var extmap__4419__auto__ = (function (){var G__12534 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12511,new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12511)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12534);
} else {
return G__12534;
}
})();
return (new membrane.ui.OnMouseMove(new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874).cljs$core$IFn$_invoke$arity$1(G__12511),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12511),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseMove,(function (draw){
return (function (this$){
var seq__12535 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12536 = null;
var count__12537 = (0);
var i__12538 = (0);
while(true){
if((i__12538 < count__12537)){
var drawable = chunk__12536.cljs$core$IIndexed$_nth$arity$2(null,i__12538);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14925 = seq__12535;
var G__14926 = chunk__12536;
var G__14927 = count__12537;
var G__14928 = (i__12538 + (1));
seq__12535 = G__14925;
chunk__12536 = G__14926;
count__12537 = G__14927;
i__12538 = G__14928;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12535);
if(temp__5735__auto__){
var seq__12535__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12535__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12535__$1);
var G__14929 = cljs.core.chunk_rest(seq__12535__$1);
var G__14930 = c__4556__auto__;
var G__14931 = cljs.core.count(c__4556__auto__);
var G__14932 = (0);
seq__12535 = G__14929;
chunk__12536 = G__14930;
count__12537 = G__14931;
i__12538 = G__14932;
continue;
} else {
var drawable = cljs.core.first(seq__12535__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__14936 = cljs.core.next(seq__12535__$1);
var G__14937 = null;
var G__14938 = (0);
var G__14939 = (0);
seq__12535 = G__14936;
chunk__12536 = G__14937;
count__12537 = G__14938;
i__12538 = G__14939;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-move events.
 * 
 *   on-mouse-move down should take 1 argument [mx my] of the mouse position in local coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_move = (function membrane$ui$on_mouse_move(var_args){
var args__4742__auto__ = [];
var len__4736__auto___14943 = arguments.length;
var i__4737__auto___14944 = (0);
while(true){
if((i__4737__auto___14944 < len__4736__auto___14943)){
args__4742__auto__.push((arguments[i__4737__auto___14944]));

var G__14945 = (i__4737__auto___14944 + (1));
i__4737__auto___14944 = G__14945;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_move,drawables){
return (new membrane.ui.OnMouseMove(on_mouse_move,drawables,null,null,null));
}));

(membrane.ui.on_mouse_move.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_move.cljs$lang$applyTo = (function (seq12539){
var G__12540 = cljs.core.first(seq12539);
var seq12539__$1 = cljs.core.next(seq12539);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12540,seq12539__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMoveGlobal}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IHasMouseMoveGlobal}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseMoveGlobal = (function (on_mouse_move_global,drawables,__meta,__extmap,__hash){
this.on_mouse_move_global = on_mouse_move_global;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12542,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12546 = k12542;
var G__12546__$1 = (((G__12546 instanceof cljs.core.Keyword))?G__12546.fqn:null);
switch (G__12546__$1) {
case "on-mouse-move-global":
return self__.on_mouse_move_global;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12542,else__4383__auto__);

}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12547){
var vec__12548 = p__12547;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12548,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12548,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IHasMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return true;
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseMoveGlobal{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),self__.on_mouse_move_global],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12541){
var self__ = this;
var G__12541__$1 = this;
return (new cljs.core.RecordIter((0),G__12541__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12551,elem){
var vec__12552 = p__12551;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12552,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12552,(1),null);
var vec__12555 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12555,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12555,(1),null);
var vec__12558 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12558,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12558,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1067455229 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12543,other12544){
var self__ = this;
var this12543__$1 = this;
return (((!((other12544 == null)))) && ((this12543__$1.constructor === other12544.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12543__$1.on_mouse_move_global,other12544.on_mouse_move_global)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12543__$1.drawables,other12544.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12543__$1.__extmap,other12544.__extmap)));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12541){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12561 = cljs.core.keyword_identical_QMARK_;
var expr__12562 = k__4388__auto__;
if(cljs.core.truth_((pred__12561.cljs$core$IFn$_invoke$arity$2 ? pred__12561.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),expr__12562) : pred__12561.call(null,new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),expr__12562)))){
return (new membrane.ui.OnMouseMoveGlobal(G__12541,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12561.cljs$core$IFn$_invoke$arity$2 ? pred__12561.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12562) : pred__12561.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12562)))){
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,G__12541,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12541),null));
}
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),self__.on_mouse_move_global,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,childs,null,null,null));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12541){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,G__12541,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_mouse_move_global)){
return (self__.on_mouse_move_global.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_move_global.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_move_global.call(null,pos));
} else {
return null;
}
}));

(membrane.ui.OnMouseMoveGlobal.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-move-global","on-mouse-move-global",-366493693,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseMoveGlobal.cljs$lang$type = true);

(membrane.ui.OnMouseMoveGlobal.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseMoveGlobal",null,(1),null));
}));

(membrane.ui.OnMouseMoveGlobal.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseMoveGlobal");
}));

/**
 * Positional factory function for membrane.ui/OnMouseMoveGlobal.
 */
membrane.ui.__GT_OnMouseMoveGlobal = (function membrane$ui$__GT_OnMouseMoveGlobal(on_mouse_move_global,drawables){
return (new membrane.ui.OnMouseMoveGlobal(on_mouse_move_global,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseMoveGlobal, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseMoveGlobal = (function membrane$ui$map__GT_OnMouseMoveGlobal(G__12545){
var extmap__4419__auto__ = (function (){var G__12564 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12545,new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12545)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12564);
} else {
return G__12564;
}
})();
return (new membrane.ui.OnMouseMoveGlobal(new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220).cljs$core$IFn$_invoke$arity$1(G__12545),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12545),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseMoveGlobal,(function (draw){
return (function (this$){
var seq__12565 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12566 = null;
var count__12567 = (0);
var i__12568 = (0);
while(true){
if((i__12568 < count__12567)){
var drawable = chunk__12566.cljs$core$IIndexed$_nth$arity$2(null,i__12568);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15006 = seq__12565;
var G__15007 = chunk__12566;
var G__15008 = count__12567;
var G__15009 = (i__12568 + (1));
seq__12565 = G__15006;
chunk__12566 = G__15007;
count__12567 = G__15008;
i__12568 = G__15009;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12565);
if(temp__5735__auto__){
var seq__12565__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12565__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12565__$1);
var G__15018 = cljs.core.chunk_rest(seq__12565__$1);
var G__15019 = c__4556__auto__;
var G__15020 = cljs.core.count(c__4556__auto__);
var G__15021 = (0);
seq__12565 = G__15018;
chunk__12566 = G__15019;
count__12567 = G__15020;
i__12568 = G__15021;
continue;
} else {
var drawable = cljs.core.first(seq__12565__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15022 = cljs.core.next(seq__12565__$1);
var G__15023 = null;
var G__15024 = (0);
var G__15025 = (0);
seq__12565 = G__15022;
chunk__12566 = G__15023;
count__12567 = G__15024;
i__12568 = G__15025;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-move-global events.
 * 
 *   on-mouse-move-global down should take 1 argument [mx my] of the mouse position in global coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_move_global = (function membrane$ui$on_mouse_move_global(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15026 = arguments.length;
var i__4737__auto___15027 = (0);
while(true){
if((i__4737__auto___15027 < len__4736__auto___15026)){
args__4742__auto__.push((arguments[i__4737__auto___15027]));

var G__15028 = (i__4737__auto___15027 + (1));
i__4737__auto___15027 = G__15028;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_move_global,drawables){
return (new membrane.ui.OnMouseMoveGlobal(on_mouse_move_global,drawables,null,null,null));
}));

(membrane.ui.on_mouse_move_global.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_move_global.cljs$lang$applyTo = (function (seq12569){
var G__12570 = cljs.core.first(seq12569);
var seq12569__$1 = cljs.core.next(seq12569);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12570,seq12569__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseEvent = (function (on_mouse_event,drawables,__meta,__extmap,__hash){
this.on_mouse_event = on_mouse_event;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseEvent.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12572,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12576 = k12572;
var G__12576__$1 = (((G__12576 instanceof cljs.core.Keyword))?G__12576.fqn:null);
switch (G__12576__$1) {
case "on-mouse-event":
return self__.on_mouse_event;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12572,else__4383__auto__);

}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12577){
var vec__12578 = p__12577;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12578,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12578,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseEvent{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),self__.on_mouse_event],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12571){
var self__ = this;
var G__12571__$1 = this;
return (new cljs.core.RecordIter((0),G__12571__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_mouse_event)){
return (self__.on_mouse_event.cljs$core$IFn$_invoke$arity$4 ? self__.on_mouse_event.cljs$core$IFn$_invoke$arity$4(pos,button,mouse_down_QMARK_,mods) : self__.on_mouse_event.call(null,pos,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12581,elem){
var vec__12582 = p__12581;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12582,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12582,(1),null);
var vec__12585 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12585,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12585,(1),null);
var vec__12588 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12588,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12588,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2107328521 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12573,other12574){
var self__ = this;
var this12573__$1 = this;
return (((!((other12574 == null)))) && ((this12573__$1.constructor === other12574.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12573__$1.on_mouse_event,other12574.on_mouse_event)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12573__$1.drawables,other12574.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12573__$1.__extmap,other12574.__extmap)));
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12571){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12591 = cljs.core.keyword_identical_QMARK_;
var expr__12592 = k__4388__auto__;
if(cljs.core.truth_((pred__12591.cljs$core$IFn$_invoke$arity$2 ? pred__12591.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),expr__12592) : pred__12591.call(null,new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),expr__12592)))){
return (new membrane.ui.OnMouseEvent(G__12571,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12591.cljs$core$IFn$_invoke$arity$2 ? pred__12591.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12592) : pred__12591.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12592)))){
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,G__12571,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12571),null));
}
}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),self__.on_mouse_event,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,childs,null,null,null));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12571){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,G__12571,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseEvent.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-event","on-mouse-event",712292405,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseEvent.cljs$lang$type = true);

(membrane.ui.OnMouseEvent.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseEvent",null,(1),null));
}));

(membrane.ui.OnMouseEvent.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseEvent");
}));

/**
 * Positional factory function for membrane.ui/OnMouseEvent.
 */
membrane.ui.__GT_OnMouseEvent = (function membrane$ui$__GT_OnMouseEvent(on_mouse_event,drawables){
return (new membrane.ui.OnMouseEvent(on_mouse_event,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseEvent, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseEvent = (function membrane$ui$map__GT_OnMouseEvent(G__12575){
var extmap__4419__auto__ = (function (){var G__12594 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12575,new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12575)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12594);
} else {
return G__12594;
}
})();
return (new membrane.ui.OnMouseEvent(new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122).cljs$core$IFn$_invoke$arity$1(G__12575),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12575),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseEvent,(function (draw){
return (function (this$){
var seq__12595 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12596 = null;
var count__12597 = (0);
var i__12598 = (0);
while(true){
if((i__12598 < count__12597)){
var drawable = chunk__12596.cljs$core$IIndexed$_nth$arity$2(null,i__12598);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15115 = seq__12595;
var G__15116 = chunk__12596;
var G__15117 = count__12597;
var G__15118 = (i__12598 + (1));
seq__12595 = G__15115;
chunk__12596 = G__15116;
count__12597 = G__15117;
i__12598 = G__15118;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12595);
if(temp__5735__auto__){
var seq__12595__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12595__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12595__$1);
var G__15123 = cljs.core.chunk_rest(seq__12595__$1);
var G__15124 = c__4556__auto__;
var G__15125 = cljs.core.count(c__4556__auto__);
var G__15126 = (0);
seq__12595 = G__15123;
chunk__12596 = G__15124;
count__12597 = G__15125;
i__12598 = G__15126;
continue;
} else {
var drawable = cljs.core.first(seq__12595__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15127 = cljs.core.next(seq__12595__$1);
var G__15128 = null;
var G__15129 = (0);
var G__15130 = (0);
seq__12595 = G__15127;
chunk__12596 = G__15128;
count__12597 = G__15129;
i__12598 = G__15130;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse events.
 * 
 *   on-mouse-event should take 4 arguments [pos button mouse-down? mods] and return a sequence of effects.
 */
membrane.ui.on_mouse_event = (function membrane$ui$on_mouse_event(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15131 = arguments.length;
var i__4737__auto___15132 = (0);
while(true){
if((i__4737__auto___15132 < len__4736__auto___15131)){
args__4742__auto__.push((arguments[i__4737__auto___15132]));

var G__15133 = (i__4737__auto___15132 + (1));
i__4737__auto___15132 = G__15133;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_event,drawables){
return (new membrane.ui.OnMouseEvent(on_mouse_event,drawables,null,null,null));
}));

(membrane.ui.on_mouse_event.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_event.cljs$lang$applyTo = (function (seq12599){
var G__12600 = cljs.core.first(seq12599);
var seq12599__$1 = cljs.core.next(seq12599);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12600,seq12599__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {membrane.ui.IDrop}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnDrop = (function (on_drop,drawables,__meta,__extmap,__hash){
this.on_drop = on_drop;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnDrop.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnDrop.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12602,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12606 = k12602;
var G__12606__$1 = (((G__12606 instanceof cljs.core.Keyword))?G__12606.fqn:null);
switch (G__12606__$1) {
case "on-drop":
return self__.on_drop;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12602,else__4383__auto__);

}
}));

(membrane.ui.OnDrop.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12607){
var vec__12608 = p__12607;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12608,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12608,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnDrop.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnDrop{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),self__.on_drop],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnDrop.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12601){
var self__ = this;
var G__12601__$1 = this;
return (new cljs.core.RecordIter((0),G__12601__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12611,elem){
var vec__12612 = p__12611;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12612,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12612,(1),null);
var vec__12615 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12615,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12615,(1),null);
var vec__12618 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12618,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12618,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnDrop.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnDrop.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnDrop.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnDrop.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1580704880 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnDrop.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12603,other12604){
var self__ = this;
var this12603__$1 = this;
return (((!((other12604 == null)))) && ((this12603__$1.constructor === other12604.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12603__$1.on_drop,other12604.on_drop)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12603__$1.drawables,other12604.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12603__$1.__extmap,other12604.__extmap)));
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnDrop.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnDrop.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12601){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12621 = cljs.core.keyword_identical_QMARK_;
var expr__12622 = k__4388__auto__;
if(cljs.core.truth_((pred__12621.cljs$core$IFn$_invoke$arity$2 ? pred__12621.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),expr__12622) : pred__12621.call(null,new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),expr__12622)))){
return (new membrane.ui.OnDrop(G__12601,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12621.cljs$core$IFn$_invoke$arity$2 ? pred__12621.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12622) : pred__12621.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12622)))){
return (new membrane.ui.OnDrop(self__.on_drop,G__12601,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12601),null));
}
}
}));

(membrane.ui.OnDrop.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),self__.on_drop,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnDrop(self__.on_drop,childs,null,null,null));
}));

(membrane.ui.OnDrop.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12601){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,G__12601,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnDrop.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IDrop$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IDrop$_drop$arity$3 = (function (this$,paths,pos){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_drop)){
return (self__.on_drop.cljs$core$IFn$_invoke$arity$2 ? self__.on_drop.cljs$core$IFn$_invoke$arity$2(paths,pos) : self__.on_drop.call(null,paths,pos));
} else {
return null;
}
}));

(membrane.ui.OnDrop.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-drop","on-drop",-786567278,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnDrop.cljs$lang$type = true);

(membrane.ui.OnDrop.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnDrop",null,(1),null));
}));

(membrane.ui.OnDrop.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnDrop");
}));

/**
 * Positional factory function for membrane.ui/OnDrop.
 */
membrane.ui.__GT_OnDrop = (function membrane$ui$__GT_OnDrop(on_drop,drawables){
return (new membrane.ui.OnDrop(on_drop,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnDrop, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnDrop = (function membrane$ui$map__GT_OnDrop(G__12605){
var extmap__4419__auto__ = (function (){var G__12624 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12605,new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12605)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12624);
} else {
return G__12624;
}
})();
return (new membrane.ui.OnDrop(new cljs.core.Keyword(null,"on-drop","on-drop",1867868491).cljs$core$IFn$_invoke$arity$1(G__12605),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12605),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnDrop,(function (draw){
return (function (this$){
var seq__12625 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12626 = null;
var count__12627 = (0);
var i__12628 = (0);
while(true){
if((i__12628 < count__12627)){
var drawable = chunk__12626.cljs$core$IIndexed$_nth$arity$2(null,i__12628);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15176 = seq__12625;
var G__15177 = chunk__12626;
var G__15178 = count__12627;
var G__15179 = (i__12628 + (1));
seq__12625 = G__15176;
chunk__12626 = G__15177;
count__12627 = G__15178;
i__12628 = G__15179;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12625);
if(temp__5735__auto__){
var seq__12625__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12625__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12625__$1);
var G__15180 = cljs.core.chunk_rest(seq__12625__$1);
var G__15181 = c__4556__auto__;
var G__15182 = cljs.core.count(c__4556__auto__);
var G__15183 = (0);
seq__12625 = G__15180;
chunk__12626 = G__15181;
count__12627 = G__15182;
i__12628 = G__15183;
continue;
} else {
var drawable = cljs.core.first(seq__12625__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15184 = cljs.core.next(seq__12625__$1);
var G__15185 = null;
var G__15186 = (0);
var G__15187 = (0);
seq__12625 = G__15184;
chunk__12626 = G__15185;
count__12627 = G__15186;
i__12628 = G__15187;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for drop events.
 * 
 *   on-drop should take 2 arguments [paths pos] and return a sequence of effects.
 */
membrane.ui.on_drop = (function membrane$ui$on_drop(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15188 = arguments.length;
var i__4737__auto___15189 = (0);
while(true){
if((i__4737__auto___15189 < len__4736__auto___15188)){
args__4742__auto__.push((arguments[i__4737__auto___15189]));

var G__15190 = (i__4737__auto___15189 + (1));
i__4737__auto___15189 = G__15190;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_drop.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_drop.cljs$core$IFn$_invoke$arity$variadic = (function (on_drop,drawables){
return (new membrane.ui.OnDrop(on_drop,drawables,null,null,null));
}));

(membrane.ui.on_drop.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_drop.cljs$lang$applyTo = (function (seq12629){
var G__12630 = cljs.core.first(seq12629);
var seq12629__$1 = cljs.core.next(seq12629);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12630,seq12629__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IHasKeyPress}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IKeyPress}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnKeyPress = (function (on_key_press,drawables,__meta,__extmap,__hash){
this.on_key_press = on_key_press;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnKeyPress.prototype.membrane$ui$IHasKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IHasKeyPress$has_key_press$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.boolean$(self__.on_key_press);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12632,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12636 = k12632;
var G__12636__$1 = (((G__12636 instanceof cljs.core.Keyword))?G__12636.fqn:null);
switch (G__12636__$1) {
case "on-key-press":
return self__.on_key_press;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12632,else__4383__auto__);

}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12637){
var vec__12638 = p__12637;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12638,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12638,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnKeyPress{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),self__.on_key_press],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12631){
var self__ = this;
var G__12631__$1 = this;
return (new cljs.core.RecordIter((0),G__12631__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12641,elem){
var vec__12642 = p__12641;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12642,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12642,(1),null);
var vec__12645 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12645,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12645,(1),null);
var vec__12648 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12648,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12648,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IKeyPress$_key_press$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_key_press)){
return (self__.on_key_press.cljs$core$IFn$_invoke$arity$1 ? self__.on_key_press.cljs$core$IFn$_invoke$arity$1(key) : self__.on_key_press.call(null,key));
} else {
return null;
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (515211784 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12633,other12634){
var self__ = this;
var this12633__$1 = this;
return (((!((other12634 == null)))) && ((this12633__$1.constructor === other12634.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12633__$1.on_key_press,other12634.on_key_press)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12633__$1.drawables,other12634.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12633__$1.__extmap,other12634.__extmap)));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12631){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12651 = cljs.core.keyword_identical_QMARK_;
var expr__12652 = k__4388__auto__;
if(cljs.core.truth_((pred__12651.cljs$core$IFn$_invoke$arity$2 ? pred__12651.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),expr__12652) : pred__12651.call(null,new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),expr__12652)))){
return (new membrane.ui.OnKeyPress(G__12631,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12651.cljs$core$IFn$_invoke$arity$2 ? pred__12651.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12652) : pred__12651.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12652)))){
return (new membrane.ui.OnKeyPress(self__.on_key_press,G__12631,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12631),null));
}
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),self__.on_key_press,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnKeyPress(self__.on_key_press,childs,null,null,null));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12631){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,G__12631,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnKeyPress.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-key-press","on-key-press",1240967850,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnKeyPress.cljs$lang$type = true);

(membrane.ui.OnKeyPress.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnKeyPress",null,(1),null));
}));

(membrane.ui.OnKeyPress.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnKeyPress");
}));

/**
 * Positional factory function for membrane.ui/OnKeyPress.
 */
membrane.ui.__GT_OnKeyPress = (function membrane$ui$__GT_OnKeyPress(on_key_press,drawables){
return (new membrane.ui.OnKeyPress(on_key_press,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnKeyPress, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnKeyPress = (function membrane$ui$map__GT_OnKeyPress(G__12635){
var extmap__4419__auto__ = (function (){var G__12654 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12635,new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12635)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12654);
} else {
return G__12654;
}
})();
return (new membrane.ui.OnKeyPress(new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677).cljs$core$IFn$_invoke$arity$1(G__12635),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12635),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnKeyPress,(function (draw){
return (function (this$){
var seq__12655 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12656 = null;
var count__12657 = (0);
var i__12658 = (0);
while(true){
if((i__12658 < count__12657)){
var drawable = chunk__12656.cljs$core$IIndexed$_nth$arity$2(null,i__12658);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15230 = seq__12655;
var G__15231 = chunk__12656;
var G__15232 = count__12657;
var G__15233 = (i__12658 + (1));
seq__12655 = G__15230;
chunk__12656 = G__15231;
count__12657 = G__15232;
i__12658 = G__15233;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12655);
if(temp__5735__auto__){
var seq__12655__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12655__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12655__$1);
var G__15235 = cljs.core.chunk_rest(seq__12655__$1);
var G__15236 = c__4556__auto__;
var G__15237 = cljs.core.count(c__4556__auto__);
var G__15238 = (0);
seq__12655 = G__15235;
chunk__12656 = G__15236;
count__12657 = G__15237;
i__12658 = G__15238;
continue;
} else {
var drawable = cljs.core.first(seq__12655__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15246 = cljs.core.next(seq__12655__$1);
var G__15247 = null;
var G__15248 = (0);
var G__15249 = (0);
seq__12655 = G__15246;
chunk__12656 = G__15247;
count__12657 = G__15248;
i__12658 = G__15249;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for key-press events.
 * 
 *   on-key-press should take 1 argument key and return a sequence of effects.
 */
membrane.ui.on_key_press = (function membrane$ui$on_key_press(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15250 = arguments.length;
var i__4737__auto___15251 = (0);
while(true){
if((i__4737__auto___15251 < len__4736__auto___15250)){
args__4742__auto__.push((arguments[i__4737__auto___15251]));

var G__15252 = (i__4737__auto___15251 + (1));
i__4737__auto___15251 = G__15252;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic = (function (on_key_press,drawables){
return (new membrane.ui.OnKeyPress(on_key_press,drawables,null,null,null));
}));

(membrane.ui.on_key_press.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_key_press.cljs$lang$applyTo = (function (seq12659){
var G__12660 = cljs.core.first(seq12659);
var seq12659__$1 = cljs.core.next(seq12659);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12660,seq12659__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IHasKeyEvent}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IKeyEvent}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnKeyEvent = (function (on_key_event,drawables,__meta,__extmap,__hash){
this.on_key_event = on_key_event;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12662,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12666 = k12662;
var G__12666__$1 = (((G__12666 instanceof cljs.core.Keyword))?G__12666.fqn:null);
switch (G__12666__$1) {
case "on-key-event":
return self__.on_key_event;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12662,else__4383__auto__);

}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12667){
var vec__12668 = p__12667;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12668,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12668,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnKeyEvent{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),self__.on_key_event],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12661){
var self__ = this;
var G__12661__$1 = this;
return (new cljs.core.RecordIter((0),G__12661__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12671,elem){
var vec__12672 = p__12671;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12672,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12672,(1),null);
var vec__12675 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12675,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12675,(1),null);
var vec__12678 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12678,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12678,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IKeyEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IKeyEvent$_key_event$arity$5 = (function (this$,key,scancode,action,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_key_event)){
return (self__.on_key_event.cljs$core$IFn$_invoke$arity$4 ? self__.on_key_event.cljs$core$IFn$_invoke$arity$4(key,scancode,action,mods) : self__.on_key_event.call(null,key,scancode,action,mods));
} else {
return null;
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2051278419 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12663,other12664){
var self__ = this;
var this12663__$1 = this;
return (((!((other12664 == null)))) && ((this12663__$1.constructor === other12664.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12663__$1.on_key_event,other12664.on_key_event)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12663__$1.drawables,other12664.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12663__$1.__extmap,other12664.__extmap)));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12661){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12681 = cljs.core.keyword_identical_QMARK_;
var expr__12682 = k__4388__auto__;
if(cljs.core.truth_((pred__12681.cljs$core$IFn$_invoke$arity$2 ? pred__12681.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),expr__12682) : pred__12681.call(null,new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),expr__12682)))){
return (new membrane.ui.OnKeyEvent(G__12661,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12681.cljs$core$IFn$_invoke$arity$2 ? pred__12681.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12682) : pred__12681.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12682)))){
return (new membrane.ui.OnKeyEvent(self__.on_key_event,G__12661,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12661),null));
}
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),self__.on_key_event,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnKeyEvent(self__.on_key_event,childs,null,null,null));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12661){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,G__12661,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IHasKeyEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IHasKeyEvent$has_key_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.boolean$(self__.on_key_event);
}));

(membrane.ui.OnKeyEvent.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-key-event","on-key-event",-1735181456,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnKeyEvent.cljs$lang$type = true);

(membrane.ui.OnKeyEvent.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnKeyEvent",null,(1),null));
}));

(membrane.ui.OnKeyEvent.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnKeyEvent");
}));

/**
 * Positional factory function for membrane.ui/OnKeyEvent.
 */
membrane.ui.__GT_OnKeyEvent = (function membrane$ui$__GT_OnKeyEvent(on_key_event,drawables){
return (new membrane.ui.OnKeyEvent(on_key_event,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnKeyEvent, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnKeyEvent = (function membrane$ui$map__GT_OnKeyEvent(G__12665){
var extmap__4419__auto__ = (function (){var G__12684 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12665,new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12665)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12684);
} else {
return G__12684;
}
})();
return (new membrane.ui.OnKeyEvent(new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313).cljs$core$IFn$_invoke$arity$1(G__12665),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12665),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnKeyEvent,(function (draw){
return (function (this$){
var seq__12685 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12686 = null;
var count__12687 = (0);
var i__12688 = (0);
while(true){
if((i__12688 < count__12687)){
var drawable = chunk__12686.cljs$core$IIndexed$_nth$arity$2(null,i__12688);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15326 = seq__12685;
var G__15327 = chunk__12686;
var G__15328 = count__12687;
var G__15329 = (i__12688 + (1));
seq__12685 = G__15326;
chunk__12686 = G__15327;
count__12687 = G__15328;
i__12688 = G__15329;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12685);
if(temp__5735__auto__){
var seq__12685__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12685__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12685__$1);
var G__15331 = cljs.core.chunk_rest(seq__12685__$1);
var G__15332 = c__4556__auto__;
var G__15333 = cljs.core.count(c__4556__auto__);
var G__15334 = (0);
seq__12685 = G__15331;
chunk__12686 = G__15332;
count__12687 = G__15333;
i__12688 = G__15334;
continue;
} else {
var drawable = cljs.core.first(seq__12685__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15336 = cljs.core.next(seq__12685__$1);
var G__15337 = null;
var G__15338 = (0);
var G__15339 = (0);
seq__12685 = G__15336;
chunk__12686 = G__15337;
count__12687 = G__15338;
i__12688 = G__15339;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for key events.
 * 
 *   on-key-event should take 4 arguments key, scancode, action, mods and return a sequence of effects.
 */
membrane.ui.on_key_event = (function membrane$ui$on_key_event(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15343 = arguments.length;
var i__4737__auto___15344 = (0);
while(true){
if((i__4737__auto___15344 < len__4736__auto___15343)){
args__4742__auto__.push((arguments[i__4737__auto___15344]));

var G__15345 = (i__4737__auto___15344 + (1));
i__4737__auto___15344 = G__15345;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic = (function (on_key_event,drawables){
return (new membrane.ui.OnKeyEvent(on_key_event,drawables,null,null,null));
}));

(membrane.ui.on_key_event.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_key_event.cljs$lang$applyTo = (function (seq12689){
var G__12690 = cljs.core.first(seq12689);
var seq12689__$1 = cljs.core.next(seq12689);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12690,seq12689__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {membrane.ui.IBubble}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnBubble = (function (on_bubble,drawables,__meta,__extmap,__hash){
this.on_bubble = on_bubble;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnBubble.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnBubble.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12692,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12696 = k12692;
var G__12696__$1 = (((G__12696 instanceof cljs.core.Keyword))?G__12696.fqn:null);
switch (G__12696__$1) {
case "on-bubble":
return self__.on_bubble;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12692,else__4383__auto__);

}
}));

(membrane.ui.OnBubble.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12697){
var vec__12698 = p__12697;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12698,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12698,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnBubble.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnBubble{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),self__.on_bubble],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnBubble.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12691){
var self__ = this;
var G__12691__$1 = this;
return (new cljs.core.RecordIter((0),G__12691__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12701,elem){
var vec__12702 = p__12701;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12702,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12702,(1),null);
var vec__12705 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12705,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12705,(1),null);
var vec__12708 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12708,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12708,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnBubble.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnBubble.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnBubble.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnBubble.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1969513103 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnBubble.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12693,other12694){
var self__ = this;
var this12693__$1 = this;
return (((!((other12694 == null)))) && ((this12693__$1.constructor === other12694.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12693__$1.on_bubble,other12694.on_bubble)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12693__$1.drawables,other12694.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12693__$1.__extmap,other12694.__extmap)));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IBubble$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IBubble$_bubble$arity$2 = (function (this$,effects){
var self__ = this;
var this$__$1 = this;
return (self__.on_bubble.cljs$core$IFn$_invoke$arity$1 ? self__.on_bubble.cljs$core$IFn$_invoke$arity$1(effects) : self__.on_bubble.call(null,effects));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnBubble.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnBubble.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12691){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12711 = cljs.core.keyword_identical_QMARK_;
var expr__12712 = k__4388__auto__;
if(cljs.core.truth_((pred__12711.cljs$core$IFn$_invoke$arity$2 ? pred__12711.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),expr__12712) : pred__12711.call(null,new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),expr__12712)))){
return (new membrane.ui.OnBubble(G__12691,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12711.cljs$core$IFn$_invoke$arity$2 ? pred__12711.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12712) : pred__12711.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12712)))){
return (new membrane.ui.OnBubble(self__.on_bubble,G__12691,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12691),null));
}
}
}));

(membrane.ui.OnBubble.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),self__.on_bubble,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnBubble(self__.on_bubble,childs,null,null,null));
}));

(membrane.ui.OnBubble.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12691){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,G__12691,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnBubble.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnBubble.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-bubble","on-bubble",-725584761,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnBubble.cljs$lang$type = true);

(membrane.ui.OnBubble.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnBubble",null,(1),null));
}));

(membrane.ui.OnBubble.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnBubble");
}));

/**
 * Positional factory function for membrane.ui/OnBubble.
 */
membrane.ui.__GT_OnBubble = (function membrane$ui$__GT_OnBubble(on_bubble,drawables){
return (new membrane.ui.OnBubble(on_bubble,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnBubble, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnBubble = (function membrane$ui$map__GT_OnBubble(G__12695){
var extmap__4419__auto__ = (function (){var G__12714 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12695,new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12695)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12714);
} else {
return G__12714;
}
})();
return (new membrane.ui.OnBubble(new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008).cljs$core$IFn$_invoke$arity$1(G__12695),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12695),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnBubble,(function (draw){
return (function (this$){
var seq__12715 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12716 = null;
var count__12717 = (0);
var i__12718 = (0);
while(true){
if((i__12718 < count__12717)){
var drawable = chunk__12716.cljs$core$IIndexed$_nth$arity$2(null,i__12718);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15365 = seq__12715;
var G__15366 = chunk__12716;
var G__15367 = count__12717;
var G__15368 = (i__12718 + (1));
seq__12715 = G__15365;
chunk__12716 = G__15366;
count__12717 = G__15367;
i__12718 = G__15368;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12715);
if(temp__5735__auto__){
var seq__12715__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12715__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12715__$1);
var G__15372 = cljs.core.chunk_rest(seq__12715__$1);
var G__15373 = c__4556__auto__;
var G__15374 = cljs.core.count(c__4556__auto__);
var G__15375 = (0);
seq__12715 = G__15372;
chunk__12716 = G__15373;
count__12717 = G__15374;
i__12718 = G__15375;
continue;
} else {
var drawable = cljs.core.first(seq__12715__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15376 = cljs.core.next(seq__12715__$1);
var G__15377 = null;
var G__15378 = (0);
var G__15379 = (0);
seq__12715 = G__15376;
chunk__12716 = G__15377;
count__12717 = G__15378;
i__12718 = G__15379;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for bubbling
 * 
 *   on-bubble should take seq of effects
 */
membrane.ui.on_bubble = (function membrane$ui$on_bubble(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15380 = arguments.length;
var i__4737__auto___15381 = (0);
while(true){
if((i__4737__auto___15381 < len__4736__auto___15380)){
args__4742__auto__.push((arguments[i__4737__auto___15381]));

var G__15382 = (i__4737__auto___15381 + (1));
i__4737__auto___15381 = G__15382;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_bubble.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_bubble.cljs$core$IFn$_invoke$arity$variadic = (function (on_bubble,drawables){
return (new membrane.ui.OnBubble(on_bubble,drawables,null,null,null));
}));

(membrane.ui.on_bubble.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_bubble.cljs$lang$applyTo = (function (seq12719){
var G__12720 = cljs.core.first(seq12719);
var seq12719__$1 = cljs.core.next(seq12719);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12720,seq12719__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IClipboardPaste}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClipboardPaste = (function (on_clipboard_paste,drawables,__meta,__extmap,__hash){
this.on_clipboard_paste = on_clipboard_paste;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClipboardPaste.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12722,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12726 = k12722;
var G__12726__$1 = (((G__12726 instanceof cljs.core.Keyword))?G__12726.fqn:null);
switch (G__12726__$1) {
case "on-clipboard-paste":
return self__.on_clipboard_paste;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12722,else__4383__auto__);

}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12727){
var vec__12728 = p__12727;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12728,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12728,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClipboardPaste{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),self__.on_clipboard_paste],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12721){
var self__ = this;
var G__12721__$1 = this;
return (new cljs.core.RecordIter((0),G__12721__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12731,elem){
var vec__12732 = p__12731;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12732,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12732,(1),null);
var vec__12735 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12735,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12735,(1),null);
var vec__12738 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12738,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12738,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1782102848 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12723,other12724){
var self__ = this;
var this12723__$1 = this;
return (((!((other12724 == null)))) && ((this12723__$1.constructor === other12724.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12723__$1.on_clipboard_paste,other12724.on_clipboard_paste)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12723__$1.drawables,other12724.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12723__$1.__extmap,other12724.__extmap)));
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IClipboardPaste$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2 = (function (this$,s){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_clipboard_paste)){
return (self__.on_clipboard_paste.cljs$core$IFn$_invoke$arity$1 ? self__.on_clipboard_paste.cljs$core$IFn$_invoke$arity$1(s) : self__.on_clipboard_paste.call(null,s));
} else {
return null;
}
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12721){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12741 = cljs.core.keyword_identical_QMARK_;
var expr__12742 = k__4388__auto__;
if(cljs.core.truth_((pred__12741.cljs$core$IFn$_invoke$arity$2 ? pred__12741.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),expr__12742) : pred__12741.call(null,new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),expr__12742)))){
return (new membrane.ui.OnClipboardPaste(G__12721,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12741.cljs$core$IFn$_invoke$arity$2 ? pred__12741.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12742) : pred__12741.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12742)))){
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,G__12721,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12721),null));
}
}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),self__.on_clipboard_paste,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,childs,null,null,null));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12721){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,G__12721,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClipboardPaste.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-clipboard-paste","on-clipboard-paste",-69142678,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClipboardPaste.cljs$lang$type = true);

(membrane.ui.OnClipboardPaste.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClipboardPaste",null,(1),null));
}));

(membrane.ui.OnClipboardPaste.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClipboardPaste");
}));

/**
 * Positional factory function for membrane.ui/OnClipboardPaste.
 */
membrane.ui.__GT_OnClipboardPaste = (function membrane$ui$__GT_OnClipboardPaste(on_clipboard_paste,drawables){
return (new membrane.ui.OnClipboardPaste(on_clipboard_paste,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClipboardPaste, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClipboardPaste = (function membrane$ui$map__GT_OnClipboardPaste(G__12725){
var extmap__4419__auto__ = (function (){var G__12744 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12725,new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12725)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12744);
} else {
return G__12744;
}
})();
return (new membrane.ui.OnClipboardPaste(new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205).cljs$core$IFn$_invoke$arity$1(G__12725),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12725),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClipboardPaste,(function (draw){
return (function (this$){
var seq__12745 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12746 = null;
var count__12747 = (0);
var i__12748 = (0);
while(true){
if((i__12748 < count__12747)){
var drawable = chunk__12746.cljs$core$IIndexed$_nth$arity$2(null,i__12748);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15407 = seq__12745;
var G__15408 = chunk__12746;
var G__15409 = count__12747;
var G__15410 = (i__12748 + (1));
seq__12745 = G__15407;
chunk__12746 = G__15408;
count__12747 = G__15409;
i__12748 = G__15410;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12745);
if(temp__5735__auto__){
var seq__12745__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12745__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12745__$1);
var G__15426 = cljs.core.chunk_rest(seq__12745__$1);
var G__15427 = c__4556__auto__;
var G__15428 = cljs.core.count(c__4556__auto__);
var G__15429 = (0);
seq__12745 = G__15426;
chunk__12746 = G__15427;
count__12747 = G__15428;
i__12748 = G__15429;
continue;
} else {
var drawable = cljs.core.first(seq__12745__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15430 = cljs.core.next(seq__12745__$1);
var G__15431 = null;
var G__15432 = (0);
var G__15433 = (0);
seq__12745 = G__15430;
chunk__12746 = G__15431;
count__12747 = G__15432;
i__12748 = G__15433;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for clipboard paste events.
 * 
 *   on-clipboard-paste should take 1 arguments s and return a sequence of effects.
 */
membrane.ui.on_clipboard_paste = (function membrane$ui$on_clipboard_paste(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15436 = arguments.length;
var i__4737__auto___15438 = (0);
while(true){
if((i__4737__auto___15438 < len__4736__auto___15436)){
args__4742__auto__.push((arguments[i__4737__auto___15438]));

var G__15439 = (i__4737__auto___15438 + (1));
i__4737__auto___15438 = G__15439;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_clipboard_paste.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_clipboard_paste.cljs$core$IFn$_invoke$arity$variadic = (function (on_clipboard_paste,drawables){
return (new membrane.ui.OnClipboardPaste(on_clipboard_paste,drawables,null,null,null));
}));

(membrane.ui.on_clipboard_paste.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_clipboard_paste.cljs$lang$applyTo = (function (seq12749){
var G__12750 = cljs.core.first(seq12749);
var seq12749__$1 = cljs.core.next(seq12749);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12750,seq12749__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {membrane.ui.IClipboardCopy}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClipboardCopy = (function (on_clipboard_copy,drawables,__meta,__extmap,__hash){
this.on_clipboard_copy = on_clipboard_copy;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClipboardCopy.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12752,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12756 = k12752;
var G__12756__$1 = (((G__12756 instanceof cljs.core.Keyword))?G__12756.fqn:null);
switch (G__12756__$1) {
case "on-clipboard-copy":
return self__.on_clipboard_copy;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12752,else__4383__auto__);

}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12757){
var vec__12758 = p__12757;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12758,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12758,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClipboardCopy{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),self__.on_clipboard_copy],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12751){
var self__ = this;
var G__12751__$1 = this;
return (new cljs.core.RecordIter((0),G__12751__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12761,elem){
var vec__12762 = p__12761;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12762,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12762,(1),null);
var vec__12765 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12765,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12765,(1),null);
var vec__12768 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12768,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12768,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (336255660 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12753,other12754){
var self__ = this;
var this12753__$1 = this;
return (((!((other12754 == null)))) && ((this12753__$1.constructor === other12754.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12753__$1.on_clipboard_copy,other12754.on_clipboard_copy)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12753__$1.drawables,other12754.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12753__$1.__extmap,other12754.__extmap)));
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IClipboardCopy$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_clipboard_copy)){
return (self__.on_clipboard_copy.cljs$core$IFn$_invoke$arity$0 ? self__.on_clipboard_copy.cljs$core$IFn$_invoke$arity$0() : self__.on_clipboard_copy.call(null));
} else {
return null;
}
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12751){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12771 = cljs.core.keyword_identical_QMARK_;
var expr__12772 = k__4388__auto__;
if(cljs.core.truth_((pred__12771.cljs$core$IFn$_invoke$arity$2 ? pred__12771.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),expr__12772) : pred__12771.call(null,new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),expr__12772)))){
return (new membrane.ui.OnClipboardCopy(G__12751,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12771.cljs$core$IFn$_invoke$arity$2 ? pred__12771.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12772) : pred__12771.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12772)))){
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,G__12751,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12751),null));
}
}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),self__.on_clipboard_copy,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,childs,null,null,null));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12751){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,G__12751,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClipboardCopy.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-clipboard-copy","on-clipboard-copy",1411899436,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClipboardCopy.cljs$lang$type = true);

(membrane.ui.OnClipboardCopy.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClipboardCopy",null,(1),null));
}));

(membrane.ui.OnClipboardCopy.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClipboardCopy");
}));

/**
 * Positional factory function for membrane.ui/OnClipboardCopy.
 */
membrane.ui.__GT_OnClipboardCopy = (function membrane$ui$__GT_OnClipboardCopy(on_clipboard_copy,drawables){
return (new membrane.ui.OnClipboardCopy(on_clipboard_copy,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClipboardCopy, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClipboardCopy = (function membrane$ui$map__GT_OnClipboardCopy(G__12755){
var extmap__4419__auto__ = (function (){var G__12774 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12755,new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12755)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12774);
} else {
return G__12774;
}
})();
return (new membrane.ui.OnClipboardCopy(new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091).cljs$core$IFn$_invoke$arity$1(G__12755),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12755),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClipboardCopy,(function (draw){
return (function (this$){
var seq__12775 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12776 = null;
var count__12777 = (0);
var i__12778 = (0);
while(true){
if((i__12778 < count__12777)){
var drawable = chunk__12776.cljs$core$IIndexed$_nth$arity$2(null,i__12778);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15480 = seq__12775;
var G__15481 = chunk__12776;
var G__15482 = count__12777;
var G__15483 = (i__12778 + (1));
seq__12775 = G__15480;
chunk__12776 = G__15481;
count__12777 = G__15482;
i__12778 = G__15483;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12775);
if(temp__5735__auto__){
var seq__12775__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12775__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12775__$1);
var G__15484 = cljs.core.chunk_rest(seq__12775__$1);
var G__15485 = c__4556__auto__;
var G__15486 = cljs.core.count(c__4556__auto__);
var G__15487 = (0);
seq__12775 = G__15484;
chunk__12776 = G__15485;
count__12777 = G__15486;
i__12778 = G__15487;
continue;
} else {
var drawable = cljs.core.first(seq__12775__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15488 = cljs.core.next(seq__12775__$1);
var G__15489 = null;
var G__15490 = (0);
var G__15491 = (0);
seq__12775 = G__15488;
chunk__12776 = G__15489;
count__12777 = G__15490;
i__12778 = G__15491;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for clipboard copy events.
 * 
 *   on-clipboard-copy should take 0 arguments and return a sequence of effects.
 */
membrane.ui.on_clipboard_copy = (function membrane$ui$on_clipboard_copy(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15492 = arguments.length;
var i__4737__auto___15493 = (0);
while(true){
if((i__4737__auto___15493 < len__4736__auto___15492)){
args__4742__auto__.push((arguments[i__4737__auto___15493]));

var G__15494 = (i__4737__auto___15493 + (1));
i__4737__auto___15493 = G__15494;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_clipboard_copy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_clipboard_copy.cljs$core$IFn$_invoke$arity$variadic = (function (on_clipboard_copy,drawables){
return (new membrane.ui.OnClipboardCopy(on_clipboard_copy,drawables,null,null,null));
}));

(membrane.ui.on_clipboard_copy.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_clipboard_copy.cljs$lang$applyTo = (function (seq12779){
var G__12780 = cljs.core.first(seq12779);
var seq12779__$1 = cljs.core.next(seq12779);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12780,seq12779__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IClipboardCut}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClipboardCut = (function (on_clipboard_cut,drawables,__meta,__extmap,__hash){
this.on_clipboard_cut = on_clipboard_cut;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClipboardCut.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12782,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12786 = k12782;
var G__12786__$1 = (((G__12786 instanceof cljs.core.Keyword))?G__12786.fqn:null);
switch (G__12786__$1) {
case "on-clipboard-cut":
return self__.on_clipboard_cut;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12782,else__4383__auto__);

}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12787){
var vec__12788 = p__12787;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12788,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12788,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IClipboardCut$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IClipboardCut$_clipboard_cut$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_clipboard_cut)){
return (self__.on_clipboard_cut.cljs$core$IFn$_invoke$arity$0 ? self__.on_clipboard_cut.cljs$core$IFn$_invoke$arity$0() : self__.on_clipboard_cut.call(null));
} else {
return null;
}
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClipboardCut{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),self__.on_clipboard_cut],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12781){
var self__ = this;
var G__12781__$1 = this;
return (new cljs.core.RecordIter((0),G__12781__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12791,elem){
var vec__12792 = p__12791;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12792,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12792,(1),null);
var vec__12795 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12795,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12795,(1),null);
var vec__12798 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12798,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12798,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2059173612 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12783,other12784){
var self__ = this;
var this12783__$1 = this;
return (((!((other12784 == null)))) && ((this12783__$1.constructor === other12784.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12783__$1.on_clipboard_cut,other12784.on_clipboard_cut)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12783__$1.drawables,other12784.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12783__$1.__extmap,other12784.__extmap)));
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12781){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12801 = cljs.core.keyword_identical_QMARK_;
var expr__12802 = k__4388__auto__;
if(cljs.core.truth_((pred__12801.cljs$core$IFn$_invoke$arity$2 ? pred__12801.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),expr__12802) : pred__12801.call(null,new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),expr__12802)))){
return (new membrane.ui.OnClipboardCut(G__12781,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12801.cljs$core$IFn$_invoke$arity$2 ? pred__12801.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12802) : pred__12801.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12802)))){
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,G__12781,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12781),null));
}
}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),self__.on_clipboard_cut,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,childs,null,null,null));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12781){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,G__12781,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClipboardCut.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-clipboard-cut","on-clipboard-cut",-1301330217,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClipboardCut.cljs$lang$type = true);

(membrane.ui.OnClipboardCut.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClipboardCut",null,(1),null));
}));

(membrane.ui.OnClipboardCut.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClipboardCut");
}));

/**
 * Positional factory function for membrane.ui/OnClipboardCut.
 */
membrane.ui.__GT_OnClipboardCut = (function membrane$ui$__GT_OnClipboardCut(on_clipboard_cut,drawables){
return (new membrane.ui.OnClipboardCut(on_clipboard_cut,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClipboardCut, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClipboardCut = (function membrane$ui$map__GT_OnClipboardCut(G__12785){
var extmap__4419__auto__ = (function (){var G__12804 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12785,new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12785)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12804);
} else {
return G__12804;
}
})();
return (new membrane.ui.OnClipboardCut(new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552).cljs$core$IFn$_invoke$arity$1(G__12785),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12785),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClipboardCut,(function (draw){
return (function (this$){
var seq__12805 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12806 = null;
var count__12807 = (0);
var i__12808 = (0);
while(true){
if((i__12808 < count__12807)){
var drawable = chunk__12806.cljs$core$IIndexed$_nth$arity$2(null,i__12808);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15524 = seq__12805;
var G__15525 = chunk__12806;
var G__15526 = count__12807;
var G__15527 = (i__12808 + (1));
seq__12805 = G__15524;
chunk__12806 = G__15525;
count__12807 = G__15526;
i__12808 = G__15527;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12805);
if(temp__5735__auto__){
var seq__12805__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12805__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12805__$1);
var G__15528 = cljs.core.chunk_rest(seq__12805__$1);
var G__15529 = c__4556__auto__;
var G__15530 = cljs.core.count(c__4556__auto__);
var G__15531 = (0);
seq__12805 = G__15528;
chunk__12806 = G__15529;
count__12807 = G__15530;
i__12808 = G__15531;
continue;
} else {
var drawable = cljs.core.first(seq__12805__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15533 = cljs.core.next(seq__12805__$1);
var G__15534 = null;
var G__15535 = (0);
var G__15536 = (0);
seq__12805 = G__15533;
chunk__12806 = G__15534;
count__12807 = G__15535;
i__12808 = G__15536;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for clipboard cut events.
 * 
 *   on-clipboard-copy should take 0 arguments and return a sequence of effects.
 */
membrane.ui.on_clipboard_cut = (function membrane$ui$on_clipboard_cut(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15537 = arguments.length;
var i__4737__auto___15538 = (0);
while(true){
if((i__4737__auto___15538 < len__4736__auto___15537)){
args__4742__auto__.push((arguments[i__4737__auto___15538]));

var G__15541 = (i__4737__auto___15538 + (1));
i__4737__auto___15538 = G__15541;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_clipboard_cut.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_clipboard_cut.cljs$core$IFn$_invoke$arity$variadic = (function (on_clipboard_cut,drawables){
return (new membrane.ui.OnClipboardCut(on_clipboard_cut,drawables,null,null,null));
}));

(membrane.ui.on_clipboard_cut.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_clipboard_cut.cljs$lang$applyTo = (function (seq12809){
var G__12810 = cljs.core.first(seq12809);
var seq12809__$1 = cljs.core.next(seq12809);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12810,seq12809__$1);
}));

/**
 * Returns a graphical elem of elems stacked on top of each other
 */
membrane.ui.vertical_layout = (function membrane$ui$vertical_layout(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15542 = arguments.length;
var i__4737__auto___15543 = (0);
while(true){
if((i__4737__auto___15543 < len__4736__auto___15542)){
args__4742__auto__.push((arguments[i__4737__auto___15543]));

var G__15544 = (i__4737__auto___15543 + (1));
i__4737__auto___15543 = G__15544;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.vertical_layout.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.vertical_layout.cljs$core$IFn$_invoke$arity$variadic = (function (elems){
var elems__$1 = cljs.core.seq(elems);
var first_elem = cljs.core.first(elems__$1);
var offset_y = (membrane.ui.height(first_elem) + membrane.ui.origin_y(first_elem));
if(elems__$1){
var elems__$2 = cljs.core.next(elems__$1);
var offset_y__$1 = (offset_y + (1));
var group_elems = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_elem], null);
while(true){
if(elems__$2){
var elem = cljs.core.first(elems__$2);
var dy = (membrane.ui.height(elem) + membrane.ui.origin_y(elem));
var G__15549 = cljs.core.next(elems__$2);
var G__15550 = ((offset_y__$1 + dy) + (1));
var G__15551 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(group_elems,membrane.ui.translate((0),offset_y__$1,elem));
elems__$2 = G__15549;
offset_y__$1 = G__15550;
group_elems = G__15551;
continue;
} else {
return group_elems;
}
break;
}
} else {
return null;
}
}));

(membrane.ui.vertical_layout.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.vertical_layout.cljs$lang$applyTo = (function (seq12811){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12811));
}));

/**
 * Returns a graphical elem of elems layed out next to eachother.
 */
membrane.ui.horizontal_layout = (function membrane$ui$horizontal_layout(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15552 = arguments.length;
var i__4737__auto___15553 = (0);
while(true){
if((i__4737__auto___15553 < len__4736__auto___15552)){
args__4742__auto__.push((arguments[i__4737__auto___15553]));

var G__15558 = (i__4737__auto___15553 + (1));
i__4737__auto___15553 = G__15558;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.horizontal_layout.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.horizontal_layout.cljs$core$IFn$_invoke$arity$variadic = (function (elems){
var elems__$1 = cljs.core.seq(elems);
var first_elem = cljs.core.first(elems__$1);
var offset_x = (membrane.ui.width(first_elem) + membrane.ui.origin_x(first_elem));
if(elems__$1){
var elems__$2 = cljs.core.next(elems__$1);
var offset_x__$1 = (offset_x + (1));
var group_elems = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_elem], null);
while(true){
if(elems__$2){
var elem = cljs.core.first(elems__$2);
var dx = (membrane.ui.width(elem) + membrane.ui.origin_x(elem));
var G__15560 = cljs.core.next(elems__$2);
var G__15561 = ((offset_x__$1 + dx) + (1));
var G__15562 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(group_elems,membrane.ui.translate(offset_x__$1,(0),elem));
elems__$2 = G__15560;
offset_x__$1 = G__15561;
group_elems = G__15562;
continue;
} else {
return group_elems;
}
break;
}
} else {
return null;
}
}));

(membrane.ui.horizontal_layout.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.horizontal_layout.cljs$lang$applyTo = (function (seq12812){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12812));
}));

membrane.ui.table_layout = (function membrane$ui$table_layout(var_args){
var G__12819 = arguments.length;
switch (G__12819) {
case 1:
return membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$1 = (function (table){
return membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$3(table,(0),(0));
}));

(membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$3 = (function (table,cell_padding_x,cell_padding_y){
var row_heights = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (row){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(membrane.ui.height,row));
}),table);
var col_widths = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (col_widths,row){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (col_widths__$1,p__12820){
var vec__12821 = p__12820;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12821,(0),null);
var elem = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12821,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(col_widths__$1,i,(function (p1__12813_SHARP_){
var x__4214__auto__ = (function (){var or__4126__auto__ = p1__12813_SHARP_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var y__4215__auto__ = membrane.ui.width(elem);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}));
}),col_widths,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,row));
}),cljs.core.PersistentVector.EMPTY,table);
var full_padding_x = ((2) * cell_padding_x);
var full_padding_y = ((2) * cell_padding_y);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,(function (){var iter__4529__auto__ = (function membrane$ui$iter__12824(s__12825){
return (new cljs.core.LazySeq(null,(function (){
var s__12825__$1 = s__12825;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__12825__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__12830 = cljs.core.first(xs__6292__auto__);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12830,(0),null);
var row = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12830,(1),null);
var iterys__4525__auto__ = ((function (s__12825__$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function membrane$ui$iter__12824_$_iter__12826(s__12827){
return (new cljs.core.LazySeq(null,((function (s__12825__$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (){
var s__12827__$1 = s__12827;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__12827__$1);
if(temp__5735__auto____$1){
var s__12827__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__12827__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__12827__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__12829 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__12828 = (0);
while(true){
if((i__12828 < size__4528__auto__)){
var vec__12833 = cljs.core._nth(c__4527__auto__,i__12828);
var j = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12833,(0),null);
var elem = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12833,(1),null);
cljs.core.chunk_append(b__12829,membrane.ui.translate((cell_padding_x + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__12828,s__12825__$1,vec__12833,j,elem,c__4527__auto__,size__4528__auto__,b__12829,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__12814_SHARP_,p2__12815_SHARP_){
return ((full_padding_x + p1__12814_SHARP_) + p2__12815_SHARP_);
});})(i__12828,s__12825__$1,vec__12833,j,elem,c__4527__auto__,size__4528__auto__,b__12829,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(col_widths,(0),j))),(cell_padding_y + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__12828,s__12825__$1,vec__12833,j,elem,c__4527__auto__,size__4528__auto__,b__12829,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__12816_SHARP_,p2__12817_SHARP_){
return ((full_padding_y + p1__12816_SHARP_) + p2__12817_SHARP_);
});})(i__12828,s__12825__$1,vec__12833,j,elem,c__4527__auto__,size__4528__auto__,b__12829,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(row_heights,(0),i))),elem));

var G__15572 = (i__12828 + (1));
i__12828 = G__15572;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12829),membrane$ui$iter__12824_$_iter__12826(cljs.core.chunk_rest(s__12827__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12829),null);
}
} else {
var vec__12836 = cljs.core.first(s__12827__$2);
var j = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12836,(0),null);
var elem = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12836,(1),null);
return cljs.core.cons(membrane.ui.translate((cell_padding_x + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__12825__$1,vec__12836,j,elem,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__12814_SHARP_,p2__12815_SHARP_){
return ((full_padding_x + p1__12814_SHARP_) + p2__12815_SHARP_);
});})(s__12825__$1,vec__12836,j,elem,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(col_widths,(0),j))),(cell_padding_y + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__12825__$1,vec__12836,j,elem,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__12816_SHARP_,p2__12817_SHARP_){
return ((full_padding_y + p1__12816_SHARP_) + p2__12817_SHARP_);
});})(s__12825__$1,vec__12836,j,elem,s__12827__$2,temp__5735__auto____$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(row_heights,(0),i))),elem),membrane$ui$iter__12824_$_iter__12826(cljs.core.rest(s__12827__$2)));
}
} else {
return null;
}
break;
}
});})(s__12825__$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,null,null));
});})(s__12825__$1,vec__12830,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,row)));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,membrane$ui$iter__12824(cljs.core.rest(s__12825__$1)));
} else {
var G__15573 = cljs.core.rest(s__12825__$1);
s__12825__$1 = G__15573;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,table));
})());
}));

(membrane.ui.table_layout.cljs$lang$maxFixedArity = 3);

membrane.ui.center = (function membrane$ui$center(elem,p__12839){
var vec__12840 = p__12839;
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12840,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12840,(1),null);
var vec__12843 = membrane.ui.bounds(elem);
var ewidth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12843,(0),null);
var eheight = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12843,(1),null);
return membrane.ui.translate((((width / (2)) - (ewidth / (2))) | (0)),(((height / (2)) - (eheight / (2))) | (0)),elem);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {membrane.ui.IScroll}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnScroll = (function (on_scroll,drawables,__meta,__extmap,__hash){
this.on_scroll = on_scroll;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnScroll.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnScroll.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12847,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12851 = k12847;
var G__12851__$1 = (((G__12851 instanceof cljs.core.Keyword))?G__12851.fqn:null);
switch (G__12851__$1) {
case "on-scroll":
return self__.on_scroll;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12847,else__4383__auto__);

}
}));

(membrane.ui.OnScroll.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12852){
var vec__12853 = p__12852;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12853,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12853,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnScroll.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnScroll{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),self__.on_scroll],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnScroll.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12846){
var self__ = this;
var G__12846__$1 = this;
return (new cljs.core.RecordIter((0),G__12846__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IScroll$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IScroll$_scroll$arity$3 = (function (this$,p__12856,mpos){
var self__ = this;
var vec__12857 = p__12856;
var offset_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12857,(0),null);
var offset_y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12857,(1),null);
var offset = vec__12857;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_scroll)){
return (self__.on_scroll.cljs$core$IFn$_invoke$arity$2 ? self__.on_scroll.cljs$core$IFn$_invoke$arity$2(offset,mpos) : self__.on_scroll.call(null,offset,mpos));
} else {
return null;
}
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__12860,elem){
var vec__12861 = p__12860;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12861,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12861,(1),null);
var vec__12864 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12864,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12864,(1),null);
var vec__12867 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12867,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12867,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnScroll.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnScroll.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnScroll.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnScroll.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1760609386 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnScroll.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12848,other12849){
var self__ = this;
var this12848__$1 = this;
return (((!((other12849 == null)))) && ((this12848__$1.constructor === other12849.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12848__$1.on_scroll,other12849.on_scroll)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12848__$1.drawables,other12849.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12848__$1.__extmap,other12849.__extmap)));
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnScroll.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnScroll.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12846){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12870 = cljs.core.keyword_identical_QMARK_;
var expr__12871 = k__4388__auto__;
if(cljs.core.truth_((pred__12870.cljs$core$IFn$_invoke$arity$2 ? pred__12870.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),expr__12871) : pred__12870.call(null,new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),expr__12871)))){
return (new membrane.ui.OnScroll(G__12846,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12870.cljs$core$IFn$_invoke$arity$2 ? pred__12870.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12871) : pred__12870.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__12871)))){
return (new membrane.ui.OnScroll(self__.on_scroll,G__12846,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12846),null));
}
}
}));

(membrane.ui.OnScroll.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),self__.on_scroll,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnScroll(self__.on_scroll,childs,null,null,null));
}));

(membrane.ui.OnScroll.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12846){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,G__12846,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnScroll.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnScroll.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-scroll","on-scroll",-1063587092,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnScroll.cljs$lang$type = true);

(membrane.ui.OnScroll.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnScroll",null,(1),null));
}));

(membrane.ui.OnScroll.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnScroll");
}));

/**
 * Positional factory function for membrane.ui/OnScroll.
 */
membrane.ui.__GT_OnScroll = (function membrane$ui$__GT_OnScroll(on_scroll,drawables){
return (new membrane.ui.OnScroll(on_scroll,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnScroll, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnScroll = (function membrane$ui$map__GT_OnScroll(G__12850){
var extmap__4419__auto__ = (function (){var G__12873 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12850,new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__12850)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12873);
} else {
return G__12873;
}
})();
return (new membrane.ui.OnScroll(new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677).cljs$core$IFn$_invoke$arity$1(G__12850),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__12850),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnScroll,(function (draw){
return (function (this$){
var seq__12874 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__12875 = null;
var count__12876 = (0);
var i__12877 = (0);
while(true){
if((i__12877 < count__12876)){
var drawable = chunk__12875.cljs$core$IIndexed$_nth$arity$2(null,i__12877);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15624 = seq__12874;
var G__15625 = chunk__12875;
var G__15626 = count__12876;
var G__15627 = (i__12877 + (1));
seq__12874 = G__15624;
chunk__12875 = G__15625;
count__12876 = G__15626;
i__12877 = G__15627;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__12874);
if(temp__5735__auto__){
var seq__12874__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12874__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__12874__$1);
var G__15628 = cljs.core.chunk_rest(seq__12874__$1);
var G__15629 = c__4556__auto__;
var G__15630 = cljs.core.count(c__4556__auto__);
var G__15631 = (0);
seq__12874 = G__15628;
chunk__12875 = G__15629;
count__12876 = G__15630;
i__12877 = G__15631;
continue;
} else {
var drawable = cljs.core.first(seq__12874__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__15632 = cljs.core.next(seq__12874__$1);
var G__15633 = null;
var G__15634 = (0);
var G__15635 = (0);
seq__12874 = G__15632;
chunk__12875 = G__15633;
count__12876 = G__15634;
i__12877 = G__15635;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for scroll events.
 * 
 *   on-scroll should take 1 argument [offset-x offset-y] of the scroll offset and return a sequence of effects.
 */
membrane.ui.on_scroll = (function membrane$ui$on_scroll(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15636 = arguments.length;
var i__4737__auto___15637 = (0);
while(true){
if((i__4737__auto___15637 < len__4736__auto___15636)){
args__4742__auto__.push((arguments[i__4737__auto___15637]));

var G__15638 = (i__4737__auto___15637 + (1));
i__4737__auto___15637 = G__15638;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic = (function (on_scroll,drawables){
return (new membrane.ui.OnScroll(on_scroll,drawables,null,null,null));
}));

(membrane.ui.on_scroll.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_scroll.cljs$lang$applyTo = (function (seq12878){
var G__12879 = cljs.core.first(seq12878);
var seq12878__$1 = cljs.core.next(seq12878);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__12879,seq12878__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.ScissorView = (function (offset,bounds,drawable,__meta,__extmap,__hash){
this.offset = offset;
this.bounds = bounds;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.ScissorView.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.ScissorView.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12881,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12885 = k12881;
var G__12885__$1 = (((G__12885 instanceof cljs.core.Keyword))?G__12885.fqn:null);
switch (G__12885__$1) {
case "offset":
return self__.offset;

break;
case "bounds":
return self__.bounds;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12881,else__4383__auto__);

}
}));

(membrane.ui.ScissorView.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12886){
var vec__12887 = p__12886;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12887,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12887,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.ScissorView.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.ScissorView{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.ScissorView.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12880){
var self__ = this;
var G__12880__$1 = this;
return (new cljs.core.RecordIter((0),G__12880__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"bounds","bounds",1691609455),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.bounds;
}));

(membrane.ui.ScissorView.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.ScissorView.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScissorView.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.ScissorView.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1562895887 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.ScissorView.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12882,other12883){
var self__ = this;
var this12882__$1 = this;
return (((!((other12883 == null)))) && ((this12882__$1.constructor === other12883.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12882__$1.offset,other12883.offset)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12882__$1.bounds,other12883.bounds)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12882__$1.drawable,other12883.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12882__$1.__extmap,other12883.__extmap)));
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.ScissorView.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"offset","offset",296498311),null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.ScissorView.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12880){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12890 = cljs.core.keyword_identical_QMARK_;
var expr__12891 = k__4388__auto__;
if(cljs.core.truth_((pred__12890.cljs$core$IFn$_invoke$arity$2 ? pred__12890.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"offset","offset",296498311),expr__12891) : pred__12890.call(null,new cljs.core.Keyword(null,"offset","offset",296498311),expr__12891)))){
return (new membrane.ui.ScissorView(G__12880,self__.bounds,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12890.cljs$core$IFn$_invoke$arity$2 ? pred__12890.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__12891) : pred__12890.call(null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__12891)))){
return (new membrane.ui.ScissorView(self__.offset,G__12880,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12890.cljs$core$IFn$_invoke$arity$2 ? pred__12890.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12891) : pred__12890.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12891)))){
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,G__12880,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12880),null));
}
}
}
}));

(membrane.ui.ScissorView.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.ScissorView(self__.offset,self__.bounds,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.ScissorView.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12880){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,G__12880,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScissorView.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.ScissorView.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"offset","offset",1937029838,null),new cljs.core.Symbol(null,"bounds","bounds",-962826314,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.ScissorView.cljs$lang$type = true);

(membrane.ui.ScissorView.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/ScissorView",null,(1),null));
}));

(membrane.ui.ScissorView.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/ScissorView");
}));

/**
 * Positional factory function for membrane.ui/ScissorView.
 */
membrane.ui.__GT_ScissorView = (function membrane$ui$__GT_ScissorView(offset,bounds,drawable){
return (new membrane.ui.ScissorView(offset,bounds,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/ScissorView, taking a map of keywords to field values.
 */
membrane.ui.map__GT_ScissorView = (function membrane$ui$map__GT_ScissorView(G__12884){
var extmap__4419__auto__ = (function (){var G__12893 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12884,new cljs.core.Keyword(null,"offset","offset",296498311),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"bounds","bounds",1691609455),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12884)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12893);
} else {
return G__12893;
}
})();
return (new membrane.ui.ScissorView(new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(G__12884),new cljs.core.Keyword(null,"bounds","bounds",1691609455).cljs$core$IFn$_invoke$arity$1(G__12884),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12884),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem to only draw drawable within bounds with an offset.
 * 
 *   All other drawing will be clipped.
 */
membrane.ui.scissor_view = (function membrane$ui$scissor_view(offset,bounds,drawable){
return (new membrane.ui.ScissorView(offset,bounds,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {membrane.ui.IDrop}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMove}
 * @implements {membrane.ui.IMouseMoveGlobal}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {membrane.ui.IScroll}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.ScrollView = (function (bounds,offset,drawable,__meta,__extmap,__hash){
this.bounds = bounds;
this.offset = offset;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.ScrollView.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.ScrollView.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12895,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12899 = k12895;
var G__12899__$1 = (((G__12899 instanceof cljs.core.Keyword))?G__12899.fqn:null);
switch (G__12899__$1) {
case "bounds":
return self__.bounds;

break;
case "offset":
return self__.offset;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12895,else__4383__auto__);

}
}));

(membrane.ui.ScrollView.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12900){
var vec__12901 = p__12900;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12901,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12901,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.ScrollView.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.ScrollView{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.ScrollView.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12894){
var self__ = this;
var G__12894__$1 = this;
return (new cljs.core.RecordIter((0),G__12894__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bounds","bounds",1691609455),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IScroll$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IScroll$_scroll$arity$3 = (function (this$,input_offset,p__12904){
var self__ = this;
var vec__12905 = p__12904;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12905,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12905,(1),null);
var pos = vec__12905;
var this$__$1 = this;
return membrane.ui.scroll(self__.drawable,input_offset,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,p__12908,button,mouse_down_QMARK_,mods){
var self__ = this;
var vec__12909 = p__12908;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12909,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12909,(1),null);
var pos = vec__12909;
var this$__$1 = this;
return membrane.ui.mouse_event(self__.drawable,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null),button,mouse_down_QMARK_,mods);
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.bounds;
}));

(membrane.ui.ScrollView.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.ScrollView.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScrollView.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.ScrollView.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1565568478 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.ScrollView.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12896,other12897){
var self__ = this;
var this12896__$1 = this;
return (((!((other12897 == null)))) && ((this12896__$1.constructor === other12897.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12896__$1.bounds,other12897.bounds)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12896__$1.offset,other12897.offset)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12896__$1.drawable,other12897.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12896__$1.__extmap,other12897.__extmap)));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.ScrollView.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"offset","offset",296498311),null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.ScrollView.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12894){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12912 = cljs.core.keyword_identical_QMARK_;
var expr__12913 = k__4388__auto__;
if(cljs.core.truth_((pred__12912.cljs$core$IFn$_invoke$arity$2 ? pred__12912.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__12913) : pred__12912.call(null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__12913)))){
return (new membrane.ui.ScrollView(G__12894,self__.offset,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12912.cljs$core$IFn$_invoke$arity$2 ? pred__12912.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"offset","offset",296498311),expr__12913) : pred__12912.call(null,new cljs.core.Keyword(null,"offset","offset",296498311),expr__12913)))){
return (new membrane.ui.ScrollView(self__.bounds,G__12894,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12912.cljs$core$IFn$_invoke$arity$2 ? pred__12912.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12913) : pred__12912.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12913)))){
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,G__12894,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12894),null));
}
}
}
}));

(membrane.ui.ScrollView.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.ScrollView(self__.offset,self__.bounds,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMove$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMove$_mouse_move$arity$2 = (function (this$,p__12915){
var self__ = this;
var vec__12916 = p__12915;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12916,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12916,(1),null);
var pos = vec__12916;
var this$__$1 = this;
return membrane.ui.mouse_move(self__.drawable,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12894){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,G__12894,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScrollView.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IDrop$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IDrop$_drop$arity$3 = (function (this$,paths,p__12919){
var self__ = this;
var vec__12920 = p__12919;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12920,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12920,(1),null);
var pos = vec__12920;
var this$__$1 = this;
return membrane.ui.drop(self__.drawable,paths,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 = (function (this$,mouse_offset){
var self__ = this;
var this$__$1 = this;
var vec__12923 = mouse_offset;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12923,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12923,(1),null);
return membrane.ui._default_mouse_move_global(this$__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bounds","bounds",-962826314,null),new cljs.core.Symbol(null,"offset","offset",1937029838,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.ScrollView.cljs$lang$type = true);

(membrane.ui.ScrollView.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/ScrollView",null,(1),null));
}));

(membrane.ui.ScrollView.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/ScrollView");
}));

/**
 * Positional factory function for membrane.ui/ScrollView.
 */
membrane.ui.__GT_ScrollView = (function membrane$ui$__GT_ScrollView(bounds,offset,drawable){
return (new membrane.ui.ScrollView(bounds,offset,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/ScrollView, taking a map of keywords to field values.
 */
membrane.ui.map__GT_ScrollView = (function membrane$ui$map__GT_ScrollView(G__12898){
var extmap__4419__auto__ = (function (){var G__12926 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12898,new cljs.core.Keyword(null,"bounds","bounds",1691609455),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12898)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12926);
} else {
return G__12926;
}
})();
return (new membrane.ui.ScrollView(new cljs.core.Keyword(null,"bounds","bounds",1691609455).cljs$core$IFn$_invoke$arity$1(G__12898),new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(G__12898),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12898),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that will draw drawable offset by offset and clip its drawings to bounds. 
 */
membrane.ui.scrollview = (function membrane$ui$scrollview(bounds,offset,drawable){
return (new membrane.ui.ScrollView(bounds,offset,drawable,null,null,null));
});

/**
 * @interface
 */
membrane.ui.IHandleEvent = function(){};

var membrane$ui$IHandleEvent$_can_handle_QMARK_$dyn_15700 = (function (this$,event_type){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui._can_handle_QMARK_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(this$,event_type) : m__4429__auto__.call(null,this$,event_type));
} else {
var m__4426__auto__ = (membrane.ui._can_handle_QMARK_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(this$,event_type) : m__4426__auto__.call(null,this$,event_type));
} else {
throw cljs.core.missing_protocol("IHandleEvent.-can-handle?",this$);
}
}
});
membrane.ui._can_handle_QMARK_ = (function membrane$ui$_can_handle_QMARK_(this$,event_type){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2 == null)))))){
return this$.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2(this$,event_type);
} else {
return membrane$ui$IHandleEvent$_can_handle_QMARK_$dyn_15700(this$,event_type);
}
});

var membrane$ui$IHandleEvent$_handle_event$dyn_15701 = (function (this$,event_type,event_args){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui._handle_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(this$,event_type,event_args) : m__4429__auto__.call(null,this$,event_type,event_args));
} else {
var m__4426__auto__ = (membrane.ui._handle_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(this$,event_type,event_args) : m__4426__auto__.call(null,this$,event_type,event_args));
} else {
throw cljs.core.missing_protocol("IHandleEvent.-handle-event",this$);
}
}
});
membrane.ui._handle_event = (function membrane$ui$_handle_event(this$,event_type,event_args){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHandleEvent$_handle_event$arity$3 == null)))))){
return this$.membrane$ui$IHandleEvent$_handle_event$arity$3(this$,event_type,event_args);
} else {
return membrane$ui$IHandleEvent$_handle_event$dyn_15701(this$,event_type,event_args);
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {membrane.ui.IBubble}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IHandleEvent}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.EventHandler = (function (event_type,handler,drawable,__meta,__extmap,__hash){
this.event_type = event_type;
this.handler = handler;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.EventHandler.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.EventHandler.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k12928,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__12932 = k12928;
var G__12932__$1 = (((G__12932 instanceof cljs.core.Keyword))?G__12932.fqn:null);
switch (G__12932__$1) {
case "event-type":
return self__.event_type;

break;
case "handler":
return self__.handler;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k12928,else__4383__auto__);

}
}));

(membrane.ui.EventHandler.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__12933){
var vec__12934 = p__12933;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12934,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12934,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.EventHandler.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.EventHandler{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"event-type","event-type",319722813),self__.event_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.EventHandler.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__12927){
var self__ = this;
var G__12927__$1 = this;
return (new cljs.core.RecordIter((0),G__12927__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"event-type","event-type",319722813),new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,membrane.ui.origin(self__.drawable),membrane.ui.bounds(self__.drawable));
}));

(membrane.ui.EventHandler.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.EventHandler.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.EventHandler.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.EventHandler.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1200937433 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.EventHandler.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this12929,other12930){
var self__ = this;
var this12929__$1 = this;
return (((!((other12930 == null)))) && ((this12929__$1.constructor === other12930.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12929__$1.event_type,other12930.event_type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12929__$1.handler,other12930.handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12929__$1.drawable,other12930.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this12929__$1.__extmap,other12930.__extmap)));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IBubble$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IBubble$_bubble$arity$2 = (function (this$,events){
var self__ = this;
var this$__$1 = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,(function (){var iter__4529__auto__ = (function membrane$ui$iter__12937(s__12938){
return (new cljs.core.LazySeq(null,(function (){
var s__12938__$1 = s__12938;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__12938__$1);
if(temp__5735__auto__){
var s__12938__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__12938__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__12938__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__12940 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__12939 = (0);
while(true){
if((i__12939 < size__4528__auto__)){
var intent = cljs.core._nth(c__4527__auto__,i__12939);
var intent_type = cljs.core.first(intent);
cljs.core.chunk_append(b__12940,(cljs.core.truth_(this$__$1.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2(null,intent_type))?this$__$1.membrane$ui$IHandleEvent$_handle_event$arity$3(null,intent_type,cljs.core.rest(intent)):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [intent], null)));

var G__15706 = (i__12939 + (1));
i__12939 = G__15706;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__12940),membrane$ui$iter__12937(cljs.core.chunk_rest(s__12938__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__12940),null);
}
} else {
var intent = cljs.core.first(s__12938__$2);
var intent_type = cljs.core.first(intent);
return cljs.core.cons((cljs.core.truth_(this$__$1.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2(null,intent_type))?this$__$1.membrane$ui$IHandleEvent$_handle_event$arity$3(null,intent_type,cljs.core.rest(intent)):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [intent], null)),membrane$ui$iter__12937(cljs.core.rest(s__12938__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(events);
})());
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.EventHandler.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null,new cljs.core.Keyword(null,"event-type","event-type",319722813),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.EventHandler.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__12927){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__12941 = cljs.core.keyword_identical_QMARK_;
var expr__12942 = k__4388__auto__;
if(cljs.core.truth_((pred__12941.cljs$core$IFn$_invoke$arity$2 ? pred__12941.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"event-type","event-type",319722813),expr__12942) : pred__12941.call(null,new cljs.core.Keyword(null,"event-type","event-type",319722813),expr__12942)))){
return (new membrane.ui.EventHandler(G__12927,self__.handler,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12941.cljs$core$IFn$_invoke$arity$2 ? pred__12941.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"handler","handler",-195596612),expr__12942) : pred__12941.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__12942)))){
return (new membrane.ui.EventHandler(self__.event_type,G__12927,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__12941.cljs$core$IFn$_invoke$arity$2 ? pred__12941.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12942) : pred__12941.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__12942)))){
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,G__12927,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__12927),null));
}
}
}
}));

(membrane.ui.EventHandler.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"event-type","event-type",319722813),self__.event_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.EventHandler(self__.event_type,self__.handler,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IHandleEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2 = (function (this$,other_event_type){
var self__ = this;
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.event_type,other_event_type);
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IHandleEvent$_handle_event$arity$3 = (function (this$,event_type__$1,event_args){
var self__ = this;
var this$__$1 = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.handler,event_args);
}));

(membrane.ui.EventHandler.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__12927){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,G__12927,self__.__extmap,self__.__hash));
}));

(membrane.ui.EventHandler.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.EventHandler.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"event-type","event-type",1960254340,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.EventHandler.cljs$lang$type = true);

(membrane.ui.EventHandler.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/EventHandler",null,(1),null));
}));

(membrane.ui.EventHandler.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/EventHandler");
}));

/**
 * Positional factory function for membrane.ui/EventHandler.
 */
membrane.ui.__GT_EventHandler = (function membrane$ui$__GT_EventHandler(event_type,handler,drawable){
return (new membrane.ui.EventHandler(event_type,handler,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/EventHandler, taking a map of keywords to field values.
 */
membrane.ui.map__GT_EventHandler = (function membrane$ui$map__GT_EventHandler(G__12931){
var extmap__4419__auto__ = (function (){var G__12944 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__12931,new cljs.core.Keyword(null,"event-type","event-type",319722813),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__12931)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__12944);
} else {
return G__12944;
}
})();
return (new membrane.ui.EventHandler(new cljs.core.Keyword(null,"event-type","event-type",319722813).cljs$core$IFn$_invoke$arity$1(G__12931),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__12931),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__12931),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.EventHandler,(function (draw){
return (function (this$){
var G__12945 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__12945) : draw.call(null,G__12945));
});
}));
if((typeof membrane !== 'undefined') && (typeof membrane.ui !== 'undefined') && (typeof membrane.ui.on_handler !== 'undefined')){
} else {
membrane.ui.on_handler = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("membrane.ui","on-handler-default","membrane.ui/on-handler-default",1778827142)], null),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__12946 = cljs.core.get_global_hierarchy;
return (fexpr__12946.cljs$core$IFn$_invoke$arity$0 ? fexpr__12946.cljs$core$IFn$_invoke$arity$0() : fexpr__12946.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("membrane.ui","on-handler"),(function (event_type,handler,body){
return event_type;
}),new cljs.core.Keyword("membrane.ui","on-handler-default","membrane.ui/on-handler-default",1778827142),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
membrane.ui.on_handler.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("membrane.ui","on-handler-default","membrane.ui/on-handler-default",1778827142),(function (event_type,handler,body){
return (new membrane.ui.EventHandler(event_type,handler,body,null,null,null));
}));
/**
 * Wraps an elem with event handlers.
 * 
 *   events are pairs of events and event handlers and the last argument should be an elem.
 * 
 *   example:
 * 
 *   Adds do nothing event handlers for mouse-down and mouse-up events on a label that says "Hello!"
 *   (on :mouse-down (fn [[mx my]] nil)
 *    :mouse-up (fn [[mx my]] nil)
 *   (label "Hello!"))
 *   
 */
membrane.ui.on = (function membrane$ui$on(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15717 = arguments.length;
var i__4737__auto___15718 = (0);
while(true){
if((i__4737__auto___15718 < len__4736__auto___15717)){
args__4742__auto__.push((arguments[i__4737__auto___15718]));

var G__15719 = (i__4737__auto___15718 + (1));
i__4737__auto___15718 = G__15719;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.on.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.on.cljs$core$IFn$_invoke$arity$variadic = (function (events){
var evs = cljs.core.seq(cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),events)));
var body = cljs.core.last(events);
while(true){
if(evs){
var vec__12952 = cljs.core.first(evs);
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12952,(0),null);
var handler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12952,(1),null);
var G__15720 = cljs.core.next(evs);
var G__15721 = (function (){var G__12955 = event_type;
var G__12955__$1 = (((G__12955 instanceof cljs.core.Keyword))?G__12955.fqn:null);
switch (G__12955__$1) {
case "mouse-down":
return membrane.ui.on_mouse_down.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-event":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "drop":
return membrane.ui.on_drop.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "scroll":
return membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-event":
return membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-press":
return membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-up":
return membrane.ui.on_mouse_up.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move":
return membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move-global":
return membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "clipboard-copy":
return membrane.ui.on_clipboard_copy.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "clipboard-cut":
return membrane.ui.on_clipboard_cut.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "clipboard-paste":
return membrane.ui.on_clipboard_paste.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
default:
return membrane.ui.on_handler.cljs$core$IFn$_invoke$arity$3(event_type,handler,body);

}
})();
evs = G__15720;
body = G__15721;
continue;
} else {
return body;
}
break;
}
}));

(membrane.ui.on.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.on.cljs$lang$applyTo = (function (seq12947){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12947));
}));

/**
 * Wraps an elem with event handlers.
 * 
 *   events are pairs of events and event handlers and the last argument should be an elem.
 *   The event handlers should accept an extra first argument to the event which is the original event handler.
 * 
 *   example:
 * 
 *   Wraps a button with a mouse-down handler that only returns an effect when the x coordinate is even.
 *   (on :mouse-down (fn [handler [mx my]]
 *                   (when (even? mx)
 *                     (handler [mx my])))
 *   (button "Hello!"
 *          (fn []
 *             [[:hello!]])))
 *   
 */
membrane.ui.wrap_on = (function membrane$ui$wrap_on(var_args){
var args__4742__auto__ = [];
var len__4736__auto___15724 = arguments.length;
var i__4737__auto___15725 = (0);
while(true){
if((i__4737__auto___15725 < len__4736__auto___15724)){
args__4742__auto__.push((arguments[i__4737__auto___15725]));

var G__15726 = (i__4737__auto___15725 + (1));
i__4737__auto___15725 = G__15726;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.wrap_on.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.wrap_on.cljs$core$IFn$_invoke$arity$variadic = (function (events){
var evs = cljs.core.seq(cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),events)));
var body = cljs.core.last(events);
while(true){
if(evs){
var vec__12984 = cljs.core.first(evs);
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12984,(0),null);
var handler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12984,(1),null);
var G__15727 = cljs.core.next(evs);
var G__15728 = (function (){var G__12987 = event_type;
var G__12987__$1 = (((G__12987 instanceof cljs.core.Keyword))?G__12987.fqn:null);
switch (G__12987__$1) {
case "mouse-down":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (mpos,button,mouse_down_QMARK_,mods){
if(cljs.core.truth_(mouse_down_QMARK_)){
var G__12988 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (pos){
return membrane.ui.mouse_event(body,pos,button,mouse_down_QMARK_,mods);
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__12989 = mpos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__12988,G__12989) : handler.call(null,G__12988,G__12989));
} else {
return membrane.ui.mouse_event(body,mpos,button,mouse_down_QMARK_,mods);
}
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-event":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (mpos,button,mouse_down_QMARK_,mods){
var G__12990 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (mpos__$1,button__$1,mouse_down_QMARK___$1,mods__$1){
return membrane.ui.mouse_event(body,mpos__$1,button__$1,mouse_down_QMARK___$1,mods__$1);
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__12991 = mpos;
var G__12992 = button;
var G__12993 = mouse_down_QMARK_;
var G__12994 = mods;
return (handler.cljs$core$IFn$_invoke$arity$5 ? handler.cljs$core$IFn$_invoke$arity$5(G__12990,G__12991,G__12992,G__12993,G__12994) : handler.call(null,G__12990,G__12991,G__12992,G__12993,G__12994));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-event":
return membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (key,scancode,action,mods){
var G__12995 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (key__$1,scancode__$1,action__$1,mods__$1){
return membrane.ui.key_event.cljs$core$IFn$_invoke$arity$variadic(body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key__$1,scancode__$1,action__$1,mods__$1], 0));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__12996 = key;
var G__12997 = scancode;
var G__12998 = action;
var G__12999 = mods;
return (handler.cljs$core$IFn$_invoke$arity$5 ? handler.cljs$core$IFn$_invoke$arity$5(G__12995,G__12996,G__12997,G__12998,G__12999) : handler.call(null,G__12995,G__12996,G__12997,G__12998,G__12999));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-press":
return membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (key){
var G__13000 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (key__$1){
return membrane.ui.key_press.cljs$core$IFn$_invoke$arity$variadic(body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key__$1], 0));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__13001 = key;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__13000,G__13001) : handler.call(null,G__13000,G__13001));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-up":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (mpos,button,mouse_down_QMARK_,mods){
if(cljs.core.not(mouse_down_QMARK_)){
var G__13002 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (pos){
return membrane.ui.mouse_event(body,pos,button,mouse_down_QMARK_,mods);
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__13003 = mpos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__13002,G__13003) : handler.call(null,G__13002,G__13003));
} else {
return membrane.ui.mouse_event(body,mpos,button,mouse_down_QMARK_,mods);
}
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move":
return membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (pos){
var G__13004 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (pos__$1){
return membrane.ui.mouse_move(body,pos__$1);
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__13005 = pos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__13004,G__13005) : handler.call(null,G__13004,G__13005));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move-global":
return membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (pos){
var G__13006 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (pos__$1){
return membrane.ui.mouse_move_global(body,pos__$1);
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__13007 = pos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__13006,G__13007) : handler.call(null,G__13006,G__13007));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "scroll":
return membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (offset,pos){
var G__13008 = ((function (evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler){
return (function (offset__$1,pos__$1){
return membrane.ui.scroll(body,offset__$1,pos__$1);
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
;
var G__13009 = offset;
var G__13010 = pos;
return (handler.cljs$core$IFn$_invoke$arity$3 ? handler.cljs$core$IFn$_invoke$arity$3(G__13008,G__13009,G__13010) : handler.call(null,G__13008,G__13009,G__13010));
});})(evs,body,G__12987,G__12987__$1,vec__12984,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__12987__$1)].join('')));

}
})();
evs = G__15727;
body = G__15728;
continue;
} else {
return body;
}
break;
}
}));

(membrane.ui.wrap_on.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.wrap_on.cljs$lang$applyTo = (function (seq12956){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12956));
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {membrane.ui.IBubble}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IHandleEvent}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMove}
 * @implements {membrane.ui.IKeyType}
 * @implements {membrane.ui.IMouseWheel}
 * @implements {membrane.ui.IClipboardCut}
 * @implements {membrane.ui.IMouseMoveGlobal}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {membrane.ui.IScroll}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IKeyPress}
 * @implements {membrane.ui.IClipboardPaste}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {membrane.ui.IClipboardCopy}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.NoEvents = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.NoEvents.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.NoEvents.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k13012,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__13016 = k13012;
var G__13016__$1 = (((G__13016 instanceof cljs.core.Keyword))?G__13016.fqn:null);
switch (G__13016__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k13012,else__4383__auto__);

}
}));

(membrane.ui.NoEvents.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__13017){
var vec__13018 = p__13017;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13018,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13018,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyType$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyType$_key_type$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCut$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCut$_clipboard_cut$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseWheel$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseWheel$_mouse_wheel$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.NoEvents.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.NoEvents{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.NoEvents.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__13011){
var self__ = this;
var G__13011__$1 = this;
return (new cljs.core.RecordIter((0),G__13011__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IScroll$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IScroll$_scroll$arity$3 = (function (this$,pos,mpos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.NoEvents.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.NoEvents.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.NoEvents(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoEvents.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyPress$_key_press$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (911804394 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.NoEvents.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this13013,other13014){
var self__ = this;
var this13013__$1 = this;
return (((!((other13014 == null)))) && ((this13013__$1.constructor === other13014.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13013__$1.drawable,other13014.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13013__$1.__extmap,other13014.__extmap)));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCopy$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardPaste$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IBubble$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IBubble$_bubble$arity$2 = (function (this$,events){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.NoEvents.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.NoEvents(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.NoEvents.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__13011){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__13021 = cljs.core.keyword_identical_QMARK_;
var expr__13022 = k__4388__auto__;
if(cljs.core.truth_((pred__13021.cljs$core$IFn$_invoke$arity$2 ? pred__13021.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13022) : pred__13021.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13022)))){
return (new membrane.ui.NoEvents(G__13011,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.NoEvents(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__13011),null));
}
}));

(membrane.ui.NoEvents.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.NoEvents(cljs.core.first(childs),null,null,null));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMove$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMove$_mouse_move$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IHandleEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2 = (function (this$,other_event_type){
var self__ = this;
var this$__$1 = this;
return false;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IHandleEvent$_handle_event$arity$3 = (function (this$,event_type,event_args){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__13011){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.NoEvents(self__.drawable,G__13011,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoEvents.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.NoEvents.cljs$lang$type = true);

(membrane.ui.NoEvents.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/NoEvents",null,(1),null));
}));

(membrane.ui.NoEvents.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/NoEvents");
}));

/**
 * Positional factory function for membrane.ui/NoEvents.
 */
membrane.ui.__GT_NoEvents = (function membrane$ui$__GT_NoEvents(drawable){
return (new membrane.ui.NoEvents(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/NoEvents, taking a map of keywords to field values.
 */
membrane.ui.map__GT_NoEvents = (function membrane$ui$map__GT_NoEvents(G__13015){
var extmap__4419__auto__ = (function (){var G__13024 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__13015,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__13015)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__13024);
} else {
return G__13024;
}
})();
return (new membrane.ui.NoEvents(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__13015),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.NoEvents,(function (draw){
return (function (this$){
var G__13025 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__13025) : draw.call(null,G__13025));
});
}));
membrane.ui.no_events = (function membrane$ui$no_events(body){
var do_nothing = cljs.core.constantly(null);
return membrane.ui.on.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"mouse-event","mouse-event",189077181),do_nothing,new cljs.core.Keyword(null,"mouse-up","mouse-up",999952135),do_nothing,new cljs.core.Keyword(null,"mouse-down","mouse-down",647107567),do_nothing,new cljs.core.Keyword(null,"drop","drop",364481611),do_nothing,new cljs.core.Keyword(null,"scroll","scroll",971553779),do_nothing,new cljs.core.Keyword(null,"key-event","key-event",-1141143098),do_nothing,new cljs.core.Keyword(null,"key-press","key-press",850740112),do_nothing,new cljs.core.Keyword(null,"mouse-move","mouse-move",-1993061223),do_nothing,new cljs.core.Keyword(null,"mouse-move-global","mouse-move-global",-212584064),do_nothing,new cljs.core.Keyword(null,"clipboard-copy","clipboard-copy",1304333525),do_nothing,new cljs.core.Keyword(null,"clipboard-cut","clipboard-cut",-1344378713),do_nothing,new cljs.core.Keyword(null,"clipboard-paste","clipboard-paste",-1682370330),do_nothing,body], 0));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IHasKeyEvent}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.NoKeyEvent = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.NoKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k13027,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__13031 = k13027;
var G__13031__$1 = (((G__13031 instanceof cljs.core.Keyword))?G__13031.fqn:null);
switch (G__13031__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k13027,else__4383__auto__);

}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__13032){
var vec__13033 = p__13032;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13033,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13033,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.NoKeyEvent{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__13026){
var self__ = this;
var G__13026__$1 = this;
return (new cljs.core.RecordIter((0),G__13026__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.NoKeyEvent(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1115347816 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this13028,other13029){
var self__ = this;
var this13028__$1 = this;
return (((!((other13029 == null)))) && ((this13028__$1.constructor === other13029.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13028__$1.drawable,other13029.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13028__$1.__extmap,other13029.__extmap)));
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.NoKeyEvent(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__13026){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__13036 = cljs.core.keyword_identical_QMARK_;
var expr__13037 = k__4388__auto__;
if(cljs.core.truth_((pred__13036.cljs$core$IFn$_invoke$arity$2 ? pred__13036.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13037) : pred__13036.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13037)))){
return (new membrane.ui.NoKeyEvent(G__13026,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.NoKeyEvent(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__13026),null));
}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.NoKeyEvent(cljs.core.first(childs),null,null,null));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__13026){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.NoKeyEvent(self__.drawable,G__13026,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IHasKeyEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IHasKeyEvent$has_key_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return false;
}));

(membrane.ui.NoKeyEvent.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.NoKeyEvent.cljs$lang$type = true);

(membrane.ui.NoKeyEvent.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/NoKeyEvent",null,(1),null));
}));

(membrane.ui.NoKeyEvent.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/NoKeyEvent");
}));

/**
 * Positional factory function for membrane.ui/NoKeyEvent.
 */
membrane.ui.__GT_NoKeyEvent = (function membrane$ui$__GT_NoKeyEvent(drawable){
return (new membrane.ui.NoKeyEvent(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/NoKeyEvent, taking a map of keywords to field values.
 */
membrane.ui.map__GT_NoKeyEvent = (function membrane$ui$map__GT_NoKeyEvent(G__13030){
var extmap__4419__auto__ = (function (){var G__13039 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__13030,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__13030)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__13039);
} else {
return G__13039;
}
})();
return (new membrane.ui.NoKeyEvent(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__13030),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.NoKeyEvent,(function (draw){
return (function (this$){
var G__13040 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__13040) : draw.call(null,G__13040));
});
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IHasKeyPress}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.NoKeyPress = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.NoKeyPress.prototype.membrane$ui$IHasKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IHasKeyPress$has_key_press$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return false;
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k13042,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__13046 = k13042;
var G__13046__$1 = (((G__13046 instanceof cljs.core.Keyword))?G__13046.fqn:null);
switch (G__13046__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k13042,else__4383__auto__);

}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__13047){
var vec__13048 = p__13047;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13048,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13048,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.NoKeyPress{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__13041){
var self__ = this;
var G__13041__$1 = this;
return (new cljs.core.RecordIter((0),G__13041__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.NoKeyPress(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (533507040 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this13043,other13044){
var self__ = this;
var this13043__$1 = this;
return (((!((other13044 == null)))) && ((this13043__$1.constructor === other13044.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13043__$1.drawable,other13044.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13043__$1.__extmap,other13044.__extmap)));
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.NoKeyPress(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__13041){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__13051 = cljs.core.keyword_identical_QMARK_;
var expr__13052 = k__4388__auto__;
if(cljs.core.truth_((pred__13051.cljs$core$IFn$_invoke$arity$2 ? pred__13051.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13052) : pred__13051.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13052)))){
return (new membrane.ui.NoKeyPress(G__13041,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.NoKeyPress(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__13041),null));
}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.NoKeyPress(cljs.core.first(childs),null,null,null));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__13041){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.NoKeyPress(self__.drawable,G__13041,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.NoKeyPress.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.NoKeyPress.cljs$lang$type = true);

(membrane.ui.NoKeyPress.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/NoKeyPress",null,(1),null));
}));

(membrane.ui.NoKeyPress.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/NoKeyPress");
}));

/**
 * Positional factory function for membrane.ui/NoKeyPress.
 */
membrane.ui.__GT_NoKeyPress = (function membrane$ui$__GT_NoKeyPress(drawable){
return (new membrane.ui.NoKeyPress(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/NoKeyPress, taking a map of keywords to field values.
 */
membrane.ui.map__GT_NoKeyPress = (function membrane$ui$map__GT_NoKeyPress(G__13045){
var extmap__4419__auto__ = (function (){var G__13054 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__13045,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__13045)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__13054);
} else {
return G__13054;
}
})();
return (new membrane.ui.NoKeyPress(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__13045),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.NoKeyPress,(function (draw){
return (function (this$){
var G__13055 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__13055) : draw.call(null,G__13055));
});
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.TryDraw = (function (drawable,error_draw,__meta,__extmap,__hash){
this.drawable = drawable;
this.error_draw = error_draw;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.TryDraw.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.TryDraw.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k13057,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__13061 = k13057;
var G__13061__$1 = (((G__13061 instanceof cljs.core.Keyword))?G__13061.fqn:null);
switch (G__13061__$1) {
case "drawable":
return self__.drawable;

break;
case "error-draw":
return self__.error_draw;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k13057,else__4383__auto__);

}
}));

(membrane.ui.TryDraw.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__13062){
var vec__13063 = p__13062;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13063,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13063,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.TryDraw.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.TryDraw{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),self__.error_draw],null))], null),self__.__extmap));
}));

(membrane.ui.TryDraw.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__13056){
var self__ = this;
var G__13056__$1 = this;
return (new cljs.core.RecordIter((0),G__13056__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),new cljs.core.Keyword(null,"error-draw","error-draw",-236722733)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
try{return membrane.ui.bounds(self__.drawable);
}catch (e13066){if((e13066 instanceof Object)){
var e = e13066;
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));

return membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1("error"));
} else {
throw e13066;

}
}}));

(membrane.ui.TryDraw.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.TryDraw.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.TryDraw.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.TryDraw.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-629576497 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.TryDraw.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this13058,other13059){
var self__ = this;
var this13058__$1 = this;
return (((!((other13059 == null)))) && ((this13058__$1.constructor === other13059.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13058__$1.drawable,other13059.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13058__$1.error_draw,other13059.error_draw)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13058__$1.__extmap,other13059.__extmap)));
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
try{return membrane.ui.origin(self__.drawable);
}catch (e13067){if((e13067 instanceof Object)){
var e = e13067;
return membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1("error"));
} else {
throw e13067;

}
}}));

(membrane.ui.TryDraw.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.TryDraw.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__13056){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__13068 = cljs.core.keyword_identical_QMARK_;
var expr__13069 = k__4388__auto__;
if(cljs.core.truth_((pred__13068.cljs$core$IFn$_invoke$arity$2 ? pred__13068.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13069) : pred__13068.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13069)))){
return (new membrane.ui.TryDraw(G__13056,self__.error_draw,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__13068.cljs$core$IFn$_invoke$arity$2 ? pred__13068.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),expr__13069) : pred__13068.call(null,new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),expr__13069)))){
return (new membrane.ui.TryDraw(self__.drawable,G__13056,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__13056),null));
}
}
}));

(membrane.ui.TryDraw.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),self__.error_draw,null))], null),self__.__extmap));
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.TryDraw(cljs.core.first(childs),self__.error_draw,null,null,null));
}));

(membrane.ui.TryDraw.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__13056){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,G__13056,self__.__extmap,self__.__hash));
}));

(membrane.ui.TryDraw.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.TryDraw.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null),new cljs.core.Symbol(null,"error-draw","error-draw",1403808794,null)], null);
}));

(membrane.ui.TryDraw.cljs$lang$type = true);

(membrane.ui.TryDraw.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/TryDraw",null,(1),null));
}));

(membrane.ui.TryDraw.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/TryDraw");
}));

/**
 * Positional factory function for membrane.ui/TryDraw.
 */
membrane.ui.__GT_TryDraw = (function membrane$ui$__GT_TryDraw(drawable,error_draw){
return (new membrane.ui.TryDraw(drawable,error_draw,null,null,null));
});

/**
 * Factory function for membrane.ui/TryDraw, taking a map of keywords to field values.
 */
membrane.ui.map__GT_TryDraw = (function membrane$ui$map__GT_TryDraw(G__13060){
var extmap__4419__auto__ = (function (){var G__13071 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__13060,new cljs.core.Keyword(null,"drawable","drawable",1829255936),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"error-draw","error-draw",-236722733)], 0));
if(cljs.core.record_QMARK_(G__13060)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__13071);
} else {
return G__13071;
}
})();
return (new membrane.ui.TryDraw(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__13060),new cljs.core.Keyword(null,"error-draw","error-draw",-236722733).cljs$core$IFn$_invoke$arity$1(G__13060),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.TryDraw,(function (draw){
return (function (this$){
try{var G__13074 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__13074) : draw.call(null,G__13074));
}catch (e13072){if((e13072 instanceof Object)){
var e = e13072;
var fexpr__13073 = new cljs.core.Keyword(null,"error-draw","error-draw",-236722733).cljs$core$IFn$_invoke$arity$1(this$);
return (fexpr__13073.cljs$core$IFn$_invoke$arity$2 ? fexpr__13073.cljs$core$IFn$_invoke$arity$2(draw,e) : fexpr__13073.call(null,draw,e));
} else {
throw e13072;

}
}});
}));
/**
 * Tries to draw body. If an exception occurs, calls error-draw with draw and the exception
 * 
 *   Example:
 *   (ui/try-draw error-body
 *  (fn [draw e]
 *    (draw (ui/label e))))
 *   
 */
membrane.ui.try_draw = (function membrane$ui$try_draw(body,error_draw){
return (new membrane.ui.TryDraw(body,error_draw,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Cached = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Cached.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Cached.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k13076,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__13080 = k13076;
var G__13080__$1 = (((G__13080 instanceof cljs.core.Keyword))?G__13080.fqn:null);
switch (G__13080__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k13076,else__4383__auto__);

}
}));

(membrane.ui.Cached.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__13081){
var vec__13082 = p__13081;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13082,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13082,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Cached.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Cached.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Cached.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Cached{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Cached.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__13075){
var self__ = this;
var G__13075__$1 = this;
return (new cljs.core.RecordIter((0),G__13075__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Cached.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Cached.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.Cached.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Cached.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Cached(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Cached.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Cached.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-59962078 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Cached.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this13077,other13078){
var self__ = this;
var this13077__$1 = this;
return (((!((other13078 == null)))) && ((this13077__$1.constructor === other13078.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13077__$1.drawable,other13078.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this13077__$1.__extmap,other13078.__extmap)));
}));

(membrane.ui.Cached.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Cached.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return membrane.ui.origin(self__.drawable);
}));

(membrane.ui.Cached.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Cached(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Cached.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__13075){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__13085 = cljs.core.keyword_identical_QMARK_;
var expr__13086 = k__4388__auto__;
if(cljs.core.truth_((pred__13085.cljs$core$IFn$_invoke$arity$2 ? pred__13085.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13086) : pred__13085.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__13086)))){
return (new membrane.ui.Cached(G__13075,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Cached(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__13075),null));
}
}));

(membrane.ui.Cached.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Cached.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__13075){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Cached(self__.drawable,G__13075,self__.__extmap,self__.__hash));
}));

(membrane.ui.Cached.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Cached.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Cached.cljs$lang$type = true);

(membrane.ui.Cached.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Cached",null,(1),null));
}));

(membrane.ui.Cached.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Cached");
}));

/**
 * Positional factory function for membrane.ui/Cached.
 */
membrane.ui.__GT_Cached = (function membrane$ui$__GT_Cached(drawable){
return (new membrane.ui.Cached(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Cached, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Cached = (function membrane$ui$map__GT_Cached(G__13079){
var extmap__4419__auto__ = (function (){var G__13088 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__13079,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__13079)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__13088);
} else {
return G__13088;
}
})();
return (new membrane.ui.Cached(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__13079),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.index_for_position_STAR_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
membrane.ui.index_for_position = (function membrane$ui$index_for_position(font,text,x,y){
var f = cljs.core.deref(membrane.ui.index_for_position_STAR_);
if(cljs.core.truth_(f)){
} else {
throw (new Error(["Assert failed: ","index-for-position should be replaced by implementation","\n","f"].join('')));
}

return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(font,text,x,y) : f.call(null,font,text,x,y));
});
membrane.ui.copy_to_clipboard = (function membrane$ui$copy_to_clipboard(s){
return null;
});

//# sourceMappingURL=membrane.ui.js.map
