goog.provide('com.rpl.specter');
com.rpl.specter.static_path_QMARK_ = (function com$rpl$specter$static_path_QMARK_(path){
if(cljs.core.sequential_QMARK_(path)){
return cljs.core.every_QMARK_(com.rpl.specter.static_path_QMARK_,path);
} else {
return (!(com.rpl.specter.impl.dynamic_param_QMARK_(path)));
}
});
com.rpl.specter.wrap_dynamic_nav = (function com$rpl$specter$wrap_dynamic_nav(f){
return (function() { 
var G__45374__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
if(((cljs.core.sequential_QMARK_(ret)) && (com.rpl.specter.static_path_QMARK_(ret)))){
return com.rpl.specter.impl.comp_paths_STAR_(ret);
} else {
if(((cljs.core.sequential_QMARK_(ret)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(ret))))){
return cljs.core.first(ret);
} else {
return ret;

}
}
};
var G__45374 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__45375__i = 0, G__45375__a = new Array(arguments.length -  0);
while (G__45375__i < G__45375__a.length) {G__45375__a[G__45375__i] = arguments[G__45375__i + 0]; ++G__45375__i;}
  args = new cljs.core.IndexedSeq(G__45375__a,0,null);
} 
return G__45374__delegate.call(this,args);};
G__45374.cljs$lang$maxFixedArity = 0;
G__45374.cljs$lang$applyTo = (function (arglist__45376){
var args = cljs.core.seq(arglist__45376);
return G__45374__delegate(args);
});
G__45374.cljs$core$IFn$_invoke$arity$variadic = G__45374__delegate;
return G__45374;
})()
;
});
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__4742__auto__ = [];
var len__4736__auto___45377 = arguments.length;
var i__4737__auto___45378 = (0);
while(true){
if((i__4737__auto___45378 < len__4736__auto___45377)){
args__4742__auto__.push((arguments[i__4737__auto___45378]));

var G__45379 = (i__4737__auto___45378 + (1));
i__4737__auto___45378 = G__45379;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
}));

(com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq44658){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq44658));
}));

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__44659 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44660 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__44659,G__44660) : com.rpl.specter.compiled_select.call(null,G__44659,G__44660));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__44661 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44662 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__44661,G__44662) : com.rpl.specter.compiled_select_one.call(null,G__44661,G__44662));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__44663 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44664 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__44663,G__44664) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__44663,G__44664));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__44665 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44666 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__44665,G__44666) : com.rpl.specter.compiled_select_first.call(null,G__44665,G__44666));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__44667 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44668 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__44667,G__44668) : com.rpl.specter.compiled_select_any.call(null,G__44667,G__44668));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__44672 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44673 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__44672,G__44673) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__44672,G__44673));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__44674 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__44675 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__44674,G__44675) : com.rpl.specter.compiled_traverse.call(null,G__44674,G__44675));
});
/**
 * Version of traverse-all that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse_all = com.rpl.specter.impl.compiled_traverse_all_STAR_;
/**
 * Returns a transducer that traverses over each element with the given path.
 */
com.rpl.specter.traverse_all_STAR_ = (function com$rpl$specter$traverse_all_STAR_(apath){
var G__44676 = com.rpl.specter.impl.comp_paths_STAR_(apath);
return (com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.compiled_traverse_all.cljs$core$IFn$_invoke$arity$1(G__44676) : com.rpl.specter.compiled_traverse_all.call(null,G__44676));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Version of vtransform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_vtransform = com.rpl.specter.impl.compiled_vtransform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__44677 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44678 = transform_fn;
var G__44679 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__44677,G__44678,G__44679) : com.rpl.specter.compiled_transform.call(null,G__44677,G__44678,G__44679));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal` or `vterminal`. Error is thrown if navigation finishes
 * at a non-terminal navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__44680 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44681 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__44680,G__44681) : com.rpl.specter.compiled_multi_transform.call(null,G__44680,G__44681));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__44682 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44683 = val;
var G__44684 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__44682,G__44683,G__44684) : com.rpl.specter.compiled_setval.call(null,G__44682,G__44683,G__44684));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___45391 = arguments.length;
var i__4737__auto___45392 = (0);
while(true){
if((i__4737__auto___45392 < len__4736__auto___45391)){
args__4742__auto__.push((arguments[i__4737__auto___45392]));

var G__45393 = (i__4737__auto___45392 + (1));
i__4737__auto___45392 = G__45393;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__44693){
var map__44694 = p__44693;
var map__44694__$1 = (((((!((map__44694 == null))))?(((((map__44694.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44694.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__44694):map__44694);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44694__$1,new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341),cljs.core.concat);
var G__44696 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__44697 = transform_fn;
var G__44698 = structure;
var G__44699 = new cljs.core.Keyword(null,"merge-fn","merge-fn",588067341);
var G__44700 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__44696,G__44697,G__44698,G__44699,G__44700) : com.rpl.specter.compiled_replace_in.call(null,G__44696,G__44697,G__44698,G__44699,G__44700));
}));

(com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq44689){
var G__44690 = cljs.core.first(seq44689);
var seq44689__$1 = cljs.core.next(seq44689);
var G__44691 = cljs.core.first(seq44689__$1);
var seq44689__$2 = cljs.core.next(seq44689__$1);
var G__44692 = cljs.core.first(seq44689__$2);
var seq44689__$3 = cljs.core.next(seq44689__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44690,G__44691,G__44692,seq44689__$3);
}));

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.late_resolved_fn = com.rpl.specter.impl.late_resolved_fn;
com.rpl.specter.eachnav = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (navfn){
var latenavfn = (com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_resolved_fn.cljs$core$IFn$_invoke$arity$1(navfn) : com.rpl.specter.late_resolved_fn.call(null,navfn));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45398__delegate = function (args){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(latenavfn,args);
};
var G__45398 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__45399__i = 0, G__45399__a = new Array(arguments.length -  0);
while (G__45399__i < G__45399__a.length) {G__45399__a[G__45399__i] = arguments[G__45399__i + 0]; ++G__45399__i;}
  args = new cljs.core.IndexedSeq(G__45399__a,0,null);
} 
return G__45398__delegate.call(this,args);};
G__45398.cljs$lang$maxFixedArity = 0;
G__45398.cljs$lang$applyTo = (function (arglist__45400){
var args = cljs.core.seq(arglist__45400);
return G__45398__delegate(args);
});
G__45398.cljs$core$IFn$_invoke$arity$variadic = G__45398__delegate;
return G__45398;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44702 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44702 = (function (meta44703){
this.meta44703 = meta44703;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44702.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44704,meta44703__$1){
var self__ = this;
var _44704__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44702(meta44703__$1));
}));

(com.rpl.specter.t_com$rpl$specter44702.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44704){
var self__ = this;
var _44704__$1 = this;
return self__.meta44703;
}));

(com.rpl.specter.t_com$rpl$specter44702.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44702.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter44702.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return structure;
}));

(com.rpl.specter.t_com$rpl$specter44702.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44703","meta44703",1803239595,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44702.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44702.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44702");

(com.rpl.specter.t_com$rpl$specter44702.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44702");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44702.
 */
com.rpl.specter.__GT_t_com$rpl$specter44702 = (function com$rpl$specter$__GT_t_com$rpl$specter44702(meta44703){
return (new com.rpl.specter.t_com$rpl$specter44702(meta44703));
});

}

return (new com.rpl.specter.t_com$rpl$specter44702(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * Defines an endpoint in the navigation the transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44705 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44705 = (function (afn,meta44706){
this.afn = afn;
this.meta44706 = meta44706;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44705.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44707,meta44706__$1){
var self__ = this;
var _44707__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44705(self__.afn,meta44706__$1));
}));

(com.rpl.specter.t_com$rpl$specter44705.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44707){
var self__ = this;
var _44707__$1 = this;
return self__.meta44706;
}));

(com.rpl.specter.t_com$rpl$specter44705.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44705.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter44705.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
}));

(com.rpl.specter.t_com$rpl$specter44705.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta44706","meta44706",586225025,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44705.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44705.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44705");

(com.rpl.specter.t_com$rpl$specter44705.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44705");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44705.
 */
com.rpl.specter.__GT_t_com$rpl$specter44705 = (function com$rpl$specter$__GT_t_com$rpl$specter44705(afn__$1,meta44706){
return (new com.rpl.specter.t_com$rpl$specter44705(afn__$1,meta44706));
});

}

return (new com.rpl.specter.t_com$rpl$specter44705(afn,null));
}));
/**
 * Defines an endpoint in the navigation the transform function run.The transform
 *        function works differently than it does in `transform`. Rather than receive
 *        collected vals spliced in as the first arguments to the function, this function
 *        always takes two arguemnts. The first is all collected vals in a vector, and
 *        the second is the navigated value.
 */
com.rpl.specter.vterminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44708 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44708 = (function (afn,meta44709){
this.afn = afn;
this.meta44709 = meta44709;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44708.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44710,meta44709__$1){
var self__ = this;
var _44710__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44708(self__.afn,meta44709__$1));
}));

(com.rpl.specter.t_com$rpl$specter44708.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44710){
var self__ = this;
var _44710__$1 = this;
return self__.meta44709;
}));

(com.rpl.specter.t_com$rpl$specter44708.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44708.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter44708.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(vals,structure) : self__.afn.call(null,vals,structure));
}));

(com.rpl.specter.t_com$rpl$specter44708.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta44709","meta44709",1595727686,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44708.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44708.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44708");

(com.rpl.specter.t_com$rpl$specter44708.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44708");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44708.
 */
com.rpl.specter.__GT_t_com$rpl$specter44708 = (function com$rpl$specter$__GT_t_com$rpl$specter44708(afn__$1,meta44709){
return (new com.rpl.specter.t_com$rpl$specter44708(afn__$1,meta44709));
});

}

return (new com.rpl.specter.t_com$rpl$specter44708(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__44715 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__44715) : com.rpl.specter.terminal.call(null,G__44715));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44719 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44719 = (function (meta44720){
this.meta44720 = meta44720;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44719.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44721,meta44720__$1){
var self__ = this;
var _44721__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44719(meta44720__$1));
}));

(com.rpl.specter.t_com$rpl$specter44719.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44721){
var self__ = this;
var _44721__$1 = this;
return self__.meta44720;
}));

(com.rpl.specter.t_com$rpl$specter44719.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44719.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44719.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.navs.all_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44719.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44720","meta44720",-437092608,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44719.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44719.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44719");

(com.rpl.specter.t_com$rpl$specter44719.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44719");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44719.
 */
com.rpl.specter.__GT_t_com$rpl$specter44719 = (function com$rpl$specter$__GT_t_com$rpl$specter44719(meta44720){
return (new com.rpl.specter.t_com$rpl$specter44719(meta44720));
});

}

return (new com.rpl.specter.t_com$rpl$specter44719(null));
})()
;


com.rpl.specter.ALL_WITH_META_select_STAR_ = (function com$rpl$specter$ALL_WITH_META_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_WITH_META_transform_STAR_ = (function com$rpl$specter$ALL_WITH_META_transform_STAR_(structure,next_fn){
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
});

/**
 * Same as ALL, except maintains metadata on the structure.
 */
com.rpl.specter.ALL_WITH_META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44727 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44727 = (function (meta44728){
this.meta44728 = meta44728;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44727.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44729,meta44728__$1){
var self__ = this;
var _44729__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44727(meta44728__$1));
}));

(com.rpl.specter.t_com$rpl$specter44727.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44729){
var self__ = this;
var _44729__$1 = this;
return self__.meta44728;
}));

(com.rpl.specter.t_com$rpl$specter44727.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44727.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.navs.all_select(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44727.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var m = cljs.core.meta(structure);
var res = com.rpl.specter.navs.all_transform(structure,next_fn);
if((!((res == null)))){
return cljs.core.with_meta(res,m);
} else {
return null;
}
}));

(com.rpl.specter.t_com$rpl$specter44727.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44728","meta44728",-1715892012,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44727.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44727.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44727");

(com.rpl.specter.t_com$rpl$specter44727.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44727");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44727.
 */
com.rpl.specter.__GT_t_com$rpl$specter44727 = (function com$rpl$specter$__GT_t_com$rpl$specter44727(meta44728){
return (new com.rpl.specter.t_com$rpl$specter44727(meta44728));
});

}

return (new com.rpl.specter.t_com$rpl$specter44727(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,v){
var ret__35249__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44736 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44736 = (function (meta44737){
this.meta44737 = meta44737;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44736.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44738,meta44737__$1){
var self__ = this;
var _44738__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44736(meta44737__$1));
}));

(com.rpl.specter.t_com$rpl$specter44736.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44738){
var self__ = this;
var _44738__$1 = this;
return self__.meta44737;
}));

(com.rpl.specter.t_com$rpl$specter44736.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44736.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,v){
var ret__35249__auto__ = next_fn(v);
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
}));

(com.rpl.specter.t_com$rpl$specter44736.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44736.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44737","meta44737",214104142,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44736.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44736.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44736");

(com.rpl.specter.t_com$rpl$specter44736.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44736");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44736.
 */
com.rpl.specter.__GT_t_com$rpl$specter44736 = (function com$rpl$specter$__GT_t_com$rpl$specter44736(meta44737){
return (new com.rpl.specter.t_com$rpl$specter44736(meta44737));
});

}

return (new com.rpl.specter.t_com$rpl$specter44736(null));
})()
;


com.rpl.specter.MAP_KEYS_select_STAR_ = (function com$rpl$specter$MAP_KEYS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,k){
var ret__35249__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(k) : next_fn.call(null,k));
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
});

com.rpl.specter.MAP_KEYS_transform_STAR_ = (function com$rpl$specter$MAP_KEYS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
});

/**
 * Navigate to each key of the map. This is more efficient than
 *        navigating via [ALL FIRST]
 */
com.rpl.specter.MAP_KEYS = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44750 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44750 = (function (meta44751){
this.meta44751 = meta44751;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44750.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44752,meta44751__$1){
var self__ = this;
var _44752__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44750(meta44751__$1));
}));

(com.rpl.specter.t_com$rpl$specter44750.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44752){
var self__ = this;
var _44752__$1 = this;
return self__.meta44751;
}));

(com.rpl.specter.t_com$rpl$specter44750.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44750.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,k){
var ret__35249__auto__ = next_fn(k);
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.keys(structure));
}));

(com.rpl.specter.t_com$rpl$specter44750.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.navs.map_keys_transform(structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44750.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44751","meta44751",1636994454,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44750.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44750.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44750");

(com.rpl.specter.t_com$rpl$specter44750.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44750");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44750.
 */
com.rpl.specter.__GT_t_com$rpl$specter44750 = (function com$rpl$specter$__GT_t_com$rpl$specter44750(meta44751){
return (new com.rpl.specter.t_com$rpl$specter44750(meta44751));
});

}

return (new com.rpl.specter.t_com$rpl$specter44750(null));
})()
;
com.rpl.specter.VAL = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44755 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44755 = (function (meta44756){
this.meta44756 = meta44756;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44755.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44757,meta44756__$1){
var self__ = this;
var _44757__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44755(meta44756__$1));
}));

(com.rpl.specter.t_com$rpl$specter44755.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44757){
var self__ = this;
var _44757__$1 = this;
return self__.meta44756;
}));

(com.rpl.specter.t_com$rpl$specter44755.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44755.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__44759 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,structure);
var G__44760 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__44759,G__44760) : next_fn__42957__auto__.call(null,G__44759,G__44760));
}));

(com.rpl.specter.t_com$rpl$specter44755.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__44767 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,structure);
var G__44768 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__44767,G__44768) : next_fn__42957__auto__.call(null,G__44767,G__44768));
}));

(com.rpl.specter.t_com$rpl$specter44755.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44756","meta44756",1359985615,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44755.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44755.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44755");

(com.rpl.specter.t_com$rpl$specter44755.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44755");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44755.
 */
com.rpl.specter.__GT_t_com$rpl$specter44755 = (function com$rpl$specter$__GT_t_com$rpl$specter44755(meta44756){
return (new com.rpl.specter.t_com$rpl$specter44755(meta44756));
});

}

return (new com.rpl.specter.t_com$rpl$specter44755(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_index_fn,end_index_fn,structure,next_fn){
var s = (start_index_fn.cljs$core$IFn$_invoke$arity$1 ? start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_index_fn.call(null,structure));
var G__44776 = structure;
var G__44777 = s;
var G__44778 = com.rpl.specter.navs.invoke_end_fn(end_index_fn,structure,s);
var G__44779 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__44776,G__44777,G__44778,G__44779) : com.rpl.specter.navs.srange_transform.call(null,G__44776,G__44777,G__44778,G__44779));
});

/**
 * Uses start-index-fn and end-index-fn to determine the bounds of the subsequence
 *        to select when navigating. `start-index-fn` takes in the structure as input. `end-index-fn`
 *        can be one of two forms. If a regular function (e.g. defined with `fn`), it takes in only the structure as input. If a function defined using special `end-fn` macro, it takes in the structure and the result of `start-index-fn`.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_index_fn,end_index_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44780 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44780 = (function (start_index_fn,end_index_fn,meta44781){
this.start_index_fn = start_index_fn;
this.end_index_fn = end_index_fn;
this.meta44781 = meta44781;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44780.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44782,meta44781__$1){
var self__ = this;
var _44782__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44780(self__.start_index_fn,self__.end_index_fn,meta44781__$1));
}));

(com.rpl.specter.t_com$rpl$specter44780.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44782){
var self__ = this;
var _44782__$1 = this;
return self__.meta44781;
}));

(com.rpl.specter.t_com$rpl$specter44780.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44780.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
return com.rpl.specter.navs.srange_select(structure,s,com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s),next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44780.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var s = (self__.start_index_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_index_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_index_fn.call(null,structure));
var G__44783 = structure;
var G__44784 = s;
var G__44785 = com.rpl.specter.navs.invoke_end_fn(self__.end_index_fn,structure,s);
var G__44786 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__44783,G__44784,G__44785,G__44786) : com.rpl.specter.navs.srange_transform.call(null,G__44783,G__44784,G__44785,G__44786));
}));

(com.rpl.specter.t_com$rpl$specter44780.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start-index-fn","start-index-fn",-344842645,null),new cljs.core.Symbol(null,"end-index-fn","end-index-fn",1237092062,null),new cljs.core.Symbol(null,"meta44781","meta44781",340256663,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44780.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44780.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44780");

(com.rpl.specter.t_com$rpl$specter44780.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44780");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44780.
 */
com.rpl.specter.__GT_t_com$rpl$specter44780 = (function com$rpl$specter$__GT_t_com$rpl$specter44780(start_index_fn__$1,end_index_fn__$1,meta44781){
return (new com.rpl.specter.t_com$rpl$specter44780(start_index_fn__$1,end_index_fn__$1,meta44781));
});

}

return (new com.rpl.specter.t_com$rpl$specter44780(start_index_fn,end_index_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44795 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44795 = (function (start,end,meta44796){
this.start = start;
this.end = end;
this.meta44796 = meta44796;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44795.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44797,meta44796__$1){
var self__ = this;
var _44797__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44795(self__.start,self__.end,meta44796__$1));
}));

(com.rpl.specter.t_com$rpl$specter44795.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44797){
var self__ = this;
var _44797__$1 = this;
return self__.meta44796;
}));

(com.rpl.specter.t_com$rpl$specter44795.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44795.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44795.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
}));

(com.rpl.specter.t_com$rpl$specter44795.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"end","end",1372345569,null),new cljs.core.Symbol(null,"meta44796","meta44796",-409078968,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44795.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44795.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44795");

(com.rpl.specter.t_com$rpl$specter44795.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44795");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44795.
 */
com.rpl.specter.__GT_t_com$rpl$specter44795 = (function com$rpl$specter$__GT_t_com$rpl$specter44795(start__$1,end__$1,meta44796){
return (new com.rpl.specter.t_com$rpl$specter44795(start__$1,end__$1,meta44796));
});

}

return (new com.rpl.specter.t_com$rpl$specter44795(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,p__44813){
var vec__44814 = p__44813;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44814,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44814,(1),null);
var ret__35249__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44817 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44817 = (function (pred,meta44818){
this.pred = pred;
this.meta44818 = meta44818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44819,meta44818__$1){
var self__ = this;
var _44819__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44817(self__.pred,meta44818__$1));
}));

(com.rpl.specter.t_com$rpl$specter44817.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44819){
var self__ = this;
var _44819__$1 = this;
return self__.meta44818;
}));

(com.rpl.specter.t_com$rpl$specter44817.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44817.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,p__44820){
var vec__44821 = p__44820;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44821,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44821,(1),null);
var ret__35249__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
}));

(com.rpl.specter.t_com$rpl$specter44817.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter44817.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"meta44818","meta44818",-1795006688,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44817.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44817.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44817");

(com.rpl.specter.t_com$rpl$specter44817.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44817");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44817.
 */
com.rpl.specter.__GT_t_com$rpl$specter44817 = (function com$rpl$specter$__GT_t_com$rpl$specter44817(pred__$1,meta44818){
return (new com.rpl.specter.t_com$rpl$specter44817(pred__$1,meta44818));
});

}

return (new com.rpl.specter.t_com$rpl$specter44817(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__44827 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44827) : next_fn.call(null,G__44827));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,""))),structure].join('');
} else {
var to_prepend = (function (){var G__44828 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44828) : next_fn.call(null,G__44828));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44829 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44829 = (function (meta44830){
this.meta44830 = meta44830;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44829.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44831,meta44830__$1){
var self__ = this;
var _44831__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44829(meta44830__$1));
}));

(com.rpl.specter.t_com$rpl$specter44829.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44831){
var self__ = this;
var _44831__$1 = this;
return self__.meta44830;
}));

(com.rpl.specter.t_com$rpl$specter44829.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44829.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter44829.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
if(typeof structure === 'string'){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn("")),structure].join('');
} else {
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
}
}));

(com.rpl.specter.t_com$rpl$specter44829.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44830","meta44830",1785526685,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44829.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44829.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44829");

(com.rpl.specter.t_com$rpl$specter44829.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44829");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44829.
 */
com.rpl.specter.__GT_t_com$rpl$specter44829 = (function com$rpl$specter$__GT_t_com$rpl$specter44829(meta44830){
return (new com.rpl.specter.t_com$rpl$specter44829(meta44830));
});

}

return (new com.rpl.specter.t_com$rpl$specter44829(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__44838 = ((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44838) : next_fn.call(null,G__44838));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1((next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1("") : next_fn.call(null,"")))].join('');
} else {
var to_append = (function (){var G__44841 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44841) : next_fn.call(null,G__44841));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
}
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44842 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44842 = (function (meta44843){
this.meta44843 = meta44843;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44842.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44844,meta44843__$1){
var self__ = this;
var _44844__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44842(meta44843__$1));
}));

(com.rpl.specter.t_com$rpl$specter44842.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44844){
var self__ = this;
var _44844__$1 = this;
return self__.meta44843;
}));

(com.rpl.specter.t_com$rpl$specter44842.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44842.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(((typeof structure === 'string')?"":cljs.core.PersistentVector.EMPTY));
}));

(com.rpl.specter.t_com$rpl$specter44842.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
if(typeof structure === 'string'){
return [structure,cljs.core.str.cljs$core$IFn$_invoke$arity$1(next_fn(""))].join('');
} else {
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
}
}));

(com.rpl.specter.t_com$rpl$specter44842.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44843","meta44843",2068122947,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44842.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44842.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44842");

(com.rpl.specter.t_com$rpl$specter44842.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44842");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44842.
 */
com.rpl.specter.__GT_t_com$rpl$specter44842 = (function com$rpl$specter$__GT_t_com$rpl$specter44842(meta44843){
return (new com.rpl.specter.t_com$rpl$specter44842(meta44843));
});

}

return (new com.rpl.specter.t_com$rpl$specter44842(null));
})()
;


com.rpl.specter.NONE_ELEM_select_STAR_ = (function com$rpl$specter$NONE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.NONE_ELEM_transform_STAR_ = (function com$rpl$specter$NONE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
});

/**
 * Navigate to 'void' elem in the set.
 *        For transformations - if result is not `NONE`,
 *        then add that value to the set.
 */
com.rpl.specter.NONE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44855 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44855 = (function (meta44856){
this.meta44856 = meta44856;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44855.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44857,meta44856__$1){
var self__ = this;
var _44857__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44855(meta44856__$1));
}));

(com.rpl.specter.t_com$rpl$specter44855.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44857){
var self__ = this;
var _44857__$1 = this;
return self__.meta44856;
}));

(com.rpl.specter.t_com$rpl$specter44855.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44855.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter44855.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
if((structure == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([newe]);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(structure,newe);
}
}
}));

(com.rpl.specter.t_com$rpl$specter44855.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44856","meta44856",3839515,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44855.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44855.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44855");

(com.rpl.specter.t_com$rpl$specter44855.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44855");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44855.
 */
com.rpl.specter.__GT_t_com$rpl$specter44855 = (function com$rpl$specter$__GT_t_com$rpl$specter44855(meta44856){
return (new com.rpl.specter.t_com$rpl$specter44855(meta44856));
});

}

return (new com.rpl.specter.t_com$rpl$specter44855(null));
})()
;


com.rpl.specter.BEFORE_ELEM_select_STAR_ = (function com$rpl$specter$BEFORE_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.BEFORE_ELEM_transform_STAR_ = (function com$rpl$specter$BEFORE_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
});

/**
 * Navigate to 'void' element before the sequence.
 *        For transformations – if result is not `NONE`,
 *        then prepend that value.
 */
com.rpl.specter.BEFORE_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44868 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44868 = (function (meta44869){
this.meta44869 = meta44869;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44868.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44870,meta44869__$1){
var self__ = this;
var _44870__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44868(meta44869__$1));
}));

(com.rpl.specter.t_com$rpl$specter44868.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44870){
var self__ = this;
var _44870__$1 = this;
return self__.meta44869;
}));

(com.rpl.specter.t_com$rpl$specter44868.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44868.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter44868.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.prepend_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter44868.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44869","meta44869",1718239615,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44868.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44868.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44868");

(com.rpl.specter.t_com$rpl$specter44868.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44868");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44868.
 */
com.rpl.specter.__GT_t_com$rpl$specter44868 = (function com$rpl$specter$__GT_t_com$rpl$specter44868(meta44869){
return (new com.rpl.specter.t_com$rpl$specter44868(meta44869));
});

}

return (new com.rpl.specter.t_com$rpl$specter44868(null));
})()
;


com.rpl.specter.AFTER_ELEM_select_STAR_ = (function com$rpl$specter$AFTER_ELEM_select_STAR_(structure,next_fn){
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
});

com.rpl.specter.AFTER_ELEM_transform_STAR_ = (function com$rpl$specter$AFTER_ELEM_transform_STAR_(structure,next_fn){
var newe = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.NONE) : next_fn.call(null,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
});

/**
 * Navigate to 'void' element after the sequence.
 *        For transformations – if result is not `NONE`,
 *        then append that value.
 */
com.rpl.specter.AFTER_ELEM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44874 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44874 = (function (meta44875){
this.meta44875 = meta44875;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44874.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44876,meta44875__$1){
var self__ = this;
var _44876__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44874(meta44875__$1));
}));

(com.rpl.specter.t_com$rpl$specter44874.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44876){
var self__ = this;
var _44876__$1 = this;
return self__.meta44875;
}));

(com.rpl.specter.t_com$rpl$specter44874.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44874.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(com.rpl.specter.NONE);
}));

(com.rpl.specter.t_com$rpl$specter44874.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var newe = next_fn(com.rpl.specter.NONE);
if((com.rpl.specter.NONE === newe)){
return structure;
} else {
return com.rpl.specter.navs.append_one(structure,newe);
}
}));

(com.rpl.specter.t_com$rpl$specter44874.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta44875","meta44875",-117375117,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44874.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44874.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44874");

(com.rpl.specter.t_com$rpl$specter44874.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44874");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44874.
 */
com.rpl.specter.__GT_t_com$rpl$specter44874 = (function com$rpl$specter$__GT_t_com$rpl$specter44874(meta44875){
return (new com.rpl.specter.t_com$rpl$specter44874(meta44875));
});

}

return (new com.rpl.specter.t_com$rpl$specter44874(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__44889 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44889) : next_fn.call(null,G__44889));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44890 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44890 = (function (aset,meta44891){
this.aset = aset;
this.meta44891 = meta44891;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44890.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44892,meta44891__$1){
var self__ = this;
var _44892__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44890(self__.aset,meta44891__$1));
}));

(com.rpl.specter.t_com$rpl$specter44890.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44892){
var self__ = this;
var _44892__$1 = this;
return self__.meta44891;
}));

(com.rpl.specter.t_com$rpl$specter44890.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44890.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
}));

(com.rpl.specter.t_com$rpl$specter44890.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
}));

(com.rpl.specter.t_com$rpl$specter44890.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"aset","aset",900773178,null),new cljs.core.Symbol(null,"meta44891","meta44891",1480747393,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44890.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44890.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44890");

(com.rpl.specter.t_com$rpl$specter44890.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44890");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44890.
 */
com.rpl.specter.__GT_t_com$rpl$specter44890 = (function com$rpl$specter$__GT_t_com$rpl$specter44890(aset__$1,meta44891){
return (new com.rpl.specter.t_com$rpl$specter44890(aset__$1,meta44891));
});

}

return (new com.rpl.specter.t_com$rpl$specter44890(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__44908 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44908) : next_fn.call(null,G__44908));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44909 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44909 = (function (m_keys,meta44910){
this.m_keys = m_keys;
this.meta44910 = meta44910;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44909.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44911,meta44910__$1){
var self__ = this;
var _44911__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44909(self__.m_keys,meta44910__$1));
}));

(com.rpl.specter.t_com$rpl$specter44909.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44911){
var self__ = this;
var _44911__$1 = this;
return self__.meta44910;
}));

(com.rpl.specter.t_com$rpl$specter44909.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44909.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
}));

(com.rpl.specter.t_com$rpl$specter44909.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
}));

(com.rpl.specter.t_com$rpl$specter44909.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"m-keys","m-keys",-197459035,null),new cljs.core.Symbol(null,"meta44910","meta44910",1721599324,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44909.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44909.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44909");

(com.rpl.specter.t_com$rpl$specter44909.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44909");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44909.
 */
com.rpl.specter.__GT_t_com$rpl$specter44909 = (function com$rpl$specter$__GT_t_com$rpl$specter44909(m_keys__$1,meta44910){
return (new com.rpl.specter.t_com$rpl$specter44909(m_keys__$1,meta44910));
});

}

return (new com.rpl.specter.t_com$rpl$specter44909(m_keys,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 * 
 *   If transformed sequence is smaller than input sequence, missing entries
 *   will be filled in with NONE, triggering removal if supported by that navigator.
 * 
 *   Value collection (e.g. collect, collect-one) may not be used in the subpath.
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45488__delegate = function (path){
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44915 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44915 = (function (path,late,meta44916){
this.path = path;
this.late = late;
this.meta44916 = meta44916;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44915.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44917,meta44916__$1){
var self__ = this;
var _44917__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44915(self__.path,self__.late,meta44916__$1));
}));

(com.rpl.specter.t_com$rpl$specter44915.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44917){
var self__ = this;
var _44917__$1 = this;
return self__.meta44916;
}));

(com.rpl.specter.t_com$rpl$specter44915.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44915.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
}));

(com.rpl.specter.t_com$rpl$specter44915.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(transformed));
var G__44923 = self__.late;
var G__44924 = (function (_){
var vs = com.rpl.specter.impl.get_cell(values_to_insert);
if(cljs.core.truth_(vs)){
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.next);

return cljs.core.first(vs);
} else {
return com.rpl.specter.NONE;
}
});
var G__44925 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__44923,G__44924,G__44925) : com.rpl.specter.compiled_transform.call(null,G__44923,G__44924,G__44925));
}));

(com.rpl.specter.t_com$rpl$specter44915.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta44916","meta44916",-704931142,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44915.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44915.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44915");

(com.rpl.specter.t_com$rpl$specter44915.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44915");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44915.
 */
com.rpl.specter.__GT_t_com$rpl$specter44915 = (function com$rpl$specter$__GT_t_com$rpl$specter44915(path__$1,late__$1,meta44916){
return (new com.rpl.specter.t_com$rpl$specter44915(path__$1,late__$1,meta44916));
});

}

return (new com.rpl.specter.t_com$rpl$specter44915(path,late,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
};
var G__45488 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45489__i = 0, G__45489__a = new Array(arguments.length -  0);
while (G__45489__i < G__45489__a.length) {G__45489__a[G__45489__i] = arguments[G__45489__i + 0]; ++G__45489__i;}
  path = new cljs.core.IndexedSeq(G__45489__a,0,null);
} 
return G__45488__delegate.call(this,path);};
G__45488.cljs$lang$maxFixedArity = 0;
G__45488.cljs$lang$applyTo = (function (arglist__45490){
var path = cljs.core.seq(arglist__45490);
return G__45488__delegate(path);
});
G__45488.cljs$core$IFn$_invoke$arity$variadic = G__45488__delegate;
return G__45488;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the given key in the map (not to the value). Navigates only if the
 *        key currently exists in the map. Can transform to NONE to remove the key/value
 *        pair from the map.
 */
com.rpl.specter.map_key = com.rpl.specter.impl.direct_nav_obj((function (key){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44928 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44928 = (function (key,meta44929){
this.key = key;
this.meta44929 = meta44929;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44928.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44930,meta44929__$1){
var self__ = this;
var _44930__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44928(self__.key,meta44929__$1));
}));

(com.rpl.specter.t_com$rpl$specter44928.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44930){
var self__ = this;
var _44930__$1 = this;
return self__.meta44929;
}));

(com.rpl.specter.t_com$rpl$specter44928.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44928.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter44928.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.key)){
var newkey = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.key) : next_fn.call(null,vals,self__.key));
var dissoced = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
if((com.rpl.specter.NONE === newkey)){
return dissoced;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(dissoced,newkey,cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key));
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter44928.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"key","key",124488940,null),new cljs.core.Symbol(null,"meta44929","meta44929",-2107404127,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44928.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44928.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44928");

(com.rpl.specter.t_com$rpl$specter44928.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44928");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44928.
 */
com.rpl.specter.__GT_t_com$rpl$specter44928 = (function com$rpl$specter$__GT_t_com$rpl$specter44928(key__$1,meta44929){
return (new com.rpl.specter.t_com$rpl$specter44928(key__$1,meta44929));
});

}

return (new com.rpl.specter.t_com$rpl$specter44928(key,null));
}));
/**
 * Navigates to the given element in the set only if it exists in the set.
 *        Can transform to NONE to remove the element from the set.
 */
com.rpl.specter.set_elem = com.rpl.specter.impl.direct_nav_obj((function (elem){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44936 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44936 = (function (elem,meta44937){
this.elem = elem;
this.meta44937 = meta44937;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44936.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44938,meta44937__$1){
var self__ = this;
var _44938__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44936(self__.elem,meta44937__$1));
}));

(com.rpl.specter.t_com$rpl$specter44936.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44938){
var self__ = this;
var _44938__$1 = this;
return self__.meta44937;
}));

(com.rpl.specter.t_com$rpl$specter44936.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44936.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter44936.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.elem)){
var newelem = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.elem) : next_fn.call(null,vals,self__.elem));
var removed = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(structure,self__.elem);
if((com.rpl.specter.NONE === newelem)){
return removed;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(removed,newelem);
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter44936.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"elem","elem",-2035804713,null),new cljs.core.Symbol(null,"meta44937","meta44937",-1914948586,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44936.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44936.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44936");

(com.rpl.specter.t_com$rpl$specter44936.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44936");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44936.
 */
com.rpl.specter.__GT_t_com$rpl$specter44936 = (function com$rpl$specter$__GT_t_com$rpl$specter44936(elem__$1,meta44937){
return (new com.rpl.specter.t_com$rpl$specter44936(elem__$1,meta44937));
});

}

return (new com.rpl.specter.t_com$rpl$specter44936(elem,null));
}));
/**
 * Navigate to the specified keys one after another. If navigate to NONE,
 *           that element is removed from the map or vector.
 */
com.rpl.specter.keypath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.keypath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.keypath_STAR_));
/**
 * Navigate to the specified keys one after another, only if they exist
 *           in the data structure. If navigate to NONE, that element is removed
 *           from the map or vector.
 */
com.rpl.specter.must = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.must_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.must_STAR_));
/**
 * Navigate to the specified indices one after another. If navigate to
 *          NONE, that element is removed from the sequence.
 */
com.rpl.specter.nthpath = (com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.eachnav.cljs$core$IFn$_invoke$arity$1(com.rpl.specter.navs.nthpath_STAR_) : com.rpl.specter.eachnav.call(null,com.rpl.specter.navs.nthpath_STAR_));
/**
 * Navigates to the empty space between the index and the prior index. For select
 *        navigates to NONE, and transforms to non-NONE insert at that position.
 */
com.rpl.specter.before_index = com.rpl.specter.impl.direct_nav_obj((function (index){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44954 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44954 = (function (index,meta44955){
this.index = index;
this.meta44955 = meta44955;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44954.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44956,meta44955__$1){
var self__ = this;
var _44956__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44954(self__.index,meta44955__$1));
}));

(com.rpl.specter.t_com$rpl$specter44954.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44956){
var self__ = this;
var _44956__$1 = this;
return self__.meta44955;
}));

(com.rpl.specter.t_com$rpl$specter44954.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44954.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.NONE;
}));

(com.rpl.specter.t_com$rpl$specter44954.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var v = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,com.rpl.specter.NONE) : next_fn.call(null,vals,com.rpl.specter.NONE));
if((com.rpl.specter.NONE === v)){
return structure;
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache44957;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info44958 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.srange,new cljs.core.Var(function(){return com.rpl.specter.srange;},new cljs.core.Symbol("com.rpl.specter","srange","com.rpl.specter/srange",-978851939,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"srange","srange",-1324254972,null),"com/rpl/specter.cljc",9,1,791,794,cljs.core.List.EMPTY,"Navigates to the subsequence bound by the indexes start (inclusive)\n          and end (exclusive)",(cljs.core.truth_(com.rpl.specter.srange)?com.rpl.specter.srange.cljs$lang$test:null)])),new cljs.core.Symbol(null,"srange","srange",-1324254972,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null)),com.rpl.specter.impl.__GT_LocalSym(self__.index,new cljs.core.Symbol(null,"index","index",108845612,null))], null),cljs.core.list(new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"srange","srange",-1324254972,null),new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"index","index",108845612,null)], null));
com.rpl.specter.pathcache44957 = info44958;

return info44958;
})():info__42969__auto__);
var precompiled44959 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__44960 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.srange,self__.index,self__.index], null);
return (precompiled44959.cljs$core$IFn$_invoke$arity$1 ? precompiled44959.cljs$core$IFn$_invoke$arity$1(G__44960) : precompiled44959.call(null,G__44960));
} else {
return precompiled44959;
}
})(),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [v], null),structure);
}
}));

(com.rpl.specter.t_com$rpl$specter44954.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index","index",108845612,null),new cljs.core.Symbol(null,"meta44955","meta44955",1549998105,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44954.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44954.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44954");

(com.rpl.specter.t_com$rpl$specter44954.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44954");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44954.
 */
com.rpl.specter.__GT_t_com$rpl$specter44954 = (function com$rpl$specter$__GT_t_com$rpl$specter44954(index__$1,meta44955){
return (new com.rpl.specter.t_com$rpl$specter44954(index__$1,meta44955));
});

}

return (new com.rpl.specter.t_com$rpl$specter44954(index,null));
}));
/**
 * Navigates to the index of the sequence if within 0 and size. Transforms move element
 *        at that index to the new index, shifting other elements in the sequence.
 */
com.rpl.specter.index_nav = com.rpl.specter.impl.direct_nav_obj((function (i){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter44964 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter44964 = (function (i,meta44965){
this.i = i;
this.meta44965 = meta44965;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter44964.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_44966,meta44965__$1){
var self__ = this;
var _44966__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter44964(self__.i,meta44965__$1));
}));

(com.rpl.specter.t_com$rpl$specter44964.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_44966){
var self__ = this;
var _44966__$1 = this;
return self__.meta44965;
}));

(com.rpl.specter.t_com$rpl$specter44964.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter44964.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
} else {
return com.rpl.specter.NONE;
}
}));

(com.rpl.specter.t_com$rpl$specter44964.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if((((self__.i >= (0))) && ((self__.i < cljs.core.count(structure))))){
var newi = (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,self__.i) : next_fn.call(null,vals,self__.i));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(newi,self__.i)){
return structure;
} else {
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(structure,self__.i);
if(cljs.core.vector_QMARK_(structure)){
var shifted = (((newi < self__.i))?(function (){var j = (self__.i - (1));
var s = structure;
while(true){
if((j < newi)){
return s;
} else {
var G__45500 = (j - (1));
var G__45501 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j + (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__45500;
s = G__45501;
continue;
}
break;
}
})():(function (){var j = (self__.i + (1));
var s = structure;
while(true){
if((j > newi)){
return s;
} else {
var G__45503 = (j + (1));
var G__45504 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(s,(j - (1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(s,j));
j = G__45503;
s = G__45504;
continue;
}
break;
}
})());
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(shifted,newi,v);
} else {
return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache44972;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info44973 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.before_index,new cljs.core.Var(function(){return com.rpl.specter.before_index;},new cljs.core.Symbol("com.rpl.specter","before-index","com.rpl.specter/before-index",1952616274,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),"com/rpl/specter.cljc",15,1,1004,1007,cljs.core.List.EMPTY,"Navigates to the empty space between the index and the prior index. For select\n          navigates to NONE, and transforms to non-NONE insert at that position.",(cljs.core.truth_(com.rpl.specter.before_index)?com.rpl.specter.before_index.cljs$lang$test:null)])),new cljs.core.Symbol(null,"before-index","before-index",-407870261,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(newi,new cljs.core.Symbol(null,"newi","newi",857919881,null))], null),cljs.core.list(new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"before-index","before-index",-407870261,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null));
com.rpl.specter.pathcache44972 = info44973;

return info44973;
})():info__42969__auto__);
var precompiled44974 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__44975 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.before_index,newi], null);
return (precompiled44974.cljs$core$IFn$_invoke$arity$1 ? precompiled44974.cljs$core$IFn$_invoke$arity$1(G__44975) : precompiled44974.call(null,G__44975));
} else {
return precompiled44974;
}
})(),v,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache44976;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info44977 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,999,1001,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(self__.i,new cljs.core.Symbol(null,"i","i",253690212,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"i","i",253690212,null)], null));
com.rpl.specter.pathcache44976 = info44977;

return info44977;
})():info__42969__auto__);
var precompiled44978 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__44981 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,self__.i], null);
return (precompiled44978.cljs$core$IFn$_invoke$arity$1 ? precompiled44978.cljs$core$IFn$_invoke$arity$1(G__44981) : precompiled44978.call(null,G__44981));
} else {
return precompiled44978;
}
})(),com.rpl.specter.NONE,structure));
}
}
} else {
return structure;
}
}));

(com.rpl.specter.t_com$rpl$specter44964.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"i","i",253690212,null),new cljs.core.Symbol(null,"meta44965","meta44965",1665340207,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter44964.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter44964.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter44964");

(com.rpl.specter.t_com$rpl$specter44964.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter44964");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter44964.
 */
com.rpl.specter.__GT_t_com$rpl$specter44964 = (function com$rpl$specter$__GT_t_com$rpl$specter44964(i__$1,meta44965){
return (new com.rpl.specter.t_com$rpl$specter44964(i__$1,meta44965));
});

}

return (new com.rpl.specter.t_com$rpl$specter44964(i,null));
}));


com.rpl.specter.indexed_vals_select_STAR_ = (function com$rpl$specter$indexed_vals_select_STAR_(start,structure,next_fn){
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,e){
var ret__35249__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

var G__44989 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44989) : next_fn.call(null,G__44989));
})()
;
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,structure);
});

com.rpl.specter.indexed_vals_transform_STAR_ = (function com$rpl$specter$indexed_vals_transform_STAR_(start,structure,next_fn){
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__44991 = (function (){var G__44994 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(start + curri),e], null);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__44994) : next_fn.call(null,G__44994));
})();
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44991,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44991,(1),null);
var newi = (newi_STAR_ - start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache44999;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45000 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,715,718,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__44986_SHARP_){
return (p1__44986_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__44987_SHARP_){
return (p1__44987_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache44999 = info45000;

return info45000;
})():info__42969__auto__);
var precompiled45001 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45002 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__44986_SHARP_){
return (p1__44986_SHARP_ >= (curri + (1)));
}),(function (p1__44987_SHARP_){
return (p1__44987_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__44986_SHARP_){
return (p1__44986_SHARP_ >= (curri + (1)));
}),(function (p1__44987_SHARP_){
return (p1__44987_SHARP_ <= newi);
})], null);
return (precompiled45001.cljs$core$IFn$_invoke$arity$1 ? precompiled45001.cljs$core$IFn$_invoke$arity$1(G__45002) : precompiled45001.call(null,G__45002));
} else {
return precompiled45001;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache45003;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45004 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,1019,1022,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache45003 = info45004;

return info45004;
})():info__42969__auto__);
var precompiled45005 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45016 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled45005.cljs$core$IFn$_invoke$arity$1 ? precompiled45005.cljs$core$IFn$_invoke$arity$1(G__45016) : precompiled45005.call(null,G__45016));
} else {
return precompiled45005;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache45017;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45018 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,999,1001,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache45017 = info45018;

return info45018;
})():info__42969__auto__);
var precompiled45019 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45020 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled45019.cljs$core$IFn$_invoke$arity$1 ? precompiled45019.cljs$core$IFn$_invoke$arity$1(G__45020) : precompiled45019.call(null,G__45020));
} else {
return precompiled45019;
}
})(),newe,s));
}),structure,structure);
});

/**
 * Navigate to [index elem] pairs for each element in a sequence. The sequence will be indexed
 *        starting from `start`. Changing index in transform has same effect as `index-nav`. Indices seen
 *        during transform take into account any shifting from prior sequence elements changing indices.
 */
com.rpl.specter.indexed_vals = com.rpl.specter.impl.direct_nav_obj((function (start){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45021 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45021 = (function (start,meta45022){
this.start = start;
this.meta45022 = meta45022;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45021.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45023,meta45022__$1){
var self__ = this;
var _45023__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45021(self__.start,meta45022__$1));
}));

(com.rpl.specter.t_com$rpl$specter45021.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45023){
var self__ = this;
var _45023__$1 = this;
return self__.meta45022;
}));

(com.rpl.specter.t_com$rpl$specter45021.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45021.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var i = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1((self__.start - (1)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,e){
var ret__35249__auto__ = (function (){
com.rpl.specter.impl.update_cell_BANG_(i,cljs.core.inc);

return next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.get_cell(i),e], null));
})()
;
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,structure);
}));

(com.rpl.specter.t_com$rpl$specter45021.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var indices = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(structure)));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s,e){
var curri = cljs.core.first(com.rpl.specter.impl.get_cell(indices));
var vec__45027 = next_fn(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.start + curri),e], null));
var newi_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45027,(0),null);
var newe = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45027,(1),null);
var newi = (newi_STAR_ - self__.start);
com.rpl.specter.impl.update_cell_BANG_(indices,(function (ii){
var ii2 = cljs.core.next(ii);
if((newi > curri)){
return com.rpl.specter.impl.compiled_transform_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache45030;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45031 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,715,718,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__44986_SHARP_){
return (p1__44986_SHARP_ >= (curri + (1)));
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null))))),com.rpl.specter.impl.__GT_SpecialFormUse((function (p1__44987_SHARP_){
return (p1__44987_SHARP_ <= newi);
}),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null),new cljs.core.Symbol(null,"newi","newi",857919881,null))))], null)], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null)], null),cljs.core.list(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.Symbol(null,"p1__44986#","p1__44986#",-2093422498,null),cljs.core.list(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))),cljs.core.list(new cljs.core.Symbol(null,"fn*","fn*",-752876845,null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null)], null),cljs.core.list(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.Symbol(null,"p1__44987#","p1__44987#",-401437229,null),new cljs.core.Symbol(null,"newi","newi",857919881,null)))], null));
com.rpl.specter.pathcache45030 = info45031;

return info45031;
})():info__42969__auto__);
var precompiled45032 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45033 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,(function (p1__44986_SHARP_){
return (p1__44986_SHARP_ >= (curri + (1)));
}),(function (p1__44987_SHARP_){
return (p1__44987_SHARP_ <= newi);
})], null),com.rpl.specter.ALL,(function (p1__44986_SHARP_){
return (p1__44986_SHARP_ >= (curri + (1)));
}),(function (p1__44987_SHARP_){
return (p1__44987_SHARP_ <= newi);
})], null);
return (precompiled45032.cljs$core$IFn$_invoke$arity$1 ? precompiled45032.cljs$core$IFn$_invoke$arity$1(G__45033) : precompiled45032.call(null,G__45033));
} else {
return precompiled45032;
}
})(),cljs.core.dec,ii2);
} else {
return ii2;
}
}));

return com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache45035;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45036 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.index_nav,new cljs.core.Var(function(){return com.rpl.specter.index_nav;},new cljs.core.Symbol("com.rpl.specter","index-nav","com.rpl.specter/index-nav",2054501071,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),"com/rpl/specter.cljc",12,1,1019,1022,cljs.core.List.EMPTY,"Navigates to the index of the sequence if within 0 and size. Transforms move element\n          at that index to the new index, shifting other elements in the sequence.",(cljs.core.truth_(com.rpl.specter.index_nav)?com.rpl.specter.index_nav.cljs$lang$test:null)])),new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-nav","index-nav",-157001568,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache45035 = info45036;

return info45036;
})():info__42969__auto__);
var precompiled45037 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45042 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.index_nav,curri], null);
return (precompiled45037.cljs$core$IFn$_invoke$arity$1 ? precompiled45037.cljs$core$IFn$_invoke$arity$1(G__45042) : precompiled45037.call(null,G__45042));
} else {
return precompiled45037;
}
})(),newi,com.rpl.specter.impl.compiled_setval_STAR_((function (){var info__42969__auto__ = com.rpl.specter.pathcache45043;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45044 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.nthpath,new cljs.core.Var(function(){return com.rpl.specter.nthpath;},new cljs.core.Symbol("com.rpl.specter","nthpath","com.rpl.specter/nthpath",2085224162,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),"com/rpl/specter.cljc",10,1,999,1001,cljs.core.List.EMPTY,"Navigate to the specified indices one after another. If navigate to\n            NONE, that element is removed from the sequence.",(cljs.core.truth_(com.rpl.specter.nthpath)?com.rpl.specter.nthpath.cljs$lang$test:null)])),new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(curri,new cljs.core.Symbol(null,"curri","curri",347667219,null))], null),cljs.core.list(new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"curri","curri",347667219,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"nthpath","nthpath",-400599909,null),new cljs.core.Symbol(null,"curri","curri",347667219,null)], null));
com.rpl.specter.pathcache45043 = info45044;

return info45044;
})():info__42969__auto__);
var precompiled45045 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45046 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.nthpath,curri], null);
return (precompiled45045.cljs$core$IFn$_invoke$arity$1 ? precompiled45045.cljs$core$IFn$_invoke$arity$1(G__45046) : precompiled45045.call(null,G__45046));
} else {
return precompiled45045;
}
})(),newe,s));
}),structure,structure);
}));

(com.rpl.specter.t_com$rpl$specter45021.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"start","start",1285322546,null),new cljs.core.Symbol(null,"meta45022","meta45022",1592322906,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45021.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45021.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45021");

(com.rpl.specter.t_com$rpl$specter45021.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45021");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45021.
 */
com.rpl.specter.__GT_t_com$rpl$specter45021 = (function com$rpl$specter$__GT_t_com$rpl$specter45021(start__$1,meta45022){
return (new com.rpl.specter.t_com$rpl$specter45021(start__$1,meta45022));
});

}

return (new com.rpl.specter.t_com$rpl$specter45021(start,null));
}));
/**
 * `indexed-vals` with a starting index of 0.
 */
com.rpl.specter.INDEXED_VALS = (com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.indexed_vals.cljs$core$IFn$_invoke$arity$1((0)) : com.rpl.specter.indexed_vals.call(null,(0)));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45049 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45049 = (function (afn,meta45050){
this.afn = afn;
this.meta45050 = meta45050;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45049.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45051,meta45050__$1){
var self__ = this;
var _45051__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45049(self__.afn,meta45050__$1));
}));

(com.rpl.specter.t_com$rpl$specter45049.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45051){
var self__ = this;
var _45051__$1 = this;
return self__.meta45050;
}));

(com.rpl.specter.t_com$rpl$specter45049.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45049.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__45057 = vals;
var G__45058 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__45057,G__45058) : next_fn.call(null,G__45057,G__45058));
}));

(com.rpl.specter.t_com$rpl$specter45049.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__45059 = vals;
var G__45060 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__45059,G__45060) : next_fn.call(null,G__45059,G__45060));
}));

(com.rpl.specter.t_com$rpl$specter45049.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"meta45050","meta45050",1937967678,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45049.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45049.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45049");

(com.rpl.specter.t_com$rpl$specter45049.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45049");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45049.
 */
com.rpl.specter.__GT_t_com$rpl$specter45049 = (function com$rpl$specter$__GT_t_com$rpl$specter45049(afn__$1,meta45050){
return (new com.rpl.specter.t_com$rpl$specter45049(afn__$1,meta45050));
});

}

return (new com.rpl.specter.t_com$rpl$specter45049(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__45066 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45066) : next_fn.call(null,G__45066));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__45067 = (function (){var G__45068 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45068) : next_fn.call(null,G__45068));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__45067) : unparse_fn.call(null,G__45067));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45069 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45069 = (function (parse_fn,unparse_fn,meta45070){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta45070 = meta45070;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45069.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45071,meta45070__$1){
var self__ = this;
var _45071__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45069(self__.parse_fn,self__.unparse_fn,meta45070__$1));
}));

(com.rpl.specter.t_com$rpl$specter45069.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45071){
var self__ = this;
var _45071__$1 = this;
return self__.meta45070;
}));

(com.rpl.specter.t_com$rpl$specter45069.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45069.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
}));

(com.rpl.specter.t_com$rpl$specter45069.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var G__45082 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__45082) : self__.unparse_fn.call(null,G__45082));
}));

(com.rpl.specter.t_com$rpl$specter45069.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"parse-fn","parse-fn",-836029424,null),new cljs.core.Symbol(null,"unparse-fn","unparse-fn",407187734,null),new cljs.core.Symbol(null,"meta45070","meta45070",670635321,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45069.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45069.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45069");

(com.rpl.specter.t_com$rpl$specter45069.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45069");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45069.
 */
com.rpl.specter.__GT_t_com$rpl$specter45069 = (function com$rpl$specter$__GT_t_com$rpl$specter45069(parse_fn__$1,unparse_fn__$1,meta45070){
return (new com.rpl.specter.t_com$rpl$specter45069(parse_fn__$1,unparse_fn__$1,meta45070));
});

}

return (new com.rpl.specter.t_com$rpl$specter45069(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__45083 = cljs.core.deref(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45083) : next_fn.call(null,G__45083));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45084 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45084 = (function (meta45085){
this.meta45085 = meta45085;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45084.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45086,meta45085__$1){
var self__ = this;
var _45086__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45084(meta45085__$1));
}));

(com.rpl.specter.t_com$rpl$specter45084.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45086){
var self__ = this;
var _45086__$1 = this;
return self__.meta45085;
}));

(com.rpl.specter.t_com$rpl$specter45084.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45084.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(cljs.core.deref(structure));
}));

(com.rpl.specter.t_com$rpl$specter45084.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
}));

(com.rpl.specter.t_com$rpl$specter45084.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta45085","meta45085",-849614913,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45084.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45084.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45084");

(com.rpl.specter.t_com$rpl$specter45084.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45084");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45084.
 */
com.rpl.specter.__GT_t_com$rpl$specter45084 = (function com$rpl$specter$__GT_t_com$rpl$specter45084(meta45085){
return (new com.rpl.specter.t_com$rpl$specter45084(meta45085));
});

}

return (new com.rpl.specter.t_com$rpl$specter45084(null));
})()
;


com.rpl.specter.regex_nav_select_STAR_ = (function com$rpl$specter$regex_nav_select_STAR_(re,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,s){
var ret__35249__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(s) : next_fn.call(null,s));
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(re,structure));
});

com.rpl.specter.regex_nav_transform_STAR_ = (function com$rpl$specter$regex_nav_transform_STAR_(re,structure,next_fn){
return clojure.string.replace(structure,re,next_fn);
});

com.rpl.specter.regex_nav = com.rpl.specter.impl.direct_nav_obj((function (re){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45091 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45091 = (function (re,meta45092){
this.re = re;
this.meta45092 = meta45092;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45091.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45093,meta45092__$1){
var self__ = this;
var _45093__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45091(self__.re,meta45092__$1));
}));

(com.rpl.specter.t_com$rpl$specter45091.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45093){
var self__ = this;
var _45093__$1 = this;
return self__.meta45092;
}));

(com.rpl.specter.t_com$rpl$specter45091.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45091.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__35248__auto__,s){
var ret__35249__auto__ = next_fn(s);
if((ret__35249__auto__ === com.rpl.specter.NONE)){
return curr__35248__auto__;
} else {
if(cljs.core.reduced_QMARK_(ret__35249__auto__)){
return cljs.core.reduced(ret__35249__auto__);
} else {
return ret__35249__auto__;
}
}
}),com.rpl.specter.NONE,cljs.core.re_seq(self__.re,structure));
}));

(com.rpl.specter.t_com$rpl$specter45091.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return clojure.string.replace(structure,self__.re,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter45091.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"re","re",1869207729,null),new cljs.core.Symbol(null,"meta45092","meta45092",670134588,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45091.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45091.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45091");

(com.rpl.specter.t_com$rpl$specter45091.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45091");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45091.
 */
com.rpl.specter.__GT_t_com$rpl$specter45091 = (function com$rpl$specter$__GT_t_com$rpl$specter45091(re__$1,meta45092){
return (new com.rpl.specter.t_com$rpl$specter45091(re__$1,meta45092));
});

}

return (new com.rpl.specter.t_com$rpl$specter45091(re,null));
}));
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45535__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return afn;
} else {
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45106 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45106 = (function (path,temp__5733__auto__,late,meta45107){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta45107 = meta45107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45108,meta45107__$1){
var self__ = this;
var _45108__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45106(self__.path,self__.temp__5733__auto__,self__.late,meta45107__$1));
}));

(com.rpl.specter.t_com$rpl$specter45106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45108){
var self__ = this;
var _45108__$1 = this;
return self__.meta45107;
}));

(com.rpl.specter.t_com$rpl$specter45106.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45106.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__45100_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__45100_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter45106.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__45101_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,vals,p1__45101_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter45106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta45107","meta45107",-1180106065,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45106.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45106.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45106");

(com.rpl.specter.t_com$rpl$specter45106.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45106");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45106.
 */
com.rpl.specter.__GT_t_com$rpl$specter45106 = (function com$rpl$specter$__GT_t_com$rpl$specter45106(path__$1,temp__5733__auto____$1,late__$1,meta45107){
return (new com.rpl.specter.t_com$rpl$specter45106(path__$1,temp__5733__auto____$1,late__$1,meta45107));
});

}

return (new com.rpl.specter.t_com$rpl$specter45106(path,temp__5733__auto__,late,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
}
};
var G__45535 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45542__i = 0, G__45542__a = new Array(arguments.length -  0);
while (G__45542__i < G__45542__a.length) {G__45542__a[G__45542__i] = arguments[G__45542__i + 0]; ++G__45542__i;}
  path = new cljs.core.IndexedSeq(G__45542__a,0,null);
} 
return G__45535__delegate.call(this,path);};
G__45535.cljs$lang$maxFixedArity = 0;
G__45535.cljs$lang$applyTo = (function (arglist__45543){
var path = cljs.core.seq(arglist__45543);
return G__45535__delegate(path);
});
G__45535.cljs$core$IFn$_invoke$arity$variadic = G__45535__delegate;
return G__45535;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45544__delegate = function (path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
} else {
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45117 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45117 = (function (path,temp__5733__auto__,late,meta45118){
this.path = path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late = late;
this.meta45118 = meta45118;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45117.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45119,meta45118__$1){
var self__ = this;
var _45119__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45117(self__.path,self__.temp__5733__auto__,self__.late,meta45118__$1));
}));

(com.rpl.specter.t_com$rpl$specter45117.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45119){
var self__ = this;
var _45119__$1 = this;
return self__.meta45118;
}));

(com.rpl.specter.t_com$rpl$specter45117.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45117.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_select((function (p1__45115_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__45115_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter45117.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.filter_transform((function (p1__45116_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,vals,p1__45116_SHARP_);
}),vals,structure,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter45117.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta45118","meta45118",-705300651,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45117.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45117.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45117");

(com.rpl.specter.t_com$rpl$specter45117.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45117");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45117.
 */
com.rpl.specter.__GT_t_com$rpl$specter45117 = (function com$rpl$specter$__GT_t_com$rpl$specter45117(path__$1,temp__5733__auto____$1,late__$1,meta45118){
return (new com.rpl.specter.t_com$rpl$specter45117(path__$1,temp__5733__auto____$1,late__$1,meta45118));
});

}

return (new com.rpl.specter.t_com$rpl$specter45117(path,temp__5733__auto__,late,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
}
};
var G__45544 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45545__i = 0, G__45545__a = new Array(arguments.length -  0);
while (G__45545__i < G__45545__a.length) {G__45545__a[G__45545__i] = arguments[G__45545__i + 0]; ++G__45545__i;}
  path = new cljs.core.IndexedSeq(G__45545__a,0,null);
} 
return G__45544__delegate.call(this,path);};
G__45544.cljs$lang$maxFixedArity = 0;
G__45544.cljs$lang$applyTo = (function (arglist__45546){
var path = cljs.core.seq(arglist__45546);
return G__45544__delegate(path);
});
G__45544.cljs$core$IFn$_invoke$arity$variadic = G__45544__delegate;
return G__45544;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 *   For transformation: `NONE` entries in the result sequence cause corresponding entries in
 *   input to be removed. A result sequence smaller than the input sequence is equivalent to
 *   padding the result sequence with `NONE` at the end until the same size as the input.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45548__delegate = function (path){
var G__45130 = com.rpl.specter.ALL;
var G__45131 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__45130,G__45131) : com.rpl.specter.subselect.call(null,G__45130,G__45131));
};
var G__45548 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45549__i = 0, G__45549__a = new Array(arguments.length -  0);
while (G__45549__i < G__45549__a.length) {G__45549__a[G__45549__i] = arguments[G__45549__i + 0]; ++G__45549__i;}
  path = new cljs.core.IndexedSeq(G__45549__a,0,null);
} 
return G__45548__delegate.call(this,path);};
G__45548.cljs$lang$maxFixedArity = 0;
G__45548.cljs$lang$applyTo = (function (arglist__45550){
var path = cljs.core.seq(arglist__45550);
return G__45548__delegate(path);
});
G__45548.cljs$core$IFn$_invoke$arity$variadic = G__45548__delegate;
return G__45548;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,update_fn){
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45132 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45132 = (function (path,update_fn,late,late_fn,meta45133){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta45133 = meta45133;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45132.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45134,meta45133__$1){
var self__ = this;
var _45134__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45132(self__.path,self__.update_fn,self__.late,self__.late_fn,meta45133__$1));
}));

(com.rpl.specter.t_com$rpl$specter45132.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45134){
var self__ = this;
var _45134__$1 = this;
return self__.meta45133;
}));

(com.rpl.specter.t_com$rpl$specter45132.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45132.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter45132.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
}));

(com.rpl.specter.t_com$rpl$specter45132.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"update-fn","update-fn",-1943348456,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta45133","meta45133",-1253720482,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45132.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45132.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45132");

(com.rpl.specter.t_com$rpl$specter45132.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45132");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45132.
 */
com.rpl.specter.__GT_t_com$rpl$specter45132 = (function com$rpl$specter$__GT_t_com$rpl$specter45132(path__$1,update_fn__$1,late__$1,late_fn__$1,meta45133){
return (new com.rpl.specter.t_com$rpl$specter45132(path__$1,update_fn__$1,late__$1,late_fn__$1,meta45133));
});

}

return (new com.rpl.specter.t_com$rpl$specter45132(path,update_fn,late,late_fn,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to a view of the current value by transforming with a reduction over
 * the specified traversal.
 */
com.rpl.specter.traversed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function (path,reduce_fn){
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45138 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45138 = (function (path,reduce_fn,late,late_fn,meta45139){
this.path = path;
this.reduce_fn = reduce_fn;
this.late = late;
this.late_fn = late_fn;
this.meta45139 = meta45139;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45138.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45140,meta45139__$1){
var self__ = this;
var _45140__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45138(self__.path,self__.reduce_fn,self__.late,self__.late_fn,meta45139__$1));
}));

(com.rpl.specter.t_com$rpl$specter45138.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45140){
var self__ = this;
var _45140__$1 = this;
return self__.meta45139;
}));

(com.rpl.specter.t_com$rpl$specter45138.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45138.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter45138.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(self__.late_fn,(com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_traverse.call(null,self__.late,structure))));
}));

(com.rpl.specter.t_com$rpl$specter45138.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"reduce-fn","reduce-fn",-1484020844,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"late-fn","late-fn",268309430,null),new cljs.core.Symbol(null,"meta45139","meta45139",-1641153184,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45138.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45138.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45138");

(com.rpl.specter.t_com$rpl$specter45138.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45138");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45138.
 */
com.rpl.specter.__GT_t_com$rpl$specter45138 = (function com$rpl$specter$__GT_t_com$rpl$specter45138(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta45139){
return (new com.rpl.specter.t_com$rpl$specter45138(path__$1,reduce_fn__$1,late__$1,late_fn__$1,meta45139));
});

}

return (new com.rpl.specter.t_com$rpl$specter45138(path,reduce_fn,late,late_fn,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),reduce_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
})),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Keeps the element only if it matches the supplied predicate. Functions in paths
 *        implicitly convert to this navigator.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
com.rpl.specter.pred_EQ_ = (function com$rpl$specter$pred_EQ_(v){
var G__45149 = (function (p1__45148_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__45148_SHARP_,v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__45149) : com.rpl.specter.pred.call(null,G__45149));
});
com.rpl.specter.pred_LT_ = (function com$rpl$specter$pred_LT_(v){
var G__45151 = (function (p1__45150_SHARP_){
return (p1__45150_SHARP_ < v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__45151) : com.rpl.specter.pred.call(null,G__45151));
});
com.rpl.specter.pred_GT_ = (function com$rpl$specter$pred_GT_(v){
var G__45157 = (function (p1__45152_SHARP_){
return (p1__45152_SHARP_ > v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__45157) : com.rpl.specter.pred.call(null,G__45157));
});
com.rpl.specter.pred_LT__EQ_ = (function com$rpl$specter$pred_LT__EQ_(v){
var G__45160 = (function (p1__45159_SHARP_){
return (p1__45159_SHARP_ <= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__45160) : com.rpl.specter.pred.call(null,G__45160));
});
com.rpl.specter.pred_GT__EQ_ = (function com$rpl$specter$pred_GT__EQ_(v){
var G__45162 = (function (p1__45161_SHARP_){
return (p1__45161_SHARP_ >= v);
});
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(G__45162) : com.rpl.specter.pred.call(null,G__45162));
});
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"null",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"null",(function (this$){
return com.rpl.specter.STAY;
}));
(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Symbol.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"string",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"string",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"number",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"number",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.char$.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.navs.keypath_STAR_.call(null,this$__$1));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"boolean",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"boolean",(function (this$){
return (com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.navs.keypath_STAR_.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.navs.keypath_STAR_.call(null,this$));
}));
goog.object.set(com.rpl.specter.protocols.ImplicitNav,"function",true);

goog.object.set(com.rpl.specter.protocols.implicit_nav,"function",(function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
}));
(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL);

(RegExp.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.regex_nav.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.regex_nav.call(null,this$__$1));
}));


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__45178 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45178) : next_fn.call(null,G__45178));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__45179 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45179) : next_fn.call(null,G__45179));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45180 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45180 = (function (v,meta45181){
this.v = v;
this.meta45181 = meta45181;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45180.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45182,meta45181__$1){
var self__ = this;
var _45182__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45180(self__.v,meta45181__$1));
}));

(com.rpl.specter.t_com$rpl$specter45180.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45182){
var self__ = this;
var _45182__$1 = this;
return self__.meta45181;
}));

(com.rpl.specter.t_com$rpl$specter45180.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45180.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter45180.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn((((structure == null))?self__.v:structure));
}));

(com.rpl.specter.t_com$rpl$specter45180.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null),new cljs.core.Symbol(null,"meta45181","meta45181",1159540867,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45180.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45180.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45180");

(com.rpl.specter.t_com$rpl$specter45180.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45180");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45180.
 */
com.rpl.specter.__GT_t_com$rpl$specter45180 = (function com$rpl$specter$__GT_t_com$rpl$specter45180(v__$1,meta45181){
return (new com.rpl.specter.t_com$rpl$specter45180(v__$1,meta45181));
});

}

return (new com.rpl.specter.t_com$rpl$specter45180(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__45186 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__45186) : com.rpl.specter.nil__GT_val.call(null,G__45186));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__45187 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__45187) : com.rpl.specter.nil__GT_val.call(null,G__45187));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__45188 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__45188) : com.rpl.specter.nil__GT_val.call(null,G__45188));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__45189 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45189) : next_fn.call(null,G__45189));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__45191 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45191) : next_fn.call(null,G__45191));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45192 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45192 = (function (meta45193){
this.meta45193 = meta45193;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45192.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45194,meta45193__$1){
var self__ = this;
var _45194__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45192(meta45193__$1));
}));

(com.rpl.specter.t_com$rpl$specter45192.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45194){
var self__ = this;
var _45194__$1 = this;
return self__.meta45193;
}));

(com.rpl.specter.t_com$rpl$specter45192.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45192.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(cljs.core.meta(structure));
}));

(com.rpl.specter.t_com$rpl$specter45192.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
}));

(com.rpl.specter.t_com$rpl$specter45192.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta45193","meta45193",370180030,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45192.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45192.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45192");

(com.rpl.specter.t_com$rpl$specter45192.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45192");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45192.
 */
com.rpl.specter.__GT_t_com$rpl$specter45192 = (function com$rpl$specter$__GT_t_com$rpl$specter45192(meta45193){
return (new com.rpl.specter.t_com$rpl$specter45192(meta45193));
});

}

return (new com.rpl.specter.t_com$rpl$specter45192(null));
})()
;


com.rpl.specter.NAME_select_STAR_ = (function com$rpl$specter$NAME_select_STAR_(structure,next_fn){
var G__45201 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45201) : next_fn.call(null,G__45201));
});

com.rpl.specter.NAME_transform_STAR_ = (function com$rpl$specter$NAME_transform_STAR_(structure,next_fn){
var new_name = (function (){var G__45203 = cljs.core.name(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45203) : next_fn.call(null,G__45203));
})();
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the name portion of the keyword or symbol
 */
com.rpl.specter.NAME = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45204 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45204 = (function (meta45205){
this.meta45205 = meta45205;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45204.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45206,meta45205__$1){
var self__ = this;
var _45206__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45204(meta45205__$1));
}));

(com.rpl.specter.t_com$rpl$specter45204.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45206){
var self__ = this;
var _45206__$1 = this;
return self__.meta45205;
}));

(com.rpl.specter.t_com$rpl$specter45204.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45204.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(cljs.core.name(structure));
}));

(com.rpl.specter.t_com$rpl$specter45204.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var new_name = next_fn(cljs.core.name(structure));
var ns = cljs.core.namespace(structure);
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(ns,new_name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAME can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter45204.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta45205","meta45205",-817142304,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45204.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45204.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45204");

(com.rpl.specter.t_com$rpl$specter45204.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45204");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45204.
 */
com.rpl.specter.__GT_t_com$rpl$specter45204 = (function com$rpl$specter$__GT_t_com$rpl$specter45204(meta45205){
return (new com.rpl.specter.t_com$rpl$specter45204(meta45205));
});

}

return (new com.rpl.specter.t_com$rpl$specter45204(null));
})()
;


com.rpl.specter.NAMESPACE_select_STAR_ = (function com$rpl$specter$NAMESPACE_select_STAR_(structure,next_fn){
var G__45209 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45209) : next_fn.call(null,G__45209));
});

com.rpl.specter.NAMESPACE_transform_STAR_ = (function com$rpl$specter$NAMESPACE_transform_STAR_(structure,next_fn){
var name = cljs.core.name(structure);
var new_ns = (function (){var G__45216 = cljs.core.namespace(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__45216) : next_fn.call(null,G__45216));
})();
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
});

/**
 * Navigates to the namespace portion of the keyword or symbol
 */
com.rpl.specter.NAMESPACE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45217 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45217 = (function (meta45218){
this.meta45218 = meta45218;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45217.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45219,meta45218__$1){
var self__ = this;
var _45219__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45217(meta45218__$1));
}));

(com.rpl.specter.t_com$rpl$specter45217.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45219){
var self__ = this;
var _45219__$1 = this;
return self__.meta45218;
}));

(com.rpl.specter.t_com$rpl$specter45217.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45217.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
return next_fn(cljs.core.namespace(structure));
}));

(com.rpl.specter.t_com$rpl$specter45217.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__41914__auto__,vals__41915__auto__,structure,next_fn__41916__auto__){
var self__ = this;
var this__41914__auto____$1 = this;
var next_fn = (function (s__41917__auto__){
return (next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__41916__auto__.cljs$core$IFn$_invoke$arity$2(vals__41915__auto__,s__41917__auto__) : next_fn__41916__auto__.call(null,vals__41915__auto__,s__41917__auto__));
});
var name = cljs.core.name(structure);
var new_ns = next_fn(cljs.core.namespace(structure));
if((structure instanceof cljs.core.Keyword)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
if((structure instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(new_ns,name);
} else {
return com.rpl.specter.impl.throw_illegal_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NAMESPACE can only be used on symbols or keywords - ",structure], 0));

}
}
}));

(com.rpl.specter.t_com$rpl$specter45217.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta45218","meta45218",-236284373,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45217.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45217.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45217");

(com.rpl.specter.t_com$rpl$specter45217.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45217");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45217.
 */
com.rpl.specter.__GT_t_com$rpl$specter45217 = (function com$rpl$specter$__GT_t_com$rpl$specter45217(meta45218){
return (new com.rpl.specter.t_com$rpl$specter45217(meta45218));
});

}

return (new com.rpl.specter.t_com$rpl$specter45217(null));
})()
;
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45578__delegate = function (path){
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45236 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45236 = (function (path,late,meta45237){
this.path = path;
this.late = late;
this.meta45237 = meta45237;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45236.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45238,meta45237__$1){
var self__ = this;
var _45238__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45236(self__.path,self__.late,meta45237__$1));
}));

(com.rpl.specter.t_com$rpl$specter45236.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45238){
var self__ = this;
var _45238__$1 = this;
return self__.meta45237;
}));

(com.rpl.specter.t_com$rpl$specter45236.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45236.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__45242 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__45243 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__45242,G__45243) : next_fn__42957__auto__.call(null,G__45242,G__45243));
}));

(com.rpl.specter.t_com$rpl$specter45236.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__45244 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__45245 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__45244,G__45245) : next_fn__42957__auto__.call(null,G__45244,G__45245));
}));

(com.rpl.specter.t_com$rpl$specter45236.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta45237","meta45237",-185088869,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45236.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45236.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45236");

(com.rpl.specter.t_com$rpl$specter45236.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45236");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45236.
 */
com.rpl.specter.__GT_t_com$rpl$specter45236 = (function com$rpl$specter$__GT_t_com$rpl$specter45236(path__$1,late__$1,meta45237){
return (new com.rpl.specter.t_com$rpl$specter45236(path__$1,late__$1,meta45237));
});

}

return (new com.rpl.specter.t_com$rpl$specter45236(path,late,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
};
var G__45578 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45588__i = 0, G__45588__a = new Array(arguments.length -  0);
while (G__45588__i < G__45588__a.length) {G__45588__a[G__45588__i] = arguments[G__45588__i + 0]; ++G__45588__i;}
  path = new cljs.core.IndexedSeq(G__45588__a,0,null);
} 
return G__45578__delegate.call(this,path);};
G__45578.cljs$lang$maxFixedArity = 0;
G__45578.cljs$lang$applyTo = (function (arglist__45589){
var path = cljs.core.seq(arglist__45589);
return G__45578__delegate(path);
});
G__45578.cljs$core$IFn$_invoke$arity$variadic = G__45578__delegate;
return G__45578;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45592__delegate = function (path){
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45258 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45258 = (function (path,late,meta45259){
this.path = path;
this.late = late;
this.meta45259 = meta45259;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45258.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45260,meta45259__$1){
var self__ = this;
var _45260__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45258(self__.path,self__.late,meta45259__$1));
}));

(com.rpl.specter.t_com$rpl$specter45258.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45260){
var self__ = this;
var _45260__$1 = this;
return self__.meta45259;
}));

(com.rpl.specter.t_com$rpl$specter45258.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45258.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__45262 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__45263 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__45262,G__45263) : next_fn__42957__auto__.call(null,G__45262,G__45263));
}));

(com.rpl.specter.t_com$rpl$specter45258.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__45268 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__45269 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__45268,G__45269) : next_fn__42957__auto__.call(null,G__45268,G__45269));
}));

(com.rpl.specter.t_com$rpl$specter45258.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta45259","meta45259",165207103,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45258.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45258.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45258");

(com.rpl.specter.t_com$rpl$specter45258.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45258");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45258.
 */
com.rpl.specter.__GT_t_com$rpl$specter45258 = (function com$rpl$specter$__GT_t_com$rpl$specter45258(path__$1,late__$1,meta45259){
return (new com.rpl.specter.t_com$rpl$specter45258(path__$1,late__$1,meta45259));
});

}

return (new com.rpl.specter.t_com$rpl$specter45258(path,late,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
};
var G__45592 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45605__i = 0, G__45605__a = new Array(arguments.length -  0);
while (G__45605__i < G__45605__a.length) {G__45605__a[G__45605__i] = arguments[G__45605__i + 0]; ++G__45605__i;}
  path = new cljs.core.IndexedSeq(G__45605__a,0,null);
} 
return G__45592__delegate.call(this,path);};
G__45592.cljs$lang$maxFixedArity = 0;
G__45592.cljs$lang$applyTo = (function (arglist__45606){
var path = cljs.core.seq(arglist__45606);
return G__45592__delegate(path);
});
G__45592.cljs$core$IFn$_invoke$arity$variadic = G__45592__delegate;
return G__45592;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45274 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45274 = (function (val,meta45275){
this.val = val;
this.meta45275 = meta45275;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45274.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45276,meta45275__$1){
var self__ = this;
var _45276__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45274(self__.val,meta45275__$1));
}));

(com.rpl.specter.t_com$rpl$specter45274.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45276){
var self__ = this;
var _45276__$1 = this;
return self__.meta45275;
}));

(com.rpl.specter.t_com$rpl$specter45274.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45274.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__45287 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,self__.val);
var G__45288 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__45287,G__45288) : next_fn__42957__auto__.call(null,G__45287,G__45288));
}));

(com.rpl.specter.t_com$rpl$specter45274.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__42955__auto__,vals__42956__auto__,structure,next_fn__42957__auto__){
var self__ = this;
var this__42955__auto____$1 = this;
var G__45289 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__42956__auto__,self__.val);
var G__45290 = structure;
return (next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__42957__auto__.cljs$core$IFn$_invoke$arity$2(G__45289,G__45290) : next_fn__42957__auto__.call(null,G__45289,G__45290));
}));

(com.rpl.specter.t_com$rpl$specter45274.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"val","val",1769233139,null),new cljs.core.Symbol(null,"meta45275","meta45275",-967321289,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45274.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45274.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45274");

(com.rpl.specter.t_com$rpl$specter45274.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45274");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45274.
 */
com.rpl.specter.__GT_t_com$rpl$specter45274 = (function com$rpl$specter$__GT_t_com$rpl$specter45274(val__$1,meta45275){
return (new com.rpl.specter.t_com$rpl$specter45274(val__$1,meta45275));
});

}

return (new com.rpl.specter.t_com$rpl$specter45274(val,null));
}));
com.rpl.specter.with_fresh_collected = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45618__delegate = function (path){
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45291 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45291 = (function (path,late,meta45292){
this.path = path;
this.late = late;
this.meta45292 = meta45292;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45291.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45293,meta45292__$1){
var self__ = this;
var _45293__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45291(self__.path,self__.late,meta45292__$1));
}));

(com.rpl.specter.t_com$rpl$specter45291.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45293){
var self__ = this;
var _45293__$1 = this;
return self__.meta45292;
}));

(com.rpl.specter.t_com$rpl$specter45291.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45291.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.select_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter45291.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.protocols.transform_STAR_(self__.late,cljs.core.PersistentVector.EMPTY,structure,(function (_,structure__$1){
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(vals,structure__$1) : next_fn.call(null,vals,structure__$1));
}));
}));

(com.rpl.specter.t_com$rpl$specter45291.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"late","late",-666327347,null),new cljs.core.Symbol(null,"meta45292","meta45292",1360108303,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45291.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45291.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45291");

(com.rpl.specter.t_com$rpl$specter45291.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45291");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45291.
 */
com.rpl.specter.__GT_t_com$rpl$specter45291 = (function com$rpl$specter$__GT_t_com$rpl$specter45291(path__$1,late__$1,meta45292){
return (new com.rpl.specter.t_com$rpl$specter45291(path__$1,late__$1,meta45292));
});

}

return (new com.rpl.specter.t_com$rpl$specter45291(path,late,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
};
var G__45618 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45626__i = 0, G__45626__a = new Array(arguments.length -  0);
while (G__45626__i < G__45626__a.length) {G__45626__a[G__45626__i] = arguments[G__45626__i + 0]; ++G__45626__i;}
  path = new cljs.core.IndexedSeq(G__45626__a,0,null);
} 
return G__45618__delegate.call(this,path);};
G__45618.cljs$lang$maxFixedArity = 0;
G__45618.cljs$lang$applyTo = (function (arglist__45627){
var path = cljs.core.seq(arglist__45627);
return G__45618__delegate(path);
});
G__45618.cljs$core$IFn$_invoke$arity$variadic = G__45618__delegate;
return G__45618;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45299 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45299 = (function (meta45300){
this.meta45300 = meta45300;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45299.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45301,meta45300__$1){
var self__ = this;
var _45301__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45299(meta45300__$1));
}));

(com.rpl.specter.t_com$rpl$specter45299.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45301){
var self__ = this;
var _45301__$1 = this;
return self__.meta45300;
}));

(com.rpl.specter.t_com$rpl$specter45299.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45299.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__45307 = cljs.core.PersistentVector.EMPTY;
var G__45308 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__45307,G__45308) : next_fn.call(null,G__45307,G__45308));
}));

(com.rpl.specter.t_com$rpl$specter45299.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__45309 = cljs.core.PersistentVector.EMPTY;
var G__45310 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__45309,G__45310) : next_fn.call(null,G__45309,G__45310));
}));

(com.rpl.specter.t_com$rpl$specter45299.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"meta45300","meta45300",898687909,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45299.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45299.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45299");

(com.rpl.specter.t_com$rpl$specter45299.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45299");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45299.
 */
com.rpl.specter.__GT_t_com$rpl$specter45299 = (function com$rpl$specter$__GT_t_com$rpl$specter45299(meta45300){
return (new com.rpl.specter.t_com$rpl$specter45299(meta45300));
});

}

return (new com.rpl.specter.t_com$rpl$specter45299(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__45632 = null;
var G__45632__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__45632__3 = (function (cond_p,then_path,else_path){
var temp__5733__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__5733__auto__)){
var afn = temp__5733__auto__;
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45315 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45315 = (function (cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,meta45316){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta45316 = meta45316;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45315.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45317,meta45316__$1){
var self__ = this;
var _45317__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45315(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.afn,self__.late_then,self__.late_else,meta45316__$1));
}));

(com.rpl.specter.t_com$rpl$specter45315.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45317){
var self__ = this;
var _45317__$1 = this;
return self__.meta45316;
}));

(com.rpl.specter.t_com$rpl$specter45315.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45315.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter45315.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter45315.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta45316","meta45316",1916778648,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45315.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45315.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45315");

(com.rpl.specter.t_com$rpl$specter45315.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45315");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45315.
 */
com.rpl.specter.__GT_t_com$rpl$specter45315 = (function com$rpl$specter$__GT_t_com$rpl$specter45315(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta45316){
return (new com.rpl.specter.t_com$rpl$specter45315(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,afn__$1,late_then__$1,late_else__$1,meta45316));
});

}

return (new com.rpl.specter.t_com$rpl$specter45315(cond_p,then_path,else_path,temp__5733__auto__,afn,late_then,late_else,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
} else {
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late_cond,late_then,late_else){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45328 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45328 = (function (cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,meta45329){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__5733__auto__ = temp__5733__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta45329 = meta45329;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45328.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45330,meta45329__$1){
var self__ = this;
var _45330__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45328(self__.cond_p,self__.then_path,self__.else_path,self__.temp__5733__auto__,self__.late_cond,self__.late_then,self__.late_else,meta45329__$1));
}));

(com.rpl.specter.t_com$rpl$specter45328.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45330){
var self__ = this;
var _45330__$1 = this;
return self__.meta45329;
}));

(com.rpl.specter.t_com$rpl$specter45328.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45328.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,(function (p1__45311_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__45311_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter45328.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,(function (p1__45312_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,vals,p1__45312_SHARP_);
}),self__.late_then,self__.late_else);
}));

(com.rpl.specter.t_com$rpl$specter45328.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-p","cond-p",695068009,null),new cljs.core.Symbol(null,"then-path","then-path",1949536092,null),new cljs.core.Symbol(null,"else-path","else-path",-2100209576,null),new cljs.core.Symbol(null,"temp__5733__auto__","temp__5733__auto__",484944449,null),new cljs.core.Symbol(null,"late-cond","late-cond",1031862828,null),new cljs.core.Symbol(null,"late-then","late-then",1623904294,null),new cljs.core.Symbol(null,"late-else","late-else",1462724600,null),new cljs.core.Symbol(null,"meta45329","meta45329",-2018817621,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45328.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45328.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45328");

(com.rpl.specter.t_com$rpl$specter45328.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45328");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45328.
 */
com.rpl.specter.__GT_t_com$rpl$specter45328 = (function com$rpl$specter$__GT_t_com$rpl$specter45328(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta45329){
return (new com.rpl.specter.t_com$rpl$specter45328(cond_p__$1,then_path__$1,else_path__$1,temp__5733__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta45329));
});

}

return (new com.rpl.specter.t_com$rpl$specter45328(cond_p,then_path,else_path,temp__5733__auto__,late_cond,late_then,late_else,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
}
});
G__45632 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__45632__2.call(this,cond_p,then_path);
case 3:
return G__45632__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45632.cljs$core$IFn$_invoke$arity$2 = G__45632__2;
G__45632.cljs$core$IFn$_invoke$arity$3 = G__45632__3;
return G__45632;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45665__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p,p__45331){
var vec__45332 = p__45331;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45332,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45332,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
}),com.rpl.specter.STOP,pairs);
};
var G__45665 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__45672__i = 0, G__45672__a = new Array(arguments.length -  0);
while (G__45672__i < G__45672__a.length) {G__45672__a[G__45672__i] = arguments[G__45672__i + 0]; ++G__45672__i;}
  conds = new cljs.core.IndexedSeq(G__45672__a,0,null);
} 
return G__45665__delegate.call(this,conds);};
G__45665.cljs$lang$maxFixedArity = 0;
G__45665.cljs$lang$applyTo = (function (arglist__45673){
var conds = cljs.core.seq(arglist__45673);
return G__45665__delegate(conds);
});
G__45665.cljs$core$IFn$_invoke$arity$variadic = G__45665__delegate;
return G__45665;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() {
var G__45676 = null;
var G__45676__0 = (function (){
return com.rpl.specter.STAY;
});
var G__45676__1 = (function (path){
return path;
});
var G__45676__2 = (function (path1,path2){
var builder__42958__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if((typeof com !== 'undefined') && (typeof com.rpl !== 'undefined') && (typeof com.rpl.specter !== 'undefined') && (typeof com.rpl.specter.t_com$rpl$specter45335 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter45335 = (function (path1,path2,late1,late2,meta45336){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta45336 = meta45336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(com.rpl.specter.t_com$rpl$specter45335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_45337,meta45336__$1){
var self__ = this;
var _45337__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter45335(self__.path1,self__.path2,self__.late1,self__.late2,meta45336__$1));
}));

(com.rpl.specter.t_com$rpl$specter45335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_45337){
var self__ = this;
var _45337__$1 = this;
return self__.meta45336;
}));

(com.rpl.specter.t_com$rpl$specter45335.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL);

(com.rpl.specter.t_com$rpl$specter45335.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = com.rpl.specter.protocols.select_STAR_(self__.late1,vals,structure,next_fn);
if(cljs.core.reduced_QMARK_(res1)){
return res1;
} else {
var res2 = com.rpl.specter.protocols.select_STAR_(self__.late2,vals,structure,next_fn);
if((com.rpl.specter.NONE === res1)){
return res2;
} else {
return res1;
}
}
}));

(com.rpl.specter.t_com$rpl$specter45335.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = com.rpl.specter.protocols.transform_STAR_(self__.late1,vals,structure,next_fn);
return com.rpl.specter.protocols.transform_STAR_(self__.late2,vals,s1,next_fn);
}));

(com.rpl.specter.t_com$rpl$specter45335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"path1","path1",-2002517142,null),new cljs.core.Symbol(null,"path2","path2",-1937913521,null),new cljs.core.Symbol(null,"late1","late1",-1413016621,null),new cljs.core.Symbol(null,"late2","late2",-681717994,null),new cljs.core.Symbol(null,"meta45336","meta45336",262173764,null)], null);
}));

(com.rpl.specter.t_com$rpl$specter45335.cljs$lang$type = true);

(com.rpl.specter.t_com$rpl$specter45335.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter45335");

(com.rpl.specter.t_com$rpl$specter45335.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"com.rpl.specter/t_com$rpl$specter45335");
}));

/**
 * Positional factory function for com.rpl.specter/t_com$rpl$specter45335.
 */
com.rpl.specter.__GT_t_com$rpl$specter45335 = (function com$rpl$specter$__GT_t_com$rpl$specter45335(path1__$1,path2__$1,late1__$1,late2__$1,meta45336){
return (new com.rpl.specter.t_com$rpl$specter45335(path1__$1,path2__$1,late1__$1,late2__$1,meta45336));
});

}

return (new com.rpl.specter.t_com$rpl$specter45335(path1,path2,late1,late2,null));
}));
var curr_params__42959__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__42959__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__42958__auto__,curr_params__42959__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__42958__auto__,curr_params__42959__auto__,null);
}
});
var G__45676__3 = (function() { 
var G__45694__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__45694 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__45700__i = 0, G__45700__a = new Array(arguments.length -  2);
while (G__45700__i < G__45700__a.length) {G__45700__a[G__45700__i] = arguments[G__45700__i + 2]; ++G__45700__i;}
  paths = new cljs.core.IndexedSeq(G__45700__a,0,null);
} 
return G__45694__delegate.call(this,path1,path2,paths);};
G__45694.cljs$lang$maxFixedArity = 2;
G__45694.cljs$lang$applyTo = (function (arglist__45704){
var path1 = cljs.core.first(arglist__45704);
arglist__45704 = cljs.core.next(arglist__45704);
var path2 = cljs.core.first(arglist__45704);
var paths = cljs.core.rest(arglist__45704);
return G__45694__delegate(path1,path2,paths);
});
G__45694.cljs$core$IFn$_invoke$arity$variadic = G__45694__delegate;
return G__45694;
})()
;
G__45676 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__45676__0.call(this);
case 1:
return G__45676__1.call(this,path1);
case 2:
return G__45676__2.call(this,path1,path2);
default:
var G__45707 = null;
if (arguments.length > 2) {
var G__45708__i = 0, G__45708__a = new Array(arguments.length -  2);
while (G__45708__i < G__45708__a.length) {G__45708__a[G__45708__i] = arguments[G__45708__i + 2]; ++G__45708__i;}
G__45707 = new cljs.core.IndexedSeq(G__45708__a,0,null);
}
return G__45676__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__45707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__45676.cljs$lang$maxFixedArity = 2;
G__45676.cljs$lang$applyTo = G__45676__3.cljs$lang$applyTo;
G__45676.cljs$core$IFn$_invoke$arity$0 = G__45676__0;
G__45676.cljs$core$IFn$_invoke$arity$1 = G__45676__1;
G__45676.cljs$core$IFn$_invoke$arity$2 = G__45676__2;
G__45676.cljs$core$IFn$_invoke$arity$variadic = G__45676__3.cljs$core$IFn$_invoke$arity$variadic;
return G__45676;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45710__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__45710 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45711__i = 0, G__45711__a = new Array(arguments.length -  0);
while (G__45711__i < G__45711__a.length) {G__45711__a[G__45711__i] = arguments[G__45711__i + 0]; ++G__45711__i;}
  path = new cljs.core.IndexedSeq(G__45711__a,0,null);
} 
return G__45710__delegate.call(this,path);};
G__45710.cljs$lang$maxFixedArity = 0;
G__45710.cljs$lang$applyTo = (function (arglist__45718){
var path = cljs.core.seq(arglist__45718);
return G__45710__delegate(path);
});
G__45710.cljs$core$IFn$_invoke$arity$variadic = G__45710__delegate;
return G__45710;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45721__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__45721 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45728__i = 0, G__45728__a = new Array(arguments.length -  0);
while (G__45728__i < G__45728__a.length) {G__45728__a[G__45728__i] = arguments[G__45728__i + 0]; ++G__45728__i;}
  path = new cljs.core.IndexedSeq(G__45728__a,0,null);
} 
return G__45721__delegate.call(this,path);};
G__45721.cljs$lang$maxFixedArity = 0;
G__45721.cljs$lang$applyTo = (function (arglist__45729){
var path = cljs.core.seq(arglist__45729);
return G__45721__delegate(path);
});
G__45721.cljs$core$IFn$_invoke$arity$variadic = G__45721__delegate;
return G__45721;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);
/**
 * Navigate the data structure until reaching
 *        a value for which `afn` returns truthy. Has
 *        same semantics as clojure.walk.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__42969__auto__ = com.rpl.specter.pathcache45346;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45347 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.List.EMPTY,new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",new cljs.core.Keyword(null,"file","file",-1269645878),"com/rpl/specter.cljc",new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Keyword(null,"line","line",212345235),1430,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Keyword(null,"test","test",577538877),(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)], null)),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1211,1215,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,680,682,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL,new cljs.core.Var(function(){return com.rpl.specter.ALL;},new cljs.core.Symbol("com.rpl.specter","ALL","com.rpl.specter/ALL",-1409005960,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),"com/rpl/specter.cljc",6,1,715,718,cljs.core.List.EMPTY,"Navigate to every element of the collection. For maps navigates to\n          a vector of `[key value]`.",(cljs.core.truth_(com.rpl.specter.ALL)?com.rpl.specter.ALL.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL","ALL",866837407,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL","ALL",866837407,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache45346 = info45347;

return info45347;
})():info__42969__auto__);
var precompiled45348 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45354 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL,p], null),com.rpl.specter.ALL,p], null);
return (precompiled45348.cljs$core$IFn$_invoke$arity$1 ? precompiled45348.cljs$core$IFn$_invoke$arity$1(G__45354) : precompiled45348.call(null,G__45354));
} else {
return precompiled45348;
}
})());

return p;
}));
/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
var p = com.rpl.specter.impl.local_declarepath();
com.rpl.specter.impl.providepath_STAR_(p,(function (){var info__42969__auto__ = com.rpl.specter.pathcache45356;
var info__42969__auto____$1 = (((info__42969__auto__ == null))?(function (){var info45357 = com.rpl.specter.impl.magic_precompilation(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.cond_path,new cljs.core.Var(function(){return com.rpl.specter.cond_path;},new cljs.core.Symbol("com.rpl.specter","cond-path","com.rpl.specter/cond-path",97137882,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.List.EMPTY,new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes in alternating cond-path path cond-path path...\n   Tests the structure if selecting with cond-path returns anything.\n   If so, it uses the following path for this portion of the navigation.\n   Otherwise, it tries the next cond-path. If nothing matches, then the structure\n   is not selected.",new cljs.core.Keyword(null,"file","file",-1269645878),"com/rpl/specter.cljc",new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Keyword(null,"line","line",212345235),1430,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Keyword(null,"test","test",577538877),(cljs.core.truth_(com.rpl.specter.cond_path)?com.rpl.specter.cond_path.cljs$lang$test:null)], null)),new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null)),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_FnInvocation(com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.pred,new cljs.core.Var(function(){return com.rpl.specter.pred;},new cljs.core.Symbol("com.rpl.specter","pred","com.rpl.specter/pred",1192968523,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"direct-nav","direct-nav",-2100776046),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),"com/rpl/specter.cljc",7,1,true,1211,1215,cljs.core.List.EMPTY,"Keeps the element only if it matches the supplied predicate. Functions in paths\n          implicitly convert to this navigator.",(cljs.core.truth_(com.rpl.specter.pred)?com.rpl.specter.pred.cljs$lang$test:null)])),new cljs.core.Symbol(null,"pred","pred",-727012372,null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_LocalSym(afn,new cljs.core.Symbol(null,"afn","afn",216963467,null))], null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null))),com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.STAY,new cljs.core.Var(function(){return com.rpl.specter.STAY;},new cljs.core.Symbol("com.rpl.specter","STAY","com.rpl.specter/STAY",-176499375,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),"com/rpl/specter.cljc",7,1,680,682,cljs.core.List.EMPTY,"Stays navigated at the current point. Essentially a no-op navigator.",(cljs.core.truth_(com.rpl.specter.STAY)?com.rpl.specter.STAY.cljs$lang$test:null)])),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null)),com.rpl.specter.impl.__GT_VarUse(cljs.core.coll_QMARK_,new cljs.core.Var(function(){return cljs.core.coll_QMARK_;},new cljs.core.Symbol("cljs.core","coll?","cljs.core/coll?",1208130522,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),"cljs/core.cljs",12,1,2133,2133,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),"Returns true if x satisfies ICollection",(cljs.core.truth_(cljs.core.coll_QMARK_)?cljs.core.coll_QMARK_.cljs$lang$test:null)])),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.impl.__GT_VarUse(com.rpl.specter.ALL_WITH_META,new cljs.core.Var(function(){return com.rpl.specter.ALL_WITH_META;},new cljs.core.Symbol("com.rpl.specter","ALL-WITH-META","com.rpl.specter/ALL-WITH-META",-1161868995,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"com.rpl.specter","com.rpl.specter",-2029095616,null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),"com/rpl/specter.cljc",16,1,725,727,cljs.core.List.EMPTY,"Same as ALL, except maintains metadata on the structure.",(cljs.core.truth_(com.rpl.specter.ALL_WITH_META)?com.rpl.specter.ALL_WITH_META.cljs$lang$test:null)])),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null)),com.rpl.specter.impl.__GT_LocalSym(p,new cljs.core.Symbol(null,"p","p",1791580836,null))], null)], null),cljs.core.list(new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),cljs.core.list(new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null)),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null)))], null),"com.rpl.specter",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cond-path","cond-path",-1167797965,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null),new cljs.core.Symbol(null,"afn","afn",216963467,null),new cljs.core.Symbol(null,"STAY","STAY",1628009270,null),new cljs.core.Symbol(null,"coll?","coll?",-1874821441,null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null),new cljs.core.Symbol(null,"ALL-WITH-META","ALL-WITH-META",250401700,null),new cljs.core.Symbol(null,"p","p",1791580836,null)], null));
com.rpl.specter.pathcache45356 = info45357;

return info45357;
})():info__42969__auto__);
var precompiled45358 = com.rpl.specter.impl.cached_path_info_precompiled(info__42969__auto____$1);
var dynamic_QMARK___42970__auto__ = com.rpl.specter.impl.cached_path_info_dynamic_QMARK_(info__42969__auto____$1);
if(cljs.core.truth_(dynamic_QMARK___42970__auto__)){
var G__45363 = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.cond_path,com.rpl.specter.pred,afn,com.rpl.specter.STAY,cljs.core.coll_QMARK_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.rpl.specter.ALL_WITH_META,p], null),com.rpl.specter.ALL_WITH_META,p], null);
return (precompiled45358.cljs$core$IFn$_invoke$arity$1 ? precompiled45358.cljs$core$IFn$_invoke$arity$1(G__45363) : precompiled45358.call(null,G__45363));
} else {
return precompiled45358;
}
})());

return p;
}));
var empty__GT_NONE_45828 = (function (){var G__45364 = cljs.core.empty_QMARK_;
var G__45365 = com.rpl.specter.terminal_val(com.rpl.specter.NONE);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$2(G__45364,G__45365) : com.rpl.specter.if_path.call(null,G__45364,G__45365));
})();
var compact_STAR__45829 = (function (nav){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(nav,empty__GT_NONE_45828) : com.rpl.specter.multi_path.call(null,nav,empty__GT_NONE_45828));
});
/**
 * During transforms, after each step of navigation in subpath check if the
 *  value is empty. If so, remove that value by setting it to NONE.
 */
com.rpl.specter.compact = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(com.rpl.specter.wrap_dynamic_nav((function() { 
var G__45832__delegate = function (path){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(compact_STAR__45829,path);
};
var G__45832 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__45833__i = 0, G__45833__a = new Array(arguments.length -  0);
while (G__45833__i < G__45833__a.length) {G__45833__a[G__45833__i] = arguments[G__45833__i + 0]; ++G__45833__i;}
  path = new cljs.core.IndexedSeq(G__45833__a,0,null);
} 
return G__45832__delegate.call(this,path);};
G__45832.cljs$lang$maxFixedArity = 0;
G__45832.cljs$lang$applyTo = (function (arglist__45834){
var path = cljs.core.seq(arglist__45834);
return G__45832__delegate(path);
});
G__45832.cljs$core$IFn$_invoke$arity$variadic = G__45832__delegate;
return G__45832;
})()
),cljs.core.assoc,new cljs.core.Keyword(null,"dynamicnav","dynamicnav",1267703844),true);

//# sourceMappingURL=com.rpl.specter.js.map
