goog.provide('cljs.core.async');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28326 = arguments.length;
switch (G__28326) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28330 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28330 = (function (f,blockable,meta28331){
this.f = f;
this.blockable = blockable;
this.meta28331 = meta28331;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28330.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28332,meta28331__$1){
var self__ = this;
var _28332__$1 = this;
return (new cljs.core.async.t_cljs$core$async28330(self__.f,self__.blockable,meta28331__$1));
}));

(cljs.core.async.t_cljs$core$async28330.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28332){
var self__ = this;
var _28332__$1 = this;
return self__.meta28331;
}));

(cljs.core.async.t_cljs$core$async28330.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28330.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28330.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async28330.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async28330.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28331","meta28331",275661690,null)], null);
}));

(cljs.core.async.t_cljs$core$async28330.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28330.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28330");

(cljs.core.async.t_cljs$core$async28330.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28330");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28330.
 */
cljs.core.async.__GT_t_cljs$core$async28330 = (function cljs$core$async$__GT_t_cljs$core$async28330(f__$1,blockable__$1,meta28331){
return (new cljs.core.async.t_cljs$core$async28330(f__$1,blockable__$1,meta28331));
});

}

return (new cljs.core.async.t_cljs$core$async28330(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28361 = arguments.length;
switch (G__28361) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28365 = arguments.length;
switch (G__28365) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28373 = arguments.length;
switch (G__28373) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_31203 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31203) : fn1.call(null,val_31203));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_31203) : fn1.call(null,val_31203));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28406 = arguments.length;
switch (G__28406) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___31223 = n;
var x_31224 = (0);
while(true){
if((x_31224 < n__4613__auto___31223)){
(a[x_31224] = x_31224);

var G__31226 = (x_31224 + (1));
x_31224 = G__31226;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28441 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28441 = (function (flag,meta28442){
this.flag = flag;
this.meta28442 = meta28442;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28441.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28443,meta28442__$1){
var self__ = this;
var _28443__$1 = this;
return (new cljs.core.async.t_cljs$core$async28441(self__.flag,meta28442__$1));
}));

(cljs.core.async.t_cljs$core$async28441.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28443){
var self__ = this;
var _28443__$1 = this;
return self__.meta28442;
}));

(cljs.core.async.t_cljs$core$async28441.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28441.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28441.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28441.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async28441.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28442","meta28442",421209000,null)], null);
}));

(cljs.core.async.t_cljs$core$async28441.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28441.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28441");

(cljs.core.async.t_cljs$core$async28441.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28441");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28441.
 */
cljs.core.async.__GT_t_cljs$core$async28441 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28441(flag__$1,meta28442){
return (new cljs.core.async.t_cljs$core$async28441(flag__$1,meta28442));
});

}

return (new cljs.core.async.t_cljs$core$async28441(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28451 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28451 = (function (flag,cb,meta28452){
this.flag = flag;
this.cb = cb;
this.meta28452 = meta28452;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28453,meta28452__$1){
var self__ = this;
var _28453__$1 = this;
return (new cljs.core.async.t_cljs$core$async28451(self__.flag,self__.cb,meta28452__$1));
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28453){
var self__ = this;
var _28453__$1 = this;
return self__.meta28452;
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async28451.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async28451.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28452","meta28452",1010342762,null)], null);
}));

(cljs.core.async.t_cljs$core$async28451.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async28451.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28451");

(cljs.core.async.t_cljs$core$async28451.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async28451");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28451.
 */
cljs.core.async.__GT_t_cljs$core$async28451 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28451(flag__$1,cb__$1,meta28452){
return (new cljs.core.async.t_cljs$core$async28451(flag__$1,cb__$1,meta28452));
});

}

return (new cljs.core.async.t_cljs$core$async28451(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28467_SHARP_){
var G__28469 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28467_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28469) : fret.call(null,G__28469));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28468_SHARP_){
var G__28471 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28468_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__28471) : fret.call(null,G__28471));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31272 = (i + (1));
i = G__31272;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31273 = arguments.length;
var i__4737__auto___31274 = (0);
while(true){
if((i__4737__auto___31274 < len__4736__auto___31273)){
args__4742__auto__.push((arguments[i__4737__auto___31274]));

var G__31275 = (i__4737__auto___31274 + (1));
i__4737__auto___31274 = G__31275;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28481){
var map__28483 = p__28481;
var map__28483__$1 = (((((!((map__28483 == null))))?(((((map__28483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28483.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28483):map__28483);
var opts = map__28483__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28475){
var G__28476 = cljs.core.first(seq28475);
var seq28475__$1 = cljs.core.next(seq28475);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28476,seq28475__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28490 = arguments.length;
switch (G__28490) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28251__auto___31284 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_28543){
var state_val_28544 = (state_28543[(1)]);
if((state_val_28544 === (7))){
var inst_28539 = (state_28543[(2)]);
var state_28543__$1 = state_28543;
var statearr_28545_31288 = state_28543__$1;
(statearr_28545_31288[(2)] = inst_28539);

(statearr_28545_31288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (1))){
var state_28543__$1 = state_28543;
var statearr_28546_31289 = state_28543__$1;
(statearr_28546_31289[(2)] = null);

(statearr_28546_31289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (4))){
var inst_28515 = (state_28543[(7)]);
var inst_28515__$1 = (state_28543[(2)]);
var inst_28516 = (inst_28515__$1 == null);
var state_28543__$1 = (function (){var statearr_28547 = state_28543;
(statearr_28547[(7)] = inst_28515__$1);

return statearr_28547;
})();
if(cljs.core.truth_(inst_28516)){
var statearr_28548_31291 = state_28543__$1;
(statearr_28548_31291[(1)] = (5));

} else {
var statearr_28549_31292 = state_28543__$1;
(statearr_28549_31292[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (13))){
var state_28543__$1 = state_28543;
var statearr_28554_31293 = state_28543__$1;
(statearr_28554_31293[(2)] = null);

(statearr_28554_31293[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (6))){
var inst_28515 = (state_28543[(7)]);
var state_28543__$1 = state_28543;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28543__$1,(11),to,inst_28515);
} else {
if((state_val_28544 === (3))){
var inst_28541 = (state_28543[(2)]);
var state_28543__$1 = state_28543;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28543__$1,inst_28541);
} else {
if((state_val_28544 === (12))){
var state_28543__$1 = state_28543;
var statearr_28561_31298 = state_28543__$1;
(statearr_28561_31298[(2)] = null);

(statearr_28561_31298[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (2))){
var state_28543__$1 = state_28543;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28543__$1,(4),from);
} else {
if((state_val_28544 === (11))){
var inst_28531 = (state_28543[(2)]);
var state_28543__$1 = state_28543;
if(cljs.core.truth_(inst_28531)){
var statearr_28562_31301 = state_28543__$1;
(statearr_28562_31301[(1)] = (12));

} else {
var statearr_28563_31303 = state_28543__$1;
(statearr_28563_31303[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (9))){
var state_28543__$1 = state_28543;
var statearr_28567_31304 = state_28543__$1;
(statearr_28567_31304[(2)] = null);

(statearr_28567_31304[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (5))){
var state_28543__$1 = state_28543;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28568_31305 = state_28543__$1;
(statearr_28568_31305[(1)] = (8));

} else {
var statearr_28569_31306 = state_28543__$1;
(statearr_28569_31306[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (14))){
var inst_28537 = (state_28543[(2)]);
var state_28543__$1 = state_28543;
var statearr_28570_31307 = state_28543__$1;
(statearr_28570_31307[(2)] = inst_28537);

(statearr_28570_31307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (10))){
var inst_28527 = (state_28543[(2)]);
var state_28543__$1 = state_28543;
var statearr_28573_31309 = state_28543__$1;
(statearr_28573_31309[(2)] = inst_28527);

(statearr_28573_31309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28544 === (8))){
var inst_28523 = cljs.core.async.close_BANG_(to);
var state_28543__$1 = state_28543;
var statearr_28575_31310 = state_28543__$1;
(statearr_28575_31310[(2)] = inst_28523);

(statearr_28575_31310[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_28583 = [null,null,null,null,null,null,null,null];
(statearr_28583[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_28583[(1)] = (1));

return statearr_28583;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_28543){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28543);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28584){var ex__28101__auto__ = e28584;
var statearr_28585_31313 = state_28543;
(statearr_28585_31313[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28543[(4)]))){
var statearr_28586_31314 = state_28543;
(statearr_28586_31314[(1)] = cljs.core.first((state_28543[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31315 = state_28543;
state_28543 = G__31315;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_28543){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_28543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_28589 = f__28252__auto__();
(statearr_28589[(6)] = c__28251__auto___31284);

return statearr_28589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__28593){
var vec__28594 = p__28593;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28594,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28594,(1),null);
var job = vec__28594;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28251__auto___31323 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_28604){
var state_val_28605 = (state_28604[(1)]);
if((state_val_28605 === (1))){
var state_28604__$1 = state_28604;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28604__$1,(2),res,v);
} else {
if((state_val_28605 === (2))){
var inst_28601 = (state_28604[(2)]);
var inst_28602 = cljs.core.async.close_BANG_(res);
var state_28604__$1 = (function (){var statearr_28606 = state_28604;
(statearr_28606[(7)] = inst_28601);

return statearr_28606;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28604__$1,inst_28602);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0 = (function (){
var statearr_28607 = [null,null,null,null,null,null,null,null];
(statearr_28607[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__);

(statearr_28607[(1)] = (1));

return statearr_28607;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1 = (function (state_28604){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28604);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28608){var ex__28101__auto__ = e28608;
var statearr_28609_31333 = state_28604;
(statearr_28609_31333[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28604[(4)]))){
var statearr_28610_31337 = state_28604;
(statearr_28610_31337[(1)] = cljs.core.first((state_28604[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31338 = state_28604;
state_28604 = G__31338;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = function(state_28604){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1.call(this,state_28604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_28612 = f__28252__auto__();
(statearr_28612[(6)] = c__28251__auto___31323);

return statearr_28612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__28616){
var vec__28617 = p__28616;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28617,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28617,(1),null);
var job = vec__28617;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___31348 = n;
var __31349 = (0);
while(true){
if((__31349 < n__4613__auto___31348)){
var G__28620_31350 = type;
var G__28620_31351__$1 = (((G__28620_31350 instanceof cljs.core.Keyword))?G__28620_31350.fqn:null);
switch (G__28620_31351__$1) {
case "compute":
var c__28251__auto___31354 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31349,c__28251__auto___31354,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async){
return (function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = ((function (__31349,c__28251__auto___31354,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async){
return (function (state_28636){
var state_val_28637 = (state_28636[(1)]);
if((state_val_28637 === (1))){
var state_28636__$1 = state_28636;
var statearr_28638_31368 = state_28636__$1;
(statearr_28638_31368[(2)] = null);

(statearr_28638_31368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28637 === (2))){
var state_28636__$1 = state_28636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28636__$1,(4),jobs);
} else {
if((state_val_28637 === (3))){
var inst_28634 = (state_28636[(2)]);
var state_28636__$1 = state_28636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28636__$1,inst_28634);
} else {
if((state_val_28637 === (4))){
var inst_28626 = (state_28636[(2)]);
var inst_28627 = process(inst_28626);
var state_28636__$1 = state_28636;
if(cljs.core.truth_(inst_28627)){
var statearr_28641_31378 = state_28636__$1;
(statearr_28641_31378[(1)] = (5));

} else {
var statearr_28642_31386 = state_28636__$1;
(statearr_28642_31386[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28637 === (5))){
var state_28636__$1 = state_28636;
var statearr_28643_31387 = state_28636__$1;
(statearr_28643_31387[(2)] = null);

(statearr_28643_31387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28637 === (6))){
var state_28636__$1 = state_28636;
var statearr_28644_31388 = state_28636__$1;
(statearr_28644_31388[(2)] = null);

(statearr_28644_31388[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28637 === (7))){
var inst_28632 = (state_28636[(2)]);
var state_28636__$1 = state_28636;
var statearr_28651_31392 = state_28636__$1;
(statearr_28651_31392[(2)] = inst_28632);

(statearr_28651_31392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31349,c__28251__auto___31354,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async))
;
return ((function (__31349,switch__28097__auto__,c__28251__auto___31354,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0 = (function (){
var statearr_28652 = [null,null,null,null,null,null,null];
(statearr_28652[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__);

(statearr_28652[(1)] = (1));

return statearr_28652;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1 = (function (state_28636){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28636);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28653){var ex__28101__auto__ = e28653;
var statearr_28654_31396 = state_28636;
(statearr_28654_31396[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28636[(4)]))){
var statearr_28655_31398 = state_28636;
(statearr_28655_31398[(1)] = cljs.core.first((state_28636[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31399 = state_28636;
state_28636 = G__31399;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = function(state_28636){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1.call(this,state_28636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__;
})()
;})(__31349,switch__28097__auto__,c__28251__auto___31354,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async))
})();
var state__28253__auto__ = (function (){var statearr_28656 = f__28252__auto__();
(statearr_28656[(6)] = c__28251__auto___31354);

return statearr_28656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
});})(__31349,c__28251__auto___31354,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async))
);


break;
case "async":
var c__28251__auto___31400 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__31349,c__28251__auto___31400,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async){
return (function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = ((function (__31349,c__28251__auto___31400,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async){
return (function (state_28670){
var state_val_28671 = (state_28670[(1)]);
if((state_val_28671 === (1))){
var state_28670__$1 = state_28670;
var statearr_28672_31402 = state_28670__$1;
(statearr_28672_31402[(2)] = null);

(statearr_28672_31402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28671 === (2))){
var state_28670__$1 = state_28670;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28670__$1,(4),jobs);
} else {
if((state_val_28671 === (3))){
var inst_28668 = (state_28670[(2)]);
var state_28670__$1 = state_28670;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28670__$1,inst_28668);
} else {
if((state_val_28671 === (4))){
var inst_28659 = (state_28670[(2)]);
var inst_28660 = async(inst_28659);
var state_28670__$1 = state_28670;
if(cljs.core.truth_(inst_28660)){
var statearr_28673_31403 = state_28670__$1;
(statearr_28673_31403[(1)] = (5));

} else {
var statearr_28674_31404 = state_28670__$1;
(statearr_28674_31404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28671 === (5))){
var state_28670__$1 = state_28670;
var statearr_28675_31407 = state_28670__$1;
(statearr_28675_31407[(2)] = null);

(statearr_28675_31407[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28671 === (6))){
var state_28670__$1 = state_28670;
var statearr_28676_31409 = state_28670__$1;
(statearr_28676_31409[(2)] = null);

(statearr_28676_31409[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28671 === (7))){
var inst_28666 = (state_28670[(2)]);
var state_28670__$1 = state_28670;
var statearr_28677_31410 = state_28670__$1;
(statearr_28677_31410[(2)] = inst_28666);

(statearr_28677_31410[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__31349,c__28251__auto___31400,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async))
;
return ((function (__31349,switch__28097__auto__,c__28251__auto___31400,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0 = (function (){
var statearr_28678 = [null,null,null,null,null,null,null];
(statearr_28678[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__);

(statearr_28678[(1)] = (1));

return statearr_28678;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1 = (function (state_28670){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28670);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28679){var ex__28101__auto__ = e28679;
var statearr_28680_31413 = state_28670;
(statearr_28680_31413[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28670[(4)]))){
var statearr_28681_31414 = state_28670;
(statearr_28681_31414[(1)] = cljs.core.first((state_28670[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31415 = state_28670;
state_28670 = G__31415;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = function(state_28670){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1.call(this,state_28670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__;
})()
;})(__31349,switch__28097__auto__,c__28251__auto___31400,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async))
})();
var state__28253__auto__ = (function (){var statearr_28684 = f__28252__auto__();
(statearr_28684[(6)] = c__28251__auto___31400);

return statearr_28684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
});})(__31349,c__28251__auto___31400,G__28620_31350,G__28620_31351__$1,n__4613__auto___31348,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28620_31351__$1)].join('')));

}

var G__31419 = (__31349 + (1));
__31349 = G__31419;
continue;
} else {
}
break;
}

var c__28251__auto___31421 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_28707){
var state_val_28708 = (state_28707[(1)]);
if((state_val_28708 === (7))){
var inst_28703 = (state_28707[(2)]);
var state_28707__$1 = state_28707;
var statearr_28709_31424 = state_28707__$1;
(statearr_28709_31424[(2)] = inst_28703);

(statearr_28709_31424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28708 === (1))){
var state_28707__$1 = state_28707;
var statearr_28712_31428 = state_28707__$1;
(statearr_28712_31428[(2)] = null);

(statearr_28712_31428[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28708 === (4))){
var inst_28688 = (state_28707[(7)]);
var inst_28688__$1 = (state_28707[(2)]);
var inst_28689 = (inst_28688__$1 == null);
var state_28707__$1 = (function (){var statearr_28713 = state_28707;
(statearr_28713[(7)] = inst_28688__$1);

return statearr_28713;
})();
if(cljs.core.truth_(inst_28689)){
var statearr_28714_31430 = state_28707__$1;
(statearr_28714_31430[(1)] = (5));

} else {
var statearr_28715_31431 = state_28707__$1;
(statearr_28715_31431[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28708 === (6))){
var inst_28688 = (state_28707[(7)]);
var inst_28693 = (state_28707[(8)]);
var inst_28693__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_28694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28695 = [inst_28688,inst_28693__$1];
var inst_28696 = (new cljs.core.PersistentVector(null,2,(5),inst_28694,inst_28695,null));
var state_28707__$1 = (function (){var statearr_28717 = state_28707;
(statearr_28717[(8)] = inst_28693__$1);

return statearr_28717;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28707__$1,(8),jobs,inst_28696);
} else {
if((state_val_28708 === (3))){
var inst_28705 = (state_28707[(2)]);
var state_28707__$1 = state_28707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28707__$1,inst_28705);
} else {
if((state_val_28708 === (2))){
var state_28707__$1 = state_28707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28707__$1,(4),from);
} else {
if((state_val_28708 === (9))){
var inst_28700 = (state_28707[(2)]);
var state_28707__$1 = (function (){var statearr_28725 = state_28707;
(statearr_28725[(9)] = inst_28700);

return statearr_28725;
})();
var statearr_28728_31441 = state_28707__$1;
(statearr_28728_31441[(2)] = null);

(statearr_28728_31441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28708 === (5))){
var inst_28691 = cljs.core.async.close_BANG_(jobs);
var state_28707__$1 = state_28707;
var statearr_28729_31442 = state_28707__$1;
(statearr_28729_31442[(2)] = inst_28691);

(statearr_28729_31442[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28708 === (8))){
var inst_28693 = (state_28707[(8)]);
var inst_28698 = (state_28707[(2)]);
var state_28707__$1 = (function (){var statearr_28730 = state_28707;
(statearr_28730[(10)] = inst_28698);

return statearr_28730;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28707__$1,(9),results,inst_28693);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0 = (function (){
var statearr_28733 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28733[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__);

(statearr_28733[(1)] = (1));

return statearr_28733;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1 = (function (state_28707){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28707);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28738){var ex__28101__auto__ = e28738;
var statearr_28742_31450 = state_28707;
(statearr_28742_31450[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28707[(4)]))){
var statearr_28743_31453 = state_28707;
(statearr_28743_31453[(1)] = cljs.core.first((state_28707[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31456 = state_28707;
state_28707 = G__31456;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = function(state_28707){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1.call(this,state_28707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_28744 = f__28252__auto__();
(statearr_28744[(6)] = c__28251__auto___31421);

return statearr_28744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


var c__28251__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_28794){
var state_val_28795 = (state_28794[(1)]);
if((state_val_28795 === (7))){
var inst_28790 = (state_28794[(2)]);
var state_28794__$1 = state_28794;
var statearr_28796_31471 = state_28794__$1;
(statearr_28796_31471[(2)] = inst_28790);

(statearr_28796_31471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (20))){
var state_28794__$1 = state_28794;
var statearr_28800_31472 = state_28794__$1;
(statearr_28800_31472[(2)] = null);

(statearr_28800_31472[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (1))){
var state_28794__$1 = state_28794;
var statearr_28802_31473 = state_28794__$1;
(statearr_28802_31473[(2)] = null);

(statearr_28802_31473[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (4))){
var inst_28747 = (state_28794[(7)]);
var inst_28747__$1 = (state_28794[(2)]);
var inst_28748 = (inst_28747__$1 == null);
var state_28794__$1 = (function (){var statearr_28807 = state_28794;
(statearr_28807[(7)] = inst_28747__$1);

return statearr_28807;
})();
if(cljs.core.truth_(inst_28748)){
var statearr_28808_31474 = state_28794__$1;
(statearr_28808_31474[(1)] = (5));

} else {
var statearr_28809_31475 = state_28794__$1;
(statearr_28809_31475[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (15))){
var inst_28761 = (state_28794[(8)]);
var state_28794__$1 = state_28794;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28794__$1,(18),to,inst_28761);
} else {
if((state_val_28795 === (21))){
var inst_28785 = (state_28794[(2)]);
var state_28794__$1 = state_28794;
var statearr_28810_31479 = state_28794__$1;
(statearr_28810_31479[(2)] = inst_28785);

(statearr_28810_31479[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (13))){
var inst_28787 = (state_28794[(2)]);
var state_28794__$1 = (function (){var statearr_28811 = state_28794;
(statearr_28811[(9)] = inst_28787);

return statearr_28811;
})();
var statearr_28812_31480 = state_28794__$1;
(statearr_28812_31480[(2)] = null);

(statearr_28812_31480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (6))){
var inst_28747 = (state_28794[(7)]);
var state_28794__$1 = state_28794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28794__$1,(11),inst_28747);
} else {
if((state_val_28795 === (17))){
var inst_28776 = (state_28794[(2)]);
var state_28794__$1 = state_28794;
if(cljs.core.truth_(inst_28776)){
var statearr_28814_31488 = state_28794__$1;
(statearr_28814_31488[(1)] = (19));

} else {
var statearr_28817_31489 = state_28794__$1;
(statearr_28817_31489[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (3))){
var inst_28792 = (state_28794[(2)]);
var state_28794__$1 = state_28794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28794__$1,inst_28792);
} else {
if((state_val_28795 === (12))){
var inst_28758 = (state_28794[(10)]);
var state_28794__$1 = state_28794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28794__$1,(14),inst_28758);
} else {
if((state_val_28795 === (2))){
var state_28794__$1 = state_28794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28794__$1,(4),results);
} else {
if((state_val_28795 === (19))){
var state_28794__$1 = state_28794;
var statearr_28818_31490 = state_28794__$1;
(statearr_28818_31490[(2)] = null);

(statearr_28818_31490[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (11))){
var inst_28758 = (state_28794[(2)]);
var state_28794__$1 = (function (){var statearr_28819 = state_28794;
(statearr_28819[(10)] = inst_28758);

return statearr_28819;
})();
var statearr_28820_31491 = state_28794__$1;
(statearr_28820_31491[(2)] = null);

(statearr_28820_31491[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (9))){
var state_28794__$1 = state_28794;
var statearr_28822_31492 = state_28794__$1;
(statearr_28822_31492[(2)] = null);

(statearr_28822_31492[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (5))){
var state_28794__$1 = state_28794;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28826_31493 = state_28794__$1;
(statearr_28826_31493[(1)] = (8));

} else {
var statearr_28827_31494 = state_28794__$1;
(statearr_28827_31494[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (14))){
var inst_28761 = (state_28794[(8)]);
var inst_28761__$1 = (state_28794[(2)]);
var inst_28768 = (inst_28761__$1 == null);
var inst_28769 = cljs.core.not(inst_28768);
var state_28794__$1 = (function (){var statearr_28828 = state_28794;
(statearr_28828[(8)] = inst_28761__$1);

return statearr_28828;
})();
if(inst_28769){
var statearr_28829_31496 = state_28794__$1;
(statearr_28829_31496[(1)] = (15));

} else {
var statearr_28830_31497 = state_28794__$1;
(statearr_28830_31497[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (16))){
var state_28794__$1 = state_28794;
var statearr_28831_31498 = state_28794__$1;
(statearr_28831_31498[(2)] = false);

(statearr_28831_31498[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (10))){
var inst_28755 = (state_28794[(2)]);
var state_28794__$1 = state_28794;
var statearr_28833_31505 = state_28794__$1;
(statearr_28833_31505[(2)] = inst_28755);

(statearr_28833_31505[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (18))){
var inst_28773 = (state_28794[(2)]);
var state_28794__$1 = state_28794;
var statearr_28834_31510 = state_28794__$1;
(statearr_28834_31510[(2)] = inst_28773);

(statearr_28834_31510[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28795 === (8))){
var inst_28752 = cljs.core.async.close_BANG_(to);
var state_28794__$1 = state_28794;
var statearr_28835_31513 = state_28794__$1;
(statearr_28835_31513[(2)] = inst_28752);

(statearr_28835_31513[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0 = (function (){
var statearr_28843 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28843[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__);

(statearr_28843[(1)] = (1));

return statearr_28843;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1 = (function (state_28794){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28794);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28844){var ex__28101__auto__ = e28844;
var statearr_28845_31514 = state_28794;
(statearr_28845_31514[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28794[(4)]))){
var statearr_28846_31515 = state_28794;
(statearr_28846_31515[(1)] = cljs.core.first((state_28794[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31517 = state_28794;
state_28794 = G__31517;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__ = function(state_28794){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1.call(this,state_28794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28098__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_28850 = f__28252__auto__();
(statearr_28850[(6)] = c__28251__auto__);

return statearr_28850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));

return c__28251__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28854 = arguments.length;
switch (G__28854) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28861 = arguments.length;
switch (G__28861) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28877 = arguments.length;
switch (G__28877) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28251__auto___31538 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_28903){
var state_val_28904 = (state_28903[(1)]);
if((state_val_28904 === (7))){
var inst_28899 = (state_28903[(2)]);
var state_28903__$1 = state_28903;
var statearr_28913_31539 = state_28903__$1;
(statearr_28913_31539[(2)] = inst_28899);

(statearr_28913_31539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (1))){
var state_28903__$1 = state_28903;
var statearr_28914_31540 = state_28903__$1;
(statearr_28914_31540[(2)] = null);

(statearr_28914_31540[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (4))){
var inst_28880 = (state_28903[(7)]);
var inst_28880__$1 = (state_28903[(2)]);
var inst_28881 = (inst_28880__$1 == null);
var state_28903__$1 = (function (){var statearr_28915 = state_28903;
(statearr_28915[(7)] = inst_28880__$1);

return statearr_28915;
})();
if(cljs.core.truth_(inst_28881)){
var statearr_28917_31546 = state_28903__$1;
(statearr_28917_31546[(1)] = (5));

} else {
var statearr_28918_31547 = state_28903__$1;
(statearr_28918_31547[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (13))){
var state_28903__$1 = state_28903;
var statearr_28919_31548 = state_28903__$1;
(statearr_28919_31548[(2)] = null);

(statearr_28919_31548[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (6))){
var inst_28880 = (state_28903[(7)]);
var inst_28886 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_28880) : p.call(null,inst_28880));
var state_28903__$1 = state_28903;
if(cljs.core.truth_(inst_28886)){
var statearr_28921_31552 = state_28903__$1;
(statearr_28921_31552[(1)] = (9));

} else {
var statearr_28922_31553 = state_28903__$1;
(statearr_28922_31553[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (3))){
var inst_28901 = (state_28903[(2)]);
var state_28903__$1 = state_28903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28903__$1,inst_28901);
} else {
if((state_val_28904 === (12))){
var state_28903__$1 = state_28903;
var statearr_28923_31554 = state_28903__$1;
(statearr_28923_31554[(2)] = null);

(statearr_28923_31554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (2))){
var state_28903__$1 = state_28903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28903__$1,(4),ch);
} else {
if((state_val_28904 === (11))){
var inst_28880 = (state_28903[(7)]);
var inst_28890 = (state_28903[(2)]);
var state_28903__$1 = state_28903;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28903__$1,(8),inst_28890,inst_28880);
} else {
if((state_val_28904 === (9))){
var state_28903__$1 = state_28903;
var statearr_28924_31555 = state_28903__$1;
(statearr_28924_31555[(2)] = tc);

(statearr_28924_31555[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (5))){
var inst_28883 = cljs.core.async.close_BANG_(tc);
var inst_28884 = cljs.core.async.close_BANG_(fc);
var state_28903__$1 = (function (){var statearr_28925 = state_28903;
(statearr_28925[(8)] = inst_28883);

return statearr_28925;
})();
var statearr_28926_31556 = state_28903__$1;
(statearr_28926_31556[(2)] = inst_28884);

(statearr_28926_31556[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (14))){
var inst_28897 = (state_28903[(2)]);
var state_28903__$1 = state_28903;
var statearr_28930_31557 = state_28903__$1;
(statearr_28930_31557[(2)] = inst_28897);

(statearr_28930_31557[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (10))){
var state_28903__$1 = state_28903;
var statearr_28931_31560 = state_28903__$1;
(statearr_28931_31560[(2)] = fc);

(statearr_28931_31560[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28904 === (8))){
var inst_28892 = (state_28903[(2)]);
var state_28903__$1 = state_28903;
if(cljs.core.truth_(inst_28892)){
var statearr_28932_31563 = state_28903__$1;
(statearr_28932_31563[(1)] = (12));

} else {
var statearr_28933_31564 = state_28903__$1;
(statearr_28933_31564[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_28934 = [null,null,null,null,null,null,null,null,null];
(statearr_28934[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_28934[(1)] = (1));

return statearr_28934;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_28903){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28903);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28935){var ex__28101__auto__ = e28935;
var statearr_28936_31565 = state_28903;
(statearr_28936_31565[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28903[(4)]))){
var statearr_28940_31566 = state_28903;
(statearr_28940_31566[(1)] = cljs.core.first((state_28903[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31571 = state_28903;
state_28903 = G__31571;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_28903){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_28903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_28941 = f__28252__auto__();
(statearr_28941[(6)] = c__28251__auto___31538);

return statearr_28941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28251__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_28963){
var state_val_28964 = (state_28963[(1)]);
if((state_val_28964 === (7))){
var inst_28959 = (state_28963[(2)]);
var state_28963__$1 = state_28963;
var statearr_28969_31572 = state_28963__$1;
(statearr_28969_31572[(2)] = inst_28959);

(statearr_28969_31572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28964 === (1))){
var inst_28942 = init;
var inst_28943 = inst_28942;
var state_28963__$1 = (function (){var statearr_28973 = state_28963;
(statearr_28973[(7)] = inst_28943);

return statearr_28973;
})();
var statearr_28974_31574 = state_28963__$1;
(statearr_28974_31574[(2)] = null);

(statearr_28974_31574[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28964 === (4))){
var inst_28946 = (state_28963[(8)]);
var inst_28946__$1 = (state_28963[(2)]);
var inst_28947 = (inst_28946__$1 == null);
var state_28963__$1 = (function (){var statearr_28975 = state_28963;
(statearr_28975[(8)] = inst_28946__$1);

return statearr_28975;
})();
if(cljs.core.truth_(inst_28947)){
var statearr_28976_31575 = state_28963__$1;
(statearr_28976_31575[(1)] = (5));

} else {
var statearr_28977_31576 = state_28963__$1;
(statearr_28977_31576[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28964 === (6))){
var inst_28943 = (state_28963[(7)]);
var inst_28950 = (state_28963[(9)]);
var inst_28946 = (state_28963[(8)]);
var inst_28950__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_28943,inst_28946) : f.call(null,inst_28943,inst_28946));
var inst_28951 = cljs.core.reduced_QMARK_(inst_28950__$1);
var state_28963__$1 = (function (){var statearr_28979 = state_28963;
(statearr_28979[(9)] = inst_28950__$1);

return statearr_28979;
})();
if(inst_28951){
var statearr_28980_31580 = state_28963__$1;
(statearr_28980_31580[(1)] = (8));

} else {
var statearr_28981_31581 = state_28963__$1;
(statearr_28981_31581[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28964 === (3))){
var inst_28961 = (state_28963[(2)]);
var state_28963__$1 = state_28963;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28963__$1,inst_28961);
} else {
if((state_val_28964 === (2))){
var state_28963__$1 = state_28963;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28963__$1,(4),ch);
} else {
if((state_val_28964 === (9))){
var inst_28950 = (state_28963[(9)]);
var inst_28943 = inst_28950;
var state_28963__$1 = (function (){var statearr_28985 = state_28963;
(statearr_28985[(7)] = inst_28943);

return statearr_28985;
})();
var statearr_28986_31582 = state_28963__$1;
(statearr_28986_31582[(2)] = null);

(statearr_28986_31582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28964 === (5))){
var inst_28943 = (state_28963[(7)]);
var state_28963__$1 = state_28963;
var statearr_28987_31583 = state_28963__$1;
(statearr_28987_31583[(2)] = inst_28943);

(statearr_28987_31583[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28964 === (10))){
var inst_28957 = (state_28963[(2)]);
var state_28963__$1 = state_28963;
var statearr_28988_31585 = state_28963__$1;
(statearr_28988_31585[(2)] = inst_28957);

(statearr_28988_31585[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28964 === (8))){
var inst_28950 = (state_28963[(9)]);
var inst_28953 = cljs.core.deref(inst_28950);
var state_28963__$1 = state_28963;
var statearr_28989_31586 = state_28963__$1;
(statearr_28989_31586[(2)] = inst_28953);

(statearr_28989_31586[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28098__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28098__auto____0 = (function (){
var statearr_28990 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28990[(0)] = cljs$core$async$reduce_$_state_machine__28098__auto__);

(statearr_28990[(1)] = (1));

return statearr_28990;
});
var cljs$core$async$reduce_$_state_machine__28098__auto____1 = (function (state_28963){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_28963);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e28991){var ex__28101__auto__ = e28991;
var statearr_28992_31588 = state_28963;
(statearr_28992_31588[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_28963[(4)]))){
var statearr_28993_31589 = state_28963;
(statearr_28993_31589[(1)] = cljs.core.first((state_28963[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31590 = state_28963;
state_28963 = G__31590;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28098__auto__ = function(state_28963){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28098__auto____1.call(this,state_28963);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28098__auto____0;
cljs$core$async$reduce_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28098__auto____1;
return cljs$core$async$reduce_$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_28994 = f__28252__auto__();
(statearr_28994[(6)] = c__28251__auto__);

return statearr_28994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));

return c__28251__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28251__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_29004){
var state_val_29005 = (state_29004[(1)]);
if((state_val_29005 === (1))){
var inst_28999 = cljs.core.async.reduce(f__$1,init,ch);
var state_29004__$1 = state_29004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29004__$1,(2),inst_28999);
} else {
if((state_val_29005 === (2))){
var inst_29001 = (state_29004[(2)]);
var inst_29002 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_29001) : f__$1.call(null,inst_29001));
var state_29004__$1 = state_29004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29004__$1,inst_29002);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28098__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28098__auto____0 = (function (){
var statearr_29009 = [null,null,null,null,null,null,null];
(statearr_29009[(0)] = cljs$core$async$transduce_$_state_machine__28098__auto__);

(statearr_29009[(1)] = (1));

return statearr_29009;
});
var cljs$core$async$transduce_$_state_machine__28098__auto____1 = (function (state_29004){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_29004);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e29010){var ex__28101__auto__ = e29010;
var statearr_29011_31598 = state_29004;
(statearr_29011_31598[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_29004[(4)]))){
var statearr_29012_31599 = state_29004;
(statearr_29012_31599[(1)] = cljs.core.first((state_29004[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31600 = state_29004;
state_29004 = G__31600;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28098__auto__ = function(state_29004){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28098__auto____1.call(this,state_29004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28098__auto____0;
cljs$core$async$transduce_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28098__auto____1;
return cljs$core$async$transduce_$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_29016 = f__28252__auto__();
(statearr_29016[(6)] = c__28251__auto__);

return statearr_29016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));

return c__28251__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__29019 = arguments.length;
switch (G__29019) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28251__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_29044){
var state_val_29045 = (state_29044[(1)]);
if((state_val_29045 === (7))){
var inst_29026 = (state_29044[(2)]);
var state_29044__$1 = state_29044;
var statearr_29053_31615 = state_29044__$1;
(statearr_29053_31615[(2)] = inst_29026);

(statearr_29053_31615[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (1))){
var inst_29020 = cljs.core.seq(coll);
var inst_29021 = inst_29020;
var state_29044__$1 = (function (){var statearr_29054 = state_29044;
(statearr_29054[(7)] = inst_29021);

return statearr_29054;
})();
var statearr_29055_31619 = state_29044__$1;
(statearr_29055_31619[(2)] = null);

(statearr_29055_31619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (4))){
var inst_29021 = (state_29044[(7)]);
var inst_29024 = cljs.core.first(inst_29021);
var state_29044__$1 = state_29044;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29044__$1,(7),ch,inst_29024);
} else {
if((state_val_29045 === (13))){
var inst_29038 = (state_29044[(2)]);
var state_29044__$1 = state_29044;
var statearr_29057_31621 = state_29044__$1;
(statearr_29057_31621[(2)] = inst_29038);

(statearr_29057_31621[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (6))){
var inst_29029 = (state_29044[(2)]);
var state_29044__$1 = state_29044;
if(cljs.core.truth_(inst_29029)){
var statearr_29059_31625 = state_29044__$1;
(statearr_29059_31625[(1)] = (8));

} else {
var statearr_29060_31626 = state_29044__$1;
(statearr_29060_31626[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (3))){
var inst_29042 = (state_29044[(2)]);
var state_29044__$1 = state_29044;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29044__$1,inst_29042);
} else {
if((state_val_29045 === (12))){
var state_29044__$1 = state_29044;
var statearr_29064_31631 = state_29044__$1;
(statearr_29064_31631[(2)] = null);

(statearr_29064_31631[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (2))){
var inst_29021 = (state_29044[(7)]);
var state_29044__$1 = state_29044;
if(cljs.core.truth_(inst_29021)){
var statearr_29065_31632 = state_29044__$1;
(statearr_29065_31632[(1)] = (4));

} else {
var statearr_29066_31633 = state_29044__$1;
(statearr_29066_31633[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (11))){
var inst_29035 = cljs.core.async.close_BANG_(ch);
var state_29044__$1 = state_29044;
var statearr_29067_31634 = state_29044__$1;
(statearr_29067_31634[(2)] = inst_29035);

(statearr_29067_31634[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (9))){
var state_29044__$1 = state_29044;
if(cljs.core.truth_(close_QMARK_)){
var statearr_29068_31635 = state_29044__$1;
(statearr_29068_31635[(1)] = (11));

} else {
var statearr_29069_31636 = state_29044__$1;
(statearr_29069_31636[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (5))){
var inst_29021 = (state_29044[(7)]);
var state_29044__$1 = state_29044;
var statearr_29070_31638 = state_29044__$1;
(statearr_29070_31638[(2)] = inst_29021);

(statearr_29070_31638[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (10))){
var inst_29040 = (state_29044[(2)]);
var state_29044__$1 = state_29044;
var statearr_29071_31640 = state_29044__$1;
(statearr_29071_31640[(2)] = inst_29040);

(statearr_29071_31640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29045 === (8))){
var inst_29021 = (state_29044[(7)]);
var inst_29031 = cljs.core.next(inst_29021);
var inst_29021__$1 = inst_29031;
var state_29044__$1 = (function (){var statearr_29072 = state_29044;
(statearr_29072[(7)] = inst_29021__$1);

return statearr_29072;
})();
var statearr_29073_31644 = state_29044__$1;
(statearr_29073_31644[(2)] = null);

(statearr_29073_31644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_29075 = [null,null,null,null,null,null,null,null];
(statearr_29075[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_29075[(1)] = (1));

return statearr_29075;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_29044){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_29044);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e29076){var ex__28101__auto__ = e29076;
var statearr_29077_31645 = state_29044;
(statearr_29077_31645[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_29044[(4)]))){
var statearr_29078_31646 = state_29044;
(statearr_29078_31646[(1)] = cljs.core.first((state_29044[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31647 = state_29044;
state_29044 = G__31647;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_29044){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_29044);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_29079 = f__28252__auto__();
(statearr_29079[(6)] = c__28251__auto__);

return statearr_29079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));

return c__28251__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__29084 = arguments.length;
switch (G__29084) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_31650 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_31650(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_31651 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_31651(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_31657 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_31657(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_31658 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_31658(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29162 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29162 = (function (ch,cs,meta29163){
this.ch = ch;
this.cs = cs;
this.meta29163 = meta29163;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29164,meta29163__$1){
var self__ = this;
var _29164__$1 = this;
return (new cljs.core.async.t_cljs$core$async29162(self__.ch,self__.cs,meta29163__$1));
}));

(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29164){
var self__ = this;
var _29164__$1 = this;
return self__.meta29163;
}));

(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async29162.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async29162.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta29163","meta29163",-1156052503,null)], null);
}));

(cljs.core.async.t_cljs$core$async29162.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29162.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29162");

(cljs.core.async.t_cljs$core$async29162.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29162");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29162.
 */
cljs.core.async.__GT_t_cljs$core$async29162 = (function cljs$core$async$mult_$___GT_t_cljs$core$async29162(ch__$1,cs__$1,meta29163){
return (new cljs.core.async.t_cljs$core$async29162(ch__$1,cs__$1,meta29163));
});

}

return (new cljs.core.async.t_cljs$core$async29162(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28251__auto___31668 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_29306){
var state_val_29307 = (state_29306[(1)]);
if((state_val_29307 === (7))){
var inst_29299 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29313_31675 = state_29306__$1;
(statearr_29313_31675[(2)] = inst_29299);

(statearr_29313_31675[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (20))){
var inst_29203 = (state_29306[(7)]);
var inst_29216 = cljs.core.first(inst_29203);
var inst_29217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29216,(0),null);
var inst_29218 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29216,(1),null);
var state_29306__$1 = (function (){var statearr_29315 = state_29306;
(statearr_29315[(8)] = inst_29217);

return statearr_29315;
})();
if(cljs.core.truth_(inst_29218)){
var statearr_29316_31679 = state_29306__$1;
(statearr_29316_31679[(1)] = (22));

} else {
var statearr_29317_31686 = state_29306__$1;
(statearr_29317_31686[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (27))){
var inst_29246 = (state_29306[(9)]);
var inst_29248 = (state_29306[(10)]);
var inst_29167 = (state_29306[(11)]);
var inst_29253 = (state_29306[(12)]);
var inst_29253__$1 = cljs.core._nth(inst_29246,inst_29248);
var inst_29254 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29253__$1,inst_29167,done);
var state_29306__$1 = (function (){var statearr_29318 = state_29306;
(statearr_29318[(12)] = inst_29253__$1);

return statearr_29318;
})();
if(cljs.core.truth_(inst_29254)){
var statearr_29319_31688 = state_29306__$1;
(statearr_29319_31688[(1)] = (30));

} else {
var statearr_29322_31689 = state_29306__$1;
(statearr_29322_31689[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (1))){
var state_29306__$1 = state_29306;
var statearr_29325_31690 = state_29306__$1;
(statearr_29325_31690[(2)] = null);

(statearr_29325_31690[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (24))){
var inst_29203 = (state_29306[(7)]);
var inst_29223 = (state_29306[(2)]);
var inst_29224 = cljs.core.next(inst_29203);
var inst_29177 = inst_29224;
var inst_29178 = null;
var inst_29179 = (0);
var inst_29180 = (0);
var state_29306__$1 = (function (){var statearr_29328 = state_29306;
(statearr_29328[(13)] = inst_29223);

(statearr_29328[(14)] = inst_29178);

(statearr_29328[(15)] = inst_29180);

(statearr_29328[(16)] = inst_29177);

(statearr_29328[(17)] = inst_29179);

return statearr_29328;
})();
var statearr_29329_31691 = state_29306__$1;
(statearr_29329_31691[(2)] = null);

(statearr_29329_31691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (39))){
var state_29306__$1 = state_29306;
var statearr_29333_31692 = state_29306__$1;
(statearr_29333_31692[(2)] = null);

(statearr_29333_31692[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (4))){
var inst_29167 = (state_29306[(11)]);
var inst_29167__$1 = (state_29306[(2)]);
var inst_29168 = (inst_29167__$1 == null);
var state_29306__$1 = (function (){var statearr_29338 = state_29306;
(statearr_29338[(11)] = inst_29167__$1);

return statearr_29338;
})();
if(cljs.core.truth_(inst_29168)){
var statearr_29340_31693 = state_29306__$1;
(statearr_29340_31693[(1)] = (5));

} else {
var statearr_29341_31694 = state_29306__$1;
(statearr_29341_31694[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (15))){
var inst_29178 = (state_29306[(14)]);
var inst_29180 = (state_29306[(15)]);
var inst_29177 = (state_29306[(16)]);
var inst_29179 = (state_29306[(17)]);
var inst_29197 = (state_29306[(2)]);
var inst_29198 = (inst_29180 + (1));
var tmp29330 = inst_29178;
var tmp29331 = inst_29177;
var tmp29332 = inst_29179;
var inst_29177__$1 = tmp29331;
var inst_29178__$1 = tmp29330;
var inst_29179__$1 = tmp29332;
var inst_29180__$1 = inst_29198;
var state_29306__$1 = (function (){var statearr_29344 = state_29306;
(statearr_29344[(14)] = inst_29178__$1);

(statearr_29344[(15)] = inst_29180__$1);

(statearr_29344[(16)] = inst_29177__$1);

(statearr_29344[(18)] = inst_29197);

(statearr_29344[(17)] = inst_29179__$1);

return statearr_29344;
})();
var statearr_29352_31701 = state_29306__$1;
(statearr_29352_31701[(2)] = null);

(statearr_29352_31701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (21))){
var inst_29227 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29356_31702 = state_29306__$1;
(statearr_29356_31702[(2)] = inst_29227);

(statearr_29356_31702[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (31))){
var inst_29253 = (state_29306[(12)]);
var inst_29257 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29253);
var state_29306__$1 = state_29306;
var statearr_29361_31703 = state_29306__$1;
(statearr_29361_31703[(2)] = inst_29257);

(statearr_29361_31703[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (32))){
var inst_29246 = (state_29306[(9)]);
var inst_29248 = (state_29306[(10)]);
var inst_29245 = (state_29306[(19)]);
var inst_29247 = (state_29306[(20)]);
var inst_29259 = (state_29306[(2)]);
var inst_29260 = (inst_29248 + (1));
var tmp29353 = inst_29246;
var tmp29354 = inst_29245;
var tmp29355 = inst_29247;
var inst_29245__$1 = tmp29354;
var inst_29246__$1 = tmp29353;
var inst_29247__$1 = tmp29355;
var inst_29248__$1 = inst_29260;
var state_29306__$1 = (function (){var statearr_29371 = state_29306;
(statearr_29371[(9)] = inst_29246__$1);

(statearr_29371[(10)] = inst_29248__$1);

(statearr_29371[(19)] = inst_29245__$1);

(statearr_29371[(20)] = inst_29247__$1);

(statearr_29371[(21)] = inst_29259);

return statearr_29371;
})();
var statearr_29372_31705 = state_29306__$1;
(statearr_29372_31705[(2)] = null);

(statearr_29372_31705[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (40))){
var inst_29272 = (state_29306[(22)]);
var inst_29276 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_29272);
var state_29306__$1 = state_29306;
var statearr_29373_31706 = state_29306__$1;
(statearr_29373_31706[(2)] = inst_29276);

(statearr_29373_31706[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (33))){
var inst_29263 = (state_29306[(23)]);
var inst_29265 = cljs.core.chunked_seq_QMARK_(inst_29263);
var state_29306__$1 = state_29306;
if(inst_29265){
var statearr_29374_31711 = state_29306__$1;
(statearr_29374_31711[(1)] = (36));

} else {
var statearr_29379_31712 = state_29306__$1;
(statearr_29379_31712[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (13))){
var inst_29191 = (state_29306[(24)]);
var inst_29194 = cljs.core.async.close_BANG_(inst_29191);
var state_29306__$1 = state_29306;
var statearr_29386_31714 = state_29306__$1;
(statearr_29386_31714[(2)] = inst_29194);

(statearr_29386_31714[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (22))){
var inst_29217 = (state_29306[(8)]);
var inst_29220 = cljs.core.async.close_BANG_(inst_29217);
var state_29306__$1 = state_29306;
var statearr_29403_31715 = state_29306__$1;
(statearr_29403_31715[(2)] = inst_29220);

(statearr_29403_31715[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (36))){
var inst_29263 = (state_29306[(23)]);
var inst_29267 = cljs.core.chunk_first(inst_29263);
var inst_29268 = cljs.core.chunk_rest(inst_29263);
var inst_29269 = cljs.core.count(inst_29267);
var inst_29245 = inst_29268;
var inst_29246 = inst_29267;
var inst_29247 = inst_29269;
var inst_29248 = (0);
var state_29306__$1 = (function (){var statearr_29405 = state_29306;
(statearr_29405[(9)] = inst_29246);

(statearr_29405[(10)] = inst_29248);

(statearr_29405[(19)] = inst_29245);

(statearr_29405[(20)] = inst_29247);

return statearr_29405;
})();
var statearr_29406_31719 = state_29306__$1;
(statearr_29406_31719[(2)] = null);

(statearr_29406_31719[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (41))){
var inst_29263 = (state_29306[(23)]);
var inst_29278 = (state_29306[(2)]);
var inst_29279 = cljs.core.next(inst_29263);
var inst_29245 = inst_29279;
var inst_29246 = null;
var inst_29247 = (0);
var inst_29248 = (0);
var state_29306__$1 = (function (){var statearr_29407 = state_29306;
(statearr_29407[(9)] = inst_29246);

(statearr_29407[(10)] = inst_29248);

(statearr_29407[(19)] = inst_29245);

(statearr_29407[(20)] = inst_29247);

(statearr_29407[(25)] = inst_29278);

return statearr_29407;
})();
var statearr_29408_31722 = state_29306__$1;
(statearr_29408_31722[(2)] = null);

(statearr_29408_31722[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (43))){
var state_29306__$1 = state_29306;
var statearr_29409_31723 = state_29306__$1;
(statearr_29409_31723[(2)] = null);

(statearr_29409_31723[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (29))){
var inst_29287 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29410_31730 = state_29306__$1;
(statearr_29410_31730[(2)] = inst_29287);

(statearr_29410_31730[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (44))){
var inst_29296 = (state_29306[(2)]);
var state_29306__$1 = (function (){var statearr_29411 = state_29306;
(statearr_29411[(26)] = inst_29296);

return statearr_29411;
})();
var statearr_29412_31731 = state_29306__$1;
(statearr_29412_31731[(2)] = null);

(statearr_29412_31731[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (6))){
var inst_29237 = (state_29306[(27)]);
var inst_29236 = cljs.core.deref(cs);
var inst_29237__$1 = cljs.core.keys(inst_29236);
var inst_29238 = cljs.core.count(inst_29237__$1);
var inst_29239 = cljs.core.reset_BANG_(dctr,inst_29238);
var inst_29244 = cljs.core.seq(inst_29237__$1);
var inst_29245 = inst_29244;
var inst_29246 = null;
var inst_29247 = (0);
var inst_29248 = (0);
var state_29306__$1 = (function (){var statearr_29413 = state_29306;
(statearr_29413[(9)] = inst_29246);

(statearr_29413[(28)] = inst_29239);

(statearr_29413[(10)] = inst_29248);

(statearr_29413[(19)] = inst_29245);

(statearr_29413[(20)] = inst_29247);

(statearr_29413[(27)] = inst_29237__$1);

return statearr_29413;
})();
var statearr_29414_31738 = state_29306__$1;
(statearr_29414_31738[(2)] = null);

(statearr_29414_31738[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (28))){
var inst_29263 = (state_29306[(23)]);
var inst_29245 = (state_29306[(19)]);
var inst_29263__$1 = cljs.core.seq(inst_29245);
var state_29306__$1 = (function (){var statearr_29418 = state_29306;
(statearr_29418[(23)] = inst_29263__$1);

return statearr_29418;
})();
if(inst_29263__$1){
var statearr_29419_31739 = state_29306__$1;
(statearr_29419_31739[(1)] = (33));

} else {
var statearr_29421_31741 = state_29306__$1;
(statearr_29421_31741[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (25))){
var inst_29248 = (state_29306[(10)]);
var inst_29247 = (state_29306[(20)]);
var inst_29250 = (inst_29248 < inst_29247);
var inst_29251 = inst_29250;
var state_29306__$1 = state_29306;
if(cljs.core.truth_(inst_29251)){
var statearr_29423_31749 = state_29306__$1;
(statearr_29423_31749[(1)] = (27));

} else {
var statearr_29424_31750 = state_29306__$1;
(statearr_29424_31750[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (34))){
var state_29306__$1 = state_29306;
var statearr_29428_31751 = state_29306__$1;
(statearr_29428_31751[(2)] = null);

(statearr_29428_31751[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (17))){
var state_29306__$1 = state_29306;
var statearr_29429_31752 = state_29306__$1;
(statearr_29429_31752[(2)] = null);

(statearr_29429_31752[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (3))){
var inst_29301 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29306__$1,inst_29301);
} else {
if((state_val_29307 === (12))){
var inst_29232 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29436_31753 = state_29306__$1;
(statearr_29436_31753[(2)] = inst_29232);

(statearr_29436_31753[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (2))){
var state_29306__$1 = state_29306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29306__$1,(4),ch);
} else {
if((state_val_29307 === (23))){
var state_29306__$1 = state_29306;
var statearr_29443_31754 = state_29306__$1;
(statearr_29443_31754[(2)] = null);

(statearr_29443_31754[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (35))){
var inst_29285 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29444_31755 = state_29306__$1;
(statearr_29444_31755[(2)] = inst_29285);

(statearr_29444_31755[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (19))){
var inst_29203 = (state_29306[(7)]);
var inst_29207 = cljs.core.chunk_first(inst_29203);
var inst_29209 = cljs.core.chunk_rest(inst_29203);
var inst_29210 = cljs.core.count(inst_29207);
var inst_29177 = inst_29209;
var inst_29178 = inst_29207;
var inst_29179 = inst_29210;
var inst_29180 = (0);
var state_29306__$1 = (function (){var statearr_29449 = state_29306;
(statearr_29449[(14)] = inst_29178);

(statearr_29449[(15)] = inst_29180);

(statearr_29449[(16)] = inst_29177);

(statearr_29449[(17)] = inst_29179);

return statearr_29449;
})();
var statearr_29450_31765 = state_29306__$1;
(statearr_29450_31765[(2)] = null);

(statearr_29450_31765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (11))){
var inst_29177 = (state_29306[(16)]);
var inst_29203 = (state_29306[(7)]);
var inst_29203__$1 = cljs.core.seq(inst_29177);
var state_29306__$1 = (function (){var statearr_29451 = state_29306;
(statearr_29451[(7)] = inst_29203__$1);

return statearr_29451;
})();
if(inst_29203__$1){
var statearr_29453_31768 = state_29306__$1;
(statearr_29453_31768[(1)] = (16));

} else {
var statearr_29454_31769 = state_29306__$1;
(statearr_29454_31769[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (9))){
var inst_29234 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29458_31774 = state_29306__$1;
(statearr_29458_31774[(2)] = inst_29234);

(statearr_29458_31774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (5))){
var inst_29174 = cljs.core.deref(cs);
var inst_29175 = cljs.core.seq(inst_29174);
var inst_29177 = inst_29175;
var inst_29178 = null;
var inst_29179 = (0);
var inst_29180 = (0);
var state_29306__$1 = (function (){var statearr_29463 = state_29306;
(statearr_29463[(14)] = inst_29178);

(statearr_29463[(15)] = inst_29180);

(statearr_29463[(16)] = inst_29177);

(statearr_29463[(17)] = inst_29179);

return statearr_29463;
})();
var statearr_29464_31778 = state_29306__$1;
(statearr_29464_31778[(2)] = null);

(statearr_29464_31778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (14))){
var state_29306__$1 = state_29306;
var statearr_29468_31780 = state_29306__$1;
(statearr_29468_31780[(2)] = null);

(statearr_29468_31780[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (45))){
var inst_29293 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29473_31782 = state_29306__$1;
(statearr_29473_31782[(2)] = inst_29293);

(statearr_29473_31782[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (26))){
var inst_29237 = (state_29306[(27)]);
var inst_29289 = (state_29306[(2)]);
var inst_29290 = cljs.core.seq(inst_29237);
var state_29306__$1 = (function (){var statearr_29479 = state_29306;
(statearr_29479[(29)] = inst_29289);

return statearr_29479;
})();
if(inst_29290){
var statearr_29482_31784 = state_29306__$1;
(statearr_29482_31784[(1)] = (42));

} else {
var statearr_29485_31785 = state_29306__$1;
(statearr_29485_31785[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (16))){
var inst_29203 = (state_29306[(7)]);
var inst_29205 = cljs.core.chunked_seq_QMARK_(inst_29203);
var state_29306__$1 = state_29306;
if(inst_29205){
var statearr_29493_31787 = state_29306__$1;
(statearr_29493_31787[(1)] = (19));

} else {
var statearr_29495_31788 = state_29306__$1;
(statearr_29495_31788[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (38))){
var inst_29282 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29503_31789 = state_29306__$1;
(statearr_29503_31789[(2)] = inst_29282);

(statearr_29503_31789[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (30))){
var state_29306__$1 = state_29306;
var statearr_29505_31792 = state_29306__$1;
(statearr_29505_31792[(2)] = null);

(statearr_29505_31792[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (10))){
var inst_29178 = (state_29306[(14)]);
var inst_29180 = (state_29306[(15)]);
var inst_29190 = cljs.core._nth(inst_29178,inst_29180);
var inst_29191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29190,(0),null);
var inst_29192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29190,(1),null);
var state_29306__$1 = (function (){var statearr_29509 = state_29306;
(statearr_29509[(24)] = inst_29191);

return statearr_29509;
})();
if(cljs.core.truth_(inst_29192)){
var statearr_29510_31796 = state_29306__$1;
(statearr_29510_31796[(1)] = (13));

} else {
var statearr_29511_31797 = state_29306__$1;
(statearr_29511_31797[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (18))){
var inst_29230 = (state_29306[(2)]);
var state_29306__$1 = state_29306;
var statearr_29512_31798 = state_29306__$1;
(statearr_29512_31798[(2)] = inst_29230);

(statearr_29512_31798[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (42))){
var state_29306__$1 = state_29306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29306__$1,(45),dchan);
} else {
if((state_val_29307 === (37))){
var inst_29263 = (state_29306[(23)]);
var inst_29272 = (state_29306[(22)]);
var inst_29167 = (state_29306[(11)]);
var inst_29272__$1 = cljs.core.first(inst_29263);
var inst_29273 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_29272__$1,inst_29167,done);
var state_29306__$1 = (function (){var statearr_29518 = state_29306;
(statearr_29518[(22)] = inst_29272__$1);

return statearr_29518;
})();
if(cljs.core.truth_(inst_29273)){
var statearr_29519_31799 = state_29306__$1;
(statearr_29519_31799[(1)] = (39));

} else {
var statearr_29524_31800 = state_29306__$1;
(statearr_29524_31800[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29307 === (8))){
var inst_29180 = (state_29306[(15)]);
var inst_29179 = (state_29306[(17)]);
var inst_29182 = (inst_29180 < inst_29179);
var inst_29183 = inst_29182;
var state_29306__$1 = state_29306;
if(cljs.core.truth_(inst_29183)){
var statearr_29528_31801 = state_29306__$1;
(statearr_29528_31801[(1)] = (10));

} else {
var statearr_29533_31803 = state_29306__$1;
(statearr_29533_31803[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28098__auto__ = null;
var cljs$core$async$mult_$_state_machine__28098__auto____0 = (function (){
var statearr_29540 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29540[(0)] = cljs$core$async$mult_$_state_machine__28098__auto__);

(statearr_29540[(1)] = (1));

return statearr_29540;
});
var cljs$core$async$mult_$_state_machine__28098__auto____1 = (function (state_29306){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_29306);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e29544){var ex__28101__auto__ = e29544;
var statearr_29545_31805 = state_29306;
(statearr_29545_31805[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_29306[(4)]))){
var statearr_29546_31806 = state_29306;
(statearr_29546_31806[(1)] = cljs.core.first((state_29306[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31807 = state_29306;
state_29306 = G__31807;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28098__auto__ = function(state_29306){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28098__auto____1.call(this,state_29306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28098__auto____0;
cljs$core$async$mult_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28098__auto____1;
return cljs$core$async$mult_$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_29552 = f__28252__auto__();
(statearr_29552[(6)] = c__28251__auto___31668);

return statearr_29552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29565 = arguments.length;
switch (G__29565) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_31821 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_31821(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_31823 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_31823(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_31825 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_31825(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_31828 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_31828(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_31830 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_31830(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___31836 = arguments.length;
var i__4737__auto___31837 = (0);
while(true){
if((i__4737__auto___31837 < len__4736__auto___31836)){
args__4742__auto__.push((arguments[i__4737__auto___31837]));

var G__31838 = (i__4737__auto___31837 + (1));
i__4737__auto___31837 = G__31838;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29624){
var map__29625 = p__29624;
var map__29625__$1 = (((((!((map__29625 == null))))?(((((map__29625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29625):map__29625);
var opts = map__29625__$1;
var statearr_29627_31839 = state;
(statearr_29627_31839[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_29628_31844 = state;
(statearr_29628_31844[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_29629_31845 = state;
(statearr_29629_31845[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29620){
var G__29621 = cljs.core.first(seq29620);
var seq29620__$1 = cljs.core.next(seq29620);
var G__29622 = cljs.core.first(seq29620__$1);
var seq29620__$2 = cljs.core.next(seq29620__$1);
var G__29623 = cljs.core.first(seq29620__$2);
var seq29620__$3 = cljs.core.next(seq29620__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29621,G__29622,G__29623,seq29620__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29634 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29634 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29635){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29635 = meta29635;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29636,meta29635__$1){
var self__ = this;
var _29636__$1 = this;
return (new cljs.core.async.t_cljs$core$async29634(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29635__$1));
}));

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29636){
var self__ = this;
var _29636__$1 = this;
return self__.meta29635;
}));

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29634.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async29634.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29635","meta29635",1775334830,null)], null);
}));

(cljs.core.async.t_cljs$core$async29634.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29634.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29634");

(cljs.core.async.t_cljs$core$async29634.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29634");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29634.
 */
cljs.core.async.__GT_t_cljs$core$async29634 = (function cljs$core$async$mix_$___GT_t_cljs$core$async29634(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29635){
return (new cljs.core.async.t_cljs$core$async29634(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29635));
});

}

return (new cljs.core.async.t_cljs$core$async29634(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28251__auto___31902 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_29765){
var state_val_29766 = (state_29765[(1)]);
if((state_val_29766 === (7))){
var inst_29675 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
var statearr_29769_31907 = state_29765__$1;
(statearr_29769_31907[(2)] = inst_29675);

(statearr_29769_31907[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (20))){
var inst_29687 = (state_29765[(7)]);
var state_29765__$1 = state_29765;
var statearr_29770_31913 = state_29765__$1;
(statearr_29770_31913[(2)] = inst_29687);

(statearr_29770_31913[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (27))){
var state_29765__$1 = state_29765;
var statearr_29772_31914 = state_29765__$1;
(statearr_29772_31914[(2)] = null);

(statearr_29772_31914[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (1))){
var inst_29661 = (state_29765[(8)]);
var inst_29661__$1 = calc_state();
var inst_29664 = (inst_29661__$1 == null);
var inst_29665 = cljs.core.not(inst_29664);
var state_29765__$1 = (function (){var statearr_29776 = state_29765;
(statearr_29776[(8)] = inst_29661__$1);

return statearr_29776;
})();
if(inst_29665){
var statearr_29777_31918 = state_29765__$1;
(statearr_29777_31918[(1)] = (2));

} else {
var statearr_29781_31925 = state_29765__$1;
(statearr_29781_31925[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (24))){
var inst_29714 = (state_29765[(9)]);
var inst_29723 = (state_29765[(10)]);
var inst_29739 = (state_29765[(11)]);
var inst_29739__$1 = (inst_29714.cljs$core$IFn$_invoke$arity$1 ? inst_29714.cljs$core$IFn$_invoke$arity$1(inst_29723) : inst_29714.call(null,inst_29723));
var state_29765__$1 = (function (){var statearr_29785 = state_29765;
(statearr_29785[(11)] = inst_29739__$1);

return statearr_29785;
})();
if(cljs.core.truth_(inst_29739__$1)){
var statearr_29786_31928 = state_29765__$1;
(statearr_29786_31928[(1)] = (29));

} else {
var statearr_29787_31929 = state_29765__$1;
(statearr_29787_31929[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (4))){
var inst_29678 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29678)){
var statearr_29788_31930 = state_29765__$1;
(statearr_29788_31930[(1)] = (8));

} else {
var statearr_29789_31931 = state_29765__$1;
(statearr_29789_31931[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (15))){
var inst_29708 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29708)){
var statearr_29790_31939 = state_29765__$1;
(statearr_29790_31939[(1)] = (19));

} else {
var statearr_29791_31940 = state_29765__$1;
(statearr_29791_31940[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (21))){
var inst_29713 = (state_29765[(12)]);
var inst_29713__$1 = (state_29765[(2)]);
var inst_29714 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29713__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29715 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29713__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29716 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29713__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29765__$1 = (function (){var statearr_29792 = state_29765;
(statearr_29792[(9)] = inst_29714);

(statearr_29792[(12)] = inst_29713__$1);

(statearr_29792[(13)] = inst_29715);

return statearr_29792;
})();
return cljs.core.async.ioc_alts_BANG_(state_29765__$1,(22),inst_29716);
} else {
if((state_val_29766 === (31))){
var inst_29747 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29747)){
var statearr_29794_31942 = state_29765__$1;
(statearr_29794_31942[(1)] = (32));

} else {
var statearr_29795_31943 = state_29765__$1;
(statearr_29795_31943[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (32))){
var inst_29722 = (state_29765[(14)]);
var state_29765__$1 = state_29765;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_29765__$1,(35),out,inst_29722);
} else {
if((state_val_29766 === (33))){
var inst_29713 = (state_29765[(12)]);
var inst_29687 = inst_29713;
var state_29765__$1 = (function (){var statearr_29796 = state_29765;
(statearr_29796[(7)] = inst_29687);

return statearr_29796;
})();
var statearr_29797_31944 = state_29765__$1;
(statearr_29797_31944[(2)] = null);

(statearr_29797_31944[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (13))){
var inst_29687 = (state_29765[(7)]);
var inst_29697 = inst_29687.cljs$lang$protocol_mask$partition0$;
var inst_29698 = (inst_29697 & (64));
var inst_29699 = inst_29687.cljs$core$ISeq$;
var inst_29700 = (cljs.core.PROTOCOL_SENTINEL === inst_29699);
var inst_29701 = ((inst_29698) || (inst_29700));
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29701)){
var statearr_29798_31945 = state_29765__$1;
(statearr_29798_31945[(1)] = (16));

} else {
var statearr_29803_31947 = state_29765__$1;
(statearr_29803_31947[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (22))){
var inst_29723 = (state_29765[(10)]);
var inst_29722 = (state_29765[(14)]);
var inst_29721 = (state_29765[(2)]);
var inst_29722__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29721,(0),null);
var inst_29723__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29721,(1),null);
var inst_29724 = (inst_29722__$1 == null);
var inst_29725 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29723__$1,change);
var inst_29726 = ((inst_29724) || (inst_29725));
var state_29765__$1 = (function (){var statearr_29805 = state_29765;
(statearr_29805[(10)] = inst_29723__$1);

(statearr_29805[(14)] = inst_29722__$1);

return statearr_29805;
})();
if(cljs.core.truth_(inst_29726)){
var statearr_29806_31948 = state_29765__$1;
(statearr_29806_31948[(1)] = (23));

} else {
var statearr_29807_31949 = state_29765__$1;
(statearr_29807_31949[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (36))){
var inst_29713 = (state_29765[(12)]);
var inst_29687 = inst_29713;
var state_29765__$1 = (function (){var statearr_29808 = state_29765;
(statearr_29808[(7)] = inst_29687);

return statearr_29808;
})();
var statearr_29809_31950 = state_29765__$1;
(statearr_29809_31950[(2)] = null);

(statearr_29809_31950[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (29))){
var inst_29739 = (state_29765[(11)]);
var state_29765__$1 = state_29765;
var statearr_29810_31953 = state_29765__$1;
(statearr_29810_31953[(2)] = inst_29739);

(statearr_29810_31953[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (6))){
var state_29765__$1 = state_29765;
var statearr_29811_31956 = state_29765__$1;
(statearr_29811_31956[(2)] = false);

(statearr_29811_31956[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (28))){
var inst_29734 = (state_29765[(2)]);
var inst_29735 = calc_state();
var inst_29687 = inst_29735;
var state_29765__$1 = (function (){var statearr_29812 = state_29765;
(statearr_29812[(7)] = inst_29687);

(statearr_29812[(15)] = inst_29734);

return statearr_29812;
})();
var statearr_29813_31957 = state_29765__$1;
(statearr_29813_31957[(2)] = null);

(statearr_29813_31957[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (25))){
var inst_29761 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
var statearr_29814_31958 = state_29765__$1;
(statearr_29814_31958[(2)] = inst_29761);

(statearr_29814_31958[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (34))){
var inst_29759 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
var statearr_29815_31966 = state_29765__$1;
(statearr_29815_31966[(2)] = inst_29759);

(statearr_29815_31966[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (17))){
var state_29765__$1 = state_29765;
var statearr_29820_31967 = state_29765__$1;
(statearr_29820_31967[(2)] = false);

(statearr_29820_31967[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (3))){
var state_29765__$1 = state_29765;
var statearr_29821_31968 = state_29765__$1;
(statearr_29821_31968[(2)] = false);

(statearr_29821_31968[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (12))){
var inst_29763 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29765__$1,inst_29763);
} else {
if((state_val_29766 === (2))){
var inst_29661 = (state_29765[(8)]);
var inst_29667 = inst_29661.cljs$lang$protocol_mask$partition0$;
var inst_29668 = (inst_29667 & (64));
var inst_29669 = inst_29661.cljs$core$ISeq$;
var inst_29670 = (cljs.core.PROTOCOL_SENTINEL === inst_29669);
var inst_29671 = ((inst_29668) || (inst_29670));
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29671)){
var statearr_29823_31972 = state_29765__$1;
(statearr_29823_31972[(1)] = (5));

} else {
var statearr_29824_31977 = state_29765__$1;
(statearr_29824_31977[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (23))){
var inst_29722 = (state_29765[(14)]);
var inst_29729 = (inst_29722 == null);
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29729)){
var statearr_29825_31978 = state_29765__$1;
(statearr_29825_31978[(1)] = (26));

} else {
var statearr_29826_31979 = state_29765__$1;
(statearr_29826_31979[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (35))){
var inst_29750 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
if(cljs.core.truth_(inst_29750)){
var statearr_29827_31992 = state_29765__$1;
(statearr_29827_31992[(1)] = (36));

} else {
var statearr_29828_31993 = state_29765__$1;
(statearr_29828_31993[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (19))){
var inst_29687 = (state_29765[(7)]);
var inst_29710 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29687);
var state_29765__$1 = state_29765;
var statearr_29832_31995 = state_29765__$1;
(statearr_29832_31995[(2)] = inst_29710);

(statearr_29832_31995[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (11))){
var inst_29687 = (state_29765[(7)]);
var inst_29693 = (inst_29687 == null);
var inst_29694 = cljs.core.not(inst_29693);
var state_29765__$1 = state_29765;
if(inst_29694){
var statearr_29833_32001 = state_29765__$1;
(statearr_29833_32001[(1)] = (13));

} else {
var statearr_29834_32003 = state_29765__$1;
(statearr_29834_32003[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (9))){
var inst_29661 = (state_29765[(8)]);
var state_29765__$1 = state_29765;
var statearr_29835_32005 = state_29765__$1;
(statearr_29835_32005[(2)] = inst_29661);

(statearr_29835_32005[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (5))){
var state_29765__$1 = state_29765;
var statearr_29836_32010 = state_29765__$1;
(statearr_29836_32010[(2)] = true);

(statearr_29836_32010[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (14))){
var state_29765__$1 = state_29765;
var statearr_29838_32015 = state_29765__$1;
(statearr_29838_32015[(2)] = false);

(statearr_29838_32015[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (26))){
var inst_29723 = (state_29765[(10)]);
var inst_29731 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_29723);
var state_29765__$1 = state_29765;
var statearr_29840_32017 = state_29765__$1;
(statearr_29840_32017[(2)] = inst_29731);

(statearr_29840_32017[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (16))){
var state_29765__$1 = state_29765;
var statearr_29843_32018 = state_29765__$1;
(statearr_29843_32018[(2)] = true);

(statearr_29843_32018[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (38))){
var inst_29755 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
var statearr_29850_32019 = state_29765__$1;
(statearr_29850_32019[(2)] = inst_29755);

(statearr_29850_32019[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (30))){
var inst_29714 = (state_29765[(9)]);
var inst_29723 = (state_29765[(10)]);
var inst_29715 = (state_29765[(13)]);
var inst_29742 = cljs.core.empty_QMARK_(inst_29714);
var inst_29743 = (inst_29715.cljs$core$IFn$_invoke$arity$1 ? inst_29715.cljs$core$IFn$_invoke$arity$1(inst_29723) : inst_29715.call(null,inst_29723));
var inst_29744 = cljs.core.not(inst_29743);
var inst_29745 = ((inst_29742) && (inst_29744));
var state_29765__$1 = state_29765;
var statearr_29856_32026 = state_29765__$1;
(statearr_29856_32026[(2)] = inst_29745);

(statearr_29856_32026[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (10))){
var inst_29661 = (state_29765[(8)]);
var inst_29683 = (state_29765[(2)]);
var inst_29684 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29683,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29685 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29683,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29686 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29683,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29687 = inst_29661;
var state_29765__$1 = (function (){var statearr_29857 = state_29765;
(statearr_29857[(7)] = inst_29687);

(statearr_29857[(16)] = inst_29684);

(statearr_29857[(17)] = inst_29685);

(statearr_29857[(18)] = inst_29686);

return statearr_29857;
})();
var statearr_29858_32032 = state_29765__$1;
(statearr_29858_32032[(2)] = null);

(statearr_29858_32032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (18))){
var inst_29705 = (state_29765[(2)]);
var state_29765__$1 = state_29765;
var statearr_29859_32033 = state_29765__$1;
(statearr_29859_32033[(2)] = inst_29705);

(statearr_29859_32033[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (37))){
var state_29765__$1 = state_29765;
var statearr_29860_32034 = state_29765__$1;
(statearr_29860_32034[(2)] = null);

(statearr_29860_32034[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29766 === (8))){
var inst_29661 = (state_29765[(8)]);
var inst_29680 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29661);
var state_29765__$1 = state_29765;
var statearr_29861_32035 = state_29765__$1;
(statearr_29861_32035[(2)] = inst_29680);

(statearr_29861_32035[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28098__auto__ = null;
var cljs$core$async$mix_$_state_machine__28098__auto____0 = (function (){
var statearr_29862 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29862[(0)] = cljs$core$async$mix_$_state_machine__28098__auto__);

(statearr_29862[(1)] = (1));

return statearr_29862;
});
var cljs$core$async$mix_$_state_machine__28098__auto____1 = (function (state_29765){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_29765);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e29863){var ex__28101__auto__ = e29863;
var statearr_29864_32041 = state_29765;
(statearr_29864_32041[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_29765[(4)]))){
var statearr_29865_32042 = state_29765;
(statearr_29865_32042[(1)] = cljs.core.first((state_29765[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32043 = state_29765;
state_29765 = G__32043;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28098__auto__ = function(state_29765){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28098__auto____1.call(this,state_29765);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28098__auto____0;
cljs$core$async$mix_$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28098__auto____1;
return cljs$core$async$mix_$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_29866 = f__28252__auto__();
(statearr_29866[(6)] = c__28251__auto___31902);

return statearr_29866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_32046 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_32046(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_32051 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_32051(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_32058 = (function() {
var G__32059 = null;
var G__32059__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__32059__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__32059 = function(p,v){
switch(arguments.length){
case 1:
return G__32059__1.call(this,p);
case 2:
return G__32059__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32059.cljs$core$IFn$_invoke$arity$1 = G__32059__1;
G__32059.cljs$core$IFn$_invoke$arity$2 = G__32059__2;
return G__32059;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29909 = arguments.length;
switch (G__29909) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_32058(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_32058(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29928 = arguments.length;
switch (G__29928) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__29921_SHARP_){
if(cljs.core.truth_((p1__29921_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__29921_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__29921_SHARP_.call(null,topic)))){
return p1__29921_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__29921_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29933 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29933 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29934){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29934 = meta29934;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29935,meta29934__$1){
var self__ = this;
var _29935__$1 = this;
return (new cljs.core.async.t_cljs$core$async29933(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29934__$1));
}));

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29935){
var self__ = this;
var _29935__$1 = this;
return self__.meta29934;
}));

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async29933.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async29933.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29934","meta29934",-301459518,null)], null);
}));

(cljs.core.async.t_cljs$core$async29933.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async29933.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29933");

(cljs.core.async.t_cljs$core$async29933.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async29933");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29933.
 */
cljs.core.async.__GT_t_cljs$core$async29933 = (function cljs$core$async$__GT_t_cljs$core$async29933(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29934){
return (new cljs.core.async.t_cljs$core$async29933(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29934));
});

}

return (new cljs.core.async.t_cljs$core$async29933(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__28251__auto___32086 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_30047){
var state_val_30048 = (state_30047[(1)]);
if((state_val_30048 === (7))){
var inst_30041 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
var statearr_30051_32087 = state_30047__$1;
(statearr_30051_32087[(2)] = inst_30041);

(statearr_30051_32087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (20))){
var state_30047__$1 = state_30047;
var statearr_30052_32088 = state_30047__$1;
(statearr_30052_32088[(2)] = null);

(statearr_30052_32088[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (1))){
var state_30047__$1 = state_30047;
var statearr_30053_32089 = state_30047__$1;
(statearr_30053_32089[(2)] = null);

(statearr_30053_32089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (24))){
var inst_30022 = (state_30047[(7)]);
var inst_30033 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_30022);
var state_30047__$1 = state_30047;
var statearr_30058_32090 = state_30047__$1;
(statearr_30058_32090[(2)] = inst_30033);

(statearr_30058_32090[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (4))){
var inst_29969 = (state_30047[(8)]);
var inst_29969__$1 = (state_30047[(2)]);
var inst_29971 = (inst_29969__$1 == null);
var state_30047__$1 = (function (){var statearr_30061 = state_30047;
(statearr_30061[(8)] = inst_29969__$1);

return statearr_30061;
})();
if(cljs.core.truth_(inst_29971)){
var statearr_30063_32091 = state_30047__$1;
(statearr_30063_32091[(1)] = (5));

} else {
var statearr_30065_32092 = state_30047__$1;
(statearr_30065_32092[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (15))){
var inst_30015 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
var statearr_30066_32093 = state_30047__$1;
(statearr_30066_32093[(2)] = inst_30015);

(statearr_30066_32093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (21))){
var inst_30038 = (state_30047[(2)]);
var state_30047__$1 = (function (){var statearr_30069 = state_30047;
(statearr_30069[(9)] = inst_30038);

return statearr_30069;
})();
var statearr_30070_32098 = state_30047__$1;
(statearr_30070_32098[(2)] = null);

(statearr_30070_32098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (13))){
var inst_29996 = (state_30047[(10)]);
var inst_29998 = cljs.core.chunked_seq_QMARK_(inst_29996);
var state_30047__$1 = state_30047;
if(inst_29998){
var statearr_30072_32103 = state_30047__$1;
(statearr_30072_32103[(1)] = (16));

} else {
var statearr_30073_32104 = state_30047__$1;
(statearr_30073_32104[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (22))){
var inst_30030 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
if(cljs.core.truth_(inst_30030)){
var statearr_30075_32105 = state_30047__$1;
(statearr_30075_32105[(1)] = (23));

} else {
var statearr_30076_32109 = state_30047__$1;
(statearr_30076_32109[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (6))){
var inst_30022 = (state_30047[(7)]);
var inst_29969 = (state_30047[(8)]);
var inst_30024 = (state_30047[(11)]);
var inst_30022__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_29969) : topic_fn.call(null,inst_29969));
var inst_30023 = cljs.core.deref(mults);
var inst_30024__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30023,inst_30022__$1);
var state_30047__$1 = (function (){var statearr_30079 = state_30047;
(statearr_30079[(7)] = inst_30022__$1);

(statearr_30079[(11)] = inst_30024__$1);

return statearr_30079;
})();
if(cljs.core.truth_(inst_30024__$1)){
var statearr_30080_32110 = state_30047__$1;
(statearr_30080_32110[(1)] = (19));

} else {
var statearr_30081_32111 = state_30047__$1;
(statearr_30081_32111[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (25))){
var inst_30035 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
var statearr_30091_32112 = state_30047__$1;
(statearr_30091_32112[(2)] = inst_30035);

(statearr_30091_32112[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (17))){
var inst_29996 = (state_30047[(10)]);
var inst_30006 = cljs.core.first(inst_29996);
var inst_30007 = cljs.core.async.muxch_STAR_(inst_30006);
var inst_30008 = cljs.core.async.close_BANG_(inst_30007);
var inst_30009 = cljs.core.next(inst_29996);
var inst_29981 = inst_30009;
var inst_29982 = null;
var inst_29983 = (0);
var inst_29984 = (0);
var state_30047__$1 = (function (){var statearr_30094 = state_30047;
(statearr_30094[(12)] = inst_29982);

(statearr_30094[(13)] = inst_29981);

(statearr_30094[(14)] = inst_30008);

(statearr_30094[(15)] = inst_29983);

(statearr_30094[(16)] = inst_29984);

return statearr_30094;
})();
var statearr_30100_32113 = state_30047__$1;
(statearr_30100_32113[(2)] = null);

(statearr_30100_32113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (3))){
var inst_30043 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30047__$1,inst_30043);
} else {
if((state_val_30048 === (12))){
var inst_30017 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
var statearr_30103_32114 = state_30047__$1;
(statearr_30103_32114[(2)] = inst_30017);

(statearr_30103_32114[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (2))){
var state_30047__$1 = state_30047;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30047__$1,(4),ch);
} else {
if((state_val_30048 === (23))){
var state_30047__$1 = state_30047;
var statearr_30105_32119 = state_30047__$1;
(statearr_30105_32119[(2)] = null);

(statearr_30105_32119[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (19))){
var inst_29969 = (state_30047[(8)]);
var inst_30024 = (state_30047[(11)]);
var inst_30028 = cljs.core.async.muxch_STAR_(inst_30024);
var state_30047__$1 = state_30047;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30047__$1,(22),inst_30028,inst_29969);
} else {
if((state_val_30048 === (11))){
var inst_29981 = (state_30047[(13)]);
var inst_29996 = (state_30047[(10)]);
var inst_29996__$1 = cljs.core.seq(inst_29981);
var state_30047__$1 = (function (){var statearr_30108 = state_30047;
(statearr_30108[(10)] = inst_29996__$1);

return statearr_30108;
})();
if(inst_29996__$1){
var statearr_30110_32120 = state_30047__$1;
(statearr_30110_32120[(1)] = (13));

} else {
var statearr_30111_32121 = state_30047__$1;
(statearr_30111_32121[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (9))){
var inst_30019 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
var statearr_30114_32122 = state_30047__$1;
(statearr_30114_32122[(2)] = inst_30019);

(statearr_30114_32122[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (5))){
var inst_29978 = cljs.core.deref(mults);
var inst_29979 = cljs.core.vals(inst_29978);
var inst_29980 = cljs.core.seq(inst_29979);
var inst_29981 = inst_29980;
var inst_29982 = null;
var inst_29983 = (0);
var inst_29984 = (0);
var state_30047__$1 = (function (){var statearr_30116 = state_30047;
(statearr_30116[(12)] = inst_29982);

(statearr_30116[(13)] = inst_29981);

(statearr_30116[(15)] = inst_29983);

(statearr_30116[(16)] = inst_29984);

return statearr_30116;
})();
var statearr_30121_32146 = state_30047__$1;
(statearr_30121_32146[(2)] = null);

(statearr_30121_32146[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (14))){
var state_30047__$1 = state_30047;
var statearr_30130_32148 = state_30047__$1;
(statearr_30130_32148[(2)] = null);

(statearr_30130_32148[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (16))){
var inst_29996 = (state_30047[(10)]);
var inst_30000 = cljs.core.chunk_first(inst_29996);
var inst_30001 = cljs.core.chunk_rest(inst_29996);
var inst_30002 = cljs.core.count(inst_30000);
var inst_29981 = inst_30001;
var inst_29982 = inst_30000;
var inst_29983 = inst_30002;
var inst_29984 = (0);
var state_30047__$1 = (function (){var statearr_30131 = state_30047;
(statearr_30131[(12)] = inst_29982);

(statearr_30131[(13)] = inst_29981);

(statearr_30131[(15)] = inst_29983);

(statearr_30131[(16)] = inst_29984);

return statearr_30131;
})();
var statearr_30133_32154 = state_30047__$1;
(statearr_30133_32154[(2)] = null);

(statearr_30133_32154[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (10))){
var inst_29982 = (state_30047[(12)]);
var inst_29981 = (state_30047[(13)]);
var inst_29983 = (state_30047[(15)]);
var inst_29984 = (state_30047[(16)]);
var inst_29990 = cljs.core._nth(inst_29982,inst_29984);
var inst_29991 = cljs.core.async.muxch_STAR_(inst_29990);
var inst_29992 = cljs.core.async.close_BANG_(inst_29991);
var inst_29993 = (inst_29984 + (1));
var tmp30125 = inst_29982;
var tmp30127 = inst_29981;
var tmp30128 = inst_29983;
var inst_29981__$1 = tmp30127;
var inst_29982__$1 = tmp30125;
var inst_29983__$1 = tmp30128;
var inst_29984__$1 = inst_29993;
var state_30047__$1 = (function (){var statearr_30136 = state_30047;
(statearr_30136[(12)] = inst_29982__$1);

(statearr_30136[(17)] = inst_29992);

(statearr_30136[(13)] = inst_29981__$1);

(statearr_30136[(15)] = inst_29983__$1);

(statearr_30136[(16)] = inst_29984__$1);

return statearr_30136;
})();
var statearr_30137_32168 = state_30047__$1;
(statearr_30137_32168[(2)] = null);

(statearr_30137_32168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (18))){
var inst_30012 = (state_30047[(2)]);
var state_30047__$1 = state_30047;
var statearr_30144_32169 = state_30047__$1;
(statearr_30144_32169[(2)] = inst_30012);

(statearr_30144_32169[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30048 === (8))){
var inst_29983 = (state_30047[(15)]);
var inst_29984 = (state_30047[(16)]);
var inst_29986 = (inst_29984 < inst_29983);
var inst_29987 = inst_29986;
var state_30047__$1 = state_30047;
if(cljs.core.truth_(inst_29987)){
var statearr_30145_32180 = state_30047__$1;
(statearr_30145_32180[(1)] = (10));

} else {
var statearr_30147_32184 = state_30047__$1;
(statearr_30147_32184[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_30149 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30149[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_30149[(1)] = (1));

return statearr_30149;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_30047){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_30047);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e30150){var ex__28101__auto__ = e30150;
var statearr_30151_32193 = state_30047;
(statearr_30151_32193[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_30047[(4)]))){
var statearr_30152_32196 = state_30047;
(statearr_30152_32196[(1)] = cljs.core.first((state_30047[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32200 = state_30047;
state_30047 = G__32200;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_30047){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_30047);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_30153 = f__28252__auto__();
(statearr_30153[(6)] = c__28251__auto___32086);

return statearr_30153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__30157 = arguments.length;
switch (G__30157) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__30171 = arguments.length;
switch (G__30171) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__30177 = arguments.length;
switch (G__30177) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__28251__auto___32236 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_30248){
var state_val_30249 = (state_30248[(1)]);
if((state_val_30249 === (7))){
var state_30248__$1 = state_30248;
var statearr_30251_32241 = state_30248__$1;
(statearr_30251_32241[(2)] = null);

(statearr_30251_32241[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (1))){
var state_30248__$1 = state_30248;
var statearr_30252_32246 = state_30248__$1;
(statearr_30252_32246[(2)] = null);

(statearr_30252_32246[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (4))){
var inst_30197 = (state_30248[(7)]);
var inst_30198 = (state_30248[(8)]);
var inst_30200 = (inst_30198 < inst_30197);
var state_30248__$1 = state_30248;
if(cljs.core.truth_(inst_30200)){
var statearr_30258_32254 = state_30248__$1;
(statearr_30258_32254[(1)] = (6));

} else {
var statearr_30259_32255 = state_30248__$1;
(statearr_30259_32255[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (15))){
var inst_30233 = (state_30248[(9)]);
var inst_30239 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_30233);
var state_30248__$1 = state_30248;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30248__$1,(17),out,inst_30239);
} else {
if((state_val_30249 === (13))){
var inst_30233 = (state_30248[(9)]);
var inst_30233__$1 = (state_30248[(2)]);
var inst_30234 = cljs.core.some(cljs.core.nil_QMARK_,inst_30233__$1);
var state_30248__$1 = (function (){var statearr_30260 = state_30248;
(statearr_30260[(9)] = inst_30233__$1);

return statearr_30260;
})();
if(cljs.core.truth_(inst_30234)){
var statearr_30261_32264 = state_30248__$1;
(statearr_30261_32264[(1)] = (14));

} else {
var statearr_30262_32266 = state_30248__$1;
(statearr_30262_32266[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (6))){
var state_30248__$1 = state_30248;
var statearr_30263_32272 = state_30248__$1;
(statearr_30263_32272[(2)] = null);

(statearr_30263_32272[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (17))){
var inst_30241 = (state_30248[(2)]);
var state_30248__$1 = (function (){var statearr_30273 = state_30248;
(statearr_30273[(10)] = inst_30241);

return statearr_30273;
})();
var statearr_30274_32285 = state_30248__$1;
(statearr_30274_32285[(2)] = null);

(statearr_30274_32285[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (3))){
var inst_30246 = (state_30248[(2)]);
var state_30248__$1 = state_30248;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30248__$1,inst_30246);
} else {
if((state_val_30249 === (12))){
var _ = (function (){var statearr_30275 = state_30248;
(statearr_30275[(4)] = cljs.core.rest((state_30248[(4)])));

return statearr_30275;
})();
var state_30248__$1 = state_30248;
var ex30272 = (state_30248__$1[(2)]);
var statearr_30278_32290 = state_30248__$1;
(statearr_30278_32290[(5)] = ex30272);


if((ex30272 instanceof Object)){
var statearr_30279_32291 = state_30248__$1;
(statearr_30279_32291[(1)] = (11));

(statearr_30279_32291[(5)] = null);

} else {
throw ex30272;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (2))){
var inst_30196 = cljs.core.reset_BANG_(dctr,cnt);
var inst_30197 = cnt;
var inst_30198 = (0);
var state_30248__$1 = (function (){var statearr_30285 = state_30248;
(statearr_30285[(7)] = inst_30197);

(statearr_30285[(8)] = inst_30198);

(statearr_30285[(11)] = inst_30196);

return statearr_30285;
})();
var statearr_30288_32293 = state_30248__$1;
(statearr_30288_32293[(2)] = null);

(statearr_30288_32293[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (11))){
var inst_30206 = (state_30248[(2)]);
var inst_30207 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_30248__$1 = (function (){var statearr_30290 = state_30248;
(statearr_30290[(12)] = inst_30206);

return statearr_30290;
})();
var statearr_30291_32297 = state_30248__$1;
(statearr_30291_32297[(2)] = inst_30207);

(statearr_30291_32297[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (9))){
var inst_30198 = (state_30248[(8)]);
var _ = (function (){var statearr_30292 = state_30248;
(statearr_30292[(4)] = cljs.core.cons((12),(state_30248[(4)])));

return statearr_30292;
})();
var inst_30215 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_30198) : chs__$1.call(null,inst_30198));
var inst_30216 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_30198) : done.call(null,inst_30198));
var inst_30217 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_30215,inst_30216);
var ___$1 = (function (){var statearr_30293 = state_30248;
(statearr_30293[(4)] = cljs.core.rest((state_30248[(4)])));

return statearr_30293;
})();
var state_30248__$1 = state_30248;
var statearr_30294_32298 = state_30248__$1;
(statearr_30294_32298[(2)] = inst_30217);

(statearr_30294_32298[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (5))){
var inst_30228 = (state_30248[(2)]);
var state_30248__$1 = (function (){var statearr_30295 = state_30248;
(statearr_30295[(13)] = inst_30228);

return statearr_30295;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30248__$1,(13),dchan);
} else {
if((state_val_30249 === (14))){
var inst_30237 = cljs.core.async.close_BANG_(out);
var state_30248__$1 = state_30248;
var statearr_30296_32309 = state_30248__$1;
(statearr_30296_32309[(2)] = inst_30237);

(statearr_30296_32309[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (16))){
var inst_30244 = (state_30248[(2)]);
var state_30248__$1 = state_30248;
var statearr_30298_32315 = state_30248__$1;
(statearr_30298_32315[(2)] = inst_30244);

(statearr_30298_32315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (10))){
var inst_30198 = (state_30248[(8)]);
var inst_30220 = (state_30248[(2)]);
var inst_30222 = (inst_30198 + (1));
var inst_30198__$1 = inst_30222;
var state_30248__$1 = (function (){var statearr_30299 = state_30248;
(statearr_30299[(8)] = inst_30198__$1);

(statearr_30299[(14)] = inst_30220);

return statearr_30299;
})();
var statearr_30300_32328 = state_30248__$1;
(statearr_30300_32328[(2)] = null);

(statearr_30300_32328[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30249 === (8))){
var inst_30226 = (state_30248[(2)]);
var state_30248__$1 = state_30248;
var statearr_30301_32330 = state_30248__$1;
(statearr_30301_32330[(2)] = inst_30226);

(statearr_30301_32330[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_30302 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30302[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_30302[(1)] = (1));

return statearr_30302;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_30248){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_30248);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e30303){var ex__28101__auto__ = e30303;
var statearr_30304_32363 = state_30248;
(statearr_30304_32363[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_30248[(4)]))){
var statearr_30305_32364 = state_30248;
(statearr_30305_32364[(1)] = cljs.core.first((state_30248[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32365 = state_30248;
state_30248 = G__32365;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_30248){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_30248);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_30307 = f__28252__auto__();
(statearr_30307[(6)] = c__28251__auto___32236);

return statearr_30307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__30315 = arguments.length;
switch (G__30315) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28251__auto___32388 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_30357){
var state_val_30358 = (state_30357[(1)]);
if((state_val_30358 === (7))){
var inst_30332 = (state_30357[(7)]);
var inst_30331 = (state_30357[(8)]);
var inst_30331__$1 = (state_30357[(2)]);
var inst_30332__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30331__$1,(0),null);
var inst_30333 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30331__$1,(1),null);
var inst_30334 = (inst_30332__$1 == null);
var state_30357__$1 = (function (){var statearr_30362 = state_30357;
(statearr_30362[(9)] = inst_30333);

(statearr_30362[(7)] = inst_30332__$1);

(statearr_30362[(8)] = inst_30331__$1);

return statearr_30362;
})();
if(cljs.core.truth_(inst_30334)){
var statearr_30363_32409 = state_30357__$1;
(statearr_30363_32409[(1)] = (8));

} else {
var statearr_30367_32410 = state_30357__$1;
(statearr_30367_32410[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30358 === (1))){
var inst_30321 = cljs.core.vec(chs);
var inst_30322 = inst_30321;
var state_30357__$1 = (function (){var statearr_30368 = state_30357;
(statearr_30368[(10)] = inst_30322);

return statearr_30368;
})();
var statearr_30369_32419 = state_30357__$1;
(statearr_30369_32419[(2)] = null);

(statearr_30369_32419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30358 === (4))){
var inst_30322 = (state_30357[(10)]);
var state_30357__$1 = state_30357;
return cljs.core.async.ioc_alts_BANG_(state_30357__$1,(7),inst_30322);
} else {
if((state_val_30358 === (6))){
var inst_30348 = (state_30357[(2)]);
var state_30357__$1 = state_30357;
var statearr_30374_32430 = state_30357__$1;
(statearr_30374_32430[(2)] = inst_30348);

(statearr_30374_32430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30358 === (3))){
var inst_30350 = (state_30357[(2)]);
var state_30357__$1 = state_30357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30357__$1,inst_30350);
} else {
if((state_val_30358 === (2))){
var inst_30322 = (state_30357[(10)]);
var inst_30324 = cljs.core.count(inst_30322);
var inst_30325 = (inst_30324 > (0));
var state_30357__$1 = state_30357;
if(cljs.core.truth_(inst_30325)){
var statearr_30378_32451 = state_30357__$1;
(statearr_30378_32451[(1)] = (4));

} else {
var statearr_30380_32453 = state_30357__$1;
(statearr_30380_32453[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30358 === (11))){
var inst_30322 = (state_30357[(10)]);
var inst_30341 = (state_30357[(2)]);
var tmp30376 = inst_30322;
var inst_30322__$1 = tmp30376;
var state_30357__$1 = (function (){var statearr_30386 = state_30357;
(statearr_30386[(10)] = inst_30322__$1);

(statearr_30386[(11)] = inst_30341);

return statearr_30386;
})();
var statearr_30387_32464 = state_30357__$1;
(statearr_30387_32464[(2)] = null);

(statearr_30387_32464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30358 === (9))){
var inst_30332 = (state_30357[(7)]);
var state_30357__$1 = state_30357;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30357__$1,(11),out,inst_30332);
} else {
if((state_val_30358 === (5))){
var inst_30346 = cljs.core.async.close_BANG_(out);
var state_30357__$1 = state_30357;
var statearr_30396_32469 = state_30357__$1;
(statearr_30396_32469[(2)] = inst_30346);

(statearr_30396_32469[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30358 === (10))){
var inst_30344 = (state_30357[(2)]);
var state_30357__$1 = state_30357;
var statearr_30397_32470 = state_30357__$1;
(statearr_30397_32470[(2)] = inst_30344);

(statearr_30397_32470[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30358 === (8))){
var inst_30322 = (state_30357[(10)]);
var inst_30333 = (state_30357[(9)]);
var inst_30332 = (state_30357[(7)]);
var inst_30331 = (state_30357[(8)]);
var inst_30336 = (function (){var cs = inst_30322;
var vec__30327 = inst_30331;
var v = inst_30332;
var c = inst_30333;
return (function (p1__30312_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__30312_SHARP_);
});
})();
var inst_30337 = cljs.core.filterv(inst_30336,inst_30322);
var inst_30322__$1 = inst_30337;
var state_30357__$1 = (function (){var statearr_30404 = state_30357;
(statearr_30404[(10)] = inst_30322__$1);

return statearr_30404;
})();
var statearr_30405_32483 = state_30357__$1;
(statearr_30405_32483[(2)] = null);

(statearr_30405_32483[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_30408 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30408[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_30408[(1)] = (1));

return statearr_30408;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_30357){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_30357);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e30409){var ex__28101__auto__ = e30409;
var statearr_30410_32498 = state_30357;
(statearr_30410_32498[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_30357[(4)]))){
var statearr_30411_32502 = state_30357;
(statearr_30411_32502[(1)] = cljs.core.first((state_30357[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32515 = state_30357;
state_30357 = G__32515;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_30357){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_30357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_30412 = f__28252__auto__();
(statearr_30412[(6)] = c__28251__auto___32388);

return statearr_30412;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__30415 = arguments.length;
switch (G__30415) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28251__auto___32526 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_30443){
var state_val_30444 = (state_30443[(1)]);
if((state_val_30444 === (7))){
var inst_30423 = (state_30443[(7)]);
var inst_30423__$1 = (state_30443[(2)]);
var inst_30424 = (inst_30423__$1 == null);
var inst_30425 = cljs.core.not(inst_30424);
var state_30443__$1 = (function (){var statearr_30445 = state_30443;
(statearr_30445[(7)] = inst_30423__$1);

return statearr_30445;
})();
if(inst_30425){
var statearr_30446_32541 = state_30443__$1;
(statearr_30446_32541[(1)] = (8));

} else {
var statearr_30447_32543 = state_30443__$1;
(statearr_30447_32543[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (1))){
var inst_30417 = (0);
var state_30443__$1 = (function (){var statearr_30448 = state_30443;
(statearr_30448[(8)] = inst_30417);

return statearr_30448;
})();
var statearr_30449_32544 = state_30443__$1;
(statearr_30449_32544[(2)] = null);

(statearr_30449_32544[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (4))){
var state_30443__$1 = state_30443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30443__$1,(7),ch);
} else {
if((state_val_30444 === (6))){
var inst_30436 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
var statearr_30451_32552 = state_30443__$1;
(statearr_30451_32552[(2)] = inst_30436);

(statearr_30451_32552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (3))){
var inst_30438 = (state_30443[(2)]);
var inst_30439 = cljs.core.async.close_BANG_(out);
var state_30443__$1 = (function (){var statearr_30453 = state_30443;
(statearr_30453[(9)] = inst_30438);

return statearr_30453;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30443__$1,inst_30439);
} else {
if((state_val_30444 === (2))){
var inst_30417 = (state_30443[(8)]);
var inst_30420 = (inst_30417 < n);
var state_30443__$1 = state_30443;
if(cljs.core.truth_(inst_30420)){
var statearr_30454_32557 = state_30443__$1;
(statearr_30454_32557[(1)] = (4));

} else {
var statearr_30455_32565 = state_30443__$1;
(statearr_30455_32565[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (11))){
var inst_30417 = (state_30443[(8)]);
var inst_30428 = (state_30443[(2)]);
var inst_30429 = (inst_30417 + (1));
var inst_30417__$1 = inst_30429;
var state_30443__$1 = (function (){var statearr_30456 = state_30443;
(statearr_30456[(10)] = inst_30428);

(statearr_30456[(8)] = inst_30417__$1);

return statearr_30456;
})();
var statearr_30457_32617 = state_30443__$1;
(statearr_30457_32617[(2)] = null);

(statearr_30457_32617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (9))){
var state_30443__$1 = state_30443;
var statearr_30458_32624 = state_30443__$1;
(statearr_30458_32624[(2)] = null);

(statearr_30458_32624[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (5))){
var state_30443__$1 = state_30443;
var statearr_30459_32630 = state_30443__$1;
(statearr_30459_32630[(2)] = null);

(statearr_30459_32630[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (10))){
var inst_30433 = (state_30443[(2)]);
var state_30443__$1 = state_30443;
var statearr_30460_32643 = state_30443__$1;
(statearr_30460_32643[(2)] = inst_30433);

(statearr_30460_32643[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30444 === (8))){
var inst_30423 = (state_30443[(7)]);
var state_30443__$1 = state_30443;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30443__$1,(11),out,inst_30423);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_30464 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30464[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_30464[(1)] = (1));

return statearr_30464;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_30443){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_30443);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e30466){var ex__28101__auto__ = e30466;
var statearr_30469_32664 = state_30443;
(statearr_30469_32664[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_30443[(4)]))){
var statearr_30470_32671 = state_30443;
(statearr_30470_32671[(1)] = cljs.core.first((state_30443[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32680 = state_30443;
state_30443 = G__32680;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_30443){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_30443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_30475 = f__28252__auto__();
(statearr_30475[(6)] = c__28251__auto___32526);

return statearr_30475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30480 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30480 = (function (f,ch,meta30481){
this.f = f;
this.ch = ch;
this.meta30481 = meta30481;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30482,meta30481__$1){
var self__ = this;
var _30482__$1 = this;
return (new cljs.core.async.t_cljs$core$async30480(self__.f,self__.ch,meta30481__$1));
}));

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30482){
var self__ = this;
var _30482__$1 = this;
return self__.meta30481;
}));

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30491 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30491 = (function (f,ch,meta30481,_,fn1,meta30492){
this.f = f;
this.ch = ch;
this.meta30481 = meta30481;
this._ = _;
this.fn1 = fn1;
this.meta30492 = meta30492;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30493,meta30492__$1){
var self__ = this;
var _30493__$1 = this;
return (new cljs.core.async.t_cljs$core$async30491(self__.f,self__.ch,self__.meta30481,self__._,self__.fn1,meta30492__$1));
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30493){
var self__ = this;
var _30493__$1 = this;
return self__.meta30492;
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30491.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__30479_SHARP_){
var G__30500 = (((p1__30479_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__30479_SHARP_) : self__.f.call(null,p1__30479_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__30500) : f1.call(null,G__30500));
});
}));

(cljs.core.async.t_cljs$core$async30491.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30481","meta30481",1260481345,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async30480","cljs.core.async/t_cljs$core$async30480",-654087070,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta30492","meta30492",-750744378,null)], null);
}));

(cljs.core.async.t_cljs$core$async30491.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30491.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30491");

(cljs.core.async.t_cljs$core$async30491.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30491");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30491.
 */
cljs.core.async.__GT_t_cljs$core$async30491 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30491(f__$1,ch__$1,meta30481__$1,___$2,fn1__$1,meta30492){
return (new cljs.core.async.t_cljs$core$async30491(f__$1,ch__$1,meta30481__$1,___$2,fn1__$1,meta30492));
});

}

return (new cljs.core.async.t_cljs$core$async30491(self__.f,self__.ch,self__.meta30481,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__30509 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__30509) : self__.f.call(null,G__30509));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30480.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async30480.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30481","meta30481",1260481345,null)], null);
}));

(cljs.core.async.t_cljs$core$async30480.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30480.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30480");

(cljs.core.async.t_cljs$core$async30480.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30480");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30480.
 */
cljs.core.async.__GT_t_cljs$core$async30480 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async30480(f__$1,ch__$1,meta30481){
return (new cljs.core.async.t_cljs$core$async30480(f__$1,ch__$1,meta30481));
});

}

return (new cljs.core.async.t_cljs$core$async30480(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30528 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30528 = (function (f,ch,meta30529){
this.f = f;
this.ch = ch;
this.meta30529 = meta30529;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30530,meta30529__$1){
var self__ = this;
var _30530__$1 = this;
return (new cljs.core.async.t_cljs$core$async30528(self__.f,self__.ch,meta30529__$1));
}));

(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30530){
var self__ = this;
var _30530__$1 = this;
return self__.meta30529;
}));

(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30528.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async30528.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30529","meta30529",162746633,null)], null);
}));

(cljs.core.async.t_cljs$core$async30528.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30528.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30528");

(cljs.core.async.t_cljs$core$async30528.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30528");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30528.
 */
cljs.core.async.__GT_t_cljs$core$async30528 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async30528(f__$1,ch__$1,meta30529){
return (new cljs.core.async.t_cljs$core$async30528(f__$1,ch__$1,meta30529));
});

}

return (new cljs.core.async.t_cljs$core$async30528(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async30557 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30557 = (function (p,ch,meta30558){
this.p = p;
this.ch = ch;
this.meta30558 = meta30558;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30559,meta30558__$1){
var self__ = this;
var _30559__$1 = this;
return (new cljs.core.async.t_cljs$core$async30557(self__.p,self__.ch,meta30558__$1));
}));

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30559){
var self__ = this;
var _30559__$1 = this;
return self__.meta30558;
}));

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30557.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async30557.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta30558","meta30558",31964841,null)], null);
}));

(cljs.core.async.t_cljs$core$async30557.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30557.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30557");

(cljs.core.async.t_cljs$core$async30557.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async30557");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30557.
 */
cljs.core.async.__GT_t_cljs$core$async30557 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async30557(p__$1,ch__$1,meta30558){
return (new cljs.core.async.t_cljs$core$async30557(p__$1,ch__$1,meta30558));
});

}

return (new cljs.core.async.t_cljs$core$async30557(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__30589 = arguments.length;
switch (G__30589) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28251__auto___32788 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_30614){
var state_val_30615 = (state_30614[(1)]);
if((state_val_30615 === (7))){
var inst_30610 = (state_30614[(2)]);
var state_30614__$1 = state_30614;
var statearr_30621_32791 = state_30614__$1;
(statearr_30621_32791[(2)] = inst_30610);

(statearr_30621_32791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (1))){
var state_30614__$1 = state_30614;
var statearr_30622_32792 = state_30614__$1;
(statearr_30622_32792[(2)] = null);

(statearr_30622_32792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (4))){
var inst_30593 = (state_30614[(7)]);
var inst_30593__$1 = (state_30614[(2)]);
var inst_30594 = (inst_30593__$1 == null);
var state_30614__$1 = (function (){var statearr_30625 = state_30614;
(statearr_30625[(7)] = inst_30593__$1);

return statearr_30625;
})();
if(cljs.core.truth_(inst_30594)){
var statearr_30627_32794 = state_30614__$1;
(statearr_30627_32794[(1)] = (5));

} else {
var statearr_30628_32796 = state_30614__$1;
(statearr_30628_32796[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (6))){
var inst_30593 = (state_30614[(7)]);
var inst_30598 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30593) : p.call(null,inst_30593));
var state_30614__$1 = state_30614;
if(cljs.core.truth_(inst_30598)){
var statearr_30629_32799 = state_30614__$1;
(statearr_30629_32799[(1)] = (8));

} else {
var statearr_30630_32800 = state_30614__$1;
(statearr_30630_32800[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (3))){
var inst_30612 = (state_30614[(2)]);
var state_30614__$1 = state_30614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30614__$1,inst_30612);
} else {
if((state_val_30615 === (2))){
var state_30614__$1 = state_30614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30614__$1,(4),ch);
} else {
if((state_val_30615 === (11))){
var inst_30602 = (state_30614[(2)]);
var state_30614__$1 = state_30614;
var statearr_30636_32808 = state_30614__$1;
(statearr_30636_32808[(2)] = inst_30602);

(statearr_30636_32808[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (9))){
var state_30614__$1 = state_30614;
var statearr_30637_32809 = state_30614__$1;
(statearr_30637_32809[(2)] = null);

(statearr_30637_32809[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (5))){
var inst_30596 = cljs.core.async.close_BANG_(out);
var state_30614__$1 = state_30614;
var statearr_30639_32818 = state_30614__$1;
(statearr_30639_32818[(2)] = inst_30596);

(statearr_30639_32818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (10))){
var inst_30607 = (state_30614[(2)]);
var state_30614__$1 = (function (){var statearr_30644 = state_30614;
(statearr_30644[(8)] = inst_30607);

return statearr_30644;
})();
var statearr_30645_32819 = state_30614__$1;
(statearr_30645_32819[(2)] = null);

(statearr_30645_32819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30615 === (8))){
var inst_30593 = (state_30614[(7)]);
var state_30614__$1 = state_30614;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30614__$1,(11),out,inst_30593);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_30647 = [null,null,null,null,null,null,null,null,null];
(statearr_30647[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_30647[(1)] = (1));

return statearr_30647;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_30614){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_30614);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e30648){var ex__28101__auto__ = e30648;
var statearr_30649_32822 = state_30614;
(statearr_30649_32822[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_30614[(4)]))){
var statearr_30650_32823 = state_30614;
(statearr_30650_32823[(1)] = cljs.core.first((state_30614[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32824 = state_30614;
state_30614 = G__32824;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_30614){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_30614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_30656 = f__28252__auto__();
(statearr_30656[(6)] = c__28251__auto___32788);

return statearr_30656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__30669 = arguments.length;
switch (G__30669) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28251__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_30747){
var state_val_30748 = (state_30747[(1)]);
if((state_val_30748 === (7))){
var inst_30743 = (state_30747[(2)]);
var state_30747__$1 = state_30747;
var statearr_30755_32843 = state_30747__$1;
(statearr_30755_32843[(2)] = inst_30743);

(statearr_30755_32843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (20))){
var inst_30711 = (state_30747[(7)]);
var inst_30724 = (state_30747[(2)]);
var inst_30725 = cljs.core.next(inst_30711);
var inst_30694 = inst_30725;
var inst_30695 = null;
var inst_30696 = (0);
var inst_30697 = (0);
var state_30747__$1 = (function (){var statearr_30758 = state_30747;
(statearr_30758[(8)] = inst_30697);

(statearr_30758[(9)] = inst_30694);

(statearr_30758[(10)] = inst_30724);

(statearr_30758[(11)] = inst_30696);

(statearr_30758[(12)] = inst_30695);

return statearr_30758;
})();
var statearr_30759_32854 = state_30747__$1;
(statearr_30759_32854[(2)] = null);

(statearr_30759_32854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (1))){
var state_30747__$1 = state_30747;
var statearr_30760_32857 = state_30747__$1;
(statearr_30760_32857[(2)] = null);

(statearr_30760_32857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (4))){
var inst_30683 = (state_30747[(13)]);
var inst_30683__$1 = (state_30747[(2)]);
var inst_30684 = (inst_30683__$1 == null);
var state_30747__$1 = (function (){var statearr_30764 = state_30747;
(statearr_30764[(13)] = inst_30683__$1);

return statearr_30764;
})();
if(cljs.core.truth_(inst_30684)){
var statearr_30767_32861 = state_30747__$1;
(statearr_30767_32861[(1)] = (5));

} else {
var statearr_30768_32862 = state_30747__$1;
(statearr_30768_32862[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (15))){
var state_30747__$1 = state_30747;
var statearr_30780_32863 = state_30747__$1;
(statearr_30780_32863[(2)] = null);

(statearr_30780_32863[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (21))){
var state_30747__$1 = state_30747;
var statearr_30783_32866 = state_30747__$1;
(statearr_30783_32866[(2)] = null);

(statearr_30783_32866[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (13))){
var inst_30697 = (state_30747[(8)]);
var inst_30694 = (state_30747[(9)]);
var inst_30696 = (state_30747[(11)]);
var inst_30695 = (state_30747[(12)]);
var inst_30705 = (state_30747[(2)]);
var inst_30707 = (inst_30697 + (1));
var tmp30777 = inst_30694;
var tmp30778 = inst_30696;
var tmp30779 = inst_30695;
var inst_30694__$1 = tmp30777;
var inst_30695__$1 = tmp30779;
var inst_30696__$1 = tmp30778;
var inst_30697__$1 = inst_30707;
var state_30747__$1 = (function (){var statearr_30784 = state_30747;
(statearr_30784[(8)] = inst_30697__$1);

(statearr_30784[(9)] = inst_30694__$1);

(statearr_30784[(11)] = inst_30696__$1);

(statearr_30784[(14)] = inst_30705);

(statearr_30784[(12)] = inst_30695__$1);

return statearr_30784;
})();
var statearr_30785_32869 = state_30747__$1;
(statearr_30785_32869[(2)] = null);

(statearr_30785_32869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (22))){
var state_30747__$1 = state_30747;
var statearr_30786_32877 = state_30747__$1;
(statearr_30786_32877[(2)] = null);

(statearr_30786_32877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (6))){
var inst_30683 = (state_30747[(13)]);
var inst_30692 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_30683) : f.call(null,inst_30683));
var inst_30693 = cljs.core.seq(inst_30692);
var inst_30694 = inst_30693;
var inst_30695 = null;
var inst_30696 = (0);
var inst_30697 = (0);
var state_30747__$1 = (function (){var statearr_30787 = state_30747;
(statearr_30787[(8)] = inst_30697);

(statearr_30787[(9)] = inst_30694);

(statearr_30787[(11)] = inst_30696);

(statearr_30787[(12)] = inst_30695);

return statearr_30787;
})();
var statearr_30788_32878 = state_30747__$1;
(statearr_30788_32878[(2)] = null);

(statearr_30788_32878[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (17))){
var inst_30711 = (state_30747[(7)]);
var inst_30715 = cljs.core.chunk_first(inst_30711);
var inst_30716 = cljs.core.chunk_rest(inst_30711);
var inst_30717 = cljs.core.count(inst_30715);
var inst_30694 = inst_30716;
var inst_30695 = inst_30715;
var inst_30696 = inst_30717;
var inst_30697 = (0);
var state_30747__$1 = (function (){var statearr_30789 = state_30747;
(statearr_30789[(8)] = inst_30697);

(statearr_30789[(9)] = inst_30694);

(statearr_30789[(11)] = inst_30696);

(statearr_30789[(12)] = inst_30695);

return statearr_30789;
})();
var statearr_30790_32885 = state_30747__$1;
(statearr_30790_32885[(2)] = null);

(statearr_30790_32885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (3))){
var inst_30745 = (state_30747[(2)]);
var state_30747__$1 = state_30747;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30747__$1,inst_30745);
} else {
if((state_val_30748 === (12))){
var inst_30733 = (state_30747[(2)]);
var state_30747__$1 = state_30747;
var statearr_30797_32886 = state_30747__$1;
(statearr_30797_32886[(2)] = inst_30733);

(statearr_30797_32886[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (2))){
var state_30747__$1 = state_30747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30747__$1,(4),in$);
} else {
if((state_val_30748 === (23))){
var inst_30741 = (state_30747[(2)]);
var state_30747__$1 = state_30747;
var statearr_30802_32891 = state_30747__$1;
(statearr_30802_32891[(2)] = inst_30741);

(statearr_30802_32891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (19))){
var inst_30728 = (state_30747[(2)]);
var state_30747__$1 = state_30747;
var statearr_30808_32893 = state_30747__$1;
(statearr_30808_32893[(2)] = inst_30728);

(statearr_30808_32893[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (11))){
var inst_30694 = (state_30747[(9)]);
var inst_30711 = (state_30747[(7)]);
var inst_30711__$1 = cljs.core.seq(inst_30694);
var state_30747__$1 = (function (){var statearr_30810 = state_30747;
(statearr_30810[(7)] = inst_30711__$1);

return statearr_30810;
})();
if(inst_30711__$1){
var statearr_30811_32960 = state_30747__$1;
(statearr_30811_32960[(1)] = (14));

} else {
var statearr_30812_32961 = state_30747__$1;
(statearr_30812_32961[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (9))){
var inst_30735 = (state_30747[(2)]);
var inst_30736 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_30747__$1 = (function (){var statearr_30816 = state_30747;
(statearr_30816[(15)] = inst_30735);

return statearr_30816;
})();
if(cljs.core.truth_(inst_30736)){
var statearr_30817_32966 = state_30747__$1;
(statearr_30817_32966[(1)] = (21));

} else {
var statearr_30818_32967 = state_30747__$1;
(statearr_30818_32967[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (5))){
var inst_30686 = cljs.core.async.close_BANG_(out);
var state_30747__$1 = state_30747;
var statearr_30819_32974 = state_30747__$1;
(statearr_30819_32974[(2)] = inst_30686);

(statearr_30819_32974[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (14))){
var inst_30711 = (state_30747[(7)]);
var inst_30713 = cljs.core.chunked_seq_QMARK_(inst_30711);
var state_30747__$1 = state_30747;
if(inst_30713){
var statearr_30822_32979 = state_30747__$1;
(statearr_30822_32979[(1)] = (17));

} else {
var statearr_30823_32980 = state_30747__$1;
(statearr_30823_32980[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (16))){
var inst_30731 = (state_30747[(2)]);
var state_30747__$1 = state_30747;
var statearr_30824_32985 = state_30747__$1;
(statearr_30824_32985[(2)] = inst_30731);

(statearr_30824_32985[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30748 === (10))){
var inst_30697 = (state_30747[(8)]);
var inst_30695 = (state_30747[(12)]);
var inst_30703 = cljs.core._nth(inst_30695,inst_30697);
var state_30747__$1 = state_30747;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30747__$1,(13),out,inst_30703);
} else {
if((state_val_30748 === (18))){
var inst_30711 = (state_30747[(7)]);
var inst_30721 = cljs.core.first(inst_30711);
var state_30747__$1 = state_30747;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30747__$1,(20),out,inst_30721);
} else {
if((state_val_30748 === (8))){
var inst_30697 = (state_30747[(8)]);
var inst_30696 = (state_30747[(11)]);
var inst_30699 = (inst_30697 < inst_30696);
var inst_30700 = inst_30699;
var state_30747__$1 = state_30747;
if(cljs.core.truth_(inst_30700)){
var statearr_30828_33028 = state_30747__$1;
(statearr_30828_33028[(1)] = (10));

} else {
var statearr_30829_33032 = state_30747__$1;
(statearr_30829_33032[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28098__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28098__auto____0 = (function (){
var statearr_30830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30830[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28098__auto__);

(statearr_30830[(1)] = (1));

return statearr_30830;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28098__auto____1 = (function (state_30747){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_30747);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e30832){var ex__28101__auto__ = e30832;
var statearr_30833_33048 = state_30747;
(statearr_30833_33048[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_30747[(4)]))){
var statearr_30834_33050 = state_30747;
(statearr_30834_33050[(1)] = cljs.core.first((state_30747[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33054 = state_30747;
state_30747 = G__33054;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28098__auto__ = function(state_30747){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28098__auto____1.call(this,state_30747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28098__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28098__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_30837 = f__28252__auto__();
(statearr_30837[(6)] = c__28251__auto__);

return statearr_30837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));

return c__28251__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30841 = arguments.length;
switch (G__30841) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30853 = arguments.length;
switch (G__30853) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30866 = arguments.length;
switch (G__30866) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28251__auto___33150 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_30908){
var state_val_30910 = (state_30908[(1)]);
if((state_val_30910 === (7))){
var inst_30903 = (state_30908[(2)]);
var state_30908__$1 = state_30908;
var statearr_30914_33155 = state_30908__$1;
(statearr_30914_33155[(2)] = inst_30903);

(statearr_30914_33155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30910 === (1))){
var inst_30885 = null;
var state_30908__$1 = (function (){var statearr_30916 = state_30908;
(statearr_30916[(7)] = inst_30885);

return statearr_30916;
})();
var statearr_30917_33157 = state_30908__$1;
(statearr_30917_33157[(2)] = null);

(statearr_30917_33157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30910 === (4))){
var inst_30888 = (state_30908[(8)]);
var inst_30888__$1 = (state_30908[(2)]);
var inst_30889 = (inst_30888__$1 == null);
var inst_30890 = cljs.core.not(inst_30889);
var state_30908__$1 = (function (){var statearr_30922 = state_30908;
(statearr_30922[(8)] = inst_30888__$1);

return statearr_30922;
})();
if(inst_30890){
var statearr_30924_33158 = state_30908__$1;
(statearr_30924_33158[(1)] = (5));

} else {
var statearr_30925_33159 = state_30908__$1;
(statearr_30925_33159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30910 === (6))){
var state_30908__$1 = state_30908;
var statearr_30926_33160 = state_30908__$1;
(statearr_30926_33160[(2)] = null);

(statearr_30926_33160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30910 === (3))){
var inst_30905 = (state_30908[(2)]);
var inst_30906 = cljs.core.async.close_BANG_(out);
var state_30908__$1 = (function (){var statearr_30928 = state_30908;
(statearr_30928[(9)] = inst_30905);

return statearr_30928;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30908__$1,inst_30906);
} else {
if((state_val_30910 === (2))){
var state_30908__$1 = state_30908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30908__$1,(4),ch);
} else {
if((state_val_30910 === (11))){
var inst_30888 = (state_30908[(8)]);
var inst_30897 = (state_30908[(2)]);
var inst_30885 = inst_30888;
var state_30908__$1 = (function (){var statearr_30932 = state_30908;
(statearr_30932[(10)] = inst_30897);

(statearr_30932[(7)] = inst_30885);

return statearr_30932;
})();
var statearr_30934_33169 = state_30908__$1;
(statearr_30934_33169[(2)] = null);

(statearr_30934_33169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30910 === (9))){
var inst_30888 = (state_30908[(8)]);
var state_30908__$1 = state_30908;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30908__$1,(11),out,inst_30888);
} else {
if((state_val_30910 === (5))){
var inst_30888 = (state_30908[(8)]);
var inst_30885 = (state_30908[(7)]);
var inst_30892 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30888,inst_30885);
var state_30908__$1 = state_30908;
if(inst_30892){
var statearr_30936_33176 = state_30908__$1;
(statearr_30936_33176[(1)] = (8));

} else {
var statearr_30937_33188 = state_30908__$1;
(statearr_30937_33188[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30910 === (10))){
var inst_30900 = (state_30908[(2)]);
var state_30908__$1 = state_30908;
var statearr_30939_33189 = state_30908__$1;
(statearr_30939_33189[(2)] = inst_30900);

(statearr_30939_33189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30910 === (8))){
var inst_30885 = (state_30908[(7)]);
var tmp30935 = inst_30885;
var inst_30885__$1 = tmp30935;
var state_30908__$1 = (function (){var statearr_30941 = state_30908;
(statearr_30941[(7)] = inst_30885__$1);

return statearr_30941;
})();
var statearr_30942_33203 = state_30908__$1;
(statearr_30942_33203[(2)] = null);

(statearr_30942_33203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_30943 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30943[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_30943[(1)] = (1));

return statearr_30943;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_30908){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_30908);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e30944){var ex__28101__auto__ = e30944;
var statearr_30951_33224 = state_30908;
(statearr_30951_33224[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_30908[(4)]))){
var statearr_30955_33225 = state_30908;
(statearr_30955_33225[(1)] = cljs.core.first((state_30908[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33230 = state_30908;
state_30908 = G__33230;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_30908){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_30908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_30963 = f__28252__auto__();
(statearr_30963[(6)] = c__28251__auto___33150);

return statearr_30963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30966 = arguments.length;
switch (G__30966) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28251__auto___33235 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_31010){
var state_val_31011 = (state_31010[(1)]);
if((state_val_31011 === (7))){
var inst_31006 = (state_31010[(2)]);
var state_31010__$1 = state_31010;
var statearr_31014_33238 = state_31010__$1;
(statearr_31014_33238[(2)] = inst_31006);

(statearr_31014_33238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (1))){
var inst_30971 = (new Array(n));
var inst_30972 = inst_30971;
var inst_30973 = (0);
var state_31010__$1 = (function (){var statearr_31016 = state_31010;
(statearr_31016[(7)] = inst_30972);

(statearr_31016[(8)] = inst_30973);

return statearr_31016;
})();
var statearr_31017_33241 = state_31010__$1;
(statearr_31017_33241[(2)] = null);

(statearr_31017_33241[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (4))){
var inst_30976 = (state_31010[(9)]);
var inst_30976__$1 = (state_31010[(2)]);
var inst_30977 = (inst_30976__$1 == null);
var inst_30978 = cljs.core.not(inst_30977);
var state_31010__$1 = (function (){var statearr_31018 = state_31010;
(statearr_31018[(9)] = inst_30976__$1);

return statearr_31018;
})();
if(inst_30978){
var statearr_31019_33243 = state_31010__$1;
(statearr_31019_33243[(1)] = (5));

} else {
var statearr_31020_33244 = state_31010__$1;
(statearr_31020_33244[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (15))){
var inst_30999 = (state_31010[(2)]);
var state_31010__$1 = state_31010;
var statearr_31021_33247 = state_31010__$1;
(statearr_31021_33247[(2)] = inst_30999);

(statearr_31021_33247[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (13))){
var state_31010__$1 = state_31010;
var statearr_31022_33248 = state_31010__$1;
(statearr_31022_33248[(2)] = null);

(statearr_31022_33248[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (6))){
var inst_30973 = (state_31010[(8)]);
var inst_30995 = (inst_30973 > (0));
var state_31010__$1 = state_31010;
if(cljs.core.truth_(inst_30995)){
var statearr_31023_33249 = state_31010__$1;
(statearr_31023_33249[(1)] = (12));

} else {
var statearr_31024_33250 = state_31010__$1;
(statearr_31024_33250[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (3))){
var inst_31008 = (state_31010[(2)]);
var state_31010__$1 = state_31010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31010__$1,inst_31008);
} else {
if((state_val_31011 === (12))){
var inst_30972 = (state_31010[(7)]);
var inst_30997 = cljs.core.vec(inst_30972);
var state_31010__$1 = state_31010;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31010__$1,(15),out,inst_30997);
} else {
if((state_val_31011 === (2))){
var state_31010__$1 = state_31010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31010__$1,(4),ch);
} else {
if((state_val_31011 === (11))){
var inst_30989 = (state_31010[(2)]);
var inst_30990 = (new Array(n));
var inst_30972 = inst_30990;
var inst_30973 = (0);
var state_31010__$1 = (function (){var statearr_31027 = state_31010;
(statearr_31027[(10)] = inst_30989);

(statearr_31027[(7)] = inst_30972);

(statearr_31027[(8)] = inst_30973);

return statearr_31027;
})();
var statearr_31031_33258 = state_31010__$1;
(statearr_31031_33258[(2)] = null);

(statearr_31031_33258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (9))){
var inst_30972 = (state_31010[(7)]);
var inst_30987 = cljs.core.vec(inst_30972);
var state_31010__$1 = state_31010;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31010__$1,(11),out,inst_30987);
} else {
if((state_val_31011 === (5))){
var inst_30972 = (state_31010[(7)]);
var inst_30976 = (state_31010[(9)]);
var inst_30982 = (state_31010[(11)]);
var inst_30973 = (state_31010[(8)]);
var inst_30980 = (inst_30972[inst_30973] = inst_30976);
var inst_30982__$1 = (inst_30973 + (1));
var inst_30983 = (inst_30982__$1 < n);
var state_31010__$1 = (function (){var statearr_31032 = state_31010;
(statearr_31032[(12)] = inst_30980);

(statearr_31032[(11)] = inst_30982__$1);

return statearr_31032;
})();
if(cljs.core.truth_(inst_30983)){
var statearr_31033_33268 = state_31010__$1;
(statearr_31033_33268[(1)] = (8));

} else {
var statearr_31034_33269 = state_31010__$1;
(statearr_31034_33269[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (14))){
var inst_31003 = (state_31010[(2)]);
var inst_31004 = cljs.core.async.close_BANG_(out);
var state_31010__$1 = (function (){var statearr_31036 = state_31010;
(statearr_31036[(13)] = inst_31003);

return statearr_31036;
})();
var statearr_31037_33271 = state_31010__$1;
(statearr_31037_33271[(2)] = inst_31004);

(statearr_31037_33271[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (10))){
var inst_30993 = (state_31010[(2)]);
var state_31010__$1 = state_31010;
var statearr_31039_33276 = state_31010__$1;
(statearr_31039_33276[(2)] = inst_30993);

(statearr_31039_33276[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31011 === (8))){
var inst_30972 = (state_31010[(7)]);
var inst_30982 = (state_31010[(11)]);
var tmp31035 = inst_30972;
var inst_30972__$1 = tmp31035;
var inst_30973 = inst_30982;
var state_31010__$1 = (function (){var statearr_31041 = state_31010;
(statearr_31041[(7)] = inst_30972__$1);

(statearr_31041[(8)] = inst_30973);

return statearr_31041;
})();
var statearr_31044_33279 = state_31010__$1;
(statearr_31044_33279[(2)] = null);

(statearr_31044_33279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_31045 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31045[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_31045[(1)] = (1));

return statearr_31045;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_31010){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_31010);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e31047){var ex__28101__auto__ = e31047;
var statearr_31048_33284 = state_31010;
(statearr_31048_33284[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_31010[(4)]))){
var statearr_31053_33285 = state_31010;
(statearr_31053_33285[(1)] = cljs.core.first((state_31010[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33286 = state_31010;
state_31010 = G__33286;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_31010){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_31010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_31065 = f__28252__auto__();
(statearr_31065[(6)] = c__28251__auto___33235);

return statearr_31065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__31068 = arguments.length;
switch (G__31068) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28251__auto___33295 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_31122){
var state_val_31123 = (state_31122[(1)]);
if((state_val_31123 === (7))){
var inst_31118 = (state_31122[(2)]);
var state_31122__$1 = state_31122;
var statearr_31124_33307 = state_31122__$1;
(statearr_31124_33307[(2)] = inst_31118);

(statearr_31124_33307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (1))){
var inst_31081 = [];
var inst_31082 = inst_31081;
var inst_31083 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_31122__$1 = (function (){var statearr_31125 = state_31122;
(statearr_31125[(7)] = inst_31083);

(statearr_31125[(8)] = inst_31082);

return statearr_31125;
})();
var statearr_31126_33316 = state_31122__$1;
(statearr_31126_33316[(2)] = null);

(statearr_31126_33316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (4))){
var inst_31086 = (state_31122[(9)]);
var inst_31086__$1 = (state_31122[(2)]);
var inst_31087 = (inst_31086__$1 == null);
var inst_31088 = cljs.core.not(inst_31087);
var state_31122__$1 = (function (){var statearr_31127 = state_31122;
(statearr_31127[(9)] = inst_31086__$1);

return statearr_31127;
})();
if(inst_31088){
var statearr_31128_33321 = state_31122__$1;
(statearr_31128_33321[(1)] = (5));

} else {
var statearr_31129_33322 = state_31122__$1;
(statearr_31129_33322[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (15))){
var inst_31112 = (state_31122[(2)]);
var state_31122__$1 = state_31122;
var statearr_31130_33325 = state_31122__$1;
(statearr_31130_33325[(2)] = inst_31112);

(statearr_31130_33325[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (13))){
var state_31122__$1 = state_31122;
var statearr_31132_33333 = state_31122__$1;
(statearr_31132_33333[(2)] = null);

(statearr_31132_33333[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (6))){
var inst_31082 = (state_31122[(8)]);
var inst_31107 = inst_31082.length;
var inst_31108 = (inst_31107 > (0));
var state_31122__$1 = state_31122;
if(cljs.core.truth_(inst_31108)){
var statearr_31136_33336 = state_31122__$1;
(statearr_31136_33336[(1)] = (12));

} else {
var statearr_31137_33338 = state_31122__$1;
(statearr_31137_33338[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (3))){
var inst_31120 = (state_31122[(2)]);
var state_31122__$1 = state_31122;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31122__$1,inst_31120);
} else {
if((state_val_31123 === (12))){
var inst_31082 = (state_31122[(8)]);
var inst_31110 = cljs.core.vec(inst_31082);
var state_31122__$1 = state_31122;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31122__$1,(15),out,inst_31110);
} else {
if((state_val_31123 === (2))){
var state_31122__$1 = state_31122;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31122__$1,(4),ch);
} else {
if((state_val_31123 === (11))){
var inst_31086 = (state_31122[(9)]);
var inst_31090 = (state_31122[(10)]);
var inst_31100 = (state_31122[(2)]);
var inst_31101 = [];
var inst_31102 = inst_31101.push(inst_31086);
var inst_31082 = inst_31101;
var inst_31083 = inst_31090;
var state_31122__$1 = (function (){var statearr_31138 = state_31122;
(statearr_31138[(7)] = inst_31083);

(statearr_31138[(11)] = inst_31102);

(statearr_31138[(12)] = inst_31100);

(statearr_31138[(8)] = inst_31082);

return statearr_31138;
})();
var statearr_31139_33359 = state_31122__$1;
(statearr_31139_33359[(2)] = null);

(statearr_31139_33359[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (9))){
var inst_31082 = (state_31122[(8)]);
var inst_31098 = cljs.core.vec(inst_31082);
var state_31122__$1 = state_31122;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31122__$1,(11),out,inst_31098);
} else {
if((state_val_31123 === (5))){
var inst_31083 = (state_31122[(7)]);
var inst_31086 = (state_31122[(9)]);
var inst_31090 = (state_31122[(10)]);
var inst_31090__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_31086) : f.call(null,inst_31086));
var inst_31091 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31090__$1,inst_31083);
var inst_31092 = cljs.core.keyword_identical_QMARK_(inst_31083,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_31093 = ((inst_31091) || (inst_31092));
var state_31122__$1 = (function (){var statearr_31140 = state_31122;
(statearr_31140[(10)] = inst_31090__$1);

return statearr_31140;
})();
if(cljs.core.truth_(inst_31093)){
var statearr_31141_33374 = state_31122__$1;
(statearr_31141_33374[(1)] = (8));

} else {
var statearr_31142_33375 = state_31122__$1;
(statearr_31142_33375[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (14))){
var inst_31115 = (state_31122[(2)]);
var inst_31116 = cljs.core.async.close_BANG_(out);
var state_31122__$1 = (function (){var statearr_31145 = state_31122;
(statearr_31145[(13)] = inst_31115);

return statearr_31145;
})();
var statearr_31146_33377 = state_31122__$1;
(statearr_31146_33377[(2)] = inst_31116);

(statearr_31146_33377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (10))){
var inst_31105 = (state_31122[(2)]);
var state_31122__$1 = state_31122;
var statearr_31147_33379 = state_31122__$1;
(statearr_31147_33379[(2)] = inst_31105);

(statearr_31147_33379[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31123 === (8))){
var inst_31086 = (state_31122[(9)]);
var inst_31090 = (state_31122[(10)]);
var inst_31082 = (state_31122[(8)]);
var inst_31095 = inst_31082.push(inst_31086);
var tmp31143 = inst_31082;
var inst_31082__$1 = tmp31143;
var inst_31083 = inst_31090;
var state_31122__$1 = (function (){var statearr_31148 = state_31122;
(statearr_31148[(7)] = inst_31083);

(statearr_31148[(14)] = inst_31095);

(statearr_31148[(8)] = inst_31082__$1);

return statearr_31148;
})();
var statearr_31149_33382 = state_31122__$1;
(statearr_31149_33382[(2)] = null);

(statearr_31149_33382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28098__auto__ = null;
var cljs$core$async$state_machine__28098__auto____0 = (function (){
var statearr_31150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31150[(0)] = cljs$core$async$state_machine__28098__auto__);

(statearr_31150[(1)] = (1));

return statearr_31150;
});
var cljs$core$async$state_machine__28098__auto____1 = (function (state_31122){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_31122);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e31151){var ex__28101__auto__ = e31151;
var statearr_31152_33383 = state_31122;
(statearr_31152_33383[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_31122[(4)]))){
var statearr_31153_33385 = state_31122;
(statearr_31153_33385[(1)] = cljs.core.first((state_31122[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33386 = state_31122;
state_31122 = G__33386;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
cljs$core$async$state_machine__28098__auto__ = function(state_31122){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28098__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28098__auto____1.call(this,state_31122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28098__auto____0;
cljs$core$async$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28098__auto____1;
return cljs$core$async$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_31154 = f__28252__auto__();
(statearr_31154[(6)] = c__28251__auto___33295);

return statearr_31154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
