goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_32095 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_32095(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_32099 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_32099(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__31229 = coll;
var G__31230 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__31229,G__31230) : shadow.dom.lazy_native_coll_seq.call(null,G__31229,G__31230));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__31260 = arguments.length;
switch (G__31260) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__31267 = arguments.length;
switch (G__31267) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__31269 = arguments.length;
switch (G__31269) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__31271 = arguments.length;
switch (G__31271) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__31277 = arguments.length;
switch (G__31277) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__31282 = arguments.length;
switch (G__31282) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e31287){if((e31287 instanceof Object)){
var e = e31287;
return console.log("didnt support attachEvent",el,e);
} else {
throw e31287;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__31294 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__31295 = null;
var count__31296 = (0);
var i__31297 = (0);
while(true){
if((i__31297 < count__31296)){
var el = chunk__31295.cljs$core$IIndexed$_nth$arity$2(null,i__31297);
var handler_32174__$1 = ((function (seq__31294,chunk__31295,count__31296,i__31297,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__31294,chunk__31295,count__31296,i__31297,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_32174__$1);


var G__32175 = seq__31294;
var G__32176 = chunk__31295;
var G__32177 = count__31296;
var G__32178 = (i__31297 + (1));
seq__31294 = G__32175;
chunk__31295 = G__32176;
count__31296 = G__32177;
i__31297 = G__32178;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__31294);
if(temp__5735__auto__){
var seq__31294__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31294__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__31294__$1);
var G__32179 = cljs.core.chunk_rest(seq__31294__$1);
var G__32181 = c__4556__auto__;
var G__32182 = cljs.core.count(c__4556__auto__);
var G__32183 = (0);
seq__31294 = G__32179;
chunk__31295 = G__32181;
count__31296 = G__32182;
i__31297 = G__32183;
continue;
} else {
var el = cljs.core.first(seq__31294__$1);
var handler_32185__$1 = ((function (seq__31294,chunk__31295,count__31296,i__31297,el,seq__31294__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__31294,chunk__31295,count__31296,i__31297,el,seq__31294__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_32185__$1);


var G__32188 = cljs.core.next(seq__31294__$1);
var G__32189 = null;
var G__32190 = (0);
var G__32191 = (0);
seq__31294 = G__32188;
chunk__31295 = G__32189;
count__31296 = G__32190;
i__31297 = G__32191;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__31312 = arguments.length;
switch (G__31312) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__31319 = cljs.core.seq(events);
var chunk__31320 = null;
var count__31321 = (0);
var i__31322 = (0);
while(true){
if((i__31322 < count__31321)){
var vec__31334 = chunk__31320.cljs$core$IIndexed$_nth$arity$2(null,i__31322);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31334,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31334,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__32221 = seq__31319;
var G__32222 = chunk__31320;
var G__32223 = count__31321;
var G__32224 = (i__31322 + (1));
seq__31319 = G__32221;
chunk__31320 = G__32222;
count__31321 = G__32223;
i__31322 = G__32224;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__31319);
if(temp__5735__auto__){
var seq__31319__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31319__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__31319__$1);
var G__32227 = cljs.core.chunk_rest(seq__31319__$1);
var G__32228 = c__4556__auto__;
var G__32229 = cljs.core.count(c__4556__auto__);
var G__32230 = (0);
seq__31319 = G__32227;
chunk__31320 = G__32228;
count__31321 = G__32229;
i__31322 = G__32230;
continue;
} else {
var vec__31341 = cljs.core.first(seq__31319__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31341,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31341,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__32232 = cljs.core.next(seq__31319__$1);
var G__32233 = null;
var G__32234 = (0);
var G__32235 = (0);
seq__31319 = G__32232;
chunk__31320 = G__32233;
count__31321 = G__32234;
i__31322 = G__32235;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__31355 = cljs.core.seq(styles);
var chunk__31356 = null;
var count__31357 = (0);
var i__31358 = (0);
while(true){
if((i__31358 < count__31357)){
var vec__31389 = chunk__31356.cljs$core$IIndexed$_nth$arity$2(null,i__31358);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31389,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31389,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__32242 = seq__31355;
var G__32243 = chunk__31356;
var G__32244 = count__31357;
var G__32245 = (i__31358 + (1));
seq__31355 = G__32242;
chunk__31356 = G__32243;
count__31357 = G__32244;
i__31358 = G__32245;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__31355);
if(temp__5735__auto__){
var seq__31355__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31355__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__31355__$1);
var G__32250 = cljs.core.chunk_rest(seq__31355__$1);
var G__32251 = c__4556__auto__;
var G__32252 = cljs.core.count(c__4556__auto__);
var G__32253 = (0);
seq__31355 = G__32250;
chunk__31356 = G__32251;
count__31357 = G__32252;
i__31358 = G__32253;
continue;
} else {
var vec__31393 = cljs.core.first(seq__31355__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31393,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31393,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__32256 = cljs.core.next(seq__31355__$1);
var G__32257 = null;
var G__32258 = (0);
var G__32259 = (0);
seq__31355 = G__32256;
chunk__31356 = G__32257;
count__31357 = G__32258;
i__31358 = G__32259;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__31401_32261 = key;
var G__31401_32262__$1 = (((G__31401_32261 instanceof cljs.core.Keyword))?G__31401_32261.fqn:null);
switch (G__31401_32262__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_32282 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_32282,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_32282,"aria-");
}
})())){
el.setAttribute(ks_32282,value);
} else {
(el[ks_32282] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__31416){
var map__31417 = p__31416;
var map__31417__$1 = (((((!((map__31417 == null))))?(((((map__31417.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31417.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31417):map__31417);
var props = map__31417__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31417__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__31425 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31425,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31425,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31425,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__31429 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__31429,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__31429;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__31435 = arguments.length;
switch (G__31435) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__31446){
var vec__31447 = p__31446;
var seq__31448 = cljs.core.seq(vec__31447);
var first__31449 = cljs.core.first(seq__31448);
var seq__31448__$1 = cljs.core.next(seq__31448);
var nn = first__31449;
var first__31449__$1 = cljs.core.first(seq__31448__$1);
var seq__31448__$2 = cljs.core.next(seq__31448__$1);
var np = first__31449__$1;
var nc = seq__31448__$2;
var node = vec__31447;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__31451 = nn;
var G__31452 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__31451,G__31452) : create_fn.call(null,G__31451,G__31452));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__31454 = nn;
var G__31455 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__31454,G__31455) : create_fn.call(null,G__31454,G__31455));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__31457 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31457,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31457,(1),null);
var seq__31460_32350 = cljs.core.seq(node_children);
var chunk__31461_32351 = null;
var count__31462_32352 = (0);
var i__31463_32353 = (0);
while(true){
if((i__31463_32353 < count__31462_32352)){
var child_struct_32354 = chunk__31461_32351.cljs$core$IIndexed$_nth$arity$2(null,i__31463_32353);
var children_32355 = shadow.dom.dom_node(child_struct_32354);
if(cljs.core.seq_QMARK_(children_32355)){
var seq__31499_32356 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_32355));
var chunk__31501_32357 = null;
var count__31502_32358 = (0);
var i__31503_32359 = (0);
while(true){
if((i__31503_32359 < count__31502_32358)){
var child_32366 = chunk__31501_32357.cljs$core$IIndexed$_nth$arity$2(null,i__31503_32359);
if(cljs.core.truth_(child_32366)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_32366);


var G__32367 = seq__31499_32356;
var G__32368 = chunk__31501_32357;
var G__32369 = count__31502_32358;
var G__32370 = (i__31503_32359 + (1));
seq__31499_32356 = G__32367;
chunk__31501_32357 = G__32368;
count__31502_32358 = G__32369;
i__31503_32359 = G__32370;
continue;
} else {
var G__32373 = seq__31499_32356;
var G__32374 = chunk__31501_32357;
var G__32375 = count__31502_32358;
var G__32376 = (i__31503_32359 + (1));
seq__31499_32356 = G__32373;
chunk__31501_32357 = G__32374;
count__31502_32358 = G__32375;
i__31503_32359 = G__32376;
continue;
}
} else {
var temp__5735__auto___32378 = cljs.core.seq(seq__31499_32356);
if(temp__5735__auto___32378){
var seq__31499_32379__$1 = temp__5735__auto___32378;
if(cljs.core.chunked_seq_QMARK_(seq__31499_32379__$1)){
var c__4556__auto___32380 = cljs.core.chunk_first(seq__31499_32379__$1);
var G__32381 = cljs.core.chunk_rest(seq__31499_32379__$1);
var G__32382 = c__4556__auto___32380;
var G__32383 = cljs.core.count(c__4556__auto___32380);
var G__32384 = (0);
seq__31499_32356 = G__32381;
chunk__31501_32357 = G__32382;
count__31502_32358 = G__32383;
i__31503_32359 = G__32384;
continue;
} else {
var child_32389 = cljs.core.first(seq__31499_32379__$1);
if(cljs.core.truth_(child_32389)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_32389);


var G__32392 = cljs.core.next(seq__31499_32379__$1);
var G__32393 = null;
var G__32394 = (0);
var G__32395 = (0);
seq__31499_32356 = G__32392;
chunk__31501_32357 = G__32393;
count__31502_32358 = G__32394;
i__31503_32359 = G__32395;
continue;
} else {
var G__32396 = cljs.core.next(seq__31499_32379__$1);
var G__32397 = null;
var G__32398 = (0);
var G__32399 = (0);
seq__31499_32356 = G__32396;
chunk__31501_32357 = G__32397;
count__31502_32358 = G__32398;
i__31503_32359 = G__32399;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_32355);
}


var G__32400 = seq__31460_32350;
var G__32401 = chunk__31461_32351;
var G__32402 = count__31462_32352;
var G__32403 = (i__31463_32353 + (1));
seq__31460_32350 = G__32400;
chunk__31461_32351 = G__32401;
count__31462_32352 = G__32402;
i__31463_32353 = G__32403;
continue;
} else {
var temp__5735__auto___32404 = cljs.core.seq(seq__31460_32350);
if(temp__5735__auto___32404){
var seq__31460_32406__$1 = temp__5735__auto___32404;
if(cljs.core.chunked_seq_QMARK_(seq__31460_32406__$1)){
var c__4556__auto___32408 = cljs.core.chunk_first(seq__31460_32406__$1);
var G__32412 = cljs.core.chunk_rest(seq__31460_32406__$1);
var G__32413 = c__4556__auto___32408;
var G__32414 = cljs.core.count(c__4556__auto___32408);
var G__32415 = (0);
seq__31460_32350 = G__32412;
chunk__31461_32351 = G__32413;
count__31462_32352 = G__32414;
i__31463_32353 = G__32415;
continue;
} else {
var child_struct_32416 = cljs.core.first(seq__31460_32406__$1);
var children_32422 = shadow.dom.dom_node(child_struct_32416);
if(cljs.core.seq_QMARK_(children_32422)){
var seq__31521_32423 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_32422));
var chunk__31523_32424 = null;
var count__31524_32425 = (0);
var i__31525_32426 = (0);
while(true){
if((i__31525_32426 < count__31524_32425)){
var child_32427 = chunk__31523_32424.cljs$core$IIndexed$_nth$arity$2(null,i__31525_32426);
if(cljs.core.truth_(child_32427)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_32427);


var G__32434 = seq__31521_32423;
var G__32435 = chunk__31523_32424;
var G__32436 = count__31524_32425;
var G__32437 = (i__31525_32426 + (1));
seq__31521_32423 = G__32434;
chunk__31523_32424 = G__32435;
count__31524_32425 = G__32436;
i__31525_32426 = G__32437;
continue;
} else {
var G__32438 = seq__31521_32423;
var G__32439 = chunk__31523_32424;
var G__32440 = count__31524_32425;
var G__32441 = (i__31525_32426 + (1));
seq__31521_32423 = G__32438;
chunk__31523_32424 = G__32439;
count__31524_32425 = G__32440;
i__31525_32426 = G__32441;
continue;
}
} else {
var temp__5735__auto___32443__$1 = cljs.core.seq(seq__31521_32423);
if(temp__5735__auto___32443__$1){
var seq__31521_32445__$1 = temp__5735__auto___32443__$1;
if(cljs.core.chunked_seq_QMARK_(seq__31521_32445__$1)){
var c__4556__auto___32446 = cljs.core.chunk_first(seq__31521_32445__$1);
var G__32447 = cljs.core.chunk_rest(seq__31521_32445__$1);
var G__32448 = c__4556__auto___32446;
var G__32449 = cljs.core.count(c__4556__auto___32446);
var G__32450 = (0);
seq__31521_32423 = G__32447;
chunk__31523_32424 = G__32448;
count__31524_32425 = G__32449;
i__31525_32426 = G__32450;
continue;
} else {
var child_32452 = cljs.core.first(seq__31521_32445__$1);
if(cljs.core.truth_(child_32452)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_32452);


var G__32454 = cljs.core.next(seq__31521_32445__$1);
var G__32455 = null;
var G__32456 = (0);
var G__32457 = (0);
seq__31521_32423 = G__32454;
chunk__31523_32424 = G__32455;
count__31524_32425 = G__32456;
i__31525_32426 = G__32457;
continue;
} else {
var G__32458 = cljs.core.next(seq__31521_32445__$1);
var G__32459 = null;
var G__32460 = (0);
var G__32461 = (0);
seq__31521_32423 = G__32458;
chunk__31523_32424 = G__32459;
count__31524_32425 = G__32460;
i__31525_32426 = G__32461;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_32422);
}


var G__32465 = cljs.core.next(seq__31460_32406__$1);
var G__32466 = null;
var G__32467 = (0);
var G__32468 = (0);
seq__31460_32350 = G__32465;
chunk__31461_32351 = G__32466;
count__31462_32352 = G__32467;
i__31463_32353 = G__32468;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__31542 = cljs.core.seq(node);
var chunk__31543 = null;
var count__31544 = (0);
var i__31545 = (0);
while(true){
if((i__31545 < count__31544)){
var n = chunk__31543.cljs$core$IIndexed$_nth$arity$2(null,i__31545);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__32558 = seq__31542;
var G__32559 = chunk__31543;
var G__32560 = count__31544;
var G__32561 = (i__31545 + (1));
seq__31542 = G__32558;
chunk__31543 = G__32559;
count__31544 = G__32560;
i__31545 = G__32561;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__31542);
if(temp__5735__auto__){
var seq__31542__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31542__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__31542__$1);
var G__32567 = cljs.core.chunk_rest(seq__31542__$1);
var G__32568 = c__4556__auto__;
var G__32569 = cljs.core.count(c__4556__auto__);
var G__32570 = (0);
seq__31542 = G__32567;
chunk__31543 = G__32568;
count__31544 = G__32569;
i__31545 = G__32570;
continue;
} else {
var n = cljs.core.first(seq__31542__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__32574 = cljs.core.next(seq__31542__$1);
var G__32575 = null;
var G__32576 = (0);
var G__32577 = (0);
seq__31542 = G__32574;
chunk__31543 = G__32575;
count__31544 = G__32576;
i__31545 = G__32577;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__31561 = arguments.length;
switch (G__31561) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__31570 = arguments.length;
switch (G__31570) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__31578 = arguments.length;
switch (G__31578) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___32608 = arguments.length;
var i__4737__auto___32610 = (0);
while(true){
if((i__4737__auto___32610 < len__4736__auto___32608)){
args__4742__auto__.push((arguments[i__4737__auto___32610]));

var G__32612 = (i__4737__auto___32610 + (1));
i__4737__auto___32610 = G__32612;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__31593_32618 = cljs.core.seq(nodes);
var chunk__31594_32619 = null;
var count__31595_32620 = (0);
var i__31596_32621 = (0);
while(true){
if((i__31596_32621 < count__31595_32620)){
var node_32623 = chunk__31594_32619.cljs$core$IIndexed$_nth$arity$2(null,i__31596_32621);
fragment.appendChild(shadow.dom._to_dom(node_32623));


var G__32625 = seq__31593_32618;
var G__32626 = chunk__31594_32619;
var G__32627 = count__31595_32620;
var G__32628 = (i__31596_32621 + (1));
seq__31593_32618 = G__32625;
chunk__31594_32619 = G__32626;
count__31595_32620 = G__32627;
i__31596_32621 = G__32628;
continue;
} else {
var temp__5735__auto___32629 = cljs.core.seq(seq__31593_32618);
if(temp__5735__auto___32629){
var seq__31593_32631__$1 = temp__5735__auto___32629;
if(cljs.core.chunked_seq_QMARK_(seq__31593_32631__$1)){
var c__4556__auto___32634 = cljs.core.chunk_first(seq__31593_32631__$1);
var G__32638 = cljs.core.chunk_rest(seq__31593_32631__$1);
var G__32639 = c__4556__auto___32634;
var G__32640 = cljs.core.count(c__4556__auto___32634);
var G__32641 = (0);
seq__31593_32618 = G__32638;
chunk__31594_32619 = G__32639;
count__31595_32620 = G__32640;
i__31596_32621 = G__32641;
continue;
} else {
var node_32644 = cljs.core.first(seq__31593_32631__$1);
fragment.appendChild(shadow.dom._to_dom(node_32644));


var G__32646 = cljs.core.next(seq__31593_32631__$1);
var G__32647 = null;
var G__32648 = (0);
var G__32649 = (0);
seq__31593_32618 = G__32646;
chunk__31594_32619 = G__32647;
count__31595_32620 = G__32648;
i__31596_32621 = G__32649;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq31587){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31587));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__31602_32653 = cljs.core.seq(scripts);
var chunk__31603_32654 = null;
var count__31604_32655 = (0);
var i__31605_32656 = (0);
while(true){
if((i__31605_32656 < count__31604_32655)){
var vec__31616_32660 = chunk__31603_32654.cljs$core$IIndexed$_nth$arity$2(null,i__31605_32656);
var script_tag_32661 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31616_32660,(0),null);
var script_body_32662 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31616_32660,(1),null);
eval(script_body_32662);


var G__32667 = seq__31602_32653;
var G__32668 = chunk__31603_32654;
var G__32669 = count__31604_32655;
var G__32670 = (i__31605_32656 + (1));
seq__31602_32653 = G__32667;
chunk__31603_32654 = G__32668;
count__31604_32655 = G__32669;
i__31605_32656 = G__32670;
continue;
} else {
var temp__5735__auto___32673 = cljs.core.seq(seq__31602_32653);
if(temp__5735__auto___32673){
var seq__31602_32674__$1 = temp__5735__auto___32673;
if(cljs.core.chunked_seq_QMARK_(seq__31602_32674__$1)){
var c__4556__auto___32675 = cljs.core.chunk_first(seq__31602_32674__$1);
var G__32676 = cljs.core.chunk_rest(seq__31602_32674__$1);
var G__32677 = c__4556__auto___32675;
var G__32678 = cljs.core.count(c__4556__auto___32675);
var G__32679 = (0);
seq__31602_32653 = G__32676;
chunk__31603_32654 = G__32677;
count__31604_32655 = G__32678;
i__31605_32656 = G__32679;
continue;
} else {
var vec__31622_32681 = cljs.core.first(seq__31602_32674__$1);
var script_tag_32682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31622_32681,(0),null);
var script_body_32683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31622_32681,(1),null);
eval(script_body_32683);


var G__32686 = cljs.core.next(seq__31602_32674__$1);
var G__32687 = null;
var G__32688 = (0);
var G__32689 = (0);
seq__31602_32653 = G__32686;
chunk__31603_32654 = G__32687;
count__31604_32655 = G__32688;
i__31605_32656 = G__32689;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__31627){
var vec__31628 = p__31627;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31628,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31628,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__31642 = arguments.length;
switch (G__31642) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__31653 = cljs.core.seq(style_keys);
var chunk__31654 = null;
var count__31655 = (0);
var i__31656 = (0);
while(true){
if((i__31656 < count__31655)){
var it = chunk__31654.cljs$core$IIndexed$_nth$arity$2(null,i__31656);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__32720 = seq__31653;
var G__32721 = chunk__31654;
var G__32722 = count__31655;
var G__32723 = (i__31656 + (1));
seq__31653 = G__32720;
chunk__31654 = G__32721;
count__31655 = G__32722;
i__31656 = G__32723;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__31653);
if(temp__5735__auto__){
var seq__31653__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__31653__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__31653__$1);
var G__32727 = cljs.core.chunk_rest(seq__31653__$1);
var G__32728 = c__4556__auto__;
var G__32729 = cljs.core.count(c__4556__auto__);
var G__32730 = (0);
seq__31653 = G__32727;
chunk__31654 = G__32728;
count__31655 = G__32729;
i__31656 = G__32730;
continue;
} else {
var it = cljs.core.first(seq__31653__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__32731 = cljs.core.next(seq__31653__$1);
var G__32732 = null;
var G__32733 = (0);
var G__32734 = (0);
seq__31653 = G__32731;
chunk__31654 = G__32732;
count__31655 = G__32733;
i__31656 = G__32734;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31660,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31665 = k31660;
var G__31665__$1 = (((G__31665 instanceof cljs.core.Keyword))?G__31665.fqn:null);
switch (G__31665__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31660,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31667){
var vec__31670 = p__31667;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31670,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31670,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31659){
var self__ = this;
var G__31659__$1 = this;
return (new cljs.core.RecordIter((0),G__31659__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31661,other31662){
var self__ = this;
var this31661__$1 = this;
return (((!((other31662 == null)))) && ((this31661__$1.constructor === other31662.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31661__$1.x,other31662.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31661__$1.y,other31662.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31661__$1.__extmap,other31662.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31659){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31696 = cljs.core.keyword_identical_QMARK_;
var expr__31697 = k__4388__auto__;
if(cljs.core.truth_((pred__31696.cljs$core$IFn$_invoke$arity$2 ? pred__31696.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__31697) : pred__31696.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__31697)))){
return (new shadow.dom.Coordinate(G__31659,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31696.cljs$core$IFn$_invoke$arity$2 ? pred__31696.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__31697) : pred__31696.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__31697)))){
return (new shadow.dom.Coordinate(self__.x,G__31659,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31659),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31659){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__31659,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__31664){
var extmap__4419__auto__ = (function (){var G__31713 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31664,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__31664)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31713);
} else {
return G__31713;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__31664),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__31664),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31725,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31737 = k31725;
var G__31737__$1 = (((G__31737 instanceof cljs.core.Keyword))?G__31737.fqn:null);
switch (G__31737__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31725,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31742){
var vec__31746 = p__31742;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31746,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31746,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31724){
var self__ = this;
var G__31724__$1 = this;
return (new cljs.core.RecordIter((0),G__31724__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31726,other31727){
var self__ = this;
var this31726__$1 = this;
return (((!((other31727 == null)))) && ((this31726__$1.constructor === other31727.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31726__$1.w,other31727.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31726__$1.h,other31727.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31726__$1.__extmap,other31727.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31724){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31770 = cljs.core.keyword_identical_QMARK_;
var expr__31771 = k__4388__auto__;
if(cljs.core.truth_((pred__31770.cljs$core$IFn$_invoke$arity$2 ? pred__31770.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__31771) : pred__31770.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__31771)))){
return (new shadow.dom.Size(G__31724,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31770.cljs$core$IFn$_invoke$arity$2 ? pred__31770.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__31771) : pred__31770.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__31771)))){
return (new shadow.dom.Size(self__.w,G__31724,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31724),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31724){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__31724,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__31729){
var extmap__4419__auto__ = (function (){var G__31791 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31729,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__31729)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31791);
} else {
return G__31791;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__31729),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__31729),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__32849 = (i + (1));
var G__32850 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__32849;
ret = G__32850;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__31814){
var vec__31815 = p__31814;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31815,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31815,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__31819 = arguments.length;
switch (G__31819) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__32883 = ps;
var G__32884 = (i + (1));
el__$1 = G__32883;
i = G__32884;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__31870 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31870,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31870,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31870,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__31874_32962 = cljs.core.seq(props);
var chunk__31875_32963 = null;
var count__31876_32964 = (0);
var i__31877_32965 = (0);
while(true){
if((i__31877_32965 < count__31876_32964)){
var vec__31890_32968 = chunk__31875_32963.cljs$core$IIndexed$_nth$arity$2(null,i__31877_32965);
var k_32969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31890_32968,(0),null);
var v_32970 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31890_32968,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_32969);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_32969),v_32970);


var G__32975 = seq__31874_32962;
var G__32976 = chunk__31875_32963;
var G__32977 = count__31876_32964;
var G__32978 = (i__31877_32965 + (1));
seq__31874_32962 = G__32975;
chunk__31875_32963 = G__32976;
count__31876_32964 = G__32977;
i__31877_32965 = G__32978;
continue;
} else {
var temp__5735__auto___32986 = cljs.core.seq(seq__31874_32962);
if(temp__5735__auto___32986){
var seq__31874_32987__$1 = temp__5735__auto___32986;
if(cljs.core.chunked_seq_QMARK_(seq__31874_32987__$1)){
var c__4556__auto___32990 = cljs.core.chunk_first(seq__31874_32987__$1);
var G__32991 = cljs.core.chunk_rest(seq__31874_32987__$1);
var G__32992 = c__4556__auto___32990;
var G__32993 = cljs.core.count(c__4556__auto___32990);
var G__32994 = (0);
seq__31874_32962 = G__32991;
chunk__31875_32963 = G__32992;
count__31876_32964 = G__32993;
i__31877_32965 = G__32994;
continue;
} else {
var vec__31893_32995 = cljs.core.first(seq__31874_32987__$1);
var k_32996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31893_32995,(0),null);
var v_32997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31893_32995,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_32996);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_32996),v_32997);


var G__33009 = cljs.core.next(seq__31874_32987__$1);
var G__33010 = null;
var G__33011 = (0);
var G__33012 = (0);
seq__31874_32962 = G__33009;
chunk__31875_32963 = G__33010;
count__31876_32964 = G__33011;
i__31877_32965 = G__33012;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__31915 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31915,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31915,(1),null);
var seq__31919_33021 = cljs.core.seq(node_children);
var chunk__31921_33022 = null;
var count__31922_33023 = (0);
var i__31923_33024 = (0);
while(true){
if((i__31923_33024 < count__31922_33023)){
var child_struct_33027 = chunk__31921_33022.cljs$core$IIndexed$_nth$arity$2(null,i__31923_33024);
if((!((child_struct_33027 == null)))){
if(typeof child_struct_33027 === 'string'){
var text_33031 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_33031),child_struct_33027].join(''));
} else {
var children_33033 = shadow.dom.svg_node(child_struct_33027);
if(cljs.core.seq_QMARK_(children_33033)){
var seq__31983_33034 = cljs.core.seq(children_33033);
var chunk__31985_33035 = null;
var count__31986_33036 = (0);
var i__31987_33037 = (0);
while(true){
if((i__31987_33037 < count__31986_33036)){
var child_33041 = chunk__31985_33035.cljs$core$IIndexed$_nth$arity$2(null,i__31987_33037);
if(cljs.core.truth_(child_33041)){
node.appendChild(child_33041);


var G__33044 = seq__31983_33034;
var G__33045 = chunk__31985_33035;
var G__33046 = count__31986_33036;
var G__33047 = (i__31987_33037 + (1));
seq__31983_33034 = G__33044;
chunk__31985_33035 = G__33045;
count__31986_33036 = G__33046;
i__31987_33037 = G__33047;
continue;
} else {
var G__33066 = seq__31983_33034;
var G__33067 = chunk__31985_33035;
var G__33068 = count__31986_33036;
var G__33069 = (i__31987_33037 + (1));
seq__31983_33034 = G__33066;
chunk__31985_33035 = G__33067;
count__31986_33036 = G__33068;
i__31987_33037 = G__33069;
continue;
}
} else {
var temp__5735__auto___33070 = cljs.core.seq(seq__31983_33034);
if(temp__5735__auto___33070){
var seq__31983_33071__$1 = temp__5735__auto___33070;
if(cljs.core.chunked_seq_QMARK_(seq__31983_33071__$1)){
var c__4556__auto___33072 = cljs.core.chunk_first(seq__31983_33071__$1);
var G__33075 = cljs.core.chunk_rest(seq__31983_33071__$1);
var G__33076 = c__4556__auto___33072;
var G__33077 = cljs.core.count(c__4556__auto___33072);
var G__33078 = (0);
seq__31983_33034 = G__33075;
chunk__31985_33035 = G__33076;
count__31986_33036 = G__33077;
i__31987_33037 = G__33078;
continue;
} else {
var child_33079 = cljs.core.first(seq__31983_33071__$1);
if(cljs.core.truth_(child_33079)){
node.appendChild(child_33079);


var G__33081 = cljs.core.next(seq__31983_33071__$1);
var G__33082 = null;
var G__33083 = (0);
var G__33084 = (0);
seq__31983_33034 = G__33081;
chunk__31985_33035 = G__33082;
count__31986_33036 = G__33083;
i__31987_33037 = G__33084;
continue;
} else {
var G__33085 = cljs.core.next(seq__31983_33071__$1);
var G__33086 = null;
var G__33087 = (0);
var G__33088 = (0);
seq__31983_33034 = G__33085;
chunk__31985_33035 = G__33086;
count__31986_33036 = G__33087;
i__31987_33037 = G__33088;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_33033);
}
}


var G__33090 = seq__31919_33021;
var G__33091 = chunk__31921_33022;
var G__33092 = count__31922_33023;
var G__33093 = (i__31923_33024 + (1));
seq__31919_33021 = G__33090;
chunk__31921_33022 = G__33091;
count__31922_33023 = G__33092;
i__31923_33024 = G__33093;
continue;
} else {
var G__33095 = seq__31919_33021;
var G__33096 = chunk__31921_33022;
var G__33097 = count__31922_33023;
var G__33098 = (i__31923_33024 + (1));
seq__31919_33021 = G__33095;
chunk__31921_33022 = G__33096;
count__31922_33023 = G__33097;
i__31923_33024 = G__33098;
continue;
}
} else {
var temp__5735__auto___33100 = cljs.core.seq(seq__31919_33021);
if(temp__5735__auto___33100){
var seq__31919_33101__$1 = temp__5735__auto___33100;
if(cljs.core.chunked_seq_QMARK_(seq__31919_33101__$1)){
var c__4556__auto___33102 = cljs.core.chunk_first(seq__31919_33101__$1);
var G__33103 = cljs.core.chunk_rest(seq__31919_33101__$1);
var G__33104 = c__4556__auto___33102;
var G__33105 = cljs.core.count(c__4556__auto___33102);
var G__33106 = (0);
seq__31919_33021 = G__33103;
chunk__31921_33022 = G__33104;
count__31922_33023 = G__33105;
i__31923_33024 = G__33106;
continue;
} else {
var child_struct_33108 = cljs.core.first(seq__31919_33101__$1);
if((!((child_struct_33108 == null)))){
if(typeof child_struct_33108 === 'string'){
var text_33109 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_33109),child_struct_33108].join(''));
} else {
var children_33110 = shadow.dom.svg_node(child_struct_33108);
if(cljs.core.seq_QMARK_(children_33110)){
var seq__32020_33111 = cljs.core.seq(children_33110);
var chunk__32022_33112 = null;
var count__32023_33113 = (0);
var i__32024_33114 = (0);
while(true){
if((i__32024_33114 < count__32023_33113)){
var child_33115 = chunk__32022_33112.cljs$core$IIndexed$_nth$arity$2(null,i__32024_33114);
if(cljs.core.truth_(child_33115)){
node.appendChild(child_33115);


var G__33116 = seq__32020_33111;
var G__33117 = chunk__32022_33112;
var G__33118 = count__32023_33113;
var G__33119 = (i__32024_33114 + (1));
seq__32020_33111 = G__33116;
chunk__32022_33112 = G__33117;
count__32023_33113 = G__33118;
i__32024_33114 = G__33119;
continue;
} else {
var G__33121 = seq__32020_33111;
var G__33122 = chunk__32022_33112;
var G__33123 = count__32023_33113;
var G__33124 = (i__32024_33114 + (1));
seq__32020_33111 = G__33121;
chunk__32022_33112 = G__33122;
count__32023_33113 = G__33123;
i__32024_33114 = G__33124;
continue;
}
} else {
var temp__5735__auto___33125__$1 = cljs.core.seq(seq__32020_33111);
if(temp__5735__auto___33125__$1){
var seq__32020_33126__$1 = temp__5735__auto___33125__$1;
if(cljs.core.chunked_seq_QMARK_(seq__32020_33126__$1)){
var c__4556__auto___33127 = cljs.core.chunk_first(seq__32020_33126__$1);
var G__33128 = cljs.core.chunk_rest(seq__32020_33126__$1);
var G__33129 = c__4556__auto___33127;
var G__33130 = cljs.core.count(c__4556__auto___33127);
var G__33131 = (0);
seq__32020_33111 = G__33128;
chunk__32022_33112 = G__33129;
count__32023_33113 = G__33130;
i__32024_33114 = G__33131;
continue;
} else {
var child_33132 = cljs.core.first(seq__32020_33126__$1);
if(cljs.core.truth_(child_33132)){
node.appendChild(child_33132);


var G__33138 = cljs.core.next(seq__32020_33126__$1);
var G__33139 = null;
var G__33140 = (0);
var G__33141 = (0);
seq__32020_33111 = G__33138;
chunk__32022_33112 = G__33139;
count__32023_33113 = G__33140;
i__32024_33114 = G__33141;
continue;
} else {
var G__33142 = cljs.core.next(seq__32020_33126__$1);
var G__33143 = null;
var G__33144 = (0);
var G__33145 = (0);
seq__32020_33111 = G__33142;
chunk__32022_33112 = G__33143;
count__32023_33113 = G__33144;
i__32024_33114 = G__33145;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_33110);
}
}


var G__33146 = cljs.core.next(seq__31919_33101__$1);
var G__33147 = null;
var G__33148 = (0);
var G__33149 = (0);
seq__31919_33021 = G__33146;
chunk__31921_33022 = G__33147;
count__31922_33023 = G__33148;
i__31923_33024 = G__33149;
continue;
} else {
var G__33151 = cljs.core.next(seq__31919_33101__$1);
var G__33152 = null;
var G__33153 = (0);
var G__33154 = (0);
seq__31919_33021 = G__33151;
chunk__31921_33022 = G__33152;
count__31922_33023 = G__33153;
i__31923_33024 = G__33154;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33161 = arguments.length;
var i__4737__auto___33162 = (0);
while(true){
if((i__4737__auto___33162 < len__4736__auto___33161)){
args__4742__auto__.push((arguments[i__4737__auto___33162]));

var G__33163 = (i__4737__auto___33162 + (1));
i__4737__auto___33162 = G__33163;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq32049){
var G__32050 = cljs.core.first(seq32049);
var seq32049__$1 = cljs.core.next(seq32049);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32050,seq32049__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__32065 = arguments.length;
switch (G__32065) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__28251__auto___33178 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28252__auto__ = (function (){var switch__28097__auto__ = (function (state_32072){
var state_val_32073 = (state_32072[(1)]);
if((state_val_32073 === (1))){
var state_32072__$1 = state_32072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32072__$1,(2),once_or_cleanup);
} else {
if((state_val_32073 === (2))){
var inst_32069 = (state_32072[(2)]);
var inst_32070 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_32072__$1 = (function (){var statearr_32077 = state_32072;
(statearr_32077[(7)] = inst_32069);

return statearr_32077;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32072__$1,inst_32070);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__28098__auto__ = null;
var shadow$dom$state_machine__28098__auto____0 = (function (){
var statearr_32079 = [null,null,null,null,null,null,null,null];
(statearr_32079[(0)] = shadow$dom$state_machine__28098__auto__);

(statearr_32079[(1)] = (1));

return statearr_32079;
});
var shadow$dom$state_machine__28098__auto____1 = (function (state_32072){
while(true){
var ret_value__28099__auto__ = (function (){try{while(true){
var result__28100__auto__ = switch__28097__auto__(state_32072);
if(cljs.core.keyword_identical_QMARK_(result__28100__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28100__auto__;
}
break;
}
}catch (e32080){var ex__28101__auto__ = e32080;
var statearr_32081_33181 = state_32072;
(statearr_32081_33181[(2)] = ex__28101__auto__);


if(cljs.core.seq((state_32072[(4)]))){
var statearr_32082_33182 = state_32072;
(statearr_32082_33182[(1)] = cljs.core.first((state_32072[(4)])));

} else {
throw ex__28101__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28099__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33183 = state_32072;
state_32072 = G__33183;
continue;
} else {
return ret_value__28099__auto__;
}
break;
}
});
shadow$dom$state_machine__28098__auto__ = function(state_32072){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__28098__auto____0.call(this);
case 1:
return shadow$dom$state_machine__28098__auto____1.call(this,state_32072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__28098__auto____0;
shadow$dom$state_machine__28098__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__28098__auto____1;
return shadow$dom$state_machine__28098__auto__;
})()
})();
var state__28253__auto__ = (function (){var statearr_32083 = f__28252__auto__();
(statearr_32083[(6)] = c__28251__auto___33178);

return statearr_32083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28253__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
