goog.provide('membrane.ui');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Font = (function (name,size,weight,width,slant,__meta,__extmap,__hash){
this.name = name;
this.size = size;
this.weight = weight;
this.width = width;
this.slant = slant;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Font.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Font.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k29717,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__29803 = k29717;
var G__29803__$1 = (((G__29803 instanceof cljs.core.Keyword))?G__29803.fqn:null);
switch (G__29803__$1) {
case "name":
return self__.name;

break;
case "size":
return self__.size;

break;
case "weight":
return self__.weight;

break;
case "width":
return self__.width;

break;
case "slant":
return self__.slant;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k29717,else__4383__auto__);

}
}));

(membrane.ui.Font.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__29837){
var vec__29841 = p__29837;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29841,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29841,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Font.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Font{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"name","name",1843675177),self__.name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"weight","weight",-1262796205),self__.weight],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"width","width",-384071477),self__.width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"slant","slant",1122551990),self__.slant],null))], null),self__.__extmap));
}));

(membrane.ui.Font.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__29716){
var self__ = this;
var G__29716__$1 = this;
return (new cljs.core.RecordIter((0),G__29716__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"weight","weight",-1262796205),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"slant","slant",1122551990)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Font.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Font.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Font.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Font.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (633017093 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Font.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this29718,other29719){
var self__ = this;
var this29718__$1 = this;
return (((!((other29719 == null)))) && ((this29718__$1.constructor === other29719.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29718__$1.name,other29719.name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29718__$1.size,other29719.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29718__$1.weight,other29719.weight)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29718__$1.width,other29719.width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29718__$1.slant,other29719.slant)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this29718__$1.__extmap,other29719.__extmap)));
}));

(membrane.ui.Font.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"weight","weight",-1262796205),null,new cljs.core.Keyword(null,"slant","slant",1122551990),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Font.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__29716){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__29920 = cljs.core.keyword_identical_QMARK_;
var expr__29921 = k__4388__auto__;
if(cljs.core.truth_((pred__29920.cljs$core$IFn$_invoke$arity$2 ? pred__29920.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177),expr__29921) : pred__29920.call(null,new cljs.core.Keyword(null,"name","name",1843675177),expr__29921)))){
return (new membrane.ui.Font(G__29716,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__29920.cljs$core$IFn$_invoke$arity$2 ? pred__29920.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),expr__29921) : pred__29920.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__29921)))){
return (new membrane.ui.Font(self__.name,G__29716,self__.weight,self__.width,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__29920.cljs$core$IFn$_invoke$arity$2 ? pred__29920.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"weight","weight",-1262796205),expr__29921) : pred__29920.call(null,new cljs.core.Keyword(null,"weight","weight",-1262796205),expr__29921)))){
return (new membrane.ui.Font(self__.name,self__.size,G__29716,self__.width,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__29920.cljs$core$IFn$_invoke$arity$2 ? pred__29920.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"width","width",-384071477),expr__29921) : pred__29920.call(null,new cljs.core.Keyword(null,"width","width",-384071477),expr__29921)))){
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,G__29716,self__.slant,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__29920.cljs$core$IFn$_invoke$arity$2 ? pred__29920.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"slant","slant",1122551990),expr__29921) : pred__29920.call(null,new cljs.core.Keyword(null,"slant","slant",1122551990),expr__29921)))){
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,G__29716,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__29716),null));
}
}
}
}
}
}));

(membrane.ui.Font.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"name","name",1843675177),self__.name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"weight","weight",-1262796205),self__.weight,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"width","width",-384071477),self__.width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"slant","slant",1122551990),self__.slant,null))], null),self__.__extmap));
}));

(membrane.ui.Font.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__29716){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Font(self__.name,self__.size,self__.weight,self__.width,self__.slant,G__29716,self__.__extmap,self__.__hash));
}));

(membrane.ui.Font.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Font.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"weight","weight",377735322,null),new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"slant","slant",-1531883779,null)], null);
}));

(membrane.ui.Font.cljs$lang$type = true);

(membrane.ui.Font.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Font",null,(1),null));
}));

(membrane.ui.Font.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Font");
}));

/**
 * Positional factory function for membrane.ui/Font.
 */
membrane.ui.__GT_Font = (function membrane$ui$__GT_Font(name,size,weight,width,slant){
return (new membrane.ui.Font(name,size,weight,width,slant,null,null,null));
});

/**
 * Factory function for membrane.ui/Font, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Font = (function membrane$ui$map__GT_Font(G__29726){
var extmap__4419__auto__ = (function (){var G__29978 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__29726,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"weight","weight",-1262796205),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"slant","slant",1122551990)], 0));
if(cljs.core.record_QMARK_(G__29726)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__29978);
} else {
return G__29978;
}
})();
return (new membrane.ui.Font(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(G__29726),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__29726),new cljs.core.Keyword(null,"weight","weight",-1262796205).cljs$core$IFn$_invoke$arity$1(G__29726),new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(G__29726),new cljs.core.Keyword(null,"slant","slant",1122551990).cljs$core$IFn$_invoke$arity$1(G__29726),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.default_font = (new membrane.ui.Font(null,(14),null,null,null,null,null,null));
/**
 * Creates a font.
 * 
 *   `name`: Should be the path to a font file on desktop. If nil, use the default font.
 *   `size`: Size of the font. If nil, use the default font size.
 */
membrane.ui.font = (function membrane$ui$font(name,size){
return (new membrane.ui.Font((cljs.core.truth_(name)?name:membrane.ui.default_font.name),(cljs.core.truth_(size)?size:membrane.ui.default_font.size),membrane.ui.default_font.weight,membrane.ui.default_font.width,membrane.ui.default_font.slant,null,null,null));
});

/**
 * @interface
 */
membrane.ui.IMouseMove = function(){};

var membrane$ui$IMouseMove$_mouse_move$dyn_32870 = (function (elem,pos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_move[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4429__auto__.call(null,elem,pos));
} else {
var m__4426__auto__ = (membrane.ui._mouse_move["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4426__auto__.call(null,elem,pos));
} else {
throw cljs.core.missing_protocol("IMouseMove.-mouse-move",elem);
}
}
});
membrane.ui._mouse_move = (function membrane$ui$_mouse_move(elem,pos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseMove$_mouse_move$arity$2 == null)))))){
return elem.membrane$ui$IMouseMove$_mouse_move$arity$2(elem,pos);
} else {
return membrane$ui$IMouseMove$_mouse_move$dyn_32870(elem,pos);
}
});


/**
 * @interface
 */
membrane.ui.IMouseMoveGlobal = function(){};

var membrane$ui$IMouseMoveGlobal$_mouse_move_global$dyn_32883 = (function (elem,pos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_move_global[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4429__auto__.call(null,elem,pos));
} else {
var m__4426__auto__ = (membrane.ui._mouse_move_global["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,pos) : m__4426__auto__.call(null,elem,pos));
} else {
throw cljs.core.missing_protocol("IMouseMoveGlobal.-mouse-move-global",elem);
}
}
});
membrane.ui._mouse_move_global = (function membrane$ui$_mouse_move_global(elem,pos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 == null)))))){
return elem.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2(elem,pos);
} else {
return membrane$ui$IMouseMoveGlobal$_mouse_move_global$dyn_32883(elem,pos);
}
});


/**
 * @interface
 */
membrane.ui.IMouseEvent = function(){};

var membrane$ui$IMouseEvent$_mouse_event$dyn_32896 = (function (elem,pos,button,mouse_down_QMARK_,mods){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$5(elem,pos,button,mouse_down_QMARK_,mods) : m__4429__auto__.call(null,elem,pos,button,mouse_down_QMARK_,mods));
} else {
var m__4426__auto__ = (membrane.ui._mouse_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$5(elem,pos,button,mouse_down_QMARK_,mods) : m__4426__auto__.call(null,elem,pos,button,mouse_down_QMARK_,mods));
} else {
throw cljs.core.missing_protocol("IMouseEvent.-mouse-event",elem);
}
}
});
membrane.ui._mouse_event = (function membrane$ui$_mouse_event(elem,pos,button,mouse_down_QMARK_,mods){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseEvent$_mouse_event$arity$5 == null)))))){
return elem.membrane$ui$IMouseEvent$_mouse_event$arity$5(elem,pos,button,mouse_down_QMARK_,mods);
} else {
return membrane$ui$IMouseEvent$_mouse_event$dyn_32896(elem,pos,button,mouse_down_QMARK_,mods);
}
});


/**
 * @interface
 */
membrane.ui.IDrop = function(){};

var membrane$ui$IDrop$_drop$dyn_32924 = (function (elem,paths,pos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._drop[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(elem,paths,pos) : m__4429__auto__.call(null,elem,paths,pos));
} else {
var m__4426__auto__ = (membrane.ui._drop["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(elem,paths,pos) : m__4426__auto__.call(null,elem,paths,pos));
} else {
throw cljs.core.missing_protocol("IDrop.-drop",elem);
}
}
});
membrane.ui._drop = (function membrane$ui$_drop(elem,paths,pos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IDrop$_drop$arity$3 == null)))))){
return elem.membrane$ui$IDrop$_drop$arity$3(elem,paths,pos);
} else {
return membrane$ui$IDrop$_drop$dyn_32924(elem,paths,pos);
}
});


/**
 * @interface
 */
membrane.ui.IScroll = function(){};

var membrane$ui$IScroll$_scroll$dyn_32926 = (function (elem,delta,mpos){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._scroll[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(elem,delta,mpos) : m__4429__auto__.call(null,elem,delta,mpos));
} else {
var m__4426__auto__ = (membrane.ui._scroll["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(elem,delta,mpos) : m__4426__auto__.call(null,elem,delta,mpos));
} else {
throw cljs.core.missing_protocol("IScroll.-scroll",elem);
}
}
});
membrane.ui._scroll = (function membrane$ui$_scroll(elem,delta,mpos){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IScroll$_scroll$arity$3 == null)))))){
return elem.membrane$ui$IScroll$_scroll$arity$3(elem,delta,mpos);
} else {
return membrane$ui$IScroll$_scroll$dyn_32926(elem,delta,mpos);
}
});


/**
 * @interface
 */
membrane.ui.IMouseWheel = function(){};

var membrane$ui$IMouseWheel$_mouse_wheel$dyn_32927 = (function (elem,delta){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._mouse_wheel[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,delta) : m__4429__auto__.call(null,elem,delta));
} else {
var m__4426__auto__ = (membrane.ui._mouse_wheel["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,delta) : m__4426__auto__.call(null,elem,delta));
} else {
throw cljs.core.missing_protocol("IMouseWheel.-mouse-wheel",elem);
}
}
});
membrane.ui._mouse_wheel = (function membrane$ui$_mouse_wheel(elem,delta){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IMouseWheel$_mouse_wheel$arity$2 == null)))))){
return elem.membrane$ui$IMouseWheel$_mouse_wheel$arity$2(elem,delta);
} else {
return membrane$ui$IMouseWheel$_mouse_wheel$dyn_32927(elem,delta);
}
});


/**
 * @interface
 */
membrane.ui.IKeyPress = function(){};

var membrane$ui$IKeyPress$_key_press$dyn_32939 = (function (elem,key){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._key_press[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4429__auto__.call(null,elem,key));
} else {
var m__4426__auto__ = (membrane.ui._key_press["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4426__auto__.call(null,elem,key));
} else {
throw cljs.core.missing_protocol("IKeyPress.-key-press",elem);
}
}
});
membrane.ui._key_press = (function membrane$ui$_key_press(elem,key){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IKeyPress$_key_press$arity$2 == null)))))){
return elem.membrane$ui$IKeyPress$_key_press$arity$2(elem,key);
} else {
return membrane$ui$IKeyPress$_key_press$dyn_32939(elem,key);
}
});


/**
 * @interface
 */
membrane.ui.IKeyType = function(){};

var membrane$ui$IKeyType$_key_type$dyn_32950 = (function (elem,key){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._key_type[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4429__auto__.call(null,elem,key));
} else {
var m__4426__auto__ = (membrane.ui._key_type["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,key) : m__4426__auto__.call(null,elem,key));
} else {
throw cljs.core.missing_protocol("IKeyType.-key-type",elem);
}
}
});
membrane.ui._key_type = (function membrane$ui$_key_type(elem,key){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IKeyType$_key_type$arity$2 == null)))))){
return elem.membrane$ui$IKeyType$_key_type$arity$2(elem,key);
} else {
return membrane$ui$IKeyType$_key_type$dyn_32950(elem,key);
}
});


/**
 * @interface
 */
membrane.ui.IClipboardPaste = function(){};

var membrane$ui$IClipboardPaste$_clipboard_paste$dyn_32953 = (function (elem,contents){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._clipboard_paste[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(elem,contents) : m__4429__auto__.call(null,elem,contents));
} else {
var m__4426__auto__ = (membrane.ui._clipboard_paste["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(elem,contents) : m__4426__auto__.call(null,elem,contents));
} else {
throw cljs.core.missing_protocol("IClipboardPaste.-clipboard-paste",elem);
}
}
});
membrane.ui._clipboard_paste = (function membrane$ui$_clipboard_paste(elem,contents){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2 == null)))))){
return elem.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2(elem,contents);
} else {
return membrane$ui$IClipboardPaste$_clipboard_paste$dyn_32953(elem,contents);
}
});


/**
 * @interface
 */
membrane.ui.IClipboardCopy = function(){};

var membrane$ui$IClipboardCopy$_clipboard_copy$dyn_32964 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._clipboard_copy[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._clipboard_copy["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IClipboardCopy.-clipboard-copy",elem);
}
}
});
membrane.ui._clipboard_copy = (function membrane$ui$_clipboard_copy(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1 == null)))))){
return elem.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1(elem);
} else {
return membrane$ui$IClipboardCopy$_clipboard_copy$dyn_32964(elem);
}
});


/**
 * @interface
 */
membrane.ui.IClipboardCut = function(){};

var membrane$ui$IClipboardCut$_clipboard_cut$dyn_32972 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._clipboard_cut[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._clipboard_cut["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IClipboardCut.-clipboard-cut",elem);
}
}
});
membrane.ui._clipboard_cut = (function membrane$ui$_clipboard_cut(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IClipboardCut$_clipboard_cut$arity$1 == null)))))){
return elem.membrane$ui$IClipboardCut$_clipboard_cut$arity$1(elem);
} else {
return membrane$ui$IClipboardCut$_clipboard_cut$dyn_32972(elem);
}
});


/**
 * @interface
 */
membrane.ui.IMakeNode = function(){};

var membrane$ui$IMakeNode$make_node$dyn_32982 = (function (node,childs){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (membrane.ui.make_node[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(node,childs) : m__4429__auto__.call(null,node,childs));
} else {
var m__4426__auto__ = (membrane.ui.make_node["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(node,childs) : m__4426__auto__.call(null,node,childs));
} else {
throw cljs.core.missing_protocol("IMakeNode.make-node",node);
}
}
});
membrane.ui.make_node = (function membrane$ui$make_node(node,childs){
if((((!((node == null)))) && ((!((node.membrane$ui$IMakeNode$make_node$arity$2 == null)))))){
return node.membrane$ui$IMakeNode$make_node$arity$2(node,childs);
} else {
return membrane$ui$IMakeNode$make_node$dyn_32982(node,childs);
}
});

(cljs.core.PersistentVector.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (node,childs){
var node__$1 = this;
return cljs.core.vec(childs);
}));

/**
 * @interface
 */
membrane.ui.IOrigin = function(){};

var membrane$ui$IOrigin$_origin$dyn_32995 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._origin[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._origin["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IOrigin.-origin",elem);
}
}
});
/**
 * Specifies the top left corner of a component's bounds
 * 
 *   The origin is vector or 2 numbers [x, y]
 */
membrane.ui._origin = (function membrane$ui$_origin(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IOrigin$_origin$arity$1 == null)))))){
return elem.membrane$ui$IOrigin$_origin$arity$1(elem);
} else {
return membrane$ui$IOrigin$_origin$dyn_32995(elem);
}
});

(cljs.core.PersistentVector.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

goog.object.set(membrane.ui.IOrigin,"null",true);

goog.object.set(membrane.ui._origin,"null",(function (this$){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));
/**
 * Specifies the top left corner of a component's bounds
 * 
 *   The origin is vector or 2 numbers [x, y]
 */
membrane.ui.origin = (function membrane$ui$origin(elem){
return membrane.ui._origin(elem);
});
/**
 * Convience function for returning the x coordinate of elem's origin
 */
membrane.ui.origin_x = (function membrane$ui$origin_x(elem){
return cljs.core.first(membrane.ui.origin(elem));
});
/**
 * Convience function for returning the y coordinate of elem's origin
 */
membrane.ui.origin_y = (function membrane$ui$origin_y(elem){
return cljs.core.second(membrane.ui.origin(elem));
});

/**
 * @interface
 */
membrane.ui.IKeyEvent = function(){};

var membrane$ui$IKeyEvent$_key_event$dyn_32999 = (function (this$,key,scancode,action,mods){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui._key_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$5(this$,key,scancode,action,mods) : m__4429__auto__.call(null,this$,key,scancode,action,mods));
} else {
var m__4426__auto__ = (membrane.ui._key_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$5(this$,key,scancode,action,mods) : m__4426__auto__.call(null,this$,key,scancode,action,mods));
} else {
throw cljs.core.missing_protocol("IKeyEvent.-key-event",this$);
}
}
});
membrane.ui._key_event = (function membrane$ui$_key_event(this$,key,scancode,action,mods){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IKeyEvent$_key_event$arity$5 == null)))))){
return this$.membrane$ui$IKeyEvent$_key_event$arity$5(this$,key,scancode,action,mods);
} else {
return membrane$ui$IKeyEvent$_key_event$dyn_32999(this$,key,scancode,action,mods);
}
});


/**
 * @interface
 */
membrane.ui.IHasKeyEvent = function(){};

var membrane$ui$IHasKeyEvent$has_key_event$dyn_33003 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui.has_key_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (membrane.ui.has_key_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IHasKeyEvent.has-key-event",this$);
}
}
});
membrane.ui.has_key_event = (function membrane$ui$has_key_event(this$){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHasKeyEvent$has_key_event$arity$1 == null)))))){
return this$.membrane$ui$IHasKeyEvent$has_key_event$arity$1(this$);
} else {
return membrane$ui$IHasKeyEvent$has_key_event$dyn_33003(this$);
}
});


/**
 * @interface
 */
membrane.ui.IHasKeyPress = function(){};

var membrane$ui$IHasKeyPress$has_key_press$dyn_33007 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui.has_key_press[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (membrane.ui.has_key_press["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IHasKeyPress.has-key-press",this$);
}
}
});
membrane.ui.has_key_press = (function membrane$ui$has_key_press(this$){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHasKeyPress$has_key_press$arity$1 == null)))))){
return this$.membrane$ui$IHasKeyPress$has_key_press$arity$1(this$);
} else {
return membrane$ui$IHasKeyPress$has_key_press$dyn_33007(this$);
}
});


/**
 * @interface
 */
membrane.ui.IHasMouseMoveGlobal = function(){};

var membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$dyn_33014 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui.has_mouse_move_global[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (membrane.ui.has_mouse_move_global["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IHasMouseMoveGlobal.has-mouse-move-global",this$);
}
}
});
membrane.ui.has_mouse_move_global = (function membrane$ui$has_mouse_move_global(this$){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$arity$1 == null)))))){
return this$.membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$arity$1(this$);
} else {
return membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$dyn_33014(this$);
}
});


/**
 * Allows an element add, remove, modify effects emitted from its children.
 * @interface
 */
membrane.ui.IBubble = function(){};

var membrane$ui$IBubble$_bubble$dyn_33017 = (function (_,effects){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (membrane.ui._bubble[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(_,effects) : m__4429__auto__.call(null,_,effects));
} else {
var m__4426__auto__ = (membrane.ui._bubble["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(_,effects) : m__4426__auto__.call(null,_,effects));
} else {
throw cljs.core.missing_protocol("IBubble.-bubble",_);
}
}
});
/**
 * Called when an effect is being emitted by a child element. The parent element can either return the same effects or allow them to continue to bubble.
 */
membrane.ui._bubble = (function membrane$ui$_bubble(_,effects){
if((((!((_ == null)))) && ((!((_.membrane$ui$IBubble$_bubble$arity$2 == null)))))){
return _.membrane$ui$IBubble$_bubble$arity$2(_,effects);
} else {
return membrane$ui$IBubble$_bubble$dyn_33017(_,effects);
}
});

goog.object.set(membrane.ui.IHasKeyPress,"null",true);

goog.object.set(membrane.ui.has_key_press,"null",(function (this$){
return false;
}));

goog.object.set(membrane.ui.IHasMouseMoveGlobal,"null",true);

goog.object.set(membrane.ui.has_mouse_move_global,"null",(function (this$){
return false;
}));

goog.object.set(membrane.ui.IScroll,"null",true);

goog.object.set(membrane.ui._scroll,"null",(function (elem,offset,local_pos){
return null;
}));

goog.object.set(membrane.ui.IMouseEvent,"null",true);

goog.object.set(membrane.ui._mouse_event,"null",(function (elem,local_pos,button,mouse_down_QMARK_,mods){
return null;
}));

goog.object.set(membrane.ui.IKeyEvent,"null",true);

goog.object.set(membrane.ui._key_event,"null",(function (this$,key,scancode,action,mods){
return null;
}));

goog.object.set(membrane.ui.IKeyPress,"null",true);

goog.object.set(membrane.ui._key_press,"null",(function (this$,info){
return null;
}));

goog.object.set(membrane.ui.IBubble,"null",true);

goog.object.set(membrane.ui._bubble,"null",(function (elem,effects){
return null;
}));

goog.object.set(membrane.ui.IDrop,"null",true);

goog.object.set(membrane.ui._drop,"null",(function (elem,paths,local_pos){
return null;
}));

goog.object.set(membrane.ui.IMouseMoveGlobal,"null",true);

goog.object.set(membrane.ui._mouse_move_global,"null",(function (this$,info){
return null;
}));

goog.object.set(membrane.ui.IHasKeyEvent,"null",true);

goog.object.set(membrane.ui.has_key_event,"null",(function (this$){
return false;
}));
membrane.ui._default_mouse_move_global = (function membrane$ui$_default_mouse_move_global(elem,offset){
var vec__30279 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30279,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30279,(1),null);
var vec__30282 = offset;
var sx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30282,(0),null);
var sy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30282,(1),null);
var child_offset = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(sx - ox),(sy - oy)], null);
var intents = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,(function (){var iter__4529__auto__ = (function membrane$ui$_default_mouse_move_global_$_iter__30311(s__30312){
return (new cljs.core.LazySeq(null,(function (){
var s__30312__$1 = s__30312;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__30312__$1);
if(temp__5735__auto__){
var s__30312__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__30312__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__30312__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__30315 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__30314 = (0);
while(true){
if((i__30314 < size__4528__auto__)){
var child = cljs.core._nth(c__4527__auto__,i__30314);
cljs.core.chunk_append(b__30315,membrane.ui._mouse_move_global(child,child_offset));

var G__33046 = (i__30314 + (1));
i__30314 = G__33046;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__30315),membrane$ui$_default_mouse_move_global_$_iter__30311(cljs.core.chunk_rest(s__30312__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__30315),null);
}
} else {
var child = cljs.core.first(s__30312__$2);
return cljs.core.cons(membrane.ui._mouse_move_global(child,child_offset),membrane$ui$_default_mouse_move_global_$_iter__30311(cljs.core.rest(s__30312__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem)));
})());
return membrane.ui._bubble(elem,intents);
});
membrane.ui.within_bounds_QMARK_ = (function membrane$ui$within_bounds_QMARK_(elem,p__30366){
var vec__30369 = p__30366;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30369,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30369,(1),null);
var vec__30377 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30377,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30377,(1),null);
var vec__30381 = (membrane.ui.bounds.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.bounds.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.bounds.call(null,elem));
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30381,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30381,(1),null);
var local_x = (x - ox);
var local_y = (y - oy);
if((((local_x < width)) && ((local_x >= (0))) && ((local_y < height)) && ((local_y >= (0))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [local_x,local_y], null);
} else {
return null;
}
});
goog.object.set(membrane.ui.IHasKeyPress,"_",true);

goog.object.set(membrane.ui.has_key_press,"_",(function (this$){
return cljs.core.some(membrane.ui.has_key_press,(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$)));
}));

goog.object.set(membrane.ui.IHasMouseMoveGlobal,"_",true);

goog.object.set(membrane.ui.has_mouse_move_global,"_",(function (this$){
return cljs.core.some(membrane.ui.has_mouse_move_global,(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$)));
}));

goog.object.set(membrane.ui.IScroll,"_",true);

goog.object.set(membrane.ui._scroll,"_",(function (elem,offset,local_pos){
var intents = cljs.core.some((function (p1__30417_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__30417_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._scroll(p1__30417_SHARP_,offset,local_pos__$1));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IMouseEvent,"_",true);

goog.object.set(membrane.ui._mouse_event,"_",(function (elem,local_pos,button,mouse_down_QMARK_,mods){
var intents = cljs.core.some((function (p1__30408_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__30408_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_event(p1__30408_SHARP_,local_pos__$1,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IKeyEvent,"_",true);

goog.object.set(membrane.ui._key_event,"_",(function (this$,key,scancode,action,mods){
var intents = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__30435_SHARP_){
return membrane.ui._key_event(p1__30435_SHARP_,key,scancode,action,mods);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$))], 0));
return membrane.ui._bubble(this$,intents);
}));

goog.object.set(membrane.ui.IKeyPress,"_",true);

goog.object.set(membrane.ui._key_press,"_",(function (this$,info){
var intents = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p1__30422_SHARP_){
return membrane.ui._key_press(p1__30422_SHARP_,info);
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$))], 0));
return membrane.ui._bubble(this$,intents);
}));

goog.object.set(membrane.ui.IBubble,"_",true);

goog.object.set(membrane.ui._bubble,"_",(function (this$,intents){
return intents;
}));

goog.object.set(membrane.ui.IMouseMove,"_",true);

goog.object.set(membrane.ui._mouse_move,"_",(function (elem,local_pos){
var intents = cljs.core.some((function (p1__30416_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__30416_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_move(p1__30416_SHARP_,local_pos__$1));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IDrop,"_",true);

goog.object.set(membrane.ui._drop,"_",(function (elem,paths,local_pos){
var intents = cljs.core.some((function (p1__30420_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__30420_SHARP_,local_pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos__$1 = temp__5735__auto__;
return cljs.core.seq(membrane.ui._drop(p1__30420_SHARP_,paths,local_pos__$1));
} else {
return null;
}
}),cljs.core.reverse((membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(elem) : membrane.ui.children.call(null,elem))));
return membrane.ui._bubble(elem,intents);
}));

goog.object.set(membrane.ui.IMouseMoveGlobal,"_",true);

goog.object.set(membrane.ui._mouse_move_global,"_",(function (this$,offset){
return membrane.ui._default_mouse_move_global(this$,offset);
}));

goog.object.set(membrane.ui.IHasKeyEvent,"_",true);

goog.object.set(membrane.ui.has_key_event,"_",(function (this$){
return cljs.core.some(membrane.ui.has_key_event,(membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$)));
}));
membrane.ui.SHIFT_MASK = (1);
membrane.ui.CONTROL_MASK = (2);
membrane.ui.ALT_MASK = (4);
membrane.ui.SUPER_MASK = (8);
membrane.ui.CAPS_LOCK_MASK = (16);
membrane.ui.NUM_LOCK_MASK = (32);
if((typeof membrane !== 'undefined') && (typeof membrane.ui !== 'undefined') && (typeof membrane.ui.default_draw_impls !== 'undefined')){
} else {
membrane.ui.default_draw_impls = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
}
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,null,(function (draw){
return (function (this$){
return null;
});
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,cljs.core.PersistentVector,(function (draw){
return (function (this$){
var seq__30493 = cljs.core.seq(this$);
var chunk__30494 = null;
var count__30495 = (0);
var i__30496 = (0);
while(true){
if((i__30496 < count__30495)){
var drawable = chunk__30494.cljs$core$IIndexed$_nth$arity$2(null,i__30496);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__33090 = seq__30493;
var G__33091 = chunk__30494;
var G__33092 = count__30495;
var G__33093 = (i__30496 + (1));
seq__30493 = G__33090;
chunk__30494 = G__33091;
count__30495 = G__33092;
i__30496 = G__33093;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__30493);
if(temp__5735__auto__){
var seq__30493__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__30493__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__30493__$1);
var G__33096 = cljs.core.chunk_rest(seq__30493__$1);
var G__33097 = c__4556__auto__;
var G__33098 = cljs.core.count(c__4556__auto__);
var G__33099 = (0);
seq__30493 = G__33096;
chunk__30494 = G__33097;
count__30495 = G__33098;
i__30496 = G__33099;
continue;
} else {
var drawable = cljs.core.first(seq__30493__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__33101 = cljs.core.next(seq__30493__$1);
var G__33102 = null;
var G__33103 = (0);
var G__33104 = (0);
seq__30493 = G__33101;
chunk__30494 = G__33102;
count__30495 = G__33103;
i__30496 = G__33104;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,new cljs.core.Keyword(null,"default","default",-1987822328),(function (draw){
return (function (this$){
var G__30516 = (membrane.ui.children.cljs$core$IFn$_invoke$arity$1 ? membrane.ui.children.cljs$core$IFn$_invoke$arity$1(this$) : membrane.ui.children.call(null,this$));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__30516) : draw.call(null,G__30516));
});
}));

/**
 * @interface
 */
membrane.ui.IBounds = function(){};

var membrane$ui$IBounds$_bounds$dyn_33107 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._bounds[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._bounds["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IBounds.-bounds",elem);
}
}
});
/**
 * Returns a 2 element vector with the [width, height] of an element's bounds with respect to its origin
 */
membrane.ui._bounds = (function membrane$ui$_bounds(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IBounds$_bounds$arity$1 == null)))))){
return elem.membrane$ui$IBounds$_bounds$arity$1(elem);
} else {
return membrane$ui$IBounds$_bounds$dyn_33107(elem);
}
});

/**
 * Returns a 2 element vector with the [width, height] of an element's bounds with respect to its origin
 */
membrane.ui.bounds = cljs.core.memoize((function (p1__30524_SHARP_){
return membrane.ui._bounds(p1__30524_SHARP_);
}));
(cljs.core.PersistentVector.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__30540,elem){
var vec__30542 = p__30540;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30542,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30542,(1),null);
var vec__30546 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30546,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30546,(1),null);
var vec__30549 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30549,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30549,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),this$__$1);
}));

goog.object.set(membrane.ui.IBounds,"null",true);

goog.object.set(membrane.ui._bounds,"null",(function (this$){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));
/**
 * Returns a memoized version of a referentially transparent function. The
 *   memoized version of the function keeps a cache of the mapping from arguments
 *   to results and, when calls with the same arguments are repeated often, has
 *   higher performance at the expense of higher memory use.
 */
membrane.ui.memoize_var = (function membrane$ui$memoize_var(f){
var mem = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
return (function() { 
var G__33146__delegate = function (args){
var temp__5733__auto__ = cljs.core.find(cljs.core.deref(mem),args);
if(cljs.core.truth_(temp__5733__auto__)){
var e = temp__5733__auto__;
return cljs.core.val(e);
} else {
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
mem.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(mem.cljs$core$IDeref$_deref$arity$1(null),args,ret));

return ret;
}
};
var G__33146 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33148__i = 0, G__33148__a = new Array(arguments.length -  0);
while (G__33148__i < G__33148__a.length) {G__33148__a[G__33148__i] = arguments[G__33148__i + 0]; ++G__33148__i;}
  args = new cljs.core.IndexedSeq(G__33148__a,0,null);
} 
return G__33146__delegate.call(this,args);};
G__33146.cljs$lang$maxFixedArity = 0;
G__33146.cljs$lang$applyTo = (function (arglist__33150){
var args = cljs.core.seq(arglist__33150);
return G__33146__delegate(args);
});
G__33146.cljs$core$IFn$_invoke$arity$variadic = G__33146__delegate;
return G__33146;
})()
;
});

/**
 * @interface
 */
membrane.ui.IChildren = function(){};

var membrane$ui$IChildren$_children$dyn_33153 = (function (elem){
var x__4428__auto__ = (((elem == null))?null:elem);
var m__4429__auto__ = (membrane.ui._children[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4429__auto__.call(null,elem));
} else {
var m__4426__auto__ = (membrane.ui._children["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(elem) : m__4426__auto__.call(null,elem));
} else {
throw cljs.core.missing_protocol("IChildren.-children",elem);
}
}
});
/**
 * Returns sub elements of elem. Useful for traversal.
 */
membrane.ui._children = (function membrane$ui$_children(elem){
if((((!((elem == null)))) && ((!((elem.membrane$ui$IChildren$_children$arity$1 == null)))))){
return elem.membrane$ui$IChildren$_children$arity$1(elem);
} else {
return membrane$ui$IChildren$_children$dyn_33153(elem);
}
});

(cljs.core.PersistentVector.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));

goog.object.set(membrane.ui.IChildren,"null",true);

goog.object.set(membrane.ui._children,"null",(function (this$){
return null;
}));
goog.object.set(membrane.ui.IChildren,"_",true);

goog.object.set(membrane.ui._children,"_",(function (this$){
return null;
}));
/**
 * Returns sub elements of elem. Useful for traversal.
 */
membrane.ui.children = (function membrane$ui$children(elem){
return membrane.ui._children(elem);
});
/**
 * Returns the width of elem.
 */
membrane.ui.width = (function membrane$ui$width(elem){
var vec__30577 = membrane.ui.bounds(elem);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30577,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30577,(1),null);
return width;
});
/**
 * Returns the height of elem.
 */
membrane.ui.height = (function membrane$ui$height(elem){
var vec__30582 = membrane.ui.bounds(elem);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30582,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30582,(1),null);
return height;
});
/**
 * Returns the effects of a mouse move event on elem. Will only call -mouse-move on mouse events within an elements bounds.
 */
membrane.ui.mouse_move = (function membrane$ui$mouse_move(elem,pos){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._mouse_move(elem,local_pos);
} else {
return null;
}
});
/**
 * Returns the effects of a mouse move event on elem. Will -mouse-move-global for all elements and their children.
 */
membrane.ui.mouse_move_global = (function membrane$ui$mouse_move_global(elem,global_pos){
return membrane.ui._mouse_move_global(elem,global_pos);
});
membrane.ui.mouse_event = (function membrane$ui$mouse_event(elem,pos,button,mouse_down_QMARK_,mods){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._mouse_event(elem,local_pos,button,mouse_down_QMARK_,mods);
} else {
return null;
}
});
/**
 * Returns the effects of a mouse down event on elem. Will only call -mouse-event or -mouse-down if the position is in the element's bounds.
 */
membrane.ui.mouse_down = (function membrane$ui$mouse_down(elem,p__30602){
var vec__30603 = p__30602;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30603,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30603,(1),null);
var pos = vec__30603;
return membrane.ui.mouse_event(elem,pos,(0),true,(0));
});
/**
 * Returns the effects of a mouse up event on elem. Will only call -mouse-event or -mouse-down if the position is in the element's bounds.
 */
membrane.ui.mouse_up = (function membrane$ui$mouse_up(elem,p__30612){
var vec__30615 = p__30612;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30615,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30615,(1),null);
var pos = vec__30615;
return membrane.ui.mouse_event(elem,pos,(0),false,(0));
});
membrane.ui.drop = (function membrane$ui$drop(elem,paths,pos){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._drop(elem,paths,local_pos);
} else {
return null;
}
});
membrane.ui.scroll = (function membrane$ui$scroll(elem,offset,pos){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(elem,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return membrane.ui._scroll(elem,offset,local_pos);
} else {
return null;
}
});
/**
 * Returns the effects of a key press event on elem.
 * @param {...*} var_args
 */
membrane.ui.key_press = (function() { 
var membrane$ui$handler__27723__auto____delegate = function (elem__27724__auto__,args__27725__auto__){
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IKeyPress$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyPress,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyPress,elem__27724__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._key_press,elem__27724__auto__,args__27725__auto__);
} else {
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IChildren$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__))){
var intents__27726__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__27722__27727__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__27723__auto__,p1__27722__27727__auto__,args__27725__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__27724__auto__));
return membrane.ui._bubble(elem__27724__auto__,intents__27726__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__27723__auto__ = function (elem__27724__auto__,var_args){
var args__27725__auto__ = null;
if (arguments.length > 1) {
var G__33187__i = 0, G__33187__a = new Array(arguments.length -  1);
while (G__33187__i < G__33187__a.length) {G__33187__a[G__33187__i] = arguments[G__33187__i + 1]; ++G__33187__i;}
  args__27725__auto__ = new cljs.core.IndexedSeq(G__33187__a,0,null);
} 
return membrane$ui$handler__27723__auto____delegate.call(this,elem__27724__auto__,args__27725__auto__);};
membrane$ui$handler__27723__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__27723__auto__.cljs$lang$applyTo = (function (arglist__33188){
var elem__27724__auto__ = cljs.core.first(arglist__33188);
var args__27725__auto__ = cljs.core.rest(arglist__33188);
return membrane$ui$handler__27723__auto____delegate(elem__27724__auto__,args__27725__auto__);
});
membrane$ui$handler__27723__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__27723__auto____delegate;
return membrane$ui$handler__27723__auto__;
})()
;
/**
 * Returns the effects of a key event on elem.
 * @param {...*} var_args
 */
membrane.ui.key_event = (function() { 
var membrane$ui$handler__27723__auto____delegate = function (elem__27724__auto__,args__27725__auto__){
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IKeyEvent$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyEvent,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IKeyEvent,elem__27724__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._key_event,elem__27724__auto__,args__27725__auto__);
} else {
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IChildren$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__))){
var intents__27726__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__27722__27727__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__27723__auto__,p1__27722__27727__auto__,args__27725__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__27724__auto__));
return membrane.ui._bubble(elem__27724__auto__,intents__27726__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__27723__auto__ = function (elem__27724__auto__,var_args){
var args__27725__auto__ = null;
if (arguments.length > 1) {
var G__33196__i = 0, G__33196__a = new Array(arguments.length -  1);
while (G__33196__i < G__33196__a.length) {G__33196__a[G__33196__i] = arguments[G__33196__i + 1]; ++G__33196__i;}
  args__27725__auto__ = new cljs.core.IndexedSeq(G__33196__a,0,null);
} 
return membrane$ui$handler__27723__auto____delegate.call(this,elem__27724__auto__,args__27725__auto__);};
membrane$ui$handler__27723__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__27723__auto__.cljs$lang$applyTo = (function (arglist__33197){
var elem__27724__auto__ = cljs.core.first(arglist__33197);
var args__27725__auto__ = cljs.core.rest(arglist__33197);
return membrane$ui$handler__27723__auto____delegate(elem__27724__auto__,args__27725__auto__);
});
membrane$ui$handler__27723__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__27723__auto____delegate;
return membrane$ui$handler__27723__auto__;
})()
;
/**
 * Returns the effects of a clipboard cut event on elem.
 * @param {...*} var_args
 */
membrane.ui.clipboard_cut = (function() { 
var membrane$ui$handler__27723__auto____delegate = function (elem__27724__auto__,args__27725__auto__){
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IClipboardCut$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCut,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCut,elem__27724__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._clipboard_cut,elem__27724__auto__,args__27725__auto__);
} else {
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IChildren$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__))){
var intents__27726__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__27722__27727__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__27723__auto__,p1__27722__27727__auto__,args__27725__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__27724__auto__));
return membrane.ui._bubble(elem__27724__auto__,intents__27726__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__27723__auto__ = function (elem__27724__auto__,var_args){
var args__27725__auto__ = null;
if (arguments.length > 1) {
var G__33198__i = 0, G__33198__a = new Array(arguments.length -  1);
while (G__33198__i < G__33198__a.length) {G__33198__a[G__33198__i] = arguments[G__33198__i + 1]; ++G__33198__i;}
  args__27725__auto__ = new cljs.core.IndexedSeq(G__33198__a,0,null);
} 
return membrane$ui$handler__27723__auto____delegate.call(this,elem__27724__auto__,args__27725__auto__);};
membrane$ui$handler__27723__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__27723__auto__.cljs$lang$applyTo = (function (arglist__33199){
var elem__27724__auto__ = cljs.core.first(arglist__33199);
var args__27725__auto__ = cljs.core.rest(arglist__33199);
return membrane$ui$handler__27723__auto____delegate(elem__27724__auto__,args__27725__auto__);
});
membrane$ui$handler__27723__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__27723__auto____delegate;
return membrane$ui$handler__27723__auto__;
})()
;
/**
 * Returns the effects of a clipboard copy event on elem.
 * @param {...*} var_args
 */
membrane.ui.clipboard_copy = (function() { 
var membrane$ui$handler__27723__auto____delegate = function (elem__27724__auto__,args__27725__auto__){
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IClipboardCopy$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCopy,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardCopy,elem__27724__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._clipboard_copy,elem__27724__auto__,args__27725__auto__);
} else {
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IChildren$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__))){
var intents__27726__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__27722__27727__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__27723__auto__,p1__27722__27727__auto__,args__27725__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__27724__auto__));
return membrane.ui._bubble(elem__27724__auto__,intents__27726__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__27723__auto__ = function (elem__27724__auto__,var_args){
var args__27725__auto__ = null;
if (arguments.length > 1) {
var G__33200__i = 0, G__33200__a = new Array(arguments.length -  1);
while (G__33200__i < G__33200__a.length) {G__33200__a[G__33200__i] = arguments[G__33200__i + 1]; ++G__33200__i;}
  args__27725__auto__ = new cljs.core.IndexedSeq(G__33200__a,0,null);
} 
return membrane$ui$handler__27723__auto____delegate.call(this,elem__27724__auto__,args__27725__auto__);};
membrane$ui$handler__27723__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__27723__auto__.cljs$lang$applyTo = (function (arglist__33205){
var elem__27724__auto__ = cljs.core.first(arglist__33205);
var args__27725__auto__ = cljs.core.rest(arglist__33205);
return membrane$ui$handler__27723__auto____delegate(elem__27724__auto__,args__27725__auto__);
});
membrane$ui$handler__27723__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__27723__auto____delegate;
return membrane$ui$handler__27723__auto__;
})()
;
/**
 * Returns the effects of a clipboard paste event on elem.
 * @param {...*} var_args
 */
membrane.ui.clipboard_paste = (function() { 
var membrane$ui$handler__27723__auto____delegate = function (elem__27724__auto__,args__27725__auto__){
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IClipboardPaste$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardPaste,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IClipboardPaste,elem__27724__auto__))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane.ui._clipboard_paste,elem__27724__auto__,args__27725__auto__);
} else {
if((((!((elem__27724__auto__ == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === elem__27724__auto__.membrane$ui$IChildren$))))?true:(((!elem__27724__auto__.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__):false)):cljs.core.native_satisfies_QMARK_(membrane.ui.IChildren,elem__27724__auto__))){
var intents__27726__auto__ = cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__27722__27727__auto__){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(membrane$ui$handler__27723__auto__,p1__27722__27727__auto__,args__27725__auto__);
})),cljs.core.into,cljs.core.PersistentVector.EMPTY,membrane.ui.children(elem__27724__auto__));
return membrane.ui._bubble(elem__27724__auto__,intents__27726__auto__);
} else {
return null;
}
}
};
var membrane$ui$handler__27723__auto__ = function (elem__27724__auto__,var_args){
var args__27725__auto__ = null;
if (arguments.length > 1) {
var G__33215__i = 0, G__33215__a = new Array(arguments.length -  1);
while (G__33215__i < G__33215__a.length) {G__33215__a[G__33215__i] = arguments[G__33215__i + 1]; ++G__33215__i;}
  args__27725__auto__ = new cljs.core.IndexedSeq(G__33215__a,0,null);
} 
return membrane$ui$handler__27723__auto____delegate.call(this,elem__27724__auto__,args__27725__auto__);};
membrane$ui$handler__27723__auto__.cljs$lang$maxFixedArity = 1;
membrane$ui$handler__27723__auto__.cljs$lang$applyTo = (function (arglist__33216){
var elem__27724__auto__ = cljs.core.first(arglist__33216);
var args__27725__auto__ = cljs.core.rest(arglist__33216);
return membrane$ui$handler__27723__auto____delegate(elem__27724__auto__,args__27725__auto__);
});
membrane$ui$handler__27723__auto__.cljs$core$IFn$_invoke$arity$variadic = membrane$ui$handler__27723__auto____delegate;
return membrane$ui$handler__27723__auto__;
})()
;

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Label = (function (text,font,__meta,__extmap,__hash){
this.text = text;
this.font = font;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Label.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Label.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k30699,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__30705 = k30699;
var G__30705__$1 = (((G__30705 instanceof cljs.core.Keyword))?G__30705.fqn:null);
switch (G__30705__$1) {
case "text":
return self__.text;

break;
case "font":
return self__.font;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30699,else__4383__auto__);

}
}));

(membrane.ui.Label.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__30713){
var vec__30715 = p__30713;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30715,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30715,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Label.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Label{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"font","font",-1506159249),self__.font],null))], null),self__.__extmap));
}));

(membrane.ui.Label.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30698){
var self__ = this;
var G__30698__$1 = this;
return (new cljs.core.RecordIter((0),G__30698__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"font","font",-1506159249)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Label.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Label.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Label(self__.text,self__.font,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Label.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Label.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1431250007 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Label.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30700,other30701){
var self__ = this;
var this30700__$1 = this;
return (((!((other30701 == null)))) && ((this30700__$1.constructor === other30701.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30700__$1.text,other30701.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30700__$1.font,other30701.font)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30700__$1.__extmap,other30701.__extmap)));
}));

(membrane.ui.Label.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Label.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Label.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"font","font",-1506159249),null,new cljs.core.Keyword(null,"text","text",-1790561697),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Label(self__.text,self__.font,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Label.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__30698){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__30739 = cljs.core.keyword_identical_QMARK_;
var expr__30740 = k__4388__auto__;
if(cljs.core.truth_((pred__30739.cljs$core$IFn$_invoke$arity$2 ? pred__30739.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__30740) : pred__30739.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__30740)))){
return (new membrane.ui.Label(G__30698,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__30739.cljs$core$IFn$_invoke$arity$2 ? pred__30739.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"font","font",-1506159249),expr__30740) : pred__30739.call(null,new cljs.core.Keyword(null,"font","font",-1506159249),expr__30740)))){
return (new membrane.ui.Label(self__.text,G__30698,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Label(self__.text,self__.font,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__30698),null));
}
}
}));

(membrane.ui.Label.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"font","font",-1506159249),self__.font,null))], null),self__.__extmap));
}));

(membrane.ui.Label.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__30698){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Label(self__.text,self__.font,G__30698,self__.__extmap,self__.__hash));
}));

(membrane.ui.Label.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Label.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"font","font",134372278,null)], null);
}));

(membrane.ui.Label.cljs$lang$type = true);

(membrane.ui.Label.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Label",null,(1),null));
}));

(membrane.ui.Label.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Label");
}));

/**
 * Positional factory function for membrane.ui/Label.
 */
membrane.ui.__GT_Label = (function membrane$ui$__GT_Label(text,font){
return (new membrane.ui.Label(text,font,null,null,null));
});

/**
 * Factory function for membrane.ui/Label, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Label = (function membrane$ui$map__GT_Label(G__30703){
var extmap__4419__auto__ = (function (){var G__30750 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30703,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"font","font",-1506159249)], 0));
if(cljs.core.record_QMARK_(G__30703)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30750);
} else {
return G__30750;
}
})();
return (new membrane.ui.Label(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__30703),new cljs.core.Keyword(null,"font","font",-1506159249).cljs$core$IFn$_invoke$arity$1(G__30703),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that can draw text.
 * 
 *   label will use the default line spacing for newline.
 *   font should be a membrane.ui.Font
 */
membrane.ui.label = (function membrane$ui$label(var_args){
var G__30762 = arguments.length;
switch (G__30762) {
case 1:
return membrane.ui.label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.label.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.label.cljs$core$IFn$_invoke$arity$1 = (function (text){
return membrane.ui.label.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),membrane.ui.default_font);
}));

(membrane.ui.label.cljs$core$IFn$_invoke$arity$2 = (function (text,font){
return (new membrane.ui.Label(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),font,null,null,null));
}));

(membrane.ui.label.cljs$lang$maxFixedArity = 2);

membrane.ui.pr_label = (function membrane$ui$pr_label(var_args){
var G__30783 = arguments.length;
switch (G__30783) {
case 1:
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$1 = (function (x){
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$2(x,(30));
}));

(membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$2 = (function (x,max_length){
return membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$3(x,max_length,null);
}));

(membrane.ui.pr_label.cljs$core$IFn$_invoke$arity$3 = (function (x,max_length,font){
var s = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
var s__$1 = (cljs.core.truth_(max_length)?cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(function (){var x__4217__auto__ = max_length;
var y__4218__auto__ = ((s).length);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})()):s);
return membrane.ui.label.cljs$core$IFn$_invoke$arity$2(s__$1,(function (){var or__4126__auto__ = font;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return membrane.ui.default_font;
}
})());
}));

(membrane.ui.pr_label.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.TextSelection = (function (text,selection,font,__meta,__extmap,__hash){
this.text = text;
this.selection = selection;
this.font = font;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.TextSelection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.TextSelection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k30795,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__30807 = k30795;
var G__30807__$1 = (((G__30807 instanceof cljs.core.Keyword))?G__30807.fqn:null);
switch (G__30807__$1) {
case "text":
return self__.text;

break;
case "selection":
return self__.selection;

break;
case "font":
return self__.font;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30795,else__4383__auto__);

}
}));

(membrane.ui.TextSelection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__30820){
var vec__30822 = p__30820;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30822,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30822,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.TextSelection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.TextSelection{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"selection","selection",975998651),self__.selection],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"font","font",-1506159249),self__.font],null))], null),self__.__extmap));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30794){
var self__ = this;
var G__30794__$1 = this;
return (new cljs.core.RecordIter((0),G__30794__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"selection","selection",975998651),new cljs.core.Keyword(null,"font","font",-1506159249)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.TextSelection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextSelection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-112814428 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.TextSelection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30796,other30797){
var self__ = this;
var this30796__$1 = this;
return (((!((other30797 == null)))) && ((this30796__$1.constructor === other30797.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30796__$1.text,other30797.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30796__$1.selection,other30797.selection)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30796__$1.font,other30797.font)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30796__$1.__extmap,other30797.__extmap)));
}));

(membrane.ui.TextSelection.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TextSelection.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.TextSelection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"font","font",-1506159249),null,new cljs.core.Keyword(null,"selection","selection",975998651),null,new cljs.core.Keyword(null,"text","text",-1790561697),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.TextSelection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__30794){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__30846 = cljs.core.keyword_identical_QMARK_;
var expr__30847 = k__4388__auto__;
if(cljs.core.truth_((pred__30846.cljs$core$IFn$_invoke$arity$2 ? pred__30846.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__30847) : pred__30846.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__30847)))){
return (new membrane.ui.TextSelection(G__30794,self__.selection,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__30846.cljs$core$IFn$_invoke$arity$2 ? pred__30846.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"selection","selection",975998651),expr__30847) : pred__30846.call(null,new cljs.core.Keyword(null,"selection","selection",975998651),expr__30847)))){
return (new membrane.ui.TextSelection(self__.text,G__30794,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__30846.cljs$core$IFn$_invoke$arity$2 ? pred__30846.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"font","font",-1506159249),expr__30847) : pred__30846.call(null,new cljs.core.Keyword(null,"font","font",-1506159249),expr__30847)))){
return (new membrane.ui.TextSelection(self__.text,self__.selection,G__30794,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__30794),null));
}
}
}
}));

(membrane.ui.TextSelection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"selection","selection",975998651),self__.selection,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"font","font",-1506159249),self__.font,null))], null),self__.__extmap));
}));

(membrane.ui.TextSelection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__30794){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.TextSelection(self__.text,self__.selection,self__.font,G__30794,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextSelection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.TextSelection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"selection","selection",-1678437118,null),new cljs.core.Symbol(null,"font","font",134372278,null)], null);
}));

(membrane.ui.TextSelection.cljs$lang$type = true);

(membrane.ui.TextSelection.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/TextSelection",null,(1),null));
}));

(membrane.ui.TextSelection.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/TextSelection");
}));

/**
 * Positional factory function for membrane.ui/TextSelection.
 */
membrane.ui.__GT_TextSelection = (function membrane$ui$__GT_TextSelection(text,selection,font){
return (new membrane.ui.TextSelection(text,selection,font,null,null,null));
});

/**
 * Factory function for membrane.ui/TextSelection, taking a map of keywords to field values.
 */
membrane.ui.map__GT_TextSelection = (function membrane$ui$map__GT_TextSelection(G__30799){
var extmap__4419__auto__ = (function (){var G__30871 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30799,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"selection","selection",975998651),new cljs.core.Keyword(null,"font","font",-1506159249)], 0));
if(cljs.core.record_QMARK_(G__30799)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30871);
} else {
return G__30871;
}
})();
return (new membrane.ui.TextSelection(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__30799),new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(G__30799),new cljs.core.Keyword(null,"font","font",-1506159249).cljs$core$IFn$_invoke$arity$1(G__30799),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem for drawing a selection of text.
 */
membrane.ui.text_selection = (function membrane$ui$text_selection(var_args){
var G__30883 = arguments.length;
switch (G__30883) {
case 2:
return membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$2 = (function (text,p__30892){
var vec__30894 = p__30892;
var selection_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30894,(0),null);
var selection_end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30894,(1),null);
var selection = vec__30894;
return (new membrane.ui.TextSelection(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),selection,membrane.ui.default_font,null,null,null));
}));

(membrane.ui.text_selection.cljs$core$IFn$_invoke$arity$3 = (function (text,p__30901,font){
var vec__30904 = p__30901;
var selection_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30904,(0),null);
var selection_end = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30904,(1),null);
var selection = vec__30904;
return (new membrane.ui.TextSelection(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),selection,font,null,null,null));
}));

(membrane.ui.text_selection.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.TextCursor = (function (text,cursor,font,__meta,__extmap,__hash){
this.text = text;
this.cursor = cursor;
this.font = font;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.TextCursor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.TextCursor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k30908,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__30918 = k30908;
var G__30918__$1 = (((G__30918 instanceof cljs.core.Keyword))?G__30918.fqn:null);
switch (G__30918__$1) {
case "text":
return self__.text;

break;
case "cursor":
return self__.cursor;

break;
case "font":
return self__.font;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30908,else__4383__auto__);

}
}));

(membrane.ui.TextCursor.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__30920){
var vec__30921 = p__30920;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30921,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30921,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.TextCursor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.TextCursor{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cursor","cursor",1011937484),self__.cursor],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"font","font",-1506159249),self__.font],null))], null),self__.__extmap));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30907){
var self__ = this;
var G__30907__$1 = this;
return (new cljs.core.RecordIter((0),G__30907__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"font","font",-1506159249)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.TextCursor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextCursor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (976138570 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.TextCursor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30910,other30911){
var self__ = this;
var this30910__$1 = this;
return (((!((other30911 == null)))) && ((this30910__$1.constructor === other30911.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30910__$1.text,other30911.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30910__$1.cursor,other30911.cursor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30910__$1.font,other30911.font)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30910__$1.__extmap,other30911.__extmap)));
}));

(membrane.ui.TextCursor.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TextCursor.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.TextCursor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"cursor","cursor",1011937484),null,new cljs.core.Keyword(null,"font","font",-1506159249),null,new cljs.core.Keyword(null,"text","text",-1790561697),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.TextCursor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__30907){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__30936 = cljs.core.keyword_identical_QMARK_;
var expr__30937 = k__4388__auto__;
if(cljs.core.truth_((pred__30936.cljs$core$IFn$_invoke$arity$2 ? pred__30936.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__30937) : pred__30936.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__30937)))){
return (new membrane.ui.TextCursor(G__30907,self__.cursor,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__30936.cljs$core$IFn$_invoke$arity$2 ? pred__30936.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"cursor","cursor",1011937484),expr__30937) : pred__30936.call(null,new cljs.core.Keyword(null,"cursor","cursor",1011937484),expr__30937)))){
return (new membrane.ui.TextCursor(self__.text,G__30907,self__.font,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__30936.cljs$core$IFn$_invoke$arity$2 ? pred__30936.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"font","font",-1506159249),expr__30937) : pred__30936.call(null,new cljs.core.Keyword(null,"font","font",-1506159249),expr__30937)))){
return (new membrane.ui.TextCursor(self__.text,self__.cursor,G__30907,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__30907),null));
}
}
}
}));

(membrane.ui.TextCursor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"cursor","cursor",1011937484),self__.cursor,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"font","font",-1506159249),self__.font,null))], null),self__.__extmap));
}));

(membrane.ui.TextCursor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__30907){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.TextCursor(self__.text,self__.cursor,self__.font,G__30907,self__.__extmap,self__.__hash));
}));

(membrane.ui.TextCursor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.TextCursor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"cursor","cursor",-1642498285,null),new cljs.core.Symbol(null,"font","font",134372278,null)], null);
}));

(membrane.ui.TextCursor.cljs$lang$type = true);

(membrane.ui.TextCursor.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/TextCursor",null,(1),null));
}));

(membrane.ui.TextCursor.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/TextCursor");
}));

/**
 * Positional factory function for membrane.ui/TextCursor.
 */
membrane.ui.__GT_TextCursor = (function membrane$ui$__GT_TextCursor(text,cursor,font){
return (new membrane.ui.TextCursor(text,cursor,font,null,null,null));
});

/**
 * Factory function for membrane.ui/TextCursor, taking a map of keywords to field values.
 */
membrane.ui.map__GT_TextCursor = (function membrane$ui$map__GT_TextCursor(G__30914){
var extmap__4419__auto__ = (function (){var G__30945 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30914,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"font","font",-1506159249)], 0));
if(cljs.core.record_QMARK_(G__30914)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__30945);
} else {
return G__30945;
}
})();
return (new membrane.ui.TextCursor(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__30914),new cljs.core.Keyword(null,"cursor","cursor",1011937484).cljs$core$IFn$_invoke$arity$1(G__30914),new cljs.core.Keyword(null,"font","font",-1506159249).cljs$core$IFn$_invoke$arity$1(G__30914),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that can draw a text cursor
 * 
 * font should be a membrane.ui.Font
 */
membrane.ui.text_cursor = (function membrane$ui$text_cursor(var_args){
var G__30954 = arguments.length;
switch (G__30954) {
case 2:
return membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$2 = (function (text,cursor){
return (new membrane.ui.TextCursor(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),cursor,membrane.ui.default_font,null,null,null));
}));

(membrane.ui.text_cursor.cljs$core$IFn$_invoke$arity$3 = (function (text,cursor,font){
return (new membrane.ui.TextCursor(cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),cursor,font,null,null,null));
}));

(membrane.ui.text_cursor.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Image = (function (image_path,size,opacity,__meta,__extmap,__hash){
this.image_path = image_path;
this.size = size;
this.opacity = opacity;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Image.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Image.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k30966,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__30978 = k30966;
var G__30978__$1 = (((G__30978 instanceof cljs.core.Keyword))?G__30978.fqn:null);
switch (G__30978__$1) {
case "image-path":
return self__.image_path;

break;
case "size":
return self__.size;

break;
case "opacity":
return self__.opacity;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k30966,else__4383__auto__);

}
}));

(membrane.ui.Image.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__30983){
var vec__30984 = p__30983;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30984,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30984,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Image.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Image{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"image-path","image-path",-348638603),self__.image_path],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opacity","opacity",397153780),self__.opacity],null))], null),self__.__extmap));
}));

(membrane.ui.Image.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__30965){
var self__ = this;
var G__30965__$1 = this;
return (new cljs.core.RecordIter((0),G__30965__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"image-path","image-path",-348638603),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"opacity","opacity",397153780)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Image.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Image.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.size;
}));

(membrane.ui.Image.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Image.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Image.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Image.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1465189816 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Image.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this30967,other30968){
var self__ = this;
var this30967__$1 = this;
return (((!((other30968 == null)))) && ((this30967__$1.constructor === other30968.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30967__$1.image_path,other30968.image_path)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30967__$1.size,other30968.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30967__$1.opacity,other30968.opacity)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this30967__$1.__extmap,other30968.__extmap)));
}));

(membrane.ui.Image.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Image.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Image.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"opacity","opacity",397153780),null,new cljs.core.Keyword(null,"image-path","image-path",-348638603),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Image.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__30965){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31015 = cljs.core.keyword_identical_QMARK_;
var expr__31016 = k__4388__auto__;
if(cljs.core.truth_((pred__31015.cljs$core$IFn$_invoke$arity$2 ? pred__31015.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"image-path","image-path",-348638603),expr__31016) : pred__31015.call(null,new cljs.core.Keyword(null,"image-path","image-path",-348638603),expr__31016)))){
return (new membrane.ui.Image(G__30965,self__.size,self__.opacity,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31015.cljs$core$IFn$_invoke$arity$2 ? pred__31015.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),expr__31016) : pred__31015.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__31016)))){
return (new membrane.ui.Image(self__.image_path,G__30965,self__.opacity,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31015.cljs$core$IFn$_invoke$arity$2 ? pred__31015.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"opacity","opacity",397153780),expr__31016) : pred__31015.call(null,new cljs.core.Keyword(null,"opacity","opacity",397153780),expr__31016)))){
return (new membrane.ui.Image(self__.image_path,self__.size,G__30965,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__30965),null));
}
}
}
}));

(membrane.ui.Image.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"image-path","image-path",-348638603),self__.image_path,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opacity","opacity",397153780),self__.opacity,null))], null),self__.__extmap));
}));

(membrane.ui.Image.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__30965){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Image(self__.image_path,self__.size,self__.opacity,G__30965,self__.__extmap,self__.__hash));
}));

(membrane.ui.Image.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Image.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"image-path","image-path",1291892924,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"opacity","opacity",2037685307,null)], null);
}));

(membrane.ui.Image.cljs$lang$type = true);

(membrane.ui.Image.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Image",null,(1),null));
}));

(membrane.ui.Image.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Image");
}));

/**
 * Positional factory function for membrane.ui/Image.
 */
membrane.ui.__GT_Image = (function membrane$ui$__GT_Image(image_path,size,opacity){
return (new membrane.ui.Image(image_path,size,opacity,null,null,null));
});

/**
 * Factory function for membrane.ui/Image, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Image = (function membrane$ui$map__GT_Image(G__30971){
var extmap__4419__auto__ = (function (){var G__31033 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__30971,new cljs.core.Keyword(null,"image-path","image-path",-348638603),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"opacity","opacity",397153780)], 0));
if(cljs.core.record_QMARK_(G__30971)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31033);
} else {
return G__31033;
}
})();
return (new membrane.ui.Image(new cljs.core.Keyword(null,"image-path","image-path",-348638603).cljs$core$IFn$_invoke$arity$1(G__30971),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__30971),new cljs.core.Keyword(null,"opacity","opacity",397153780).cljs$core$IFn$_invoke$arity$1(G__30971),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.image_size = (function membrane$ui$image_size(image_path){
throw (new Error(["Assert failed: ","image size should be replaced by implementation","\n","false"].join('')));

});
/**
 * Graphical element that draws an image.
 * 
 *   `image-path`: using the skia backend, `image-path` can be one of
 *   - a string filename
 *   - a java.net.URL
 *   - a byte array containing the bytes of supported image format
 *   This is useful for drawing images included in a jar. Simply put your image in your resources folder, typically resources.
 *   Draw the images in the jar with `(ui/image (clojure.java.io/resource "filename.png"))`
 * 
 *   The image can be drawn at a different size by supplying a size.
 *   Supply a nil size will use the the original image size.
 * 
 *   The image can be aspect scaled by supply a size with one of the dimensions as nil.
 * 
 *   For example, to draw an image with width 30 with aspect scaling, `(image "path.png" [30 nil])`
 * 
 *   opacity is a float between 0 and 1.
 * 
 *   Allowable image formats may vary by platform, but will typically include png and jpeg.
 *   
 */
membrane.ui.image = (function membrane$ui$image(var_args){
var G__31053 = arguments.length;
switch (G__31053) {
case 1:
return membrane.ui.image.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.image.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.image.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.image.cljs$core$IFn$_invoke$arity$1 = (function (image_path){
return membrane.ui.image.cljs$core$IFn$_invoke$arity$3(image_path,null,null);
}));

(membrane.ui.image.cljs$core$IFn$_invoke$arity$2 = (function (image_path,p__31070){
var vec__31071 = p__31070;
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31071,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31071,(1),null);
var size = vec__31071;
return membrane.ui.image.cljs$core$IFn$_invoke$arity$3(image_path,size,null);
}));

(membrane.ui.image.cljs$core$IFn$_invoke$arity$3 = (function (image_path,p__31076,opacity){
var vec__31080 = p__31076;
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31080,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31080,(1),null);
var size = vec__31080;
var size__$1 = (((size == null))?membrane.ui.image_size(image_path):(function (){var vec__31088 = size;
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31088,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31088,(1),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = w;
if(cljs.core.truth_(and__4115__auto__)){
return h;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [w,h], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = w;
if(cljs.core.truth_(and__4115__auto__)){
return (h == null);
} else {
return and__4115__auto__;
}
})())){
var vec__31097 = membrane.ui.image_size(image_path);
var actual_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31097,(0),null);
var actual_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31097,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [w,(actual_height * (w / (function (){var x__4214__auto__ = (1);
var y__4215__auto__ = actual_width;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()))], null);
} else {
if(cljs.core.truth_((((w == null))?h:false))){
var vec__31102 = membrane.ui.image_size(image_path);
var actual_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31102,(0),null);
var actual_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31102,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(actual_width * (h / (function (){var x__4214__auto__ = (1);
var y__4215__auto__ = actual_height;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})())),h], null);
} else {
return membrane.ui.image_size(image_path);

}
}
}
})());
var opacity__$1 = (((opacity == null))?(1):opacity);
return (new membrane.ui.Image(image_path,size__$1,opacity__$1,null,null,null));
}));

(membrane.ui.image.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Translate = (function (x,y,drawable,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Translate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Translate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31113,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31125 = k31113;
var G__31125__$1 = (((G__31125 instanceof cljs.core.Keyword))?G__31125.fqn:null);
switch (G__31125__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31113,else__4383__auto__);

}
}));

(membrane.ui.Translate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31126){
var vec__31127 = p__31126;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31127,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31127,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Translate.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Translate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Translate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Translate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31112){
var self__ = this;
var G__31112__$1 = this;
return (new cljs.core.RecordIter((0),G__31112__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Translate.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__31147 = membrane.ui.bounds(self__.drawable);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31147,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31147,(1),null);
var vec__31150 = membrane.ui.origin(self__.drawable);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31150,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31150,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(w + ox),(h + oy)], null);
}));

(membrane.ui.Translate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Translate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Translate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Translate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (526052509 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Translate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31114,other31115){
var self__ = this;
var this31114__$1 = this;
return (((!((other31115 == null)))) && ((this31114__$1.constructor === other31115.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31114__$1.x,other31115.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31114__$1.y,other31115.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31114__$1.drawable,other31115.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31114__$1.__extmap,other31115.__extmap)));
}));

(membrane.ui.Translate.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.x,self__.y], null);
}));

(membrane.ui.Translate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Translate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31112){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31180 = cljs.core.keyword_identical_QMARK_;
var expr__31181 = k__4388__auto__;
if(cljs.core.truth_((pred__31180.cljs$core$IFn$_invoke$arity$2 ? pred__31180.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__31181) : pred__31180.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__31181)))){
return (new membrane.ui.Translate(G__31112,self__.y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31180.cljs$core$IFn$_invoke$arity$2 ? pred__31180.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__31181) : pred__31180.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__31181)))){
return (new membrane.ui.Translate(self__.x,G__31112,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31180.cljs$core$IFn$_invoke$arity$2 ? pred__31180.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31181) : pred__31180.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31181)))){
return (new membrane.ui.Translate(self__.x,self__.y,G__31112,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31112),null));
}
}
}
}));

(membrane.ui.Translate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Translate.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Translate.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Translate(self__.x,self__.y,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Translate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31112){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Translate(self__.x,self__.y,self__.drawable,G__31112,self__.__extmap,self__.__hash));
}));

(membrane.ui.Translate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Translate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Translate.cljs$lang$type = true);

(membrane.ui.Translate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Translate",null,(1),null));
}));

(membrane.ui.Translate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Translate");
}));

/**
 * Positional factory function for membrane.ui/Translate.
 */
membrane.ui.__GT_Translate = (function membrane$ui$__GT_Translate(x,y,drawable){
return (new membrane.ui.Translate(x,y,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Translate, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Translate = (function membrane$ui$map__GT_Translate(G__31117){
var extmap__4419__auto__ = (function (){var G__31190 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31117,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31117)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31190);
} else {
return G__31190;
}
})();
return (new membrane.ui.Translate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__31117),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__31117),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31117),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * A graphical elem that will shift drawable's origin by x and y and draw it at its new origin.
 */
membrane.ui.translate = (function membrane$ui$translate(x,y,drawable){
return (new membrane.ui.Translate(x,y,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Rotate = (function (degrees,drawable,__meta,__extmap,__hash){
this.degrees = degrees;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Rotate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Rotate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31204,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31221 = k31204;
var G__31221__$1 = (((G__31221 instanceof cljs.core.Keyword))?G__31221.fqn:null);
switch (G__31221__$1) {
case "degrees":
return self__.degrees;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31204,else__4383__auto__);

}
}));

(membrane.ui.Rotate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31230){
var vec__31232 = p__31230;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31232,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31232,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Rotate.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Rotate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Rotate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"degrees","degrees",2015169884),self__.degrees],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Rotate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31203){
var self__ = this;
var G__31203__$1 = this;
return (new cljs.core.RecordIter((0),G__31203__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"degrees","degrees",2015169884),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Rotate.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.Rotate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Rotate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rotate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Rotate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (734720640 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Rotate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31205,other31206){
var self__ = this;
var this31205__$1 = this;
return (((!((other31206 == null)))) && ((this31205__$1.constructor === other31206.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31205__$1.degrees,other31206.degrees)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31205__$1.drawable,other31206.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31205__$1.__extmap,other31206.__extmap)));
}));

(membrane.ui.Rotate.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Rotate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"degrees","degrees",2015169884),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Rotate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31203){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31283 = cljs.core.keyword_identical_QMARK_;
var expr__31284 = k__4388__auto__;
if(cljs.core.truth_((pred__31283.cljs$core$IFn$_invoke$arity$2 ? pred__31283.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"degrees","degrees",2015169884),expr__31284) : pred__31283.call(null,new cljs.core.Keyword(null,"degrees","degrees",2015169884),expr__31284)))){
return (new membrane.ui.Rotate(G__31203,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31283.cljs$core$IFn$_invoke$arity$2 ? pred__31283.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31284) : pred__31283.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31284)))){
return (new membrane.ui.Rotate(self__.degrees,G__31203,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31203),null));
}
}
}));

(membrane.ui.Rotate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"degrees","degrees",2015169884),self__.degrees,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Rotate.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rotate.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Rotate(self__.degrees,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Rotate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31203){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Rotate(self__.degrees,self__.drawable,G__31203,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rotate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Rotate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"degrees","degrees",-639265885,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Rotate.cljs$lang$type = true);

(membrane.ui.Rotate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Rotate",null,(1),null));
}));

(membrane.ui.Rotate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Rotate");
}));

/**
 * Positional factory function for membrane.ui/Rotate.
 */
membrane.ui.__GT_Rotate = (function membrane$ui$__GT_Rotate(degrees,drawable){
return (new membrane.ui.Rotate(degrees,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Rotate, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Rotate = (function membrane$ui$map__GT_Rotate(G__31209){
var extmap__4419__auto__ = (function (){var G__31328 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31209,new cljs.core.Keyword(null,"degrees","degrees",2015169884),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31209)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31328);
} else {
return G__31328;
}
})();
return (new membrane.ui.Rotate(new cljs.core.Keyword(null,"degrees","degrees",2015169884).cljs$core$IFn$_invoke$arity$1(G__31209),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31209),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.rotate = (function membrane$ui$rotate(degrees,drawable){
return (new membrane.ui.Rotate(degrees,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.AffineTransform = (function (matrix,drawable,__meta,__extmap,__hash){
this.matrix = matrix;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.AffineTransform.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31340,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31354 = k31340;
var G__31354__$1 = (((G__31354 instanceof cljs.core.Keyword))?G__31354.fqn:null);
switch (G__31354__$1) {
case "matrix":
return self__.matrix;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31340,else__4383__auto__);

}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31358){
var vec__31359 = p__31358;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31359,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31359,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.AffineTransform{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"matrix","matrix",803137200),self__.matrix],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31339){
var self__ = this;
var G__31339__$1 = this;
return (new cljs.core.RecordIter((0),G__31339__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"matrix","matrix",803137200),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1520501787 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31341,other31342){
var self__ = this;
var this31341__$1 = this;
return (((!((other31342 == null)))) && ((this31341__$1.constructor === other31342.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31341__$1.matrix,other31342.matrix)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31341__$1.drawable,other31342.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31341__$1.__extmap,other31342.__extmap)));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"matrix","matrix",803137200),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31339){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31383 = cljs.core.keyword_identical_QMARK_;
var expr__31384 = k__4388__auto__;
if(cljs.core.truth_((pred__31383.cljs$core$IFn$_invoke$arity$2 ? pred__31383.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"matrix","matrix",803137200),expr__31384) : pred__31383.call(null,new cljs.core.Keyword(null,"matrix","matrix",803137200),expr__31384)))){
return (new membrane.ui.AffineTransform(G__31339,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31383.cljs$core$IFn$_invoke$arity$2 ? pred__31383.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31384) : pred__31383.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31384)))){
return (new membrane.ui.AffineTransform(self__.matrix,G__31339,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31339),null));
}
}
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"matrix","matrix",803137200),self__.matrix,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31339){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.AffineTransform(self__.matrix,self__.drawable,G__31339,self__.__extmap,self__.__hash));
}));

(membrane.ui.AffineTransform.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.AffineTransform.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"matrix","matrix",-1851298569,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.AffineTransform.cljs$lang$type = true);

(membrane.ui.AffineTransform.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/AffineTransform",null,(1),null));
}));

(membrane.ui.AffineTransform.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/AffineTransform");
}));

/**
 * Positional factory function for membrane.ui/AffineTransform.
 */
membrane.ui.__GT_AffineTransform = (function membrane$ui$__GT_AffineTransform(matrix,drawable){
return (new membrane.ui.AffineTransform(matrix,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/AffineTransform, taking a map of keywords to field values.
 */
membrane.ui.map__GT_AffineTransform = (function membrane$ui$map__GT_AffineTransform(G__31349){
var extmap__4419__auto__ = (function (){var G__31398 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31349,new cljs.core.Keyword(null,"matrix","matrix",803137200),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31349)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31398);
} else {
return G__31398;
}
})();
return (new membrane.ui.AffineTransform(new cljs.core.Keyword(null,"matrix","matrix",803137200).cljs$core$IFn$_invoke$arity$1(G__31349),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31349),null,cljs.core.not_empty(extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Skew = (function (sx,sy,drawable,__meta,__extmap,__hash){
this.sx = sx;
this.sy = sy;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Skew.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Skew.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31403,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31426 = k31403;
var G__31426__$1 = (((G__31426 instanceof cljs.core.Keyword))?G__31426.fqn:null);
switch (G__31426__$1) {
case "sx":
return self__.sx;

break;
case "sy":
return self__.sy;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31403,else__4383__auto__);

}
}));

(membrane.ui.Skew.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31437){
var vec__31438 = p__31437;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31438,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31438,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Skew.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Skew{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sx","sx",-403071592),self__.sx],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sy","sy",227523849),self__.sy],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Skew.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31402){
var self__ = this;
var G__31402__$1 = this;
return (new cljs.core.RecordIter((0),G__31402__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"sx","sx",-403071592),new cljs.core.Keyword(null,"sy","sy",227523849),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Skew.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Skew.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Skew.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Skew.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1913038515 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Skew.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31404,other31405){
var self__ = this;
var this31404__$1 = this;
return (((!((other31405 == null)))) && ((this31404__$1.constructor === other31405.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31404__$1.sx,other31405.sx)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31404__$1.sy,other31405.sy)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31404__$1.drawable,other31405.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31404__$1.__extmap,other31405.__extmap)));
}));

(membrane.ui.Skew.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"sy","sy",227523849),null,new cljs.core.Keyword(null,"sx","sx",-403071592),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Skew.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31402){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31475 = cljs.core.keyword_identical_QMARK_;
var expr__31476 = k__4388__auto__;
if(cljs.core.truth_((pred__31475.cljs$core$IFn$_invoke$arity$2 ? pred__31475.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"sx","sx",-403071592),expr__31476) : pred__31475.call(null,new cljs.core.Keyword(null,"sx","sx",-403071592),expr__31476)))){
return (new membrane.ui.Skew(G__31402,self__.sy,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31475.cljs$core$IFn$_invoke$arity$2 ? pred__31475.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"sy","sy",227523849),expr__31476) : pred__31475.call(null,new cljs.core.Keyword(null,"sy","sy",227523849),expr__31476)))){
return (new membrane.ui.Skew(self__.sx,G__31402,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31475.cljs$core$IFn$_invoke$arity$2 ? pred__31475.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31476) : pred__31475.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31476)))){
return (new membrane.ui.Skew(self__.sx,self__.sy,G__31402,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31402),null));
}
}
}
}));

(membrane.ui.Skew.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sx","sx",-403071592),self__.sx,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sy","sy",227523849),self__.sy,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Skew.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31402){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Skew(self__.sx,self__.sy,self__.drawable,G__31402,self__.__extmap,self__.__hash));
}));

(membrane.ui.Skew.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Skew.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"sx","sx",1237459935,null),new cljs.core.Symbol(null,"sy","sy",1868055376,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Skew.cljs$lang$type = true);

(membrane.ui.Skew.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Skew",null,(1),null));
}));

(membrane.ui.Skew.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Skew");
}));

/**
 * Positional factory function for membrane.ui/Skew.
 */
membrane.ui.__GT_Skew = (function membrane$ui$__GT_Skew(sx,sy,drawable){
return (new membrane.ui.Skew(sx,sy,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Skew, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Skew = (function membrane$ui$map__GT_Skew(G__31413){
var extmap__4419__auto__ = (function (){var G__31502 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31413,new cljs.core.Keyword(null,"sx","sx",-403071592),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"sy","sy",227523849),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31413)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31502);
} else {
return G__31502;
}
})();
return (new membrane.ui.Skew(new cljs.core.Keyword(null,"sx","sx",-403071592).cljs$core$IFn$_invoke$arity$1(G__31413),new cljs.core.Keyword(null,"sy","sy",227523849).cljs$core$IFn$_invoke$arity$1(G__31413),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31413),null,cljs.core.not_empty(extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Spacer = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Spacer.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Spacer.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31508,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31516 = k31508;
var G__31516__$1 = (((G__31516 instanceof cljs.core.Keyword))?G__31516.fqn:null);
switch (G__31516__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31508,else__4383__auto__);

}
}));

(membrane.ui.Spacer.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31517){
var vec__31518 = p__31517;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31518,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31518,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Spacer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Spacer{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(membrane.ui.Spacer.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31507){
var self__ = this;
var G__31507__$1 = this;
return (new cljs.core.RecordIter((0),G__31507__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Spacer.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Spacer.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.x,self__.y], null);
}));

(membrane.ui.Spacer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Spacer.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Spacer(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Spacer.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Spacer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-864303194 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Spacer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31509,other31510){
var self__ = this;
var this31509__$1 = this;
return (((!((other31510 == null)))) && ((this31509__$1.constructor === other31510.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31509__$1.x,other31510.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31509__$1.y,other31510.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31509__$1.__extmap,other31510.__extmap)));
}));

(membrane.ui.Spacer.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Spacer.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Spacer.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Spacer(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Spacer.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31507){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31538 = cljs.core.keyword_identical_QMARK_;
var expr__31539 = k__4388__auto__;
if(cljs.core.truth_((pred__31538.cljs$core$IFn$_invoke$arity$2 ? pred__31538.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__31539) : pred__31538.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__31539)))){
return (new membrane.ui.Spacer(G__31507,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31538.cljs$core$IFn$_invoke$arity$2 ? pred__31538.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__31539) : pred__31538.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__31539)))){
return (new membrane.ui.Spacer(self__.x,G__31507,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Spacer(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31507),null));
}
}
}));

(membrane.ui.Spacer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(membrane.ui.Spacer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31507){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Spacer(self__.x,self__.y,G__31507,self__.__extmap,self__.__hash));
}));

(membrane.ui.Spacer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Spacer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(membrane.ui.Spacer.cljs$lang$type = true);

(membrane.ui.Spacer.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Spacer",null,(1),null));
}));

(membrane.ui.Spacer.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Spacer");
}));

/**
 * Positional factory function for membrane.ui/Spacer.
 */
membrane.ui.__GT_Spacer = (function membrane$ui$__GT_Spacer(x,y){
return (new membrane.ui.Spacer(x,y,null,null,null));
});

/**
 * Factory function for membrane.ui/Spacer, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Spacer = (function membrane$ui$map__GT_Spacer(G__31515){
var extmap__4419__auto__ = (function (){var G__31554 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31515,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__31515)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31554);
} else {
return G__31554;
}
})();
return (new membrane.ui.Spacer(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__31515),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__31515),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Spacer,(function (draw){
return (function (this$){
return null;
});
}));
/**
 * An empty graphical element with width x and height y.
 * 
 *   Useful for layout.
 */
membrane.ui.spacer = (function membrane$ui$spacer(var_args){
var G__31559 = arguments.length;
switch (G__31559) {
case 1:
return membrane.ui.spacer.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.spacer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.spacer.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new membrane.ui.Spacer(x,x,null,null,null));
}));

(membrane.ui.spacer.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new membrane.ui.Spacer(x,y,null,null,null));
}));

(membrane.ui.spacer.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.FixedBounds = (function (size,drawable,__meta,__extmap,__hash){
this.size = size;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.FixedBounds.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31567,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31579 = k31567;
var G__31579__$1 = (((G__31579 instanceof cljs.core.Keyword))?G__31579.fqn:null);
switch (G__31579__$1) {
case "size":
return self__.size;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31567,else__4383__auto__);

}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31581){
var vec__31582 = p__31581;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31582,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31582,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.FixedBounds{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31566){
var self__ = this;
var G__31566__$1 = this;
return (new cljs.core.RecordIter((0),G__31566__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.size;
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (208008287 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31568,other31569){
var self__ = this;
var this31568__$1 = this;
return (((!((other31569 == null)))) && ((this31568__$1.constructor === other31569.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31568__$1.size,other31569.size)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31568__$1.drawable,other31569.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31568__$1.__extmap,other31569.__extmap)));
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"size","size",1098693007),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31566){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31609 = cljs.core.keyword_identical_QMARK_;
var expr__31610 = k__4388__auto__;
if(cljs.core.truth_((pred__31609.cljs$core$IFn$_invoke$arity$2 ? pred__31609.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),expr__31610) : pred__31609.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__31610)))){
return (new membrane.ui.FixedBounds(G__31566,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31609.cljs$core$IFn$_invoke$arity$2 ? pred__31609.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31610) : pred__31609.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31610)))){
return (new membrane.ui.FixedBounds(self__.size,G__31566,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31566),null));
}
}
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.FixedBounds.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FixedBounds.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.FixedBounds(self__.size,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31566){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.FixedBounds(self__.size,self__.drawable,G__31566,self__.__extmap,self__.__hash));
}));

(membrane.ui.FixedBounds.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.FixedBounds.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.FixedBounds.cljs$lang$type = true);

(membrane.ui.FixedBounds.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/FixedBounds",null,(1),null));
}));

(membrane.ui.FixedBounds.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/FixedBounds");
}));

/**
 * Positional factory function for membrane.ui/FixedBounds.
 */
membrane.ui.__GT_FixedBounds = (function membrane$ui$__GT_FixedBounds(size,drawable){
return (new membrane.ui.FixedBounds(size,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/FixedBounds, taking a map of keywords to field values.
 */
membrane.ui.map__GT_FixedBounds = (function membrane$ui$map__GT_FixedBounds(G__31571){
var extmap__4419__auto__ = (function (){var G__31630 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31571,new cljs.core.Keyword(null,"size","size",1098693007),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31571)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31630);
} else {
return G__31630;
}
})();
return (new membrane.ui.FixedBounds(new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__31571),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31571),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.FixedBounds,(function (draw){
return (function (this$){
var G__31638 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__31638) : draw.call(null,G__31638));
});
}));
membrane.ui.fixed_bounds = (function membrane$ui$fixed_bounds(size,drawable){
return (new membrane.ui.FixedBounds(size,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Padding = (function (top,right,bottom,left,drawable,__meta,__extmap,__hash){
this.top = top;
this.right = right;
this.bottom = bottom;
this.left = left;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Padding.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Padding.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31654,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31670 = k31654;
var G__31670__$1 = (((G__31670 instanceof cljs.core.Keyword))?G__31670.fqn:null);
switch (G__31670__$1) {
case "top":
return self__.top;

break;
case "right":
return self__.right;

break;
case "bottom":
return self__.bottom;

break;
case "left":
return self__.left;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31654,else__4383__auto__);

}
}));

(membrane.ui.Padding.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31679){
var vec__31680 = p__31679;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31680,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31680,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Padding.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Padding.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Padding{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"top","top",-1856271961),self__.top],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"right","right",-452581833),self__.right],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"bottom","bottom",-1550509018),self__.bottom],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"left","left",-399115937),self__.left],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Padding.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31653){
var self__ = this;
var G__31653__$1 = this;
return (new cljs.core.RecordIter((0),G__31653__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Padding.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__31694 = membrane.ui.bounds(self__.drawable);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31694,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31694,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((w + self__.left) + self__.right),((h + self__.top) + self__.bottom)], null);
}));

(membrane.ui.Padding.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Padding.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Padding.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Padding.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2025201373 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Padding.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31655,other31656){
var self__ = this;
var this31655__$1 = this;
return (((!((other31656 == null)))) && ((this31655__$1.constructor === other31656.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31655__$1.top,other31656.top)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31655__$1.right,other31656.right)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31655__$1.bottom,other31656.bottom)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31655__$1.left,other31656.left)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31655__$1.drawable,other31656.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31655__$1.__extmap,other31656.__extmap)));
}));

(membrane.ui.Padding.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.left,self__.top], null);
}));

(membrane.ui.Padding.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),null,new cljs.core.Keyword(null,"top","top",-1856271961),null,new cljs.core.Keyword(null,"right","right",-452581833),null,new cljs.core.Keyword(null,"left","left",-399115937),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Padding.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31653){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31702 = cljs.core.keyword_identical_QMARK_;
var expr__31703 = k__4388__auto__;
if(cljs.core.truth_((pred__31702.cljs$core$IFn$_invoke$arity$2 ? pred__31702.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"top","top",-1856271961),expr__31703) : pred__31702.call(null,new cljs.core.Keyword(null,"top","top",-1856271961),expr__31703)))){
return (new membrane.ui.Padding(G__31653,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31702.cljs$core$IFn$_invoke$arity$2 ? pred__31702.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"right","right",-452581833),expr__31703) : pred__31702.call(null,new cljs.core.Keyword(null,"right","right",-452581833),expr__31703)))){
return (new membrane.ui.Padding(self__.top,G__31653,self__.bottom,self__.left,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31702.cljs$core$IFn$_invoke$arity$2 ? pred__31702.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"bottom","bottom",-1550509018),expr__31703) : pred__31702.call(null,new cljs.core.Keyword(null,"bottom","bottom",-1550509018),expr__31703)))){
return (new membrane.ui.Padding(self__.top,self__.right,G__31653,self__.left,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31702.cljs$core$IFn$_invoke$arity$2 ? pred__31702.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"left","left",-399115937),expr__31703) : pred__31702.call(null,new cljs.core.Keyword(null,"left","left",-399115937),expr__31703)))){
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,G__31653,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31702.cljs$core$IFn$_invoke$arity$2 ? pred__31702.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31703) : pred__31702.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31703)))){
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,G__31653,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31653),null));
}
}
}
}
}
}));

(membrane.ui.Padding.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"top","top",-1856271961),self__.top,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"right","right",-452581833),self__.right,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"bottom","bottom",-1550509018),self__.bottom,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"left","left",-399115937),self__.left,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Padding.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Padding.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Padding(self__.left,self__.right,self__.bottom,self__.top,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Padding.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31653){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Padding(self__.top,self__.right,self__.bottom,self__.left,self__.drawable,G__31653,self__.__extmap,self__.__hash));
}));

(membrane.ui.Padding.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Padding.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"top","top",-215740434,null),new cljs.core.Symbol(null,"right","right",1187949694,null),new cljs.core.Symbol(null,"bottom","bottom",90022509,null),new cljs.core.Symbol(null,"left","left",1241415590,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Padding.cljs$lang$type = true);

(membrane.ui.Padding.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Padding",null,(1),null));
}));

(membrane.ui.Padding.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Padding");
}));

/**
 * Positional factory function for membrane.ui/Padding.
 */
membrane.ui.__GT_Padding = (function membrane$ui$__GT_Padding(top,right,bottom,left,drawable){
return (new membrane.ui.Padding(top,right,bottom,left,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Padding, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Padding = (function membrane$ui$map__GT_Padding(G__31658){
var extmap__4419__auto__ = (function (){var G__31723 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31658,new cljs.core.Keyword(null,"top","top",-1856271961),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"right","right",-452581833),new cljs.core.Keyword(null,"bottom","bottom",-1550509018),new cljs.core.Keyword(null,"left","left",-399115937),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31658)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31723);
} else {
return G__31723;
}
})();
return (new membrane.ui.Padding(new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(G__31658),new cljs.core.Keyword(null,"right","right",-452581833).cljs$core$IFn$_invoke$arity$1(G__31658),new cljs.core.Keyword(null,"bottom","bottom",-1550509018).cljs$core$IFn$_invoke$arity$1(G__31658),new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(G__31658),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31658),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Padding,(function (draw){
return (function (this$){
var G__31724 = membrane.ui.translate(new cljs.core.Keyword(null,"left","left",-399115937).cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.Keyword(null,"top","top",-1856271961).cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__31724) : draw.call(null,G__31724));
});
}));
membrane.ui.padding = (function membrane$ui$padding(var_args){
var G__31726 = arguments.length;
switch (G__31726) {
case 2:
return membrane.ui.padding.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.padding.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return membrane.ui.padding.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.padding.cljs$core$IFn$_invoke$arity$2 = (function (p,elem){
return (new membrane.ui.Padding(p,p,p,p,elem,null,null,null));
}));

(membrane.ui.padding.cljs$core$IFn$_invoke$arity$3 = (function (px,py,elem){
return (new membrane.ui.Padding(py,px,py,px,elem,null,null,null));
}));

(membrane.ui.padding.cljs$core$IFn$_invoke$arity$5 = (function (top,right,bottom,left,elem){
return (new membrane.ui.Padding(top,right,bottom,left,elem,null,null,null));
}));

(membrane.ui.padding.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Path = (function (points,__meta,__extmap,__hash){
this.points = points;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Path.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Path.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31734,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31743 = k31734;
var G__31743__$1 = (((G__31743 instanceof cljs.core.Keyword))?G__31743.fqn:null);
switch (G__31743__$1) {
case "points":
return self__.points;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31734,else__4383__auto__);

}
}));

(membrane.ui.Path.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31747){
var vec__31748 = p__31747;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31748,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31748,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Path.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Path{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"points","points",-1486596883),self__.points],null))], null),self__.__extmap));
}));

(membrane.ui.Path.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31733){
var self__ = this;
var G__31733__$1 = this;
return (new cljs.core.RecordIter((0),G__31733__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"points","points",-1486596883)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Path.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Path.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var maxx = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,self__.points));
var maxy = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.second,self__.points));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [maxx,maxy], null);
}));

(membrane.ui.Path.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Path.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Path(self__.points,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Path.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Path.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1184185045 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Path.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31735,other31736){
var self__ = this;
var this31735__$1 = this;
return (((!((other31736 == null)))) && ((this31735__$1.constructor === other31736.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31735__$1.points,other31736.points)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31735__$1.__extmap,other31736.__extmap)));
}));

(membrane.ui.Path.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Path.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Path.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"points","points",-1486596883),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Path(self__.points,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Path.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31733){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31769 = cljs.core.keyword_identical_QMARK_;
var expr__31770 = k__4388__auto__;
if(cljs.core.truth_((pred__31769.cljs$core$IFn$_invoke$arity$2 ? pred__31769.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"points","points",-1486596883),expr__31770) : pred__31769.call(null,new cljs.core.Keyword(null,"points","points",-1486596883),expr__31770)))){
return (new membrane.ui.Path(G__31733,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Path(self__.points,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31733),null));
}
}));

(membrane.ui.Path.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"points","points",-1486596883),self__.points,null))], null),self__.__extmap));
}));

(membrane.ui.Path.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31733){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Path(self__.points,G__31733,self__.__extmap,self__.__hash));
}));

(membrane.ui.Path.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Path.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"points","points",153934644,null)], null);
}));

(membrane.ui.Path.cljs$lang$type = true);

(membrane.ui.Path.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Path",null,(1),null));
}));

(membrane.ui.Path.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Path");
}));

/**
 * Positional factory function for membrane.ui/Path.
 */
membrane.ui.__GT_Path = (function membrane$ui$__GT_Path(points){
return (new membrane.ui.Path(points,null,null,null));
});

/**
 * Factory function for membrane.ui/Path, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Path = (function membrane$ui$map__GT_Path(G__31737){
var extmap__4419__auto__ = (function (){var G__31773 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__31737,new cljs.core.Keyword(null,"points","points",-1486596883));
if(cljs.core.record_QMARK_(G__31737)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31773);
} else {
return G__31773;
}
})();
return (new membrane.ui.Path(new cljs.core.Keyword(null,"points","points",-1486596883).cljs$core$IFn$_invoke$arity$1(G__31737),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * A graphical element that will draw lines connecting points.
 * 
 *   See with-style, with-stroke-width, and with-color for more options.
 */
membrane.ui.path = (function membrane$ui$path(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33621 = arguments.length;
var i__4737__auto___33622 = (0);
while(true){
if((i__4737__auto___33622 < len__4736__auto___33621)){
args__4742__auto__.push((arguments[i__4737__auto___33622]));

var G__33623 = (i__4737__auto___33622 + (1));
i__4737__auto___33622 = G__33623;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic = (function (points){
return (new membrane.ui.Path(points,null,null,null));
}));

(membrane.ui.path.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.path.cljs$lang$applyTo = (function (seq31783){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq31783));
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.WithColor = (function (color,drawables,__meta,__extmap,__hash){
this.color = color;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.WithColor.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.WithColor.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31793,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31801 = k31793;
var G__31801__$1 = (((G__31801 instanceof cljs.core.Keyword))?G__31801.fqn:null);
switch (G__31801__$1) {
case "color":
return self__.color;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31793,else__4383__auto__);

}
}));

(membrane.ui.WithColor.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31806){
var vec__31807 = p__31806;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31807,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31807,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.WithColor.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.WithColor.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.WithColor{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"color","color",1011675173),self__.color],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.WithColor.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31792){
var self__ = this;
var G__31792__$1 = this;
return (new cljs.core.RecordIter((0),G__31792__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.WithColor.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__31820,elem){
var vec__31821 = p__31820;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31821,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31821,(1),null);
var vec__31824 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31824,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31824,(1),null);
var vec__31827 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31827,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31827,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.WithColor.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.WithColor.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.WithColor(self__.color,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithColor.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.WithColor.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (505438910 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.WithColor.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31794,other31795){
var self__ = this;
var this31794__$1 = this;
return (((!((other31795 == null)))) && ((this31794__$1.constructor === other31795.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31794__$1.color,other31795.color)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31794__$1.drawables,other31795.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31794__$1.__extmap,other31795.__extmap)));
}));

(membrane.ui.WithColor.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.WithColor.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.WithColor(self__.color,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.WithColor.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31792){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31835 = cljs.core.keyword_identical_QMARK_;
var expr__31836 = k__4388__auto__;
if(cljs.core.truth_((pred__31835.cljs$core$IFn$_invoke$arity$2 ? pred__31835.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"color","color",1011675173),expr__31836) : pred__31835.call(null,new cljs.core.Keyword(null,"color","color",1011675173),expr__31836)))){
return (new membrane.ui.WithColor(G__31792,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31835.cljs$core$IFn$_invoke$arity$2 ? pred__31835.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31836) : pred__31835.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31836)))){
return (new membrane.ui.WithColor(self__.color,G__31792,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.WithColor(self__.color,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31792),null));
}
}
}));

(membrane.ui.WithColor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"color","color",1011675173),self__.color,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.WithColor.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithColor.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.WithColor(self__.color,childs,null,null,null));
}));

(membrane.ui.WithColor.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31792){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.WithColor(self__.color,self__.drawables,G__31792,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithColor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.WithColor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"color","color",-1642760596,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.WithColor.cljs$lang$type = true);

(membrane.ui.WithColor.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/WithColor",null,(1),null));
}));

(membrane.ui.WithColor.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/WithColor");
}));

/**
 * Positional factory function for membrane.ui/WithColor.
 */
membrane.ui.__GT_WithColor = (function membrane$ui$__GT_WithColor(color,drawables){
return (new membrane.ui.WithColor(color,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/WithColor, taking a map of keywords to field values.
 */
membrane.ui.map__GT_WithColor = (function membrane$ui$map__GT_WithColor(G__31798){
var extmap__4419__auto__ = (function (){var G__31838 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31798,new cljs.core.Keyword(null,"color","color",1011675173),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__31798)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31838);
} else {
return G__31838;
}
})();
return (new membrane.ui.WithColor(new cljs.core.Keyword(null,"color","color",1011675173).cljs$core$IFn$_invoke$arity$1(G__31798),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__31798),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Use color for all children. Color is a vector of [r g b] or [r g b a]. All values should be between 0 and 1 inclusive.
 */
membrane.ui.with_color = (function membrane$ui$with_color(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33629 = arguments.length;
var i__4737__auto___33630 = (0);
while(true){
if((i__4737__auto___33630 < len__4736__auto___33629)){
args__4742__auto__.push((arguments[i__4737__auto___33630]));

var G__33631 = (i__4737__auto___33630 + (1));
i__4737__auto___33630 = G__33631;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic = (function (color,drawables){
return (new membrane.ui.WithColor(color,drawables,null,null,null));
}));

(membrane.ui.with_color.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.with_color.cljs$lang$applyTo = (function (seq31839){
var G__31840 = cljs.core.first(seq31839);
var seq31839__$1 = cljs.core.next(seq31839);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31840,seq31839__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.WithStyle = (function (style,drawables,__meta,__extmap,__hash){
this.style = style;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.WithStyle.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.WithStyle.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31842,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31846 = k31842;
var G__31846__$1 = (((G__31846 instanceof cljs.core.Keyword))?G__31846.fqn:null);
switch (G__31846__$1) {
case "style":
return self__.style;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31842,else__4383__auto__);

}
}));

(membrane.ui.WithStyle.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31847){
var vec__31848 = p__31847;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31848,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31848,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.WithStyle.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.WithStyle{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"style","style",-496642736),self__.style],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.WithStyle.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31841){
var self__ = this;
var G__31841__$1 = this;
return (new cljs.core.RecordIter((0),G__31841__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawables);
}));

(membrane.ui.WithStyle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.WithStyle.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.WithStyle(self__.style,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStyle.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.WithStyle.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (542819839 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.WithStyle.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31843,other31844){
var self__ = this;
var this31843__$1 = this;
return (((!((other31844 == null)))) && ((this31843__$1.constructor === other31844.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31843__$1.style,other31844.style)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31843__$1.drawables,other31844.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31843__$1.__extmap,other31844.__extmap)));
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.WithStyle.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"style","style",-496642736),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.WithStyle(self__.style,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.WithStyle.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31841){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31851 = cljs.core.keyword_identical_QMARK_;
var expr__31852 = k__4388__auto__;
if(cljs.core.truth_((pred__31851.cljs$core$IFn$_invoke$arity$2 ? pred__31851.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"style","style",-496642736),expr__31852) : pred__31851.call(null,new cljs.core.Keyword(null,"style","style",-496642736),expr__31852)))){
return (new membrane.ui.WithStyle(G__31841,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31851.cljs$core$IFn$_invoke$arity$2 ? pred__31851.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31852) : pred__31851.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31852)))){
return (new membrane.ui.WithStyle(self__.style,G__31841,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.WithStyle(self__.style,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31841),null));
}
}
}));

(membrane.ui.WithStyle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"style","style",-496642736),self__.style,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.WithStyle.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStyle.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.WithStyle(self__.style,childs,null,null,null));
}));

(membrane.ui.WithStyle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31841){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.WithStyle(self__.style,self__.drawables,G__31841,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStyle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.WithStyle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"style","style",1143888791,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.WithStyle.cljs$lang$type = true);

(membrane.ui.WithStyle.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/WithStyle",null,(1),null));
}));

(membrane.ui.WithStyle.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/WithStyle");
}));

/**
 * Positional factory function for membrane.ui/WithStyle.
 */
membrane.ui.__GT_WithStyle = (function membrane$ui$__GT_WithStyle(style,drawables){
return (new membrane.ui.WithStyle(style,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/WithStyle, taking a map of keywords to field values.
 */
membrane.ui.map__GT_WithStyle = (function membrane$ui$map__GT_WithStyle(G__31845){
var extmap__4419__auto__ = (function (){var G__31854 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31845,new cljs.core.Keyword(null,"style","style",-496642736),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__31845)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31854);
} else {
return G__31854;
}
})();
return (new membrane.ui.WithStyle(new cljs.core.Keyword(null,"style","style",-496642736).cljs$core$IFn$_invoke$arity$1(G__31845),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__31845),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Style for drawing paths and polygons
 * 
 *   style is one of:
 * :membrane.ui/style-fill
 * :membrane.ui/style-stroke
 * :membrane.ui/style-stroke-and-fill
 */
membrane.ui.with_style = (function membrane$ui$with_style(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33641 = arguments.length;
var i__4737__auto___33642 = (0);
while(true){
if((i__4737__auto___33642 < len__4736__auto___33641)){
args__4742__auto__.push((arguments[i__4737__auto___33642]));

var G__33643 = (i__4737__auto___33642 + (1));
i__4737__auto___33642 = G__33643;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic = (function (style,drawables){
return (new membrane.ui.WithStyle(style,cljs.core.vec(drawables),null,null,null));
}));

(membrane.ui.with_style.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.with_style.cljs$lang$applyTo = (function (seq31855){
var G__31856 = cljs.core.first(seq31855);
var seq31855__$1 = cljs.core.next(seq31855);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31856,seq31855__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.WithStrokeWidth = (function (stroke_width,drawables,__meta,__extmap,__hash){
this.stroke_width = stroke_width;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.WithStrokeWidth.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31858,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31862 = k31858;
var G__31862__$1 = (((G__31862 instanceof cljs.core.Keyword))?G__31862.fqn:null);
switch (G__31862__$1) {
case "stroke-width":
return self__.stroke_width;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31858,else__4383__auto__);

}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31863){
var vec__31864 = p__31863;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31864,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31864,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.WithStrokeWidth{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),self__.stroke_width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31857){
var self__ = this;
var G__31857__$1 = this;
return (new cljs.core.RecordIter((0),G__31857__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawables);
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (335234124 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31859,other31860){
var self__ = this;
var this31859__$1 = this;
return (((!((other31860 == null)))) && ((this31859__$1.constructor === other31860.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31859__$1.stroke_width,other31860.stroke_width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31859__$1.drawables,other31860.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31859__$1.__extmap,other31860.__extmap)));
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31857){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31867 = cljs.core.keyword_identical_QMARK_;
var expr__31868 = k__4388__auto__;
if(cljs.core.truth_((pred__31867.cljs$core$IFn$_invoke$arity$2 ? pred__31867.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),expr__31868) : pred__31867.call(null,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),expr__31868)))){
return (new membrane.ui.WithStrokeWidth(G__31857,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31867.cljs$core$IFn$_invoke$arity$2 ? pred__31867.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31868) : pred__31867.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31868)))){
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,G__31857,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31857),null));
}
}
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),self__.stroke_width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.WithStrokeWidth.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,childs,null,null,null));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31857){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.WithStrokeWidth(self__.stroke_width,self__.drawables,G__31857,self__.__extmap,self__.__hash));
}));

(membrane.ui.WithStrokeWidth.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.WithStrokeWidth.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"stroke-width","stroke-width",-1937599334,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.WithStrokeWidth.cljs$lang$type = true);

(membrane.ui.WithStrokeWidth.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/WithStrokeWidth",null,(1),null));
}));

(membrane.ui.WithStrokeWidth.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/WithStrokeWidth");
}));

/**
 * Positional factory function for membrane.ui/WithStrokeWidth.
 */
membrane.ui.__GT_WithStrokeWidth = (function membrane$ui$__GT_WithStrokeWidth(stroke_width,drawables){
return (new membrane.ui.WithStrokeWidth(stroke_width,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/WithStrokeWidth, taking a map of keywords to field values.
 */
membrane.ui.map__GT_WithStrokeWidth = (function membrane$ui$map__GT_WithStrokeWidth(G__31861){
var extmap__4419__auto__ = (function (){var G__31870 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31861,new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__31861)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31870);
} else {
return G__31870;
}
})();
return (new membrane.ui.WithStrokeWidth(new cljs.core.Keyword(null,"stroke-width","stroke-width",716836435).cljs$core$IFn$_invoke$arity$1(G__31861),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__31861),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Set the stroke width for drawables.
 */
membrane.ui.with_stroke_width = (function membrane$ui$with_stroke_width(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33660 = arguments.length;
var i__4737__auto___33661 = (0);
while(true){
if((i__4737__auto___33661 < len__4736__auto___33660)){
args__4742__auto__.push((arguments[i__4737__auto___33661]));

var G__33662 = (i__4737__auto___33661 + (1));
i__4737__auto___33661 = G__33662;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic = (function (stroke_width,drawables){
return (new membrane.ui.WithStrokeWidth(stroke_width,cljs.core.vec(drawables),null,null,null));
}));

(membrane.ui.with_stroke_width.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.with_stroke_width.cljs$lang$applyTo = (function (seq31871){
var G__31872 = cljs.core.first(seq31871);
var seq31871__$1 = cljs.core.next(seq31871);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31872,seq31871__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Scale = (function (scalars,drawables,__meta,__extmap,__hash){
this.scalars = scalars;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Scale.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Scale.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31874,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31878 = k31874;
var G__31878__$1 = (((G__31878 instanceof cljs.core.Keyword))?G__31878.fqn:null);
switch (G__31878__$1) {
case "scalars":
return self__.scalars;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31874,else__4383__auto__);

}
}));

(membrane.ui.Scale.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31879){
var vec__31880 = p__31879;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31880,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31880,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Scale.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.Scale.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Scale{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"scalars","scalars",-350192527),self__.scalars],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.Scale.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31873){
var self__ = this;
var G__31873__$1 = this;
return (new cljs.core.RecordIter((0),G__31873__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"scalars","scalars",-350192527),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Scale.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__31883 = membrane.ui.bounds(self__.drawables);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31883,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31883,(1),null);
var vec__31886 = self__.scalars;
var sx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31886,(0),null);
var sy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31886,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(w * sx),(h * sy)], null);
}));

(membrane.ui.Scale.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Scale.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Scale(self__.scalars,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Scale.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Scale.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1872230439 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Scale.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31875,other31876){
var self__ = this;
var this31875__$1 = this;
return (((!((other31876 == null)))) && ((this31875__$1.constructor === other31876.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31875__$1.scalars,other31876.scalars)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31875__$1.drawables,other31876.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31875__$1.__extmap,other31876.__extmap)));
}));

(membrane.ui.Scale.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Scale.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"scalars","scalars",-350192527),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Scale(self__.scalars,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Scale.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31873){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31889 = cljs.core.keyword_identical_QMARK_;
var expr__31890 = k__4388__auto__;
if(cljs.core.truth_((pred__31889.cljs$core$IFn$_invoke$arity$2 ? pred__31889.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"scalars","scalars",-350192527),expr__31890) : pred__31889.call(null,new cljs.core.Keyword(null,"scalars","scalars",-350192527),expr__31890)))){
return (new membrane.ui.Scale(G__31873,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31889.cljs$core$IFn$_invoke$arity$2 ? pred__31889.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31890) : pred__31889.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__31890)))){
return (new membrane.ui.Scale(self__.scalars,G__31873,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Scale(self__.scalars,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31873),null));
}
}
}));

(membrane.ui.Scale.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"scalars","scalars",-350192527),self__.scalars,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.Scale.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Scale.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.Scale(self__.scalars,childs,null,null,null));
}));

(membrane.ui.Scale.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31873){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Scale(self__.scalars,self__.drawables,G__31873,self__.__extmap,self__.__hash));
}));

(membrane.ui.Scale.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Scale.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"scalars","scalars",1290339000,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.Scale.cljs$lang$type = true);

(membrane.ui.Scale.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Scale",null,(1),null));
}));

(membrane.ui.Scale.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Scale");
}));

/**
 * Positional factory function for membrane.ui/Scale.
 */
membrane.ui.__GT_Scale = (function membrane$ui$__GT_Scale(scalars,drawables){
return (new membrane.ui.Scale(scalars,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/Scale, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Scale = (function membrane$ui$map__GT_Scale(G__31877){
var extmap__4419__auto__ = (function (){var G__31892 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31877,new cljs.core.Keyword(null,"scalars","scalars",-350192527),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__31877)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31892);
} else {
return G__31892;
}
})();
return (new membrane.ui.Scale(new cljs.core.Keyword(null,"scalars","scalars",-350192527).cljs$core$IFn$_invoke$arity$1(G__31877),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__31877),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Draw drawables using scalars which is a vector of [scale-x scale-y]
 */
membrane.ui.scale = (function membrane$ui$scale(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33688 = arguments.length;
var i__4737__auto___33689 = (0);
while(true){
if((i__4737__auto___33689 < len__4736__auto___33688)){
args__4742__auto__.push((arguments[i__4737__auto___33689]));

var G__33690 = (i__4737__auto___33689 + (1));
i__4737__auto___33689 = G__33690;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return membrane.ui.scale.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(membrane.ui.scale.cljs$core$IFn$_invoke$arity$variadic = (function (sx,sy,drawables){
return (new membrane.ui.Scale(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sx,sy], null),cljs.core.vec(drawables),null,null,null));
}));

(membrane.ui.scale.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(membrane.ui.scale.cljs$lang$applyTo = (function (seq31893){
var G__31894 = cljs.core.first(seq31893);
var seq31893__$1 = cljs.core.next(seq31893);
var G__31895 = cljs.core.first(seq31893__$1);
var seq31893__$2 = cljs.core.next(seq31893__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31894,G__31895,seq31893__$2);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Arc = (function (radius,rad_start,rad_end,steps,__meta,__extmap,__hash){
this.radius = radius;
this.rad_start = rad_start;
this.rad_end = rad_end;
this.steps = steps;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Arc.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Arc.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31897,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31901 = k31897;
var G__31901__$1 = (((G__31901 instanceof cljs.core.Keyword))?G__31901.fqn:null);
switch (G__31901__$1) {
case "radius":
return self__.radius;

break;
case "rad-start":
return self__.rad_start;

break;
case "rad-end":
return self__.rad_end;

break;
case "steps":
return self__.steps;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31897,else__4383__auto__);

}
}));

(membrane.ui.Arc.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31902){
var vec__31903 = p__31902;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31903,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31903,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Arc.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Arc{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"radius","radius",-2073122258),self__.radius],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rad-start","rad-start",134012724),self__.rad_start],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),self__.rad_end],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"steps","steps",-128433302),self__.steps],null))], null),self__.__extmap));
}));

(membrane.ui.Arc.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31896){
var self__ = this;
var G__31896__$1 = this;
return (new cljs.core.RecordIter((0),G__31896__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"radius","radius",-2073122258),new cljs.core.Keyword(null,"rad-start","rad-start",134012724),new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),new cljs.core.Keyword(null,"steps","steps",-128433302)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Arc.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Arc.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Arc.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Arc.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Arc.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (4 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Arc.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-661039756 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Arc.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31898,other31899){
var self__ = this;
var this31898__$1 = this;
return (((!((other31899 == null)))) && ((this31898__$1.constructor === other31899.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31898__$1.radius,other31899.radius)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31898__$1.rad_start,other31899.rad_start)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31898__$1.rad_end,other31899.rad_end)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31898__$1.steps,other31899.steps)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31898__$1.__extmap,other31899.__extmap)));
}));

(membrane.ui.Arc.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Arc.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Arc.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),null,new cljs.core.Keyword(null,"steps","steps",-128433302),null,new cljs.core.Keyword(null,"radius","radius",-2073122258),null,new cljs.core.Keyword(null,"rad-start","rad-start",134012724),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Arc.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31896){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31906 = cljs.core.keyword_identical_QMARK_;
var expr__31907 = k__4388__auto__;
if(cljs.core.truth_((pred__31906.cljs$core$IFn$_invoke$arity$2 ? pred__31906.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"radius","radius",-2073122258),expr__31907) : pred__31906.call(null,new cljs.core.Keyword(null,"radius","radius",-2073122258),expr__31907)))){
return (new membrane.ui.Arc(G__31896,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31906.cljs$core$IFn$_invoke$arity$2 ? pred__31906.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"rad-start","rad-start",134012724),expr__31907) : pred__31906.call(null,new cljs.core.Keyword(null,"rad-start","rad-start",134012724),expr__31907)))){
return (new membrane.ui.Arc(self__.radius,G__31896,self__.rad_end,self__.steps,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31906.cljs$core$IFn$_invoke$arity$2 ? pred__31906.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),expr__31907) : pred__31906.call(null,new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),expr__31907)))){
return (new membrane.ui.Arc(self__.radius,self__.rad_start,G__31896,self__.steps,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31906.cljs$core$IFn$_invoke$arity$2 ? pred__31906.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"steps","steps",-128433302),expr__31907) : pred__31906.call(null,new cljs.core.Keyword(null,"steps","steps",-128433302),expr__31907)))){
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,G__31896,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31896),null));
}
}
}
}
}));

(membrane.ui.Arc.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"radius","radius",-2073122258),self__.radius,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rad-start","rad-start",134012724),self__.rad_start,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),self__.rad_end,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"steps","steps",-128433302),self__.steps,null))], null),self__.__extmap));
}));

(membrane.ui.Arc.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31896){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Arc(self__.radius,self__.rad_start,self__.rad_end,self__.steps,G__31896,self__.__extmap,self__.__hash));
}));

(membrane.ui.Arc.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Arc.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"radius","radius",-432590731,null),new cljs.core.Symbol(null,"rad-start","rad-start",1774544251,null),new cljs.core.Symbol(null,"rad-end","rad-end",109446828,null),new cljs.core.Symbol(null,"steps","steps",1512098225,null)], null);
}));

(membrane.ui.Arc.cljs$lang$type = true);

(membrane.ui.Arc.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Arc",null,(1),null));
}));

(membrane.ui.Arc.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Arc");
}));

/**
 * Positional factory function for membrane.ui/Arc.
 */
membrane.ui.__GT_Arc = (function membrane$ui$__GT_Arc(radius,rad_start,rad_end,steps){
return (new membrane.ui.Arc(radius,rad_start,rad_end,steps,null,null,null));
});

/**
 * Factory function for membrane.ui/Arc, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Arc = (function membrane$ui$map__GT_Arc(G__31900){
var extmap__4419__auto__ = (function (){var G__31909 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31900,new cljs.core.Keyword(null,"radius","radius",-2073122258),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"rad-start","rad-start",134012724),new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699),new cljs.core.Keyword(null,"steps","steps",-128433302)], 0));
if(cljs.core.record_QMARK_(G__31900)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31909);
} else {
return G__31909;
}
})();
return (new membrane.ui.Arc(new cljs.core.Keyword(null,"radius","radius",-2073122258).cljs$core$IFn$_invoke$arity$1(G__31900),new cljs.core.Keyword(null,"rad-start","rad-start",134012724).cljs$core$IFn$_invoke$arity$1(G__31900),new cljs.core.Keyword(null,"rad-end","rad-end",-1531084699).cljs$core$IFn$_invoke$arity$1(G__31900),new cljs.core.Keyword(null,"steps","steps",-128433302).cljs$core$IFn$_invoke$arity$1(G__31900),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.arc = (function membrane$ui$arc(radius,rad_start,rad_end){
return (new membrane.ui.Arc(radius,rad_start,rad_end,(10),null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Rectangle = (function (width,height,__meta,__extmap,__hash){
this.width = width;
this.height = height;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Rectangle.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Rectangle.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31911,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31915 = k31911;
var G__31915__$1 = (((G__31915 instanceof cljs.core.Keyword))?G__31915.fqn:null);
switch (G__31915__$1) {
case "width":
return self__.width;

break;
case "height":
return self__.height;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31911,else__4383__auto__);

}
}));

(membrane.ui.Rectangle.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31916){
var vec__31917 = p__31916;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31917,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31917,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Rectangle.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Rectangle{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"width","width",-384071477),self__.width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"height","height",1025178622),self__.height],null))], null),self__.__extmap));
}));

(membrane.ui.Rectangle.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31910){
var self__ = this;
var G__31910__$1 = this;
return (new cljs.core.RecordIter((0),G__31910__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"height","height",1025178622)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Rectangle.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rectangle.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.width,self__.height], null);
}));

(membrane.ui.Rectangle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Rectangle.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Rectangle(self__.width,self__.height,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rectangle.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Rectangle.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (833278147 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Rectangle.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31912,other31913){
var self__ = this;
var this31912__$1 = this;
return (((!((other31913 == null)))) && ((this31912__$1.constructor === other31913.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31912__$1.width,other31913.width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31912__$1.height,other31913.height)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31912__$1.__extmap,other31913.__extmap)));
}));

(membrane.ui.Rectangle.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Rectangle.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Rectangle.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"height","height",1025178622),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Rectangle(self__.width,self__.height,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Rectangle.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31910){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31920 = cljs.core.keyword_identical_QMARK_;
var expr__31921 = k__4388__auto__;
if(cljs.core.truth_((pred__31920.cljs$core$IFn$_invoke$arity$2 ? pred__31920.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"width","width",-384071477),expr__31921) : pred__31920.call(null,new cljs.core.Keyword(null,"width","width",-384071477),expr__31921)))){
return (new membrane.ui.Rectangle(G__31910,self__.height,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31920.cljs$core$IFn$_invoke$arity$2 ? pred__31920.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"height","height",1025178622),expr__31921) : pred__31920.call(null,new cljs.core.Keyword(null,"height","height",1025178622),expr__31921)))){
return (new membrane.ui.Rectangle(self__.width,G__31910,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Rectangle(self__.width,self__.height,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31910),null));
}
}
}));

(membrane.ui.Rectangle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"width","width",-384071477),self__.width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"height","height",1025178622),self__.height,null))], null),self__.__extmap));
}));

(membrane.ui.Rectangle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31910){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Rectangle(self__.width,self__.height,G__31910,self__.__extmap,self__.__hash));
}));

(membrane.ui.Rectangle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Rectangle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"height","height",-1629257147,null)], null);
}));

(membrane.ui.Rectangle.cljs$lang$type = true);

(membrane.ui.Rectangle.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Rectangle",null,(1),null));
}));

(membrane.ui.Rectangle.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Rectangle");
}));

/**
 * Positional factory function for membrane.ui/Rectangle.
 */
membrane.ui.__GT_Rectangle = (function membrane$ui$__GT_Rectangle(width,height){
return (new membrane.ui.Rectangle(width,height,null,null,null));
});

/**
 * Factory function for membrane.ui/Rectangle, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Rectangle = (function membrane$ui$map__GT_Rectangle(G__31914){
var extmap__4419__auto__ = (function (){var G__31923 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31914,new cljs.core.Keyword(null,"width","width",-384071477),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"height","height",1025178622)], 0));
if(cljs.core.record_QMARK_(G__31914)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31923);
} else {
return G__31923;
}
})();
return (new membrane.ui.Rectangle(new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(G__31914),new cljs.core.Keyword(null,"height","height",1025178622).cljs$core$IFn$_invoke$arity$1(G__31914),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Rectangle,(function (draw){
return (function (this$){
var map__31924 = this$;
var map__31924__$1 = (((((!((map__31924 == null))))?(((((map__31924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31924):map__31924);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31924__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31924__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var G__31926 = membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),height], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [width,height], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [width,(0)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null)], 0));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__31926) : draw.call(null,G__31926));
});
}));
/**
 * Graphical elem that draws a rectangle.
 * 
 *   See with-style, with-stroke-width, and with-color for more options.
 */
membrane.ui.rectangle = (function membrane$ui$rectangle(width,height){
return (new membrane.ui.Rectangle(width,height,null,null,null));
});
/**
 * Graphical elem that draws a filled rectangle with color, [r g b] or [r g b a].
 */
membrane.ui.filled_rectangle = (function membrane$ui$filled_rectangle(color,width,height){
return membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(color,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-fill","membrane.ui/style-fill",1620230388),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new membrane.ui.Rectangle(width,height,null,null,null))], 0))], 0));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.RoundedRectangle = (function (width,height,border_radius,__meta,__extmap,__hash){
this.width = width;
this.height = height;
this.border_radius = border_radius;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.RoundedRectangle.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31928,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31932 = k31928;
var G__31932__$1 = (((G__31932 instanceof cljs.core.Keyword))?G__31932.fqn:null);
switch (G__31932__$1) {
case "width":
return self__.width;

break;
case "height":
return self__.height;

break;
case "border-radius":
return self__.border_radius;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31928,else__4383__auto__);

}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31933){
var vec__31934 = p__31933;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31934,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31934,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.RoundedRectangle{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"width","width",-384071477),self__.width],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"height","height",1025178622),self__.height],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"border-radius","border-radius",419594011),self__.border_radius],null))], null),self__.__extmap));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31927){
var self__ = this;
var G__31927__$1 = this;
return (new cljs.core.RecordIter((0),G__31927__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"border-radius","border-radius",419594011)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.width,self__.height], null);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1334660464 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31929,other31930){
var self__ = this;
var this31929__$1 = this;
return (((!((other31930 == null)))) && ((this31929__$1.constructor === other31930.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31929__$1.width,other31930.width)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31929__$1.height,other31930.height)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31929__$1.border_radius,other31930.border_radius)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31929__$1.__extmap,other31930.__extmap)));
}));

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.RoundedRectangle.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"width","width",-384071477),null,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),null,new cljs.core.Keyword(null,"height","height",1025178622),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31927){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31937 = cljs.core.keyword_identical_QMARK_;
var expr__31938 = k__4388__auto__;
if(cljs.core.truth_((pred__31937.cljs$core$IFn$_invoke$arity$2 ? pred__31937.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"width","width",-384071477),expr__31938) : pred__31937.call(null,new cljs.core.Keyword(null,"width","width",-384071477),expr__31938)))){
return (new membrane.ui.RoundedRectangle(G__31927,self__.height,self__.border_radius,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31937.cljs$core$IFn$_invoke$arity$2 ? pred__31937.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"height","height",1025178622),expr__31938) : pred__31937.call(null,new cljs.core.Keyword(null,"height","height",1025178622),expr__31938)))){
return (new membrane.ui.RoundedRectangle(self__.width,G__31927,self__.border_radius,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31937.cljs$core$IFn$_invoke$arity$2 ? pred__31937.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"border-radius","border-radius",419594011),expr__31938) : pred__31937.call(null,new cljs.core.Keyword(null,"border-radius","border-radius",419594011),expr__31938)))){
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,G__31927,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31927),null));
}
}
}
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"width","width",-384071477),self__.width,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"height","height",1025178622),self__.height,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"border-radius","border-radius",419594011),self__.border_radius,null))], null),self__.__extmap));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31927){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.RoundedRectangle(self__.width,self__.height,self__.border_radius,G__31927,self__.__extmap,self__.__hash));
}));

(membrane.ui.RoundedRectangle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.RoundedRectangle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"width","width",1256460050,null),new cljs.core.Symbol(null,"height","height",-1629257147,null),new cljs.core.Symbol(null,"border-radius","border-radius",2060125538,null)], null);
}));

(membrane.ui.RoundedRectangle.cljs$lang$type = true);

(membrane.ui.RoundedRectangle.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/RoundedRectangle",null,(1),null));
}));

(membrane.ui.RoundedRectangle.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/RoundedRectangle");
}));

/**
 * Positional factory function for membrane.ui/RoundedRectangle.
 */
membrane.ui.__GT_RoundedRectangle = (function membrane$ui$__GT_RoundedRectangle(width,height,border_radius){
return (new membrane.ui.RoundedRectangle(width,height,border_radius,null,null,null));
});

/**
 * Factory function for membrane.ui/RoundedRectangle, taking a map of keywords to field values.
 */
membrane.ui.map__GT_RoundedRectangle = (function membrane$ui$map__GT_RoundedRectangle(G__31931){
var extmap__4419__auto__ = (function (){var G__31940 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31931,new cljs.core.Keyword(null,"width","width",-384071477),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"border-radius","border-radius",419594011)], 0));
if(cljs.core.record_QMARK_(G__31931)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31940);
} else {
return G__31940;
}
})();
return (new membrane.ui.RoundedRectangle(new cljs.core.Keyword(null,"width","width",-384071477).cljs$core$IFn$_invoke$arity$1(G__31931),new cljs.core.Keyword(null,"height","height",1025178622).cljs$core$IFn$_invoke$arity$1(G__31931),new cljs.core.Keyword(null,"border-radius","border-radius",419594011).cljs$core$IFn$_invoke$arity$1(G__31931),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that draws a rounded rectangle.
 */
membrane.ui.rounded_rectangle = (function membrane$ui$rounded_rectangle(width,height,border_radius){
return (new membrane.ui.RoundedRectangle(width,height,border_radius,null,null,null));
});
membrane.ui.bordered_draw = (function membrane$ui$bordered_draw(this$){
var map__31941 = this$;
var map__31941__$1 = (((((!((map__31941 == null))))?(((((map__31941.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31941.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31941):map__31941);
var drawable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31941__$1,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
var padding_x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31941__$1,new cljs.core.Keyword(null,"padding-x","padding-x",762313863));
var padding_y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31941__$1,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186));
var vec__31942 = membrane.ui.bounds(drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31942,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31942,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var gray = 0.65;
return membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [gray,gray,gray], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rectangle((width + ((2) * padding_x)),(height + ((2) * padding_y)))], 0))], 0));
})(),membrane.ui.translate(padding_x,padding_y,drawable)], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Bordered = (function (padding_x,padding_y,drawable,__meta,__extmap,__hash){
this.padding_x = padding_x;
this.padding_y = padding_y;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Bordered.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Bordered.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31947,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31951 = k31947;
var G__31951__$1 = (((G__31951 instanceof cljs.core.Keyword))?G__31951.fqn:null);
switch (G__31951__$1) {
case "padding-x":
return self__.padding_x;

break;
case "padding-y":
return self__.padding_y;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31947,else__4383__auto__);

}
}));

(membrane.ui.Bordered.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31952){
var vec__31953 = p__31952;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31953,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31953,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Bordered.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bordered_draw(this$__$1);
}));

(membrane.ui.Bordered.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Bordered{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Bordered.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31946){
var self__ = this;
var G__31946__$1 = this;
return (new cljs.core.RecordIter((0),G__31946__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"padding-x","padding-x",762313863),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Bordered.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__31956 = membrane.ui.bounds(self__.drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31956,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31956,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(width + ((2) * self__.padding_x)),(height + ((2) * self__.padding_y))], null);
}));

(membrane.ui.Bordered.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Bordered.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Bordered.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Bordered.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-900094536 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Bordered.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31948,other31949){
var self__ = this;
var this31948__$1 = this;
return (((!((other31949 == null)))) && ((this31948__$1.constructor === other31949.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31948__$1.padding_x,other31949.padding_x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31948__$1.padding_y,other31949.padding_y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31948__$1.drawable,other31949.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31948__$1.__extmap,other31949.__extmap)));
}));

(membrane.ui.Bordered.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.origin(membrane.ui.bordered_draw(this$__$1));
}));

(membrane.ui.Bordered.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Bordered.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31946){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31959 = cljs.core.keyword_identical_QMARK_;
var expr__31960 = k__4388__auto__;
if(cljs.core.truth_((pred__31959.cljs$core$IFn$_invoke$arity$2 ? pred__31959.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__31960) : pred__31959.call(null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__31960)))){
return (new membrane.ui.Bordered(G__31946,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31959.cljs$core$IFn$_invoke$arity$2 ? pred__31959.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__31960) : pred__31959.call(null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__31960)))){
return (new membrane.ui.Bordered(self__.padding_x,G__31946,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31959.cljs$core$IFn$_invoke$arity$2 ? pred__31959.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31960) : pred__31959.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31960)))){
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,G__31946,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31946),null));
}
}
}
}));

(membrane.ui.Bordered.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Bordered.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Bordered.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.Bordered.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31946){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Bordered(self__.padding_x,self__.padding_y,self__.drawable,G__31946,self__.__extmap,self__.__hash));
}));

(membrane.ui.Bordered.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Bordered.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"padding-x","padding-x",-1892121906,null),new cljs.core.Symbol(null,"padding-y","padding-y",382093341,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Bordered.cljs$lang$type = true);

(membrane.ui.Bordered.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Bordered",null,(1),null));
}));

(membrane.ui.Bordered.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Bordered");
}));

/**
 * Positional factory function for membrane.ui/Bordered.
 */
membrane.ui.__GT_Bordered = (function membrane$ui$__GT_Bordered(padding_x,padding_y,drawable){
return (new membrane.ui.Bordered(padding_x,padding_y,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Bordered, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Bordered = (function membrane$ui$map__GT_Bordered(G__31950){
var extmap__4419__auto__ = (function (){var G__31962 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31950,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31950)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31962);
} else {
return G__31962;
}
})();
return (new membrane.ui.Bordered(new cljs.core.Keyword(null,"padding-x","padding-x",762313863).cljs$core$IFn$_invoke$arity$1(G__31950),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186).cljs$core$IFn$_invoke$arity$1(G__31950),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31950),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Bordered,(function (draw){
return (function (this$){
var G__31963 = membrane.ui.bordered_draw(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__31963) : draw.call(null,G__31963));
});
}));
/**
 * Graphical elem that will draw drawable with a gray border.
 */
membrane.ui.bordered = (function membrane$ui$bordered(padding,drawable){
if(cljs.core.vector_QMARK_(padding)){
var vec__31964 = padding;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31964,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31964,(1),null);
return (new membrane.ui.Bordered(px,py,drawable,null,null,null));
} else {
return (new membrane.ui.Bordered(padding,padding,drawable,null,null,null));
}
});
membrane.ui.fill_bordered_draw = (function membrane$ui$fill_bordered_draw(this$){
var map__31967 = this$;
var map__31967__$1 = (((((!((map__31967 == null))))?(((((map__31967.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31967.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31967):map__31967);
var color = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31967__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var drawable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31967__$1,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
var padding_x = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31967__$1,new cljs.core.Keyword(null,"padding-x","padding-x",762313863));
var padding_y = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31967__$1,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186));
var vec__31968 = membrane.ui.bounds(drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31968,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31968,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.filled_rectangle(color,(width + ((2) * padding_x)),(height + ((2) * padding_y))),membrane.ui.translate(padding_x,padding_y,drawable)], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.FillBordered = (function (color,padding_x,padding_y,drawable,__meta,__extmap,__hash){
this.color = color;
this.padding_x = padding_x;
this.padding_y = padding_y;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.FillBordered.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31973,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31977 = k31973;
var G__31977__$1 = (((G__31977 instanceof cljs.core.Keyword))?G__31977.fqn:null);
switch (G__31977__$1) {
case "color":
return self__.color;

break;
case "padding-x":
return self__.padding_x;

break;
case "padding-y":
return self__.padding_y;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31973,else__4383__auto__);

}
}));

(membrane.ui.FillBordered.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31978){
var vec__31979 = p__31978;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31979,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31979,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.FillBordered{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"color","color",1011675173),self__.color],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.FillBordered.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31972){
var self__ = this;
var G__31972__$1 = this;
return (new cljs.core.RecordIter((0),G__31972__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"padding-x","padding-x",762313863),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var vec__31982 = membrane.ui.bounds(self__.drawable);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31982,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31982,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(width + ((2) * self__.padding_x)),(height + ((2) * self__.padding_y))], null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.FillBordered.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.FillBordered.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (4 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.FillBordered.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-851895183 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.FillBordered.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31974,other31975){
var self__ = this;
var this31974__$1 = this;
return (((!((other31975 == null)))) && ((this31974__$1.constructor === other31975.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31974__$1.color,other31975.color)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31974__$1.padding_x,other31975.padding_x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31974__$1.padding_y,other31975.padding_y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31974__$1.drawable,other31975.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31974__$1.__extmap,other31975.__extmap)));
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.FillBordered.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"color","color",1011675173),null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.FillBordered.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31972){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__31985 = cljs.core.keyword_identical_QMARK_;
var expr__31986 = k__4388__auto__;
if(cljs.core.truth_((pred__31985.cljs$core$IFn$_invoke$arity$2 ? pred__31985.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"color","color",1011675173),expr__31986) : pred__31985.call(null,new cljs.core.Keyword(null,"color","color",1011675173),expr__31986)))){
return (new membrane.ui.FillBordered(G__31972,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31985.cljs$core$IFn$_invoke$arity$2 ? pred__31985.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__31986) : pred__31985.call(null,new cljs.core.Keyword(null,"padding-x","padding-x",762313863),expr__31986)))){
return (new membrane.ui.FillBordered(self__.color,G__31972,self__.padding_y,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31985.cljs$core$IFn$_invoke$arity$2 ? pred__31985.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__31986) : pred__31985.call(null,new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),expr__31986)))){
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,G__31972,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__31985.cljs$core$IFn$_invoke$arity$2 ? pred__31985.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31986) : pred__31985.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__31986)))){
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,G__31972,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31972),null));
}
}
}
}
}));

(membrane.ui.FillBordered.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"color","color",1011675173),self__.color,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-x","padding-x",762313863),self__.padding_x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),self__.padding_y,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.FillBordered.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.FillBordered.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.FillBordered.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31972){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.FillBordered(self__.color,self__.padding_x,self__.padding_y,self__.drawable,G__31972,self__.__extmap,self__.__hash));
}));

(membrane.ui.FillBordered.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.FillBordered.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"color","color",-1642760596,null),new cljs.core.Symbol(null,"padding-x","padding-x",-1892121906,null),new cljs.core.Symbol(null,"padding-y","padding-y",382093341,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.FillBordered.cljs$lang$type = true);

(membrane.ui.FillBordered.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/FillBordered",null,(1),null));
}));

(membrane.ui.FillBordered.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/FillBordered");
}));

/**
 * Positional factory function for membrane.ui/FillBordered.
 */
membrane.ui.__GT_FillBordered = (function membrane$ui$__GT_FillBordered(color,padding_x,padding_y,drawable){
return (new membrane.ui.FillBordered(color,padding_x,padding_y,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/FillBordered, taking a map of keywords to field values.
 */
membrane.ui.map__GT_FillBordered = (function membrane$ui$map__GT_FillBordered(G__31976){
var extmap__4419__auto__ = (function (){var G__31988 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__31976,new cljs.core.Keyword(null,"color","color",1011675173),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"padding-x","padding-x",762313863),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__31976)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__31988);
} else {
return G__31988;
}
})();
return (new membrane.ui.FillBordered(new cljs.core.Keyword(null,"color","color",1011675173).cljs$core$IFn$_invoke$arity$1(G__31976),new cljs.core.Keyword(null,"padding-x","padding-x",762313863).cljs$core$IFn$_invoke$arity$1(G__31976),new cljs.core.Keyword(null,"padding-y","padding-y",-1258438186).cljs$core$IFn$_invoke$arity$1(G__31976),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__31976),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.FillBordered,(function (draw){
return (function (this$){
var G__31989 = membrane.ui.fill_bordered_draw(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__31989) : draw.call(null,G__31989));
});
}));
/**
 * Graphical elem that will draw elem with filled border.
 */
membrane.ui.fill_bordered = (function membrane$ui$fill_bordered(color,padding,drawable){
if(cljs.core.vector_QMARK_(padding)){
var vec__31990 = padding;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31990,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31990,(1),null);
return (new membrane.ui.FillBordered(color,px,py,drawable,null,null,null));
} else {
return (new membrane.ui.FillBordered(color,padding,padding,drawable,null,null,null));
}
});
membrane.ui.draw_checkbox = (function membrane$ui$draw_checkbox(checked_QMARK_){
if(cljs.core.truth_(checked_QMARK_)){
var border = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.14901960784313725,0.5254901960784314,0.9882352941176471], null);
var fill = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.2,0.5607843137254902,0.9882352941176471], null);
return membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-fill","membrane.ui/style-fill",1620230388),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(fill,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((12),(12),(2))], 0))], 0)),membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(border,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((12),(12),(2))], 0)),membrane.ui.translate((0),(1),membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic(1.5,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),0.3], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(6)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(9)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(10),(2)], null)], 0))], 0))], 0))),membrane.ui.with_stroke_width.cljs$core$IFn$_invoke$arity$variadic(1.5,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),(1),(1)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(6)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(9)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(10),(2)], null)], 0))], 0))], 0))], null)], 0));
} else {
var gray = 0.6862745098039216;
return membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [gray,gray,gray], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((12),(12),(2))], 0))], 0));
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Checkbox = (function (checked_QMARK_,__meta,__extmap,__hash){
this.checked_QMARK_ = checked_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Checkbox.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Checkbox.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k31994,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__31998 = k31994;
var G__31998__$1 = (((G__31998 instanceof cljs.core.Keyword))?G__31998.fqn:null);
switch (G__31998__$1) {
case "checked?":
return self__.checked_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k31994,else__4383__auto__);

}
}));

(membrane.ui.Checkbox.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__31999){
var vec__32000 = p__31999;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32000,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32000,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Checkbox.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Checkbox.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.draw_checkbox(self__.checked_QMARK_)], null);
}));

(membrane.ui.Checkbox.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Checkbox{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"checked?","checked?",2024809091),self__.checked_QMARK_],null))], null),self__.__extmap));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__31993){
var self__ = this;
var G__31993__$1 = this;
return (new cljs.core.RecordIter((0),G__31993__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"checked?","checked?",2024809091)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Checkbox.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Checkbox.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(membrane.ui.draw_checkbox(self__.checked_QMARK_));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Checkbox.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Checkbox(self__.checked_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Checkbox.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1062342187 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Checkbox.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this31995,other31996){
var self__ = this;
var this31995__$1 = this;
return (((!((other31996 == null)))) && ((this31995__$1.constructor === other31996.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31995__$1.checked_QMARK_,other31996.checked_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this31995__$1.__extmap,other31996.__extmap)));
}));

(membrane.ui.Checkbox.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Checkbox.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Checkbox.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"checked?","checked?",2024809091),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Checkbox(self__.checked_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Checkbox.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__31993){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32003 = cljs.core.keyword_identical_QMARK_;
var expr__32004 = k__4388__auto__;
if(cljs.core.truth_((pred__32003.cljs$core$IFn$_invoke$arity$2 ? pred__32003.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"checked?","checked?",2024809091),expr__32004) : pred__32003.call(null,new cljs.core.Keyword(null,"checked?","checked?",2024809091),expr__32004)))){
return (new membrane.ui.Checkbox(G__31993,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Checkbox(self__.checked_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__31993),null));
}
}));

(membrane.ui.Checkbox.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"checked?","checked?",2024809091),self__.checked_QMARK_,null))], null),self__.__extmap));
}));

(membrane.ui.Checkbox.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__31993){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Checkbox(self__.checked_QMARK_,G__31993,self__.__extmap,self__.__hash));
}));

(membrane.ui.Checkbox.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Checkbox.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"checked?","checked?",-629626678,null)], null);
}));

(membrane.ui.Checkbox.cljs$lang$type = true);

(membrane.ui.Checkbox.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Checkbox",null,(1),null));
}));

(membrane.ui.Checkbox.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Checkbox");
}));

/**
 * Positional factory function for membrane.ui/Checkbox.
 */
membrane.ui.__GT_Checkbox = (function membrane$ui$__GT_Checkbox(checked_QMARK_){
return (new membrane.ui.Checkbox(checked_QMARK_,null,null,null));
});

/**
 * Factory function for membrane.ui/Checkbox, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Checkbox = (function membrane$ui$map__GT_Checkbox(G__31997){
var extmap__4419__auto__ = (function (){var G__32006 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__31997,new cljs.core.Keyword(null,"checked?","checked?",2024809091));
if(cljs.core.record_QMARK_(G__31997)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32006);
} else {
return G__32006;
}
})();
return (new membrane.ui.Checkbox(new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(G__31997),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Checkbox,(function (draw){
return (function (this$){
var G__32007 = membrane.ui.draw_checkbox(new cljs.core.Keyword(null,"checked?","checked?",2024809091).cljs$core$IFn$_invoke$arity$1(this$));
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__32007) : draw.call(null,G__32007));
});
}));
/**
 * Graphical elem that will draw a checkbox.
 */
membrane.ui.checkbox = (function membrane$ui$checkbox(checked_QMARK_){
return (new membrane.ui.Checkbox(checked_QMARK_,null,null,null));
});
/**
 * Tests whether [px py] is within  [x y width height].
 */
membrane.ui.box_contains_QMARK_ = (function membrane$ui$box_contains_QMARK_(p__32008,p__32009){
var vec__32010 = p__32008;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32010,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32010,(1),null);
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32010,(2),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32010,(3),null);
var vec__32013 = p__32009;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32013,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32013,(1),null);
return (((px <= (x + width))) && ((px >= x)) && ((py <= (y + height))) && ((py >= y)));
});
membrane.ui.button_draw = (function membrane$ui$button_draw(this$){
var text = new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(this$);
var vec__32016 = membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1(text));
var text_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32016,(0),null);
var text_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32016,(1),null);
var padding = (12);
var rect_width = (text_width + padding);
var rect_height = (text_height + padding);
var border_radius = (3);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(new cljs.core.Keyword(null,"hover?","hover?",-1201331489).cljs$core$IFn$_invoke$arity$1(this$))?membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.9,0.9,0.9], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle(rect_width,rect_height,border_radius)], 0)):null),membrane.ui.with_style.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword("membrane.ui","style-stroke","membrane.ui/style-stroke",767695743),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.76,0.76,0.76,(1)], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle((0.5 + rect_width),(0.5 + rect_height),border_radius)], 0)),membrane.ui.with_color.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.85,0.85,0.85], null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([membrane.ui.rounded_rectangle(rect_width,rect_height,border_radius)], 0))], null)], 0)),membrane.ui.translate((padding / (2)),((padding / (2)) - (2)),membrane.ui.label.cljs$core$IFn$_invoke$arity$1(text))], null);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Button = (function (text,on_click,hover_QMARK_,__meta,__extmap,__hash){
this.text = text;
this.on_click = on_click;
this.hover_QMARK_ = hover_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Button.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Button.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32020,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32024 = k32020;
var G__32024__$1 = (((G__32024 instanceof cljs.core.Keyword))?G__32024.fqn:null);
switch (G__32024__$1) {
case "text":
return self__.text;

break;
case "on-click":
return self__.on_click;

break;
case "hover?":
return self__.hover_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32020,else__4383__auto__);

}
}));

(membrane.ui.Button.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32025){
var vec__32026 = p__32025;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32026,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32026,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Button.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Button{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"text","text",-1790561697),self__.text],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"hover?","hover?",-1201331489),self__.hover_QMARK_],null))], null),self__.__extmap));
}));

(membrane.ui.Button.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32019){
var self__ = this;
var G__32019__$1 = this;
return (new cljs.core.RecordIter((0),G__32019__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"hover?","hover?",-1201331489)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Button.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Button.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var and__4115__auto__ = mouse_down_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return self__.on_click;
} else {
return and__4115__auto__;
}
})())){
return (self__.on_click.cljs$core$IFn$_invoke$arity$0 ? self__.on_click.cljs$core$IFn$_invoke$arity$0() : self__.on_click.call(null));
} else {
return null;
}
}));

(membrane.ui.Button.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Button.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var vec__32029 = membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1(self__.text));
var text_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32029,(0),null);
var text_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32029,(1),null);
var padding = (12);
var btn_width = (text_width + padding);
var btn_height = (text_height + padding);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [btn_width,btn_height], null);
}));

(membrane.ui.Button.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Button.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Button.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Button.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-534561442 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Button.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32021,other32022){
var self__ = this;
var this32021__$1 = this;
return (((!((other32022 == null)))) && ((this32021__$1.constructor === other32022.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32021__$1.text,other32022.text)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32021__$1.on_click,other32022.on_click)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32021__$1.hover_QMARK_,other32022.hover_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32021__$1.__extmap,other32022.__extmap)));
}));

(membrane.ui.Button.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Button.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.Button.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"text","text",-1790561697),null,new cljs.core.Keyword(null,"hover?","hover?",-1201331489),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Button.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32019){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32032 = cljs.core.keyword_identical_QMARK_;
var expr__32033 = k__4388__auto__;
if(cljs.core.truth_((pred__32032.cljs$core$IFn$_invoke$arity$2 ? pred__32032.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"text","text",-1790561697),expr__32033) : pred__32032.call(null,new cljs.core.Keyword(null,"text","text",-1790561697),expr__32033)))){
return (new membrane.ui.Button(G__32019,self__.on_click,self__.hover_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32032.cljs$core$IFn$_invoke$arity$2 ? pred__32032.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__32033) : pred__32032.call(null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__32033)))){
return (new membrane.ui.Button(self__.text,G__32019,self__.hover_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32032.cljs$core$IFn$_invoke$arity$2 ? pred__32032.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"hover?","hover?",-1201331489),expr__32033) : pred__32032.call(null,new cljs.core.Keyword(null,"hover?","hover?",-1201331489),expr__32033)))){
return (new membrane.ui.Button(self__.text,self__.on_click,G__32019,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32019),null));
}
}
}
}));

(membrane.ui.Button.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"text","text",-1790561697),self__.text,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"hover?","hover?",-1201331489),self__.hover_QMARK_,null))], null),self__.__extmap));
}));

(membrane.ui.Button.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32019){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Button(self__.text,self__.on_click,self__.hover_QMARK_,G__32019,self__.__extmap,self__.__hash));
}));

(membrane.ui.Button.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Button.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"text","text",-150030170,null),new cljs.core.Symbol(null,"on-click","on-click",-1021609226,null),new cljs.core.Symbol(null,"hover?","hover?",439200038,null)], null);
}));

(membrane.ui.Button.cljs$lang$type = true);

(membrane.ui.Button.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Button",null,(1),null));
}));

(membrane.ui.Button.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Button");
}));

/**
 * Positional factory function for membrane.ui/Button.
 */
membrane.ui.__GT_Button = (function membrane$ui$__GT_Button(text,on_click,hover_QMARK_){
return (new membrane.ui.Button(text,on_click,hover_QMARK_,null,null,null));
});

/**
 * Factory function for membrane.ui/Button, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Button = (function membrane$ui$map__GT_Button(G__32023){
var extmap__4419__auto__ = (function (){var G__32035 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32023,new cljs.core.Keyword(null,"text","text",-1790561697),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"hover?","hover?",-1201331489)], 0));
if(cljs.core.record_QMARK_(G__32023)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32035);
} else {
return G__32035;
}
})();
return (new membrane.ui.Button(new cljs.core.Keyword(null,"text","text",-1790561697).cljs$core$IFn$_invoke$arity$1(G__32023),new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(G__32023),new cljs.core.Keyword(null,"hover?","hover?",-1201331489).cljs$core$IFn$_invoke$arity$1(G__32023),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.Button,(function (draw){
return (function (this$){
var G__32036 = membrane.ui.button_draw(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__32036) : draw.call(null,G__32036));
});
}));
/**
 * Graphical elem that draws a button. Optional on-click function may be provided that is called with no arguments when button has a mouse-down event.
 */
membrane.ui.button = (function membrane$ui$button(var_args){
var G__32038 = arguments.length;
switch (G__32038) {
case 1:
return membrane.ui.button.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return membrane.ui.button.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return membrane.ui.button.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.button.cljs$core$IFn$_invoke$arity$1 = (function (text){
return (new membrane.ui.Button(text,null,false,null,null,null));
}));

(membrane.ui.button.cljs$core$IFn$_invoke$arity$2 = (function (text,on_click){
return (new membrane.ui.Button(text,on_click,false,null,null,null));
}));

(membrane.ui.button.cljs$core$IFn$_invoke$arity$3 = (function (text,on_click,hover_QMARK_){
return (new membrane.ui.Button(text,on_click,hover_QMARK_,null,null,null));
}));

(membrane.ui.button.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClick = (function (on_click,drawables,__meta,__extmap,__hash){
this.on_click = on_click;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClick.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClick.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32040,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32044 = k32040;
var G__32044__$1 = (((G__32044 instanceof cljs.core.Keyword))?G__32044.fqn:null);
switch (G__32044__$1) {
case "on-click":
return self__.on_click;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32040,else__4383__auto__);

}
}));

(membrane.ui.OnClick.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32045){
var vec__32046 = p__32045;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32046,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32046,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClick.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClick.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClick{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClick.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32039){
var self__ = this;
var G__32039__$1 = this;
return (new cljs.core.RecordIter((0),G__32039__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClick.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var and__4115__auto__ = mouse_down_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return self__.on_click;
} else {
return and__4115__auto__;
}
})())){
return (self__.on_click.cljs$core$IFn$_invoke$arity$0 ? self__.on_click.cljs$core$IFn$_invoke$arity$0() : self__.on_click.call(null));
} else {
return null;
}
}));

(membrane.ui.OnClick.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32049,elem){
var vec__32050 = p__32049;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32050,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32050,(1),null);
var vec__32053 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32053,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32053,(1),null);
var vec__32056 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32056,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32056,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClick.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClick.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClick.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClick.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1125995677 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClick.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32041,other32042){
var self__ = this;
var this32041__$1 = this;
return (((!((other32042 == null)))) && ((this32041__$1.constructor === other32042.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32041__$1.on_click,other32042.on_click)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32041__$1.drawables,other32042.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32041__$1.__extmap,other32042.__extmap)));
}));

(membrane.ui.OnClick.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClick.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClick.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32039){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32059 = cljs.core.keyword_identical_QMARK_;
var expr__32060 = k__4388__auto__;
if(cljs.core.truth_((pred__32059.cljs$core$IFn$_invoke$arity$2 ? pred__32059.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__32060) : pred__32059.call(null,new cljs.core.Keyword(null,"on-click","on-click",1632826543),expr__32060)))){
return (new membrane.ui.OnClick(G__32039,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32059.cljs$core$IFn$_invoke$arity$2 ? pred__32059.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32060) : pred__32059.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32060)))){
return (new membrane.ui.OnClick(self__.on_click,G__32039,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32039),null));
}
}
}));

(membrane.ui.OnClick.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-click","on-click",1632826543),self__.on_click,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClick.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClick.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClick(self__.on_click,childs,null,null,null));
}));

(membrane.ui.OnClick.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32039){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClick(self__.on_click,self__.drawables,G__32039,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClick.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClick.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-click","on-click",-1021609226,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClick.cljs$lang$type = true);

(membrane.ui.OnClick.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClick",null,(1),null));
}));

(membrane.ui.OnClick.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClick");
}));

/**
 * Positional factory function for membrane.ui/OnClick.
 */
membrane.ui.__GT_OnClick = (function membrane$ui$__GT_OnClick(on_click,drawables){
return (new membrane.ui.OnClick(on_click,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClick, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClick = (function membrane$ui$map__GT_OnClick(G__32043){
var extmap__4419__auto__ = (function (){var G__32062 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32043,new cljs.core.Keyword(null,"on-click","on-click",1632826543),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32043)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32062);
} else {
return G__32062;
}
})();
return (new membrane.ui.OnClick(new cljs.core.Keyword(null,"on-click","on-click",1632826543).cljs$core$IFn$_invoke$arity$1(G__32043),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32043),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClick,(function (draw){
return (function (this$){
var seq__32063 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32064 = null;
var count__32065 = (0);
var i__32066 = (0);
while(true){
if((i__32066 < count__32065)){
var drawable = chunk__32064.cljs$core$IIndexed$_nth$arity$2(null,i__32066);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__33878 = seq__32063;
var G__33879 = chunk__32064;
var G__33880 = count__32065;
var G__33881 = (i__32066 + (1));
seq__32063 = G__33878;
chunk__32064 = G__33879;
count__32065 = G__33880;
i__32066 = G__33881;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32063);
if(temp__5735__auto__){
var seq__32063__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32063__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32063__$1);
var G__33882 = cljs.core.chunk_rest(seq__32063__$1);
var G__33883 = c__4556__auto__;
var G__33884 = cljs.core.count(c__4556__auto__);
var G__33885 = (0);
seq__32063 = G__33882;
chunk__32064 = G__33883;
count__32065 = G__33884;
i__32066 = G__33885;
continue;
} else {
var drawable = cljs.core.first(seq__32063__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__33886 = cljs.core.next(seq__32063__$1);
var G__33887 = null;
var G__33888 = (0);
var G__33889 = (0);
seq__32063 = G__33886;
chunk__32064 = G__33887;
count__32065 = G__33888;
i__32066 = G__33889;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wrap an element with a mouse down event handler, on-click. 
 * 
 *   on-click must accept 0 arguments and should return a sequence of effects.
 */
membrane.ui.on_click = (function membrane$ui$on_click(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33891 = arguments.length;
var i__4737__auto___33898 = (0);
while(true){
if((i__4737__auto___33898 < len__4736__auto___33891)){
args__4742__auto__.push((arguments[i__4737__auto___33898]));

var G__33901 = (i__4737__auto___33898 + (1));
i__4737__auto___33898 = G__33901;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_click.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_click.cljs$core$IFn$_invoke$arity$variadic = (function (on_click,drawables){
return (new membrane.ui.OnClick(on_click,drawables,null,null,null));
}));

(membrane.ui.on_click.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_click.cljs$lang$applyTo = (function (seq32067){
var G__32068 = cljs.core.first(seq32067);
var seq32067__$1 = cljs.core.next(seq32067);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32068,seq32067__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseDown = (function (on_mouse_down,drawables,__meta,__extmap,__hash){
this.on_mouse_down = on_mouse_down;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseDown.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32071,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32075 = k32071;
var G__32075__$1 = (((G__32075 instanceof cljs.core.Keyword))?G__32075.fqn:null);
switch (G__32075__$1) {
case "on-mouse-down":
return self__.on_mouse_down;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32071,else__4383__auto__);

}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32076){
var vec__32077 = p__32076;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32077,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32077,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseDown{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),self__.on_mouse_down],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32070){
var self__ = this;
var G__32070__$1 = this;
return (new cljs.core.RecordIter((0),G__32070__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(mouse_down_QMARK_)){
if(cljs.core.truth_(self__.on_mouse_down)){
return (self__.on_mouse_down.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_down.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_down.call(null,pos));
} else {
return null;
}
} else {
var intents = cljs.core.some((function (p1__32069_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__32069_SHARP_,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_event(p1__32069_SHARP_,local_pos,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}),cljs.core.reverse(membrane.ui.children(this$__$1)));
return membrane.ui._bubble(this$__$1,intents);
}
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32080,elem){
var vec__32081 = p__32080;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32081,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32081,(1),null);
var vec__32084 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32084,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32084,(1),null);
var vec__32087 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32087,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32087,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-698428315 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32072,other32073){
var self__ = this;
var this32072__$1 = this;
return (((!((other32073 == null)))) && ((this32072__$1.constructor === other32073.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32072__$1.on_mouse_down,other32073.on_mouse_down)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32072__$1.drawables,other32073.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32072__$1.__extmap,other32073.__extmap)));
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32070){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32090 = cljs.core.keyword_identical_QMARK_;
var expr__32091 = k__4388__auto__;
if(cljs.core.truth_((pred__32090.cljs$core$IFn$_invoke$arity$2 ? pred__32090.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),expr__32091) : pred__32090.call(null,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),expr__32091)))){
return (new membrane.ui.OnMouseDown(G__32070,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32090.cljs$core$IFn$_invoke$arity$2 ? pred__32090.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32091) : pred__32090.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32091)))){
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,G__32070,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32070),null));
}
}
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),self__.on_mouse_down,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseDown.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,childs,null,null,null));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32070){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseDown(self__.on_mouse_down,self__.drawables,G__32070,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseDown.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseDown.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-down","on-mouse-down",-1506680299,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseDown.cljs$lang$type = true);

(membrane.ui.OnMouseDown.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseDown",null,(1),null));
}));

(membrane.ui.OnMouseDown.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseDown");
}));

/**
 * Positional factory function for membrane.ui/OnMouseDown.
 */
membrane.ui.__GT_OnMouseDown = (function membrane$ui$__GT_OnMouseDown(on_mouse_down,drawables){
return (new membrane.ui.OnMouseDown(on_mouse_down,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseDown, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseDown = (function membrane$ui$map__GT_OnMouseDown(G__32074){
var extmap__4419__auto__ = (function (){var G__32093 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32074,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32074)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32093);
} else {
return G__32093;
}
})();
return (new membrane.ui.OnMouseDown(new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470).cljs$core$IFn$_invoke$arity$1(G__32074),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32074),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseDown,(function (draw){
return (function (this$){
var seq__32094 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32095 = null;
var count__32096 = (0);
var i__32097 = (0);
while(true){
if((i__32097 < count__32096)){
var drawable = chunk__32095.cljs$core$IIndexed$_nth$arity$2(null,i__32097);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__33968 = seq__32094;
var G__33969 = chunk__32095;
var G__33970 = count__32096;
var G__33971 = (i__32097 + (1));
seq__32094 = G__33968;
chunk__32095 = G__33969;
count__32096 = G__33970;
i__32097 = G__33971;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32094);
if(temp__5735__auto__){
var seq__32094__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32094__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32094__$1);
var G__33972 = cljs.core.chunk_rest(seq__32094__$1);
var G__33973 = c__4556__auto__;
var G__33974 = cljs.core.count(c__4556__auto__);
var G__33975 = (0);
seq__32094 = G__33972;
chunk__32095 = G__33973;
count__32096 = G__33974;
i__32097 = G__33975;
continue;
} else {
var drawable = cljs.core.first(seq__32094__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__33976 = cljs.core.next(seq__32094__$1);
var G__33977 = null;
var G__33978 = (0);
var G__33979 = (0);
seq__32094 = G__33976;
chunk__32095 = G__33977;
count__32096 = G__33978;
i__32097 = G__33979;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-down events.
 * 
 *   on-mouse-down should take 1 argument [mx my] of the mouse position in local coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_down = (function membrane$ui$on_mouse_down(var_args){
var args__4742__auto__ = [];
var len__4736__auto___33980 = arguments.length;
var i__4737__auto___33981 = (0);
while(true){
if((i__4737__auto___33981 < len__4736__auto___33980)){
args__4742__auto__.push((arguments[i__4737__auto___33981]));

var G__33982 = (i__4737__auto___33981 + (1));
i__4737__auto___33981 = G__33982;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_down.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_down.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_down,drawables){
return (new membrane.ui.OnMouseDown(on_mouse_down,drawables,null,null,null));
}));

(membrane.ui.on_mouse_down.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_down.cljs$lang$applyTo = (function (seq32098){
var G__32099 = cljs.core.first(seq32098);
var seq32098__$1 = cljs.core.next(seq32098);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32099,seq32098__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseUp = (function (on_mouse_up,drawables,__meta,__extmap,__hash){
this.on_mouse_up = on_mouse_up;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseUp.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32102,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32106 = k32102;
var G__32106__$1 = (((G__32106 instanceof cljs.core.Keyword))?G__32106.fqn:null);
switch (G__32106__$1) {
case "on-mouse-up":
return self__.on_mouse_up;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32102,else__4383__auto__);

}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32107){
var vec__32108 = p__32107;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32108,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseUp{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),self__.on_mouse_up],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32101){
var self__ = this;
var G__32101__$1 = this;
return (new cljs.core.RecordIter((0),G__32101__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(mouse_down_QMARK_)){
var intents = cljs.core.some((function (p1__32100_SHARP_){
var temp__5735__auto__ = membrane.ui.within_bounds_QMARK_(p1__32100_SHARP_,pos);
if(cljs.core.truth_(temp__5735__auto__)){
var local_pos = temp__5735__auto__;
return cljs.core.seq(membrane.ui._mouse_event(p1__32100_SHARP_,local_pos,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}),cljs.core.reverse(membrane.ui.children(this$__$1)));
return membrane.ui._bubble(this$__$1,intents);
} else {
if(cljs.core.truth_(self__.on_mouse_up)){
return (self__.on_mouse_up.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_up.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_up.call(null,pos));
} else {
return null;
}
}
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32111,elem){
var vec__32112 = p__32111;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32112,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32112,(1),null);
var vec__32115 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32115,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32115,(1),null);
var vec__32118 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32118,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32118,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-778849279 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32103,other32104){
var self__ = this;
var this32103__$1 = this;
return (((!((other32104 == null)))) && ((this32103__$1.constructor === other32104.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32103__$1.on_mouse_up,other32104.on_mouse_up)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32103__$1.drawables,other32104.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32103__$1.__extmap,other32104.__extmap)));
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32101){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32121 = cljs.core.keyword_identical_QMARK_;
var expr__32122 = k__4388__auto__;
if(cljs.core.truth_((pred__32121.cljs$core$IFn$_invoke$arity$2 ? pred__32121.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),expr__32122) : pred__32121.call(null,new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),expr__32122)))){
return (new membrane.ui.OnMouseUp(G__32101,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32121.cljs$core$IFn$_invoke$arity$2 ? pred__32121.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32122) : pred__32121.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32122)))){
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,G__32101,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32101),null));
}
}
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),self__.on_mouse_up,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseUp.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,childs,null,null,null));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32101){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseUp(self__.on_mouse_up,self__.drawables,G__32101,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseUp.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseUp.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-up","on-mouse-up",299998207,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseUp.cljs$lang$type = true);

(membrane.ui.OnMouseUp.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseUp",null,(1),null));
}));

(membrane.ui.OnMouseUp.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseUp");
}));

/**
 * Positional factory function for membrane.ui/OnMouseUp.
 */
membrane.ui.__GT_OnMouseUp = (function membrane$ui$__GT_OnMouseUp(on_mouse_up,drawables){
return (new membrane.ui.OnMouseUp(on_mouse_up,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseUp, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseUp = (function membrane$ui$map__GT_OnMouseUp(G__32105){
var extmap__4419__auto__ = (function (){var G__32124 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32105,new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32105)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32124);
} else {
return G__32124;
}
})();
return (new membrane.ui.OnMouseUp(new cljs.core.Keyword(null,"on-mouse-up","on-mouse-up",-1340533320).cljs$core$IFn$_invoke$arity$1(G__32105),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32105),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseUp,(function (draw){
return (function (this$){
var seq__32125 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32126 = null;
var count__32127 = (0);
var i__32128 = (0);
while(true){
if((i__32128 < count__32127)){
var drawable = chunk__32126.cljs$core$IIndexed$_nth$arity$2(null,i__32128);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34012 = seq__32125;
var G__34013 = chunk__32126;
var G__34014 = count__32127;
var G__34015 = (i__32128 + (1));
seq__32125 = G__34012;
chunk__32126 = G__34013;
count__32127 = G__34014;
i__32128 = G__34015;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32125);
if(temp__5735__auto__){
var seq__32125__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32125__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32125__$1);
var G__34016 = cljs.core.chunk_rest(seq__32125__$1);
var G__34017 = c__4556__auto__;
var G__34018 = cljs.core.count(c__4556__auto__);
var G__34019 = (0);
seq__32125 = G__34016;
chunk__32126 = G__34017;
count__32127 = G__34018;
i__32128 = G__34019;
continue;
} else {
var drawable = cljs.core.first(seq__32125__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34020 = cljs.core.next(seq__32125__$1);
var G__34021 = null;
var G__34022 = (0);
var G__34023 = (0);
seq__32125 = G__34020;
chunk__32126 = G__34021;
count__32127 = G__34022;
i__32128 = G__34023;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-up events.
 * 
 *   on-mouse-up should take 1 argument [mx my] of the mouse position in local coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_up = (function membrane$ui$on_mouse_up(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34024 = arguments.length;
var i__4737__auto___34025 = (0);
while(true){
if((i__4737__auto___34025 < len__4736__auto___34024)){
args__4742__auto__.push((arguments[i__4737__auto___34025]));

var G__34026 = (i__4737__auto___34025 + (1));
i__4737__auto___34025 = G__34026;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_up.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_up.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_up,drawables){
return (new membrane.ui.OnMouseUp(on_mouse_up,drawables,null,null,null));
}));

(membrane.ui.on_mouse_up.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_up.cljs$lang$applyTo = (function (seq32129){
var G__32130 = cljs.core.first(seq32129);
var seq32129__$1 = cljs.core.next(seq32129);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32130,seq32129__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMove}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseMove = (function (on_mouse_move,drawables,__meta,__extmap,__hash){
this.on_mouse_move = on_mouse_move;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseMove.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32132,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32136 = k32132;
var G__32136__$1 = (((G__32136 instanceof cljs.core.Keyword))?G__32136.fqn:null);
switch (G__32136__$1) {
case "on-mouse-move":
return self__.on_mouse_move;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32132,else__4383__auto__);

}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32137){
var vec__32138 = p__32137;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32138,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32138,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseMove{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),self__.on_mouse_move],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32131){
var self__ = this;
var G__32131__$1 = this;
return (new cljs.core.RecordIter((0),G__32131__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32141,elem){
var vec__32142 = p__32141;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32142,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32142,(1),null);
var vec__32145 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32145,(1),null);
var vec__32148 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32148,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32148,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1514972171 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32133,other32134){
var self__ = this;
var this32133__$1 = this;
return (((!((other32134 == null)))) && ((this32133__$1.constructor === other32134.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32133__$1.on_mouse_move,other32134.on_mouse_move)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32133__$1.drawables,other32134.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32133__$1.__extmap,other32134.__extmap)));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32131){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32151 = cljs.core.keyword_identical_QMARK_;
var expr__32152 = k__4388__auto__;
if(cljs.core.truth_((pred__32151.cljs$core$IFn$_invoke$arity$2 ? pred__32151.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),expr__32152) : pred__32151.call(null,new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),expr__32152)))){
return (new membrane.ui.OnMouseMove(G__32131,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32151.cljs$core$IFn$_invoke$arity$2 ? pred__32151.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32152) : pred__32151.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32152)))){
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,G__32131,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32131),null));
}
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),self__.on_mouse_move,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,childs,null,null,null));
}));

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMouseMove$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMove.prototype.membrane$ui$IMouseMove$_mouse_move$arity$2 = (function (this$,p__32154){
var self__ = this;
var vec__32155 = p__32154;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32155,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32155,(1),null);
var pos = vec__32155;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_mouse_move)){
return (self__.on_mouse_move.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_move.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_move.call(null,pos));
} else {
return null;
}
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32131){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseMove(self__.on_mouse_move,self__.drawables,G__32131,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMove.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseMove.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-move","on-mouse-move",254210653,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseMove.cljs$lang$type = true);

(membrane.ui.OnMouseMove.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseMove",null,(1),null));
}));

(membrane.ui.OnMouseMove.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseMove");
}));

/**
 * Positional factory function for membrane.ui/OnMouseMove.
 */
membrane.ui.__GT_OnMouseMove = (function membrane$ui$__GT_OnMouseMove(on_mouse_move,drawables){
return (new membrane.ui.OnMouseMove(on_mouse_move,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseMove, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseMove = (function membrane$ui$map__GT_OnMouseMove(G__32135){
var extmap__4419__auto__ = (function (){var G__32158 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32135,new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32135)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32158);
} else {
return G__32158;
}
})();
return (new membrane.ui.OnMouseMove(new cljs.core.Keyword(null,"on-mouse-move","on-mouse-move",-1386320874).cljs$core$IFn$_invoke$arity$1(G__32135),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32135),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseMove,(function (draw){
return (function (this$){
var seq__32159 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32160 = null;
var count__32161 = (0);
var i__32162 = (0);
while(true){
if((i__32162 < count__32161)){
var drawable = chunk__32160.cljs$core$IIndexed$_nth$arity$2(null,i__32162);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34041 = seq__32159;
var G__34042 = chunk__32160;
var G__34043 = count__32161;
var G__34044 = (i__32162 + (1));
seq__32159 = G__34041;
chunk__32160 = G__34042;
count__32161 = G__34043;
i__32162 = G__34044;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32159);
if(temp__5735__auto__){
var seq__32159__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32159__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32159__$1);
var G__34046 = cljs.core.chunk_rest(seq__32159__$1);
var G__34047 = c__4556__auto__;
var G__34048 = cljs.core.count(c__4556__auto__);
var G__34049 = (0);
seq__32159 = G__34046;
chunk__32160 = G__34047;
count__32161 = G__34048;
i__32162 = G__34049;
continue;
} else {
var drawable = cljs.core.first(seq__32159__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34052 = cljs.core.next(seq__32159__$1);
var G__34053 = null;
var G__34054 = (0);
var G__34055 = (0);
seq__32159 = G__34052;
chunk__32160 = G__34053;
count__32161 = G__34054;
i__32162 = G__34055;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-move events.
 * 
 *   on-mouse-move down should take 1 argument [mx my] of the mouse position in local coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_move = (function membrane$ui$on_mouse_move(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34058 = arguments.length;
var i__4737__auto___34059 = (0);
while(true){
if((i__4737__auto___34059 < len__4736__auto___34058)){
args__4742__auto__.push((arguments[i__4737__auto___34059]));

var G__34060 = (i__4737__auto___34059 + (1));
i__4737__auto___34059 = G__34060;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_move,drawables){
return (new membrane.ui.OnMouseMove(on_mouse_move,drawables,null,null,null));
}));

(membrane.ui.on_mouse_move.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_move.cljs$lang$applyTo = (function (seq32163){
var G__32164 = cljs.core.first(seq32163);
var seq32163__$1 = cljs.core.next(seq32163);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32164,seq32163__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMoveGlobal}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IHasMouseMoveGlobal}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseMoveGlobal = (function (on_mouse_move_global,drawables,__meta,__extmap,__hash){
this.on_mouse_move_global = on_mouse_move_global;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32166,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32170 = k32166;
var G__32170__$1 = (((G__32170 instanceof cljs.core.Keyword))?G__32170.fqn:null);
switch (G__32170__$1) {
case "on-mouse-move-global":
return self__.on_mouse_move_global;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32166,else__4383__auto__);

}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32171){
var vec__32172 = p__32171;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32172,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32172,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IHasMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IHasMouseMoveGlobal$has_mouse_move_global$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return true;
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseMoveGlobal{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),self__.on_mouse_move_global],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32165){
var self__ = this;
var G__32165__$1 = this;
return (new cljs.core.RecordIter((0),G__32165__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32175,elem){
var vec__32176 = p__32175;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32176,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32176,(1),null);
var vec__32179 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32179,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32179,(1),null);
var vec__32182 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32182,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32182,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1067455229 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32167,other32168){
var self__ = this;
var this32167__$1 = this;
return (((!((other32168 == null)))) && ((this32167__$1.constructor === other32168.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32167__$1.on_mouse_move_global,other32168.on_mouse_move_global)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32167__$1.drawables,other32168.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32167__$1.__extmap,other32168.__extmap)));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32165){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32185 = cljs.core.keyword_identical_QMARK_;
var expr__32186 = k__4388__auto__;
if(cljs.core.truth_((pred__32185.cljs$core$IFn$_invoke$arity$2 ? pred__32185.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),expr__32186) : pred__32185.call(null,new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),expr__32186)))){
return (new membrane.ui.OnMouseMoveGlobal(G__32165,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32185.cljs$core$IFn$_invoke$arity$2 ? pred__32185.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32186) : pred__32185.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32186)))){
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,G__32165,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32165),null));
}
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),self__.on_mouse_move_global,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,childs,null,null,null));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32165){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseMoveGlobal(self__.on_mouse_move_global,self__.drawables,G__32165,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseMoveGlobal.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseMoveGlobal.prototype.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_mouse_move_global)){
return (self__.on_mouse_move_global.cljs$core$IFn$_invoke$arity$1 ? self__.on_mouse_move_global.cljs$core$IFn$_invoke$arity$1(pos) : self__.on_mouse_move_global.call(null,pos));
} else {
return null;
}
}));

(membrane.ui.OnMouseMoveGlobal.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-move-global","on-mouse-move-global",-366493693,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseMoveGlobal.cljs$lang$type = true);

(membrane.ui.OnMouseMoveGlobal.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseMoveGlobal",null,(1),null));
}));

(membrane.ui.OnMouseMoveGlobal.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseMoveGlobal");
}));

/**
 * Positional factory function for membrane.ui/OnMouseMoveGlobal.
 */
membrane.ui.__GT_OnMouseMoveGlobal = (function membrane$ui$__GT_OnMouseMoveGlobal(on_mouse_move_global,drawables){
return (new membrane.ui.OnMouseMoveGlobal(on_mouse_move_global,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseMoveGlobal, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseMoveGlobal = (function membrane$ui$map__GT_OnMouseMoveGlobal(G__32169){
var extmap__4419__auto__ = (function (){var G__32188 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32169,new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32169)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32188);
} else {
return G__32188;
}
})();
return (new membrane.ui.OnMouseMoveGlobal(new cljs.core.Keyword(null,"on-mouse-move-global","on-mouse-move-global",-2007025220).cljs$core$IFn$_invoke$arity$1(G__32169),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32169),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseMoveGlobal,(function (draw){
return (function (this$){
var seq__32189 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32190 = null;
var count__32191 = (0);
var i__32192 = (0);
while(true){
if((i__32192 < count__32191)){
var drawable = chunk__32190.cljs$core$IIndexed$_nth$arity$2(null,i__32192);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34098 = seq__32189;
var G__34099 = chunk__32190;
var G__34100 = count__32191;
var G__34101 = (i__32192 + (1));
seq__32189 = G__34098;
chunk__32190 = G__34099;
count__32191 = G__34100;
i__32192 = G__34101;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32189);
if(temp__5735__auto__){
var seq__32189__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32189__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32189__$1);
var G__34106 = cljs.core.chunk_rest(seq__32189__$1);
var G__34107 = c__4556__auto__;
var G__34108 = cljs.core.count(c__4556__auto__);
var G__34109 = (0);
seq__32189 = G__34106;
chunk__32190 = G__34107;
count__32191 = G__34108;
i__32192 = G__34109;
continue;
} else {
var drawable = cljs.core.first(seq__32189__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34112 = cljs.core.next(seq__32189__$1);
var G__34113 = null;
var G__34114 = (0);
var G__34115 = (0);
seq__32189 = G__34112;
chunk__32190 = G__34113;
count__32191 = G__34114;
i__32192 = G__34115;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse-move-global events.
 * 
 *   on-mouse-move-global down should take 1 argument [mx my] of the mouse position in global coordinates and return a sequence of effects.
 */
membrane.ui.on_mouse_move_global = (function membrane$ui$on_mouse_move_global(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34116 = arguments.length;
var i__4737__auto___34117 = (0);
while(true){
if((i__4737__auto___34117 < len__4736__auto___34116)){
args__4742__auto__.push((arguments[i__4737__auto___34117]));

var G__34118 = (i__4737__auto___34117 + (1));
i__4737__auto___34117 = G__34118;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_move_global,drawables){
return (new membrane.ui.OnMouseMoveGlobal(on_mouse_move_global,drawables,null,null,null));
}));

(membrane.ui.on_mouse_move_global.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_move_global.cljs$lang$applyTo = (function (seq32193){
var G__32194 = cljs.core.first(seq32193);
var seq32193__$1 = cljs.core.next(seq32193);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32194,seq32193__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnMouseEvent = (function (on_mouse_event,drawables,__meta,__extmap,__hash){
this.on_mouse_event = on_mouse_event;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnMouseEvent.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32196,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32200 = k32196;
var G__32200__$1 = (((G__32200 instanceof cljs.core.Keyword))?G__32200.fqn:null);
switch (G__32200__$1) {
case "on-mouse-event":
return self__.on_mouse_event;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32196,else__4383__auto__);

}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32201){
var vec__32202 = p__32201;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32202,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32202,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnMouseEvent{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),self__.on_mouse_event],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32195){
var self__ = this;
var G__32195__$1 = this;
return (new cljs.core.RecordIter((0),G__32195__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,pos,button,mouse_down_QMARK_,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_mouse_event)){
return (self__.on_mouse_event.cljs$core$IFn$_invoke$arity$4 ? self__.on_mouse_event.cljs$core$IFn$_invoke$arity$4(pos,button,mouse_down_QMARK_,mods) : self__.on_mouse_event.call(null,pos,button,mouse_down_QMARK_,mods));
} else {
return null;
}
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32205,elem){
var vec__32206 = p__32205;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32206,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32206,(1),null);
var vec__32209 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32209,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32209,(1),null);
var vec__32212 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32212,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32212,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2107328521 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32197,other32198){
var self__ = this;
var this32197__$1 = this;
return (((!((other32198 == null)))) && ((this32197__$1.constructor === other32198.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32197__$1.on_mouse_event,other32198.on_mouse_event)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32197__$1.drawables,other32198.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32197__$1.__extmap,other32198.__extmap)));
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32195){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32215 = cljs.core.keyword_identical_QMARK_;
var expr__32216 = k__4388__auto__;
if(cljs.core.truth_((pred__32215.cljs$core$IFn$_invoke$arity$2 ? pred__32215.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),expr__32216) : pred__32215.call(null,new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),expr__32216)))){
return (new membrane.ui.OnMouseEvent(G__32195,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32215.cljs$core$IFn$_invoke$arity$2 ? pred__32215.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32216) : pred__32215.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32216)))){
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,G__32195,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32195),null));
}
}
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),self__.on_mouse_event,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnMouseEvent.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,childs,null,null,null));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32195){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnMouseEvent(self__.on_mouse_event,self__.drawables,G__32195,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnMouseEvent.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnMouseEvent.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-mouse-event","on-mouse-event",712292405,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnMouseEvent.cljs$lang$type = true);

(membrane.ui.OnMouseEvent.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnMouseEvent",null,(1),null));
}));

(membrane.ui.OnMouseEvent.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnMouseEvent");
}));

/**
 * Positional factory function for membrane.ui/OnMouseEvent.
 */
membrane.ui.__GT_OnMouseEvent = (function membrane$ui$__GT_OnMouseEvent(on_mouse_event,drawables){
return (new membrane.ui.OnMouseEvent(on_mouse_event,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnMouseEvent, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnMouseEvent = (function membrane$ui$map__GT_OnMouseEvent(G__32199){
var extmap__4419__auto__ = (function (){var G__32218 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32199,new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32199)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32218);
} else {
return G__32218;
}
})();
return (new membrane.ui.OnMouseEvent(new cljs.core.Keyword(null,"on-mouse-event","on-mouse-event",-928239122).cljs$core$IFn$_invoke$arity$1(G__32199),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32199),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnMouseEvent,(function (draw){
return (function (this$){
var seq__32219 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32220 = null;
var count__32221 = (0);
var i__32222 = (0);
while(true){
if((i__32222 < count__32221)){
var drawable = chunk__32220.cljs$core$IIndexed$_nth$arity$2(null,i__32222);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34133 = seq__32219;
var G__34134 = chunk__32220;
var G__34135 = count__32221;
var G__34136 = (i__32222 + (1));
seq__32219 = G__34133;
chunk__32220 = G__34134;
count__32221 = G__34135;
i__32222 = G__34136;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32219);
if(temp__5735__auto__){
var seq__32219__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32219__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32219__$1);
var G__34137 = cljs.core.chunk_rest(seq__32219__$1);
var G__34138 = c__4556__auto__;
var G__34139 = cljs.core.count(c__4556__auto__);
var G__34140 = (0);
seq__32219 = G__34137;
chunk__32220 = G__34138;
count__32221 = G__34139;
i__32222 = G__34140;
continue;
} else {
var drawable = cljs.core.first(seq__32219__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34147 = cljs.core.next(seq__32219__$1);
var G__34148 = null;
var G__34149 = (0);
var G__34150 = (0);
seq__32219 = G__34147;
chunk__32220 = G__34148;
count__32221 = G__34149;
i__32222 = G__34150;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for mouse events.
 * 
 *   on-mouse-event should take 4 arguments [pos button mouse-down? mods] and return a sequence of effects.
 */
membrane.ui.on_mouse_event = (function membrane$ui$on_mouse_event(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34151 = arguments.length;
var i__4737__auto___34152 = (0);
while(true){
if((i__4737__auto___34152 < len__4736__auto___34151)){
args__4742__auto__.push((arguments[i__4737__auto___34152]));

var G__34156 = (i__4737__auto___34152 + (1));
i__4737__auto___34152 = G__34156;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic = (function (on_mouse_event,drawables){
return (new membrane.ui.OnMouseEvent(on_mouse_event,drawables,null,null,null));
}));

(membrane.ui.on_mouse_event.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_mouse_event.cljs$lang$applyTo = (function (seq32223){
var G__32224 = cljs.core.first(seq32223);
var seq32223__$1 = cljs.core.next(seq32223);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32224,seq32223__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {membrane.ui.IDrop}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnDrop = (function (on_drop,drawables,__meta,__extmap,__hash){
this.on_drop = on_drop;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnDrop.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnDrop.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32226,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32230 = k32226;
var G__32230__$1 = (((G__32230 instanceof cljs.core.Keyword))?G__32230.fqn:null);
switch (G__32230__$1) {
case "on-drop":
return self__.on_drop;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32226,else__4383__auto__);

}
}));

(membrane.ui.OnDrop.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32231){
var vec__32232 = p__32231;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32232,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32232,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnDrop.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnDrop{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),self__.on_drop],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnDrop.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32225){
var self__ = this;
var G__32225__$1 = this;
return (new cljs.core.RecordIter((0),G__32225__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32235,elem){
var vec__32236 = p__32235;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32236,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32236,(1),null);
var vec__32239 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32239,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32239,(1),null);
var vec__32242 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32242,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32242,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnDrop.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnDrop.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnDrop.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnDrop.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1580704880 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnDrop.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32227,other32228){
var self__ = this;
var this32227__$1 = this;
return (((!((other32228 == null)))) && ((this32227__$1.constructor === other32228.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32227__$1.on_drop,other32228.on_drop)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32227__$1.drawables,other32228.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32227__$1.__extmap,other32228.__extmap)));
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnDrop.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnDrop.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32225){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32245 = cljs.core.keyword_identical_QMARK_;
var expr__32246 = k__4388__auto__;
if(cljs.core.truth_((pred__32245.cljs$core$IFn$_invoke$arity$2 ? pred__32245.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),expr__32246) : pred__32245.call(null,new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),expr__32246)))){
return (new membrane.ui.OnDrop(G__32225,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32245.cljs$core$IFn$_invoke$arity$2 ? pred__32245.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32246) : pred__32245.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32246)))){
return (new membrane.ui.OnDrop(self__.on_drop,G__32225,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32225),null));
}
}
}));

(membrane.ui.OnDrop.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),self__.on_drop,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnDrop(self__.on_drop,childs,null,null,null));
}));

(membrane.ui.OnDrop.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32225){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnDrop(self__.on_drop,self__.drawables,G__32225,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnDrop.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnDrop.prototype.membrane$ui$IDrop$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnDrop.prototype.membrane$ui$IDrop$_drop$arity$3 = (function (this$,paths,pos){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_drop)){
return (self__.on_drop.cljs$core$IFn$_invoke$arity$2 ? self__.on_drop.cljs$core$IFn$_invoke$arity$2(paths,pos) : self__.on_drop.call(null,paths,pos));
} else {
return null;
}
}));

(membrane.ui.OnDrop.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-drop","on-drop",-786567278,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnDrop.cljs$lang$type = true);

(membrane.ui.OnDrop.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnDrop",null,(1),null));
}));

(membrane.ui.OnDrop.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnDrop");
}));

/**
 * Positional factory function for membrane.ui/OnDrop.
 */
membrane.ui.__GT_OnDrop = (function membrane$ui$__GT_OnDrop(on_drop,drawables){
return (new membrane.ui.OnDrop(on_drop,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnDrop, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnDrop = (function membrane$ui$map__GT_OnDrop(G__32229){
var extmap__4419__auto__ = (function (){var G__32248 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32229,new cljs.core.Keyword(null,"on-drop","on-drop",1867868491),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32229)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32248);
} else {
return G__32248;
}
})();
return (new membrane.ui.OnDrop(new cljs.core.Keyword(null,"on-drop","on-drop",1867868491).cljs$core$IFn$_invoke$arity$1(G__32229),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32229),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnDrop,(function (draw){
return (function (this$){
var seq__32249 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32250 = null;
var count__32251 = (0);
var i__32252 = (0);
while(true){
if((i__32252 < count__32251)){
var drawable = chunk__32250.cljs$core$IIndexed$_nth$arity$2(null,i__32252);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34171 = seq__32249;
var G__34172 = chunk__32250;
var G__34173 = count__32251;
var G__34174 = (i__32252 + (1));
seq__32249 = G__34171;
chunk__32250 = G__34172;
count__32251 = G__34173;
i__32252 = G__34174;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32249);
if(temp__5735__auto__){
var seq__32249__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32249__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32249__$1);
var G__34175 = cljs.core.chunk_rest(seq__32249__$1);
var G__34176 = c__4556__auto__;
var G__34177 = cljs.core.count(c__4556__auto__);
var G__34178 = (0);
seq__32249 = G__34175;
chunk__32250 = G__34176;
count__32251 = G__34177;
i__32252 = G__34178;
continue;
} else {
var drawable = cljs.core.first(seq__32249__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34179 = cljs.core.next(seq__32249__$1);
var G__34180 = null;
var G__34181 = (0);
var G__34182 = (0);
seq__32249 = G__34179;
chunk__32250 = G__34180;
count__32251 = G__34181;
i__32252 = G__34182;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for drop events.
 * 
 *   on-drop should take 2 arguments [paths pos] and return a sequence of effects.
 */
membrane.ui.on_drop = (function membrane$ui$on_drop(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34183 = arguments.length;
var i__4737__auto___34184 = (0);
while(true){
if((i__4737__auto___34184 < len__4736__auto___34183)){
args__4742__auto__.push((arguments[i__4737__auto___34184]));

var G__34185 = (i__4737__auto___34184 + (1));
i__4737__auto___34184 = G__34185;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_drop.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_drop.cljs$core$IFn$_invoke$arity$variadic = (function (on_drop,drawables){
return (new membrane.ui.OnDrop(on_drop,drawables,null,null,null));
}));

(membrane.ui.on_drop.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_drop.cljs$lang$applyTo = (function (seq32253){
var G__32254 = cljs.core.first(seq32253);
var seq32253__$1 = cljs.core.next(seq32253);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32254,seq32253__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IHasKeyPress}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IKeyPress}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnKeyPress = (function (on_key_press,drawables,__meta,__extmap,__hash){
this.on_key_press = on_key_press;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnKeyPress.prototype.membrane$ui$IHasKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IHasKeyPress$has_key_press$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.boolean$(self__.on_key_press);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32256,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32260 = k32256;
var G__32260__$1 = (((G__32260 instanceof cljs.core.Keyword))?G__32260.fqn:null);
switch (G__32260__$1) {
case "on-key-press":
return self__.on_key_press;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32256,else__4383__auto__);

}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32261){
var vec__32262 = p__32261;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32262,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32262,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnKeyPress{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),self__.on_key_press],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32255){
var self__ = this;
var G__32255__$1 = this;
return (new cljs.core.RecordIter((0),G__32255__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32265,elem){
var vec__32266 = p__32265;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32266,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32266,(1),null);
var vec__32269 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32269,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32269,(1),null);
var vec__32272 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32272,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32272,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IKeyPress$_key_press$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_key_press)){
return (self__.on_key_press.cljs$core$IFn$_invoke$arity$1 ? self__.on_key_press.cljs$core$IFn$_invoke$arity$1(key) : self__.on_key_press.call(null,key));
} else {
return null;
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (515211784 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32257,other32258){
var self__ = this;
var this32257__$1 = this;
return (((!((other32258 == null)))) && ((this32257__$1.constructor === other32258.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32257__$1.on_key_press,other32258.on_key_press)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32257__$1.drawables,other32258.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32257__$1.__extmap,other32258.__extmap)));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32255){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32275 = cljs.core.keyword_identical_QMARK_;
var expr__32276 = k__4388__auto__;
if(cljs.core.truth_((pred__32275.cljs$core$IFn$_invoke$arity$2 ? pred__32275.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),expr__32276) : pred__32275.call(null,new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),expr__32276)))){
return (new membrane.ui.OnKeyPress(G__32255,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32275.cljs$core$IFn$_invoke$arity$2 ? pred__32275.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32276) : pred__32275.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32276)))){
return (new membrane.ui.OnKeyPress(self__.on_key_press,G__32255,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32255),null));
}
}
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),self__.on_key_press,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyPress.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyPress.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnKeyPress(self__.on_key_press,childs,null,null,null));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32255){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnKeyPress(self__.on_key_press,self__.drawables,G__32255,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyPress.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnKeyPress.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-key-press","on-key-press",1240967850,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnKeyPress.cljs$lang$type = true);

(membrane.ui.OnKeyPress.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnKeyPress",null,(1),null));
}));

(membrane.ui.OnKeyPress.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnKeyPress");
}));

/**
 * Positional factory function for membrane.ui/OnKeyPress.
 */
membrane.ui.__GT_OnKeyPress = (function membrane$ui$__GT_OnKeyPress(on_key_press,drawables){
return (new membrane.ui.OnKeyPress(on_key_press,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnKeyPress, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnKeyPress = (function membrane$ui$map__GT_OnKeyPress(G__32259){
var extmap__4419__auto__ = (function (){var G__32278 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32259,new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32259)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32278);
} else {
return G__32278;
}
})();
return (new membrane.ui.OnKeyPress(new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677).cljs$core$IFn$_invoke$arity$1(G__32259),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32259),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnKeyPress,(function (draw){
return (function (this$){
var seq__32279 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32280 = null;
var count__32281 = (0);
var i__32282 = (0);
while(true){
if((i__32282 < count__32281)){
var drawable = chunk__32280.cljs$core$IIndexed$_nth$arity$2(null,i__32282);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34244 = seq__32279;
var G__34245 = chunk__32280;
var G__34246 = count__32281;
var G__34247 = (i__32282 + (1));
seq__32279 = G__34244;
chunk__32280 = G__34245;
count__32281 = G__34246;
i__32282 = G__34247;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32279);
if(temp__5735__auto__){
var seq__32279__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32279__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32279__$1);
var G__34249 = cljs.core.chunk_rest(seq__32279__$1);
var G__34250 = c__4556__auto__;
var G__34251 = cljs.core.count(c__4556__auto__);
var G__34252 = (0);
seq__32279 = G__34249;
chunk__32280 = G__34250;
count__32281 = G__34251;
i__32282 = G__34252;
continue;
} else {
var drawable = cljs.core.first(seq__32279__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34256 = cljs.core.next(seq__32279__$1);
var G__34257 = null;
var G__34258 = (0);
var G__34259 = (0);
seq__32279 = G__34256;
chunk__32280 = G__34257;
count__32281 = G__34258;
i__32282 = G__34259;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for key-press events.
 * 
 *   on-key-press should take 1 argument key and return a sequence of effects.
 */
membrane.ui.on_key_press = (function membrane$ui$on_key_press(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34260 = arguments.length;
var i__4737__auto___34261 = (0);
while(true){
if((i__4737__auto___34261 < len__4736__auto___34260)){
args__4742__auto__.push((arguments[i__4737__auto___34261]));

var G__34262 = (i__4737__auto___34261 + (1));
i__4737__auto___34261 = G__34262;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic = (function (on_key_press,drawables){
return (new membrane.ui.OnKeyPress(on_key_press,drawables,null,null,null));
}));

(membrane.ui.on_key_press.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_key_press.cljs$lang$applyTo = (function (seq32283){
var G__32284 = cljs.core.first(seq32283);
var seq32283__$1 = cljs.core.next(seq32283);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32284,seq32283__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IHasKeyEvent}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IKeyEvent}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnKeyEvent = (function (on_key_event,drawables,__meta,__extmap,__hash){
this.on_key_event = on_key_event;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32286,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32290 = k32286;
var G__32290__$1 = (((G__32290 instanceof cljs.core.Keyword))?G__32290.fqn:null);
switch (G__32290__$1) {
case "on-key-event":
return self__.on_key_event;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32286,else__4383__auto__);

}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32291){
var vec__32292 = p__32291;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32292,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32292,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnKeyEvent{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),self__.on_key_event],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32285){
var self__ = this;
var G__32285__$1 = this;
return (new cljs.core.RecordIter((0),G__32285__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32295,elem){
var vec__32296 = p__32295;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32296,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32296,(1),null);
var vec__32299 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32299,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32299,(1),null);
var vec__32302 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32302,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32302,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IKeyEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IKeyEvent$_key_event$arity$5 = (function (this$,key,scancode,action,mods){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_key_event)){
return (self__.on_key_event.cljs$core$IFn$_invoke$arity$4 ? self__.on_key_event.cljs$core$IFn$_invoke$arity$4(key,scancode,action,mods) : self__.on_key_event.call(null,key,scancode,action,mods));
} else {
return null;
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2051278419 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32287,other32288){
var self__ = this;
var this32287__$1 = this;
return (((!((other32288 == null)))) && ((this32287__$1.constructor === other32288.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32287__$1.on_key_event,other32288.on_key_event)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32287__$1.drawables,other32288.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32287__$1.__extmap,other32288.__extmap)));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32285){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32305 = cljs.core.keyword_identical_QMARK_;
var expr__32306 = k__4388__auto__;
if(cljs.core.truth_((pred__32305.cljs$core$IFn$_invoke$arity$2 ? pred__32305.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),expr__32306) : pred__32305.call(null,new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),expr__32306)))){
return (new membrane.ui.OnKeyEvent(G__32285,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32305.cljs$core$IFn$_invoke$arity$2 ? pred__32305.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32306) : pred__32305.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32306)))){
return (new membrane.ui.OnKeyEvent(self__.on_key_event,G__32285,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32285),null));
}
}
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),self__.on_key_event,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnKeyEvent(self__.on_key_event,childs,null,null,null));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32285){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnKeyEvent(self__.on_key_event,self__.drawables,G__32285,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnKeyEvent.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IHasKeyEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnKeyEvent.prototype.membrane$ui$IHasKeyEvent$has_key_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.boolean$(self__.on_key_event);
}));

(membrane.ui.OnKeyEvent.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-key-event","on-key-event",-1735181456,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnKeyEvent.cljs$lang$type = true);

(membrane.ui.OnKeyEvent.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnKeyEvent",null,(1),null));
}));

(membrane.ui.OnKeyEvent.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnKeyEvent");
}));

/**
 * Positional factory function for membrane.ui/OnKeyEvent.
 */
membrane.ui.__GT_OnKeyEvent = (function membrane$ui$__GT_OnKeyEvent(on_key_event,drawables){
return (new membrane.ui.OnKeyEvent(on_key_event,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnKeyEvent, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnKeyEvent = (function membrane$ui$map__GT_OnKeyEvent(G__32289){
var extmap__4419__auto__ = (function (){var G__32308 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32289,new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32289)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32308);
} else {
return G__32308;
}
})();
return (new membrane.ui.OnKeyEvent(new cljs.core.Keyword(null,"on-key-event","on-key-event",919254313).cljs$core$IFn$_invoke$arity$1(G__32289),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32289),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnKeyEvent,(function (draw){
return (function (this$){
var seq__32309 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32310 = null;
var count__32311 = (0);
var i__32312 = (0);
while(true){
if((i__32312 < count__32311)){
var drawable = chunk__32310.cljs$core$IIndexed$_nth$arity$2(null,i__32312);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34332 = seq__32309;
var G__34333 = chunk__32310;
var G__34334 = count__32311;
var G__34335 = (i__32312 + (1));
seq__32309 = G__34332;
chunk__32310 = G__34333;
count__32311 = G__34334;
i__32312 = G__34335;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32309);
if(temp__5735__auto__){
var seq__32309__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32309__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32309__$1);
var G__34336 = cljs.core.chunk_rest(seq__32309__$1);
var G__34337 = c__4556__auto__;
var G__34338 = cljs.core.count(c__4556__auto__);
var G__34339 = (0);
seq__32309 = G__34336;
chunk__32310 = G__34337;
count__32311 = G__34338;
i__32312 = G__34339;
continue;
} else {
var drawable = cljs.core.first(seq__32309__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34340 = cljs.core.next(seq__32309__$1);
var G__34341 = null;
var G__34342 = (0);
var G__34343 = (0);
seq__32309 = G__34340;
chunk__32310 = G__34341;
count__32311 = G__34342;
i__32312 = G__34343;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for key events.
 * 
 *   on-key-event should take 4 arguments key, scancode, action, mods and return a sequence of effects.
 */
membrane.ui.on_key_event = (function membrane$ui$on_key_event(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34344 = arguments.length;
var i__4737__auto___34345 = (0);
while(true){
if((i__4737__auto___34345 < len__4736__auto___34344)){
args__4742__auto__.push((arguments[i__4737__auto___34345]));

var G__34347 = (i__4737__auto___34345 + (1));
i__4737__auto___34345 = G__34347;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic = (function (on_key_event,drawables){
return (new membrane.ui.OnKeyEvent(on_key_event,drawables,null,null,null));
}));

(membrane.ui.on_key_event.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_key_event.cljs$lang$applyTo = (function (seq32313){
var G__32314 = cljs.core.first(seq32313);
var seq32313__$1 = cljs.core.next(seq32313);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32314,seq32313__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {membrane.ui.IBubble}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnBubble = (function (on_bubble,drawables,__meta,__extmap,__hash){
this.on_bubble = on_bubble;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnBubble.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnBubble.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32316,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32320 = k32316;
var G__32320__$1 = (((G__32320 instanceof cljs.core.Keyword))?G__32320.fqn:null);
switch (G__32320__$1) {
case "on-bubble":
return self__.on_bubble;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32316,else__4383__auto__);

}
}));

(membrane.ui.OnBubble.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32321){
var vec__32322 = p__32321;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32322,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32322,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnBubble.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnBubble{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),self__.on_bubble],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnBubble.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32315){
var self__ = this;
var G__32315__$1 = this;
return (new cljs.core.RecordIter((0),G__32315__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32325,elem){
var vec__32326 = p__32325;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32326,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32326,(1),null);
var vec__32329 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32329,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32329,(1),null);
var vec__32332 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32332,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32332,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnBubble.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnBubble.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnBubble.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnBubble.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1969513103 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnBubble.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32317,other32318){
var self__ = this;
var this32317__$1 = this;
return (((!((other32318 == null)))) && ((this32317__$1.constructor === other32318.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32317__$1.on_bubble,other32318.on_bubble)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32317__$1.drawables,other32318.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32317__$1.__extmap,other32318.__extmap)));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IBubble$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IBubble$_bubble$arity$2 = (function (this$,effects){
var self__ = this;
var this$__$1 = this;
return (self__.on_bubble.cljs$core$IFn$_invoke$arity$1 ? self__.on_bubble.cljs$core$IFn$_invoke$arity$1(effects) : self__.on_bubble.call(null,effects));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnBubble.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnBubble.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32315){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32335 = cljs.core.keyword_identical_QMARK_;
var expr__32336 = k__4388__auto__;
if(cljs.core.truth_((pred__32335.cljs$core$IFn$_invoke$arity$2 ? pred__32335.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),expr__32336) : pred__32335.call(null,new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),expr__32336)))){
return (new membrane.ui.OnBubble(G__32315,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32335.cljs$core$IFn$_invoke$arity$2 ? pred__32335.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32336) : pred__32335.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32336)))){
return (new membrane.ui.OnBubble(self__.on_bubble,G__32315,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32315),null));
}
}
}));

(membrane.ui.OnBubble.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),self__.on_bubble,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnBubble.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnBubble.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnBubble(self__.on_bubble,childs,null,null,null));
}));

(membrane.ui.OnBubble.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32315){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnBubble(self__.on_bubble,self__.drawables,G__32315,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnBubble.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnBubble.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-bubble","on-bubble",-725584761,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnBubble.cljs$lang$type = true);

(membrane.ui.OnBubble.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnBubble",null,(1),null));
}));

(membrane.ui.OnBubble.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnBubble");
}));

/**
 * Positional factory function for membrane.ui/OnBubble.
 */
membrane.ui.__GT_OnBubble = (function membrane$ui$__GT_OnBubble(on_bubble,drawables){
return (new membrane.ui.OnBubble(on_bubble,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnBubble, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnBubble = (function membrane$ui$map__GT_OnBubble(G__32319){
var extmap__4419__auto__ = (function (){var G__32338 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32319,new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32319)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32338);
} else {
return G__32338;
}
})();
return (new membrane.ui.OnBubble(new cljs.core.Keyword(null,"on-bubble","on-bubble",1928851008).cljs$core$IFn$_invoke$arity$1(G__32319),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32319),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnBubble,(function (draw){
return (function (this$){
var seq__32339 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32340 = null;
var count__32341 = (0);
var i__32342 = (0);
while(true){
if((i__32342 < count__32341)){
var drawable = chunk__32340.cljs$core$IIndexed$_nth$arity$2(null,i__32342);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34387 = seq__32339;
var G__34388 = chunk__32340;
var G__34389 = count__32341;
var G__34390 = (i__32342 + (1));
seq__32339 = G__34387;
chunk__32340 = G__34388;
count__32341 = G__34389;
i__32342 = G__34390;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32339);
if(temp__5735__auto__){
var seq__32339__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32339__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32339__$1);
var G__34391 = cljs.core.chunk_rest(seq__32339__$1);
var G__34392 = c__4556__auto__;
var G__34393 = cljs.core.count(c__4556__auto__);
var G__34394 = (0);
seq__32339 = G__34391;
chunk__32340 = G__34392;
count__32341 = G__34393;
i__32342 = G__34394;
continue;
} else {
var drawable = cljs.core.first(seq__32339__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34395 = cljs.core.next(seq__32339__$1);
var G__34396 = null;
var G__34397 = (0);
var G__34398 = (0);
seq__32339 = G__34395;
chunk__32340 = G__34396;
count__32341 = G__34397;
i__32342 = G__34398;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for bubbling
 * 
 *   on-bubble should take seq of effects
 */
membrane.ui.on_bubble = (function membrane$ui$on_bubble(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34399 = arguments.length;
var i__4737__auto___34400 = (0);
while(true){
if((i__4737__auto___34400 < len__4736__auto___34399)){
args__4742__auto__.push((arguments[i__4737__auto___34400]));

var G__34401 = (i__4737__auto___34400 + (1));
i__4737__auto___34400 = G__34401;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_bubble.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_bubble.cljs$core$IFn$_invoke$arity$variadic = (function (on_bubble,drawables){
return (new membrane.ui.OnBubble(on_bubble,drawables,null,null,null));
}));

(membrane.ui.on_bubble.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_bubble.cljs$lang$applyTo = (function (seq32343){
var G__32344 = cljs.core.first(seq32343);
var seq32343__$1 = cljs.core.next(seq32343);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32344,seq32343__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IClipboardPaste}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClipboardPaste = (function (on_clipboard_paste,drawables,__meta,__extmap,__hash){
this.on_clipboard_paste = on_clipboard_paste;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClipboardPaste.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32346,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32350 = k32346;
var G__32350__$1 = (((G__32350 instanceof cljs.core.Keyword))?G__32350.fqn:null);
switch (G__32350__$1) {
case "on-clipboard-paste":
return self__.on_clipboard_paste;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32346,else__4383__auto__);

}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32351){
var vec__32352 = p__32351;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32352,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32352,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClipboardPaste{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),self__.on_clipboard_paste],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32345){
var self__ = this;
var G__32345__$1 = this;
return (new cljs.core.RecordIter((0),G__32345__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32355,elem){
var vec__32356 = p__32355;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32356,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32356,(1),null);
var vec__32359 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32359,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32359,(1),null);
var vec__32362 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32362,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32362,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1782102848 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32347,other32348){
var self__ = this;
var this32347__$1 = this;
return (((!((other32348 == null)))) && ((this32347__$1.constructor === other32348.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32347__$1.on_clipboard_paste,other32348.on_clipboard_paste)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32347__$1.drawables,other32348.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32347__$1.__extmap,other32348.__extmap)));
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IClipboardPaste$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2 = (function (this$,s){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_clipboard_paste)){
return (self__.on_clipboard_paste.cljs$core$IFn$_invoke$arity$1 ? self__.on_clipboard_paste.cljs$core$IFn$_invoke$arity$1(s) : self__.on_clipboard_paste.call(null,s));
} else {
return null;
}
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32345){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32365 = cljs.core.keyword_identical_QMARK_;
var expr__32366 = k__4388__auto__;
if(cljs.core.truth_((pred__32365.cljs$core$IFn$_invoke$arity$2 ? pred__32365.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),expr__32366) : pred__32365.call(null,new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),expr__32366)))){
return (new membrane.ui.OnClipboardPaste(G__32345,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32365.cljs$core$IFn$_invoke$arity$2 ? pred__32365.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32366) : pred__32365.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32366)))){
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,G__32345,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32345),null));
}
}
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),self__.on_clipboard_paste,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardPaste.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,childs,null,null,null));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32345){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClipboardPaste(self__.on_clipboard_paste,self__.drawables,G__32345,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardPaste.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClipboardPaste.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-clipboard-paste","on-clipboard-paste",-69142678,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClipboardPaste.cljs$lang$type = true);

(membrane.ui.OnClipboardPaste.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClipboardPaste",null,(1),null));
}));

(membrane.ui.OnClipboardPaste.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClipboardPaste");
}));

/**
 * Positional factory function for membrane.ui/OnClipboardPaste.
 */
membrane.ui.__GT_OnClipboardPaste = (function membrane$ui$__GT_OnClipboardPaste(on_clipboard_paste,drawables){
return (new membrane.ui.OnClipboardPaste(on_clipboard_paste,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClipboardPaste, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClipboardPaste = (function membrane$ui$map__GT_OnClipboardPaste(G__32349){
var extmap__4419__auto__ = (function (){var G__32368 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32349,new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32349)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32368);
} else {
return G__32368;
}
})();
return (new membrane.ui.OnClipboardPaste(new cljs.core.Keyword(null,"on-clipboard-paste","on-clipboard-paste",-1709674205).cljs$core$IFn$_invoke$arity$1(G__32349),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32349),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClipboardPaste,(function (draw){
return (function (this$){
var seq__32369 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32370 = null;
var count__32371 = (0);
var i__32372 = (0);
while(true){
if((i__32372 < count__32371)){
var drawable = chunk__32370.cljs$core$IIndexed$_nth$arity$2(null,i__32372);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34480 = seq__32369;
var G__34481 = chunk__32370;
var G__34482 = count__32371;
var G__34483 = (i__32372 + (1));
seq__32369 = G__34480;
chunk__32370 = G__34481;
count__32371 = G__34482;
i__32372 = G__34483;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32369);
if(temp__5735__auto__){
var seq__32369__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32369__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32369__$1);
var G__34484 = cljs.core.chunk_rest(seq__32369__$1);
var G__34485 = c__4556__auto__;
var G__34486 = cljs.core.count(c__4556__auto__);
var G__34487 = (0);
seq__32369 = G__34484;
chunk__32370 = G__34485;
count__32371 = G__34486;
i__32372 = G__34487;
continue;
} else {
var drawable = cljs.core.first(seq__32369__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34488 = cljs.core.next(seq__32369__$1);
var G__34489 = null;
var G__34490 = (0);
var G__34491 = (0);
seq__32369 = G__34488;
chunk__32370 = G__34489;
count__32371 = G__34490;
i__32372 = G__34491;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for clipboard paste events.
 * 
 *   on-clipboard-paste should take 1 arguments s and return a sequence of effects.
 */
membrane.ui.on_clipboard_paste = (function membrane$ui$on_clipboard_paste(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34492 = arguments.length;
var i__4737__auto___34493 = (0);
while(true){
if((i__4737__auto___34493 < len__4736__auto___34492)){
args__4742__auto__.push((arguments[i__4737__auto___34493]));

var G__34494 = (i__4737__auto___34493 + (1));
i__4737__auto___34493 = G__34494;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_clipboard_paste.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_clipboard_paste.cljs$core$IFn$_invoke$arity$variadic = (function (on_clipboard_paste,drawables){
return (new membrane.ui.OnClipboardPaste(on_clipboard_paste,drawables,null,null,null));
}));

(membrane.ui.on_clipboard_paste.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_clipboard_paste.cljs$lang$applyTo = (function (seq32373){
var G__32374 = cljs.core.first(seq32373);
var seq32373__$1 = cljs.core.next(seq32373);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32374,seq32373__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {membrane.ui.IClipboardCopy}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClipboardCopy = (function (on_clipboard_copy,drawables,__meta,__extmap,__hash){
this.on_clipboard_copy = on_clipboard_copy;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClipboardCopy.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32376,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32380 = k32376;
var G__32380__$1 = (((G__32380 instanceof cljs.core.Keyword))?G__32380.fqn:null);
switch (G__32380__$1) {
case "on-clipboard-copy":
return self__.on_clipboard_copy;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32376,else__4383__auto__);

}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32381){
var vec__32382 = p__32381;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32382,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32382,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClipboardCopy{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),self__.on_clipboard_copy],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32375){
var self__ = this;
var G__32375__$1 = this;
return (new cljs.core.RecordIter((0),G__32375__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32385,elem){
var vec__32386 = p__32385;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32386,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32386,(1),null);
var vec__32389 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32389,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32389,(1),null);
var vec__32392 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32392,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32392,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (336255660 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32377,other32378){
var self__ = this;
var this32377__$1 = this;
return (((!((other32378 == null)))) && ((this32377__$1.constructor === other32378.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32377__$1.on_clipboard_copy,other32378.on_clipboard_copy)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32377__$1.drawables,other32378.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32377__$1.__extmap,other32378.__extmap)));
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IClipboardCopy$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_clipboard_copy)){
return (self__.on_clipboard_copy.cljs$core$IFn$_invoke$arity$0 ? self__.on_clipboard_copy.cljs$core$IFn$_invoke$arity$0() : self__.on_clipboard_copy.call(null));
} else {
return null;
}
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32375){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32395 = cljs.core.keyword_identical_QMARK_;
var expr__32396 = k__4388__auto__;
if(cljs.core.truth_((pred__32395.cljs$core$IFn$_invoke$arity$2 ? pred__32395.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),expr__32396) : pred__32395.call(null,new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),expr__32396)))){
return (new membrane.ui.OnClipboardCopy(G__32375,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32395.cljs$core$IFn$_invoke$arity$2 ? pred__32395.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32396) : pred__32395.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32396)))){
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,G__32375,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32375),null));
}
}
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),self__.on_clipboard_copy,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCopy.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,childs,null,null,null));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32375){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClipboardCopy(self__.on_clipboard_copy,self__.drawables,G__32375,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCopy.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClipboardCopy.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-clipboard-copy","on-clipboard-copy",1411899436,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClipboardCopy.cljs$lang$type = true);

(membrane.ui.OnClipboardCopy.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClipboardCopy",null,(1),null));
}));

(membrane.ui.OnClipboardCopy.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClipboardCopy");
}));

/**
 * Positional factory function for membrane.ui/OnClipboardCopy.
 */
membrane.ui.__GT_OnClipboardCopy = (function membrane$ui$__GT_OnClipboardCopy(on_clipboard_copy,drawables){
return (new membrane.ui.OnClipboardCopy(on_clipboard_copy,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClipboardCopy, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClipboardCopy = (function membrane$ui$map__GT_OnClipboardCopy(G__32379){
var extmap__4419__auto__ = (function (){var G__32398 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32379,new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32379)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32398);
} else {
return G__32398;
}
})();
return (new membrane.ui.OnClipboardCopy(new cljs.core.Keyword(null,"on-clipboard-copy","on-clipboard-copy",-228632091).cljs$core$IFn$_invoke$arity$1(G__32379),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32379),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClipboardCopy,(function (draw){
return (function (this$){
var seq__32399 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32400 = null;
var count__32401 = (0);
var i__32402 = (0);
while(true){
if((i__32402 < count__32401)){
var drawable = chunk__32400.cljs$core$IIndexed$_nth$arity$2(null,i__32402);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34519 = seq__32399;
var G__34520 = chunk__32400;
var G__34521 = count__32401;
var G__34522 = (i__32402 + (1));
seq__32399 = G__34519;
chunk__32400 = G__34520;
count__32401 = G__34521;
i__32402 = G__34522;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32399);
if(temp__5735__auto__){
var seq__32399__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32399__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32399__$1);
var G__34523 = cljs.core.chunk_rest(seq__32399__$1);
var G__34524 = c__4556__auto__;
var G__34525 = cljs.core.count(c__4556__auto__);
var G__34526 = (0);
seq__32399 = G__34523;
chunk__32400 = G__34524;
count__32401 = G__34525;
i__32402 = G__34526;
continue;
} else {
var drawable = cljs.core.first(seq__32399__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34527 = cljs.core.next(seq__32399__$1);
var G__34528 = null;
var G__34529 = (0);
var G__34530 = (0);
seq__32399 = G__34527;
chunk__32400 = G__34528;
count__32401 = G__34529;
i__32402 = G__34530;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for clipboard copy events.
 * 
 *   on-clipboard-copy should take 0 arguments and return a sequence of effects.
 */
membrane.ui.on_clipboard_copy = (function membrane$ui$on_clipboard_copy(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34540 = arguments.length;
var i__4737__auto___34541 = (0);
while(true){
if((i__4737__auto___34541 < len__4736__auto___34540)){
args__4742__auto__.push((arguments[i__4737__auto___34541]));

var G__34542 = (i__4737__auto___34541 + (1));
i__4737__auto___34541 = G__34542;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_clipboard_copy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_clipboard_copy.cljs$core$IFn$_invoke$arity$variadic = (function (on_clipboard_copy,drawables){
return (new membrane.ui.OnClipboardCopy(on_clipboard_copy,drawables,null,null,null));
}));

(membrane.ui.on_clipboard_copy.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_clipboard_copy.cljs$lang$applyTo = (function (seq32403){
var G__32404 = cljs.core.first(seq32403);
var seq32403__$1 = cljs.core.next(seq32403);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32404,seq32403__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IClipboardCut}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnClipboardCut = (function (on_clipboard_cut,drawables,__meta,__extmap,__hash){
this.on_clipboard_cut = on_clipboard_cut;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnClipboardCut.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32406,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32410 = k32406;
var G__32410__$1 = (((G__32410 instanceof cljs.core.Keyword))?G__32410.fqn:null);
switch (G__32410__$1) {
case "on-clipboard-cut":
return self__.on_clipboard_cut;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32406,else__4383__auto__);

}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32411){
var vec__32412 = p__32411;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32412,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32412,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IClipboardCut$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IClipboardCut$_clipboard_cut$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_clipboard_cut)){
return (self__.on_clipboard_cut.cljs$core$IFn$_invoke$arity$0 ? self__.on_clipboard_cut.cljs$core$IFn$_invoke$arity$0() : self__.on_clipboard_cut.call(null));
} else {
return null;
}
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnClipboardCut{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),self__.on_clipboard_cut],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32405){
var self__ = this;
var G__32405__$1 = this;
return (new cljs.core.RecordIter((0),G__32405__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32415,elem){
var vec__32416 = p__32415;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32416,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32416,(1),null);
var vec__32419 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32419,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32419,(1),null);
var vec__32422 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32422,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32422,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (2059173612 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32407,other32408){
var self__ = this;
var this32407__$1 = this;
return (((!((other32408 == null)))) && ((this32407__$1.constructor === other32408.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32407__$1.on_clipboard_cut,other32408.on_clipboard_cut)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32407__$1.drawables,other32408.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32407__$1.__extmap,other32408.__extmap)));
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawables","drawables",1997910160),null,new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32405){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32425 = cljs.core.keyword_identical_QMARK_;
var expr__32426 = k__4388__auto__;
if(cljs.core.truth_((pred__32425.cljs$core$IFn$_invoke$arity$2 ? pred__32425.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),expr__32426) : pred__32425.call(null,new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),expr__32426)))){
return (new membrane.ui.OnClipboardCut(G__32405,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32425.cljs$core$IFn$_invoke$arity$2 ? pred__32425.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32426) : pred__32425.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32426)))){
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,G__32405,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32405),null));
}
}
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),self__.on_clipboard_cut,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnClipboardCut.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,childs,null,null,null));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32405){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnClipboardCut(self__.on_clipboard_cut,self__.drawables,G__32405,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnClipboardCut.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnClipboardCut.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-clipboard-cut","on-clipboard-cut",-1301330217,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnClipboardCut.cljs$lang$type = true);

(membrane.ui.OnClipboardCut.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnClipboardCut",null,(1),null));
}));

(membrane.ui.OnClipboardCut.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnClipboardCut");
}));

/**
 * Positional factory function for membrane.ui/OnClipboardCut.
 */
membrane.ui.__GT_OnClipboardCut = (function membrane$ui$__GT_OnClipboardCut(on_clipboard_cut,drawables){
return (new membrane.ui.OnClipboardCut(on_clipboard_cut,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnClipboardCut, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnClipboardCut = (function membrane$ui$map__GT_OnClipboardCut(G__32409){
var extmap__4419__auto__ = (function (){var G__32428 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32409,new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32409)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32428);
} else {
return G__32428;
}
})();
return (new membrane.ui.OnClipboardCut(new cljs.core.Keyword(null,"on-clipboard-cut","on-clipboard-cut",1353105552).cljs$core$IFn$_invoke$arity$1(G__32409),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32409),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnClipboardCut,(function (draw){
return (function (this$){
var seq__32429 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32430 = null;
var count__32431 = (0);
var i__32432 = (0);
while(true){
if((i__32432 < count__32431)){
var drawable = chunk__32430.cljs$core$IIndexed$_nth$arity$2(null,i__32432);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34600 = seq__32429;
var G__34601 = chunk__32430;
var G__34602 = count__32431;
var G__34603 = (i__32432 + (1));
seq__32429 = G__34600;
chunk__32430 = G__34601;
count__32431 = G__34602;
i__32432 = G__34603;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32429);
if(temp__5735__auto__){
var seq__32429__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32429__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32429__$1);
var G__34610 = cljs.core.chunk_rest(seq__32429__$1);
var G__34611 = c__4556__auto__;
var G__34612 = cljs.core.count(c__4556__auto__);
var G__34613 = (0);
seq__32429 = G__34610;
chunk__32430 = G__34611;
count__32431 = G__34612;
i__32432 = G__34613;
continue;
} else {
var drawable = cljs.core.first(seq__32429__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34616 = cljs.core.next(seq__32429__$1);
var G__34617 = null;
var G__34618 = (0);
var G__34619 = (0);
seq__32429 = G__34616;
chunk__32430 = G__34617;
count__32431 = G__34618;
i__32432 = G__34619;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds a handler for clipboard cut events.
 * 
 *   on-clipboard-copy should take 0 arguments and return a sequence of effects.
 */
membrane.ui.on_clipboard_cut = (function membrane$ui$on_clipboard_cut(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34621 = arguments.length;
var i__4737__auto___34623 = (0);
while(true){
if((i__4737__auto___34623 < len__4736__auto___34621)){
args__4742__auto__.push((arguments[i__4737__auto___34623]));

var G__34624 = (i__4737__auto___34623 + (1));
i__4737__auto___34623 = G__34624;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_clipboard_cut.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_clipboard_cut.cljs$core$IFn$_invoke$arity$variadic = (function (on_clipboard_cut,drawables){
return (new membrane.ui.OnClipboardCut(on_clipboard_cut,drawables,null,null,null));
}));

(membrane.ui.on_clipboard_cut.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_clipboard_cut.cljs$lang$applyTo = (function (seq32433){
var G__32434 = cljs.core.first(seq32433);
var seq32433__$1 = cljs.core.next(seq32433);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32434,seq32433__$1);
}));

/**
 * Returns a graphical elem of elems stacked on top of each other
 */
membrane.ui.vertical_layout = (function membrane$ui$vertical_layout(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34630 = arguments.length;
var i__4737__auto___34631 = (0);
while(true){
if((i__4737__auto___34631 < len__4736__auto___34630)){
args__4742__auto__.push((arguments[i__4737__auto___34631]));

var G__34636 = (i__4737__auto___34631 + (1));
i__4737__auto___34631 = G__34636;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.vertical_layout.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.vertical_layout.cljs$core$IFn$_invoke$arity$variadic = (function (elems){
var elems__$1 = cljs.core.seq(elems);
var first_elem = cljs.core.first(elems__$1);
var offset_y = (membrane.ui.height(first_elem) + membrane.ui.origin_y(first_elem));
if(elems__$1){
var elems__$2 = cljs.core.next(elems__$1);
var offset_y__$1 = (offset_y + (1));
var group_elems = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_elem], null);
while(true){
if(elems__$2){
var elem = cljs.core.first(elems__$2);
var dy = (membrane.ui.height(elem) + membrane.ui.origin_y(elem));
var G__34641 = cljs.core.next(elems__$2);
var G__34642 = ((offset_y__$1 + dy) + (1));
var G__34643 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(group_elems,membrane.ui.translate((0),offset_y__$1,elem));
elems__$2 = G__34641;
offset_y__$1 = G__34642;
group_elems = G__34643;
continue;
} else {
return group_elems;
}
break;
}
} else {
return null;
}
}));

(membrane.ui.vertical_layout.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.vertical_layout.cljs$lang$applyTo = (function (seq32435){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32435));
}));

/**
 * Returns a graphical elem of elems layed out next to eachother.
 */
membrane.ui.horizontal_layout = (function membrane$ui$horizontal_layout(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34644 = arguments.length;
var i__4737__auto___34645 = (0);
while(true){
if((i__4737__auto___34645 < len__4736__auto___34644)){
args__4742__auto__.push((arguments[i__4737__auto___34645]));

var G__34646 = (i__4737__auto___34645 + (1));
i__4737__auto___34645 = G__34646;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.horizontal_layout.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.horizontal_layout.cljs$core$IFn$_invoke$arity$variadic = (function (elems){
var elems__$1 = cljs.core.seq(elems);
var first_elem = cljs.core.first(elems__$1);
var offset_x = (membrane.ui.width(first_elem) + membrane.ui.origin_x(first_elem));
if(elems__$1){
var elems__$2 = cljs.core.next(elems__$1);
var offset_x__$1 = (offset_x + (1));
var group_elems = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [first_elem], null);
while(true){
if(elems__$2){
var elem = cljs.core.first(elems__$2);
var dx = (membrane.ui.width(elem) + membrane.ui.origin_x(elem));
var G__34650 = cljs.core.next(elems__$2);
var G__34651 = ((offset_x__$1 + dx) + (1));
var G__34652 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(group_elems,membrane.ui.translate(offset_x__$1,(0),elem));
elems__$2 = G__34650;
offset_x__$1 = G__34651;
group_elems = G__34652;
continue;
} else {
return group_elems;
}
break;
}
} else {
return null;
}
}));

(membrane.ui.horizontal_layout.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.horizontal_layout.cljs$lang$applyTo = (function (seq32436){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32436));
}));

membrane.ui.table_layout = (function membrane$ui$table_layout(var_args){
var G__32443 = arguments.length;
switch (G__32443) {
case 1:
return membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$1 = (function (table){
return membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$3(table,(0),(0));
}));

(membrane.ui.table_layout.cljs$core$IFn$_invoke$arity$3 = (function (table,cell_padding_x,cell_padding_y){
var row_heights = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (row){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(membrane.ui.height,row));
}),table);
var col_widths = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (col_widths,row){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (col_widths__$1,p__32444){
var vec__32445 = p__32444;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32445,(0),null);
var elem = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32445,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(col_widths__$1,i,(function (p1__32437_SHARP_){
var x__4214__auto__ = (function (){var or__4126__auto__ = p1__32437_SHARP_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})();
var y__4215__auto__ = membrane.ui.width(elem);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}));
}),col_widths,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,row));
}),cljs.core.PersistentVector.EMPTY,table);
var full_padding_x = ((2) * cell_padding_x);
var full_padding_y = ((2) * cell_padding_y);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,(function (){var iter__4529__auto__ = (function membrane$ui$iter__32448(s__32449){
return (new cljs.core.LazySeq(null,(function (){
var s__32449__$1 = s__32449;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__32449__$1);
if(temp__5735__auto__){
var xs__6292__auto__ = temp__5735__auto__;
var vec__32454 = cljs.core.first(xs__6292__auto__);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32454,(0),null);
var row = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32454,(1),null);
var iterys__4525__auto__ = ((function (s__32449__$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function membrane$ui$iter__32448_$_iter__32450(s__32451){
return (new cljs.core.LazySeq(null,((function (s__32449__$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (){
var s__32451__$1 = s__32451;
while(true){
var temp__5735__auto____$1 = cljs.core.seq(s__32451__$1);
if(temp__5735__auto____$1){
var s__32451__$2 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__32451__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__32451__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__32453 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__32452 = (0);
while(true){
if((i__32452 < size__4528__auto__)){
var vec__32457 = cljs.core._nth(c__4527__auto__,i__32452);
var j = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32457,(0),null);
var elem = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32457,(1),null);
cljs.core.chunk_append(b__32453,membrane.ui.translate((cell_padding_x + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__32452,s__32449__$1,vec__32457,j,elem,c__4527__auto__,size__4528__auto__,b__32453,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__32438_SHARP_,p2__32439_SHARP_){
return ((full_padding_x + p1__32438_SHARP_) + p2__32439_SHARP_);
});})(i__32452,s__32449__$1,vec__32457,j,elem,c__4527__auto__,size__4528__auto__,b__32453,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(col_widths,(0),j))),(cell_padding_y + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (i__32452,s__32449__$1,vec__32457,j,elem,c__4527__auto__,size__4528__auto__,b__32453,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__32440_SHARP_,p2__32441_SHARP_){
return ((full_padding_y + p1__32440_SHARP_) + p2__32441_SHARP_);
});})(i__32452,s__32449__$1,vec__32457,j,elem,c__4527__auto__,size__4528__auto__,b__32453,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(row_heights,(0),i))),elem));

var G__34711 = (i__32452 + (1));
i__32452 = G__34711;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32453),membrane$ui$iter__32448_$_iter__32450(cljs.core.chunk_rest(s__32451__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32453),null);
}
} else {
var vec__32460 = cljs.core.first(s__32451__$2);
var j = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32460,(0),null);
var elem = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32460,(1),null);
return cljs.core.cons(membrane.ui.translate((cell_padding_x + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__32449__$1,vec__32460,j,elem,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__32438_SHARP_,p2__32439_SHARP_){
return ((full_padding_x + p1__32438_SHARP_) + p2__32439_SHARP_);
});})(s__32449__$1,vec__32460,j,elem,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(col_widths,(0),j))),(cell_padding_y + cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__32449__$1,vec__32460,j,elem,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y){
return (function (p1__32440_SHARP_,p2__32441_SHARP_){
return ((full_padding_y + p1__32440_SHARP_) + p2__32441_SHARP_);
});})(s__32449__$1,vec__32460,j,elem,s__32451__$2,temp__5735__auto____$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,(0),cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(row_heights,(0),i))),elem),membrane$ui$iter__32448_$_iter__32450(cljs.core.rest(s__32451__$2)));
}
} else {
return null;
}
break;
}
});})(s__32449__$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
,null,null));
});})(s__32449__$1,vec__32454,i,row,xs__6292__auto__,temp__5735__auto__,row_heights,col_widths,full_padding_x,full_padding_y))
;
var fs__4526__auto__ = cljs.core.seq(iterys__4525__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,row)));
if(fs__4526__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4526__auto__,membrane$ui$iter__32448(cljs.core.rest(s__32449__$1)));
} else {
var G__34721 = cljs.core.rest(s__32449__$1);
s__32449__$1 = G__34721;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,table));
})());
}));

(membrane.ui.table_layout.cljs$lang$maxFixedArity = 3);

membrane.ui.center = (function membrane$ui$center(elem,p__32463){
var vec__32464 = p__32463;
var width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32464,(0),null);
var height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32464,(1),null);
var vec__32467 = membrane.ui.bounds(elem);
var ewidth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32467,(0),null);
var eheight = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32467,(1),null);
return membrane.ui.translate((((width / (2)) - (ewidth / (2))) | (0)),(((height / (2)) - (eheight / (2))) | (0)),elem);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {membrane.ui.IScroll}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.OnScroll = (function (on_scroll,drawables,__meta,__extmap,__hash){
this.on_scroll = on_scroll;
this.drawables = drawables;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.OnScroll.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.OnScroll.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32471,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32475 = k32471;
var G__32475__$1 = (((G__32475 instanceof cljs.core.Keyword))?G__32475.fqn:null);
switch (G__32475__$1) {
case "on-scroll":
return self__.on_scroll;

break;
case "drawables":
return self__.drawables;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32471,else__4383__auto__);

}
}));

(membrane.ui.OnScroll.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32476){
var vec__32477 = p__32476;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32477,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32477,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.drawables;
}));

(membrane.ui.OnScroll.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.OnScroll{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),self__.on_scroll],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables],null))], null),self__.__extmap));
}));

(membrane.ui.OnScroll.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32470){
var self__ = this;
var G__32470__$1 = this;
return (new cljs.core.RecordIter((0),G__32470__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),new cljs.core.Keyword(null,"drawables","drawables",1997910160)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IScroll$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IScroll$_scroll$arity$3 = (function (this$,p__32480,mpos){
var self__ = this;
var vec__32481 = p__32480;
var offset_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32481,(0),null);
var offset_y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32481,(1),null);
var offset = vec__32481;
var this$__$1 = this;
if(cljs.core.truth_(self__.on_scroll)){
return (self__.on_scroll.cljs$core$IFn$_invoke$arity$2 ? self__.on_scroll.cljs$core$IFn$_invoke$arity$2(offset,mpos) : self__.on_scroll.call(null,offset,mpos));
} else {
return null;
}
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__32484,elem){
var vec__32485 = p__32484;
var max_width = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32485,(0),null);
var max_height = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32485,(1),null);
var vec__32488 = membrane.ui.origin(elem);
var ox = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32488,(0),null);
var oy = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32488,(1),null);
var vec__32491 = membrane.ui.bounds(elem);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32491,(0),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32491,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var x__4214__auto__ = max_width;
var y__4215__auto__ = (ox + w);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})(),(function (){var x__4214__auto__ = max_height;
var y__4215__auto__ = (oy + h);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
})()], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),self__.drawables);
}));

(membrane.ui.OnScroll.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.OnScroll.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnScroll.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.OnScroll.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1760609386 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.OnScroll.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32472,other32473){
var self__ = this;
var this32472__$1 = this;
return (((!((other32473 == null)))) && ((this32472__$1.constructor === other32473.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32472__$1.on_scroll,other32473.on_scroll)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32472__$1.drawables,other32473.drawables)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32472__$1.__extmap,other32473.__extmap)));
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.OnScroll.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.OnScroll.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32470){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32494 = cljs.core.keyword_identical_QMARK_;
var expr__32495 = k__4388__auto__;
if(cljs.core.truth_((pred__32494.cljs$core$IFn$_invoke$arity$2 ? pred__32494.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),expr__32495) : pred__32494.call(null,new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),expr__32495)))){
return (new membrane.ui.OnScroll(G__32470,self__.drawables,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32494.cljs$core$IFn$_invoke$arity$2 ? pred__32494.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32495) : pred__32494.call(null,new cljs.core.Keyword(null,"drawables","drawables",1997910160),expr__32495)))){
return (new membrane.ui.OnScroll(self__.on_scroll,G__32470,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32470),null));
}
}
}));

(membrane.ui.OnScroll.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),self__.on_scroll,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawables","drawables",1997910160),self__.drawables,null))], null),self__.__extmap));
}));

(membrane.ui.OnScroll.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.OnScroll.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
return (new membrane.ui.OnScroll(self__.on_scroll,childs,null,null,null));
}));

(membrane.ui.OnScroll.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32470){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.OnScroll(self__.on_scroll,self__.drawables,G__32470,self__.__extmap,self__.__hash));
}));

(membrane.ui.OnScroll.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.OnScroll.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"on-scroll","on-scroll",-1063587092,null),new cljs.core.Symbol(null,"drawables","drawables",-656525609,null)], null);
}));

(membrane.ui.OnScroll.cljs$lang$type = true);

(membrane.ui.OnScroll.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/OnScroll",null,(1),null));
}));

(membrane.ui.OnScroll.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/OnScroll");
}));

/**
 * Positional factory function for membrane.ui/OnScroll.
 */
membrane.ui.__GT_OnScroll = (function membrane$ui$__GT_OnScroll(on_scroll,drawables){
return (new membrane.ui.OnScroll(on_scroll,drawables,null,null,null));
});

/**
 * Factory function for membrane.ui/OnScroll, taking a map of keywords to field values.
 */
membrane.ui.map__GT_OnScroll = (function membrane$ui$map__GT_OnScroll(G__32474){
var extmap__4419__auto__ = (function (){var G__32497 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32474,new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"drawables","drawables",1997910160)], 0));
if(cljs.core.record_QMARK_(G__32474)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32497);
} else {
return G__32497;
}
})();
return (new membrane.ui.OnScroll(new cljs.core.Keyword(null,"on-scroll","on-scroll",1590848677).cljs$core$IFn$_invoke$arity$1(G__32474),new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(G__32474),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.OnScroll,(function (draw){
return (function (this$){
var seq__32498 = cljs.core.seq(new cljs.core.Keyword(null,"drawables","drawables",1997910160).cljs$core$IFn$_invoke$arity$1(this$));
var chunk__32499 = null;
var count__32500 = (0);
var i__32501 = (0);
while(true){
if((i__32501 < count__32500)){
var drawable = chunk__32499.cljs$core$IIndexed$_nth$arity$2(null,i__32501);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34758 = seq__32498;
var G__34759 = chunk__32499;
var G__34760 = count__32500;
var G__34761 = (i__32501 + (1));
seq__32498 = G__34758;
chunk__32499 = G__34759;
count__32500 = G__34760;
i__32501 = G__34761;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__32498);
if(temp__5735__auto__){
var seq__32498__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__32498__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__32498__$1);
var G__34772 = cljs.core.chunk_rest(seq__32498__$1);
var G__34773 = c__4556__auto__;
var G__34774 = cljs.core.count(c__4556__auto__);
var G__34775 = (0);
seq__32498 = G__34772;
chunk__32499 = G__34773;
count__32500 = G__34774;
i__32501 = G__34775;
continue;
} else {
var drawable = cljs.core.first(seq__32498__$1);
(draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(drawable) : draw.call(null,drawable));


var G__34776 = cljs.core.next(seq__32498__$1);
var G__34777 = null;
var G__34778 = (0);
var G__34779 = (0);
seq__32498 = G__34776;
chunk__32499 = G__34777;
count__32500 = G__34778;
i__32501 = G__34779;
continue;
}
} else {
return null;
}
}
break;
}
});
}));
/**
 * Wraps drawables and adds an event handler for scroll events.
 * 
 *   on-scroll should take 1 argument [offset-x offset-y] of the scroll offset and return a sequence of effects.
 */
membrane.ui.on_scroll = (function membrane$ui$on_scroll(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34780 = arguments.length;
var i__4737__auto___34781 = (0);
while(true){
if((i__4737__auto___34781 < len__4736__auto___34780)){
args__4742__auto__.push((arguments[i__4737__auto___34781]));

var G__34782 = (i__4737__auto___34781 + (1));
i__4737__auto___34781 = G__34782;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic = (function (on_scroll,drawables){
return (new membrane.ui.OnScroll(on_scroll,drawables,null,null,null));
}));

(membrane.ui.on_scroll.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(membrane.ui.on_scroll.cljs$lang$applyTo = (function (seq32502){
var G__32503 = cljs.core.first(seq32502);
var seq32502__$1 = cljs.core.next(seq32502);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__32503,seq32502__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.ScissorView = (function (offset,bounds,drawable,__meta,__extmap,__hash){
this.offset = offset;
this.bounds = bounds;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.ScissorView.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.ScissorView.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32505,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32509 = k32505;
var G__32509__$1 = (((G__32509 instanceof cljs.core.Keyword))?G__32509.fqn:null);
switch (G__32509__$1) {
case "offset":
return self__.offset;

break;
case "bounds":
return self__.bounds;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32505,else__4383__auto__);

}
}));

(membrane.ui.ScissorView.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32510){
var vec__32511 = p__32510;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32511,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32511,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.ScissorView.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.ScissorView{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.ScissorView.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32504){
var self__ = this;
var G__32504__$1 = this;
return (new cljs.core.RecordIter((0),G__32504__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"bounds","bounds",1691609455),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.bounds;
}));

(membrane.ui.ScissorView.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.ScissorView.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScissorView.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.ScissorView.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1562895887 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.ScissorView.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32506,other32507){
var self__ = this;
var this32506__$1 = this;
return (((!((other32507 == null)))) && ((this32506__$1.constructor === other32507.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32506__$1.offset,other32507.offset)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32506__$1.bounds,other32507.bounds)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32506__$1.drawable,other32507.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32506__$1.__extmap,other32507.__extmap)));
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.ScissorView.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"offset","offset",296498311),null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.ScissorView.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32504){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32514 = cljs.core.keyword_identical_QMARK_;
var expr__32515 = k__4388__auto__;
if(cljs.core.truth_((pred__32514.cljs$core$IFn$_invoke$arity$2 ? pred__32514.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"offset","offset",296498311),expr__32515) : pred__32514.call(null,new cljs.core.Keyword(null,"offset","offset",296498311),expr__32515)))){
return (new membrane.ui.ScissorView(G__32504,self__.bounds,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32514.cljs$core$IFn$_invoke$arity$2 ? pred__32514.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__32515) : pred__32514.call(null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__32515)))){
return (new membrane.ui.ScissorView(self__.offset,G__32504,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32514.cljs$core$IFn$_invoke$arity$2 ? pred__32514.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32515) : pred__32514.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32515)))){
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,G__32504,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32504),null));
}
}
}
}));

(membrane.ui.ScissorView.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.ScissorView.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScissorView.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.ScissorView(self__.offset,self__.bounds,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.ScissorView.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32504){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.ScissorView(self__.offset,self__.bounds,self__.drawable,G__32504,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScissorView.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.ScissorView.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"offset","offset",1937029838,null),new cljs.core.Symbol(null,"bounds","bounds",-962826314,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.ScissorView.cljs$lang$type = true);

(membrane.ui.ScissorView.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/ScissorView",null,(1),null));
}));

(membrane.ui.ScissorView.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/ScissorView");
}));

/**
 * Positional factory function for membrane.ui/ScissorView.
 */
membrane.ui.__GT_ScissorView = (function membrane$ui$__GT_ScissorView(offset,bounds,drawable){
return (new membrane.ui.ScissorView(offset,bounds,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/ScissorView, taking a map of keywords to field values.
 */
membrane.ui.map__GT_ScissorView = (function membrane$ui$map__GT_ScissorView(G__32508){
var extmap__4419__auto__ = (function (){var G__32517 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32508,new cljs.core.Keyword(null,"offset","offset",296498311),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"bounds","bounds",1691609455),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__32508)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32517);
} else {
return G__32517;
}
})();
return (new membrane.ui.ScissorView(new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(G__32508),new cljs.core.Keyword(null,"bounds","bounds",1691609455).cljs$core$IFn$_invoke$arity$1(G__32508),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32508),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem to only draw drawable within bounds with an offset.
 * 
 *   All other drawing will be clipped.
 */
membrane.ui.scissor_view = (function membrane$ui$scissor_view(offset,bounds,drawable){
return (new membrane.ui.ScissorView(offset,bounds,drawable,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {membrane.ui.IDrop}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMove}
 * @implements {membrane.ui.IMouseMoveGlobal}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IMouseEvent}
 * @implements {membrane.ui.IBounds}
 * @implements {membrane.ui.IScroll}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.ScrollView = (function (bounds,offset,drawable,__meta,__extmap,__hash){
this.bounds = bounds;
this.offset = offset;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.ScrollView.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.ScrollView.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32519,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32523 = k32519;
var G__32523__$1 = (((G__32523 instanceof cljs.core.Keyword))?G__32523.fqn:null);
switch (G__32523__$1) {
case "bounds":
return self__.bounds;

break;
case "offset":
return self__.offset;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32519,else__4383__auto__);

}
}));

(membrane.ui.ScrollView.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32524){
var vec__32525 = p__32524;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32525,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32525,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.ScrollView.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.ScrollView{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.ScrollView.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32518){
var self__ = this;
var G__32518__$1 = this;
return (new cljs.core.RecordIter((0),G__32518__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"bounds","bounds",1691609455),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IScroll$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IScroll$_scroll$arity$3 = (function (this$,input_offset,p__32528){
var self__ = this;
var vec__32529 = p__32528;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32529,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32529,(1),null);
var pos = vec__32529;
var this$__$1 = this;
return membrane.ui.scroll(self__.drawable,input_offset,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseEvent$_mouse_event$arity$5 = (function (this$,p__32532,button,mouse_down_QMARK_,mods){
var self__ = this;
var vec__32533 = p__32532;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32533,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32533,(1),null);
var pos = vec__32533;
var this$__$1 = this;
return membrane.ui.mouse_event(self__.drawable,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null),button,mouse_down_QMARK_,mods);
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.bounds;
}));

(membrane.ui.ScrollView.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.ScrollView.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScrollView.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.ScrollView.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1565568478 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.ScrollView.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32520,other32521){
var self__ = this;
var this32520__$1 = this;
return (((!((other32521 == null)))) && ((this32520__$1.constructor === other32521.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32520__$1.bounds,other32521.bounds)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32520__$1.offset,other32521.offset)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32520__$1.drawable,other32521.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32520__$1.__extmap,other32521.__extmap)));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.ScrollView.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"offset","offset",296498311),null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.ScrollView.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32518){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32536 = cljs.core.keyword_identical_QMARK_;
var expr__32537 = k__4388__auto__;
if(cljs.core.truth_((pred__32536.cljs$core$IFn$_invoke$arity$2 ? pred__32536.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__32537) : pred__32536.call(null,new cljs.core.Keyword(null,"bounds","bounds",1691609455),expr__32537)))){
return (new membrane.ui.ScrollView(G__32518,self__.offset,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32536.cljs$core$IFn$_invoke$arity$2 ? pred__32536.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"offset","offset",296498311),expr__32537) : pred__32536.call(null,new cljs.core.Keyword(null,"offset","offset",296498311),expr__32537)))){
return (new membrane.ui.ScrollView(self__.bounds,G__32518,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32536.cljs$core$IFn$_invoke$arity$2 ? pred__32536.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32537) : pred__32536.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32537)))){
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,G__32518,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32518),null));
}
}
}
}));

(membrane.ui.ScrollView.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"bounds","bounds",1691609455),self__.bounds,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"offset","offset",296498311),self__.offset,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.ScrollView(self__.offset,self__.bounds,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMove$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMove$_mouse_move$arity$2 = (function (this$,p__32539){
var self__ = this;
var vec__32540 = p__32539;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32540,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32540,(1),null);
var pos = vec__32540;
var this$__$1 = this;
return membrane.ui.mouse_move(self__.drawable,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32518){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.ScrollView(self__.bounds,self__.offset,self__.drawable,G__32518,self__.__extmap,self__.__hash));
}));

(membrane.ui.ScrollView.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IDrop$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IDrop$_drop$arity$3 = (function (this$,paths,p__32543){
var self__ = this;
var vec__32544 = p__32543;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32544,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32544,(1),null);
var pos = vec__32544;
var this$__$1 = this;
return membrane.ui.drop(self__.drawable,paths,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.ScrollView.prototype.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 = (function (this$,mouse_offset){
var self__ = this;
var this$__$1 = this;
var vec__32547 = mouse_offset;
var mx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32547,(0),null);
var my = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32547,(1),null);
return membrane.ui._default_mouse_move_global(this$__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(mx - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(0))),(my - cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.offset,(1)))], null));
}));

(membrane.ui.ScrollView.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"bounds","bounds",-962826314,null),new cljs.core.Symbol(null,"offset","offset",1937029838,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.ScrollView.cljs$lang$type = true);

(membrane.ui.ScrollView.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/ScrollView",null,(1),null));
}));

(membrane.ui.ScrollView.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/ScrollView");
}));

/**
 * Positional factory function for membrane.ui/ScrollView.
 */
membrane.ui.__GT_ScrollView = (function membrane$ui$__GT_ScrollView(bounds,offset,drawable){
return (new membrane.ui.ScrollView(bounds,offset,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/ScrollView, taking a map of keywords to field values.
 */
membrane.ui.map__GT_ScrollView = (function membrane$ui$map__GT_ScrollView(G__32522){
var extmap__4419__auto__ = (function (){var G__32550 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32522,new cljs.core.Keyword(null,"bounds","bounds",1691609455),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__32522)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32550);
} else {
return G__32550;
}
})();
return (new membrane.ui.ScrollView(new cljs.core.Keyword(null,"bounds","bounds",1691609455).cljs$core$IFn$_invoke$arity$1(G__32522),new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(G__32522),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32522),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

/**
 * Graphical elem that will draw drawable offset by offset and clip its drawings to bounds. 
 */
membrane.ui.scrollview = (function membrane$ui$scrollview(bounds,offset,drawable){
return (new membrane.ui.ScrollView(bounds,offset,drawable,null,null,null));
});

/**
 * @interface
 */
membrane.ui.IHandleEvent = function(){};

var membrane$ui$IHandleEvent$_can_handle_QMARK_$dyn_34913 = (function (this$,event_type){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui._can_handle_QMARK_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(this$,event_type) : m__4429__auto__.call(null,this$,event_type));
} else {
var m__4426__auto__ = (membrane.ui._can_handle_QMARK_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(this$,event_type) : m__4426__auto__.call(null,this$,event_type));
} else {
throw cljs.core.missing_protocol("IHandleEvent.-can-handle?",this$);
}
}
});
membrane.ui._can_handle_QMARK_ = (function membrane$ui$_can_handle_QMARK_(this$,event_type){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2 == null)))))){
return this$.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2(this$,event_type);
} else {
return membrane$ui$IHandleEvent$_can_handle_QMARK_$dyn_34913(this$,event_type);
}
});

var membrane$ui$IHandleEvent$_handle_event$dyn_34914 = (function (this$,event_type,event_args){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (membrane.ui._handle_event[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(this$,event_type,event_args) : m__4429__auto__.call(null,this$,event_type,event_args));
} else {
var m__4426__auto__ = (membrane.ui._handle_event["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(this$,event_type,event_args) : m__4426__auto__.call(null,this$,event_type,event_args));
} else {
throw cljs.core.missing_protocol("IHandleEvent.-handle-event",this$);
}
}
});
membrane.ui._handle_event = (function membrane$ui$_handle_event(this$,event_type,event_args){
if((((!((this$ == null)))) && ((!((this$.membrane$ui$IHandleEvent$_handle_event$arity$3 == null)))))){
return this$.membrane$ui$IHandleEvent$_handle_event$arity$3(this$,event_type,event_args);
} else {
return membrane$ui$IHandleEvent$_handle_event$dyn_34914(this$,event_type,event_args);
}
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {membrane.ui.IBubble}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IHandleEvent}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.EventHandler = (function (event_type,handler,drawable,__meta,__extmap,__hash){
this.event_type = event_type;
this.handler = handler;
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.EventHandler.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.EventHandler.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32552,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32556 = k32552;
var G__32556__$1 = (((G__32556 instanceof cljs.core.Keyword))?G__32556.fqn:null);
switch (G__32556__$1) {
case "event-type":
return self__.event_type;

break;
case "handler":
return self__.handler;

break;
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32552,else__4383__auto__);

}
}));

(membrane.ui.EventHandler.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32557){
var vec__32558 = p__32557;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32558,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32558,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.EventHandler.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.EventHandler{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"event-type","event-type",319722813),self__.event_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.EventHandler.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32551){
var self__ = this;
var G__32551__$1 = this;
return (new cljs.core.RecordIter((0),G__32551__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"event-type","event-type",319722813),new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,membrane.ui.origin(self__.drawable),membrane.ui.bounds(self__.drawable));
}));

(membrane.ui.EventHandler.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.EventHandler.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.EventHandler.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.EventHandler.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1200937433 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.EventHandler.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32553,other32554){
var self__ = this;
var this32553__$1 = this;
return (((!((other32554 == null)))) && ((this32553__$1.constructor === other32554.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32553__$1.event_type,other32554.event_type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32553__$1.handler,other32554.handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32553__$1.drawable,other32554.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32553__$1.__extmap,other32554.__extmap)));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IBubble$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IBubble$_bubble$arity$2 = (function (this$,events){
var self__ = this;
var this$__$1 = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,(function (){var iter__4529__auto__ = (function membrane$ui$iter__32561(s__32562){
return (new cljs.core.LazySeq(null,(function (){
var s__32562__$1 = s__32562;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__32562__$1);
if(temp__5735__auto__){
var s__32562__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32562__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__32562__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__32564 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__32563 = (0);
while(true){
if((i__32563 < size__4528__auto__)){
var intent = cljs.core._nth(c__4527__auto__,i__32563);
var intent_type = cljs.core.first(intent);
cljs.core.chunk_append(b__32564,(cljs.core.truth_(this$__$1.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2(null,intent_type))?this$__$1.membrane$ui$IHandleEvent$_handle_event$arity$3(null,intent_type,cljs.core.rest(intent)):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [intent], null)));

var G__34921 = (i__32563 + (1));
i__32563 = G__34921;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32564),membrane$ui$iter__32561(cljs.core.chunk_rest(s__32562__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32564),null);
}
} else {
var intent = cljs.core.first(s__32562__$2);
var intent_type = cljs.core.first(intent);
return cljs.core.cons((cljs.core.truth_(this$__$1.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2(null,intent_type))?this$__$1.membrane$ui$IHandleEvent$_handle_event$arity$3(null,intent_type,cljs.core.rest(intent)):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [intent], null)),membrane$ui$iter__32561(cljs.core.rest(s__32562__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(events);
})());
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.EventHandler.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"handler","handler",-195596612),null,new cljs.core.Keyword(null,"event-type","event-type",319722813),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.EventHandler.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32551){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32565 = cljs.core.keyword_identical_QMARK_;
var expr__32566 = k__4388__auto__;
if(cljs.core.truth_((pred__32565.cljs$core$IFn$_invoke$arity$2 ? pred__32565.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"event-type","event-type",319722813),expr__32566) : pred__32565.call(null,new cljs.core.Keyword(null,"event-type","event-type",319722813),expr__32566)))){
return (new membrane.ui.EventHandler(G__32551,self__.handler,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32565.cljs$core$IFn$_invoke$arity$2 ? pred__32565.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"handler","handler",-195596612),expr__32566) : pred__32565.call(null,new cljs.core.Keyword(null,"handler","handler",-195596612),expr__32566)))){
return (new membrane.ui.EventHandler(self__.event_type,G__32551,self__.drawable,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32565.cljs$core$IFn$_invoke$arity$2 ? pred__32565.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32566) : pred__32565.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32566)))){
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,G__32551,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32551),null));
}
}
}
}));

(membrane.ui.EventHandler.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"event-type","event-type",319722813),self__.event_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"handler","handler",-195596612),self__.handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.EventHandler(self__.event_type,self__.handler,cljs.core.first(childs),null,null,null));
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IHandleEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.EventHandler.prototype.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2 = (function (this$,other_event_type){
var self__ = this;
var this$__$1 = this;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(self__.event_type,other_event_type);
}));

(membrane.ui.EventHandler.prototype.membrane$ui$IHandleEvent$_handle_event$arity$3 = (function (this$,event_type__$1,event_args){
var self__ = this;
var this$__$1 = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.handler,event_args);
}));

(membrane.ui.EventHandler.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32551){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.EventHandler(self__.event_type,self__.handler,self__.drawable,G__32551,self__.__extmap,self__.__hash));
}));

(membrane.ui.EventHandler.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.EventHandler.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"event-type","event-type",1960254340,null),new cljs.core.Symbol(null,"handler","handler",1444934915,null),new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.EventHandler.cljs$lang$type = true);

(membrane.ui.EventHandler.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/EventHandler",null,(1),null));
}));

(membrane.ui.EventHandler.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/EventHandler");
}));

/**
 * Positional factory function for membrane.ui/EventHandler.
 */
membrane.ui.__GT_EventHandler = (function membrane$ui$__GT_EventHandler(event_type,handler,drawable){
return (new membrane.ui.EventHandler(event_type,handler,drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/EventHandler, taking a map of keywords to field values.
 */
membrane.ui.map__GT_EventHandler = (function membrane$ui$map__GT_EventHandler(G__32555){
var extmap__4419__auto__ = (function (){var G__32568 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32555,new cljs.core.Keyword(null,"event-type","event-type",319722813),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"handler","handler",-195596612),new cljs.core.Keyword(null,"drawable","drawable",1829255936)], 0));
if(cljs.core.record_QMARK_(G__32555)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32568);
} else {
return G__32568;
}
})();
return (new membrane.ui.EventHandler(new cljs.core.Keyword(null,"event-type","event-type",319722813).cljs$core$IFn$_invoke$arity$1(G__32555),new cljs.core.Keyword(null,"handler","handler",-195596612).cljs$core$IFn$_invoke$arity$1(G__32555),new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32555),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.EventHandler,(function (draw){
return (function (this$){
var G__32569 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__32569) : draw.call(null,G__32569));
});
}));
if((typeof membrane !== 'undefined') && (typeof membrane.ui !== 'undefined') && (typeof membrane.ui.on_handler !== 'undefined')){
} else {
membrane.ui.on_handler = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword("membrane.ui","on-handler-default","membrane.ui/on-handler-default",1778827142)], null),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__32570 = cljs.core.get_global_hierarchy;
return (fexpr__32570.cljs$core$IFn$_invoke$arity$0 ? fexpr__32570.cljs$core$IFn$_invoke$arity$0() : fexpr__32570.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("membrane.ui","on-handler"),(function (event_type,handler,body){
return event_type;
}),new cljs.core.Keyword("membrane.ui","on-handler-default","membrane.ui/on-handler-default",1778827142),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
membrane.ui.on_handler.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("membrane.ui","on-handler-default","membrane.ui/on-handler-default",1778827142),(function (event_type,handler,body){
return (new membrane.ui.EventHandler(event_type,handler,body,null,null,null));
}));
/**
 * Wraps an elem with event handlers.
 * 
 *   events are pairs of events and event handlers and the last argument should be an elem.
 * 
 *   example:
 * 
 *   Adds do nothing event handlers for mouse-down and mouse-up events on a label that says "Hello!"
 *   (on :mouse-down (fn [[mx my]] nil)
 *    :mouse-up (fn [[mx my]] nil)
 *   (label "Hello!"))
 *   
 */
membrane.ui.on = (function membrane$ui$on(var_args){
var args__4742__auto__ = [];
var len__4736__auto___34993 = arguments.length;
var i__4737__auto___34994 = (0);
while(true){
if((i__4737__auto___34994 < len__4736__auto___34993)){
args__4742__auto__.push((arguments[i__4737__auto___34994]));

var G__34995 = (i__4737__auto___34994 + (1));
i__4737__auto___34994 = G__34995;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.on.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.on.cljs$core$IFn$_invoke$arity$variadic = (function (events){
var evs = cljs.core.seq(cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),events)));
var body = cljs.core.last(events);
while(true){
if(evs){
var vec__32576 = cljs.core.first(evs);
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32576,(0),null);
var handler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32576,(1),null);
var G__35003 = cljs.core.next(evs);
var G__35004 = (function (){var G__32579 = event_type;
var G__32579__$1 = (((G__32579 instanceof cljs.core.Keyword))?G__32579.fqn:null);
switch (G__32579__$1) {
case "mouse-down":
return membrane.ui.on_mouse_down.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-event":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "drop":
return membrane.ui.on_drop.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "scroll":
return membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-event":
return membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-press":
return membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-up":
return membrane.ui.on_mouse_up.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move":
return membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move-global":
return membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "clipboard-copy":
return membrane.ui.on_clipboard_copy.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "clipboard-cut":
return membrane.ui.on_clipboard_cut.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "clipboard-paste":
return membrane.ui.on_clipboard_paste.cljs$core$IFn$_invoke$arity$variadic(handler,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
default:
return membrane.ui.on_handler.cljs$core$IFn$_invoke$arity$3(event_type,handler,body);

}
})();
evs = G__35003;
body = G__35004;
continue;
} else {
return body;
}
break;
}
}));

(membrane.ui.on.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.on.cljs$lang$applyTo = (function (seq32571){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32571));
}));

/**
 * Wraps an elem with event handlers.
 * 
 *   events are pairs of events and event handlers and the last argument should be an elem.
 *   The event handlers should accept an extra first argument to the event which is the original event handler.
 * 
 *   example:
 * 
 *   Wraps a button with a mouse-down handler that only returns an effect when the x coordinate is even.
 *   (on :mouse-down (fn [handler [mx my]]
 *                   (when (even? mx)
 *                     (handler [mx my])))
 *   (button "Hello!"
 *          (fn []
 *             [[:hello!]])))
 *   
 */
membrane.ui.wrap_on = (function membrane$ui$wrap_on(var_args){
var args__4742__auto__ = [];
var len__4736__auto___35008 = arguments.length;
var i__4737__auto___35009 = (0);
while(true){
if((i__4737__auto___35009 < len__4736__auto___35008)){
args__4742__auto__.push((arguments[i__4737__auto___35009]));

var G__35010 = (i__4737__auto___35009 + (1));
i__4737__auto___35009 = G__35010;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return membrane.ui.wrap_on.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(membrane.ui.wrap_on.cljs$core$IFn$_invoke$arity$variadic = (function (events){
var evs = cljs.core.seq(cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),events)));
var body = cljs.core.last(events);
while(true){
if(evs){
var vec__32608 = cljs.core.first(evs);
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32608,(0),null);
var handler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32608,(1),null);
var G__35011 = cljs.core.next(evs);
var G__35012 = (function (){var G__32611 = event_type;
var G__32611__$1 = (((G__32611 instanceof cljs.core.Keyword))?G__32611.fqn:null);
switch (G__32611__$1) {
case "mouse-down":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (mpos,button,mouse_down_QMARK_,mods){
if(cljs.core.truth_(mouse_down_QMARK_)){
var G__32612 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (pos){
return membrane.ui.mouse_event(body,pos,button,mouse_down_QMARK_,mods);
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32613 = mpos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__32612,G__32613) : handler.call(null,G__32612,G__32613));
} else {
return membrane.ui.mouse_event(body,mpos,button,mouse_down_QMARK_,mods);
}
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-event":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (mpos,button,mouse_down_QMARK_,mods){
var G__32614 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (mpos__$1,button__$1,mouse_down_QMARK___$1,mods__$1){
return membrane.ui.mouse_event(body,mpos__$1,button__$1,mouse_down_QMARK___$1,mods__$1);
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32615 = mpos;
var G__32616 = button;
var G__32617 = mouse_down_QMARK_;
var G__32618 = mods;
return (handler.cljs$core$IFn$_invoke$arity$5 ? handler.cljs$core$IFn$_invoke$arity$5(G__32614,G__32615,G__32616,G__32617,G__32618) : handler.call(null,G__32614,G__32615,G__32616,G__32617,G__32618));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-event":
return membrane.ui.on_key_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (key,scancode,action,mods){
var G__32619 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (key__$1,scancode__$1,action__$1,mods__$1){
return membrane.ui.key_event.cljs$core$IFn$_invoke$arity$variadic(body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key__$1,scancode__$1,action__$1,mods__$1], 0));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32620 = key;
var G__32621 = scancode;
var G__32622 = action;
var G__32623 = mods;
return (handler.cljs$core$IFn$_invoke$arity$5 ? handler.cljs$core$IFn$_invoke$arity$5(G__32619,G__32620,G__32621,G__32622,G__32623) : handler.call(null,G__32619,G__32620,G__32621,G__32622,G__32623));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "key-press":
return membrane.ui.on_key_press.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (key){
var G__32624 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (key__$1){
return membrane.ui.key_press.cljs$core$IFn$_invoke$arity$variadic(body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key__$1], 0));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32625 = key;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__32624,G__32625) : handler.call(null,G__32624,G__32625));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-up":
return membrane.ui.on_mouse_event.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (mpos,button,mouse_down_QMARK_,mods){
if(cljs.core.not(mouse_down_QMARK_)){
var G__32626 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (pos){
return membrane.ui.mouse_event(body,pos,button,mouse_down_QMARK_,mods);
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32627 = mpos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__32626,G__32627) : handler.call(null,G__32626,G__32627));
} else {
return membrane.ui.mouse_event(body,mpos,button,mouse_down_QMARK_,mods);
}
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move":
return membrane.ui.on_mouse_move.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (pos){
var G__32628 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (pos__$1){
return membrane.ui.mouse_move(body,pos__$1);
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32629 = pos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__32628,G__32629) : handler.call(null,G__32628,G__32629));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "mouse-move-global":
return membrane.ui.on_mouse_move_global.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (pos){
var G__32630 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (pos__$1){
return membrane.ui.mouse_move_global(body,pos__$1);
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32631 = pos;
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(G__32630,G__32631) : handler.call(null,G__32630,G__32631));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
case "scroll":
return membrane.ui.on_scroll.cljs$core$IFn$_invoke$arity$variadic(((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (offset,pos){
var G__32632 = ((function (evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler){
return (function (offset__$1,pos__$1){
return membrane.ui.scroll(body,offset__$1,pos__$1);
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
;
var G__32633 = offset;
var G__32634 = pos;
return (handler.cljs$core$IFn$_invoke$arity$3 ? handler.cljs$core$IFn$_invoke$arity$3(G__32632,G__32633,G__32634) : handler.call(null,G__32632,G__32633,G__32634));
});})(evs,body,G__32611,G__32611__$1,vec__32608,event_type,handler))
,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([body], 0));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__32611__$1)].join('')));

}
})();
evs = G__35011;
body = G__35012;
continue;
} else {
return body;
}
break;
}
}));

(membrane.ui.wrap_on.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(membrane.ui.wrap_on.cljs$lang$applyTo = (function (seq32580){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq32580));
}));


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {membrane.ui.IBubble}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IHandleEvent}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IMouseMove}
 * @implements {membrane.ui.IKeyType}
 * @implements {membrane.ui.IMouseWheel}
 * @implements {membrane.ui.IClipboardCut}
 * @implements {membrane.ui.IMouseMoveGlobal}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {membrane.ui.IScroll}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {membrane.ui.IKeyPress}
 * @implements {membrane.ui.IClipboardPaste}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {membrane.ui.IClipboardCopy}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.NoEvents = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.NoEvents.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.NoEvents.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32636,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32640 = k32636;
var G__32640__$1 = (((G__32640 instanceof cljs.core.Keyword))?G__32640.fqn:null);
switch (G__32640__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32636,else__4383__auto__);

}
}));

(membrane.ui.NoEvents.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32641){
var vec__32642 = p__32641;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32642,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32642,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyType$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyType$_key_type$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCut$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCut$_clipboard_cut$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseWheel$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseWheel$_mouse_wheel$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.NoEvents.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.NoEvents{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.NoEvents.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32635){
var self__ = this;
var G__32635__$1 = this;
return (new cljs.core.RecordIter((0),G__32635__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IScroll$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IScroll$_scroll$arity$3 = (function (this$,pos,mpos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.NoEvents.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.NoEvents.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.NoEvents(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoEvents.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IKeyPress$_key_press$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (911804394 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.NoEvents.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32637,other32638){
var self__ = this;
var this32637__$1 = this;
return (((!((other32638 == null)))) && ((this32637__$1.constructor === other32638.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32637__$1.drawable,other32638.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32637__$1.__extmap,other32638.__extmap)));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCopy$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardCopy$_clipboard_copy$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardPaste$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IClipboardPaste$_clipboard_paste$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IBubble$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IBubble$_bubble$arity$2 = (function (this$,events){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.NoEvents.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.NoEvents(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.NoEvents.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32635){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32645 = cljs.core.keyword_identical_QMARK_;
var expr__32646 = k__4388__auto__;
if(cljs.core.truth_((pred__32645.cljs$core$IFn$_invoke$arity$2 ? pred__32645.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32646) : pred__32645.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32646)))){
return (new membrane.ui.NoEvents(G__32635,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.NoEvents(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32635),null));
}
}));

(membrane.ui.NoEvents.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.NoEvents(cljs.core.first(childs),null,null,null));
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMove$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMove$_mouse_move$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IHandleEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IHandleEvent$_can_handle_QMARK_$arity$2 = (function (this$,other_event_type){
var self__ = this;
var this$__$1 = this;
return false;
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IHandleEvent$_handle_event$arity$3 = (function (this$,event_type,event_args){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32635){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.NoEvents(self__.drawable,G__32635,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoEvents.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMoveGlobal$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoEvents.prototype.membrane$ui$IMouseMoveGlobal$_mouse_move_global$arity$2 = (function (this$,pos){
var self__ = this;
var this$__$1 = this;
return null;
}));

(membrane.ui.NoEvents.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.NoEvents.cljs$lang$type = true);

(membrane.ui.NoEvents.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/NoEvents",null,(1),null));
}));

(membrane.ui.NoEvents.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/NoEvents");
}));

/**
 * Positional factory function for membrane.ui/NoEvents.
 */
membrane.ui.__GT_NoEvents = (function membrane$ui$__GT_NoEvents(drawable){
return (new membrane.ui.NoEvents(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/NoEvents, taking a map of keywords to field values.
 */
membrane.ui.map__GT_NoEvents = (function membrane$ui$map__GT_NoEvents(G__32639){
var extmap__4419__auto__ = (function (){var G__32648 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__32639,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__32639)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32648);
} else {
return G__32648;
}
})();
return (new membrane.ui.NoEvents(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32639),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.NoEvents,(function (draw){
return (function (this$){
var G__32649 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__32649) : draw.call(null,G__32649));
});
}));
membrane.ui.no_events = (function membrane$ui$no_events(body){
var do_nothing = cljs.core.constantly(null);
return membrane.ui.on.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"mouse-event","mouse-event",189077181),do_nothing,new cljs.core.Keyword(null,"mouse-up","mouse-up",999952135),do_nothing,new cljs.core.Keyword(null,"mouse-down","mouse-down",647107567),do_nothing,new cljs.core.Keyword(null,"drop","drop",364481611),do_nothing,new cljs.core.Keyword(null,"scroll","scroll",971553779),do_nothing,new cljs.core.Keyword(null,"key-event","key-event",-1141143098),do_nothing,new cljs.core.Keyword(null,"key-press","key-press",850740112),do_nothing,new cljs.core.Keyword(null,"mouse-move","mouse-move",-1993061223),do_nothing,new cljs.core.Keyword(null,"mouse-move-global","mouse-move-global",-212584064),do_nothing,new cljs.core.Keyword(null,"clipboard-copy","clipboard-copy",1304333525),do_nothing,new cljs.core.Keyword(null,"clipboard-cut","clipboard-cut",-1344378713),do_nothing,new cljs.core.Keyword(null,"clipboard-paste","clipboard-paste",-1682370330),do_nothing,body], 0));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {membrane.ui.IHasKeyEvent}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.NoKeyEvent = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.NoKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32651,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32655 = k32651;
var G__32655__$1 = (((G__32655 instanceof cljs.core.Keyword))?G__32655.fqn:null);
switch (G__32655__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32651,else__4383__auto__);

}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32656){
var vec__32657 = p__32656;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32657,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32657,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.NoKeyEvent{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32650){
var self__ = this;
var G__32650__$1 = this;
return (new cljs.core.RecordIter((0),G__32650__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.NoKeyEvent(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1115347816 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32652,other32653){
var self__ = this;
var this32652__$1 = this;
return (((!((other32653 == null)))) && ((this32652__$1.constructor === other32653.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32652__$1.drawable,other32653.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32652__$1.__extmap,other32653.__extmap)));
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.NoKeyEvent(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32650){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32660 = cljs.core.keyword_identical_QMARK_;
var expr__32661 = k__4388__auto__;
if(cljs.core.truth_((pred__32660.cljs$core$IFn$_invoke$arity$2 ? pred__32660.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32661) : pred__32660.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32661)))){
return (new membrane.ui.NoKeyEvent(G__32650,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.NoKeyEvent(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32650),null));
}
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.NoKeyEvent(cljs.core.first(childs),null,null,null));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32650){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.NoKeyEvent(self__.drawable,G__32650,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyEvent.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IHasKeyEvent$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyEvent.prototype.membrane$ui$IHasKeyEvent$has_key_event$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return false;
}));

(membrane.ui.NoKeyEvent.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.NoKeyEvent.cljs$lang$type = true);

(membrane.ui.NoKeyEvent.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/NoKeyEvent",null,(1),null));
}));

(membrane.ui.NoKeyEvent.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/NoKeyEvent");
}));

/**
 * Positional factory function for membrane.ui/NoKeyEvent.
 */
membrane.ui.__GT_NoKeyEvent = (function membrane$ui$__GT_NoKeyEvent(drawable){
return (new membrane.ui.NoKeyEvent(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/NoKeyEvent, taking a map of keywords to field values.
 */
membrane.ui.map__GT_NoKeyEvent = (function membrane$ui$map__GT_NoKeyEvent(G__32654){
var extmap__4419__auto__ = (function (){var G__32663 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__32654,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__32654)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32663);
} else {
return G__32663;
}
})();
return (new membrane.ui.NoKeyEvent(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32654),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.NoKeyEvent,(function (draw){
return (function (this$){
var G__32664 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__32664) : draw.call(null,G__32664));
});
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IHasKeyPress}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.NoKeyPress = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.NoKeyPress.prototype.membrane$ui$IHasKeyPress$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IHasKeyPress$has_key_press$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return false;
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32666,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32670 = k32666;
var G__32670__$1 = (((G__32670 instanceof cljs.core.Keyword))?G__32670.fqn:null);
switch (G__32670__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32666,else__4383__auto__);

}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32671){
var vec__32672 = p__32671;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32672,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32672,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.NoKeyPress{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32665){
var self__ = this;
var G__32665__$1 = this;
return (new cljs.core.RecordIter((0),G__32665__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.NoKeyPress(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (533507040 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32667,other32668){
var self__ = this;
var this32667__$1 = this;
return (((!((other32668 == null)))) && ((this32667__$1.constructor === other32668.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32667__$1.drawable,other32668.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32667__$1.__extmap,other32668.__extmap)));
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.NoKeyPress(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32665){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32675 = cljs.core.keyword_identical_QMARK_;
var expr__32676 = k__4388__auto__;
if(cljs.core.truth_((pred__32675.cljs$core$IFn$_invoke$arity$2 ? pred__32675.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32676) : pred__32675.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32676)))){
return (new membrane.ui.NoKeyPress(G__32665,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.NoKeyPress(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32665),null));
}
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.NoKeyPress.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.NoKeyPress.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.NoKeyPress(cljs.core.first(childs),null,null,null));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32665){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.NoKeyPress(self__.drawable,G__32665,self__.__extmap,self__.__hash));
}));

(membrane.ui.NoKeyPress.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.NoKeyPress.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.NoKeyPress.cljs$lang$type = true);

(membrane.ui.NoKeyPress.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/NoKeyPress",null,(1),null));
}));

(membrane.ui.NoKeyPress.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/NoKeyPress");
}));

/**
 * Positional factory function for membrane.ui/NoKeyPress.
 */
membrane.ui.__GT_NoKeyPress = (function membrane$ui$__GT_NoKeyPress(drawable){
return (new membrane.ui.NoKeyPress(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/NoKeyPress, taking a map of keywords to field values.
 */
membrane.ui.map__GT_NoKeyPress = (function membrane$ui$map__GT_NoKeyPress(G__32669){
var extmap__4419__auto__ = (function (){var G__32678 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__32669,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__32669)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32678);
} else {
return G__32678;
}
})();
return (new membrane.ui.NoKeyPress(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32669),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.NoKeyPress,(function (draw){
return (function (this$){
var G__32679 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__32679) : draw.call(null,G__32679));
});
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IMakeNode}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.TryDraw = (function (drawable,error_draw,__meta,__extmap,__hash){
this.drawable = drawable;
this.error_draw = error_draw;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.TryDraw.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.TryDraw.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32681,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32685 = k32681;
var G__32685__$1 = (((G__32685 instanceof cljs.core.Keyword))?G__32685.fqn:null);
switch (G__32685__$1) {
case "drawable":
return self__.drawable;

break;
case "error-draw":
return self__.error_draw;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32681,else__4383__auto__);

}
}));

(membrane.ui.TryDraw.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32686){
var vec__32687 = p__32686;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32687,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32687,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.TryDraw.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.TryDraw{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),self__.error_draw],null))], null),self__.__extmap));
}));

(membrane.ui.TryDraw.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32680){
var self__ = this;
var G__32680__$1 = this;
return (new cljs.core.RecordIter((0),G__32680__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),new cljs.core.Keyword(null,"error-draw","error-draw",-236722733)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
try{return membrane.ui.bounds(self__.drawable);
}catch (e32690){if((e32690 instanceof Object)){
var e = e32690;
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));

return membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1("error"));
} else {
throw e32690;

}
}}));

(membrane.ui.TryDraw.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.TryDraw.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.TryDraw.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.TryDraw.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-629576497 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.TryDraw.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32682,other32683){
var self__ = this;
var this32682__$1 = this;
return (((!((other32683 == null)))) && ((this32682__$1.constructor === other32683.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32682__$1.drawable,other32683.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32682__$1.error_draw,other32683.error_draw)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32682__$1.__extmap,other32683.__extmap)));
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
try{return membrane.ui.origin(self__.drawable);
}catch (e32691){if((e32691 instanceof Object)){
var e = e32691;
return membrane.ui.bounds(membrane.ui.label.cljs$core$IFn$_invoke$arity$1("error"));
} else {
throw e32691;

}
}}));

(membrane.ui.TryDraw.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null,new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.TryDraw.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32680){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32692 = cljs.core.keyword_identical_QMARK_;
var expr__32693 = k__4388__auto__;
if(cljs.core.truth_((pred__32692.cljs$core$IFn$_invoke$arity$2 ? pred__32692.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32693) : pred__32692.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32693)))){
return (new membrane.ui.TryDraw(G__32680,self__.error_draw,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__32692.cljs$core$IFn$_invoke$arity$2 ? pred__32692.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),expr__32693) : pred__32692.call(null,new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),expr__32693)))){
return (new membrane.ui.TryDraw(self__.drawable,G__32680,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32680),null));
}
}
}));

(membrane.ui.TryDraw.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"error-draw","error-draw",-236722733),self__.error_draw,null))], null),self__.__extmap));
}));

(membrane.ui.TryDraw.prototype.membrane$ui$IMakeNode$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.TryDraw.prototype.membrane$ui$IMakeNode$make_node$arity$2 = (function (this$,childs){
var self__ = this;
var this$__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(childs),(1))){
} else {
throw (new Error("Assert failed: (= (count childs) 1)"));
}

return (new membrane.ui.TryDraw(cljs.core.first(childs),self__.error_draw,null,null,null));
}));

(membrane.ui.TryDraw.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32680){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.TryDraw(self__.drawable,self__.error_draw,G__32680,self__.__extmap,self__.__hash));
}));

(membrane.ui.TryDraw.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.TryDraw.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null),new cljs.core.Symbol(null,"error-draw","error-draw",1403808794,null)], null);
}));

(membrane.ui.TryDraw.cljs$lang$type = true);

(membrane.ui.TryDraw.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/TryDraw",null,(1),null));
}));

(membrane.ui.TryDraw.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/TryDraw");
}));

/**
 * Positional factory function for membrane.ui/TryDraw.
 */
membrane.ui.__GT_TryDraw = (function membrane$ui$__GT_TryDraw(drawable,error_draw){
return (new membrane.ui.TryDraw(drawable,error_draw,null,null,null));
});

/**
 * Factory function for membrane.ui/TryDraw, taking a map of keywords to field values.
 */
membrane.ui.map__GT_TryDraw = (function membrane$ui$map__GT_TryDraw(G__32684){
var extmap__4419__auto__ = (function (){var G__32695 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32684,new cljs.core.Keyword(null,"drawable","drawable",1829255936),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"error-draw","error-draw",-236722733)], 0));
if(cljs.core.record_QMARK_(G__32684)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32695);
} else {
return G__32695;
}
})();
return (new membrane.ui.TryDraw(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32684),new cljs.core.Keyword(null,"error-draw","error-draw",-236722733).cljs$core$IFn$_invoke$arity$1(G__32684),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(membrane.ui.default_draw_impls,cljs.core.assoc,membrane.ui.TryDraw,(function (draw){
return (function (this$){
try{var G__32698 = new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(this$);
return (draw.cljs$core$IFn$_invoke$arity$1 ? draw.cljs$core$IFn$_invoke$arity$1(G__32698) : draw.call(null,G__32698));
}catch (e32696){if((e32696 instanceof Object)){
var e = e32696;
var fexpr__32697 = new cljs.core.Keyword(null,"error-draw","error-draw",-236722733).cljs$core$IFn$_invoke$arity$1(this$);
return (fexpr__32697.cljs$core$IFn$_invoke$arity$2 ? fexpr__32697.cljs$core$IFn$_invoke$arity$2(draw,e) : fexpr__32697.call(null,draw,e));
} else {
throw e32696;

}
}});
}));
membrane.ui.try_draw = (function membrane$ui$try_draw(body,error_draw){
return (new membrane.ui.TryDraw(body,error_draw,null,null,null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {membrane.ui.IOrigin}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {membrane.ui.IChildren}
 * @implements {membrane.ui.IBounds}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
membrane.ui.Cached = (function (drawable,__meta,__extmap,__hash){
this.drawable = drawable;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(membrane.ui.Cached.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(membrane.ui.Cached.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k32700,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__32704 = k32700;
var G__32704__$1 = (((G__32704 instanceof cljs.core.Keyword))?G__32704.fqn:null);
switch (G__32704__$1) {
case "drawable":
return self__.drawable;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32700,else__4383__auto__);

}
}));

(membrane.ui.Cached.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__32705){
var vec__32706 = p__32705;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32706,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32706,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(membrane.ui.Cached.prototype.membrane$ui$IChildren$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Cached.prototype.membrane$ui$IChildren$_children$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.drawable], null);
}));

(membrane.ui.Cached.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#membrane.ui.Cached{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable],null))], null),self__.__extmap));
}));

(membrane.ui.Cached.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32699){
var self__ = this;
var G__32699__$1 = this;
return (new cljs.core.RecordIter((0),G__32699__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"drawable","drawable",1829255936)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(membrane.ui.Cached.prototype.membrane$ui$IBounds$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Cached.prototype.membrane$ui$IBounds$_bounds$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return membrane.ui.bounds(self__.drawable);
}));

(membrane.ui.Cached.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(membrane.ui.Cached.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new membrane.ui.Cached(self__.drawable,self__.__meta,self__.__extmap,self__.__hash));
}));

(membrane.ui.Cached.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
}));

(membrane.ui.Cached.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-59962078 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(membrane.ui.Cached.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32701,other32702){
var self__ = this;
var this32701__$1 = this;
return (((!((other32702 == null)))) && ((this32701__$1.constructor === other32702.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32701__$1.drawable,other32702.drawable)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32701__$1.__extmap,other32702.__extmap)));
}));

(membrane.ui.Cached.prototype.membrane$ui$IOrigin$ = cljs.core.PROTOCOL_SENTINEL);

(membrane.ui.Cached.prototype.membrane$ui$IOrigin$_origin$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return membrane.ui.origin(self__.drawable);
}));

(membrane.ui.Cached.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"drawable","drawable",1829255936),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new membrane.ui.Cached(self__.drawable,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(membrane.ui.Cached.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__32699){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__32709 = cljs.core.keyword_identical_QMARK_;
var expr__32710 = k__4388__auto__;
if(cljs.core.truth_((pred__32709.cljs$core$IFn$_invoke$arity$2 ? pred__32709.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32710) : pred__32709.call(null,new cljs.core.Keyword(null,"drawable","drawable",1829255936),expr__32710)))){
return (new membrane.ui.Cached(G__32699,self__.__meta,self__.__extmap,null));
} else {
return (new membrane.ui.Cached(self__.drawable,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__32699),null));
}
}));

(membrane.ui.Cached.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"drawable","drawable",1829255936),self__.drawable,null))], null),self__.__extmap));
}));

(membrane.ui.Cached.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__32699){
var self__ = this;
var this__4379__auto____$1 = this;
return (new membrane.ui.Cached(self__.drawable,G__32699,self__.__extmap,self__.__hash));
}));

(membrane.ui.Cached.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(membrane.ui.Cached.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"drawable","drawable",-825179833,null)], null);
}));

(membrane.ui.Cached.cljs$lang$type = true);

(membrane.ui.Cached.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"membrane.ui/Cached",null,(1),null));
}));

(membrane.ui.Cached.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"membrane.ui/Cached");
}));

/**
 * Positional factory function for membrane.ui/Cached.
 */
membrane.ui.__GT_Cached = (function membrane$ui$__GT_Cached(drawable){
return (new membrane.ui.Cached(drawable,null,null,null));
});

/**
 * Factory function for membrane.ui/Cached, taking a map of keywords to field values.
 */
membrane.ui.map__GT_Cached = (function membrane$ui$map__GT_Cached(G__32703){
var extmap__4419__auto__ = (function (){var G__32712 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__32703,new cljs.core.Keyword(null,"drawable","drawable",1829255936));
if(cljs.core.record_QMARK_(G__32703)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32712);
} else {
return G__32712;
}
})();
return (new membrane.ui.Cached(new cljs.core.Keyword(null,"drawable","drawable",1829255936).cljs$core$IFn$_invoke$arity$1(G__32703),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

membrane.ui.index_for_position_STAR_ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
membrane.ui.index_for_position = (function membrane$ui$index_for_position(font,text,x,y){
var f = cljs.core.deref(membrane.ui.index_for_position_STAR_);
if(cljs.core.truth_(f)){
} else {
throw (new Error(["Assert failed: ","index-for-position should be replaced by implementation","\n","f"].join('')));
}

return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(font,text,x,y) : f.call(null,font,text,x,y));
});
membrane.ui.copy_to_clipboard = (function membrane$ui$copy_to_clipboard(s){
return null;
});

//# sourceMappingURL=membrane.ui.js.map
