(ns com.phronemophobic.env
  (:require [clojure.edn :as edn]
            [clojure.java.io :as io]
            [clojure.string :as str]))

(def ^:private env
  (delay 
    (let [f (io/file "secrets.edn")]
      (when (.exists f)
        (with-open [rdr (io/reader f)
                    rdr (java.io.PushbackReader. rdr)]
         (edn/read rdr))))))

(defn ^:private normalize-env-key [k]
  (str/replace (str/upper-case
                (if-let [ns (namespace k)]
                  (str ns "_" (name k))
                  (name k)))
               #"[^A-Z0-9_]"
               "_"))

(defn get-env
  ([k not-found]
   (let [normalized-k (normalize-env-key k)]
     (if-let [v (System/getProperty normalized-k)]
       v
       (if-let [v (System/getenv normalized-k)]
         v
         (if-let [v (get @env k)]
           v
           not-found)))))
  ([k]
   (let [normalized-k (normalize-env-key k)]
     (if-let [v (System/getProperty normalized-k)]
       v
       (if-let [v (System/getenv normalized-k)]
         v
         (if-let [v (get @env k)]
           v
           (throw (ex-info "Missing env key"
                           {:key k}))))))))

