/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefCallback;
import com.phronemophobic.cljcef.CefRequest;
import com.phronemophobic.cljcef.CefResourceReadCallback;
import com.phronemophobic.cljcef.CefResourceSkipCallback;
import com.phronemophobic.cljcef.CefResponse;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefResourceHandler
extends Structure {
    public CefBaseRefCounted base;
    public OpenFunc open;
    public ProcessRequestFunc process_request;
    public GetResponseHeadersFunc get_response_headers;
    public SkipFunc skip;
    public ReadFunc read;
    public ReadResponseFunc read_response;
    public CancelFunc cancel;

    public CefResourceHandler() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "open", "process_request", "get_response_headers", "skip", "read", "read_response", "cancel");
    }

    public int open(CefRequest cefRequest, Pointer pointer, CefCallback cefCallback) {
        return this.open.open(this, cefRequest, pointer, cefCallback);
    }

    public int processRequest(CefRequest cefRequest, CefCallback cefCallback) {
        return this.process_request.process_request(this, cefRequest, cefCallback);
    }

    public void getResponseHeaders(CefResponse cefResponse, Pointer pointer, String string) {
        this.get_response_headers.get_response_headers(this, cefResponse, pointer, CljCefLib.toCefString(string));
    }

    public int skip(long l, Pointer pointer, CefResourceSkipCallback cefResourceSkipCallback) {
        return this.skip.skip(this, l, pointer, cefResourceSkipCallback);
    }

    public int read(Pointer pointer, int n, Pointer pointer2, CefResourceReadCallback cefResourceReadCallback) {
        return this.read.read(this, pointer, n, pointer2, cefResourceReadCallback);
    }

    public int readResponse(Pointer pointer, int n, Pointer pointer2, CefCallback cefCallback) {
        return this.read_response.read_response(this, pointer, n, pointer2, cefCallback);
    }

    public void cancel() {
        this.cancel.cancel(this);
    }

    public static interface OpenFunc
    extends Callback {
        public int open(CefResourceHandler var1, CefRequest var2, Pointer var3, CefCallback var4);
    }

    public static interface ProcessRequestFunc
    extends Callback {
        public int process_request(CefResourceHandler var1, CefRequest var2, CefCallback var3);
    }

    public static interface GetResponseHeadersFunc
    extends Callback {
        public void get_response_headers(CefResourceHandler var1, CefResponse var2, Pointer var3, CefStringUtf16 var4);
    }

    public static interface SkipFunc
    extends Callback {
        public int skip(CefResourceHandler var1, long var2, Pointer var4, CefResourceSkipCallback var5);
    }

    public static interface ReadFunc
    extends Callback {
        public int read(CefResourceHandler var1, Pointer var2, int var3, Pointer var4, CefResourceReadCallback var5);
    }

    public static interface ReadResponseFunc
    extends Callback {
        public int read_response(CefResourceHandler var1, Pointer var2, int var3, Pointer var4, CefCallback var5);
    }

    public static interface CancelFunc
    extends Callback {
        public void cancel(CefResourceHandler var1);
    }
}

