/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefAccessibilityHandler;
import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefBrowser;
import com.phronemophobic.cljcef.CefDragData;
import com.phronemophobic.cljcef.CefRange;
import com.phronemophobic.cljcef.CefRect;
import com.phronemophobic.cljcef.CefScreenInfo;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.phronemophobic.cljcef.SizeT;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefRenderHandler
extends Structure {
    public CefBaseRefCounted base;
    public GetAccessibilityHandlerFunc get_accessibility_handler;
    public GetRootScreenRectFunc get_root_screen_rect;
    public GetViewRectFunc get_view_rect;
    public GetScreenPointFunc get_screen_point;
    public GetScreenInfoFunc get_screen_info;
    public OnPopupShowFunc on_popup_show;
    public OnPopupSizeFunc on_popup_size;
    public OnPaintFunc on_paint;
    public OnAcceleratedPaintFunc on_accelerated_paint;
    public StartDraggingFunc start_dragging;
    public UpdateDragCursorFunc update_drag_cursor;
    public OnScrollOffsetChangedFunc on_scroll_offset_changed;
    public OnImeCompositionRangeChangedFunc on_ime_composition_range_changed;
    public OnTextSelectionChangedFunc on_text_selection_changed;
    public OnVirtualKeyboardRequestedFunc on_virtual_keyboard_requested;

    public CefRenderHandler() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "get_accessibility_handler", "get_root_screen_rect", "get_view_rect", "get_screen_point", "get_screen_info", "on_popup_show", "on_popup_size", "on_paint", "on_accelerated_paint", "start_dragging", "update_drag_cursor", "on_scroll_offset_changed", "on_ime_composition_range_changed", "on_text_selection_changed", "on_virtual_keyboard_requested");
    }

    public CefAccessibilityHandler getAccessibilityHandler() {
        return this.get_accessibility_handler.get_accessibility_handler(this);
    }

    public int getRootScreenRect(CefBrowser cefBrowser, CefRect cefRect) {
        return this.get_root_screen_rect.get_root_screen_rect(this, cefBrowser, cefRect);
    }

    public void getViewRect(CefBrowser cefBrowser, CefRect cefRect) {
        this.get_view_rect.get_view_rect(this, cefBrowser, cefRect);
    }

    public int getScreenPoint(CefBrowser cefBrowser, int n, int n2, Pointer pointer, Pointer pointer2) {
        return this.get_screen_point.get_screen_point(this, cefBrowser, n, n2, pointer, pointer2);
    }

    public int getScreenInfo(CefBrowser cefBrowser, CefScreenInfo cefScreenInfo) {
        return this.get_screen_info.get_screen_info(this, cefBrowser, cefScreenInfo);
    }

    public void onPopupShow(CefBrowser cefBrowser, int n) {
        this.on_popup_show.on_popup_show(this, cefBrowser, n);
    }

    public void onPopupSize(CefBrowser cefBrowser, CefRect cefRect) {
        this.on_popup_size.on_popup_size(this, cefBrowser, cefRect);
    }

    public void onPaint(CefBrowser cefBrowser, int n, SizeT sizeT, CefRect cefRect, Pointer pointer, int n2, int n3) {
        this.on_paint.on_paint(this, cefBrowser, n, sizeT, cefRect, pointer, n2, n3);
    }

    public void onAcceleratedPaint(CefBrowser cefBrowser, int n, SizeT sizeT, CefRect cefRect, Pointer pointer) {
        this.on_accelerated_paint.on_accelerated_paint(this, cefBrowser, n, sizeT, cefRect, pointer);
    }

    public int startDragging(CefBrowser cefBrowser, CefDragData cefDragData, int n, int n2, int n3) {
        return this.start_dragging.start_dragging(this, cefBrowser, cefDragData, n, n2, n3);
    }

    public void updateDragCursor(CefBrowser cefBrowser, int n) {
        this.update_drag_cursor.update_drag_cursor(this, cefBrowser, n);
    }

    public void onScrollOffsetChanged(CefBrowser cefBrowser, double d, double d2) {
        this.on_scroll_offset_changed.on_scroll_offset_changed(this, cefBrowser, d, d2);
    }

    public void onImeCompositionRangeChanged(CefBrowser cefBrowser, CefRange cefRange, SizeT sizeT, CefRect cefRect) {
        this.on_ime_composition_range_changed.on_ime_composition_range_changed(this, cefBrowser, cefRange, sizeT, cefRect);
    }

    public void onTextSelectionChanged(CefBrowser cefBrowser, String string, CefRange cefRange) {
        this.on_text_selection_changed.on_text_selection_changed(this, cefBrowser, CljCefLib.toCefString(string), cefRange);
    }

    public void onVirtualKeyboardRequested(CefBrowser cefBrowser, int n) {
        this.on_virtual_keyboard_requested.on_virtual_keyboard_requested(this, cefBrowser, n);
    }

    public static interface GetAccessibilityHandlerFunc
    extends Callback {
        public CefAccessibilityHandler get_accessibility_handler(CefRenderHandler var1);
    }

    public static interface GetRootScreenRectFunc
    extends Callback {
        public int get_root_screen_rect(CefRenderHandler var1, CefBrowser var2, CefRect var3);
    }

    public static interface GetViewRectFunc
    extends Callback {
        public void get_view_rect(CefRenderHandler var1, CefBrowser var2, CefRect var3);
    }

    public static interface GetScreenPointFunc
    extends Callback {
        public int get_screen_point(CefRenderHandler var1, CefBrowser var2, int var3, int var4, Pointer var5, Pointer var6);
    }

    public static interface GetScreenInfoFunc
    extends Callback {
        public int get_screen_info(CefRenderHandler var1, CefBrowser var2, CefScreenInfo var3);
    }

    public static interface OnPopupShowFunc
    extends Callback {
        public void on_popup_show(CefRenderHandler var1, CefBrowser var2, int var3);
    }

    public static interface OnPopupSizeFunc
    extends Callback {
        public void on_popup_size(CefRenderHandler var1, CefBrowser var2, CefRect var3);
    }

    public static interface OnPaintFunc
    extends Callback {
        public void on_paint(CefRenderHandler var1, CefBrowser var2, int var3, SizeT var4, CefRect var5, Pointer var6, int var7, int var8);
    }

    public static interface OnAcceleratedPaintFunc
    extends Callback {
        public void on_accelerated_paint(CefRenderHandler var1, CefBrowser var2, int var3, SizeT var4, CefRect var5, Pointer var6);
    }

    public static interface StartDraggingFunc
    extends Callback {
        public int start_dragging(CefRenderHandler var1, CefBrowser var2, CefDragData var3, int var4, int var5, int var6);
    }

    public static interface UpdateDragCursorFunc
    extends Callback {
        public void update_drag_cursor(CefRenderHandler var1, CefBrowser var2, int var3);
    }

    public static interface OnScrollOffsetChangedFunc
    extends Callback {
        public void on_scroll_offset_changed(CefRenderHandler var1, CefBrowser var2, double var3, double var5);
    }

    public static interface OnImeCompositionRangeChangedFunc
    extends Callback {
        public void on_ime_composition_range_changed(CefRenderHandler var1, CefBrowser var2, CefRange var3, SizeT var4, CefRect var5);
    }

    public static interface OnTextSelectionChangedFunc
    extends Callback {
        public void on_text_selection_changed(CefRenderHandler var1, CefBrowser var2, CefStringUtf16 var3, CefRange var4);
    }

    public static interface OnVirtualKeyboardRequestedFunc
    extends Callback {
        public void on_virtual_keyboard_requested(CefRenderHandler var1, CefBrowser var2, int var3);
    }
}

