/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefImage;
import com.phronemophobic.cljcef.CefPoint;
import com.phronemophobic.cljcef.CefStreamWriter;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.phronemophobic.cljcef.SizeT;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefDragData
extends Structure {
    public CefBaseRefCounted base;
    public CloneFunc clone;
    public IsReadOnlyFunc is_read_only;
    public IsLinkFunc is_link;
    public IsFragmentFunc is_fragment;
    public IsFileFunc is_file;
    public GetLinkUrlFunc get_link_url;
    public GetLinkTitleFunc get_link_title;
    public GetLinkMetadataFunc get_link_metadata;
    public GetFragmentTextFunc get_fragment_text;
    public GetFragmentHtmlFunc get_fragment_html;
    public GetFragmentBaseUrlFunc get_fragment_base_url;
    public GetFileNameFunc get_file_name;
    public GetFileContentsFunc get_file_contents;
    public GetFileNamesFunc get_file_names;
    public SetLinkUrlFunc set_link_url;
    public SetLinkTitleFunc set_link_title;
    public SetLinkMetadataFunc set_link_metadata;
    public SetFragmentTextFunc set_fragment_text;
    public SetFragmentHtmlFunc set_fragment_html;
    public SetFragmentBaseUrlFunc set_fragment_base_url;
    public ResetFileContentsFunc reset_file_contents;
    public AddFileFunc add_file;
    public GetImageFunc get_image;
    public GetImageHotspotFunc get_image_hotspot;
    public HasImageFunc has_image;

    public CefDragData() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "clone", "is_read_only", "is_link", "is_fragment", "is_file", "get_link_url", "get_link_title", "get_link_metadata", "get_fragment_text", "get_fragment_html", "get_fragment_base_url", "get_file_name", "get_file_contents", "get_file_names", "set_link_url", "set_link_title", "set_link_metadata", "set_fragment_text", "set_fragment_html", "set_fragment_base_url", "reset_file_contents", "add_file", "get_image", "get_image_hotspot", "has_image");
    }

    public CefDragData clone() {
        return this.clone.clone(this);
    }

    public int isReadOnly() {
        return this.is_read_only.is_read_only(this);
    }

    public int isLink() {
        return this.is_link.is_link(this);
    }

    public int isFragment() {
        return this.is_fragment.is_fragment(this);
    }

    public int isFile() {
        return this.is_file.is_file(this);
    }

    public CefStringUtf16 getLinkUrl() {
        return this.get_link_url.get_link_url(this);
    }

    public CefStringUtf16 getLinkTitle() {
        return this.get_link_title.get_link_title(this);
    }

    public CefStringUtf16 getLinkMetadata() {
        return this.get_link_metadata.get_link_metadata(this);
    }

    public CefStringUtf16 getFragmentText() {
        return this.get_fragment_text.get_fragment_text(this);
    }

    public CefStringUtf16 getFragmentHtml() {
        return this.get_fragment_html.get_fragment_html(this);
    }

    public CefStringUtf16 getFragmentBaseUrl() {
        return this.get_fragment_base_url.get_fragment_base_url(this);
    }

    public CefStringUtf16 getFileName() {
        return this.get_file_name.get_file_name(this);
    }

    public SizeT getFileContents(CefStreamWriter cefStreamWriter) {
        return this.get_file_contents.get_file_contents(this, cefStreamWriter);
    }

    public int getFileNames(Pointer pointer) {
        return this.get_file_names.get_file_names(this, pointer);
    }

    public void setLinkUrl(String string) {
        this.set_link_url.set_link_url(this, CljCefLib.toCefString(string));
    }

    public void setLinkTitle(String string) {
        this.set_link_title.set_link_title(this, CljCefLib.toCefString(string));
    }

    public void setLinkMetadata(String string) {
        this.set_link_metadata.set_link_metadata(this, CljCefLib.toCefString(string));
    }

    public void setFragmentText(String string) {
        this.set_fragment_text.set_fragment_text(this, CljCefLib.toCefString(string));
    }

    public void setFragmentHtml(String string) {
        this.set_fragment_html.set_fragment_html(this, CljCefLib.toCefString(string));
    }

    public void setFragmentBaseUrl(String string) {
        this.set_fragment_base_url.set_fragment_base_url(this, CljCefLib.toCefString(string));
    }

    public void resetFileContents() {
        this.reset_file_contents.reset_file_contents(this);
    }

    public void addFile(String string, String string2) {
        this.add_file.add_file(this, CljCefLib.toCefString(string), CljCefLib.toCefString(string2));
    }

    public CefImage getImage() {
        return this.get_image.get_image(this);
    }

    public CefPoint getImageHotspot() {
        return this.get_image_hotspot.get_image_hotspot(this);
    }

    public int hasImage() {
        return this.has_image.has_image(this);
    }

    public static interface CloneFunc
    extends Callback {
        public CefDragData clone(CefDragData var1);
    }

    public static interface IsReadOnlyFunc
    extends Callback {
        public int is_read_only(CefDragData var1);
    }

    public static interface IsLinkFunc
    extends Callback {
        public int is_link(CefDragData var1);
    }

    public static interface IsFragmentFunc
    extends Callback {
        public int is_fragment(CefDragData var1);
    }

    public static interface IsFileFunc
    extends Callback {
        public int is_file(CefDragData var1);
    }

    public static interface GetLinkUrlFunc
    extends Callback {
        public CefStringUtf16 get_link_url(CefDragData var1);
    }

    public static interface GetLinkTitleFunc
    extends Callback {
        public CefStringUtf16 get_link_title(CefDragData var1);
    }

    public static interface GetLinkMetadataFunc
    extends Callback {
        public CefStringUtf16 get_link_metadata(CefDragData var1);
    }

    public static interface GetFragmentTextFunc
    extends Callback {
        public CefStringUtf16 get_fragment_text(CefDragData var1);
    }

    public static interface GetFragmentHtmlFunc
    extends Callback {
        public CefStringUtf16 get_fragment_html(CefDragData var1);
    }

    public static interface GetFragmentBaseUrlFunc
    extends Callback {
        public CefStringUtf16 get_fragment_base_url(CefDragData var1);
    }

    public static interface GetFileNameFunc
    extends Callback {
        public CefStringUtf16 get_file_name(CefDragData var1);
    }

    public static interface GetFileContentsFunc
    extends Callback {
        public SizeT get_file_contents(CefDragData var1, CefStreamWriter var2);
    }

    public static interface GetFileNamesFunc
    extends Callback {
        public int get_file_names(CefDragData var1, Pointer var2);
    }

    public static interface SetLinkUrlFunc
    extends Callback {
        public void set_link_url(CefDragData var1, CefStringUtf16 var2);
    }

    public static interface SetLinkTitleFunc
    extends Callback {
        public void set_link_title(CefDragData var1, CefStringUtf16 var2);
    }

    public static interface SetLinkMetadataFunc
    extends Callback {
        public void set_link_metadata(CefDragData var1, CefStringUtf16 var2);
    }

    public static interface SetFragmentTextFunc
    extends Callback {
        public void set_fragment_text(CefDragData var1, CefStringUtf16 var2);
    }

    public static interface SetFragmentHtmlFunc
    extends Callback {
        public void set_fragment_html(CefDragData var1, CefStringUtf16 var2);
    }

    public static interface SetFragmentBaseUrlFunc
    extends Callback {
        public void set_fragment_base_url(CefDragData var1, CefStringUtf16 var2);
    }

    public static interface ResetFileContentsFunc
    extends Callback {
        public void reset_file_contents(CefDragData var1);
    }

    public static interface AddFileFunc
    extends Callback {
        public void add_file(CefDragData var1, CefStringUtf16 var2, CefStringUtf16 var3);
    }

    public static interface GetImageFunc
    extends Callback {
        public CefImage get_image(CefDragData var1);
    }

    public static interface GetImageHotspotFunc
    extends Callback {
        public CefPoint get_image_hotspot(CefDragData var1);
    }

    public static interface HasImageFunc
    extends Callback {
        public int has_image(CefDragData var1);
    }
}

