/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefBrowser;
import com.phronemophobic.cljcef.CefCursorInfo;
import com.phronemophobic.cljcef.CefFrame;
import com.phronemophobic.cljcef.CefSize;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefDisplayHandler
extends Structure {
    public CefBaseRefCounted base;
    public OnAddressChangeFunc on_address_change;
    public OnTitleChangeFunc on_title_change;
    public OnFaviconUrlchangeFunc on_favicon_urlchange;
    public OnFullscreenModeChangeFunc on_fullscreen_mode_change;
    public OnTooltipFunc on_tooltip;
    public OnStatusMessageFunc on_status_message;
    public OnConsoleMessageFunc on_console_message;
    public OnAutoResizeFunc on_auto_resize;
    public OnLoadingProgressChangeFunc on_loading_progress_change;
    public OnCursorChangeFunc on_cursor_change;

    public CefDisplayHandler() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "on_address_change", "on_title_change", "on_favicon_urlchange", "on_fullscreen_mode_change", "on_tooltip", "on_status_message", "on_console_message", "on_auto_resize", "on_loading_progress_change", "on_cursor_change");
    }

    public void onAddressChange(CefBrowser cefBrowser, CefFrame cefFrame, String string) {
        this.on_address_change.on_address_change(this, cefBrowser, cefFrame, CljCefLib.toCefString(string));
    }

    public void onTitleChange(CefBrowser cefBrowser, String string) {
        this.on_title_change.on_title_change(this, cefBrowser, CljCefLib.toCefString(string));
    }

    public void onFaviconUrlchange(CefBrowser cefBrowser, Pointer pointer) {
        this.on_favicon_urlchange.on_favicon_urlchange(this, cefBrowser, pointer);
    }

    public void onFullscreenModeChange(CefBrowser cefBrowser, int n) {
        this.on_fullscreen_mode_change.on_fullscreen_mode_change(this, cefBrowser, n);
    }

    public int onTooltip(CefBrowser cefBrowser, String string) {
        return this.on_tooltip.on_tooltip(this, cefBrowser, CljCefLib.toCefString(string));
    }

    public void onStatusMessage(CefBrowser cefBrowser, String string) {
        this.on_status_message.on_status_message(this, cefBrowser, CljCefLib.toCefString(string));
    }

    public int onConsoleMessage(CefBrowser cefBrowser, int n, String string, String string2, int n2) {
        return this.on_console_message.on_console_message(this, cefBrowser, n, CljCefLib.toCefString(string), CljCefLib.toCefString(string2), n2);
    }

    public int onAutoResize(CefBrowser cefBrowser, CefSize cefSize) {
        return this.on_auto_resize.on_auto_resize(this, cefBrowser, cefSize);
    }

    public void onLoadingProgressChange(CefBrowser cefBrowser, double d) {
        this.on_loading_progress_change.on_loading_progress_change(this, cefBrowser, d);
    }

    public int onCursorChange(CefBrowser cefBrowser, Pointer pointer, int n, CefCursorInfo cefCursorInfo) {
        return this.on_cursor_change.on_cursor_change(this, cefBrowser, pointer, n, cefCursorInfo);
    }

    public static interface OnCursorChangeFunc
    extends Callback {
        public int on_cursor_change(CefDisplayHandler var1, CefBrowser var2, Pointer var3, int var4, CefCursorInfo var5);
    }

    public static interface OnLoadingProgressChangeFunc
    extends Callback {
        public void on_loading_progress_change(CefDisplayHandler var1, CefBrowser var2, double var3);
    }

    public static interface OnAutoResizeFunc
    extends Callback {
        public int on_auto_resize(CefDisplayHandler var1, CefBrowser var2, CefSize var3);
    }

    public static interface OnConsoleMessageFunc
    extends Callback {
        public int on_console_message(CefDisplayHandler var1, CefBrowser var2, int var3, CefStringUtf16 var4, CefStringUtf16 var5, int var6);
    }

    public static interface OnStatusMessageFunc
    extends Callback {
        public void on_status_message(CefDisplayHandler var1, CefBrowser var2, CefStringUtf16 var3);
    }

    public static interface OnTooltipFunc
    extends Callback {
        public int on_tooltip(CefDisplayHandler var1, CefBrowser var2, CefStringUtf16 var3);
    }

    public static interface OnFullscreenModeChangeFunc
    extends Callback {
        public void on_fullscreen_mode_change(CefDisplayHandler var1, CefBrowser var2, int var3);
    }

    public static interface OnFaviconUrlchangeFunc
    extends Callback {
        public void on_favicon_urlchange(CefDisplayHandler var1, CefBrowser var2, Pointer var3);
    }

    public static interface OnTitleChangeFunc
    extends Callback {
        public void on_title_change(CefDisplayHandler var1, CefBrowser var2, CefStringUtf16 var3);
    }

    public static interface OnAddressChangeFunc
    extends Callback {
        public void on_address_change(CefDisplayHandler var1, CefBrowser var2, CefFrame var3, CefStringUtf16 var4);
    }
}

