/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefBinaryValue;
import com.phronemophobic.cljcef.CefDictionaryValue;
import com.phronemophobic.cljcef.CefListValue;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.sun.jna.Callback;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefValue
extends Structure {
    public CefBaseRefCounted base;
    public IsValidFunc is_valid;
    public IsOwnedFunc is_owned;
    public IsReadOnlyFunc is_read_only;
    public IsSameFunc is_same;
    public IsEqualFunc is_equal;
    public CopyFunc copy;
    public GetTypeFunc get_type;
    public GetBoolFunc get_bool;
    public GetIntFunc get_int;
    public GetDoubleFunc get_double;
    public GetStringFunc get_string;
    public GetBinaryFunc get_binary;
    public GetDictionaryFunc get_dictionary;
    public GetListFunc get_list;
    public SetNullFunc set_null;
    public SetBoolFunc set_bool;
    public SetIntFunc set_int;
    public SetDoubleFunc set_double;
    public SetStringFunc set_string;
    public SetBinaryFunc set_binary;
    public SetDictionaryFunc set_dictionary;
    public SetListFunc set_list;

    public CefValue() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "is_valid", "is_owned", "is_read_only", "is_same", "is_equal", "copy", "get_type", "get_bool", "get_int", "get_double", "get_string", "get_binary", "get_dictionary", "get_list", "set_null", "set_bool", "set_int", "set_double", "set_string", "set_binary", "set_dictionary", "set_list");
    }

    public int isValid() {
        return this.is_valid.is_valid(this);
    }

    public int isOwned() {
        return this.is_owned.is_owned(this);
    }

    public int isReadOnly() {
        return this.is_read_only.is_read_only(this);
    }

    public int isSame(CefValue cefValue) {
        return this.is_same.is_same(this, cefValue);
    }

    public int isEqual(CefValue cefValue) {
        return this.is_equal.is_equal(this, cefValue);
    }

    public CefValue copy() {
        return this.copy.copy(this);
    }

    public int getType() {
        return this.get_type.get_type(this);
    }

    public int getBool() {
        return this.get_bool.get_bool(this);
    }

    public int getInt() {
        return this.get_int.get_int(this);
    }

    public double getDouble() {
        return this.get_double.get_double(this);
    }

    public CefStringUtf16 getString() {
        return this.get_string.get_string(this);
    }

    public CefBinaryValue getBinary() {
        return this.get_binary.get_binary(this);
    }

    public CefDictionaryValue getDictionary() {
        return this.get_dictionary.get_dictionary(this);
    }

    public CefListValue getList() {
        return this.get_list.get_list(this);
    }

    public int setNull() {
        return this.set_null.set_null(this);
    }

    public int setBool(int n) {
        return this.set_bool.set_bool(this, n);
    }

    public int setInt(int n) {
        return this.set_int.set_int(this, n);
    }

    public int setDouble(double d) {
        return this.set_double.set_double(this, d);
    }

    public int setString(String string) {
        return this.set_string.set_string(this, CljCefLib.toCefString(string));
    }

    public int setBinary(CefBinaryValue cefBinaryValue) {
        return this.set_binary.set_binary(this, cefBinaryValue);
    }

    public int setDictionary(CefDictionaryValue cefDictionaryValue) {
        return this.set_dictionary.set_dictionary(this, cefDictionaryValue);
    }

    public int setList(CefListValue cefListValue) {
        return this.set_list.set_list(this, cefListValue);
    }

    public static interface IsValidFunc
    extends Callback {
        public int is_valid(CefValue var1);
    }

    public static interface IsOwnedFunc
    extends Callback {
        public int is_owned(CefValue var1);
    }

    public static interface IsReadOnlyFunc
    extends Callback {
        public int is_read_only(CefValue var1);
    }

    public static interface IsSameFunc
    extends Callback {
        public int is_same(CefValue var1, CefValue var2);
    }

    public static interface IsEqualFunc
    extends Callback {
        public int is_equal(CefValue var1, CefValue var2);
    }

    public static interface CopyFunc
    extends Callback {
        public CefValue copy(CefValue var1);
    }

    public static interface GetTypeFunc
    extends Callback {
        public int get_type(CefValue var1);
    }

    public static interface GetBoolFunc
    extends Callback {
        public int get_bool(CefValue var1);
    }

    public static interface GetIntFunc
    extends Callback {
        public int get_int(CefValue var1);
    }

    public static interface GetDoubleFunc
    extends Callback {
        public double get_double(CefValue var1);
    }

    public static interface GetStringFunc
    extends Callback {
        public CefStringUtf16 get_string(CefValue var1);
    }

    public static interface GetBinaryFunc
    extends Callback {
        public CefBinaryValue get_binary(CefValue var1);
    }

    public static interface GetDictionaryFunc
    extends Callback {
        public CefDictionaryValue get_dictionary(CefValue var1);
    }

    public static interface GetListFunc
    extends Callback {
        public CefListValue get_list(CefValue var1);
    }

    public static interface SetNullFunc
    extends Callback {
        public int set_null(CefValue var1);
    }

    public static interface SetBoolFunc
    extends Callback {
        public int set_bool(CefValue var1, int var2);
    }

    public static interface SetIntFunc
    extends Callback {
        public int set_int(CefValue var1, int var2);
    }

    public static interface SetDoubleFunc
    extends Callback {
        public int set_double(CefValue var1, double var2);
    }

    public static interface SetStringFunc
    extends Callback {
        public int set_string(CefValue var1, CefStringUtf16 var2);
    }

    public static interface SetBinaryFunc
    extends Callback {
        public int set_binary(CefValue var1, CefBinaryValue var2);
    }

    public static interface SetDictionaryFunc
    extends Callback {
        public int set_dictionary(CefValue var1, CefDictionaryValue var2);
    }

    public static interface SetListFunc
    extends Callback {
        public int set_list(CefValue var1, CefListValue var2);
    }
}

