/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefMenuModel;
import com.phronemophobic.cljcef.CefPoint;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.sun.jna.Callback;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefMenuModelDelegate
extends Structure {
    public CefBaseRefCounted base;
    public ExecuteCommandFunc execute_command;
    public MouseOutsideMenuFunc mouse_outside_menu;
    public UnhandledOpenSubmenuFunc unhandled_open_submenu;
    public UnhandledCloseSubmenuFunc unhandled_close_submenu;
    public MenuWillShowFunc menu_will_show;
    public MenuClosedFunc menu_closed;
    public FormatLabelFunc format_label;

    public CefMenuModelDelegate() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "execute_command", "mouse_outside_menu", "unhandled_open_submenu", "unhandled_close_submenu", "menu_will_show", "menu_closed", "format_label");
    }

    public void executeCommand(CefMenuModel cefMenuModel, int n, int n2) {
        this.execute_command.execute_command(this, cefMenuModel, n, n2);
    }

    public void mouseOutsideMenu(CefMenuModel cefMenuModel, CefPoint cefPoint) {
        this.mouse_outside_menu.mouse_outside_menu(this, cefMenuModel, cefPoint);
    }

    public void unhandledOpenSubmenu(CefMenuModel cefMenuModel, int n) {
        this.unhandled_open_submenu.unhandled_open_submenu(this, cefMenuModel, n);
    }

    public void unhandledCloseSubmenu(CefMenuModel cefMenuModel, int n) {
        this.unhandled_close_submenu.unhandled_close_submenu(this, cefMenuModel, n);
    }

    public void menuWillShow(CefMenuModel cefMenuModel) {
        this.menu_will_show.menu_will_show(this, cefMenuModel);
    }

    public void menuClosed(CefMenuModel cefMenuModel) {
        this.menu_closed.menu_closed(this, cefMenuModel);
    }

    public int formatLabel(CefMenuModel cefMenuModel, String string) {
        return this.format_label.format_label(this, cefMenuModel, CljCefLib.toCefString(string));
    }

    public static interface ExecuteCommandFunc
    extends Callback {
        public void execute_command(CefMenuModelDelegate var1, CefMenuModel var2, int var3, int var4);
    }

    public static interface MouseOutsideMenuFunc
    extends Callback {
        public void mouse_outside_menu(CefMenuModelDelegate var1, CefMenuModel var2, CefPoint var3);
    }

    public static interface UnhandledOpenSubmenuFunc
    extends Callback {
        public void unhandled_open_submenu(CefMenuModelDelegate var1, CefMenuModel var2, int var3);
    }

    public static interface UnhandledCloseSubmenuFunc
    extends Callback {
        public void unhandled_close_submenu(CefMenuModelDelegate var1, CefMenuModel var2, int var3);
    }

    public static interface MenuWillShowFunc
    extends Callback {
        public void menu_will_show(CefMenuModelDelegate var1, CefMenuModel var2);
    }

    public static interface MenuClosedFunc
    extends Callback {
        public void menu_closed(CefMenuModelDelegate var1, CefMenuModel var2);
    }

    public static interface FormatLabelFunc
    extends Callback {
        public int format_label(CefMenuModelDelegate var1, CefMenuModel var2, CefStringUtf16 var3);
    }
}

