/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefBinaryValue;
import com.phronemophobic.cljcef.CefDictionaryValue;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CefValue;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.phronemophobic.cljcef.SizeT;
import com.sun.jna.Callback;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefListValue
extends Structure {
    public CefBaseRefCounted base;
    public IsValidFunc is_valid;
    public IsOwnedFunc is_owned;
    public IsReadOnlyFunc is_read_only;
    public IsSameFunc is_same;
    public IsEqualFunc is_equal;
    public CopyFunc copy;
    public SetSizeFunc set_size;
    public GetSizeFunc get_size;
    public ClearFunc clear;
    public RemoveFunc remove;
    public GetTypeFunc get_type;
    public GetValueFunc get_value;
    public GetBoolFunc get_bool;
    public GetIntFunc get_int;
    public GetDoubleFunc get_double;
    public GetStringFunc get_string;
    public GetBinaryFunc get_binary;
    public GetDictionaryFunc get_dictionary;
    public GetListFunc get_list;
    public SetValueFunc set_value;
    public SetNullFunc set_null;
    public SetBoolFunc set_bool;
    public SetIntFunc set_int;
    public SetDoubleFunc set_double;
    public SetStringFunc set_string;
    public SetBinaryFunc set_binary;
    public SetDictionaryFunc set_dictionary;
    public SetListFunc set_list;

    public CefListValue() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "is_valid", "is_owned", "is_read_only", "is_same", "is_equal", "copy", "set_size", "get_size", "clear", "remove", "get_type", "get_value", "get_bool", "get_int", "get_double", "get_string", "get_binary", "get_dictionary", "get_list", "set_value", "set_null", "set_bool", "set_int", "set_double", "set_string", "set_binary", "set_dictionary", "set_list");
    }

    public int isValid() {
        return this.is_valid.is_valid(this);
    }

    public int isOwned() {
        return this.is_owned.is_owned(this);
    }

    public int isReadOnly() {
        return this.is_read_only.is_read_only(this);
    }

    public int isSame(CefListValue cefListValue) {
        return this.is_same.is_same(this, cefListValue);
    }

    public int isEqual(CefListValue cefListValue) {
        return this.is_equal.is_equal(this, cefListValue);
    }

    public CefListValue copy() {
        return this.copy.copy(this);
    }

    public int setSize(SizeT sizeT) {
        return this.set_size.set_size(this, sizeT);
    }

    public SizeT getSize() {
        return this.get_size.get_size(this);
    }

    public int remove(SizeT sizeT) {
        return this.remove.remove(this, sizeT);
    }

    public int getType(SizeT sizeT) {
        return this.get_type.get_type(this, sizeT);
    }

    public CefValue getValue(SizeT sizeT) {
        return this.get_value.get_value(this, sizeT);
    }

    public int getBool(SizeT sizeT) {
        return this.get_bool.get_bool(this, sizeT);
    }

    public int getInt(SizeT sizeT) {
        return this.get_int.get_int(this, sizeT);
    }

    public double getDouble(SizeT sizeT) {
        return this.get_double.get_double(this, sizeT);
    }

    public CefStringUtf16 getString(SizeT sizeT) {
        return this.get_string.get_string(this, sizeT);
    }

    public CefBinaryValue getBinary(SizeT sizeT) {
        return this.get_binary.get_binary(this, sizeT);
    }

    public CefDictionaryValue getDictionary(SizeT sizeT) {
        return this.get_dictionary.get_dictionary(this, sizeT);
    }

    public CefListValue getList(SizeT sizeT) {
        return this.get_list.get_list(this, sizeT);
    }

    public int setValue(SizeT sizeT, CefValue cefValue) {
        return this.set_value.set_value(this, sizeT, cefValue);
    }

    public int setNull(SizeT sizeT) {
        return this.set_null.set_null(this, sizeT);
    }

    public int setBool(SizeT sizeT, int n) {
        return this.set_bool.set_bool(this, sizeT, n);
    }

    public int setInt(SizeT sizeT, int n) {
        return this.set_int.set_int(this, sizeT, n);
    }

    public int setDouble(SizeT sizeT, double d) {
        return this.set_double.set_double(this, sizeT, d);
    }

    public int setString(SizeT sizeT, String string) {
        return this.set_string.set_string(this, sizeT, CljCefLib.toCefString(string));
    }

    public int setBinary(SizeT sizeT, CefBinaryValue cefBinaryValue) {
        return this.set_binary.set_binary(this, sizeT, cefBinaryValue);
    }

    public int setDictionary(SizeT sizeT, CefDictionaryValue cefDictionaryValue) {
        return this.set_dictionary.set_dictionary(this, sizeT, cefDictionaryValue);
    }

    public int setList(SizeT sizeT, CefListValue cefListValue) {
        return this.set_list.set_list(this, sizeT, cefListValue);
    }

    public static interface IsValidFunc
    extends Callback {
        public int is_valid(CefListValue var1);
    }

    public static interface IsOwnedFunc
    extends Callback {
        public int is_owned(CefListValue var1);
    }

    public static interface IsReadOnlyFunc
    extends Callback {
        public int is_read_only(CefListValue var1);
    }

    public static interface IsSameFunc
    extends Callback {
        public int is_same(CefListValue var1, CefListValue var2);
    }

    public static interface IsEqualFunc
    extends Callback {
        public int is_equal(CefListValue var1, CefListValue var2);
    }

    public static interface CopyFunc
    extends Callback {
        public CefListValue copy(CefListValue var1);
    }

    public static interface SetSizeFunc
    extends Callback {
        public int set_size(CefListValue var1, SizeT var2);
    }

    public static interface GetSizeFunc
    extends Callback {
        public SizeT get_size(CefListValue var1);
    }

    public static interface RemoveFunc
    extends Callback {
        public int remove(CefListValue var1, SizeT var2);
    }

    public static interface GetTypeFunc
    extends Callback {
        public int get_type(CefListValue var1, SizeT var2);
    }

    public static interface GetValueFunc
    extends Callback {
        public CefValue get_value(CefListValue var1, SizeT var2);
    }

    public static interface GetBoolFunc
    extends Callback {
        public int get_bool(CefListValue var1, SizeT var2);
    }

    public static interface GetIntFunc
    extends Callback {
        public int get_int(CefListValue var1, SizeT var2);
    }

    public static interface GetDoubleFunc
    extends Callback {
        public double get_double(CefListValue var1, SizeT var2);
    }

    public static interface GetStringFunc
    extends Callback {
        public CefStringUtf16 get_string(CefListValue var1, SizeT var2);
    }

    public static interface GetBinaryFunc
    extends Callback {
        public CefBinaryValue get_binary(CefListValue var1, SizeT var2);
    }

    public static interface GetDictionaryFunc
    extends Callback {
        public CefDictionaryValue get_dictionary(CefListValue var1, SizeT var2);
    }

    public static interface GetListFunc
    extends Callback {
        public CefListValue get_list(CefListValue var1, SizeT var2);
    }

    public static interface SetValueFunc
    extends Callback {
        public int set_value(CefListValue var1, SizeT var2, CefValue var3);
    }

    public static interface SetNullFunc
    extends Callback {
        public int set_null(CefListValue var1, SizeT var2);
    }

    public static interface SetBoolFunc
    extends Callback {
        public int set_bool(CefListValue var1, SizeT var2, int var3);
    }

    public static interface SetIntFunc
    extends Callback {
        public int set_int(CefListValue var1, SizeT var2, int var3);
    }

    public static interface SetDoubleFunc
    extends Callback {
        public int set_double(CefListValue var1, SizeT var2, double var3);
    }

    public static interface SetStringFunc
    extends Callback {
        public int set_string(CefListValue var1, SizeT var2, CefStringUtf16 var3);
    }

    public static interface SetBinaryFunc
    extends Callback {
        public int set_binary(CefListValue var1, SizeT var2, CefBinaryValue var3);
    }

    public static interface SetDictionaryFunc
    extends Callback {
        public int set_dictionary(CefListValue var1, SizeT var2, CefDictionaryValue var3);
    }

    public static interface SetListFunc
    extends Callback {
        public int set_list(CefListValue var1, SizeT var2, CefListValue var3);
    }

    public static interface ClearFunc
    extends Callback {
        public int clear(CefListValue var1);
    }
}

