/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefCommandLine
extends Structure {
    public CefBaseRefCounted base;
    public IsValidFunc is_valid;
    public IsReadOnlyFunc is_read_only;
    public CopyFunc copy;
    public InitFromArgvFunc init_from_argv;
    public InitFromStringFunc init_from_string;
    public ResetFunc reset;
    public GetArgvFunc get_argv;
    public GetCommandLineStringFunc get_command_line_string;
    public GetProgramFunc get_program;
    public SetProgramFunc set_program;
    public HasSwitchesFunc has_switches;
    public HasSwitchFunc has_switch;
    public GetSwitchValueFunc get_switch_value;
    public GetSwitchesFunc get_switches;
    public AppendSwitchFunc append_switch;
    public AppendSwitchWithValueFunc append_switch_with_value;
    public HasArgumentsFunc has_arguments;
    public GetArgumentsFunc get_arguments;
    public AppendArgumentFunc append_argument;
    public PrependWrapperFunc prepend_wrapper;

    public CefCommandLine() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "is_valid", "is_read_only", "copy", "init_from_argv", "init_from_string", "reset", "get_argv", "get_command_line_string", "get_program", "set_program", "has_switches", "has_switch", "get_switch_value", "get_switches", "append_switch", "append_switch_with_value", "has_arguments", "get_arguments", "append_argument", "prepend_wrapper");
    }

    public int isValid() {
        return this.is_valid.is_valid(this);
    }

    public int isReadOnly() {
        return this.is_read_only.is_read_only(this);
    }

    public CefCommandLine copy() {
        return this.copy.copy(this);
    }

    public void initFromArgv(int n, Pointer pointer) {
        this.init_from_argv.init_from_argv(this, n, pointer);
    }

    public void initFromString(String string) {
        this.init_from_string.init_from_string(this, CljCefLib.toCefString(string));
    }

    public void reset() {
        this.reset.reset(this);
    }

    public void getArgv(Pointer pointer) {
        this.get_argv.get_argv(this, pointer);
    }

    public CefStringUtf16 getCommandLineString() {
        return this.get_command_line_string.get_command_line_string(this);
    }

    public CefStringUtf16 getProgram() {
        return this.get_program.get_program(this);
    }

    public void setProgram(String string) {
        this.set_program.set_program(this, CljCefLib.toCefString(string));
    }

    public int hasSwitches() {
        return this.has_switches.has_switches(this);
    }

    public int hasSwitch(String string) {
        return this.has_switch.has_switch(this, CljCefLib.toCefString(string));
    }

    public CefStringUtf16 getSwitchValue(String string) {
        return this.get_switch_value.get_switch_value(this, CljCefLib.toCefString(string));
    }

    public void getSwitches(Pointer pointer) {
        this.get_switches.get_switches(this, pointer);
    }

    public void appendSwitch(String string) {
        this.append_switch.append_switch(this, CljCefLib.toCefString(string));
    }

    public void appendSwitchWithValue(String string, String string2) {
        this.append_switch_with_value.append_switch_with_value(this, CljCefLib.toCefString(string), CljCefLib.toCefString(string2));
    }

    public int hasArguments() {
        return this.has_arguments.has_arguments(this);
    }

    public void getArguments(Pointer pointer) {
        this.get_arguments.get_arguments(this, pointer);
    }

    public void appendArgument(String string) {
        this.append_argument.append_argument(this, CljCefLib.toCefString(string));
    }

    public void prependWrapper(String string) {
        this.prepend_wrapper.prepend_wrapper(this, CljCefLib.toCefString(string));
    }

    public static interface PrependWrapperFunc
    extends Callback {
        public void prepend_wrapper(CefCommandLine var1, CefStringUtf16 var2);
    }

    public static interface AppendArgumentFunc
    extends Callback {
        public void append_argument(CefCommandLine var1, CefStringUtf16 var2);
    }

    public static interface GetArgumentsFunc
    extends Callback {
        public void get_arguments(CefCommandLine var1, Pointer var2);
    }

    public static interface HasArgumentsFunc
    extends Callback {
        public int has_arguments(CefCommandLine var1);
    }

    public static interface AppendSwitchWithValueFunc
    extends Callback {
        public void append_switch_with_value(CefCommandLine var1, CefStringUtf16 var2, CefStringUtf16 var3);
    }

    public static interface AppendSwitchFunc
    extends Callback {
        public void append_switch(CefCommandLine var1, CefStringUtf16 var2);
    }

    public static interface GetSwitchesFunc
    extends Callback {
        public void get_switches(CefCommandLine var1, Pointer var2);
    }

    public static interface GetSwitchValueFunc
    extends Callback {
        public CefStringUtf16 get_switch_value(CefCommandLine var1, CefStringUtf16 var2);
    }

    public static interface HasSwitchFunc
    extends Callback {
        public int has_switch(CefCommandLine var1, CefStringUtf16 var2);
    }

    public static interface HasSwitchesFunc
    extends Callback {
        public int has_switches(CefCommandLine var1);
    }

    public static interface SetProgramFunc
    extends Callback {
        public void set_program(CefCommandLine var1, CefStringUtf16 var2);
    }

    public static interface GetProgramFunc
    extends Callback {
        public CefStringUtf16 get_program(CefCommandLine var1);
    }

    public static interface GetCommandLineStringFunc
    extends Callback {
        public CefStringUtf16 get_command_line_string(CefCommandLine var1);
    }

    public static interface GetArgvFunc
    extends Callback {
        public void get_argv(CefCommandLine var1, Pointer var2);
    }

    public static interface ResetFunc
    extends Callback {
        public void reset(CefCommandLine var1);
    }

    public static interface InitFromStringFunc
    extends Callback {
        public void init_from_string(CefCommandLine var1, CefStringUtf16 var2);
    }

    public static interface InitFromArgvFunc
    extends Callback {
        public void init_from_argv(CefCommandLine var1, int var2, Pointer var3);
    }

    public static interface CopyFunc
    extends Callback {
        public CefCommandLine copy(CefCommandLine var1);
    }

    public static interface IsReadOnlyFunc
    extends Callback {
        public int is_read_only(CefCommandLine var1);
    }

    public static interface IsValidFunc
    extends Callback {
        public int is_valid(CefCommandLine var1);
    }
}

