/*
 * Decompiled with CFR 0.152.
 */
package com.phronemophobic.cljcef;

import com.phronemophobic.cljcef.CefBaseRefCounted;
import com.phronemophobic.cljcef.CefCompletionCallback;
import com.phronemophobic.cljcef.CefCookie;
import com.phronemophobic.cljcef.CefCookieVisitor;
import com.phronemophobic.cljcef.CefDeleteCookiesCallback;
import com.phronemophobic.cljcef.CefSetCookieCallback;
import com.phronemophobic.cljcef.CefStringUtf16;
import com.phronemophobic.cljcef.CljCefLib;
import com.phronemophobic.cljcef.ReferenceCountImpl;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class CefCookieManager
extends Structure {
    public CefBaseRefCounted base;
    public SetSupportedSchemesFunc set_supported_schemes;
    public VisitAllCookiesFunc visit_all_cookies;
    public VisitUrlCookiesFunc visit_url_cookies;
    public SetCookieFunc set_cookie;
    public DeleteCookiesFunc delete_cookies;
    public FlushStoreFunc flush_store;

    public CefCookieManager() {
        this.base.size.setValue(this.size());
        ReferenceCountImpl.track(this.getPointer());
    }

    protected List getFieldOrder() {
        return Arrays.asList("base", "set_supported_schemes", "visit_all_cookies", "visit_url_cookies", "set_cookie", "delete_cookies", "flush_store");
    }

    public void setSupportedSchemes(Pointer pointer, int n, CefCompletionCallback cefCompletionCallback) {
        this.set_supported_schemes.set_supported_schemes(this, pointer, n, cefCompletionCallback);
    }

    public int visitAllCookies(CefCookieVisitor cefCookieVisitor) {
        return this.visit_all_cookies.visit_all_cookies(this, cefCookieVisitor);
    }

    public int visitUrlCookies(String string, int n, CefCookieVisitor cefCookieVisitor) {
        return this.visit_url_cookies.visit_url_cookies(this, CljCefLib.toCefString(string), n, cefCookieVisitor);
    }

    public int setCookie(String string, CefCookie cefCookie, CefSetCookieCallback cefSetCookieCallback) {
        return this.set_cookie.set_cookie(this, CljCefLib.toCefString(string), cefCookie, cefSetCookieCallback);
    }

    public int deleteCookies(String string, String string2, CefDeleteCookiesCallback cefDeleteCookiesCallback) {
        return this.delete_cookies.delete_cookies(this, CljCefLib.toCefString(string), CljCefLib.toCefString(string2), cefDeleteCookiesCallback);
    }

    public int flushStore(CefCompletionCallback cefCompletionCallback) {
        return this.flush_store.flush_store(this, cefCompletionCallback);
    }

    public static interface FlushStoreFunc
    extends Callback {
        public int flush_store(CefCookieManager var1, CefCompletionCallback var2);
    }

    public static interface DeleteCookiesFunc
    extends Callback {
        public int delete_cookies(CefCookieManager var1, CefStringUtf16 var2, CefStringUtf16 var3, CefDeleteCookiesCallback var4);
    }

    public static interface SetCookieFunc
    extends Callback {
        public int set_cookie(CefCookieManager var1, CefStringUtf16 var2, CefCookie var3, CefSetCookieCallback var4);
    }

    public static interface VisitUrlCookiesFunc
    extends Callback {
        public int visit_url_cookies(CefCookieManager var1, CefStringUtf16 var2, int var3, CefCookieVisitor var4);
    }

    public static interface VisitAllCookiesFunc
    extends Callback {
        public int visit_all_cookies(CefCookieManager var1, CefCookieVisitor var2);
    }

    public static interface SetSupportedSchemesFunc
    extends Callback {
        public void set_supported_schemes(CefCookieManager var1, Pointer var2, int var3, CefCompletionCallback var4);
    }
}

