(ns com.phronemophobic.clip.db
  (:require [com.phronemophobic.clip :as clip]
            [clojure.java.io :as io]
            [clojure.edn :as edn]
            [clojure.string :as str])
  (:gen-class))



(require 'dev)
(dev/add-libs '{com.phronemophobic/membrane {:mvn/version "0.14.3-beta"}})
(require '[membrane.ui :as ui]
         '[membrane.java2d :as java2d])


(defn index [ctx images]
  (binding [clip/*num-threads* 8]
    (into {}
          (comp
           (map io/as-file)
           (map (fn [^java.io.File f]
                  (try
                    [f
                     (clip/image-embedding ctx f)]
                    (catch Exception e
                      nil))))
           (remove nil?))
          images)))

(defn find-nearest [ctx index emb]
  (->> (sort-by
        (fn [[f image-emb]]
          (clip/cosine-similarity emb image-emb))
        index)
       reverse
       (take 10)
       (map first)
       (into [])))



(comment

  (do
    (def model-path
      "models/CLIP-ViT-B-32-laion2B-s34B-b79K_ggml-model-f16.gguf")

    (def ctx (clip/create-context model-path)))

  (def img-dir
    "/Users/adrian/workspace/worldhaven/images/character-ability-cards/frosthaven")
  (def images
    (into []
          (comp
           (filter #(or (str/ends-with? (.getName %) ".jpg")
                        (str/ends-with? (.getName %) ".png")
                        (str/ends-with? (.getName %) ".jpeg")))
           (remove #(str/ends-with? (.getName %) "back.png")))
          (file-seq (io/file img-dir)))
    )

  (def my-index
    (time
     (index ctx images)))

  ,)

(declare ctx my-index)

(defn search-ui* [search-emb]
  (let [
        imgs (find-nearest ctx my-index search-emb)
        view (ui/table-layout
              (into []
                    (comp
                     (map #(.getCanonicalPath %))
                     (map #(ui/image % [200 nil]))
                     (partition-all 5))
                    imgs))]
    view))
(def search-ui (memoize search-ui*))

(defn get-embedding* [type input]
  (case type
    :image (clip/image-embedding ctx input)
    :text (clip/text-embedding ctx input)))
(def get-embedding (memoize get-embedding*))

(defn debug []
  (search-ui
   #_(get-embedding :text "putrid cloud")
   (get-embedding :image "/Users/adrian/workspace/worldhaven/images/tokens/frosthaven/elements/fh-ice-element.png")))

(comment
  (java2d/run
    #'debug)
  ,)
