/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.testcontainer.elasticsearch.utils;

import com.phonepe.testcontainer.commons.ContainerUtils;
import com.phonepe.testcontainer.elasticsearch.CreateIndex;
import com.phonepe.testcontainer.elasticsearch.WaitForGreenStatus;
import com.phonepe.testcontainer.elasticsearch.config.ElasticsearchContainerConfiguration;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ElasticsearchContainerUtils {
    public static String getJavaOpts(ElasticsearchContainerConfiguration configuration) {
        return "-Xms" + configuration.getClusterRamMb() + "m -Xmx" + configuration.getClusterRamMb() + "m";
    }

    public static WaitStrategy getCompositeWaitStrategy(ElasticsearchContainerConfiguration configuration) {
        WaitAllStrategy strategy = new WaitAllStrategy().withStrategy((WaitStrategy)new HostPortWaitStrategy());
        configuration.getIndices().forEach(index -> strategy.withStrategy((WaitStrategy)new CreateIndex(configuration, (String)index)));
        return strategy.withStrategy((WaitStrategy)new WaitForGreenStatus(configuration)).withStartupTimeout(ContainerUtils.DEFAULT_CONTAINER_WAIT_DURATION);
    }
}

