/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.testcontainer.demo.config;

import com.phonepe.testcontainer.demo.config.AerospikeHost;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class AerospikeConfiguration {
    @NotNull
    private List<AerospikeHost> connection;
    private String user;
    private String password;
    @Min(value=0L)
    private int retries = 5;
    @Min(value=10L)
    @Max(value=10000L)
    private int sleepBetweenRetries = 100;
    @Min(value=1L)
    private int maxConnectionsPerNode = 5;

    public List<AerospikeHost> getConnection() {
        return this.connection;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getSleepBetweenRetries() {
        return this.sleepBetweenRetries;
    }

    public int getMaxConnectionsPerNode() {
        return this.maxConnectionsPerNode;
    }

    public void setConnection(List<AerospikeHost> connection) {
        this.connection = connection;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public void setMaxConnectionsPerNode(int maxConnectionsPerNode) {
        this.maxConnectionsPerNode = maxConnectionsPerNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeConfiguration)) {
            return false;
        }
        AerospikeConfiguration other = (AerospikeConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<AerospikeHost> this$connection = this.getConnection();
        List<AerospikeHost> other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !((Object)this$connection).equals(other$connection)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        if (this.getSleepBetweenRetries() != other.getSleepBetweenRetries()) {
            return false;
        }
        return this.getMaxConnectionsPerNode() == other.getMaxConnectionsPerNode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AerospikeConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AerospikeHost> $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : ((Object)$connection).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + this.getRetries();
        result = result * 59 + this.getSleepBetweenRetries();
        result = result * 59 + this.getMaxConnectionsPerNode();
        return result;
    }

    public String toString() {
        return "AerospikeConfiguration(connection=" + this.getConnection() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", retries=" + this.getRetries() + ", sleepBetweenRetries=" + this.getSleepBetweenRetries() + ", maxConnectionsPerNode=" + this.getMaxConnectionsPerNode() + ")";
    }

    @ConstructorProperties(value={"connection", "user", "password", "retries", "sleepBetweenRetries", "maxConnectionsPerNode"})
    public AerospikeConfiguration(List<AerospikeHost> connection, String user, String password, int retries, int sleepBetweenRetries, int maxConnectionsPerNode) {
        this.connection = connection;
        this.user = user;
        this.password = password;
        this.retries = retries;
        this.sleepBetweenRetries = sleepBetweenRetries;
        this.maxConnectionsPerNode = maxConnectionsPerNode;
    }

    public AerospikeConfiguration() {
    }
}

