/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.testcontainer.demo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.phonepe.testcontainer.commons.ApplicationContext;
import com.phonepe.testcontainer.demo.config.DemoAppConfiguration;
import com.phonepe.testcontainer.demo.module.AerospikeModule;
import com.phonepe.testcontainer.demo.utils.SerDe;
import io.dropwizard.Application;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.vyarus.dropwizard.guice.GuiceBundle;

public class TestContainerDemoApplication
extends Application<DemoAppConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(TestContainerDemoApplication.class);
    private GuiceBundle<DemoAppConfiguration> guiceBundle;

    public static void main(String[] args) throws Exception {
        new TestContainerDemoApplication().run(args);
    }

    public void initialize(Bootstrap<DemoAppConfiguration> bootstrap) {
        this.guiceBundle = GuiceBundle.builder().modules(new Module[]{new AerospikeModule()}).enableAutoConfig(new String[]{((Object)((Object)this)).getClass().getPackage().getName()}).build(Stage.PRODUCTION);
        bootstrap.addBundle(this.guiceBundle);
    }

    public void run(DemoAppConfiguration hermesConfiguration, Environment environment) {
        this.initializeSerDeserializer(environment);
        ApplicationContext.setAlreadyCreatedInjector((Injector)this.guiceBundle.getInjector());
    }

    private void initializeSerDeserializer(Environment environment) {
        environment.getObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        environment.getObjectMapper().configure(MapperFeature.USE_BASE_TYPE_AS_DEFAULT_IMPL, true);
        SerDe.init(environment.getObjectMapper());
    }

    public String getName() {
        return "testcontainer-app";
    }
}

