/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.phonepe.sdk.javasdk.transaction.models.Base64Request;
import com.phonepe.sdk.javasdk.utils.MapperUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Base64Utils {
    private static final Logger log = LoggerFactory.getLogger(Base64Utils.class);

    public static String decodeBase64(String encodedString) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)encodedString));
    }

    public static String encodeBase64(String requestString) {
        return StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])requestString.getBytes()));
    }

    public static <T> Base64Request getBase64Request(T requestBody) throws JsonProcessingException {
        String jsonBody = MapperUtils.getMapper().writeValueAsString(requestBody);
        String b64RequestBody = Base64Utils.encodeBase64(jsonBody);
        return Base64Request.builder().request(b64RequestBody).build();
    }

    private Base64Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

