/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk.config.models;

import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.PhonePeConfig;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public class SDKConfig {
    @Valid
    @NotNull
    private MerchantConfig merchantConfig;
    @Valid
    private PhonePeConfig phonePeConfig = PhonePeConfig.builder().build();

    public SDKConfig(MerchantConfig merchantConfig, PhonePeConfig phonePeConfig) {
        this.merchantConfig = merchantConfig;
        this.phonePeConfig = phonePeConfig == null ? PhonePeConfig.builder().build() : phonePeConfig;
    }

    public static SDKConfigBuilder builder() {
        return new SDKConfigBuilder();
    }

    public MerchantConfig getMerchantConfig() {
        return this.merchantConfig;
    }

    public PhonePeConfig getPhonePeConfig() {
        return this.phonePeConfig;
    }

    public void setMerchantConfig(MerchantConfig merchantConfig) {
        this.merchantConfig = merchantConfig;
    }

    public void setPhonePeConfig(PhonePeConfig phonePeConfig) {
        this.phonePeConfig = phonePeConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SDKConfig)) {
            return false;
        }
        SDKConfig other = (SDKConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MerchantConfig this$merchantConfig = this.getMerchantConfig();
        MerchantConfig other$merchantConfig = other.getMerchantConfig();
        if (this$merchantConfig == null ? other$merchantConfig != null : !((Object)this$merchantConfig).equals(other$merchantConfig)) {
            return false;
        }
        PhonePeConfig this$phonePeConfig = this.getPhonePeConfig();
        PhonePeConfig other$phonePeConfig = other.getPhonePeConfig();
        return !(this$phonePeConfig == null ? other$phonePeConfig != null : !((Object)this$phonePeConfig).equals(other$phonePeConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SDKConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MerchantConfig $merchantConfig = this.getMerchantConfig();
        result = result * 59 + ($merchantConfig == null ? 43 : ((Object)$merchantConfig).hashCode());
        PhonePeConfig $phonePeConfig = this.getPhonePeConfig();
        result = result * 59 + ($phonePeConfig == null ? 43 : ((Object)$phonePeConfig).hashCode());
        return result;
    }

    public String toString() {
        return "SDKConfig(merchantConfig=" + this.getMerchantConfig() + ", phonePeConfig=" + this.getPhonePeConfig() + ")";
    }

    public SDKConfig() {
    }

    public static class SDKConfigBuilder {
        private MerchantConfig merchantConfig;
        private PhonePeConfig phonePeConfig;

        SDKConfigBuilder() {
        }

        public SDKConfigBuilder merchantConfig(MerchantConfig merchantConfig) {
            this.merchantConfig = merchantConfig;
            return this;
        }

        public SDKConfigBuilder phonePeConfig(PhonePeConfig phonePeConfig) {
            this.phonePeConfig = phonePeConfig;
            return this;
        }

        public SDKConfig build() {
            return new SDKConfig(this.merchantConfig, this.phonePeConfig);
        }

        public String toString() {
            return "SDKConfig.SDKConfigBuilder(merchantConfig=" + this.merchantConfig + ", phonePeConfig=" + this.phonePeConfig + ")";
        }
    }
}

