/*
 * Decompiled with CFR 0.152.
 */
package com.phonepe.sdk.javasdk;

import com.google.common.base.Preconditions;
import com.phonepe.sdk.javasdk.config.ConfigurationFactory;
import com.phonepe.sdk.javasdk.config.DefaultEndpointCreator;
import com.phonepe.sdk.javasdk.config.DefaultUrlCreator;
import com.phonepe.sdk.javasdk.config.URLCreator;
import com.phonepe.sdk.javasdk.config.models.DefaultConfig;
import com.phonepe.sdk.javasdk.config.models.Endpoint;
import com.phonepe.sdk.javasdk.config.models.HttpClientConfig;
import com.phonepe.sdk.javasdk.config.models.InitConfig;
import com.phonepe.sdk.javasdk.config.models.MerchantConfig;
import com.phonepe.sdk.javasdk.config.models.PhonePeConfig;
import com.phonepe.sdk.javasdk.config.models.SDKConfig;
import com.phonepe.sdk.javasdk.config.models.StatusConfig;
import com.phonepe.sdk.javasdk.exception.PhonePeClientException;
import com.phonepe.sdk.javasdk.exception.PhonePeConfigurationException;
import com.phonepe.sdk.javasdk.http.PhonePeHttpClientFactory;
import com.phonepe.sdk.javasdk.http.utils.HttpUtils;
import com.phonepe.sdk.javasdk.transaction.callback.CallbackHandler;
import com.phonepe.sdk.javasdk.transaction.callback.StatusResponseHandler;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGenerator;
import com.phonepe.sdk.javasdk.transaction.checksum.ChecksumGeneratorFactory;
import com.phonepe.sdk.javasdk.transaction.client.TransactionCommand;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiator;
import com.phonepe.sdk.javasdk.transaction.init.TransactionInitiatorFactory;
import com.phonepe.sdk.javasdk.transaction.init.models.InitResponse;
import com.phonepe.sdk.javasdk.transaction.models.InitParams;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreator;
import com.phonepe.sdk.javasdk.transaction.request.PhonePeHttpRequestCreatorFactory;
import com.phonepe.sdk.javasdk.transaction.status.PaymentStateCreator;
import com.phonepe.sdk.javasdk.transaction.status.TransactionStatusChecker;
import com.phonepe.sdk.javasdk.transaction.status.models.StatusResponse;
import com.phonepe.sdk.javasdk.utils.KeyUtils;
import java.io.IOException;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhonePeClient {
    private static final Logger log = LoggerFactory.getLogger(PhonePeClient.class);
    private TransactionInitiator transactionInitiator;
    private CallbackHandler callbackHandler;
    private TransactionStatusChecker statusChecker;
    private int defaultKeyIndex;

    public PhonePeClient(SDKConfig sdkConfig) throws PhonePeConfigurationException, IOException {
        Preconditions.checkNotNull((Object)sdkConfig);
        this.init(sdkConfig);
    }

    private void init(SDKConfig config) throws PhonePeConfigurationException, IOException {
        this.init(config, null);
    }

    private void init(SDKConfig sdkConfig, OkHttpClient okHttpClient) throws PhonePeConfigurationException, IOException {
        PhonePeConfig phonePeConfig = sdkConfig.getPhonePeConfig();
        DefaultConfig defaultConfig = ConfigurationFactory.builder().clazz(DefaultConfig.class).build().buildConfig("java_sdk_default.yml");
        HttpClientConfig httpClientConfig = phonePeConfig.getHttpClientConfig();
        Endpoint endpoint = phonePeConfig.getEndpoint();
        StatusConfig statusConfig = phonePeConfig.getStatusConfig();
        MerchantConfig merchantConfig = sdkConfig.getMerchantConfig();
        InitConfig initConfig = phonePeConfig.getInitConfig();
        ChecksumGeneratorFactory checksumGeneratorFactory = new ChecksumGeneratorFactory();
        DefaultEndpointCreator defaultEndpointCreator = DefaultEndpointCreator.builder().defaultConfig(defaultConfig).build();
        DefaultUrlCreator defaultUrlCreator = DefaultUrlCreator.builder().defaultConfig(defaultConfig).build();
        URLCreator urlCreator = URLCreator.builder().defaultEndpointCreator(defaultEndpointCreator).endpoint(endpoint).defaultUrlCreator(defaultUrlCreator).build();
        PaymentStateCreator paymentStateCreator = new PaymentStateCreator();
        OkHttpClient client = PhonePeHttpClientFactory.buildOkHttpClient(okHttpClient, httpClientConfig, HttpUtils.isHttpEndpointSecured(endpoint));
        TransactionCommand transactionCommand = new TransactionCommand(client, defaultConfig);
        ChecksumGenerator statusChecksumGenerator = statusConfig.getApiVersion().accept(checksumGeneratorFactory);
        ChecksumGenerator initChecksumGenerator = initConfig.getApiVersion().accept(checksumGeneratorFactory);
        PhonePeHttpRequestCreatorFactory phonePeHttpRequestCreatorFactory = new PhonePeHttpRequestCreatorFactory();
        PhonePeHttpRequestCreator phonePeHttpRequestCreator = (PhonePeHttpRequestCreator)initConfig.getApiVersion().accept(phonePeHttpRequestCreatorFactory);
        TransactionInitiatorFactory transactionInitiatorFactory = TransactionInitiatorFactory.builder().merchantConfig(merchantConfig).initConfig(initConfig).transactionCommand(transactionCommand).checksumGenerator(initChecksumGenerator).urlCreator(urlCreator).phonePeHttpRequestCreator(phonePeHttpRequestCreator).build();
        this.statusChecker = TransactionStatusChecker.builder().merchantConfig(merchantConfig).statusConfig(statusConfig).transactionCommand(transactionCommand).checksumGenerator(statusChecksumGenerator).paymentStateCreator(paymentStateCreator).urlCreator(urlCreator).build();
        this.callbackHandler = CallbackHandler.builder().merchantConfig(merchantConfig).transactionStatusChecker(this.statusChecker).build();
        this.transactionInitiator = initConfig.getInitType().accept(transactionInitiatorFactory);
        this.defaultKeyIndex = KeyUtils.getDefaultKeyIndex(merchantConfig.getApiKeys());
    }

    public InitResponse initTransaction(InitParams initParam) throws PhonePeClientException {
        return this.initTransaction(initParam, this.defaultKeyIndex);
    }

    public InitResponse initTransaction(InitParams initParams, int keyIndex) throws PhonePeClientException {
        return this.transactionInitiator.initiateTransaction(initParams, keyIndex);
    }

    public void handleCallback(String responseReceived, String checksum, long transactionAmount, StatusResponseHandler customResponseHandler) throws PhonePeClientException {
        this.callbackHandler.handleCallback(responseReceived, checksum, transactionAmount, customResponseHandler);
    }

    public StatusResponse checkTransactionStatus(String transactionId) throws PhonePeClientException {
        return this.checkTransactionStatus(transactionId, this.defaultKeyIndex);
    }

    public StatusResponse checkTransactionStatus(String transactionId, int keyIndex) throws PhonePeClientException {
        return this.statusChecker.checkTransactionStatus(transactionId, keyIndex);
    }

    public static PhonePeClientBuilder builder() {
        return new PhonePeClientBuilder();
    }

    public static class PhonePeClientBuilder {
        private SDKConfig sdkConfig;

        PhonePeClientBuilder() {
        }

        public PhonePeClientBuilder sdkConfig(SDKConfig sdkConfig) {
            this.sdkConfig = sdkConfig;
            return this;
        }

        public PhonePeClient build() throws PhonePeConfigurationException, IOException {
            return new PhonePeClient(this.sdkConfig);
        }

        public String toString() {
            return "PhonePeClient.PhonePeClientBuilder(sdkConfig=" + this.sdkConfig + ")";
        }
    }
}

