package com.phonepe.sdk.javasdk.transaction.init.models;

import com.phonepe.sdk.javasdk.transaction.init.models.enums.Denomination;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.annotation.Nonnegative;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OfferTag {

    @Size(min = 1)
    private String id;

    @Min(1)
    @Nonnegative
    private Long amount;

    @Builder.Default
    private Denomination denomination = Denomination.PAISE;
}
    