package com.phonepe.sdk.javasdk.transaction.init.decorator;

import com.phonepe.sdk.javasdk.transaction.init.models.AllowedAccountConstraint;
import com.phonepe.sdk.javasdk.transaction.init.models.InitRequest;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantConstraints;
import com.phonepe.sdk.javasdk.transaction.init.models.MerchantContext;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;


/**
 * Decorator that will populate the {@link com.phonepe.sdk.javasdk.transaction.init.models.InitRequest}
 * with merchant account constraints.
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AccountConstraintsDecorator extends InitRequestDecorator {

    private List<AllowedAccountConstraint> allowedAccountConstraints;

    @Builder
    public AccountConstraintsDecorator(final TransactionInitComponent transactionInitComponent,
                                       final List<AllowedAccountConstraint> allowedAccountConstraints) {
        super(transactionInitComponent);
        this.allowedAccountConstraints = allowedAccountConstraints;
    }

    @Override
    public InitRequest getInitRequest() {
        InitRequest initRequest = this.transactionInitComponent.getInitRequest();
        MerchantContext merchantContext = initRequest.getMerchantContext();
        MerchantConstraints merchantConstraints = MerchantConstraints
                .builder()
                .account(this.allowedAccountConstraints)
                .build();
        if (merchantContext != null) {
            merchantContext.setConstraints(merchantConstraints);
        } else {
            merchantContext = MerchantContext
                    .builder()
                    .constraints(merchantConstraints)
                    .build();
        }
        initRequest.setMerchantContext(merchantContext);
        return initRequest;
    }
}
